/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.SqlReturnResultSet;
import org.springframework.jdbc.core.metadata.CallMetaDataProvider;
import org.springframework.jdbc.core.metadata.CallMetaDataProviderFactory;
import org.springframework.jdbc.core.metadata.CallParameterMetaData;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallMetaDataContext {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String procedureName;
    private String catalogName;
    private String schemaName;
    private List<SqlParameter> callParameters = new ArrayList<SqlParameter>();
    private String functionReturnName = "return";
    private Set<String> limitedInParameterNames = new HashSet<String>();
    private List<String> outParameterNames = new ArrayList<String>();
    private boolean accessCallParameterMetaData = true;
    private boolean function;
    private boolean returnValueRequired;
    private CallMetaDataProvider metaDataProvider;

    public void setFunctionReturnName(String functionReturnName) {
        this.functionReturnName = functionReturnName;
    }

    public String getFunctionReturnName() {
        return this.functionReturnName;
    }

    public void setLimitedInParameterNames(Set<String> limitedInParameterNames) {
        this.limitedInParameterNames = limitedInParameterNames;
    }

    public Set<String> getLimitedInParameterNames() {
        return this.limitedInParameterNames;
    }

    public void setOutParameterNames(List<String> outParameterNames) {
        this.outParameterNames = outParameterNames;
    }

    public List<String> getOutParameterNames() {
        return this.outParameterNames;
    }

    public void setProcedureName(String procedureName) {
        this.procedureName = procedureName;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setFunction(boolean function) {
        this.function = function;
    }

    public boolean isFunction() {
        return this.function;
    }

    public void setReturnValueRequired(boolean returnValueRequired) {
        this.returnValueRequired = returnValueRequired;
    }

    public boolean isReturnValueRequired() {
        return this.returnValueRequired;
    }

    public void setAccessCallParameterMetaData(boolean accessCallParameterMetaData) {
        this.accessCallParameterMetaData = accessCallParameterMetaData;
    }

    public boolean isAccessCallParameterMetaData() {
        return this.accessCallParameterMetaData;
    }

    public SqlParameter createReturnResultSetParameter(String parameterName, RowMapper rowMapper) {
        if (this.metaDataProvider.isReturnResultSetSupported()) {
            return new SqlReturnResultSet(parameterName, rowMapper);
        }
        if (this.metaDataProvider.isRefCursorSupported()) {
            return new SqlOutParameter(parameterName, this.metaDataProvider.getRefCursorSqlType(), rowMapper);
        }
        throw new InvalidDataAccessApiUsageException("Return of a ResultSet from a stored procedure is not supported.");
    }

    public String getScalarOutParameterName() {
        if (this.isFunction()) {
            return this.functionReturnName;
        }
        if (this.outParameterNames.size() > 1) {
            this.logger.warn((Object)"Accessing single output value when procedure has more than one output parameter");
        }
        return this.outParameterNames.size() > 0 ? this.outParameterNames.get(0) : null;
    }

    public List<SqlParameter> getCallParameters() {
        return this.callParameters;
    }

    public void initializeMetaData(DataSource dataSource) {
        this.metaDataProvider = CallMetaDataProviderFactory.createMetaDataProvider(dataSource, this);
    }

    public void processParameters(List<SqlParameter> parameters) {
        this.callParameters = this.reconcileParameters(parameters);
    }

    private List<SqlParameter> reconcileParameters(List<SqlParameter> parameters) {
        ArrayList<SqlParameter> declaredReturnParameters = new ArrayList<SqlParameter>();
        LinkedHashMap<String, SqlParameter> declaredParameters = new LinkedHashMap<String, SqlParameter>();
        boolean returnDeclared = false;
        ArrayList<String> outParameterNames = new ArrayList<String>();
        for (SqlParameter parameter : parameters) {
            if (parameter.isResultsParameter()) {
                declaredReturnParameters.add(parameter);
                continue;
            }
            String parameterNameToMatch = this.metaDataProvider.parameterNameToUse(parameter.getName()).toLowerCase();
            declaredParameters.put(parameterNameToMatch, parameter);
            if (!(parameter instanceof SqlOutParameter)) continue;
            outParameterNames.add(parameter.getName());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Added metadata out parameter for: " + parameter.getName()));
            }
            if (!this.isFunction()) continue;
            if (!returnDeclared) {
                this.setFunctionReturnName(parameter.getName());
            }
            returnDeclared = true;
        }
        this.setOutParameterNames(outParameterNames);
        ArrayList<SqlParameter> workParameters = new ArrayList<SqlParameter>();
        workParameters.addAll(declaredReturnParameters);
        if (!this.metaDataProvider.isProcedureColumnMetaDataUsed()) {
            workParameters.addAll(declaredParameters.values());
            return workParameters;
        }
        HashMap<String, String> limitedInParamNamesMap = new HashMap<String, String>(this.limitedInParameterNames.size());
        for (String limitedParameterName : this.limitedInParameterNames) {
            limitedInParamNamesMap.put(this.metaDataProvider.parameterNameToUse(limitedParameterName).toLowerCase(), limitedParameterName);
        }
        for (CallParameterMetaData meta : this.metaDataProvider.getCallParameterMetaData()) {
            String parNameToCheck = null;
            if (meta.getParameterName() != null) {
                parNameToCheck = this.metaDataProvider.parameterNameToUse(meta.getParameterName()).toLowerCase();
            }
            String parNameToUse = this.metaDataProvider.parameterNameToUse(meta.getParameterName());
            if (declaredParameters.containsKey(parNameToCheck) || meta.getParameterType() == 5 && returnDeclared) {
                SqlParameter parameter;
                if (meta.getParameterType() == 5) {
                    parameter = (SqlParameter)declaredParameters.get(this.getFunctionReturnName());
                    if (parameter == null && this.getOutParameterNames().size() > 0) {
                        parameter = (SqlParameter)declaredParameters.get(this.getOutParameterNames().get(0).toLowerCase());
                    }
                    if (parameter == null) {
                        throw new InvalidDataAccessApiUsageException("Unable to locate declared parameter for function return value -  add an SqlOutParameter with name \"" + this.getFunctionReturnName() + "\"");
                    }
                    this.setFunctionReturnName(parameter.getName());
                } else {
                    parameter = (SqlParameter)declaredParameters.get(parNameToCheck);
                }
                if (parameter == null) continue;
                workParameters.add(parameter);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Using declared parameter for: " + (parNameToUse == null ? this.getFunctionReturnName() : parNameToUse)));
                continue;
            }
            if (meta.getParameterType() == 5) {
                if (!this.isFunction() && !this.isReturnValueRequired() && this.metaDataProvider.byPassReturnParameter(meta.getParameterName())) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Bypassing metadata return parameter for: " + meta.getParameterName()));
                    continue;
                }
                String returnNameToUse = meta.getParameterName() == null || meta.getParameterName().length() < 1 ? this.getFunctionReturnName() : parNameToUse;
                workParameters.add(new SqlOutParameter(returnNameToUse, meta.getSqlType()));
                if (this.isFunction()) {
                    outParameterNames.add(returnNameToUse);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added metadata return parameter for: " + returnNameToUse));
                continue;
            }
            if (meta.getParameterType() == 4) {
                workParameters.add(this.metaDataProvider.createDefaultOutParameter(parNameToUse, meta));
                outParameterNames.add(parNameToUse);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added metadata out parameter for: " + parNameToUse));
                continue;
            }
            if (meta.getParameterType() == 2) {
                workParameters.add(this.metaDataProvider.createDefaultInOutParameter(parNameToUse, meta));
                outParameterNames.add(parNameToUse);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added metadata in out parameter for: " + parNameToUse));
                continue;
            }
            if (this.limitedInParameterNames.size() == 0 || limitedInParamNamesMap.containsKey(parNameToUse.toLowerCase())) {
                workParameters.add(this.metaDataProvider.createDefaultInParameter(parNameToUse, meta));
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added metadata in parameter for: " + parNameToUse));
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Limited set of parameters " + limitedInParamNamesMap.keySet() + " skipped parameter for: " + parNameToUse));
        }
        return workParameters;
    }

    public Map<String, Object> matchInParameterValuesWithCallParameters(SqlParameterSource parameterSource) {
        Map caseInsensitiveParameterNames = SqlParameterSourceUtils.extractCaseInsensitiveParameterNames(parameterSource);
        HashMap<String, String> callParameterNames = new HashMap<String, String>(this.callParameters.size());
        HashMap<String, Object> matchedParameters = new HashMap<String, Object>(this.callParameters.size());
        for (SqlParameter parameter : this.callParameters) {
            if (!parameter.isInputValueProvided()) continue;
            String parameterName = parameter.getName();
            String parameterNameToMatch = this.metaDataProvider.parameterNameToUse(parameterName);
            if (parameterNameToMatch != null) {
                callParameterNames.put(parameterNameToMatch.toLowerCase(), parameterName);
            }
            if (parameterName == null) continue;
            if (parameterSource.hasValue(parameterName)) {
                matchedParameters.put(parameterName, SqlParameterSourceUtils.getTypedValue(parameterSource, parameterName));
                continue;
            }
            String lowerCaseName = parameterName.toLowerCase();
            if (parameterSource.hasValue(lowerCaseName)) {
                matchedParameters.put(parameterName, SqlParameterSourceUtils.getTypedValue(parameterSource, lowerCaseName));
                continue;
            }
            String propertyName = JdbcUtils.convertUnderscoreNameToPropertyName(parameterName);
            if (parameterSource.hasValue(propertyName)) {
                matchedParameters.put(parameterName, SqlParameterSourceUtils.getTypedValue(parameterSource, propertyName));
                continue;
            }
            if (caseInsensitiveParameterNames.containsKey(lowerCaseName)) {
                String sourceName = (String)caseInsensitiveParameterNames.get(lowerCaseName);
                matchedParameters.put(parameterName, SqlParameterSourceUtils.getTypedValue(parameterSource, sourceName));
                continue;
            }
            this.logger.warn((Object)("Unable to locate the corresponding parameter value for '" + parameterName + "' within the parameter values provided: " + caseInsensitiveParameterNames.values()));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Matching " + caseInsensitiveParameterNames.values() + " with " + callParameterNames.values()));
            this.logger.debug((Object)("Found match for " + matchedParameters.keySet()));
        }
        return matchedParameters;
    }

    public Map<String, Object> matchInParameterValuesWithCallParameters(Map<String, Object> inParameters) {
        String callParameterName;
        String parameterNameToMatch;
        if (!this.metaDataProvider.isProcedureColumnMetaDataUsed()) {
            return inParameters;
        }
        HashMap<String, String> callParameterNames = new HashMap<String, String>(this.callParameters.size());
        for (SqlParameter parameter : this.callParameters) {
            String parameterName;
            if (!parameter.isInputValueProvided() || (parameterNameToMatch = this.metaDataProvider.parameterNameToUse(parameterName = parameter.getName())) == null) continue;
            callParameterNames.put(parameterNameToMatch.toLowerCase(), parameterName);
        }
        HashMap<String, Object> matchedParameters = new HashMap<String, Object>(inParameters.size());
        for (String parameterName : inParameters.keySet()) {
            parameterNameToMatch = this.metaDataProvider.parameterNameToUse(parameterName);
            callParameterName = (String)callParameterNames.get(parameterNameToMatch.toLowerCase());
            if (callParameterName == null) {
                if (!this.logger.isDebugEnabled()) continue;
                Object value = inParameters.get(parameterName);
                if (value instanceof SqlParameterValue) {
                    value = ((SqlParameterValue)value).getValue();
                }
                if (value == null) continue;
                this.logger.debug((Object)("Unable to locate the corresponding IN or IN-OUT parameter for \"" + parameterName + "\" in the parameters used: " + callParameterNames.keySet()));
                continue;
            }
            matchedParameters.put(callParameterName, inParameters.get(parameterName));
        }
        if (matchedParameters.size() < callParameterNames.size()) {
            for (String parameterName : callParameterNames.keySet()) {
                parameterNameToMatch = this.metaDataProvider.parameterNameToUse(parameterName);
                callParameterName = (String)callParameterNames.get(parameterNameToMatch.toLowerCase());
                if (matchedParameters.containsKey(callParameterName)) continue;
                this.logger.warn((Object)("Unable to locate the corresponding parameter value for '" + parameterName + "' within the parameter values provided: " + inParameters.keySet()));
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Matching " + inParameters.keySet() + " with " + callParameterNames.values()));
            this.logger.debug((Object)("Found match for " + matchedParameters.keySet()));
        }
        return matchedParameters;
    }

    public String createCallString() {
        int callString;
        String procedureNameToUse;
        boolean bl = false;
        String parameterCount = null;
        String catalogNameToUse = null;
        if (this.metaDataProvider.isSupportsSchemasInProcedureCalls() && !this.metaDataProvider.isSupportsCatalogsInProcedureCalls()) {
            catalogNameToUse = this.metaDataProvider.catalogNameToUse(this.getCatalogName());
            parameterCount = this.metaDataProvider.schemaNameToUse(this.getSchemaName());
        } else {
            parameterCount = this.metaDataProvider.catalogNameToUse(this.getCatalogName());
            catalogNameToUse = this.metaDataProvider.schemaNameToUse(this.getSchemaName());
        }
        String schemaNameToUse = this.metaDataProvider.procedureNameToUse(this.getProcedureName());
        if (this.isFunction() || this.isReturnValueRequired()) {
            procedureNameToUse = "{? = call " + (parameterCount != null && parameterCount.length() > 0 ? parameterCount + "." : "") + (catalogNameToUse != null && catalogNameToUse.length() > 0 ? catalogNameToUse + "." : "") + schemaNameToUse + "(";
            callString = -1;
        } else {
            procedureNameToUse = "{call " + (parameterCount != null && parameterCount.length() > 0 ? parameterCount + "." : "") + (catalogNameToUse != null && catalogNameToUse.length() > 0 ? catalogNameToUse + "." : "") + schemaNameToUse + "(";
        }
        for (SqlParameter parameter : this.callParameters) {
            if (parameter.isResultsParameter()) continue;
            if (callString > 0) {
                procedureNameToUse = procedureNameToUse + ", ";
            }
            if (callString >= 0) {
                procedureNameToUse = procedureNameToUse + "?";
            }
            ++callString;
        }
        procedureNameToUse = procedureNameToUse + ")}";
        return procedureNameToUse;
    }
}

