/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.Area;
import org.jrobin.graph.Cdef;
import org.jrobin.graph.Comment;
import org.jrobin.graph.CustomArea;
import org.jrobin.graph.CustomLine;
import org.jrobin.graph.Gprint;
import org.jrobin.graph.GridRange;
import org.jrobin.graph.Legend;
import org.jrobin.graph.Line;
import org.jrobin.graph.PlotDef;
import org.jrobin.graph.RrdExportDef;
import org.jrobin.graph.Stack;
import org.jrobin.graph.TimeAxisLabel;
import org.jrobin.graph.TimeAxisUnit;
import org.jrobin.graph.TimeText;
import org.jrobin.graph.Title;
import org.jrobin.graph.ValueAxisUnit;

public class RrdGraphDef
extends RrdExportDef
implements Serializable {
    private Title title = null;
    private String valueAxisLabel = null;
    private TimeAxisLabel timeAxisLabel = null;
    private boolean lazyGeneration = false;
    private boolean gridX = true;
    private boolean gridY = true;
    private boolean minorGridX = true;
    private boolean minorGridY = true;
    private boolean majorGridX = true;
    private boolean majorGridY = true;
    private boolean frontGrid = true;
    private boolean antiAliasing = true;
    private boolean showLegend = true;
    private boolean drawSignature = true;
    private Color backColor = new Color(245, 245, 245);
    private Color canvasColor = Color.WHITE;
    private Color borderColor = Color.LIGHT_GRAY;
    private Color normalFontColor = Color.BLACK;
    private Color titleFontColor = Color.BLACK;
    private Color majorGridColor = new Color(130, 30, 30);
    private Color minorGridColor = new Color(140, 140, 140);
    private Color axisColor = new Color(130, 30, 30);
    private Color arrowColor = Color.RED;
    private Color frameColor = Color.LIGHT_GRAY;
    private Font titleFont = null;
    private Font normalFont = null;
    private File background = null;
    private File overlay = null;
    private int chart_lpadding = 50;
    private int firstDayOfWeek = 2;
    private double baseValue = 1000.0;
    private int scaleIndex = -1;
    private BasicStroke borderStroke = null;
    private TimeAxisUnit tAxis = null;
    private ValueAxisUnit vAxis = null;
    private GridRange gridRange = null;
    private int commentLines = 0;
    private int commentLineShift = 0;
    private ArrayList plotDefs = new ArrayList(10);
    private ArrayList comments = new ArrayList(10);

    public RrdGraphDef() {
    }

    public RrdGraphDef(long l, long l2) throws RrdException {
        this.setTimePeriod(l, l2);
    }

    public RrdGraphDef(Date date, Date date2) throws RrdException {
        this.setTimePeriod(date, date2);
    }

    public RrdGraphDef(GregorianCalendar gregorianCalendar, GregorianCalendar gregorianCalendar2) throws RrdException {
        this.setTimePeriod(gregorianCalendar, gregorianCalendar2);
    }

    public void setLazy(boolean bl) {
        this.lazyGeneration = bl;
    }

    public void setTitle(String string) throws RrdException {
        this.title = new Title(string);
    }

    public void setVerticalLabel(String string) {
        this.valueAxisLabel = string;
    }

    public void setTimeAxisLabel(String string) throws RrdException {
        if (string != null) {
            this.timeAxisLabel = new TimeAxisLabel(string);
            this.commentLines += this.timeAxisLabel.getLineCount();
            this.commentLineShift = this.timeAxisLabel.isCompleteLine() ? 0 : 1;
            this.comments.add(0, this.timeAxisLabel);
        }
    }

    public void setBackColor(Color color) {
        this.backColor = color;
    }

    public void setCanvasColor(Color color) {
        this.canvasColor = color;
    }

    public void setImageBorder(Color color, int n) {
        this.borderStroke = new BasicStroke(n);
        if (color != null) {
            this.borderColor = color;
        }
    }

    public void setTitleFontColor(Color color) {
        this.titleFontColor = color;
    }

    public void setDefaultFontColor(Color color) {
        this.normalFontColor = color;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public void setDefaultFont(Font font) {
        this.normalFont = font;
    }

    public void setMajorGridColor(Color color) {
        this.majorGridColor = color;
    }

    public void setMinorGridColor(Color color) {
        this.minorGridColor = color;
    }

    public void setFrameColor(Color color) {
        this.frameColor = color;
    }

    public void setAxisColor(Color color) {
        this.axisColor = color;
    }

    public void setArrowColor(Color color) {
        this.arrowColor = color;
    }

    public void setMinorGridX(boolean bl) {
        this.minorGridX = bl;
    }

    public void setMinorGridY(boolean bl) {
        this.minorGridY = bl;
    }

    public void setMajorGridX(boolean bl) {
        this.majorGridX = bl;
    }

    public void setMajorGridY(boolean bl) {
        this.majorGridY = bl;
    }

    public void setGridX(boolean bl) {
        this.gridX = bl;
    }

    public void setGridY(boolean bl) {
        this.gridY = bl;
    }

    public void setFrontGrid(boolean bl) {
        this.frontGrid = bl;
    }

    public void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }

    public void setShowSignature(boolean bl) {
        this.drawSignature = bl;
    }

    public void setAntiAliasing(boolean bl) {
        this.antiAliasing = bl;
    }

    public void setChartLeftPadding(int n) {
        this.chart_lpadding = n;
    }

    public void setBackground(String string) {
        File file = new File(string);
        if (file.exists()) {
            this.background = file;
        }
    }

    public void setOverlay(String string) {
        File file = new File(string);
        if (file.exists()) {
            this.overlay = file;
        }
    }

    public void setBaseValue(double d) {
        this.baseValue = d;
    }

    public void setUnitsExponent(int n) {
        this.scaleIndex = 6 - n / 3;
    }

    int getUnitsExponent() {
        return (6 - this.scaleIndex) * 3;
    }

    public void setGridRange(double d, double d2, boolean bl) {
        this.gridRange = new GridRange(d, d2, bl);
    }

    public void setLowerLimit(double d) {
        this.gridRange = new GridRange(d, Double.NaN, false);
    }

    public void setValueAxis(double d, double d2) {
        this.vAxis = new ValueAxisUnit(d, d2);
    }

    public void setTimeAxis(int n, int n2, int n3, int n4, String string, boolean bl) {
        this.tAxis = new TimeAxisUnit(n, n2, n3, n4, new SimpleDateFormat(string), bl, this.firstDayOfWeek);
    }

    public void setFirstDayOfWeek(int n) {
        this.firstDayOfWeek = n;
    }

    public void line(String string, Color color, String string2) throws RrdException {
        this.plotDefs.add(new Line(string, color));
        this.addLegend(string2, color);
    }

    public void line(String string, Color color, String string2, int n) throws RrdException {
        this.plotDefs.add(new Line(string, color, n));
        this.addLegend(string2, color);
    }

    public void line(GregorianCalendar gregorianCalendar, double d, GregorianCalendar gregorianCalendar2, double d2, Color color, String string, int n) throws RrdException {
        this.plotDefs.add(new CustomLine(gregorianCalendar.getTimeInMillis() / 1000L, d, gregorianCalendar2.getTimeInMillis() / 1000L, d2, color, n));
        this.addLegend(string, color);
    }

    public void area(String string, Color color, String string2) throws RrdException {
        this.plotDefs.add(new Area(string, color));
        this.addLegend(string2, color);
    }

    public void area(GregorianCalendar gregorianCalendar, double d, GregorianCalendar gregorianCalendar2, double d2, Color color, String string) throws RrdException {
        this.plotDefs.add(new CustomArea(gregorianCalendar.getTimeInMillis() / 1000L, d, gregorianCalendar2.getTimeInMillis() / 1000L, d2, color));
        this.addLegend(string, color);
    }

    public void stack(String string, Color color, String string2) throws RrdException {
        this.plotDefs.add(new Stack(string, color));
        this.addLegend(string2, color);
    }

    public void hrule(double d, Color color, String string) throws RrdException {
        this.plotDefs.add(new CustomLine(Long.MIN_VALUE, d, Long.MAX_VALUE, d, color));
        this.addLegend(string, color);
    }

    public void hrule(double d, Color color, String string, int n) throws RrdException {
        this.plotDefs.add(new CustomLine(Long.MIN_VALUE, d, Long.MAX_VALUE, d, color, n));
        this.addLegend(string, color);
    }

    public void vrule(GregorianCalendar gregorianCalendar, Color color, String string) throws RrdException {
        long l = gregorianCalendar.getTimeInMillis() / 1000L;
        this.plotDefs.add(new CustomLine(l, Double.MIN_VALUE, l, Double.MAX_VALUE, color));
        this.addLegend(string, color);
    }

    public void vrule(GregorianCalendar gregorianCalendar, Color color, String string, int n) throws RrdException {
        long l = gregorianCalendar.getTimeInMillis() / 1000L;
        this.plotDefs.add(new CustomLine(l, Double.MIN_VALUE, l, Double.MAX_VALUE, color, n));
        this.addLegend(string, color);
    }

    public void comment(String string) throws RrdException {
        this.addComment(new Comment(string));
    }

    public void time(String string, String string2) throws RrdException {
        this.addComment(new TimeText(string, string2));
    }

    public void time(String string, DateFormat dateFormat) throws RrdException {
        this.addComment(new TimeText(string, dateFormat));
    }

    public void time(String string, String string2, long l) throws RrdException {
        this.addComment(new TimeText(string, string2, l));
    }

    public void time(String string, DateFormat dateFormat, long l) throws RrdException {
        this.addComment(new TimeText(string, dateFormat, l));
    }

    public void time(String string, String string2, Date date) throws RrdException {
        this.addComment(new TimeText(string, string2, date));
    }

    public void time(String string, DateFormat dateFormat, Date date) throws RrdException {
        this.addComment(new TimeText(string, dateFormat, date));
    }

    public void time(String string, String string2, Calendar calendar) throws RrdException {
        this.addComment(new TimeText(string, string2, calendar));
    }

    public void time(String string, DateFormat dateFormat, Calendar calendar) throws RrdException {
        this.addComment(new TimeText(string, dateFormat, calendar));
    }

    public void gprint(String string, String string2, String string3) throws RrdException {
        this.addComment(new Gprint(string, string2, string3));
    }

    public void gprint(String string, String string2, String string3, double d) throws RrdException {
        this.addComment(new Gprint(string, string2, string3, d));
    }

    public void exportXmlTemplate(OutputStream outputStream) {
        Object object;
        int n;
        XmlWriter xmlWriter = new XmlWriter(outputStream);
        xmlWriter.startTag("rrd_graph_def");
        xmlWriter.startTag("span");
        xmlWriter.writeTag("start", this.getStartTime());
        xmlWriter.writeTag("end", this.getEndTime());
        xmlWriter.closeTag();
        xmlWriter.startTag("options");
        xmlWriter.writeTag("anti_aliasing", this.antiAliasing);
        xmlWriter.writeTag("arrow_color", this.arrowColor);
        xmlWriter.writeTag("axis_color", this.axisColor);
        xmlWriter.writeTag("back_color", this.backColor);
        if (this.background != null) {
            xmlWriter.writeTag("background", this.background);
        }
        xmlWriter.writeTag("base_value", this.baseValue);
        xmlWriter.writeTag("canvas", this.canvasColor);
        xmlWriter.writeTag("left_padding", this.chart_lpadding);
        if (this.normalFont != null) {
            xmlWriter.writeTag("default_font", this.normalFont);
        }
        xmlWriter.writeTag("default_font_color", this.normalFontColor);
        xmlWriter.writeTag("frame_color", this.frameColor);
        xmlWriter.writeTag("front_grid", this.frontGrid);
        if (this.gridRange != null) {
            this.gridRange.exportXmlTemplate(xmlWriter);
        }
        xmlWriter.writeTag("grid_x", this.gridX);
        xmlWriter.writeTag("grid_y", this.gridY);
        if (this.borderStroke != null) {
            xmlWriter.startTag("border");
            xmlWriter.writeTag("color", this.borderColor);
            xmlWriter.writeTag("width", (int)this.borderStroke.getLineWidth());
            xmlWriter.closeTag();
        }
        xmlWriter.writeTag("major_grid_color", this.majorGridColor);
        xmlWriter.writeTag("major_grid_x", this.majorGridX);
        xmlWriter.writeTag("major_grid_y", this.majorGridY);
        xmlWriter.writeTag("minor_grid_color", this.minorGridColor);
        xmlWriter.writeTag("minor_grid_x", this.minorGridX);
        xmlWriter.writeTag("minor_grid_y", this.minorGridY);
        if (this.overlay != null) {
            xmlWriter.writeTag("overlay", this.overlay);
        }
        xmlWriter.writeTag("show_legend", this.showLegend);
        xmlWriter.writeTag("show_signature", this.drawSignature);
        if (this.tAxis != null) {
            this.tAxis.exportXmlTemplate(xmlWriter);
        }
        if (this.timeAxisLabel != null) {
            this.timeAxisLabel.exportXmlTemplate(xmlWriter);
        }
        if (this.title != null) {
            this.title.exportXmlTemplate(xmlWriter);
        }
        if (this.titleFont != null) {
            xmlWriter.writeTag("title_font", this.titleFont);
        }
        xmlWriter.writeTag("title_font_color", this.titleFontColor);
        if (this.scaleIndex != -1) {
            xmlWriter.writeTag("units_exponent", this.getUnitsExponent());
        }
        if (this.vAxis != null) {
            this.vAxis.exportXmlTemplate(xmlWriter);
        }
        if (this.valueAxisLabel != null) {
            xmlWriter.writeTag("vertical_label", this.valueAxisLabel);
        }
        xmlWriter.closeTag();
        xmlWriter.startTag("datasources");
        for (n = 0; n < this.fetchSources.size(); ++n) {
            this.fetchSources.get(n).exportXml(xmlWriter);
        }
        for (n = 0; n < this.cdefList.size(); ++n) {
            object = (Cdef)this.cdefList.get(n);
            ((Cdef)object).exportXml(xmlWriter);
        }
        xmlWriter.closeTag();
        xmlWriter.startTag("graph");
        for (n = 0; n < this.comments.size(); ++n) {
            object = (Comment)this.comments.get(n);
            if (((Comment)object).commentType == 1 || ((Comment)object).commentType == 3) {
                PlotDef plotDef = (PlotDef)this.plotDefs.get(((Legend)object).getPlofDefIndex());
                plotDef.exportXmlTemplate(xmlWriter, ((Comment)object).text);
                continue;
            }
            if (object instanceof TimeAxisLabel) continue;
            ((Comment)object).exportXmlTemplate(xmlWriter);
        }
        xmlWriter.closeTag();
        xmlWriter.closeTag();
        xmlWriter.flush();
    }

    protected boolean isLazy() {
        return this.lazyGeneration;
    }

    protected Title getTitle() {
        return this.title;
    }

    protected String getVerticalLabel() {
        return this.valueAxisLabel;
    }

    protected Color getBackColor() {
        return this.backColor;
    }

    protected Color getCanvasColor() {
        return this.canvasColor;
    }

    protected Color getImageBorderColor() {
        return this.borderColor;
    }

    protected BasicStroke getImageBorderStroke() {
        return this.borderStroke;
    }

    protected Color getTitleFontColor() {
        return this.titleFontColor;
    }

    protected Color getDefaultFontColor() {
        return this.normalFontColor;
    }

    protected Font getTitleFont() {
        return this.titleFont;
    }

    protected Font getDefaultFont() {
        return this.normalFont;
    }

    protected Color getMajorGridColor() {
        return this.majorGridColor;
    }

    protected Color getMinorGridColor() {
        return this.minorGridColor;
    }

    protected Color getFrameColor() {
        return this.frameColor;
    }

    protected Color getAxisColor() {
        return this.axisColor;
    }

    protected Color getArrowColor() {
        return this.arrowColor;
    }

    protected Color getBorderColor() {
        return this.borderColor;
    }

    protected BasicStroke getBorderStroke() {
        return this.borderStroke;
    }

    protected boolean showMinorGridX() {
        return this.minorGridX;
    }

    protected boolean showMinorGridY() {
        return this.minorGridY;
    }

    protected boolean showMajorGridX() {
        return this.majorGridX;
    }

    protected boolean showMajorGridY() {
        return this.majorGridY;
    }

    protected boolean showGridX() {
        return this.gridX;
    }

    protected boolean showGridY() {
        return this.gridY;
    }

    protected boolean drawFrontGrid() {
        return this.frontGrid;
    }

    protected boolean showLegend() {
        return this.showLegend;
    }

    protected boolean showSignature() {
        return this.drawSignature;
    }

    protected boolean isFrontGrid() {
        return this.frontGrid;
    }

    protected boolean useAntiAliasing() {
        return this.antiAliasing;
    }

    protected int getChartLeftPadding() {
        return this.chart_lpadding;
    }

    protected File getBackground() {
        return this.background;
    }

    protected File getOverlay() {
        return this.overlay;
    }

    protected double getBaseValue() {
        return this.baseValue;
    }

    protected int getScaleIndex() {
        return this.scaleIndex;
    }

    protected GridRange getGridRange() {
        return this.gridRange;
    }

    protected ValueAxisUnit getValueAxis() {
        return this.vAxis;
    }

    protected TimeAxisUnit getTimeAxis() {
        return this.tAxis;
    }

    protected int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    protected PlotDef[] getPlotDefs() {
        return this.plotDefs.toArray(new PlotDef[0]);
    }

    protected Comment[] getComments() {
        return this.comments.toArray(new Comment[0]);
    }

    protected int getCommentLineCount() {
        return this.comments.size() > 0 ? this.commentLines + this.commentLineShift : 0;
    }

    private void addComment(Comment comment) {
        this.commentLines += comment.getLineCount();
        this.commentLineShift = comment.isCompleteLine() ? 0 : 1;
        this.comments.add(comment);
    }

    private void addLegend(String string, Color color) throws RrdException {
        this.addComment(new Legend(string, color, this.plotDefs.size() - 1));
    }
}

