/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

class ChartGraphics {
    private Graphics2D g;
    private int width;
    private int height;
    private long xStart;
    private long xEnd;
    private double yStart;
    private double yEnd;
    private double widthDelta = 1.0;
    private double heightDelta = 3.0;

    ChartGraphics(Graphics2D graphics2D) {
        this.g = graphics2D;
    }

    void drawLine(int n, int n2, int n3, int n4) {
        this.g.drawLine(n, -n2, n3, -n4);
    }

    void fillRect(int n, int n2, int n3, int n4) {
        this.g.fillRect(n, -n4, n3 - n, -(n4 - n2));
    }

    void setColor(Color color) {
        this.g.setColor(color);
    }

    void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    void setXRange(long l, long l2) {
        this.xStart = l;
        this.xEnd = l2;
        this.widthDelta = this.xEnd != this.xStart ? (double)this.width * 1.0 / ((double)(this.xEnd - this.xStart) * 1.0) : 1.0;
    }

    void setYRange(double d, double d2) {
        this.yStart = d;
        this.yEnd = d2;
        this.heightDelta = this.yEnd != this.yStart ? (double)this.height * 1.0 / ((this.yEnd - this.yStart) * 1.0) : 1.0;
        this.yStart = this.yStart < 0.0 ? 0.0 : Math.abs(this.yStart);
    }

    int getX(long l) {
        return (int)((double)(l - this.xStart) * this.widthDelta);
    }

    int getY(double d) {
        if (Double.isNaN(d)) {
            return Integer.MIN_VALUE;
        }
        return (int)((d - this.yStart) * this.heightDelta);
    }

    double getInverseY(int n) {
        if (n == Integer.MIN_VALUE) {
            return Double.NaN;
        }
        return (double)n * 1.0 / this.heightDelta + this.yStart;
    }

    void setStroke(Stroke stroke) {
        this.g.setStroke(stroke);
    }

    int getMinX() {
        return 0;
    }

    int getMaxX() {
        return 0 + this.width;
    }

    int getMinY() {
        return 0;
    }

    int getMaxY() {
        return 0 + this.height;
    }

    Graphics2D getGraphics() {
        return this.g;
    }
}

