/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.util.Vector;
import snmp.SNMPBadValueException;
import snmp.SNMPInteger;
import snmp.SNMPObject;
import snmp.SNMPOctetString;
import snmp.SNMPPDU;
import snmp.SNMPSequence;
import snmp.SNMPTrapPDU;

public class SNMPMessage
extends SNMPSequence {
    public SNMPMessage(int n, String string, SNMPPDU sNMPPDU) {
        Vector<SNMPObject> vector = new Vector<SNMPObject>();
        vector.insertElementAt(new SNMPInteger(n), 0);
        vector.insertElementAt(new SNMPOctetString(string), 1);
        vector.insertElementAt(sNMPPDU, 2);
        try {
            this.setValue(vector);
        }
        catch (SNMPBadValueException sNMPBadValueException) {
            // empty catch block
        }
    }

    public SNMPMessage(int n, String string, SNMPTrapPDU sNMPTrapPDU) {
        Vector<SNMPObject> vector = new Vector<SNMPObject>();
        vector.insertElementAt(new SNMPInteger(n), 0);
        vector.insertElementAt(new SNMPOctetString(string), 1);
        vector.insertElementAt(sNMPTrapPDU, 2);
        try {
            this.setValue(vector);
        }
        catch (SNMPBadValueException sNMPBadValueException) {
            // empty catch block
        }
    }

    protected SNMPMessage(byte[] byArray) throws SNMPBadValueException {
        super(byArray);
    }

    public SNMPPDU getPDU() throws SNMPBadValueException {
        Vector vector = (Vector)this.getValue();
        Object e = vector.elementAt(2);
        if (!(e instanceof SNMPPDU)) {
            throw new SNMPBadValueException("Wrong PDU type in message: expected SNMPPDU, have " + e.getClass().toString());
        }
        return (SNMPPDU)e;
    }

    public SNMPTrapPDU getTrapPDU() throws SNMPBadValueException {
        Vector vector = (Vector)this.getValue();
        Object e = vector.elementAt(2);
        if (!(e instanceof SNMPTrapPDU)) {
            throw new SNMPBadValueException("Wrong PDU type in message: expected SNMPTrapPDU, have " + e.getClass().toString());
        }
        return (SNMPTrapPDU)e;
    }

    public String getCommunityName() throws SNMPBadValueException {
        Vector vector = (Vector)this.getValue();
        Object e = vector.elementAt(1);
        if (!(e instanceof SNMPOctetString)) {
            throw new SNMPBadValueException("Wrong SNMP type for community name in message: expected SNMPOctetString, have " + e.getClass().toString());
        }
        return ((SNMPOctetString)e).toString();
    }
}

