/*****************************************************************************
 * logger.h
 * Header file for logger.c
 *****************************************************************************
 * Copyright (C) 1998, 1999, 2000, 2001 VideoLAN
 * $Id: logger.h,v 1.10 2001/04/29 03:41:49 nitrox Exp $
 *
 * Authors: Damien Lucas <nitrox@via.ecp.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#ifndef __LOGGER_H__
#define __LOGGER_H__

/* Methods for logger */
#define LOG_NONE 0
#define LOG_FILE_ONLY 1
#define LOG_SCREEN_ONLY 2
#define LOG_BOTH 3

#define LOGBUFF_MAXSIZE 120

char * VS_log_errstr(ERR_CODE err);

void VS_log(LOG_LEVELS level, LOG_MODULES module, char * format, ...);

int LOG_init(char * sLogName, unsigned char ucM);
int LOG_change(char * sLogName, unsigned char ucM);
#endif
