/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Checkbox;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import rene.gui.ButtonAction;
import rene.gui.IconBar;
import rene.gui.MyLabel;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.objects.FunctionObject;

class CurveEditDialog
extends ObjectEditDialog {
    TextField VarMin;
    TextField VarMax;
    TextField DVar;
    TextField Var;
    TextField EX;
    TextField EY;
    IconBar IC;
    IconBar TypeIB;
    ZirkelCanvas ZC;
    Checkbox Special;
    public String xaxis_variable;
    public String yaxis_variable;

    public CurveEditDialog(ZirkelCanvas zirkelCanvas, FunctionObject functionObject) {
        super(zirkelCanvas.getFrame(), Zirkel.name("edit.function.title"), functionObject, "function");
        this.ZC = zirkelCanvas;
    }

    public void addFirst(Panel panel) {
        FunctionObject functionObject = (FunctionObject)this.O;
        this.VarMin = new TextFieldAction(this, "varmin", "" + functionObject.VarMin, 30);
        panel.add(new MyLabel(Zirkel.name("function.varmin")));
        panel.add(this.VarMin);
        this.VarMax = new TextFieldAction(this, "varmax", "" + functionObject.VarMax, 30);
        panel.add(new MyLabel(Zirkel.name("function.varmax")));
        panel.add(this.VarMax);
        this.DVar = new TextFieldAction(this, "dvar", "" + functionObject.DVar, 30);
        panel.add(new MyLabel(Zirkel.name("function.dvar")));
        panel.add(this.DVar);
        this.Var = new TextFieldAction(this, "var", "" + functionObject.getVar(), 30);
        panel.add(new MyLabel(Zirkel.name("function.var")));
        panel.add(this.Var);
        String string = functionObject.getEX();
        if (string.equals(functionObject.Var)) {
            string = "";
        }
        this.EX = new TextFieldAction(this, "ex", "" + string, 30);
        panel.add(new MyLabel(Zirkel.name("function.x")));
        panel.add(this.EX);
        this.EY = new TextFieldAction(this, "ey", "" + functionObject.getEY(), 30);
        panel.add(new MyLabel(Zirkel.name("function.y")));
        panel.add(this.EY);
    }

    public void addSecond(Panel panel) {
        FunctionObject functionObject = (FunctionObject)this.O;
        this.IC = new IconBar(this.F);
        this.IC.setIconBarListener(this);
        this.IC.addOnOffLeft("filled");
        this.IC.setState("filled", functionObject.isFilled());
        this.IC.setIconBarListener(this);
        panel.add(new MyLabel(""));
        panel.add(this.IC);
        this.TypeIB = new IconBar(this.F);
        this.TypeIB.addToggleGroupLeft("type", 6);
        this.TypeIB.toggle("type", functionObject.getType());
        panel.add(new MyLabel(""));
        panel.add(this.TypeIB);
        panel.add(new MyLabel(Zirkel.name("edit.discrete")));
        this.Special = new Checkbox();
        panel.add(this.Special);
        this.Special.setState(functionObject.isSpecial());
    }

    public void addButton(Panel panel) {
        FunctionObject functionObject = (FunctionObject)this.O;
        if (!functionObject.Var.equals(functionObject.EX)) {
            if (functionObject.Center == null) {
                panel.add(new ButtonAction(this, Zirkel.name("edit.function.center"), "SetCenter"));
            } else {
                panel.add(new ButtonAction(this, Zirkel.name("edit.function.free"), "SetFree"));
            }
            panel.add(new MyLabel(" "));
        }
    }

    public void iconPressed(String string) {
        if (string.equals("filled")) {
            if (this.IC.getState("filled")) {
                this.IB.setState("isback", true);
                this.ThicknessIB.setEnabled("solid", true);
            } else {
                this.IB.setState("isback", false);
                this.ThicknessIB.setState("solid", false);
                this.ThicknessIB.setEnabled("solid", false);
            }
        }
        super.iconPressed(string);
    }

    public void setAction() {
        FunctionObject functionObject = (FunctionObject)this.O;
        functionObject.setExpressions(this.Var.getText(), this.EX.getText(), this.EY.getText());
        functionObject.setRange(this.VarMin.getText(), this.VarMax.getText(), this.DVar.getText());
        functionObject.setFilled(this.IC.getState("filled"));
        functionObject.setType(this.TypeIB.getToggleState("type"));
        functionObject.setSpecial(this.Special.getState());
    }

    public void doAction(String string) {
        if (string.equals("SetCenter")) {
            this.ZC.setCurveCenter((FunctionObject)this.O);
            super.doAction("OK");
        } else if (string.equals("SetFree")) {
            ((FunctionObject)this.O).Center = null;
            super.doAction("OK");
        } else {
            super.doAction(string);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.VarMin.requestFocus();
    }
}

