#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:27:18 
# conf/unconfig-pam_samba.sh

### I N C L U D E
. ./_include.sh

### P A R A M S
if [ "$1" == "-f" ];then
	MYDIR="$2"
	shift
	shift
else
	MYDIR="${PAMDIR}"
fi
#echo "dir=${MYDIR}"

### M O D I F I E D   F I L E S ...
# those specified by ${MYDIR}/samba
pamsamba=/etc/pam.d/samba

### ... W I T H   A C C E S S
INST_UID=root
INST_GID=root
INST_PAM_MOD=644

### F O R M A T S
case ${DISTRIBUTION} in
	Redhat|Fedora)
		libpath="\/lib\/security\/\$ISA\/"
		sysauthmatcher="^%SERVICE%[[:space:]]*required[[:space:]]*pam_stack.so[[:space:]]*service=system-auth.*$"; \
		;;
	Mandriva|Debian|Ubuntu|Suse)
		libpath=
		sysauthmatcher="^@include[[:space:]]*common-%SERVICE%.*$"; \
		;;
	*)
		echo "Unsupported distribution" >&2
		exit 1
		;;
esac

### S T A R T

function pam_toggle()
{
awk ' \
	{ \
		if (match($0,"^# sadms remove begin")) \
			remove=1; \
		if (match($0,"^# sadms remove end")) \
			remove=0; \
		if (match($0,"^# sadms add begin")) \
			add=1; \
		if (match($0,"^# sadms add end")) \
			add=0; \
		if (match($0,"^# sadms")) \
		{ \
		} \
		else if (add==0 && remove==0) \
			print $0; \
		else if(remove) \
			print substr($0,2); \
	} \
' "restore=${restore}" -
}

# remove sadms additions
cat ${pamsamba} | pam_toggle > ${TMPDIR}/samba
#cat ${TMPDIR}/samba

# install
echo "install modified samba to ${MYDIR}"
${INSTALL} -o ${INST_UID} -g ${INST_GID} -m ${INST_PAM_MOD} ${TMPDIR}/samba ${MYDIR} > /dev/null

# cleanup temporary
rm -f ${TMPDIR}/samba
