// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2023 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Security.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.security {

  public class RoleAccessControl : ICloneable {
    public object Clone() {
      RoleAccessControl copy = new RoleAccessControl();
      copy.enabled = this.enabled;
      copy.defaultPolicy = this.defaultPolicy;
      copy.rules = this.rules;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["enabled"] = this.enabled;
      json["defaultPolicy"] = (int)this.defaultPolicy;
      json["rules"] = new JsonArray(this.rules.Select(
        _value => (JsonValue)(_value.Encode())));
      return json;
    }

    public static RoleAccessControl Decode(LightJson.JsonObject json, Agent agent) {
      RoleAccessControl inst = new RoleAccessControl();
      inst.enabled = (bool)json["enabled"];
      inst.defaultPolicy = (Com.Raritan.Idl.security.RoleAccessPolicy)(int)json["defaultPolicy"];
      inst.rules = new System.Collections.Generic.List<Com.Raritan.Idl.security.RoleAccessRule>(json["rules"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.security.RoleAccessRule.Decode(_value, agent)));
      return inst;
    }

    public bool enabled = false;
    public Com.Raritan.Idl.security.RoleAccessPolicy defaultPolicy = Com.Raritan.Idl.security.RoleAccessPolicy.ALLOW;
    public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.security.RoleAccessRule> rules = new System.Collections.Generic.List<Com.Raritan.Idl.security.RoleAccessRule>();
  }
}
