// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2023 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Firmware.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.firmware {

  public class ImageStatus : ICloneable {
    public object Clone() {
      ImageStatus copy = new ImageStatus();
      copy.state = this.state;
      copy.error_message = this.error_message;
      copy.time_started = this.time_started;
      copy.size_total = this.size_total;
      copy.size_done = this.size_done;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["state"] = (int)this.state;
      json["error_message"] = this.error_message;
      json["time_started"] = (this.time_started.ToUniversalTime().Ticks - new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks) / System.TimeSpan.TicksPerSecond;
      json["size_total"] = this.size_total;
      json["size_done"] = this.size_done;
      return json;
    }

    public static ImageStatus Decode(LightJson.JsonObject json, Agent agent) {
      ImageStatus inst = new ImageStatus();
      inst.state = (Com.Raritan.Idl.firmware.ImageState)(int)json["state"];
      inst.error_message = (string)json["error_message"];
      inst.time_started = new System.DateTime(json["time_started"] * System.TimeSpan.TicksPerSecond + new System.DateTime(1970, 1, 1, 0, 0, 0, 0, System.DateTimeKind.Utc).Ticks, System.DateTimeKind.Utc).ToLocalTime();
      inst.size_total = (int)json["size_total"];
      inst.size_done = (int)json["size_done"];
      return inst;
    }

    public Com.Raritan.Idl.firmware.ImageState state = Com.Raritan.Idl.firmware.ImageState.NONE;
    public string error_message = "";
    public System.DateTime time_started = new System.DateTime(0);
    public int size_total = 0;
    public int size_done = 0;
  }
}
