% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{components.marginaleffects}
\alias{components.marginaleffects}
\title{Extract components from marginaleffects objects}
\usage{
\method{components}{marginaleffects}(object, component = NULL, ...)
}
\arguments{
\item{object}{A marginaleffects object (predictions, comparisons, slopes, or hypotheses)}

\item{component}{Character string specifying which component to extract. Must be a valid
slot name from the internal S4 object. If \code{NULL} (the default), \code{components()} prints a message with
all available component names. Common components include: "model", "newdata",
"modeldata", "call", "jacobian", "vcov_model", "type", "by", "comparison", "variables", etc.}

\item{...}{Ignored.}
}
\value{
The requested component from the mfx object
}
\description{
Extract components from marginaleffects objects
}
\details{
This function provides access to the internal components stored in the \code{mfx}
attribute of marginaleffects objects. The \code{mfx} attribute contains an S4 object of
class "marginaleffects_internal" with various slots containing model information,
data, and computational details used by the marginaleffects functions.

Warning: the internal slot names are not considered part of the public API and may change
without warning in future versions of the marginaleffects package.
}
