% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-functions.R
\name{importImzMl}
\alias{importImzMl}
\title{Import imzML files}
\usage{
importImzMl(path, coordinates = NULL, ...)
}
\arguments{
\item{path}{\code{character}, path to directory or file which should be read
in.}

\item{coordinates}{\code{matrix}, 2 column matrix that contains the x- and
y-coordinates for spectra that should be imported. Other spectra would be
ignored.}

\item{\ldots}{arguments to be passed to
\code{\link[MALDIquantForeign]{import}}.}
}
\value{
a \code{list} of \code{\link[MALDIquant]{MassSpectrum-class}} or
\code{\link[MALDIquant]{MassPeaks-class}} objects (depending on the
\code{centroided} argument).
}
\description{
This function imports files in imzML file format
into \code{\link[MALDIquant]{MassSpectrum-class}} or
\code{\link[MALDIquant]{MassPeaks-class}} objects.
}
\examples{

library("MALDIquant")
library("MALDIquantForeign")

## get example directory
exampleDirectory <- system.file("exampledata", package="MALDIquantForeign")

## import
s <- importImzMl(file.path(exampleDirectory, "tiny_continuous.imzML"))

## import only spectra for pixel 1,1 and 2,1
s <- importImzMl(file.path(exampleDirectory, "tiny_continuous.imzML"),
                 coordinates = cbind(1:2, c(1, 1)))

}
\references{
\url{http://strimmerlab.org/software/maldiquant/}, \cr
Definition of \code{imzML} format:
\url{http://www.imzml.org/}
}
\seealso{
\code{\link[MALDIquant]{MassSpectrum-class}},
\code{\link[MALDIquant]{MassPeaks-class}}
}
\author{
Sebastian Gibb
}
