% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-summarise.R
\name{summarise.tbl_lazy}
\alias{summarise.tbl_lazy}
\title{Summarise each group to one row}
\usage{
\method{summarise}{tbl_lazy}(.data, ..., .by = NULL, .groups = NULL)
}
\arguments{
\item{.data}{A lazy data frame backed by a database query.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variables, or
functions of variables. Use \code{\link[dplyr:desc]{desc()}} to sort a variable in descending
order.}

\item{.by}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}

\item{.groups}{\Sexpr[results=rd]{lifecycle::badge("experimental")} Grouping structure of the result.
\itemize{
\item "drop_last": dropping the last level of grouping. This was the
only supported option before version 1.0.0.
\item "drop": All levels of grouping are dropped.
\item "keep": Same grouping structure as \code{.data}.
}

When \code{.groups} is not specified, it defaults to "drop_last".

In addition, a message informs you of that choice, unless the result is ungrouped,
the option "dplyr.summarise.inform" is set to \code{FALSE},
or when \code{summarise()} is called from a function in a package.}
}
\value{
Another \code{tbl_lazy}. Use \code{\link[dplyr:explain]{dplyr::show_query()}} to see the generated
query, and use \code{\link[=collect.tbl_sql]{collect()}} to execute the query
and return data to R.
}
\description{
This is a method for the dplyr \code{\link[dplyr:summarise]{dplyr::summarise()}} generic. It generates the
\code{SELECT} clause of the SQL query, and generally needs to be combined with
\code{group_by()}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

db <- memdb_frame(g = c(1, 1, 1, 2, 2), x = c(4, 3, 6, 9, 2))
db \%>\%
  summarise(n()) \%>\%
  show_query()

db \%>\%
  group_by(g) \%>\%
  summarise(n()) \%>\%
  show_query()
}
