% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/einstein.R
\name{einstein}
\alias{einstein}
\title{Numerical and Symbolic Einstein Summation}
\usage{
einstein(..., drop = TRUE)
}
\arguments{
\item{...}{arbitrary number of indexed \code{arrays}. See \code{\link{index}}.}

\item{drop}{\code{logical}. Drop summation indices? If \code{FALSE}, keep dummy dimensions.}
}
\value{
\code{array}.
}
\description{
Implements the Einstein notation for summation over repeated indices.
}
\examples{
### A{i,j} B{j,k}
a <- array(letters[1:6], dim = c(i=2, j=3))
b <- array(letters[1:3], dim = c(j=3, k=1))
einstein(a,b)

### A{i,j} B{j,k,k} C{k,l} D{j,k}
a <- array(1:10, dim = c(i=2, j=5))
b <- array(1:45, dim = c(j=5, k=3, k=3))
c <- array(1:12, dim = c(k=3, l=4))
d <- array(1:15, dim = c(j=5, k=3))
einstein(a,b,c,d)

}
\references{
Guidotti E (2022). "calculus: High-Dimensional Numerical and Symbolic Calculus in R." Journal of Statistical Software, 104(5), 1-37. \doi{10.18637/jss.v104.i05}
}
\seealso{
Other tensor algebra: 
\code{\link{contraction}()},
\code{\link{delta}()},
\code{\link{diagonal}()},
\code{\link{epsilon}()},
\code{\link{index}()}
}
\concept{tensor algebra}
