--
-- Copyright 2025 The Android Open Source Project
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--     https://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
-- Device specific device curves with 2D dependency (i.e. curve characteristics
-- are dependent on another CPU policy). See go/wattson for more info.
INCLUDE PERFETTO MODULE wattson.curves.tg5_cpu_2d_1;

INCLUDE PERFETTO MODULE wattson.curves.tg5_cpu_2d_2;

INCLUDE PERFETTO MODULE wattson.utils;

CREATE PERFETTO TABLE _tg5_2d_lut AS
WITH
  data(device, policy, freq_khz, dep_policy, dep_freq, static, active, idle0, idle1) AS (
    SELECT
      *
    FROM (VALUES
      ("Tensor G5", 0, 268000, _dsu_dep!(), 115000000, 15.38, 7.88, 0.11, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 268000000, 14.63, 14.04, 1.89, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 400000000, 16.55, 20.75, 1.1, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 537000000, 19.11, 25.02, 1.01, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 691000000, 23.19, 34.83, 1.34, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 768000000, 26.06, 38.12, 1.14, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 844000000, 28.85, 10.76, 1.22, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 960000000, 32.34, 52.63, 1.27, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 1056000000, 38.77, 52.47, 1.24, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 1132000000, 37.64, 62.55, 1.23, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 1228000000, 41.25, 68.97, 1.17, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 1324000000, 44.53, 74.26, 1.2, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 1420000000, 48.28, 85.23, 1.45, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 1516000000, 52.09, 90.09, 1.35, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 1612000000, 54.77, 95.13, 1.33, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 1728000000, 65.3, 109.03, 1.53, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 1843000000, 68.93, 130.0, 1.05, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 1920000000, 78.89, 131.44, 1.92, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 1996000000, 85.37, 139.68, 1.36, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 2092000000, 96.41, 167.55, 1.66, 0),
      ("Tensor G5", 0, 268000, _dsu_dep!(), 2188000000, 103.8, 186.28, 2.36, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 115000000, 13.03, 9.71, 0.94, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 268000000, 15.56, 16.65, 1.61, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 400000000, 17.81, 20.36, 0.35, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 537000000, 20.02, 29.11, 0.93, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 691000000, 24.83, 35.59, 0.46, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 768000000, 26.79, 40.61, 0.79, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 844000000, 29.23, 46.36, 1.03, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 960000000, 33.26, 54.77, 0.57, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 1056000000, 35.24, 63.16, 0.87, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 1132000000, 38.1, 68.68, 0.93, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 1228000000, 40.04, 76.41, 2.53, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 1324000000, 44.69, 78.79, 1.15, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 1420000000, 48.98, 94.16, 1.08, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 1516000000, 52.4, 100.6, 1.11, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 1612000000, 58.33, 110.56, 1.07, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 1728000000, 91.97, 104.29, 0.9, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 1843000000, 73.52, 142.75, 0.98, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 1920000000, 79.46, 158.68, 1.57, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 1996000000, 85.61, 167.47, 1.41, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 2092000000, 97.08, 188.3, 1.24, 0),
      ("Tensor G5", 0, 345000, _dsu_dep!(), 2188000000, 104.12, 201.35, 0.55, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 115000000, 14.26, 10.39, 0.56, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 268000000, 15.58, 17.03, 0.64, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 400000000, 18.04, 22.22, 0.90, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 537000000, 20.33, 32.69, 0.87, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 691000000, 22.57, 40.93, 0.99, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 768000000, 27.44, 47.9, 1.11, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 844000000, 29.86, 48.01, 0.62, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 960000000, 31.79, 58.2, 1.08, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 1056000000, 34.03, 69.79, 1.26, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 1132000000, 38.34, 71.23, 0.78, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 1228000000, 41.75, 76.41, 0.96, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 1324000000, 44.81, 84.19, 1.09, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 1420000000, 46.34, 93.12, 1.84, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 1516000000, 52.79, 109.98, 1.02, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 1612000000, 58.92, 121.77, 1.78, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 1728000000, 66.4, 125.05, 1.0, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 1843000000, 73.24, 155.18, 1.27, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 1920000000, 79.7, 169.78, 1.52, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 1996000000, 85.83, 169.27, 1.37, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 2092000000, 97.68, 198.51, 1.01, 0),
      ("Tensor G5", 0, 422000, _dsu_dep!(), 2188000000, 108.82, 219.75, 1.1, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 115000000, 14.4, 10.87, 0.3, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 268000000, 16.12, 20.76, 0.51, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 400000000, 18.59, 27.03, 0.63, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 537000000, 20.5, 32.26, 0.67, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 691000000, 15.76, 42.04, 1.34, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 768000000, 26.92, 45.26, 0.81, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 844000000, 29.65, 51.15, 0.84, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 960000000, 33.22, 64.57, 0.76, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 1056000000, 35.32, 72.52, 0.91, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 1132000000, 38.8, 79.61, 0.49, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 1228000000, 42.32, 88.23, 0.6, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 1324000000, 45.29, 94.03, 0.8, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 1420000000, 49.15, 102.06, 0.93, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 1516000000, 52.59, 100.8, 1.16, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 1612000000, 58.83, 112.1, 0.85, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 1728000000, 66.13, 127.77, 1.24, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 1843000000, 73.7, 154.89, 0.93, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 1920000000, 79.8, 171.36, 1.67, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 1996000000, 86.18, 167.59, 1.12, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 2092000000, 97.45, 185.37, 1.27, 0),
      ("Tensor G5", 0, 460000, _dsu_dep!(), 2188000000, 108.94, 203.97, 1.04, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 115000000, 14.3, 11.55, 0.64, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 268000000, 16.65, 20.88, 0.42, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 400000000, 18.35, 29.02, 0.59, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 537000000, 19.83, 38.27, 1.36, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 691000000, 24.29, 46.66, 0.46, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 768000000, 27.09, 48.99, 0.52, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 844000000, 28.18, 51.64, 1.05, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 960000000, 31.37, 61.18, 1.45, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 1056000000, 35.72, 73.64, 0.55, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 1132000000, 38.17, 72.72, 0.77, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 1228000000, 41.76, 83.2, 0.81, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 1324000000, 44.91, 98.8, 0.9, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 1420000000, 49.19, 111.71, 0.77, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 1516000000, 52.54, 114.06, 0.96, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 1612000000, 58.69, 129.09, 0.72, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 1728000000, 66.35, 133.39, 0.81, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 1843000000, 69.46, 158.55, 1.9, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 1920000000, 80.14, 160.82, 1.01, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 1996000000, 85.93, 176.23, 1.14, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 2092000000, 96.43, 206.06, 1.61, 0),
      ("Tensor G5", 0, 533000, _dsu_dep!(), 2188000000, 107.77, 221.39, 1.52, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 115000000, 15.92, 15.42, 1.23, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 268000000, 18.31, 28.5, 0.86, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 400000000, 20.51, 37.87, 0.74, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 537000000, 22.42, 44.91, 0.72, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 691000000, 23.82, 51.09, 1.63, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 768000000, 27.02, 60.86, 1.27, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 844000000, 30.12, 64.8, 0.77, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 960000000, 33.05, 72.37, 1.54, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 1056000000, 36.2, 83.3, 0.91, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 1132000000, 37.15, 88.36, 1.52, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 1228000000, 41.42, 102.86, 1.02, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 1324000000, 44.41, 112.95, 1.25, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 1420000000, 50.58, 126.07, 0.47, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 1516000000, 54.01, 139.42, 0.51, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 1612000000, 59.5, 146.77, 0.78, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 1728000000, 67.14, 168.02, 1.02, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 1843000000, 74.48, 181.33, 0.97, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 1920000000, 85.8, 222.78, 0.72, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 1996000000, 87.08, 226.78, 1.16, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 2092000000, 98.98, 254.91, 0.8, 0),
      ("Tensor G5", 0, 729000, _dsu_dep!(), 2188000000, 103.8, 290.34, 1.07, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 115000000, 19.46, 17.48, 0.12, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 268000000, 21.3, 32.12, 0.18, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 400000000, 22.68, 43.41, 0.59, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 537000000, 24.87, 51.34, 0.47, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 691000000, 26.93, 59.0, 0.56, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 768000000, 29.44, 60.66, 0.09, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 844000000, 29.33, 70.19, 0.84, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 960000000, 33.06, 83.65, 0.71, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 1056000000, 36.2, 90.53, 0.92, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 1132000000, 39.04, 103.09, 0.78, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 1228000000, 46.04, 114.89, 0.8, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 1324000000, 46.13, 115.45, 0.87, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 1420000000, 48.66, 133.67, 1.47, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 1516000000, 54.16, 143.27, 0.77, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 1612000000, 57.49, 150.15, 1.21, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 1728000000, 67.93, 188.21, 0.71, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 1843000000, 72.55, 199.99, 1.38, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 1920000000, 82.1, 228.38, 0.84, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 1996000000, 84.13, 225.51, 1.47, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 2092000000, 98.82, 264.64, 1.26, 0),
      ("Tensor G5", 0, 883000, _dsu_dep!(), 2188000000, 105.97, 283.71, 5.98, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 115000000, 19.27, 20.49, 0.54, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 268000000, 21.28, 33.3, 0.67, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 400000000, 23.61, 44.45, 0.73, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 537000000, 26.03, 55.75, 0.54, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 691000000, 28.27, 67.73, 0.6, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 768000000, 29.73, 72.22, 0.63, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 844000000, 31.23, 74.49, 0.44, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 960000000, 40.33, 85.06, 0.38, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 1056000000, 36.75, 95.54, 0.72, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 1132000000, 40.35, 107.32, 0.36, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 1228000000, 43.56, 115.64, 0.66, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 1324000000, 46.58, 130.94, 0.9, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 1420000000, 50.64, 151.0, 0.91, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 1516000000, 54.06, 145.58, 0.95, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 1612000000, 60.43, 172.93, 0.73, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 1728000000, 68.19, 185.82, 0.89, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 1843000000, 75.43, 211.12, 0.95, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 1920000000, 75.64, 228.31, 1.33, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 1996000000, 88.17, 250.07, 1.18, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 2092000000, 100.08, 274.23, 0.87, 0),
      ("Tensor G5", 0, 1036000, _dsu_dep!(), 2188000000, 111.22, 322.66, 1.03, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 115000000, 20.35, 22.29, 0.56, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 268000000, 22.92, 42.08, 0.73, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 400000000, 25.66, 50.48, 0.38, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 537000000, 27.58, 58.6, 0.62, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 691000000, 29.84, 71.45, 0.8, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 768000000, 30.93, 79.32, 1.34, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 844000000, 31.84, 80.86, 1.76, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 960000000, 34.43, 89.45, 0.93, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 1056000000, 36.96, 101.52, 0.81, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 1132000000, 40.1, 109.06, 0.64, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 1228000000, 43.66, 133.21, 0.83, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 1324000000, 47.3, 138.71, 0.56, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 1420000000, 51.13, 147.79, 0.87, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 1516000000, 55.16, 161.04, 0.53, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 1612000000, 54.08, 178.54, 5.18, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 1728000000, 69.73, 193.32, 1.84, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 1843000000, 75.0, 221.8, 1.83, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 1920000000, 82.32, 241.49, 1.29, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 1996000000, 88.62, 264.4, 1.18, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 2092000000, 100.23, 297.33, 1.11, 0),
      ("Tensor G5", 0, 1190000, _dsu_dep!(), 2188000000, 111.75, 338.84, 1.22, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 115000000, 21.61, 29.39, 1.21, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 268000000, 25.28, 44.57, 0.36, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 400000000, 28.12, 56.33, 0.29, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 537000000, 29.55, 71.13, 0.78, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 691000000, 32.11, 78.96, 0.79, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 768000000, 26.37, 76.42, 8.34, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 844000000, 28.68, 69.5, 1.26, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 960000000, 36.88, 107.59, 1.13, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 1056000000, 37.82, 106.56, 0.83, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 1132000000, 39.79, 112.11, 1.09, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 1228000000, 43.5, 129.42, 1.02, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 1324000000, 468.82, 140.63, 0.74, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 1420000000, 185.39, 164.73, 0.81, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 1516000000, 282.14, 182.65, 0.7, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 1612000000, 298.78, 190.35, 0.96, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 1728000000, 422.42, 205.29, 0.86, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 1843000000, 77.84, 227.42, 0.15, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 1920000000, 84.4, 249.93, 0.27, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 1996000000, 90.1, 274.36, 0.61, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 2092000000, 101.23, 315.63, 0.86, 0),
      ("Tensor G5", 0, 1286000, _dsu_dep!(), 2188000000, 112.88, 339.0, 0.79, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 115000000, 22.78, 30.64, 0.67, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 268000000, 26.61, 46.13, 0.25, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 400000000, 28.62, 56.41, 0.58, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 537000000, 31.0, 71.3, 0.65, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 691000000, 33.59, 86.05, 0.75, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 768000000, 35.42, 95.78, 0.66, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 844000000, 35.25, 93.0, 0.68, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 960000000, 40.43, 105.52, 0.67, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 1056000000, 39.58, 109.81, 0.62, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 1132000000, 41.12, 115.72, 0.69, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 1228000000, 42.13, 127.16, 1.53, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 1324000000, 47.56, 139.5, 0.75, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 1420000000, 52.38, 156.85, 0.39, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 1516000000, 53.61, 162.52, 1.46, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 1612000000, 61.48, 183.97, 0.59, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 1728000000, 69.42, 210.05, 0.86, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 1843000000, 76.17, 234.68, 1.37, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 1920000000, 82.86, 258.92, 1.23, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 1996000000, 89.89, 297.04, 0.77, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 2092000000, 101.61, 308.49, 0.78, 0),
      ("Tensor G5", 0, 1363000, _dsu_dep!(), 2188000000, 108.47, 332.08, 1.22, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 115000000, 25.02, 32.49, 0.38, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 268000000, 28.45, 48.13, 0.3, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 400000000, 30.78, 66.35, 0.55, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 537000000, 32.6, 76.75, 1.17, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 691000000, 36.24, 94.36, 0.62, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 768000000, 37.69, 100.45, 0.78, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 844000000, 39.37, 105.59, 0.71, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 960000000, 41.63, 122.39, 0.7, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 1056000000, 42.52, 125.65, 0.64, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 1132000000, 44.07, 130.33, 0.65, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 1228000000, 45.76, 139.21, 0.95, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 1324000000, 47.31, 148.74, 0.85, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 1420000000, 53.2, 162.42, 0.11, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 1516000000, 55.3, 177.22, 0.87, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 1612000000, 61.69, 194.55, 0.7, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 1728000000, 69.63, 214.84, 0.79, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 1843000000, 76.84, 237.31, 0.94, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 1920000000, 83.6, 269.29, 1.05, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 1996000000, 90.18, 288.85, 0.78, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 2092000000, 101.79, 343.02, 0.86, 0),
      ("Tensor G5", 0, 1459000, _dsu_dep!(), 2188000000, 112.96, 375.32, 0.96, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 115000000, 25.81, 33.24, 0.78, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 268000000, 29.88, 57.31, 0.4, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 400000000, 31.54, 69.2, 1.09, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 537000000, 35.15, 83.66, 0.6, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 691000000, 37.77, 96.68, 0.87, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 768000000, 39.08, 105.1, 1.93, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 844000000, 41.72, 117.06, 0.56, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 960000000, 44.12, 125.35, 0.55, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 1056000000, 44.67, 133.17, 0.68, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 1132000000, 46.67, 135.44, 0.57, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 1228000000, 47.89, 151.1, 0.95, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 1324000000, 50.34, 158.81, 0.74, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 1420000000, 52.28, 162.93, 0.73, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 1516000000, 56.05, 175.57, 0.62, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 1612000000, 59.86, 191.93, 2.7, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 1728000000, 71.5, 230.99, 1.77, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 1843000000, 77.48, 244.05, 0.62, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 1920000000, 84.48, 270.05, 0.78, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 1996000000, 89.7, 290.99, 1.2, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 2092000000, 101.61, 331.63, 1.2, 0),
      ("Tensor G5", 0, 1555000, _dsu_dep!(), 2188000000, 113.01, 374.24, 1.12, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 115000000, 28.25, 36.62, 0.01, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 268000000, 30.28, 58.2, 0.76, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 400000000, 33.89, 76.04, 0.3, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 537000000, 36.11, 84.16, 0.88, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 691000000, 40.44, 105.97, 0.79, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 768000000, 41.68, 120.82, 0.52, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 844000000, 43.07, 119.68, 0.71, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 960000000, 45.15, 131.08, 0.92, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 1056000000, 46.16, 139.07, 0.72, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 1132000000, 46.46, 146.5, 1.22, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 1228000000, 49.99, 157.13, 0.72, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 1324000000, 51.75, 164.34, 1.05, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 1420000000, 54.29, 173.74, 0.62, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 1516000000, 56.69, 185.94, 0.0, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 1612000000, 61.72, 203.28, 0.99, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 1728000000, 69.77, 241.15, 1.06, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 1843000000, 77.12, 269.15, 1.05, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 1920000000, 83.99, 285.59, 1.27, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 1996000000, 96.73, 303.74, 1.1, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 2092000000, 102.17, 336.84, 0.86, 0),
      ("Tensor G5", 0, 1632000, _dsu_dep!(), 2188000000, 111.49, 371.95, 1.22, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 115000000, 28.83, 39.78, 1.04, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 268000000, 32.14, 62.72, 1.66, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 400000000, 36.53, 81.64, 0.76, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 537000000, 39.54, 96.57, 0.88, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 691000000, 42.74, 115.72, 1.05, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 768000000, 45.06, 126.78, 0.85, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 844000000, 47.09, 133.63, 0.72, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 960000000, 49.04, 145.75, 1.06, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 1056000000, 50.36, 175.74, 0.85, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 1132000000, 50.45, 164.82, 0.83, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 1228000000, 54.76, 177.83, 0.81, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 1324000000, 56.73, 186.14, 0.83, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 1420000000, 60.62, 195.35, 0.0, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 1516000000, 60.49, 216.61, 1.09, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 1612000000, 63.81, 203.86, 0.61, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 1728000000, 70.61, 237.14, 0.56, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 1843000000, 74.41, 252.18, 1.25, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 1920000000, 86.28, 282.05, 1.6, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 1996000000, 91.18, 310.57, 0.68, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 2092000000, 102.74, 344.05, 0.89, 0),
      ("Tensor G5", 0, 1766000, _dsu_dep!(), 2188000000, 113.23, 396.02, 1.45, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 115000000, 31.65, 44.25, 0.81, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 268000000, 35.73, 69.99, 0.59, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 400000000, 39.31, 85.52, 0.7, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 537000000, 42.38, 102.24, 0.92, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 691000000, 46.12, 120.67, 0.79, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 768000000, 48.01, 142.64, 1.01, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 844000000, 47.93, 155.88, 1.04, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 960000000, 52.63, 162.54, 1.17, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 1056000000, 53.94, 172.98, 0.84, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 1132000000, 56.33, 180.7, 0.68, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 1228000000, 58.35, 191.56, 0.84, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 1324000000, 60.94, 197.53, 0.71, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 1420000000, 63.56, 220.68, 0.39, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 1516000000, 63.6, 222.55, 1.52, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 1612000000, 68.76, 243.96, 0.34, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 1728000000, 70.9, 252.42, 0.74, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 1843000000, 73.76, 270.62, 1.24, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 1920000000, 84.64, 288.52, 1.23, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 1996000000, 91.7, 316.34, 0.67, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 2092000000, 103.14, 355.3, 0.91, 0),
      ("Tensor G5", 0, 1881000, _dsu_dep!(), 2188000000, 114.68, 390.88, 0.97, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 115000000, 35.86, 49.93, 0.74, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 268000000, 38.38, 77.71, 0.63, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 400000000, 42.03, 99.62, 0.93, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 537000000, 45.66, 118.99, 0.73, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 691000000, 47.66, 134.24, 1.41, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 768000000, 51.67, 145.17, 0.94, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 844000000, 53.54, 164.1, 1.04, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 960000000, 56.94, 186.09, 0.72, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 1056000000, 58.01, 182.51, 0.73, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 1132000000, 59.73, 200.04, 1.01, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 1228000000, 62.81, 213.61, 0.68, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 1324000000, 65.4, 225.19, 0.61, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 1420000000, 67.42, 228.54, 0.85, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 1516000000, 69.73, 240.23, 0.89, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 1612000000, 73.04, 250.67, 0.62, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 1728000000, 75.73, 263.9, 0.65, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 1843000000, 78.8, 274.24, 0.66, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 1920000000, 85.72, 299.41, 0.75, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 1996000000, 91.2, 332.3, 1.18, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 2092000000, 101.06, 359.95, 1.36, 0),
      ("Tensor G5", 0, 1996000, _dsu_dep!(), 2188000000, 115.01, 419.31, 1.07, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 115000000, 31.62, 55.5, 1.49, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 268000000, 39.39, 85.13, 0.83, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 400000000, 43.29, 96.41, 0.88, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 537000000, 45.91, 115.47, 1.07, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 691000000, 51.08, 141.38, 0.86, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 768000000, 53.55, 150.9, 0.81, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 844000000, 55.76, 161.46, 0.72, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 960000000, 58.66, 191.14, 0.9, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 1056000000, 59.96, 193.8, 0.61, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 1132000000, 60.26, 202.23, 0.58, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 1228000000, 64.55, 220.67, 0.84, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 1324000000, 67.23, 223.1, 0.63, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 1420000000, 69.75, 233.77, 0.7, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 1516000000, 71.9, 246.63, 0.97, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 1612000000, 74.84, 263.37, 0.85, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 1728000000, 78.11, 276.42, 0.78, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 1843000000, 82.33, 294.76, 1.29, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 1920000000, 81.9, 299.3, 1.55, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 1996000000, 91.67, 322.26, 0.91, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 2092000000, 104.11, 358.2, 0.61, 0),
      ("Tensor G5", 0, 2016000, _dsu_dep!(), 2188000000, 114.88, 405.19, 1.22, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 115000000, 36.6, 52.82, 0.93, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 268000000, 41.46, 83.98, 0.84, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 400000000, 45.31, 104.78, 1.11, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 537000000, 49.6, 125.88, 0.81, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 691000000, 53.74, 158.67, 0.86, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 768000000, 54.47, 169.14, 2.61, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 844000000, 58.3, 172.99, 0.86, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 960000000, 62.79, 195.93, 0.18, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 1056000000, 60.41, 201.47, 1.08, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 1132000000, 64.96, 210.42, 0.97, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 1228000000, 68.71, 228.57, 1.01, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 1324000000, 68.3, 227.14, 1.92, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 1420000000, 73.05, 245.3, 0.84, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 1516000000, 75.94, 260.46, 0.6, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 1612000000, 78.65, 264.24, 0.75, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 1728000000, 84.04, 291.13, 1.0, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 1843000000, 85.21, 302.95, 0.73, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 1920000000, 87.3, 311.8, 0.86, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 1996000000, 90.45, 316.78, 2.52, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 2092000000, 104.03, 361.54, 0.77, 0),
      ("Tensor G5", 0, 2054000, _dsu_dep!(), 2188000000, 115.09, 426.55, 1.15, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 115000000, 39.1, 56.49, 1.03, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 268000000, 36.42, 84.78, 1.4, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 400000000, 48.88, 109.91, 1.02, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 537000000, 51.16, 130.06, 0.81, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 691000000, 55.61, 160.42, 0.78, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 768000000, 56.42, 157.73, 2.7, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 844000000, 60.2, 189.98, 0.97, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 960000000, 63.5, 200.08, 1.03, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 1056000000, 65.36, 218.11, 0.41, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 1132000000, 66.94, 231.3, 1.24, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 1228000000, 70.27, 232.3, 0.78, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 1324000000, 70.11, 245.3, 1.58, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 1420000000, 75.26, 257.22, 1.01, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 1516000000, 77.89, 277.04, 0.92, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 1612000000, 82.16, 292.1, 0.23, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 1728000000, 84.57, 295.18, 0.88, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 1843000000, 87.98, 308.21, 0.66, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 1920000000, 90.16, 322.65, 0.74, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 1996000000, 92.65, 352.28, 0.56, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 2092000000, 105.23, 370.03, 0.16, 0),
      ("Tensor G5", 0, 2092000, _dsu_dep!(), 2188000000, 115.87, 411.54, 0.85, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 115000000, 42.62, 60.74, 0.77, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 268000000, 43.69, 102.88, 2.88, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 400000000, 50.61, 119.86, 2.35, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 537000000, 54.62, 142.5, 2.85, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 691000000, 60.28, 168.92, 1.7, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 768000000, 63.92, 196.16, 1.14, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 844000000, 66.68, 195.66, 0.87, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 960000000, 70.49, 216.61, 0.73, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 1056000000, 70.77, 244.97, 1.52, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 1132000000, 74.14, 237.56, 0.96, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 1228000000, 77.04, 278.22, 0.99, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 1324000000, 80.22, 273.2, 0.87, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 1420000000, 77.82, 287.03, 1.55, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 1516000000, 85.41, 291.57, 1.36, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 1612000000, 89.28, 325.21, 1.02, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 1728000000, 94.06, 331.6, 0.35, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 1843000000, 96.8, 342.11, 0.85, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 1920000000, 98.83, 356.44, 1.09, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 1996000000, 101.05, 352.73, 1.16, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 2092000000, 104.74, 378.28, 0.65, 0),
      ("Tensor G5", 0, 2169000, _dsu_dep!(), 2188000000, 115.9, 413.13, 0.99, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 115000000, 46.17, 65.62, 0.99, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 268000000, 51.7, 109.99, 1.05, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 400000000, 52.75, 130.87, 0.9, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 537000000, 63.14, 166.48, 0.9, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 691000000, 66.56, 185.35, 0.91, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 768000000, 69.84, 213.57, 0.9, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 844000000, 72.44, 209.96, 0.92, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 960000000, 76.31, 244.77, 0.88, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 1056000000, 77.19, 253.25, 1.15, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 1132000000, 80.51, 269.49, 0.94, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 1228000000, 86.15, 279.13, 1.28, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 1324000000, 86.89, 298.88, 0.98, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 1420000000, 87.36, 321.84, 1.2, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 1516000000, 93.03, 322.88, 1.18, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 1612000000, 96.83, 348.28, 1.16, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 1728000000, 100.03, 359.41, 1.49, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 1843000000, 104.83, 374.2, 0.96, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 1920000000, 107.22, 382.67, 1.17, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 1996000000, 110.02, 397.06, 0.87, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 2092000000, 113.37, 443.7, 0.8, 0),
      ("Tensor G5", 0, 2246000, _dsu_dep!(), 2188000000, 116.14, 423.27, 1.22, 0)) AS _values
  )
SELECT
  *
FROM data
UNION ALL
SELECT
  *
FROM _tg5_2d_lut_1
UNION ALL
SELECT
  *
FROM _tg5_2d_lut_2;
