/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.toolbars;

import com.vldocking.swing.toolbars.ToolBarConstraints;
import com.vldocking.swing.toolbars.ToolBarContainer;
import com.vldocking.swing.toolbars.ToolBarIOReadInfo;
import com.vldocking.swing.toolbars.ToolBarPanel;
import com.vldocking.swing.toolbars.ToolBarPanelLayout;
import com.vldocking.swing.toolbars.VLToolBar;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

public class ToolBarIO {
    private ToolBarContainer container;

    public ToolBarIO(ToolBarContainer container) {
        this.container = container;
    }

    public void writeXML(OutputStream stream) throws IOException {
        PrintWriter out = new PrintWriter(stream);
        out.println("<?xml version=\"1.0\"?>");
        out.println("<VLToolBars version=\"1.0\">");
        this.xmlWriteContainer(out);
        out.println("</VLToolBars>");
        out.flush();
    }

    private void xmlWriteContainer(PrintWriter out) {
        out.println("<Container>");
        Component[] comps = this.container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            ToolBarPanel panel;
            Object constraints = this.container.getConstraints(comps[i]);
            if (constraints.equals("North")) {
                panel = this.container.getToolBarPanelAt(constraints);
                this.xmlWriteToolBarPanel(out, panel, "top");
                continue;
            }
            if (constraints.equals("West")) {
                panel = this.container.getToolBarPanelAt(constraints);
                this.xmlWriteToolBarPanel(out, panel, "left");
                continue;
            }
            if (constraints.equals("South")) {
                panel = this.container.getToolBarPanelAt(constraints);
                this.xmlWriteToolBarPanel(out, panel, "bottom");
                continue;
            }
            if (!constraints.equals("East")) continue;
            panel = this.container.getToolBarPanelAt(constraints);
            this.xmlWriteToolBarPanel(out, panel, "right");
        }
        out.println("</Container>");
    }

    private void xmlWriteToolBarPanel(PrintWriter out, ToolBarPanel panel, String position) {
        out.println("<ToolBarPanel position=\"" + position + "\">");
        ToolBarPanelLayout layout = (ToolBarPanelLayout)panel.getLayout();
        Component[] children = layout.getComponents();
        for (int i = 0; i < children.length; ++i) {
            VLToolBar tb = (VLToolBar)children[i];
            ToolBarConstraints tc = layout.getConstraints(tb);
            out.println("<ToolBar name=\"" + tb.getName() + "\" major=\"" + tc.majorOrder + "\" minor=\"" + tc.minorOrder + "\" collapsed=\"" + tb.isCollapsed() + "\"/>");
        }
        out.println("</ToolBarPanel>");
    }

    public ToolBarIOReadInfo readXML(InputStream in) throws ParserConfigurationException, IOException, SAXException {
        ToolBarIOReadInfo tri = new ToolBarIOReadInfo();
        Component[] comps = this.container.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Object constraints = this.container.getConstraints(comps[i]);
            if (constraints.equals("North")) {
                ((Container)comps[i]).removeAll();
                continue;
            }
            if (constraints.equals("West")) {
                ((Container)comps[i]).removeAll();
                continue;
            }
            if (constraints.equals("South")) {
                ((Container)comps[i]).removeAll();
                continue;
            }
            if (!constraints.equals("East")) continue;
            ((Container)comps[i]).removeAll();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(in);
        Element root = doc.getDocumentElement();
        NodeList children = root.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            this.xmlReadRootNode(child, tri);
        }
        tri.setRegisteredToolbars(this.container.getRegisteredToolBars());
        tri.finishLoading();
        this.container.revalidate();
        return tri;
    }

    private void xmlReadRootNode(Node node, ToolBarIOReadInfo tri) throws SAXException {
        if (node.getNodeType() == 1) {
            Element elt = (Element)node;
            String name = elt.getNodeName();
            if (name.equals("Container")) {
                NodeList children = node.getChildNodes();
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    Node child = children.item(i);
                    this.xmlReadContainerNode(child, tri);
                }
            } else {
                throw new SAXNotRecognizedException(name);
            }
        }
    }

    private void xmlReadContainerNode(Node node, ToolBarIOReadInfo tri) throws SAXException {
        if (node.getNodeType() == 1) {
            Element elt = (Element)node;
            String name = elt.getNodeName();
            if (name.equals("ToolBarPanel")) {
                String position = elt.getAttribute("position");
                ToolBarPanel tp = null;
                if (position.equals("top")) {
                    tp = this.container.getToolBarPanelAt("North");
                } else if (position.equals("left")) {
                    tp = this.container.getToolBarPanelAt("West");
                } else if (position.equals("bottom")) {
                    tp = this.container.getToolBarPanelAt("South");
                } else if (position.equals("right")) {
                    tp = this.container.getToolBarPanelAt("East");
                }
                NodeList children = elt.getElementsByTagName("ToolBar");
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.xmlReadToolBarPanelNode(tp, (Element)children.item(i), tri);
                }
                tp.revalidate();
            } else {
                throw new SAXNotRecognizedException(name);
            }
        }
    }

    private void xmlReadToolBarPanelNode(ToolBarPanel panel, Element toolbarElt, ToolBarIOReadInfo tri) {
        String toolbarName = toolbarElt.getAttribute("name");
        int major = Integer.parseInt(toolbarElt.getAttribute("major"));
        int minor = Integer.parseInt(toolbarElt.getAttribute("minor"));
        boolean collapsed = Boolean.valueOf(toolbarElt.getAttribute("collapsed"));
        ToolBarConstraints tc = new ToolBarConstraints(major, minor);
        VLToolBar tb = this.container.getToolBarByName(toolbarName);
        if (tb != null) {
            tb.setCollapsed(collapsed);
            panel.add(tb, tc);
            tri.notifyToolbarInstalled(tb);
        } else {
            tri.notifyUnknownToolbarFound(toolbarName);
        }
    }
}

