/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.eviction;

import static org.testng.AssertJUnit.fail;

import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

/**
 * Unit tests for NullEvictionPolicyConfig.
 *
 * @author Daniel Huang (dhuang@jboss.org)
 * @version $Revision: 4444 $
 */
@Test(groups = {"functional"})
public class NullEvictionConfigTest
{
   /** 
    * Creates a bunch of region elements with LRU configs and confirms
    * that NullEvictionPolicyConfig doesn't barf.
    * 
    * @throws Exception
    */
   public void testXMLParsing() throws Exception
   {
      String xml =
            "<region name=\"/org/jboss/data\">\n" +
                  "<attribute name=\"maxNodes\">5000</attribute>\n" +
                  "<attribute name=\"timeToLiveSeconds\">1000</attribute>\n" +
                  "</region>";
      
      testConfigBlock(xml);
      
      xml = "<region name=\"/maxAgeTest/\">\n" +
            "<attribute name=\"maxNodes\">10000</attribute>\n" +
            "<attribute name=\"timeToLiveSeconds\">8</attribute>\n" +
            "<attribute name=\"maxAgeSeconds\">10</attribute>\n" +
            "</region>";
      
      testConfigBlock(xml);

      xml = "<region name=\"/maxAgeTest/\">\n" +
            "<attribute name=\"maxNodes\">10000</attribute>\n" +
            "<attribute name=\"maxAgeSeconds\">10</attribute>\n" +
            "</region>";
      
      testConfigBlock(xml);

      xml = "<region name=\"/maxAgeTest/\">\n" +
            "<attribute name=\"timeToLiveSeconds\">8</attribute>\n" +
            "<attribute name=\"maxAgeSeconds\">10</attribute>\n" +
            "</region>";
      
      testConfigBlock(xml);

      xml = "<region name=\"/maxAgeTest/\"/>\n";
      
      testConfigBlock(xml);
   }

   /**
    * FIXME Comment this
    * 
    * @param xml
    * @throws Exception
    */
   private void testConfigBlock(String xml) throws Exception
   {
      Element element = XmlHelper.stringToElement(xml);
      NullEvictionPolicyConfig config = new NullEvictionPolicyConfig();
      try
      {
         XmlConfigurationParser.parseEvictionPolicyConfig(element, config);
      }
      catch (Exception e)
      {
         fail(e.getMessage());
      }
   }
}
