/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.eviction;

import static org.testng.AssertJUnit.assertEquals;
import static org.testng.AssertJUnit.assertTrue;
import static org.testng.AssertJUnit.fail;

import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
/**
 * @author Daniel Huang
 * @version $Revision: 4444 $
 */
@Test(groups = {"functional"})
public class ElementSizeConfigurationTest
{
   public void testXMLParse1() throws Exception
   {
      ElementSizeConfiguration config = new ElementSizeConfiguration();
      String xml = "<region name=\"abc\">" +
                   "<attribute name=\"maxNodes\">1000</attribute>" +
                   "<attribute name=\"maxElementsPerNode\">100</attribute>" +
                   "</region>";

      Element element = XmlHelper.stringToElement(xml);
      XmlConfigurationParser.parseEvictionPolicyConfig(element, config);

      assertEquals(100, config.getMaxElementsPerNode());
      assertEquals(1000, config.getMaxNodes());
   }


   public void testXMLParse2() throws Exception
   {
      ElementSizeConfiguration config = new ElementSizeConfiguration();
      String xml = "<region name=\"abc\">" +
                   "<attribute name=\"maxNodes\">1000</attribute>" +
                   "</region>";

      Element element = XmlHelper.stringToElement(xml);
      try
      {
         XmlConfigurationParser.parseEvictionPolicyConfig(element, config);
      }
      catch (ConfigurationException ce)
      {
         assertTrue("Configure exception properly thrown", true);
         return;
      }

      fail("Invalid region Element Size configuration did not cause ConfigureException to be thrown with empty maxElementsPerNode attribute");
   }


   public void testXMLParse3() throws Exception
   {
      ElementSizeConfiguration config = new ElementSizeConfiguration();
      String xml = "<region name=\"abc\">" +
                   "<attribute name=\"maxElementsPerNode\">100</attribute>" +
                   "</region>";

      Element element = XmlHelper.stringToElement(xml);

      XmlConfigurationParser.parseEvictionPolicyConfig(element, config);

      assertEquals(100, config.getMaxElementsPerNode());
      assertEquals(0, config.getMaxNodes());
   }

}
