/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.config;


import static org.testng.AssertJUnit.assertEquals;
import static org.testng.AssertJUnit.assertNull;

import org.jboss.cache.config.Configuration.CacheMode;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.TransactionSetup;
import org.testng.annotations.Test;
/**
 * @author <a href="mailto:manik@jboss.org">Manik Surtani (manik@jboss.org)</a>
 */
@Test(groups = {"functional", "jgroups", "transaction"})
public class ConfigurationTest
{
   public void testReplSyncStack() throws Exception
   {
      Configuration conf = UnitTestCacheConfigurationFactory.createConfiguration(CacheMode.REPL_SYNC);

      //now test that everything has been read in properly.
      assertEquals(Configuration.CacheMode.REPL_SYNC, conf.getCacheMode());
      assertEquals(TransactionSetup.getManagerLookup(), conf.getTransactionManagerLookupClass());
      assertEquals(IsolationLevel.REPEATABLE_READ, conf.getIsolationLevel());
      assertEquals(false, conf.isUseReplQueue());
      assertEquals(0, conf.getReplQueueInterval());
      assertEquals(0, conf.getReplQueueMaxElements());
      assertEquals("JBossCache-Cluster", conf.getClusterName());
      assertEquals(true, conf.isFetchInMemoryState());
      assertEquals(15000, conf.getStateRetrievalTimeout());
      assertEquals(15000, conf.getSyncReplTimeout());
      assertEquals(10000, conf.getLockAcquisitionTimeout());
      assertNull(conf.getEvictionConfig());
      assertEquals(false, conf.isUseRegionBasedMarshalling());

      // not testing the JGroups configs since JGroups doesn't expose their config as a bean.
      // comparing an XML block is a PITA.
   }

   public void testMultiplexerStack() throws Exception
   {
      XmlConfigurationParser parser = new XmlConfigurationParser();
      Configuration conf = parser.parseFile("META-INF/conf-test/mux-service.xml");

      // test that multiplexer settings have been read in properly.
      //assertEquals("MultiplexerService", "jgroups.mux:name=Multiplexer", conf.getMultiplexerService());
      assertEquals("MultiplexerStack", "tcp", conf.getMultiplexerStack());
      assertNull("ClusterConfig", conf.getClusterConfig());
   }

}
