package org.jboss.cache.commands.tx;

import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.transaction.GlobalTransaction;

/**
 * Base class for transaction boundary commands that deal with global transactions
 *
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @since 2.2.0
 */
public abstract class AbstractTransactionCommand implements VisitableCommand
{
   protected GlobalTransaction globalTransaction;

   /**
    * Default implementation which is a no-op.  Transaction boundary commands always return a null.
    *
    * @return null
    */
   public Object perform(InvocationContext ctx)
   {
      return null;
   }

   public GlobalTransaction getGlobalTransaction()
   {
      return globalTransaction;
   }

   public void setGlobalTransaction(GlobalTransaction gtx)
   {
      this.globalTransaction = gtx;
   }

   public Object[] getParameters()
   {
      return new Object[]{globalTransaction};
   }

   public void setParameters(int commandId, Object[] args)
   {
      globalTransaction = (GlobalTransaction) args[0];
   }

   @Override
   public boolean equals(Object o)
   {
      if (this == o) return true;
      if (o == null || getClass() != o.getClass()) return false;

      AbstractTransactionCommand that = (AbstractTransactionCommand) o;

      if (globalTransaction != null ? !globalTransaction.equals(that.globalTransaction) : that.globalTransaction != null)
         return false;

      return true;
   }

   @Override
   public int hashCode()
   {
      return (globalTransaction != null ? globalTransaction.hashCode() : 0);
   }

   @Override
   public String toString()
   {
      return getClass().getSimpleName() + "{" +
            "gtx=" + globalTransaction +
            '}';
   }
}
