import { OtGlyph } from "@ot-builder/ot-glyphs";
import { Data } from "@ot-builder/prelude";
import { Int16 } from "@ot-builder/primitive";
import { OtVar } from "@ot-builder/variance";
export declare const Tag = "MATH";
export declare class Table {
    constants: Data.Maybe<Constants>;
    glyphInfo: Data.Maybe<GlyphInfo>;
    variants: Data.Maybe<Variants>;
    constructor(constants?: Data.Maybe<Constants>, glyphInfo?: Data.Maybe<GlyphInfo>, variants?: Data.Maybe<Variants>);
}
export type ValueRecord = {
    readonly value: OtVar.Value;
    readonly device?: Data.Maybe<ReadonlyArray<number>>;
};
export declare class Constants {
    scriptPercentScaleDown: Int16;
    scriptScriptPercentScaleDown: Int16;
    delimitedSubFormulaMinHeight: OtVar.Value;
    displayOperatorMinHeight: OtVar.Value;
    mathLeading: ValueRecord;
    axisHeight: ValueRecord;
    accentBaseHeight: ValueRecord;
    flattenedAccentBaseHeight: ValueRecord;
    subscriptShiftDown: ValueRecord;
    subscriptTopMax: ValueRecord;
    subscriptBaselineDropMin: ValueRecord;
    superscriptShiftUp: ValueRecord;
    superscriptShiftUpCramped: ValueRecord;
    superscriptBottomMin: ValueRecord;
    superscriptBaselineDropMax: ValueRecord;
    subSuperscriptGapMin: ValueRecord;
    superscriptBottomMaxWithSubscript: ValueRecord;
    spaceAfterScript: ValueRecord;
    upperLimitGapMin: ValueRecord;
    upperLimitBaselineRiseMin: ValueRecord;
    lowerLimitGapMin: ValueRecord;
    lowerLimitBaselineDropMin: ValueRecord;
    stackTopShiftUp: ValueRecord;
    stackTopDisplayStyleShiftUp: ValueRecord;
    stackBottomShiftDown: ValueRecord;
    stackBottomDisplayStyleShiftDown: ValueRecord;
    stackGapMin: ValueRecord;
    stackDisplayStyleGapMin: ValueRecord;
    stretchStackTopShiftUp: ValueRecord;
    stretchStackBottomShiftDown: ValueRecord;
    stretchStackGapAboveMin: ValueRecord;
    stretchStackGapBelowMin: ValueRecord;
    fractionNumeratorShiftUp: ValueRecord;
    fractionNumeratorDisplayStyleShiftUp: ValueRecord;
    fractionDenominatorShiftDown: ValueRecord;
    fractionDenominatorDisplayStyleShiftDown: ValueRecord;
    fractionNumeratorGapMin: ValueRecord;
    fractionNumDisplayStyleGapMin: ValueRecord;
    fractionRuleThickness: ValueRecord;
    fractionDenominatorGapMin: ValueRecord;
    fractionDenomDisplayStyleGapMin: ValueRecord;
    skewedFractionHorizontalGap: ValueRecord;
    skewedFractionVerticalGap: ValueRecord;
    overbarVerticalGap: ValueRecord;
    overbarRuleThickness: ValueRecord;
    overbarExtraAscender: ValueRecord;
    underbarVerticalGap: ValueRecord;
    underbarRuleThickness: ValueRecord;
    underbarExtraDescender: ValueRecord;
    radicalVerticalGap: ValueRecord;
    radicalDisplayStyleVerticalGap: ValueRecord;
    radicalRuleThickness: ValueRecord;
    radicalExtraAscender: ValueRecord;
    radicalKernBeforeDegree: ValueRecord;
    radicalKernAfterDegree: ValueRecord;
    radicalDegreeBottomRaisePercent: Int16;
}
export declare class GlyphInfo {
    italicCorrections: Map<OtGlyph, ValueRecord>;
    topAccentAttachments: Map<OtGlyph, ValueRecord>;
    extendedShapes: Data.Maybe<Set<OtGlyph>>;
    kernInfos: Map<OtGlyph, KernInfo>;
    constructor(italicCorrections?: Map<OtGlyph, ValueRecord>, topAccentAttachments?: Map<OtGlyph, ValueRecord>, extendedShapes?: Data.Maybe<Set<OtGlyph>>, kernInfos?: Map<OtGlyph, KernInfo>);
}
export declare class KernInfo {
    topRight: Data.Maybe<Kern>;
    topLeft: Data.Maybe<Kern>;
    bottomRight: Data.Maybe<Kern>;
    bottomLeft: Data.Maybe<Kern>;
    constructor(topRight?: Data.Maybe<Kern>, topLeft?: Data.Maybe<Kern>, bottomRight?: Data.Maybe<Kern>, bottomLeft?: Data.Maybe<Kern>);
}
export declare class Kern {
    kernValue: ValueRecord;
    corrections: [ValueRecord, ValueRecord][];
    constructor(kernValue?: ValueRecord, corrections?: [ValueRecord, ValueRecord][]);
}
export declare class GlyphVariantRecord {
    readonly variantGlyph: OtGlyph;
    readonly advanceMeasurement: OtVar.Value;
    constructor(variantGlyph: OtGlyph, advanceMeasurement: OtVar.Value);
}
export declare enum GlyphPartFlags {
    None = 0,
    Extender = 1
}
export declare class GlyphPart {
    readonly partGlyph: OtGlyph;
    readonly startConnectorLength: OtVar.Value;
    readonly endConnectorLength: OtVar.Value;
    readonly fullAdvance: OtVar.Value;
    readonly flags: GlyphPartFlags;
    constructor(partGlyph: OtGlyph, startConnectorLength: OtVar.Value, endConnectorLength: OtVar.Value, fullAdvance: OtVar.Value, flags: GlyphPartFlags);
}
export declare class GlyphAssembly {
    italicCorrection: ValueRecord;
    parts: GlyphPart[];
    constructor(italicCorrection: ValueRecord, parts: GlyphPart[]);
}
export declare class GlyphConstruction {
    assembly: Data.Maybe<GlyphAssembly>;
    variants: GlyphVariantRecord[];
    constructor(assembly?: Data.Maybe<GlyphAssembly>, variants?: GlyphVariantRecord[]);
}
export declare class Variants {
    minConnectorOverlap: OtVar.Value;
    vertical: Data.Maybe<Map<OtGlyph, GlyphConstruction>>;
    horizontal: Data.Maybe<Map<OtGlyph, GlyphConstruction>>;
    constructor(minConnectorOverlap?: OtVar.Value, vertical?: Data.Maybe<Map<OtGlyph, GlyphConstruction>>, horizontal?: Data.Maybe<Map<OtGlyph, GlyphConstruction>>);
}
//# sourceMappingURL=index.d.ts.map