package org.rcsb.cif.schema.core;

import org.rcsb.cif.model.*;
import org.rcsb.cif.schema.*;

import javax.annotation.Generated;

/**
 * 
 */
@Generated("org.rcsb.cif.schema.generator.SchemaGenerator")
public class DiffrnSource extends DelegatingCategory.DelegatingCifCoreCategory {
    private static final String NAME = "diffrn_source";

    public DiffrnSource(CifCoreBlock parentBlock) {
        super(NAME, parentBlock);
    }

    /**
     * The name of the beamline at the synchrotron or other
     * large-scale experimental facility at which the experiment
     * was conducted.
     * @return StrColumn
     */
    public StrColumn getBeamline() {
        return new DelegatingStrColumn(parentBlock.getColumn("diffrn_source_beamline"));
    }

    /**
     * Generator current at which the radiation source device was operated.
     * @return FloatColumn
     */
    public FloatColumn getCurrent() {
        return new DelegatingFloatColumn(parentBlock.getColumn("diffrn_source_current"));
    }

    /**
     * A description of special aspects of the source not covered by
     * other data items.
     * @return StrColumn
     */
    public StrColumn getDetails() {
        return new DelegatingStrColumn(parentBlock.getColumn("diffrn_source_details"));
    }

    /**
     * Enumerated code for the device providing the source of radiation.
     * @return StrColumn
     */
    public StrColumn getDevice() {
        return new DelegatingStrColumn(parentBlock.getColumn("diffrn_source_device"));
    }

    /**
     * The name of the synchrotron or other large-scale
     * experimental facility at which the experiment was
     * conducted. Names should conform to the spelling and
     * format used in the 'Light Sources of the World' listing
     * of lightsources.org
     * (https://lightsources.org/lightsources-of-the-world/)
     * @return StrColumn
     */
    public StrColumn getFacility() {
        return new DelegatingStrColumn(parentBlock.getColumn("diffrn_source_facility"));
    }

    /**
     * Generator power at which the radiation source device was operated.
     * @return FloatColumn
     */
    public FloatColumn getPower() {
        return new DelegatingFloatColumn(parentBlock.getColumn("diffrn_source_power"));
    }

    /**
     * Description of the collimated source beam as viewed from the sample.
     * @return StrColumn
     */
    public StrColumn getSize() {
        return new DelegatingStrColumn(parentBlock.getColumn("diffrn_source_size"));
    }

    /**
     * Chemical element symbol for the radiation source target (usually
     * the anode). This can be used also for spallation sources.
     * @return StrColumn
     */
    public StrColumn getTarget() {
        return new DelegatingStrColumn(parentBlock.getColumn("diffrn_source_target"));
    }

    /**
     * Generator voltage at which the radiation source device was operated.
     * @return FloatColumn
     */
    public FloatColumn getVoltage() {
        return new DelegatingFloatColumn(parentBlock.getColumn("diffrn_source_voltage"));
    }

    /**
     * The general class of the source of radiation. This is deprecated.
     * Use _diffrn_source.device and _diffrn_source.details.
     * @return StrColumn
     */
    public StrColumn getSource() {
        return new DelegatingStrColumn(parentBlock.getAliasedColumn("diffrn_source_source", "diffrn_source_description"));
    }

    /**
     * The general class of the source of radiation. This is deprecated.
     * Use _diffrn_source.device and _diffrn_source.details.
     * @return StrColumn
     */
    public StrColumn getDescription() {
        return new DelegatingStrColumn(parentBlock.getAliasedColumn("diffrn_source_source", "diffrn_source_description"));
    }

    /**
     * Description of the make, model or name of the source device.
     * Large scale facilities should use _diffrn_source.facility and
     * _diffrn_source.beamline to identify the source of radiation.
     * @return StrColumn
     */
    public StrColumn getType() {
        return new DelegatingStrColumn(parentBlock.getAliasedColumn("diffrn_source_type", "diffrn_source_make"));
    }

    /**
     * Description of the make, model or name of the source device.
     * Large scale facilities should use _diffrn_source.facility and
     * _diffrn_source.beamline to identify the source of radiation.
     * @return StrColumn
     */
    public StrColumn getMake() {
        return new DelegatingStrColumn(parentBlock.getAliasedColumn("diffrn_source_type", "diffrn_source_make"));
    }

    /**
     * The complement of the angle in degrees between the normal
     * to the surface of the X-ray tube target and the primary
     * X-ray beam for beams generated by traditional X-ray tubes.
     * @return FloatColumn
     */
    public FloatColumn getTake_offAngle() {
        return new DelegatingFloatColumn(parentBlock.getAliasedColumn("diffrn_source_take-off_angle", "diffrn_source_take_off_angle"));
    }

    /**
     * The complement of the angle in degrees between the normal
     * to the surface of the X-ray tube target and the primary
     * X-ray beam for beams generated by traditional X-ray tubes.
     * @return FloatColumn
     */
    public FloatColumn getTakeOffAngle() {
        return new DelegatingFloatColumn(parentBlock.getAliasedColumn("diffrn_source_take-off_angle", "diffrn_source_take_off_angle"));
    }

}