# Visionaire - Force the use of the system SDL library, for use with native games
# USAGE: visionaire_tweak_sdl_native
visionaire_tweak_sdl_native() {
	local path_libraries
	path_libraries=$(path_libraries_system)
	cat <<- EOF
	# Force the use of the system SDL library
	export SDL_DYNAMIC_API="${path_libraries}/libSDL2-2.0.so.0"

	EOF
}

# Visionaire - Prevent the use of wayland SDL video driver, for use with WINE games
# USAGE: visionaire_tweak_sdl_wine
visionaire_tweak_sdl_wine() {
	{
		cat <<- 'EOF'
		# Prevent the use of wayland SDL video driver
		if [ "${SDL_VIDEODRIVER:-}" = 'wayland' ]; then
		    unset SDL_VIDEODRIVER
		fi

		EOF
	} | sed --regexp-extended 's/( ){4}/\t/g'
}

