/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "OpenDRIM_LogManagesRecordAccess.h"
#include "../OpenDRIM_LogEntry/OpenDRIM_LogEntryAccess.h"
#include "../OpenDRIM_LogEntry/cmpiOpenDRIM_LogEntry.h"

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(OpenDRIM_RecordLogPackage_CIM_RecordForLog_load(broker, errorMessage));
	CF_assert(OpenDRIM_RecordLogPackage_CIM_Log_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(OpenDRIM_RecordLogPackage_CIM_RecordForLog_unload(errorMessage));
	CF_assert(OpenDRIM_RecordLogPackage_CIM_Log_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_isAssociated(const Instance& Record, const Instance& Log, bool& isAssociated, string& errorMessage) {
	_E_;
	string record_id;
	CF_assert(Record.getProperty("InstanceID", record_id));
		
	string log_id;
	CF_assert(Log.getProperty("InstanceID", log_id));
	
	if (CF_startsWith(record_id, log_id))
		isAssociated=true;
	else 
		isAssociated=false;
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_LogManagesRecord>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_enumerateRecords(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_enumerateRecords(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			Record_classnames[0], Log_classnames[0],
			Record_role.c_str(), Log_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_referenceRecordToLog(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_LogManagesRecord& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath Record_objectpath;
	instance.getRecord(Record_objectpath);
	Instance Record_instance;
	CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_getRecord(broker, ctx, Record_objectpath, Record_instance, NULL, errorMessage));
	
	Objectpath Log_objectpath;
	instance.getLog(Log_objectpath);
	Instance Log_instance;
	CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_getLog(broker, ctx, Log_objectpath, Log_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_isAssociated(Record_instance, Log_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LogManagesRecord& newInstance, const OpenDRIM_LogManagesRecord& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LogManagesRecord& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_LogManagesRecord& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_associatorRecordToLog(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Record_instance, const char** properties, vector<Instance>& Log_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */	
	/*vector<Instance> Log_instances;
	if (discriminant=="a")
		CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_enumerateLogs(broker, ctx, Log_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_enumerateLogs(broker, ctx, Log_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_enumerateLogs(broker, ctx, Log_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<Log_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_isAssociated(Record_instance, Log_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			Log_associatedInstances.push_back(Log_instances[i]);
	}*/
	string id;
	CF_assert(Record_instance.getProperty("InstanceID", id));
	string filename = id.substr(0, id.find(':'));
	
	Objectpath op(broker, "OpenDRIM_RecordLog", Log_NAMESPACE);
	op.addKey("InstanceID", filename);
	Instance record_inst(broker, op);
	if (discriminant == "a")
		CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_getLog(broker, ctx, op, record_inst, NULL, errorMessage));
	Log_associatedInstances.push_back(record_inst);	
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_associatorLogToRecord(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Log_instance, const char** properties, vector<Instance>& Record_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	/*vector<Instance> Record_instances;
	if (discriminant=="a")
		CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_enumerateRecords(broker, ctx, Record_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_enumerateRecords(broker, ctx, Record_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_enumerateRecords(broker, ctx, Record_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<Record_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_isAssociated(Record_instances[i], Log_instance, isAssociated, errorMessage));
		if (isAssociated)
			Record_associatedInstances.push_back(Record_instances[i]);
	}*/
	string filename;
	CF_assert(Log_instance.getProperty("InstanceID", filename));
	
	vector<OpenDRIM_LogEntry> result;
	string ei_discriminant = discriminant == "an" ? "ein" : "ei"; 
	CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_makeInstances(filename, result, ei_discriminant,  errorMessage));
	for (vector<OpenDRIM_LogEntry>::size_type i = 0; i < result.size(); ++i) {
		CMPIInstance* record_cmpi_inst = OpenDRIM_RecordLogPackage_OpenDRIM_LogEntry_toCMPIInstance(broker, result[i]);
		Instance record_inst(broker, record_cmpi_inst);
		Record_associatedInstances.push_back(record_inst);
	}
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_referenceRecordToLog(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Record_instance, const vector<Instance>& Log_instances, vector<OpenDRIM_LogManagesRecord>& OpenDRIM_LogManagesRecord_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < Log_instances.size(); i++) {
		OpenDRIM_LogManagesRecord instance;
		instance.setRecord(((Instance) Record_instance).getObjectpath());
		instance.setLog(((Instance) Log_instances[i]).getObjectpath());
		
		OpenDRIM_LogManagesRecord_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_referenceLogToRecord(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Log_instance, const vector<Instance>& Record_instances, vector<OpenDRIM_LogManagesRecord>& OpenDRIM_LogManagesRecord_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < Record_instances.size(); i++) {
		OpenDRIM_LogManagesRecord instance;
		instance.setRecord(((Instance) Record_instances[i]).getObjectpath());
		instance.setLog(((Instance) Log_instance).getObjectpath());
		
		OpenDRIM_LogManagesRecord_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_populate(OpenDRIM_LogManagesRecord& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

