// Code generated by protoc-gen-go. DO NOT EDIT.
// source: snapshot_service.proto

package cloud_vmm

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type OperationType int32

const (
	OperationType_NOT_SET       OperationType = 0
	OperationType_PRE_SNAPSHOT  OperationType = 1
	OperationType_POST_SNAPSHOT OperationType = 2
)

var OperationType_name = map[int32]string{
	0: "NOT_SET",
	1: "PRE_SNAPSHOT",
	2: "POST_SNAPSHOT",
}

var OperationType_value = map[string]int32{
	"NOT_SET":       0,
	"PRE_SNAPSHOT":  1,
	"POST_SNAPSHOT": 2,
}

func (x OperationType) String() string {
	return proto.EnumName(OperationType_name, int32(x))
}

func (OperationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ef5e407b8dc8e20f, []int{0}
}

type SupportedFeatures int32

const (
	SupportedFeatures_NONE      SupportedFeatures = 0
	SupportedFeatures_SNAPSHOTS SupportedFeatures = 1
)

var SupportedFeatures_name = map[int32]string{
	0: "NONE",
	1: "SNAPSHOTS",
}

var SupportedFeatures_value = map[string]int32{
	"NONE":      0,
	"SNAPSHOTS": 1,
}

func (x SupportedFeatures) String() string {
	return proto.EnumName(SupportedFeatures_name, int32(x))
}

func (SupportedFeatures) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ef5e407b8dc8e20f, []int{1}
}

type AgentErrorCode int32

const (
	AgentErrorCode_NO_ERROR AgentErrorCode = 0
	// The snapshot config was improper in some way.
	AgentErrorCode_INVALID_CONFIG AgentErrorCode = 1
	// The pre or post snapshot script was not found on disk.
	AgentErrorCode_SCRIPT_NOT_FOUND AgentErrorCode = 2
	// The pre or post snapshot script timed out.
	AgentErrorCode_SCRIPT_TIMED_OUT AgentErrorCode = 3
	// The pre or post snapshot script returned an error, but the "continue on
	// error" flag was not set.
	AgentErrorCode_UNHANDLED_SCRIPT_ERROR AgentErrorCode = 4
)

var AgentErrorCode_name = map[int32]string{
	0: "NO_ERROR",
	1: "INVALID_CONFIG",
	2: "SCRIPT_NOT_FOUND",
	3: "SCRIPT_TIMED_OUT",
	4: "UNHANDLED_SCRIPT_ERROR",
}

var AgentErrorCode_value = map[string]int32{
	"NO_ERROR":               0,
	"INVALID_CONFIG":         1,
	"SCRIPT_NOT_FOUND":       2,
	"SCRIPT_TIMED_OUT":       3,
	"UNHANDLED_SCRIPT_ERROR": 4,
}

func (x AgentErrorCode) String() string {
	return proto.EnumName(AgentErrorCode_name, int32(x))
}

func (AgentErrorCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_ef5e407b8dc8e20f, []int{2}
}

type SnapshotRequest struct {
	// The operation id of the snapshot.
	OperationId int32 `protobuf:"varint,1,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// A list of comma separated target/lun values, e.g "1/2,3/4".
	DiskList string `protobuf:"bytes,2,opt,name=disk_list,json=diskList,proto3" json:"disk_list,omitempty"`
	// The operation type.
	Type                 OperationType `protobuf:"varint,3,opt,name=type,proto3,enum=cloud.vmm.OperationType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *SnapshotRequest) Reset()         { *m = SnapshotRequest{} }
func (m *SnapshotRequest) String() string { return proto.CompactTextString(m) }
func (*SnapshotRequest) ProtoMessage()    {}
func (*SnapshotRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef5e407b8dc8e20f, []int{0}
}

func (m *SnapshotRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SnapshotRequest.Unmarshal(m, b)
}
func (m *SnapshotRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SnapshotRequest.Marshal(b, m, deterministic)
}
func (m *SnapshotRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SnapshotRequest.Merge(m, src)
}
func (m *SnapshotRequest) XXX_Size() int {
	return xxx_messageInfo_SnapshotRequest.Size(m)
}
func (m *SnapshotRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SnapshotRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SnapshotRequest proto.InternalMessageInfo

func (m *SnapshotRequest) GetOperationId() int32 {
	if m != nil {
		return m.OperationId
	}
	return 0
}

func (m *SnapshotRequest) GetDiskList() string {
	if m != nil {
		return m.DiskList
	}
	return ""
}

func (m *SnapshotRequest) GetType() OperationType {
	if m != nil {
		return m.Type
	}
	return OperationType_NOT_SET
}

type ServerInfo struct {
	SupportedFeatures    []SupportedFeatures `protobuf:"varint,1,rep,packed,name=supported_features,json=supportedFeatures,proto3,enum=cloud.vmm.SupportedFeatures" json:"supported_features,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ServerInfo) Reset()         { *m = ServerInfo{} }
func (m *ServerInfo) String() string { return proto.CompactTextString(m) }
func (*ServerInfo) ProtoMessage()    {}
func (*ServerInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef5e407b8dc8e20f, []int{1}
}

func (m *ServerInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServerInfo.Unmarshal(m, b)
}
func (m *ServerInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServerInfo.Marshal(b, m, deterministic)
}
func (m *ServerInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServerInfo.Merge(m, src)
}
func (m *ServerInfo) XXX_Size() int {
	return xxx_messageInfo_ServerInfo.Size(m)
}
func (m *ServerInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ServerInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ServerInfo proto.InternalMessageInfo

func (m *ServerInfo) GetSupportedFeatures() []SupportedFeatures {
	if m != nil {
		return m.SupportedFeatures
	}
	return nil
}

type SnapshotResponse struct {
	// The operation id of the snapshot.
	OperationId int32 `protobuf:"varint,1,opt,name=operation_id,json=operationId,proto3" json:"operation_id,omitempty"`
	// The return code of the scripts run by the guest. If this is non-zero, then
	// agent_return_code should be UNHANDLED_SCRIPT_ERROR.
	ScriptsReturnCode int32 `protobuf:"varint,2,opt,name=scripts_return_code,json=scriptsReturnCode,proto3" json:"scripts_return_code,omitempty"`
	// The agent return code.
	AgentReturnCode AgentErrorCode `protobuf:"varint,3,opt,name=agent_return_code,json=agentReturnCode,proto3,enum=cloud.vmm.AgentErrorCode" json:"agent_return_code,omitempty"`
	// The operation type.
	Type                 OperationType `protobuf:"varint,4,opt,name=type,proto3,enum=cloud.vmm.OperationType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *SnapshotResponse) Reset()         { *m = SnapshotResponse{} }
func (m *SnapshotResponse) String() string { return proto.CompactTextString(m) }
func (*SnapshotResponse) ProtoMessage()    {}
func (*SnapshotResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef5e407b8dc8e20f, []int{2}
}

func (m *SnapshotResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SnapshotResponse.Unmarshal(m, b)
}
func (m *SnapshotResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SnapshotResponse.Marshal(b, m, deterministic)
}
func (m *SnapshotResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SnapshotResponse.Merge(m, src)
}
func (m *SnapshotResponse) XXX_Size() int {
	return xxx_messageInfo_SnapshotResponse.Size(m)
}
func (m *SnapshotResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SnapshotResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SnapshotResponse proto.InternalMessageInfo

func (m *SnapshotResponse) GetOperationId() int32 {
	if m != nil {
		return m.OperationId
	}
	return 0
}

func (m *SnapshotResponse) GetScriptsReturnCode() int32 {
	if m != nil {
		return m.ScriptsReturnCode
	}
	return 0
}

func (m *SnapshotResponse) GetAgentReturnCode() AgentErrorCode {
	if m != nil {
		return m.AgentReturnCode
	}
	return AgentErrorCode_NO_ERROR
}

func (m *SnapshotResponse) GetType() OperationType {
	if m != nil {
		return m.Type
	}
	return OperationType_NOT_SET
}

type GuestReady struct {
	RequestServerInfo    bool     `protobuf:"varint,1,opt,name=request_server_info,json=requestServerInfo,proto3" json:"request_server_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GuestReady) Reset()         { *m = GuestReady{} }
func (m *GuestReady) String() string { return proto.CompactTextString(m) }
func (*GuestReady) ProtoMessage()    {}
func (*GuestReady) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef5e407b8dc8e20f, []int{3}
}

func (m *GuestReady) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GuestReady.Unmarshal(m, b)
}
func (m *GuestReady) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GuestReady.Marshal(b, m, deterministic)
}
func (m *GuestReady) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GuestReady.Merge(m, src)
}
func (m *GuestReady) XXX_Size() int {
	return xxx_messageInfo_GuestReady.Size(m)
}
func (m *GuestReady) XXX_DiscardUnknown() {
	xxx_messageInfo_GuestReady.DiscardUnknown(m)
}

var xxx_messageInfo_GuestReady proto.InternalMessageInfo

func (m *GuestReady) GetRequestServerInfo() bool {
	if m != nil {
		return m.RequestServerInfo
	}
	return false
}

type GuestMessage struct {
	// Types that are valid to be assigned to Msg:
	//	*GuestMessage_SnapshotRequest
	//	*GuestMessage_ServerInfo
	Msg                  isGuestMessage_Msg `protobuf_oneof:"msg"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *GuestMessage) Reset()         { *m = GuestMessage{} }
func (m *GuestMessage) String() string { return proto.CompactTextString(m) }
func (*GuestMessage) ProtoMessage()    {}
func (*GuestMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef5e407b8dc8e20f, []int{4}
}

func (m *GuestMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GuestMessage.Unmarshal(m, b)
}
func (m *GuestMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GuestMessage.Marshal(b, m, deterministic)
}
func (m *GuestMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GuestMessage.Merge(m, src)
}
func (m *GuestMessage) XXX_Size() int {
	return xxx_messageInfo_GuestMessage.Size(m)
}
func (m *GuestMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_GuestMessage.DiscardUnknown(m)
}

var xxx_messageInfo_GuestMessage proto.InternalMessageInfo

type isGuestMessage_Msg interface {
	isGuestMessage_Msg()
}

type GuestMessage_SnapshotRequest struct {
	SnapshotRequest *SnapshotRequest `protobuf:"bytes,1,opt,name=snapshot_request,json=snapshotRequest,proto3,oneof"`
}

type GuestMessage_ServerInfo struct {
	ServerInfo *ServerInfo `protobuf:"bytes,2,opt,name=server_info,json=serverInfo,proto3,oneof"`
}

func (*GuestMessage_SnapshotRequest) isGuestMessage_Msg() {}

func (*GuestMessage_ServerInfo) isGuestMessage_Msg() {}

func (m *GuestMessage) GetMsg() isGuestMessage_Msg {
	if m != nil {
		return m.Msg
	}
	return nil
}

func (m *GuestMessage) GetSnapshotRequest() *SnapshotRequest {
	if x, ok := m.GetMsg().(*GuestMessage_SnapshotRequest); ok {
		return x.SnapshotRequest
	}
	return nil
}

func (m *GuestMessage) GetServerInfo() *ServerInfo {
	if x, ok := m.GetMsg().(*GuestMessage_ServerInfo); ok {
		return x.ServerInfo
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GuestMessage) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GuestMessage_SnapshotRequest)(nil),
		(*GuestMessage_ServerInfo)(nil),
	}
}

type ServerAck struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServerAck) Reset()         { *m = ServerAck{} }
func (m *ServerAck) String() string { return proto.CompactTextString(m) }
func (*ServerAck) ProtoMessage()    {}
func (*ServerAck) Descriptor() ([]byte, []int) {
	return fileDescriptor_ef5e407b8dc8e20f, []int{5}
}

func (m *ServerAck) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServerAck.Unmarshal(m, b)
}
func (m *ServerAck) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServerAck.Marshal(b, m, deterministic)
}
func (m *ServerAck) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServerAck.Merge(m, src)
}
func (m *ServerAck) XXX_Size() int {
	return xxx_messageInfo_ServerAck.Size(m)
}
func (m *ServerAck) XXX_DiscardUnknown() {
	xxx_messageInfo_ServerAck.DiscardUnknown(m)
}

var xxx_messageInfo_ServerAck proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("cloud.vmm.OperationType", OperationType_name, OperationType_value)
	proto.RegisterEnum("cloud.vmm.SupportedFeatures", SupportedFeatures_name, SupportedFeatures_value)
	proto.RegisterEnum("cloud.vmm.AgentErrorCode", AgentErrorCode_name, AgentErrorCode_value)
	proto.RegisterType((*SnapshotRequest)(nil), "cloud.vmm.SnapshotRequest")
	proto.RegisterType((*ServerInfo)(nil), "cloud.vmm.ServerInfo")
	proto.RegisterType((*SnapshotResponse)(nil), "cloud.vmm.SnapshotResponse")
	proto.RegisterType((*GuestReady)(nil), "cloud.vmm.GuestReady")
	proto.RegisterType((*GuestMessage)(nil), "cloud.vmm.GuestMessage")
	proto.RegisterType((*ServerAck)(nil), "cloud.vmm.ServerAck")
}

func init() { proto.RegisterFile("snapshot_service.proto", fileDescriptor_ef5e407b8dc8e20f) }

var fileDescriptor_ef5e407b8dc8e20f = []byte{
	// 608 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x54, 0xc1, 0x6e, 0xda, 0x40,
	0x10, 0xb5, 0x81, 0xb4, 0x30, 0x10, 0xb2, 0x6c, 0xd3, 0x94, 0x92, 0x1e, 0xa8, 0x4f, 0x28, 0x8a,
	0x50, 0x45, 0x2f, 0x3d, 0xf4, 0xe2, 0x82, 0x09, 0x56, 0x13, 0x1b, 0xad, 0x9d, 0x4a, 0x3d, 0xad,
	0x5c, 0x7b, 0x93, 0x5a, 0x09, 0x5e, 0x77, 0x77, 0x89, 0x94, 0x5e, 0xfa, 0x1b, 0xfd, 0x86, 0x7e,
	0x52, 0xbf, 0xa6, 0xb2, 0x31, 0x60, 0x92, 0x1e, 0x72, 0x64, 0xe6, 0xcd, 0x63, 0xde, 0x7b, 0xb3,
	0x86, 0x23, 0x99, 0x04, 0xa9, 0xfc, 0xce, 0x15, 0x95, 0x4c, 0xdc, 0xc5, 0x21, 0x1b, 0xa6, 0x82,
	0x2b, 0x8e, 0x1b, 0xe1, 0x2d, 0x5f, 0x46, 0xc3, 0xbb, 0xc5, 0xc2, 0xf8, 0x05, 0x07, 0x5e, 0x01,
	0x22, 0xec, 0xc7, 0x92, 0x49, 0x85, 0xdf, 0x42, 0x8b, 0xa7, 0x4c, 0x04, 0x2a, 0xe6, 0x09, 0x8d,
	0xa3, 0xae, 0xde, 0xd7, 0x07, 0x7b, 0xa4, 0xb9, 0xa9, 0xd9, 0x11, 0x3e, 0x86, 0x46, 0x14, 0xcb,
	0x1b, 0x7a, 0x1b, 0x4b, 0xd5, 0xad, 0xf4, 0xf5, 0x41, 0x83, 0xd4, 0xb3, 0xc2, 0x79, 0x2c, 0x15,
	0x3e, 0x85, 0x9a, 0xba, 0x4f, 0x59, 0xb7, 0xda, 0xd7, 0x07, 0xed, 0x51, 0x77, 0xb8, 0xf9, 0xb3,
	0xa1, 0xbb, 0xa6, 0xf0, 0xef, 0x53, 0x46, 0x72, 0x94, 0xf1, 0x15, 0xc0, 0x63, 0xe2, 0x8e, 0x09,
	0x3b, 0xb9, 0xe2, 0xf8, 0x33, 0x60, 0xb9, 0x4c, 0x53, 0x2e, 0x14, 0x8b, 0xe8, 0x15, 0x0b, 0xd4,
	0x52, 0x30, 0xd9, 0xd5, 0xfb, 0xd5, 0x41, 0x7b, 0xf4, 0xa6, 0xc4, 0xe4, 0xad, 0x41, 0xd3, 0x02,
	0x43, 0x3a, 0xf2, 0x61, 0xc9, 0xf8, 0xab, 0x03, 0xda, 0x8a, 0x93, 0x29, 0x4f, 0x24, 0x7b, 0x8a,
	0xba, 0x21, 0xbc, 0x90, 0xa1, 0x88, 0x53, 0x25, 0xa9, 0x60, 0x6a, 0x29, 0x12, 0x1a, 0xf2, 0x88,
	0xe5, 0x3a, 0xf7, 0x48, 0xa7, 0x68, 0x91, 0xbc, 0x33, 0xe6, 0x11, 0xc3, 0x16, 0x74, 0x82, 0x6b,
	0x96, 0xa8, 0x1d, 0xf4, 0x4a, 0xfd, 0xeb, 0xd2, 0xce, 0x66, 0x86, 0xb1, 0x84, 0xe0, 0x22, 0x9b,
	0x22, 0x07, 0xf9, 0x4c, 0x89, 0x66, 0xed, 0x5b, 0xed, 0x49, 0xbe, 0x7d, 0x04, 0x38, 0xcb, 0xe2,
	0x22, 0x2c, 0x88, 0xee, 0xb3, 0x95, 0xc5, 0x2a, 0xbe, 0x3c, 0x6a, 0x26, 0x68, 0x9c, 0x5c, 0xf1,
	0x5c, 0x5c, 0x9d, 0x74, 0x8a, 0xd6, 0xd6, 0x67, 0xe3, 0xb7, 0x0e, 0xad, 0x7c, 0xfc, 0x82, 0x49,
	0x19, 0x5c, 0x33, 0x7c, 0x06, 0x68, 0x73, 0x2c, 0x05, 0x3c, 0x9f, 0x6e, 0x8e, 0x7a, 0x65, 0xdb,
	0x77, 0x4f, 0x65, 0xa6, 0x91, 0x03, 0xf9, 0xe0, 0x7a, 0x3e, 0x40, 0xb3, 0xbc, 0x41, 0x25, 0xe7,
	0x78, 0x59, 0xe6, 0xd8, 0x6c, 0x31, 0xd3, 0x08, 0xc8, 0xcd, 0xaf, 0x4f, 0x7b, 0x50, 0x5d, 0xc8,
	0x6b, 0xa3, 0x09, 0x8d, 0x15, 0xc4, 0x0c, 0x6f, 0x4e, 0x4c, 0xd8, 0xdf, 0x11, 0x8f, 0x9b, 0xf0,
	0xdc, 0x71, 0x7d, 0xea, 0x59, 0x3e, 0xd2, 0x30, 0x82, 0xd6, 0x9c, 0x58, 0xd4, 0x73, 0xcc, 0xb9,
	0x37, 0x73, 0x7d, 0xa4, 0xe3, 0x0e, 0xec, 0xcf, 0x5d, 0xcf, 0xdf, 0x96, 0x2a, 0x27, 0xa7, 0xd0,
	0x79, 0x74, 0x2d, 0xb8, 0x0e, 0x35, 0xc7, 0x75, 0x2c, 0xa4, 0xe1, 0x7d, 0x68, 0xac, 0xc1, 0x1e,
	0xd2, 0x4f, 0x7e, 0x42, 0x7b, 0x37, 0x27, 0xdc, 0x82, 0xba, 0xe3, 0x52, 0x8b, 0x10, 0x97, 0x20,
	0x0d, 0x63, 0x68, 0xdb, 0xce, 0x17, 0xf3, 0xdc, 0x9e, 0xd0, 0xb1, 0xeb, 0x4c, 0xed, 0x33, 0xa4,
	0xe3, 0x43, 0x40, 0xde, 0x98, 0xd8, 0x73, 0x9f, 0x66, 0xab, 0x4d, 0xdd, 0x4b, 0x67, 0x82, 0x2a,
	0xa5, 0xaa, 0x6f, 0x5f, 0x58, 0x13, 0xea, 0x5e, 0xfa, 0xa8, 0x8a, 0x7b, 0x70, 0x74, 0xe9, 0xcc,
	0x4c, 0x67, 0x72, 0x6e, 0x4d, 0x68, 0xd1, 0x5f, 0x71, 0xd7, 0x46, 0x7f, 0xf4, 0xed, 0x63, 0xf4,
	0x56, 0x0f, 0x16, 0x4f, 0x01, 0x8d, 0x05, 0x0b, 0x14, 0x1b, 0xf3, 0x24, 0x61, 0x61, 0xe6, 0x03,
	0x2e, 0xbb, 0xb9, 0xbd, 0x81, 0xde, 0xab, 0x87, 0xe5, 0x22, 0x5b, 0x43, 0x7b, 0xa7, 0x63, 0x17,
	0xba, 0xb3, 0x20, 0x89, 0x6e, 0xd9, 0xfa, 0x21, 0xc8, 0xa9, 0xe0, 0x8b, 0x1c, 0x86, 0x8f, 0xff,
	0x9b, 0xf0, 0x0a, 0xd6, 0x3b, 0x7c, 0x14, 0x9d, 0x19, 0xde, 0x18, 0xda, 0xb7, 0x67, 0xf9, 0xa7,
	0xe4, 0xfd, 0xbf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x11, 0x49, 0x78, 0xe7, 0x64, 0x04, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SnapshotServiceClient is the client API for SnapshotService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SnapshotServiceClient interface {
	// The client is expected to first send a "GuestReady" message, indicating
	// they are available and establishing the connection that vanadium writes
	// requests to the agent on.
	CreateConnection(ctx context.Context, in *GuestReady, opts ...grpc.CallOption) (SnapshotService_CreateConnectionClient, error)
	// Handles the agent's responses to the above requests.
	HandleResponsesFromGuest(ctx context.Context, in *SnapshotResponse, opts ...grpc.CallOption) (*ServerAck, error)
}

type snapshotServiceClient struct {
	cc *grpc.ClientConn
}

func NewSnapshotServiceClient(cc *grpc.ClientConn) SnapshotServiceClient {
	return &snapshotServiceClient{cc}
}

func (c *snapshotServiceClient) CreateConnection(ctx context.Context, in *GuestReady, opts ...grpc.CallOption) (SnapshotService_CreateConnectionClient, error) {
	stream, err := c.cc.NewStream(ctx, &_SnapshotService_serviceDesc.Streams[0], "/cloud.vmm.SnapshotService/CreateConnection", opts...)
	if err != nil {
		return nil, err
	}
	x := &snapshotServiceCreateConnectionClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type SnapshotService_CreateConnectionClient interface {
	Recv() (*GuestMessage, error)
	grpc.ClientStream
}

type snapshotServiceCreateConnectionClient struct {
	grpc.ClientStream
}

func (x *snapshotServiceCreateConnectionClient) Recv() (*GuestMessage, error) {
	m := new(GuestMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *snapshotServiceClient) HandleResponsesFromGuest(ctx context.Context, in *SnapshotResponse, opts ...grpc.CallOption) (*ServerAck, error) {
	out := new(ServerAck)
	err := c.cc.Invoke(ctx, "/cloud.vmm.SnapshotService/HandleResponsesFromGuest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SnapshotServiceServer is the server API for SnapshotService service.
type SnapshotServiceServer interface {
	// The client is expected to first send a "GuestReady" message, indicating
	// they are available and establishing the connection that vanadium writes
	// requests to the agent on.
	CreateConnection(*GuestReady, SnapshotService_CreateConnectionServer) error
	// Handles the agent's responses to the above requests.
	HandleResponsesFromGuest(context.Context, *SnapshotResponse) (*ServerAck, error)
}

// UnimplementedSnapshotServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSnapshotServiceServer struct {
}

func (*UnimplementedSnapshotServiceServer) CreateConnection(req *GuestReady, srv SnapshotService_CreateConnectionServer) error {
	return status.Errorf(codes.Unimplemented, "method CreateConnection not implemented")
}
func (*UnimplementedSnapshotServiceServer) HandleResponsesFromGuest(ctx context.Context, req *SnapshotResponse) (*ServerAck, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleResponsesFromGuest not implemented")
}

func RegisterSnapshotServiceServer(s *grpc.Server, srv SnapshotServiceServer) {
	s.RegisterService(&_SnapshotService_serviceDesc, srv)
}

func _SnapshotService_CreateConnection_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GuestReady)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SnapshotServiceServer).CreateConnection(m, &snapshotServiceCreateConnectionServer{stream})
}

type SnapshotService_CreateConnectionServer interface {
	Send(*GuestMessage) error
	grpc.ServerStream
}

type snapshotServiceCreateConnectionServer struct {
	grpc.ServerStream
}

func (x *snapshotServiceCreateConnectionServer) Send(m *GuestMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _SnapshotService_HandleResponsesFromGuest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SnapshotResponse)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SnapshotServiceServer).HandleResponsesFromGuest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cloud.vmm.SnapshotService/HandleResponsesFromGuest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SnapshotServiceServer).HandleResponsesFromGuest(ctx, req.(*SnapshotResponse))
	}
	return interceptor(ctx, in, info, handler)
}

var _SnapshotService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cloud.vmm.SnapshotService",
	HandlerType: (*SnapshotServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleResponsesFromGuest",
			Handler:    _SnapshotService_HandleResponsesFromGuest_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "CreateConnection",
			Handler:       _SnapshotService_CreateConnection_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "snapshot_service.proto",
}
