// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Texture, ffi};
use glib::{prelude::*, translate::*};

glib::wrapper! {
    #[doc(alias = "GdkCursor")]
    pub struct Cursor(Object<ffi::GdkCursor>);

    match fn {
        type_ => || ffi::gdk_cursor_get_type(),
    }
}

impl Cursor {
    #[doc(alias = "gdk_cursor_new_from_name")]
    #[doc(alias = "new_from_name")]
    pub fn from_name(name: &str, fallback: Option<&Cursor>) -> Option<Cursor> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gdk_cursor_new_from_name(
                name.to_glib_none().0,
                fallback.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gdk_cursor_new_from_texture")]
    #[doc(alias = "new_from_texture")]
    pub fn from_texture(
        texture: &impl IsA<Texture>,
        hotspot_x: i32,
        hotspot_y: i32,
        fallback: Option<&Cursor>,
    ) -> Cursor {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gdk_cursor_new_from_texture(
                texture.as_ref().to_glib_none().0,
                hotspot_x,
                hotspot_y,
                fallback.to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Cursor`] objects.
    ///
    /// This method returns an instance of [`CursorBuilder`](crate::builders::CursorBuilder) which can be used to create [`Cursor`] objects.
    pub fn builder() -> CursorBuilder {
        CursorBuilder::new()
    }

    #[doc(alias = "gdk_cursor_get_fallback")]
    #[doc(alias = "get_fallback")]
    #[must_use]
    pub fn fallback(&self) -> Option<Cursor> {
        unsafe { from_glib_none(ffi::gdk_cursor_get_fallback(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_cursor_get_hotspot_x")]
    #[doc(alias = "get_hotspot_x")]
    #[doc(alias = "hotspot-x")]
    pub fn hotspot_x(&self) -> i32 {
        unsafe { ffi::gdk_cursor_get_hotspot_x(self.to_glib_none().0) }
    }

    #[doc(alias = "gdk_cursor_get_hotspot_y")]
    #[doc(alias = "get_hotspot_y")]
    #[doc(alias = "hotspot-y")]
    pub fn hotspot_y(&self) -> i32 {
        unsafe { ffi::gdk_cursor_get_hotspot_y(self.to_glib_none().0) }
    }

    #[doc(alias = "gdk_cursor_get_name")]
    #[doc(alias = "get_name")]
    pub fn name(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gdk_cursor_get_name(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_cursor_get_texture")]
    #[doc(alias = "get_texture")]
    pub fn texture(&self) -> Option<Texture> {
        unsafe { from_glib_none(ffi::gdk_cursor_get_texture(self.to_glib_none().0)) }
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Cursor`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct CursorBuilder {
    builder: glib::object::ObjectBuilder<'static, Cursor>,
}

impl CursorBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn fallback(self, fallback: &Cursor) -> Self {
        Self {
            builder: self.builder.property("fallback", fallback.clone()),
        }
    }

    pub fn hotspot_x(self, hotspot_x: i32) -> Self {
        Self {
            builder: self.builder.property("hotspot-x", hotspot_x),
        }
    }

    pub fn hotspot_y(self, hotspot_y: i32) -> Self {
        Self {
            builder: self.builder.property("hotspot-y", hotspot_y),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn texture(self, texture: &impl IsA<Texture>) -> Self {
        Self {
            builder: self.builder.property("texture", texture.clone().upcast()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Cursor`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Cursor {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
