/*
 *  Copyright (C) 2011 Sourcefire, Inc.
 *
 *  Author: Török Edvin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 */

#include "cltypes.h"
struct arc4_state {
    /* really just 8 bit, but it is faster if reads are aligned */
    uint32_t S[256];
    uint8_t i, j;
};

void arc4_init(struct arc4_state *a, const uint8_t *key, unsigned keylength);
void arc4_apply(struct arc4_state *s, uint8_t *data, unsigned len);
