---
title: Object is not an Class Error
---

# Object is not an Class Error

## Description

This error is thrown when applying `@strawberry.type/interface/input` to a
non-class object, for example the following code will throw this error:

```python
import strawberry


@strawberry.type
def a_function(): ...


@strawberry.type
class Query:
    field: a_function


schema = strawberry.Schema(query=Query)
```

This happens because Strawberry expects all enums to be subclasses of `Enum`.

## How to fix this error

You can fix this error by making sure the class you're applying
`@strawberry.type/interface/input` to is a class. For example, the following
code will fix this error:

```python
import strawberry


@strawberry.type
class AFunction:
    field: int


@strawberry.type
class Query:
    field: AFunction


schema = strawberry.Schema(query=Query)
```
