% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups-with.R
\name{with_groups}
\alias{with_groups}
\title{Perform an operation with temporary groups}
\usage{
with_groups(.data, .groups, .f, ...)
}
\arguments{
\item{.data}{A data frame}

\item{.groups}{<\code{\link[=dplyr_tidy_select]{tidy-select}}> One or more variables
to group by. Unlike \code{\link[=group_by]{group_by()}}, you can only group by existing variables,
and you can use tidy-select syntax like \code{c(x, y, z)} to select multiple
variables.

Use \code{NULL} to temporarily \strong{un}group.}

\item{.f}{Function to apply to regrouped data.
Supports purrr-style \code{~} syntax}

\item{...}{Additional arguments passed on to \code{...}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

This was an experimental function that allows you to modify the grouping
variables for a single operation; it is superseded in favour of using the
\code{.by} argument to individual verbs.
}
\examples{
df <- tibble(g = c(1, 1, 2, 2, 3), x = runif(5))

# Old
df |>
  with_groups(g, mutate, x_mean = mean(x))
# New
df |> mutate(x_mean = mean(x), .by = g)
}
\keyword{internal}
