# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerservicefleet.aio import ContainerServiceFleetMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerServiceFleetMgmtFleetMembersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerServiceFleetMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_fleet_members_get(self, resource_group):
        response = await self.client.fleet_members.get(
            resource_group_name=resource_group.name,
            fleet_name="str",
            fleet_member_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_fleet_members_begin_create(self, resource_group):
        response = await (
            await self.client.fleet_members.begin_create(
                resource_group_name=resource_group.name,
                fleet_name="str",
                fleet_member_name="str",
                resource={
                    "eTag": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "clusterResourceId": "str",
                        "group": "str",
                        "labels": {"str": "str"},
                        "provisioningState": "str",
                        "status": {
                            "lastOperationError": {
                                "additionalInfo": [{"info": {}, "type": "str"}],
                                "code": "str",
                                "details": [...],
                                "message": "str",
                                "target": "str",
                            },
                            "lastOperationId": "str",
                        },
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_fleet_members_begin_update(self, resource_group):
        response = await (
            await self.client.fleet_members.begin_update(
                resource_group_name=resource_group.name,
                fleet_name="str",
                fleet_member_name="str",
                properties={"properties": {"group": "str", "labels": {"str": "str"}}},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_fleet_members_begin_delete(self, resource_group):
        response = await (
            await self.client.fleet_members.begin_delete(
                resource_group_name=resource_group.name,
                fleet_name="str",
                fleet_member_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_fleet_members_list_by_fleet(self, resource_group):
        response = self.client.fleet_members.list_by_fleet(
            resource_group_name=resource_group.name,
            fleet_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
