# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AadConnectivityStateEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The connectivity state of the external AAD solution."""

    DISCOVERED = "Discovered"
    NOT_LICENSED = "NotLicensed"
    CONNECTED = "Connected"


class ActionableRemediationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ActionableRemediation Setting.
    None - the setting was never set.
    Enabled - ActionableRemediation is enabled.
    Disabled - ActionableRemediation is disabled.
    """

    NONE = "None"
    DISABLED = "Disabled"
    ENABLED = "Enabled"


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"
    LOGIC_APP = "LogicApp"
    EVENT_HUB = "EventHub"
    WORKSPACE = "Workspace"


class AdditionalWorkspaceDataType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Data types sent to workspace."""

    ALERTS = "Alerts"
    RAW_EVENTS = "RawEvents"


class AdditionalWorkspaceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Workspace type."""

    SENTINEL = "Sentinel"


class AgentlessEnablement(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Agentless Enablement states."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"
    NOT_APPLICABLE = "NotApplicable"


class AlertSeverity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The risk level of the threat that was detected. Learn more:
    https://docs.microsoft.com/en-us/azure/security-center/security-center-alerts-overview#how-are-alerts-classified.
    """

    INFORMATIONAL = "Informational"
    """Informational"""
    LOW = "Low"
    """Low"""
    MEDIUM = "Medium"
    """Medium"""
    HIGH = "High"
    """High"""


class AlertStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The life cycle status of the alert."""

    ACTIVE = "Active"
    """An alert which doesn't specify a value is assigned the status 'Active'"""
    IN_PROGRESS = "InProgress"
    """An alert which is in handling state"""
    RESOLVED = "Resolved"
    """Alert closed after handling"""
    DISMISSED = "Dismissed"
    """Alert dismissed as false positive"""


class AnnotateDefaultBranchState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Configuration of PR Annotations on default branch.

    Enabled - PR Annotations are enabled on the resource's default branch.
    Disabled - PR Annotations are disabled on the resource's default branch.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class ApplicationConditionOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The application Condition's Operator, for example Contains for id or In for list of possible
    IDs, see examples.
    """

    CONTAINS = "Contains"
    """Checks that the string value of the data defined in Property contains the given value"""
    EQUALS = "Equals"
    """Checks that the string value of the data defined in Property equals the given value"""
    IN = "In"
    """Checks that the string value of the data defined in Property equals any of the given values
    (exact fit)"""
    IN_ENUM = "In"
    """Checks that the string value of the data defined in Property equals any of the given values
    (exact fit)"""


class ApplicationSourceResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The application source, what it affects, e.g. Assessments."""

    ASSESSMENTS = "Assessments"
    """The source of the application is assessments"""


class AssessedResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sub-assessment resource type."""

    SQL_SERVER_VULNERABILITY = "SqlServerVulnerability"
    CONTAINER_REGISTRY_VULNERABILITY = "ContainerRegistryVulnerability"
    SERVER_VULNERABILITY = "ServerVulnerability"


class AssessmentStatusCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Programmatic code for the status of the assessment."""

    HEALTHY = "Healthy"
    """The resource is healthy"""
    UNHEALTHY = "Unhealthy"
    """The resource has a security issue that needs to be addressed"""
    NOT_APPLICABLE = "NotApplicable"
    """Assessment for this resource did not happen"""


class AssessmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment
    based on custom Azure Policy definition.
    """

    BUILT_IN = "BuiltIn"
    """Microsoft Defender for Cloud managed assessments"""
    CUSTOM_POLICY = "CustomPolicy"
    """User defined policies that are automatically ingested from Azure Policy to Microsoft Defender
    for Cloud"""
    CUSTOMER_MANAGED = "CustomerManaged"
    """User assessments pushed directly by the user or other third party to Microsoft Defender for
    Cloud"""
    BUILT_IN_POLICY = "BuiltInPolicy"
    """Microsoft Defender for Cloud managed policies"""
    VERIFIED_PARTNER = "VerifiedPartner"
    """Third party assessments that are verified by Microsoft Defender for Cloud"""
    MANUAL_BUILT_IN_POLICY = "ManualBuiltInPolicy"
    """Microsoft Defender for Cloud managed policies that are manually created by the user"""
    MANUAL_BUILT_IN = "ManualBuiltIn"
    """Microsoft Defender for Cloud managed assessments that are manually created by the user"""
    MANUAL_CUSTOM_POLICY = "ManualCustomPolicy"
    """User defined policies that are manually created by the user"""
    DYNAMIC_BUILT_IN = "DynamicBuiltIn"
    """Microsoft Defender for Cloud managed assessments that are dynamically created by the system"""


class AttestationComplianceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Attest category of this assignment."""

    UNKNOWN = "unknown"
    COMPLIANT = "compliant"
    NON_COMPLIANT = "nonCompliant"


class AuthenticationProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of the multi-cloud connector."""

    VALID = "Valid"
    """Valid connector"""
    INVALID = "Invalid"
    """Invalid connector"""
    EXPIRED = "Expired"
    """the connection has expired"""
    INCORRECT_POLICY = "IncorrectPolicy"
    """Incorrect policy of the connector"""


class AuthenticationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Connect to your cloud account, for AWS use either account credentials or role-based
    authentication. For GCP use account organization credentials.
    """

    AWS_CREDS = "awsCreds"
    """AWS cloud account connector user credentials authentication"""
    AWS_ASSUME_ROLE = "awsAssumeRole"
    """AWS account connector assume role authentication"""
    GCP_CREDENTIALS = "gcpCredentials"
    """GCP account connector service to service authentication"""


class AutoDiscovery(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AutoDiscovery states."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"
    NOT_APPLICABLE = "NotApplicable"


class AutoProvision(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes what kind of security agent provisioning action to take."""

    ON = "On"
    """Install missing security agent on VMs automatically"""
    OFF = "Off"
    """Do not install security agent on the VMs automatically"""


class BlobScanResultsOptions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Optional. Write scan result on blobIndexTags by default."""

    BLOB_INDEX_TAGS = "blobIndexTags"
    """Write scan results on the blobs index tags."""
    NONE = "None"
    """Do not write scan results on the blobs index tags."""


class BundleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Alert Simulator supported bundles."""

    APP_SERVICES = "AppServices"
    DNS = "DNS"
    KEY_VAULTS = "KeyVaults"
    KUBERNETES_SERVICE = "KubernetesService"
    RESOURCE_MANAGER = "ResourceManager"
    SQL_SERVERS = "SqlServers"
    STORAGE_ACCOUNTS = "StorageAccounts"
    VIRTUAL_MACHINES = "VirtualMachines"
    COSMOS_DBS = "CosmosDbs"


class Categories(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The categories of resource that is at risk when the assessment is unhealthy."""

    COMPUTE = "Compute"
    NETWORKING = "Networking"
    DATA = "Data"
    IDENTITY_AND_ACCESS = "IdentityAndAccess"
    IO_T = "IoT"
    CONTAINER = "Container"
    APP_SERVICES = "AppServices"


class CloudName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The multi cloud resource's cloud name."""

    AZURE = "Azure"
    AWS = "AWS"
    GCP = "GCP"
    GITHUB = "Github"
    AZURE_DEV_OPS = "AzureDevOps"
    GIT_LAB = "GitLab"
    DOCKER_HUB = "DockerHub"
    J_FROG = "JFrog"


class Code(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operation status code."""

    SUCCEEDED = "Succeeded"
    """Extension was created/updated successfully."""
    FAILED = "Failed"
    """Extension was not created/updated successfully. See operation status message for more details."""


class ConnectionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ConnectionType."""

    INTERNAL = "Internal"
    EXTERNAL = "External"


class ControlType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of security control (for example, BuiltIn)."""

    BUILT_IN = "BuiltIn"
    """Microsoft Defender for Cloud managed assessments"""
    CUSTOM = "Custom"
    """Non Microsoft Defender for Cloud managed assessments"""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DataSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DataSource."""

    TWIN_DATA = "TwinData"
    """Devices twin data"""


class DesiredOnboardingState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Onboarding states."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class DevOpsProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the resource.

    Pending - Provisioning pending.
    Failed - Provisioning failed.
    Succeeded - Successful provisioning.
    Canceled - Provisioning canceled.
    PendingDeletion - Deletion pending.
    DeletionSuccess - Deletion successful.
    DeletionFailure - Deletion failure.
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PENDING = "Pending"
    PENDING_DELETION = "PendingDeletion"
    DELETION_SUCCESS = "DeletionSuccess"
    DELETION_FAILURE = "DeletionFailure"


class Effect(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Expected effect of this assignment (Audit/Exempt/Attest)."""

    AUDIT = "Audit"
    EXEMPT = "Exempt"
    ATTEST = "Attest"


class EndOfSupportStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """End of support status."""

    NONE = "None"
    NO_LONGER_SUPPORTED = "noLongerSupported"
    VERSION_NO_LONGER_SUPPORTED = "versionNoLongerSupported"
    UPCOMING_NO_LONGER_SUPPORTED = "upcomingNoLongerSupported"
    UPCOMING_VERSION_NO_LONGER_SUPPORTED = "upcomingVersionNoLongerSupported"


class Enforce(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """If set to "False", it allows the descendants of this scope to override the pricing
    configuration set on this scope (allows setting inherited="False"). If set to "True", it
    prevents overrides and forces this pricing configuration on all the descendants of this scope.
    This field is only available for subscription-level pricing.
    """

    FALSE = "False"
    """Allows the descendants of this scope to override the pricing configuration set on this scope
    (allows setting inherited="False")"""
    TRUE = "True"
    """Prevents overrides and forces the current scope's pricing configuration to all descendants"""


class EnvironmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the environment data."""

    AWS_ACCOUNT = "AwsAccount"
    GCP_PROJECT = "GcpProject"
    GITHUB_SCOPE = "GithubScope"
    AZURE_DEV_OPS_SCOPE = "AzureDevOpsScope"
    GITLAB_SCOPE = "GitlabScope"
    DOCKER_HUB_ORGANIZATION = "DockerHubOrganization"
    J_FROG_ARTIFACTORY = "JFrogArtifactory"


class EventSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A valid event source type."""

    ASSESSMENTS = "Assessments"
    ASSESSMENTS_SNAPSHOT = "AssessmentsSnapshot"
    SUB_ASSESSMENTS = "SubAssessments"
    SUB_ASSESSMENTS_SNAPSHOT = "SubAssessmentsSnapshot"
    ALERTS = "Alerts"
    SECURE_SCORES = "SecureScores"
    SECURE_SCORES_SNAPSHOT = "SecureScoresSnapshot"
    SECURE_SCORE_CONTROLS = "SecureScoreControls"
    SECURE_SCORE_CONTROLS_SNAPSHOT = "SecureScoreControlsSnapshot"
    REGULATORY_COMPLIANCE_ASSESSMENT = "RegulatoryComplianceAssessment"
    REGULATORY_COMPLIANCE_ASSESSMENT_SNAPSHOT = "RegulatoryComplianceAssessmentSnapshot"
    ATTACK_PATHS = "AttackPaths"
    ATTACK_PATHS_SNAPSHOT = "AttackPathsSnapshot"


class ExemptionCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Exemption category of this assignment."""

    WAIVER = "waiver"
    MITIGATED = "mitigated"


class ExpandControlsEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ExpandControlsEnum."""

    DEFINITION = "definition"
    """Add definition object for each control"""


class ExpandEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ExpandEnum."""

    LINKS = "links"
    """All links associated with an assessment"""
    METADATA = "metadata"
    """Assessment metadata"""


class ExportData(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ExportData."""

    RAW_EVENTS = "RawEvents"
    """Agent raw events"""


class ExternalSecuritySolutionKindEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the external solution."""

    CEF = "CEF"
    ATA = "ATA"
    AAD = "AAD"


class GovernanceRuleConditionOperator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The governance rule Condition's Operator, for example Equals for severity or In for list of
    assessments, see examples.
    """

    EQUALS = "Equals"
    """Checks that the string value of the data defined in Property equals the given value - exact fit"""
    IN = "In"
    """Checks that the string value of the data defined in Property equals any of the given values
    (exact fit)"""
    IN_ENUM = "In"
    """Checks that the string value of the data defined in Property equals any of the given values
    (exact fit)"""


class GovernanceRuleOwnerSourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The owner type for the governance rule owner source."""

    BY_TAG = "ByTag"
    """The rule source type defined using resource tag"""
    MANUALLY = "Manually"
    """The rule source type defined manually"""


class GovernanceRuleSourceResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The governance rule source, what the rule affects, e.g. Assessments."""

    ASSESSMENTS = "Assessments"
    """The source of the governance rule is assessments"""


class GovernanceRuleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The rule type of the governance rule, defines the source of the rule e.g. Integrated."""

    INTEGRATED = "Integrated"
    """The source of the rule type definition is integrated"""
    SERVICE_NOW = "ServiceNow"
    """The source of the rule type definition is ServiceNow"""


class HybridComputeProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of the service principal and its secret."""

    VALID = "Valid"
    """Valid service principal details."""
    INVALID = "Invalid"
    """Invalid service principal details."""
    EXPIRED = "Expired"
    """the service principal details are expired"""


class ImplementationEffort(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The implementation effort required to remediate this assessment."""

    LOW = "Low"
    MODERATE = "Moderate"
    HIGH = "High"


class InformationProtectionPolicyName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """InformationProtectionPolicyName."""

    EFFECTIVE = "effective"
    CUSTOM = "custom"


class Inherited(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ "inherited" = "True" indicates that the current scope inherits its pricing configuration from
    its parent. The ID of the parent scope that provides the inherited configuration is displayed
    in the "inheritedFrom" field. On the other hand, "inherited" = "False" indicates that the
    current scope has its own pricing configuration explicitly set, and does not inherit from its
    parent. This field is read only and available only for resource-level pricing.
    """

    TRUE = "True"
    """Indicates that the current scope is inheriting its pricing configuration from its parent"""
    FALSE = "False"
    """Indicates that the current scope sets its own pricing configuration and does not inherit it
    from its parent"""


class InheritFromParentState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Update Settings.

    Enabled - Resource should inherit configurations from parent.
    Disabled - Resource should not inherit configurations from parent.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class Intent(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kill chain related intent behind the alert. For list of supported values, and explanations
    of Azure Security Center's supported kill chain intents.
    """

    UNKNOWN = "Unknown"
    """Unknown"""
    PRE_ATTACK = "PreAttack"
    """PreAttack could be either an attempt to access a certain resource regardless of a malicious
    intent, or a failed attempt to gain access to a target system to gather information prior to
    exploitation. This step is usually detected as an attempt, originating from outside the
    network, to scan the target system and find a way in.  Further details on the PreAttack stage
    can be read in `MITRE Pre-Att&ck matrix <https://attack.mitre.org/matrices/pre/>`_."""
    INITIAL_ACCESS = "InitialAccess"
    """InitialAccess is the stage where an attacker manages to get foothold on the attacked resource."""
    PERSISTENCE = "Persistence"
    """Persistence is any access, action, or configuration change to a system that gives a threat
    actor a persistent presence on that system."""
    PRIVILEGE_ESCALATION = "PrivilegeEscalation"
    """Privilege escalation is the result of actions that allow an adversary to obtain a higher level
    of permissions on a system or network."""
    DEFENSE_EVASION = "DefenseEvasion"
    """Defense evasion consists of techniques an adversary may use to evade detection or avoid other
    defenses."""
    CREDENTIAL_ACCESS = "CredentialAccess"
    """Credential access represents techniques resulting in access to or control over system, domain,
    or service credentials that are used within an enterprise environment."""
    DISCOVERY = "Discovery"
    """Discovery consists of techniques that allow the adversary to gain knowledge about the system
    and internal network."""
    LATERAL_MOVEMENT = "LateralMovement"
    """Lateral movement consists of techniques that enable an adversary to access and control remote
    systems on a network and could, but does not necessarily, include execution of tools on remote
    systems."""
    EXECUTION = "Execution"
    """The execution tactic represents techniques that result in execution of adversary-controlled
    code on a local or remote system."""
    COLLECTION = "Collection"
    """Collection consists of techniques used to identify and gather information, such as sensitive
    files, from a target network prior to exfiltration."""
    EXFILTRATION = "Exfiltration"
    """Exfiltration refers to techniques and attributes that result or aid in the adversary removing
    files and information from a target network."""
    COMMAND_AND_CONTROL = "CommandAndControl"
    """The command and control tactic represents how adversaries communicate with systems under their
    control within a target network."""
    IMPACT = "Impact"
    """Impact events primarily try to directly reduce the availability or integrity of a system,
    service, or network; including manipulation of data to impact a business or operational
    process."""
    PROBING = "Probing"
    """Probing could be either an attempt to access a certain resource regardless of a malicious
    intent, or a failed attempt to gain access to a target system to gather information prior to
    exploitation."""
    EXPLOITATION = "Exploitation"
    """Exploitation is the stage where an attacker manages to get a foothold on the attacked resource.
    This stage is relevant for compute hosts and resources such as user accounts, certificates etc."""


class InventoryKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Types for inventory kind."""

    AZURE_DEV_OPS_ORGANIZATION = "AzureDevOpsOrganization"
    AZURE_DEV_OPS_PROJECT = "AzureDevOpsProject"
    AZURE_DEV_OPS_REPOSITORY = "AzureDevOpsRepository"
    GIT_HUB_OWNER = "GitHubOwner"
    GIT_HUB_REPOSITORY = "GitHubRepository"


class InventoryListKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Types for inventory list."""

    INCLUSION = "Inclusion"
    EXCLUSION = "Exclusion"


class IsEnabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether the extension is enabled."""

    TRUE = "True"
    """Indicates the extension is enabled"""
    FALSE = "False"
    """Indicates the extension is disabled"""


class KindEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of alert simulation."""

    BUNDLES = "Bundles"
    """Simulate alerts according to bundles"""


class MinimalRiskLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the minimal attack path risk level which will be sent as email notifications."""

    CRITICAL = "Critical"
    """Get notifications on new attack paths with Critical risk level"""
    HIGH = "High"
    """Get notifications on new attack paths with High or Critical risk level"""
    MEDIUM = "Medium"
    """Get notifications on new attach paths with Medium, High or Critical risk level"""
    LOW = "Low"
    """Get notifications on new attach paths with Low, Medium, High or Critical risk level"""


class MinimalSeverity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the minimal alert severity which will be sent as email notifications."""

    HIGH = "High"
    """Get notifications on new alerts with High severity"""
    MEDIUM = "Medium"
    """Get notifications on new alerts with Medium or High severity"""
    LOW = "Low"
    """Get notifications on new alerts with Low, Medium or High severity"""


class MipIntegrationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Microsoft information protection integration status."""

    OK = "Ok"
    NO_CONSENT = "noConsent"
    NO_AUTO_LABELING_RULES = "noAutoLabelingRules"
    NO_MIP_LABELS = "noMipLabels"


class OfferingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the security offering."""

    CSPM_MONITOR_AWS = "CspmMonitorAws"
    DEFENDER_FOR_CONTAINERS_AWS = "DefenderForContainersAws"
    DEFENDER_FOR_SERVERS_AWS = "DefenderForServersAws"
    DEFENDER_FOR_DATABASES_AWS = "DefenderForDatabasesAws"
    CSPM_MONITOR_GCP = "CspmMonitorGcp"
    CSPM_MONITOR_GITHUB = "CspmMonitorGithub"
    CSPM_MONITOR_AZURE_DEV_OPS = "CspmMonitorAzureDevOps"
    DEFENDER_FOR_SERVERS_GCP = "DefenderForServersGcp"
    DEFENDER_FOR_CONTAINERS_GCP = "DefenderForContainersGcp"
    DEFENDER_FOR_DATABASES_GCP = "DefenderForDatabasesGcp"
    DEFENDER_CSPM_AWS = "DefenderCspmAws"
    DEFENDER_CSPM_GCP = "DefenderCspmGcp"
    CSPM_MONITOR_GIT_LAB = "CspmMonitorGitLab"
    CSPM_MONITOR_DOCKER_HUB = "CspmMonitorDockerHub"
    DEFENDER_FOR_CONTAINERS_DOCKER_HUB = "DefenderForContainersDockerHub"
    DEFENDER_CSPM_DOCKER_HUB = "DefenderCspmDockerHub"
    CSPM_MONITOR_J_FROG = "CspmMonitorJFrog"
    DEFENDER_FOR_CONTAINERS_J_FROG = "DefenderForContainersJFrog"
    DEFENDER_CSPM_J_FROG = "DefenderCspmJFrog"


class OnboardingState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Details about resource onboarding status across all connectors.

    OnboardedByOtherConnector - this resource has already been onboarded to another connector. This
    is only applicable to top-level resources.
    Onboarded - this resource has already been onboarded by the specified connector.
    NotOnboarded - this resource has not been onboarded to any connector.
    NotApplicable - the onboarding state is not applicable to the current endpoint.
    """

    NOT_APPLICABLE = "NotApplicable"
    ONBOARDED_BY_OTHER_CONNECTOR = "OnboardedByOtherConnector"
    ONBOARDED = "Onboarded"
    NOT_ONBOARDED = "NotOnboarded"


class OperationResult(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the long run operation result of governance rule."""

    SUCCEEDED = "Succeeded"
    """The operation succeeded"""
    FAILED = "Failed"
    """The operation failed"""
    CANCELED = "Canceled"
    """The operation canceled"""


class Operator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A valid comparer operator to use. A case-insensitive comparison will be applied for String
    PropertyType.
    """

    EQUALS = "Equals"
    """Applies for decimal and non-decimal operands"""
    GREATER_THAN = "GreaterThan"
    """Applies only for decimal operands"""
    GREATER_THAN_OR_EQUAL_TO = "GreaterThanOrEqualTo"
    """Applies only for decimal operands"""
    LESSER_THAN = "LesserThan"
    """Applies only for decimal operands"""
    LESSER_THAN_OR_EQUAL_TO = "LesserThanOrEqualTo"
    """Applies only for decimal operands"""
    NOT_EQUALS = "NotEquals"
    """Applies  for decimal and non-decimal operands"""
    CONTAINS = "Contains"
    """Applies only for non-decimal operands"""
    STARTS_WITH = "StartsWith"
    """Applies only for non-decimal operands"""
    ENDS_WITH = "EndsWith"
    """Applies only for non-decimal operands"""


class OrganizationMembershipType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The multi cloud account's membership type in the organization."""

    MEMBER = "Member"
    ORGANIZATION = "Organization"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class PermissionProperty(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A permission detected in the cloud account."""

    AWS_AWS_SECURITY_HUB_READ_ONLY_ACCESS = "AWS::AWSSecurityHubReadOnlyAccess"
    """This permission provides read only access to AWS Security Hub resources."""
    AWS_SECURITY_AUDIT = "AWS::SecurityAudit"
    """This permission grants access to read security configuration metadata."""
    AWS_AMAZON_SSM_AUTOMATION_ROLE = "AWS::AmazonSSMAutomationRole"
    """The permission provides for EC2 Automation service to execute activities defined within
    Automation documents."""
    GCP_SECURITY_CENTER_ADMIN_VIEWER = "GCP::Security Center Admin Viewer"
    """This permission provides read only access to GCP Security Command Center."""


class PricingTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether the Defender plan is enabled on the selected scope. Microsoft Defender for
    Cloud is provided in two pricing tiers: free and standard. The standard tier offers advanced
    security capabilities, while the free tier offers basic security features.
    """

    FREE = "Free"
    """Get free Microsoft Defender for Cloud experience with basic security features"""
    STANDARD = "Standard"
    """Get the standard Microsoft Defender for Cloud experience with advanced security features"""


class PrivateEndpointConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    DELETING = "Deleting"
    FAILED = "Failed"


class PrivateEndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private endpoint connection status."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"


class PropertyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The data type of the compared operands (string, integer, floating point number or a boolean
    [true/false]].
    """

    STRING = "String"
    INTEGER = "Integer"
    NUMBER = "Number"
    BOOLEAN = "Boolean"


class ProtocolEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ProtocolEnum."""

    TCP = "TCP"
    UDP = "UDP"
    ALL = "*"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The security family provisioning State."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    UPDATING = "Updating"


class Rank(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The rank of the sensitivity label."""

    NONE = "None"
    LOW = "Low"
    MEDIUM = "Medium"
    HIGH = "High"
    CRITICAL = "Critical"


class RecommendationConfigStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Recommendation status. When the recommendation status is disabled recommendations are not
    generated.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class RecommendationSupportedClouds(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The cloud that the recommendation is supported on."""

    AZURE = "Azure"
    AWS = "AWS"
    GCP = "GCP"


class RecommendationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of IoT Security recommendation."""

    IO_T_ACRAUTHENTICATION = "IoT_ACRAuthentication"
    """Authentication schema used for pull an edge module from an ACR repository does not use Service
    Principal Authentication."""
    IO_T_AGENT_SENDS_UNUTILIZED_MESSAGES = "IoT_AgentSendsUnutilizedMessages"
    """IoT agent message size capacity is currently underutilized, causing an increase in the number
    of sent messages. Adjust message intervals for better utilization."""
    IO_T_BASELINE = "IoT_Baseline"
    """Identified security related system configuration issues."""
    IO_T_EDGE_HUB_MEM_OPTIMIZE = "IoT_EdgeHubMemOptimize"
    """You can optimize Edge Hub memory usage by turning off protocol heads for any protocols not used
    by Edge modules in your solution."""
    IO_T_EDGE_LOGGING_OPTIONS = "IoT_EdgeLoggingOptions"
    """Logging is disabled for this edge module."""
    IO_T_INCONSISTENT_MODULE_SETTINGS = "IoT_InconsistentModuleSettings"
    """A minority within a device security group has inconsistent Edge Module settings with the rest
    of their group."""
    IO_T_INSTALL_AGENT = "IoT_InstallAgent"
    """Install the Azure Security of Things Agent."""
    IO_T_IPFILTER_DENY_ALL = "IoT_IPFilter_DenyAll"
    """IP Filter Configuration should have rules defined for allowed traffic and should deny all other
    traffic by default."""
    IO_T_IPFILTER_PERMISSIVE_RULE = "IoT_IPFilter_PermissiveRule"
    """An Allow IP Filter rules source IP range is too large. Overly permissive rules might expose
    your IoT hub to malicious intenders."""
    IO_T_OPEN_PORTS = "IoT_OpenPorts"
    """A listening endpoint was found on the device."""
    IO_T_PERMISSIVE_FIREWALL_POLICY = "IoT_PermissiveFirewallPolicy"
    """An Allowed firewall policy was found (INPUT/OUTPUT). The policy should Deny all traffic by
    default and define rules to allow necessary communication to/from the device."""
    IO_T_PERMISSIVE_INPUT_FIREWALL_RULES = "IoT_PermissiveInputFirewallRules"
    """A rule in the firewall has been found that contains a permissive pattern for a wide range of IP
    addresses or Ports."""
    IO_T_PERMISSIVE_OUTPUT_FIREWALL_RULES = "IoT_PermissiveOutputFirewallRules"
    """A rule in the firewall has been found that contains a permissive pattern for a wide range of IP
    addresses or Ports."""
    IO_T_PRIVILEGED_DOCKER_OPTIONS = "IoT_PrivilegedDockerOptions"
    """Edge module is configured to run in privileged mode, with extensive Linux capabilities or with
    host-level network access (send/receive data to host machine)."""
    IO_T_SHARED_CREDENTIALS = "IoT_SharedCredentials"
    """Same authentication credentials to the IoT Hub used by multiple devices. This could indicate an
    illegitimate device impersonating a legitimate device. It also exposes the risk of device
    impersonation by an attacker."""
    IO_T_VULNERABLE_TLS_CIPHER_SUITE = "IoT_VulnerableTLSCipherSuite"
    """Insecure TLS configurations detected. Immediate upgrade recommended."""


class ReportedSeverity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Assessed alert severity."""

    INFORMATIONAL = "Informational"
    LOW = "Low"
    MEDIUM = "Medium"
    HIGH = "High"


class ResourceIdentifierType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """There can be multiple identifiers of different type per alert, this field specify the
    identifier type.
    """

    AZURE_RESOURCE = "AzureResource"
    LOG_ANALYTICS = "LogAnalytics"


class ResourcesCoverageStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This field is available for subscription-level only, and reflects the coverage status of the
    resources under the subscription. Please note: The "pricingTier" field reflects the plan status
    of the subscription. However, since the plan status can also be defined at the resource level,
    there might be misalignment between the subscription's plan status and the resource status.
    This field helps indicate the coverage status of the resources.
    """

    FULLY_COVERED = "FullyCovered"
    """This value indicates that all resources associated with the subscription have the Defender plan
    enabled."""
    PARTIALLY_COVERED = "PartiallyCovered"
    """This value indicates that some resources under the subscription have the Defender plan enabled,
    while others have it disabled. There is a mixed coverage status among resources."""
    NOT_COVERED = "NotCovered"
    """This value indicates that the Defender plan is disabled for all resources under the
    subscription. None of the resources are protected by the Defender plan."""


class ResourceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the resource regarding a single assessment."""

    HEALTHY = "Healthy"
    """This assessment on the resource is healthy"""
    NOT_APPLICABLE = "NotApplicable"
    """This assessment is not applicable to this resource"""
    OFF_BY_POLICY = "OffByPolicy"
    """This assessment is turned off by policy on this subscription"""
    NOT_HEALTHY = "NotHealthy"
    """This assessment on the resource is not healthy"""


class RiskLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The risk level."""

    LOW = "Low"
    MEDIUM = "Medium"
    HIGH = "High"


class RuleCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Rule categories.
    Code - code scanning results.
    Artifact scanning results.
    Dependencies scanning results.
    IaC results.
    Secrets scanning results.
    Container scanning results.
    """

    CODE = "Code"
    ARTIFACTS = "Artifacts"
    DEPENDENCIES = "Dependencies"
    SECRETS = "Secrets"
    IA_C = "IaC"
    CONTAINERS = "Containers"


class RuleSeverity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The rule severity."""

    HIGH = "High"
    """High"""
    MEDIUM = "Medium"
    """Medium"""
    LOW = "Low"
    """Low"""
    INFORMATIONAL = "Informational"
    """Informational"""
    OBSOLETE = "Obsolete"
    """Obsolete"""


class RuleState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible states of the rule."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"
    EXPIRED = "Expired"


class RuleStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The rule result status."""

    NON_FINDING = "NonFinding"
    """NonFinding"""
    FINDING = "Finding"
    """Finding"""
    INTERNAL_ERROR = "InternalError"
    """InternalError"""


class RuleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The rule type."""

    BINARY = "Binary"
    """Binary"""
    BASELINE_EXPECTED = "BaselineExpected"
    """BaselineExpected"""
    POSITIVE_LIST = "PositiveList"
    """PositiveList"""
    NEGATIVE_LIST = "NegativeList"
    """NegativeList"""


class ScanningMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The scanning mode for the VM scan."""

    DEFAULT = "Default"


class ScanState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The scan status."""

    FAILED = "Failed"
    """Failed"""
    FAILED_TO_RUN = "FailedToRun"
    """FailedToRun"""
    IN_PROGRESS = "InProgress"
    """InProgress"""
    PASSED = "Passed"
    """Passed"""


class ScanTriggerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The scan trigger type."""

    ON_DEMAND = "OnDemand"
    """OnDemand"""
    RECURRING = "Recurring"
    """Recurring"""


class SecurityContactName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SecurityContactName."""

    DEFAULT = "default"
    """The single applicable name of the security contact object"""


class SecurityContactRole(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A possible role to configure sending security notification alerts to."""

    ACCOUNT_ADMIN = "AccountAdmin"
    """If enabled, send notification on new alerts to the account admins"""
    SERVICE_ADMIN = "ServiceAdmin"
    """If enabled, send notification on new alerts to the service admins"""
    OWNER = "Owner"
    """If enabled, send notification on new alerts to the subscription owners"""
    CONTRIBUTOR = "Contributor"
    """If enabled, send notification on new alerts to the subscription contributors"""


class SecurityFamily(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The security family of the discovered solution."""

    WAF = "Waf"
    NGFW = "Ngfw"
    SAAS_WAF = "SaasWaf"
    VA = "Va"


class SecurityIssue(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The severity to relate to the assessments generated by this Recommendation."""

    VULNERABILITY = "Vulnerability"
    EXCESSIVE_PERMISSIONS = "ExcessivePermissions"
    ANONYMOUS_ACCESS = "AnonymousAccess"
    NETWORK_EXPOSURE = "NetworkExposure"
    TRAFFIC_ENCRYPTION = "TrafficEncryption"
    BEST_PRACTICES = "BestPractices"


class SecuritySolutionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the IoT Security solution."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class ServerVulnerabilityAssessmentPropertiesProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioningState of the vulnerability assessment capability on the VM."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    PROVISIONING = "Provisioning"
    DEPROVISIONING = "Deprovisioning"


class ServerVulnerabilityAssessmentsAzureSettingSelectedProvider(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The selected vulnerability assessments provider on Azure servers in the defined scope."""

    MDE_TVM = "MdeTvm"
    """Microsoft Defender for Endpoints threat and vulnerability management."""


class ServerVulnerabilityAssessmentsSettingKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the server vulnerability assessments setting."""

    AZURE_SERVERS_SETTING = "AzureServersSetting"


class ServerVulnerabilityAssessmentsSettingKindName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ServerVulnerabilityAssessmentsSettingKindName."""

    AZURE_SERVERS_SETTING = "azureServersSetting"


class SettingKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """the kind of the settings string."""

    DATA_EXPORT_SETTINGS = "DataExportSettings"
    ALERT_SUPPRESSION_SETTING = "AlertSuppressionSetting"
    ALERT_SYNC_SETTINGS = "AlertSyncSettings"


class SettingName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SettingName."""

    CURRENT = "current"
    """Name of the Defender for Storage Settings name."""


class SettingNameAutoGenerated(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SettingNameAutoGenerated."""

    MCAS = "MCAS"
    WDATP = "WDATP"
    WDATP_EXCLUDE_LINUX_PUBLIC_PREVIEW = "WDATP_EXCLUDE_LINUX_PUBLIC_PREVIEW"
    WDATP_UNIFIED_SOLUTION = "WDATP_UNIFIED_SOLUTION"
    SENTINEL = "Sentinel"


class Severity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sub-assessment severity level."""

    LOW = "Low"
    MEDIUM = "Medium"
    HIGH = "High"


class SeverityEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The severity to relate to the assessments generated by this assessment automation."""

    HIGH = "High"
    MEDIUM = "Medium"
    LOW = "Low"


class Source(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The platform where the assessed resource resides."""

    AZURE = "Azure"
    """Resource is in Azure"""
    ON_PREMISE = "OnPremise"
    """Resource in an on premise machine connected to Azure cloud"""
    ON_PREMISE_SQL = "OnPremiseSql"
    """SQL Resource in an on premise machine connected to Azure cloud"""


class SourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The source type that will trigger the notification."""

    ALERT = "Alert"
    ATTACK_PATH = "AttackPath"


class StandardSupportedCloud(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The cloud that the standard is supported on."""

    AZURE = "Azure"
    AWS = "AWS"
    GCP = "GCP"


class StandardType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Standard type (Custom or Default or Compliance only currently)."""

    CUSTOM = "Custom"
    DEFAULT = "Default"
    COMPLIANCE = "Compliance"


class State(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Aggregative state based on the standard's supported controls states."""

    PASSED = "Passed"
    """All supported regulatory compliance controls in the given standard have a passed state"""
    FAILED = "Failed"
    """At least one supported regulatory compliance control in the given standard has a state of
    failed"""
    SKIPPED = "Skipped"
    """All supported regulatory compliance controls in the given standard have a state of skipped"""
    UNSUPPORTED = "Unsupported"
    """No supported regulatory compliance data for the given standard"""


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the port."""

    REVOKED = "Revoked"
    INITIATED = "Initiated"


class StatusName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the health report."""

    HEALTHY = "Healthy"
    NOT_HEALTHY = "NotHealthy"
    NOT_APPLICABLE = "NotApplicable"


class StatusReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A description of why the ``status`` has its value."""

    EXPIRED = "Expired"
    USER_REQUESTED = "UserRequested"
    NEWER_REQUEST_INITIATED = "NewerRequestInitiated"


class SubAssessmentStatusCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Programmatic code for the status of the assessment."""

    HEALTHY = "Healthy"
    """The resource is healthy"""
    UNHEALTHY = "Unhealthy"
    """The resource has a security issue that needs to be addressed"""
    NOT_APPLICABLE = "NotApplicable"
    """Assessment for this resource did not happen"""


class SubPlan(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The available sub plans."""

    P1 = "P1"
    P2 = "P2"


class SupportedCloudEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Relevant cloud for the custom assessment automation."""

    AWS = "AWS"
    GCP = "GCP"


class Tactics(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Tactic of the assessment."""

    RECONNAISSANCE = "Reconnaissance"
    RESOURCE_DEVELOPMENT = "Resource Development"
    INITIAL_ACCESS = "Initial Access"
    EXECUTION = "Execution"
    PERSISTENCE = "Persistence"
    PRIVILEGE_ESCALATION = "Privilege Escalation"
    DEFENSE_EVASION = "Defense Evasion"
    CREDENTIAL_ACCESS = "Credential Access"
    DISCOVERY = "Discovery"
    LATERAL_MOVEMENT = "Lateral Movement"
    COLLECTION = "Collection"
    COMMAND_AND_CONTROL = "Command and Control"
    EXFILTRATION = "Exfiltration"
    IMPACT = "Impact"


class TaskUpdateActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """TaskUpdateActionType."""

    ACTIVATE = "Activate"
    DISMISS = "Dismiss"
    START = "Start"
    RESOLVE = "Resolve"
    CLOSE = "Close"


class Techniques(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Techniques of the assessment."""

    ABUSE_ELEVATION_CONTROL_MECHANISM = "Abuse Elevation Control Mechanism"
    ACCESS_TOKEN_MANIPULATION = "Access Token Manipulation"
    ACCOUNT_DISCOVERY = "Account Discovery"
    ACCOUNT_MANIPULATION = "Account Manipulation"
    ACTIVE_SCANNING = "Active Scanning"
    APPLICATION_LAYER_PROTOCOL = "Application Layer Protocol"
    AUDIO_CAPTURE = "Audio Capture"
    BOOT_OR_LOGON_AUTOSTART_EXECUTION = "Boot or Logon Autostart Execution"
    BOOT_OR_LOGON_INITIALIZATION_SCRIPTS = "Boot or Logon Initialization Scripts"
    BRUTE_FORCE = "Brute Force"
    CLOUD_INFRASTRUCTURE_DISCOVERY = "Cloud Infrastructure Discovery"
    CLOUD_SERVICE_DASHBOARD = "Cloud Service Dashboard"
    CLOUD_SERVICE_DISCOVERY = "Cloud Service Discovery"
    COMMAND_AND_SCRIPTING_INTERPRETER = "Command and Scripting Interpreter"
    COMPROMISE_CLIENT_SOFTWARE_BINARY = "Compromise Client Software Binary"
    COMPROMISE_INFRASTRUCTURE = "Compromise Infrastructure"
    CONTAINER_AND_RESOURCE_DISCOVERY = "Container and Resource Discovery"
    CREATE_ACCOUNT = "Create Account"
    CREATE_OR_MODIFY_SYSTEM_PROCESS = "Create or Modify System Process"
    CREDENTIALS_FROM_PASSWORD_STORES = "Credentials from Password Stores"
    DATA_DESTRUCTION = "Data Destruction"
    DATA_ENCRYPTED_FOR_IMPACT = "Data Encrypted for Impact"
    DATA_FROM_CLOUD_STORAGE_OBJECT = "Data from Cloud Storage Object"
    DATA_FROM_CONFIGURATION_REPOSITORY = "Data from Configuration Repository"
    DATA_FROM_INFORMATION_REPOSITORIES = "Data from Information Repositories"
    DATA_FROM_LOCAL_SYSTEM = "Data from Local System"
    DATA_MANIPULATION = "Data Manipulation"
    DATA_STAGED = "Data Staged"
    DEFACEMENT = "Defacement"
    DEOBFUSCATE_DECODE_FILES_OR_INFORMATION = "Deobfuscate/Decode Files or Information"
    DISK_WIPE = "Disk Wipe"
    DOMAIN_TRUST_DISCOVERY = "Domain Trust Discovery"
    DRIVE_BY_COMPROMISE = "Drive-by Compromise"
    DYNAMIC_RESOLUTION = "Dynamic Resolution"
    ENDPOINT_DENIAL_OF_SERVICE = "Endpoint Denial of Service"
    EVENT_TRIGGERED_EXECUTION = "Event Triggered Execution"
    EXFILTRATION_OVER_ALTERNATIVE_PROTOCOL = "Exfiltration Over Alternative Protocol"
    EXPLOIT_PUBLIC_FACING_APPLICATION = "Exploit Public-Facing Application"
    EXPLOITATION_FOR_CLIENT_EXECUTION = "Exploitation for Client Execution"
    EXPLOITATION_FOR_CREDENTIAL_ACCESS = "Exploitation for Credential Access"
    EXPLOITATION_FOR_DEFENSE_EVASION = "Exploitation for Defense Evasion"
    EXPLOITATION_FOR_PRIVILEGE_ESCALATION = "Exploitation for Privilege Escalation"
    EXPLOITATION_OF_REMOTE_SERVICES = "Exploitation of Remote Services"
    EXTERNAL_REMOTE_SERVICES = "External Remote Services"
    FALLBACK_CHANNELS = "Fallback Channels"
    FILE_AND_DIRECTORY_DISCOVERY = "File and Directory Discovery"
    GATHER_VICTIM_NETWORK_INFORMATION = "Gather Victim Network Information"
    HIDE_ARTIFACTS = "Hide Artifacts"
    HIJACK_EXECUTION_FLOW = "Hijack Execution Flow"
    IMPAIR_DEFENSES = "Impair Defenses"
    IMPLANT_CONTAINER_IMAGE = "Implant Container Image"
    INDICATOR_REMOVAL_ON_HOST = "Indicator Removal on Host"
    INDIRECT_COMMAND_EXECUTION = "Indirect Command Execution"
    INGRESS_TOOL_TRANSFER = "Ingress Tool Transfer"
    INPUT_CAPTURE = "Input Capture"
    INTER_PROCESS_COMMUNICATION = "Inter-Process Communication"
    LATERAL_TOOL_TRANSFER = "Lateral Tool Transfer"
    MAN_IN_THE_MIDDLE = "Man-in-the-Middle"
    MASQUERADING = "Masquerading"
    MODIFY_AUTHENTICATION_PROCESS = "Modify Authentication Process"
    MODIFY_REGISTRY = "Modify Registry"
    NETWORK_DENIAL_OF_SERVICE = "Network Denial of Service"
    NETWORK_SERVICE_SCANNING = "Network Service Scanning"
    NETWORK_SNIFFING = "Network Sniffing"
    NON_APPLICATION_LAYER_PROTOCOL = "Non-Application Layer Protocol"
    NON_STANDARD_PORT = "Non-Standard Port"
    OBTAIN_CAPABILITIES = "Obtain Capabilities"
    OBFUSCATED_FILES_OR_INFORMATION = "Obfuscated Files or Information"
    OFFICE_APPLICATION_STARTUP = "Office Application Startup"
    OS_CREDENTIAL_DUMPING = "OS Credential Dumping"
    PERMISSION_GROUPS_DISCOVERY = "Permission Groups Discovery"
    PHISHING = "Phishing"
    PRE_OS_BOOT = "Pre-OS Boot"
    PROCESS_DISCOVERY = "Process Discovery"
    PROCESS_INJECTION = "Process Injection"
    PROTOCOL_TUNNELING = "Protocol Tunneling"
    PROXY = "Proxy"
    QUERY_REGISTRY = "Query Registry"
    REMOTE_ACCESS_SOFTWARE = "Remote Access Software"
    REMOTE_SERVICE_SESSION_HIJACKING = "Remote Service Session Hijacking"
    REMOTE_SERVICES = "Remote Services"
    REMOTE_SYSTEM_DISCOVERY = "Remote System Discovery"
    RESOURCE_HIJACKING = "Resource Hijacking"
    SCHEDULED_TASK_JOB = "Scheduled Task/Job"
    SCREEN_CAPTURE = "Screen Capture"
    SEARCH_VICTIM_OWNED_WEBSITES = "Search Victim-Owned Websites"
    SERVER_SOFTWARE_COMPONENT = "Server Software Component"
    SERVICE_STOP = "Service Stop"
    SIGNED_BINARY_PROXY_EXECUTION = "Signed Binary Proxy Execution"
    SOFTWARE_DEPLOYMENT_TOOLS = "Software Deployment Tools"
    SQL_STORED_PROCEDURES = "SQL Stored Procedures"
    STEAL_OR_FORGE_KERBEROS_TICKETS = "Steal or Forge Kerberos Tickets"
    SUBVERT_TRUST_CONTROLS = "Subvert Trust Controls"
    SUPPLY_CHAIN_COMPROMISE = "Supply Chain Compromise"
    SYSTEM_INFORMATION_DISCOVERY = "System Information Discovery"
    TAINT_SHARED_CONTENT = "Taint Shared Content"
    TRAFFIC_SIGNALING = "Traffic Signaling"
    TRANSFER_DATA_TO_CLOUD_ACCOUNT = "Transfer Data to Cloud Account"
    TRUSTED_RELATIONSHIP = "Trusted Relationship"
    UNSECURED_CREDENTIALS = "Unsecured Credentials"
    USER_EXECUTION = "User Execution"
    VALID_ACCOUNTS = "Valid Accounts"
    WINDOWS_MANAGEMENT_INSTRUMENTATION = "Windows Management Instrumentation"
    FILE_AND_DIRECTORY_PERMISSIONS_MODIFICATION = "File and Directory Permissions Modification"


class Threats(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Threats impact of the assessment."""

    ACCOUNT_BREACH = "accountBreach"
    DATA_EXFILTRATION = "dataExfiltration"
    DATA_SPILLAGE = "dataSpillage"
    MALICIOUS_INSIDER = "maliciousInsider"
    ELEVATION_OF_PRIVILEGE = "elevationOfPrivilege"
    THREAT_RESISTANCE = "threatResistance"
    MISSING_COVERAGE = "missingCoverage"
    DENIAL_OF_SERVICE = "denialOfService"


class Type(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'."""

    QUALYS = "Qualys"
    TVM = "TVM"


class UnmaskedIpLoggingStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Unmasked IP address logging status."""

    DISABLED = "Disabled"
    """Unmasked IP logging is disabled"""
    ENABLED = "Enabled"
    """Unmasked IP logging is enabled"""


class UserImpact(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The user impact of the assessment."""

    LOW = "Low"
    MODERATE = "Moderate"
    HIGH = "High"


class ValueType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The value type of the items in the list."""

    IP_CIDR = "IpCidr"
    """An IP range in CIDR format (e.g. '192.168.0.1/8')."""
    STRING = "String"
    """Any string value."""
