# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class DayOfWeek(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    SUNDAY = "Sunday"
    MONDAY = "Monday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"
    THURSDAY = "Thursday"
    FRIDAY = "Friday"
    SATURDAY = "Saturday"

class HttpAuthenticationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the HTTP authentication type.
    """

    NOT_SPECIFIED = "NotSpecified"
    CLIENT_CERTIFICATE = "ClientCertificate"
    ACTIVE_DIRECTORY_O_AUTH = "ActiveDirectoryOAuth"
    BASIC = "Basic"

class JobActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the job action type.
    """

    HTTP = "Http"
    HTTPS = "Https"
    STORAGE_QUEUE = "StorageQueue"
    SERVICE_BUS_QUEUE = "ServiceBusQueue"
    SERVICE_BUS_TOPIC = "ServiceBusTopic"

class JobCollectionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the state.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"
    SUSPENDED = "Suspended"
    DELETED = "Deleted"

class JobExecutionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets the job execution status.
    """

    COMPLETED = "Completed"
    FAILED = "Failed"
    POSTPONED = "Postponed"

class JobHistoryActionName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets the job history action name.
    """

    MAIN_ACTION = "MainAction"
    ERROR_ACTION = "ErrorAction"

class JobScheduleDay(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the day. Must be one of monday, tuesday, wednesday, thursday, friday, saturday,
    sunday.
    """

    MONDAY = "Monday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"
    THURSDAY = "Thursday"
    FRIDAY = "Friday"
    SATURDAY = "Saturday"
    SUNDAY = "Sunday"

class JobState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or set the job state.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"
    FAULTED = "Faulted"
    COMPLETED = "Completed"

class RecurrenceFrequency(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
    """

    MINUTE = "Minute"
    HOUR = "Hour"
    DAY = "Day"
    WEEK = "Week"
    MONTH = "Month"

class RetryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the retry strategy to be used.
    """

    NONE = "None"
    FIXED = "Fixed"

class ServiceBusAuthenticationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the authentication type.
    """

    NOT_SPECIFIED = "NotSpecified"
    SHARED_ACCESS_KEY = "SharedAccessKey"

class ServiceBusTransportType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the transport type.
    """

    NOT_SPECIFIED = "NotSpecified"
    NET_MESSAGING = "NetMessaging"
    AMQP = "AMQP"

class SkuDefinition(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or set the SKU.
    """

    STANDARD = "Standard"
    FREE = "Free"
    P10_PREMIUM = "P10Premium"
    P20_PREMIUM = "P20Premium"
