/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2019 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// StdLib includes


/////////////////////// Qt includes


/////////////////////// pappsomspp includes
#include <pappsomspp/core/massspectrum/qualifiedmassspectrum.h>
#include <pappsomspp/core/msrun/msrundatasettreenode.h>
#include <pappsomspp/core/msrun/msrundatasettreevisitor.h>
#include <pappsomspp/core/trace/maptrace.h>


/////////////////////// Local includes
#include "ProcessingFlow.hpp"
#include "MsRunDataSet.hpp"
#include "BaseMsRunDataSetTreeNodeVisitor.hpp"

namespace MsXpS
{
namespace MineXpert
{

class MassDataIntegrator;

class TicChromTreeNodeCombinerVisitor;

typedef std::shared_ptr<TicChromTreeNodeCombinerVisitor>
  TicChromTreeNodeCombinerVisitorSPtr;

class TicChromTreeNodeCombinerVisitor: public BaseMsRunDataSetTreeNodeVisitor
{

  friend class MassDataIntegrator;

  public:
  TicChromTreeNodeCombinerVisitor(MsRunDataSetCstSPtr ms_run_data_set_csp,
                                  const ProcessingFlow &processing_flow,
                                  QObject *parent = nullptr);

  virtual ~TicChromTreeNodeCombinerVisitor();

  virtual BaseMsRunDataSetTreeNodeVisitor *
  clone(QObject *parent = nullptr) const override;

  const pappso::MapTrace &getTicChromMapTrace() const;

  TicChromTreeNodeCombinerVisitor &
  operator=(const TicChromTreeNodeCombinerVisitor &other);

  // Overrides the base class.
  virtual bool visit(const pappso::MsRunDataSetTreeNode &node) override;

  protected:
  pappso::MapTrace m_ticChromMapTrace;
};


} // namespace MineXpert

} // namespace MsXpS
