// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/type/datetime.proto

package datetime

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Represents civil time in one of a few possible ways:
//
//  * When utc_offset is set and time_zone is unset: a civil time on a calendar
//    day with a particular offset from UTC.
//  * When time_zone is set and utc_offset is unset: a civil time on a calendar
//    day in a particular time zone.
//  * When neither time_zone nor utc_offset is set: a civil time on a calendar
//    day in local time.
//
// The date is relative to the Proleptic Gregorian Calendar.
//
// If year is 0, the DateTime is considered not to have a specific year. month
// and day must have valid, non-zero values.
//
// This type is more flexible than some applications may want. Make sure to
// document and validate your application's limitations.
type DateTime struct {
	// Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a
	// datetime without a year.
	Year int32 `protobuf:"varint,1,opt,name=year,proto3" json:"year,omitempty"`
	// Required. Month of year. Must be from 1 to 12.
	Month int32 `protobuf:"varint,2,opt,name=month,proto3" json:"month,omitempty"`
	// Required. Day of month. Must be from 1 to 31 and valid for the year and
	// month.
	Day int32 `protobuf:"varint,3,opt,name=day,proto3" json:"day,omitempty"`
	// Required. Hours of day in 24 hour format. Should be from 0 to 23. An API
	// may choose to allow the value "24:00:00" for scenarios like business
	// closing time.
	Hours int32 `protobuf:"varint,4,opt,name=hours,proto3" json:"hours,omitempty"`
	// Required. Minutes of hour of day. Must be from 0 to 59.
	Minutes int32 `protobuf:"varint,5,opt,name=minutes,proto3" json:"minutes,omitempty"`
	// Required. Seconds of minutes of the time. Must normally be from 0 to 59. An
	// API may allow the value 60 if it allows leap-seconds.
	Seconds int32 `protobuf:"varint,6,opt,name=seconds,proto3" json:"seconds,omitempty"`
	// Required. Fractions of seconds in nanoseconds. Must be from 0 to
	// 999,999,999.
	Nanos int32 `protobuf:"varint,7,opt,name=nanos,proto3" json:"nanos,omitempty"`
	// Optional. Specifies either the UTC offset or the time zone of the DateTime.
	// Choose carefully between them, considering that time zone data may change
	// in the future (for example, a country modifies their DST start/end dates,
	// and future DateTimes in the affected range had already been stored).
	// If omitted, the DateTime is considered to be in local time.
	//
	// Types that are valid to be assigned to TimeOffset:
	//	*DateTime_UtcOffset
	//	*DateTime_TimeZone
	TimeOffset           isDateTime_TimeOffset `protobuf_oneof:"time_offset"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *DateTime) Reset()         { *m = DateTime{} }
func (m *DateTime) String() string { return proto.CompactTextString(m) }
func (*DateTime) ProtoMessage()    {}
func (*DateTime) Descriptor() ([]byte, []int) {
	return fileDescriptor_247e8eac669493f4, []int{0}
}

func (m *DateTime) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DateTime.Unmarshal(m, b)
}
func (m *DateTime) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DateTime.Marshal(b, m, deterministic)
}
func (m *DateTime) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DateTime.Merge(m, src)
}
func (m *DateTime) XXX_Size() int {
	return xxx_messageInfo_DateTime.Size(m)
}
func (m *DateTime) XXX_DiscardUnknown() {
	xxx_messageInfo_DateTime.DiscardUnknown(m)
}

var xxx_messageInfo_DateTime proto.InternalMessageInfo

func (m *DateTime) GetYear() int32 {
	if m != nil {
		return m.Year
	}
	return 0
}

func (m *DateTime) GetMonth() int32 {
	if m != nil {
		return m.Month
	}
	return 0
}

func (m *DateTime) GetDay() int32 {
	if m != nil {
		return m.Day
	}
	return 0
}

func (m *DateTime) GetHours() int32 {
	if m != nil {
		return m.Hours
	}
	return 0
}

func (m *DateTime) GetMinutes() int32 {
	if m != nil {
		return m.Minutes
	}
	return 0
}

func (m *DateTime) GetSeconds() int32 {
	if m != nil {
		return m.Seconds
	}
	return 0
}

func (m *DateTime) GetNanos() int32 {
	if m != nil {
		return m.Nanos
	}
	return 0
}

type isDateTime_TimeOffset interface {
	isDateTime_TimeOffset()
}

type DateTime_UtcOffset struct {
	UtcOffset *duration.Duration `protobuf:"bytes,8,opt,name=utc_offset,json=utcOffset,proto3,oneof"`
}

type DateTime_TimeZone struct {
	TimeZone *TimeZone `protobuf:"bytes,9,opt,name=time_zone,json=timeZone,proto3,oneof"`
}

func (*DateTime_UtcOffset) isDateTime_TimeOffset() {}

func (*DateTime_TimeZone) isDateTime_TimeOffset() {}

func (m *DateTime) GetTimeOffset() isDateTime_TimeOffset {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *DateTime) GetUtcOffset() *duration.Duration {
	if x, ok := m.GetTimeOffset().(*DateTime_UtcOffset); ok {
		return x.UtcOffset
	}
	return nil
}

func (m *DateTime) GetTimeZone() *TimeZone {
	if x, ok := m.GetTimeOffset().(*DateTime_TimeZone); ok {
		return x.TimeZone
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*DateTime) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*DateTime_UtcOffset)(nil),
		(*DateTime_TimeZone)(nil),
	}
}

// Represents a time zone from the
// [IANA Time Zone Database](https://www.iana.org/time-zones).
type TimeZone struct {
	// IANA Time Zone Database time zone, e.g. "America/New_York".
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Optional. IANA Time Zone Database version number, e.g. "2019a".
	Version              string   `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TimeZone) Reset()         { *m = TimeZone{} }
func (m *TimeZone) String() string { return proto.CompactTextString(m) }
func (*TimeZone) ProtoMessage()    {}
func (*TimeZone) Descriptor() ([]byte, []int) {
	return fileDescriptor_247e8eac669493f4, []int{1}
}

func (m *TimeZone) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimeZone.Unmarshal(m, b)
}
func (m *TimeZone) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimeZone.Marshal(b, m, deterministic)
}
func (m *TimeZone) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeZone.Merge(m, src)
}
func (m *TimeZone) XXX_Size() int {
	return xxx_messageInfo_TimeZone.Size(m)
}
func (m *TimeZone) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeZone.DiscardUnknown(m)
}

var xxx_messageInfo_TimeZone proto.InternalMessageInfo

func (m *TimeZone) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *TimeZone) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func init() {
	proto.RegisterType((*DateTime)(nil), "google.type.DateTime")
	proto.RegisterType((*TimeZone)(nil), "google.type.TimeZone")
}

func init() { proto.RegisterFile("google/type/datetime.proto", fileDescriptor_247e8eac669493f4) }

var fileDescriptor_247e8eac669493f4 = []byte{
	// 349 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x54, 0x51, 0x4d, 0x6f, 0xe2, 0x30,
	0x14, 0x24, 0xe1, 0x2b, 0x31, 0x62, 0x77, 0x65, 0xed, 0x4a, 0x5e, 0x0e, 0x15, 0xe2, 0xc4, 0xc9,
	0x91, 0x5a, 0x4e, 0x6d, 0x4f, 0x08, 0xa9, 0xdc, 0x8a, 0x22, 0x4e, 0x5c, 0x90, 0x49, 0x4c, 0xb0,
	0x44, 0xfc, 0x50, 0xec, 0x54, 0xa2, 0x3f, 0xa7, 0x97, 0xfe, 0xc5, 0x1e, 0x2b, 0x3f, 0x27, 0x12,
	0xbd, 0xcd, 0xbc, 0x99, 0xe7, 0x97, 0x99, 0x90, 0x49, 0x01, 0x50, 0x9c, 0x65, 0x62, 0xaf, 0x17,
	0x99, 0xe4, 0xc2, 0x4a, 0xab, 0x4a, 0xc9, 0x2f, 0x15, 0x58, 0xa0, 0x23, 0xaf, 0x71, 0xa7, 0x4d,
	0xee, 0x1a, 0x23, 0x4a, 0x87, 0xfa, 0x98, 0xe4, 0x75, 0x25, 0xac, 0x02, 0xed, 0xcd, 0xb3, 0xcf,
	0x90, 0x44, 0x2b, 0x61, 0xe5, 0x56, 0x95, 0x92, 0x52, 0xd2, 0xbb, 0x4a, 0x51, 0xb1, 0x60, 0x1a,
	0xcc, 0xfb, 0x29, 0x62, 0xfa, 0x97, 0xf4, 0x4b, 0xd0, 0xf6, 0xc4, 0x42, 0x1c, 0x7a, 0x42, 0xff,
	0x90, 0x6e, 0x2e, 0xae, 0xac, 0x8b, 0x33, 0x07, 0x9d, 0xef, 0x04, 0x75, 0x65, 0x58, 0xcf, 0xfb,
	0x90, 0x50, 0x46, 0x86, 0xa5, 0xd2, 0xb5, 0x95, 0x86, 0xf5, 0x71, 0xde, 0x52, 0xa7, 0x18, 0x99,
	0x81, 0xce, 0x0d, 0x1b, 0x78, 0xa5, 0xa1, 0xee, 0x25, 0x2d, 0x34, 0x18, 0x36, 0xf4, 0x2f, 0x21,
	0xa1, 0x8f, 0x84, 0xd4, 0x36, 0xdb, 0xc3, 0xf1, 0x68, 0xa4, 0x65, 0xd1, 0x34, 0x98, 0x8f, 0xee,
	0xff, 0xf3, 0x26, 0x6a, 0x9b, 0x8e, 0xaf, 0x9a, 0x74, 0xeb, 0x4e, 0x1a, 0xd7, 0x36, 0x7b, 0x45,
	0x37, 0x5d, 0x90, 0xd8, 0xf5, 0xb3, 0x7f, 0x07, 0x2d, 0x59, 0x8c, 0xab, 0xff, 0xf8, 0x4d, 0x4b,
	0xdc, 0xa5, 0xdf, 0x81, 0x96, 0xeb, 0x4e, 0x1a, 0xd9, 0x06, 0x2f, 0xc7, 0x64, 0x84, 0x5b, 0xfe,
	0xe4, 0x6c, 0x41, 0xa2, 0xd6, 0x46, 0x7f, 0x91, 0x50, 0xe5, 0x58, 0x53, 0x9c, 0x86, 0x2a, 0x77,
	0x61, 0xde, 0x64, 0x65, 0x14, 0x68, 0xac, 0x29, 0x4e, 0x5b, 0xba, 0x54, 0xe4, 0x77, 0x06, 0xe5,
	0xed, 0xb1, 0xe5, 0xb8, 0xed, 0x7b, 0xe3, 0xbe, 0x7a, 0x13, 0xec, 0x9e, 0x1b, 0xb5, 0x80, 0xb3,
	0xd0, 0x05, 0x87, 0xaa, 0x48, 0x0a, 0xa9, 0x31, 0x53, 0xe2, 0x25, 0x71, 0x51, 0xe6, 0xe7, 0xbf,
	0x7e, 0x6a, 0xc1, 0x57, 0x10, 0x7c, 0x84, 0xdd, 0x97, 0xed, 0xe6, 0x30, 0xc0, 0x8d, 0x87, 0xef,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x0f, 0xfe, 0x9d, 0x3c, 0x1c, 0x02, 0x00, 0x00,
}
