"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemoveBrokenLinkAlg = exports.CRemoveBrokenLinkAlg = exports.LookupRemovableAlg = exports.CLookupRemovableAlg = void 0;
const Ot = require("@ot-builder/ot");
class CLookupRemovableAlg {
    process(lookup) {
        switch (lookup.type) {
            case Ot.Gsub.LookupType.Single:
                return this.gsubSingle(lookup);
            case Ot.Gsub.LookupType.Multi:
                return this.gsubMulti(lookup);
            case Ot.Gsub.LookupType.Alternate:
                return this.gsubAlternate(lookup);
            case Ot.Gsub.LookupType.Ligature:
                return this.gsubLigature(lookup);
            case Ot.Gsub.LookupType.Chaining:
                return this.gsubChaining(lookup);
            case Ot.Gsub.LookupType.Reverse:
                return this.gsubReverse(lookup);
            case Ot.Gpos.LookupType.Single:
                return this.gposSingle(lookup);
            case Ot.Gpos.LookupType.Pair:
                return this.gposPair(lookup);
            case Ot.Gpos.LookupType.Cursive:
                return this.gposCursive(lookup);
            case Ot.Gpos.LookupType.MarkToBase:
                return this.gposMarkToBase(lookup);
            case Ot.Gpos.LookupType.MarkToLigature:
                return this.gposMarkToLigature(lookup);
            case Ot.Gpos.LookupType.MarkToMark:
                return this.gposMarkToMark(lookup);
            case Ot.Gpos.LookupType.Chaining:
                return this.gposChaining(lookup);
        }
    }
    gsubSingle(props) {
        return !props.mapping.size;
    }
    gsubMulti(props) {
        return !props.mapping.size;
    }
    gsubAlternate(props) {
        return !props.mapping.size;
    }
    gsubLigature(props) {
        return !props.mapping.length;
    }
    gsubReverse(props) {
        return !props.rules.length;
    }
    gposSingle(props) {
        return !props.adjustments.size;
    }
    gposPair(props) {
        const cdFirst = props.adjustments.getXClassDef();
        const cdSecond = props.adjustments.getYClassDef();
        for (let c1 = 0; c1 < cdFirst.length; c1++) {
            for (let c2 = 0; c2 < cdSecond.length; c2++) {
                const cFirst = cdFirst[c1];
                const cSecond = cdSecond[c2];
                const adj = props.adjustments.getByClass(c1, c2);
                if (cFirst.length || cSecond.length || adj != null)
                    return false;
            }
        }
        return true;
    }
    gposCursive(props) {
        return !props.attachments.size;
    }
    gposMarkToBase(props) {
        return !props.marks.size || !props.bases.size;
    }
    gposMarkToMark(props) {
        return !props.marks.size || !props.baseMarks.size;
    }
    gposMarkToLigature(props) {
        return !props.marks.size || !props.bases.size;
    }
    gsubChaining(props) {
        return !props.rules.length;
    }
    gposChaining(props) {
        return !props.rules.length;
    }
}
exports.CLookupRemovableAlg = CLookupRemovableAlg;
exports.LookupRemovableAlg = new CLookupRemovableAlg();
class CRemoveBrokenLinkAlg {
    process(lookup, validSet) {
        switch (lookup.type) {
            case Ot.Gsub.LookupType.Chaining:
                this.chaining(lookup, validSet);
                break;
            case Ot.Gpos.LookupType.Chaining:
                this.chaining(lookup, validSet);
                break;
        }
    }
    chaining(props, validSet) {
        let rear = 0;
        for (let front = 0; front < props.rules.length; front++) {
            const rule = props.rules[front];
            let apRear = 0;
            for (let apFront = 0; apFront < rule.applications.length; apFront++) {
                if (validSet.has(rule.applications[apFront].apply)) {
                    rule.applications[apRear++] = rule.applications[apFront];
                }
            }
            rule.applications.length = apRear;
            if (rule.applications.length)
                props.rules[rear++] = rule;
        }
        props.rules.length = rear;
    }
}
exports.CRemoveBrokenLinkAlg = CRemoveBrokenLinkAlg;
exports.RemoveBrokenLinkAlg = new CRemoveBrokenLinkAlg();
//# sourceMappingURL=lookup-removable-alg.js.map