"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.combineList = combineList;
exports.mergeMapOpt = mergeMapOpt;
exports.mergeMap = mergeMap;
exports.mergeClassDefOpt = mergeClassDefOpt;
exports.mergeClassDef = mergeClassDef;
exports.mergeMapAlt = mergeMapAlt;
exports.Prime = Prime;
function combineList(a, b) {
    return [...(a || []), ...(b || [])];
}
function mergeMapOpt(preferred, less, mergeValue) {
    if (!preferred)
        return less;
    if (!less)
        return preferred;
    return mergeMap(preferred, less, mergeValue);
}
function mergeMap(preferred, less, mergeValue) {
    const m = new Map(preferred);
    for (const [k, v] of less) {
        if (m.has(k)) {
            m.set(k, mergeValue(m.get(k), v));
        }
        else {
            m.set(k, v);
        }
    }
    return m;
}
function mergeClassDefOpt(preferred, less) {
    if (!preferred)
        return less;
    if (!less)
        return preferred;
    return mergeClassDef(preferred, less);
}
function mergeClassDef(preferred, less) {
    const m = new Map(preferred);
    let maxClass = 0;
    for (const v of m.values())
        if (v > maxClass)
            maxClass = v;
    for (const [k, v] of less)
        if (!m.has(k))
            m.set(k, v + maxClass);
    return m;
}
function mergeMapAlt(preferred, less, mergeValue) {
    const keySet = new Set([...preferred.keys(), ...less.keys()]);
    const m = new Map();
    for (const k of keySet) {
        m.set(k, mergeValue(preferred.get(k), less.get(k)));
    }
    return m;
}
function Prime(a, b) {
    return a;
}
//# sourceMappingURL=utils.js.map