// Copyright (c) 2011, Thomas Goyne <plorkyeran@aegisub.org>
//
// Permission to use, copy, modify, and distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

/// @file libaegisub_keyframe.cpp
/// @brief agi::keyframe tests
/// @ingroup video_input

#include <libaegisub/fs.h>
#include <libaegisub/keyframe.h>

#include <fstream>
#include <iterator>

#include <main.h>
#include <util.h>

using namespace agi::keyframe;
using namespace util;

TEST(lagi_keyframe, save) {
	std::vector<int> kf = { 0, 5, 70, 180, 300 };

	ASSERT_NO_THROW(Save("data/keyframe/out.txt", kf));

	std::vector<int> res;
	ASSERT_NO_THROW(res = Load("data/keyframe/out.txt"));

	EXPECT_TRUE(kf == res);
}

TEST(lagi_keyframe, bad_files) {
	EXPECT_THROW(Load(""), agi::fs::FileSystemError);
	// TODO: use more clearly error type
	EXPECT_THROW(Load("data/keyframe/empty.txt"), agi::InvalidInputException);
	EXPECT_THROW(Load("data/keyframe/garbage.txt"), agi::InvalidInputException);
}

TEST(lagi_keyframe, xvid) {
	std::vector<int> expected = {
		0, 52, 53, 55, 57, 80, 114, 168, 182, 234, 240, 242, 244, 250, 251,
		274, 290, 336, 364, 431, 465, 535, 596, 654, 700, 744, 976, 982, 983,
		984, 985, 993, 994, 995, 996, 997, 998, 1006, 1007, 1008, 1009, 1022,
		1066, 1071, 1072, 1073, 1074, 1075, 1081, 1086, 1092, 1096, 1097,
		1099, 1100, 1429, 1445, 1511, 1559, 1575, 1605, 1624, 1634, 1696,
		1760, 1795, 1820, 1873, 1900, 1948, 1958, 1966, 1974, 1983, 1991,
		1999, 2012, 2032, 2194, 2195, 2325, 2354, 2355, 2404, 2411, 2412,
		2414, 2446, 2487, 2489, 2495, 2496, 2497, 2498, 2522, 2538, 2544,
		2552, 2558, 2564, 2575, 2583, 2591, 2599, 2607, 2690, 2695, 2703,
		2711, 2719, 2727, 2735, 2753, 2754, 2756, 2757, 2765, 2766, 2768,
		2769, 2777, 2900, 3048, 3093, 3104, 3116, 3184, 3439, 3605, 3645,
		3649, 3655, 3657, 3659, 3679, 3681, 3749, 3770, 3794, 3815, 3837,
		3862, 3969, 4007, 4044, 4090, 4113, 4157, 4246, 4293, 4480, 4520,
		4573, 4619, 4644, 4661, 4682, 4684, 4686, 4708, 4737, 4739, 4741,
		4777, 4779, 4780, 4783, 4839, 4851, 4863, 4872, 4878, 4884, 4890,
		4896, 4901, 4953, 4975, 4986, 4988, 4990, 4992, 5004, 5068, 5093,
		5160, 5183, 5212, 5233, 5275, 5281, 5326, 5360, 5380, 5493, 5497,
		5498, 5499, 5500, 5517, 5562, 5684, 5708, 5762, 5764, 5821, 5857,
		5975, 5993, 6053, 6099, 6172, 6224, 6248, 6272, 6305, 6329, 6353,
		6377, 6414, 6438, 6465, 6499, 6567, 6677, 6736, 6781, 6809, 6873,
		6985, 7031, 7115, 7199, 7283, 7367, 7451, 7535, 7619, 7703, 8177,
		8232, 8484, 8505, 8595, 8659, 8699, 8967, 9004, 9021, 9064, 9116,
		9164, 9271, 9293, 9327, 9379, 9505, 9663, 9754, 9800, 9845, 9911,
		9936, 9976, 9992, 10186, 10452, 10523, 10677, 10716, 10816, 10852,
		10950, 11102, 11149, 11169, 11295, 11314, 11377, 11417, 11458, 11641,
		11681, 11712, 11892, 11920, 11978, 12016, 12119, 12195, 12561, 12661,
		12725, 12727, 12728, 12729, 12839, 12983, 12988, 13032, 13096, 13173,
		13175, 13203, 13215, 13239, 13251, 13268, 13300, 13324, 13332, 13390,
		13429, 13531, 13588, 13661, 13828, 13873, 13932, 13964, 14013, 14151,
		14239, 14356, 14384, 14596, 14625, 14655, 14736, 14797, 14921, 14965,
		15001, 15048, 15141, 15181, 15264, 15328, 15416, 15595, 15636, 15706,
		15758, 15867, 15908, 16150, 16416, 16457, 16504, 16569, 16622, 16686,
		16723, 16814, 16982, 17138, 17210, 17243, 17273, 17303, 17333, 17438,
		17516, 17591, 17687, 17747, 17894, 17960, 17984, 18032, 18056, 18080,
		18116, 18227, 18301, 18407, 18467, 18605, 18695, 18803, 18917, 18989,
		19049, 19304, 19415, 19502, 19583, 19688, 19847, 19961, 20069, 20093,
		20126, 20165, 20228, 20276, 20318, 20363, 20423, 20456, 20570, 20651,
		20701, 20789, 20834, 20922, 20968, 21075, 21112, 21145, 21185, 21232,
		21274, 21313, 21354, 21382, 21410, 21444, 21469, 21473, 21482, 21484,
		21486, 21488, 21489, 21514, 21516, 21518, 21542, 21594, 21634, 21700,
		21752, 21798, 21800, 21810, 21812, 21828, 21830, 21840, 21842, 21844,
		21846, 21848, 21850, 21854, 21885, 21901, 21916, 21933, 21988, 21999,
		22016, 22035, 22037, 22038, 22040, 22042, 22044, 22054, 22055, 22057,
		22059, 22061, 22066, 22068, 22069, 22189, 22229, 22296, 22312, 22388,
		22464, 22496, 22578, 22636, 22664, 22665, 22699, 22730, 22777, 22800,
		22882, 22904, 23042, 23069, 23178, 23196, 23198, 23206, 23222, 23230,
		23238, 23240, 23302, 23353, 23424, 23502, 23526, 23549, 23632, 23674,
		23724, 23805, 23845, 23906, 23937, 24038, 24106, 24174, 24194, 24226,
		24290, 24294, 24315, 24356, 24609, 24638, 24698, 24721, 24858, 24898,
		24948, 25068, 25218, 25253, 25298, 25375, 25421, 25461, 25575, 25725,
		25785, 25926, 26067, 26196, 26280, 26322, 26358, 26424, 26460, 26490,
		26514, 26537, 26572, 26674, 26696, 26781, 26806, 26824, 27150, 27177,
		27201, 27301, 27358, 27402, 27460, 27494, 27601, 27708, 27786, 27860,
		27905, 27981, 28009, 28034, 28061, 28086, 28114, 28140, 28221, 28285,
		28538, 28573, 28724, 28762, 28966, 29138, 29166, 29231, 29364, 29434,
		29474, 29569, 29585, 29677, 29753, 29882, 29929, 30094, 30160, 30185,
		30217, 30229, 30233, 30234, 30235, 30236, 30237, 30242, 30243, 30268,
		30282, 30289, 30301, 30329, 30412, 30426, 30433, 30445, 30477, 30602,
		30635, 30744, 30783, 30894, 30927, 31110, 31375, 31377, 31379, 31381,
		31383, 31384, 31388, 31437, 31458, 31474, 31620, 31770, 32139, 32317,
		32321, 32323, 32326, 32344, 32346, 32347, 32349, 32354, 32433, 32518,
		32594, 32801, 32820, 32881, 32989, 33060, 33130, 33162, 33233, 33273,
		33325, 33344, 33362, 33388, 33408, 33438, 33458, 33561, 33644, 33700,
		33880, 33923, 33969, 33982, 33991, 34010, 34025, 34043, 34055, 34065,
		34082, 34102, 34112, 34122, 34142, 34158, 34170, 34187, 34211
	};

	std::vector<int> res;
	ASSERT_NO_THROW(res = Load("data/keyframe/xvid.txt"));

	EXPECT_TRUE(expected == res);
}

TEST(lagi_keyframe, x264) {
	std::vector<int> expected(41);
	for (size_t i = 0; i < 41; ++i) expected[i] = i * 250;

	std::vector<int> res;
	ASSERT_NO_THROW(res = Load("data/keyframe/x264.log"));

	EXPECT_TRUE(expected == res);
}

TEST(lagi_keyframe, aegi) {
	std::vector<int> expected(135);
	for (size_t i = 0; i < 135; ++i) expected[i] = i * 250;

	std::vector<int> res;
	ASSERT_NO_THROW(res = Load("data/keyframe/aegi.txt"));

	EXPECT_TRUE(expected == res);
}
