; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc  -O0 -mtriple=mipsel-linux-gnu -global-isel -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32,FP32
; RUN: llc  -O0 -mtriple=mipsel-linux-gnu -mattr=+fp64,+mips32r2 -global-isel -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32,FP64

declare float @llvm.sqrt.f32(float)
define float @sqrt_f32(float %a) {
; MIPS32-LABEL: sqrt_f32:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sqrt.s $f0, $f12
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %0 = call float @llvm.sqrt.f32(float %a)
  ret float %0
}

declare double @llvm.sqrt.f64(double)
define double @sqrt_f64(double %a) {
; MIPS32-LABEL: sqrt_f64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sqrt.d $f0, $f12
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %0 = call double @llvm.sqrt.f64(double %a)
  ret double %0
}
