# -*- warn-indent:false;  -*-

# line 1 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"

# line 650 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"


# THIS IS A GENERATED FILE, DO NOT EDIT DIRECTLY
# This file was generated from lib/regexp_parser/scanner/scanner.rl

require 'regexp_parser/error'

class Regexp::Scanner
  # General scanner error (catch all)
  class ScannerError < Regexp::Parser::Error; end

  # Base for all scanner validation errors
  class ValidationError < Regexp::Parser::Error
    def initialize(reason)
      super reason
    end
  end

  # Unexpected end of pattern
  class PrematureEndError < ScannerError
    def initialize(where = '')
      super "Premature end of pattern at #{where}"
    end
  end

  # Invalid sequence format. Used for escape sequences, mainly.
  class InvalidSequenceError < ValidationError
    def initialize(what = 'sequence', where = '')
      super "Invalid #{what} at #{where}"
    end
  end

  # Invalid group. Used for named groups.
  class InvalidGroupError < ValidationError
    def initialize(what, reason)
      super "Invalid #{what}, #{reason}."
    end
  end

  # Invalid groupOption. Used for inline options.
  # TODO: should become InvalidGroupOptionError in v3.0.0 for consistency
  class InvalidGroupOption < ValidationError
    def initialize(option, text)
      super "Invalid group option #{option} in #{text}"
    end
  end

  # Invalid back reference. Used for name a number refs/calls.
  class InvalidBackrefError < ValidationError
    def initialize(what, reason)
      super "Invalid back reference #{what}, #{reason}"
    end
  end

  # The property name was not recognized by the scanner.
  class UnknownUnicodePropertyError < ValidationError
    def initialize(name)
      super "Unknown unicode character property name #{name}"
    end
  end

  # The POSIX class name was not recognized by the scanner.
  class UnknownPosixClassError < ValidationError
    def initialize(text)
      super "Unknown POSIX class #{text}"
    end
  end

  # Scans the given regular expression text, or Regexp object and collects the
  # emitted token into an array that gets returned at the end. If a block is
  # given, it gets called for each emitted token.
  #
  # This method may raise errors if a syntax error is encountered.
  # --------------------------------------------------------------------------
  def self.scan(input_object, options: nil, collect_tokens: true, &block)
    new.scan(input_object, options: options, collect_tokens: collect_tokens, &block)
  end

  def scan(input_object, options: nil, collect_tokens: true, &block)
    self.collect_tokens = collect_tokens
    self.literal_run = nil
    stack = []

    input = input_object.is_a?(Regexp) ? input_object.source : input_object
    self.free_spacing = free_spacing?(input_object, options)
    self.spacing_stack = [{:free_spacing => free_spacing, :depth => 0}]

    data  = input.unpack("c*")
    eof   = data.length

    self.tokens = []
    self.block  = block

    self.set_depth = 0
    self.group_depth = 0
    self.conditional_stack = []
    self.char_pos = 0

    
# line 105 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner.rb"
class << self
	attr_accessor :_re_scanner_trans_keys
	private :_re_scanner_trans_keys, :_re_scanner_trans_keys=
end
self._re_scanner_trans_keys = [
	0, 0, -128, -65, -128, -65, 
	-128, -65, 41, 41, 39, 
	57, 39, 39, 33, 62, 
	62, 62, 39, 60, 39, 57, 
	39, 39, 48, 57, 39, 
	57, 39, 57, 48, 57, 
	39, 39, 33, 62, 62, 62, 
	48, 57, 48, 62, 43, 
	62, 48, 57, 62, 62, 
	39, 60, 39, 57, 39, 39, 
	48, 57, 39, 57, 39, 
	57, 48, 57, 33, 62, 
	62, 62, 48, 57, 48, 62, 
	43, 62, 48, 57, 48, 
	57, 48, 125, 44, 125, 
	123, 123, 9, 122, 9, 125, 
	9, 122, -128, -65, -128, 
	-65, 38, 38, 58, 93, 
	58, 93, -128, -65, -128, -65, 
	45, 45, 92, 92, 92, 
	92, 45, 45, 92, 92, 
	92, 92, 48, 123, 48, 102, 
	48, 102, 48, 102, 48, 
	102, 9, 125, 9, 125, 
	9, 125, 9, 125, 9, 125, 
	9, 125, 48, 123, 39, 
	39, 41, 41, 41, 57, 
	62, 62, -128, 127, -62, -12, 
	1, 127, 1, 127, 9, 
	32, 33, 126, 10, 10, 
	63, 63, 33, 126, 33, 126, 
	62, 62, 43, 63, 43, 
	63, 43, 63, 65, 122, 
	44, 57, 68, 119, 80, 112, 
	-62, 125, -128, -65, -128, 
	-65, -128, -65, 38, 38, 
	38, 93, 58, 58, 48, 120, 
	48, 55, 48, 55, -62, 
	125, -128, -65, -128, -65, 
	-128, -65, 48, 55, 48, 55, 
	77, 77, 45, 45, 0, 
	0, 67, 99, 45, 45, 
	0, 0, 92, 92, 48, 102, 
	39, 60, 39, 57, 49, 
	57, 41, 57, 33, 62, 
	0
]

class << self
	attr_accessor :_re_scanner_key_spans
	private :_re_scanner_key_spans, :_re_scanner_key_spans=
end
self._re_scanner_key_spans = [
	0, 64, 64, 64, 1, 19, 1, 30, 
	1, 22, 19, 1, 10, 19, 19, 10, 
	1, 30, 1, 10, 15, 20, 10, 1, 
	22, 19, 1, 10, 19, 19, 10, 30, 
	1, 10, 15, 20, 10, 10, 78, 82, 
	1, 114, 117, 114, 64, 64, 1, 36, 
	36, 64, 64, 1, 1, 1, 1, 1, 
	1, 76, 55, 55, 55, 55, 117, 117, 
	117, 117, 117, 117, 76, 1, 1, 17, 
	1, 256, 51, 127, 127, 24, 94, 1, 
	1, 94, 94, 1, 21, 21, 21, 58, 
	14, 52, 33, 188, 64, 64, 64, 1, 
	56, 1, 73, 8, 8, 188, 64, 64, 
	64, 8, 8, 1, 1, 0, 33, 1, 
	0, 1, 55, 22, 19, 9, 17, 30
]

class << self
	attr_accessor :_re_scanner_index_offsets
	private :_re_scanner_index_offsets, :_re_scanner_index_offsets=
end
self._re_scanner_index_offsets = [
	0, 0, 65, 130, 195, 197, 217, 219, 
	250, 252, 275, 295, 297, 308, 328, 348, 
	359, 361, 392, 394, 405, 421, 442, 453, 
	455, 478, 498, 500, 511, 531, 551, 562, 
	593, 595, 606, 622, 643, 654, 665, 744, 
	827, 829, 944, 1062, 1177, 1242, 1307, 1309, 
	1346, 1383, 1448, 1513, 1515, 1517, 1519, 1521, 
	1523, 1525, 1602, 1658, 1714, 1770, 1826, 1944, 
	2062, 2180, 2298, 2416, 2534, 2611, 2613, 2615, 
	2633, 2635, 2892, 2944, 3072, 3200, 3225, 3320, 
	3322, 3324, 3419, 3514, 3516, 3538, 3560, 3582, 
	3641, 3656, 3709, 3743, 3932, 3997, 4062, 4127, 
	4129, 4186, 4188, 4262, 4271, 4280, 4469, 4534, 
	4599, 4664, 4673, 4682, 4684, 4686, 4687, 4721, 
	4723, 4724, 4726, 4782, 4805, 4825, 4835, 4853
]

class << self
	attr_accessor :_re_scanner_indicies
	private :_re_scanner_indicies, :_re_scanner_indicies=
end
self._re_scanner_indicies = [
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	0, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 0, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 0, 6, 5, 8, 7, 7, 
	7, 7, 7, 4, 7, 7, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 
	7, 8, 7, 10, 9, 9, 9, 9, 
	9, 9, 9, 9, 9, 9, 9, 4, 
	9, 9, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 9, 9, 9, 11, 
	8, 9, 8, 9, 13, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 14, 12, 16, 15, 15, 15, 15, 
	15, 17, 15, 15, 18, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 15, 16, 
	15, 20, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 12, 16, 12, 12, 12, 
	12, 12, 12, 12, 12, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 20, 12, 
	16, 12, 12, 12, 21, 12, 21, 12, 
	12, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 12, 20, 20, 20, 20, 
	20, 20, 20, 20, 20, 20, 12, 16, 
	12, 12, 22, 22, 22, 22, 22, 22, 
	22, 22, 22, 22, 22, 23, 22, 22, 
	24, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 22, 22, 22, 22, 16, 22, 
	16, 22, 26, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 12, 26, 26, 26, 
	26, 26, 26, 26, 26, 26, 26, 12, 
	12, 12, 12, 16, 12, 27, 12, 27, 
	12, 12, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 12, 12, 12, 12, 
	16, 12, 26, 26, 26, 26, 26, 26, 
	26, 26, 26, 26, 12, 16, 12, 28, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 29, 12, 31, 30, 
	30, 30, 30, 30, 32, 30, 30, 12, 
	33, 33, 33, 33, 33, 33, 33, 33, 
	33, 30, 31, 30, 34, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 12, 31, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 34, 12, 31, 12, 12, 12, 35, 
	12, 35, 12, 12, 33, 33, 33, 33, 
	33, 33, 33, 33, 33, 33, 12, 34, 
	34, 34, 34, 34, 34, 34, 34, 34, 
	34, 12, 12, 36, 36, 36, 36, 36, 
	36, 36, 36, 36, 36, 36, 37, 36, 
	36, 12, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 36, 36, 36, 36, 31, 
	36, 31, 36, 39, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 12, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	12, 12, 12, 12, 31, 12, 40, 12, 
	40, 12, 12, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 12, 12, 12, 
	12, 31, 12, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 12, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	41, 42, 42, 42, 42, 42, 42, 42, 
	42, 42, 42, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 43, 41, 
	42, 41, 41, 41, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 43, 41, 45, 46, 47, 47, 47, 
	47, 47, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 47, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 47, 47, 46, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 46, 46, 
	46, 47, 46, 46, 46, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 46, 
	46, 46, 48, 47, 46, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 46, 
	47, 47, 47, 47, 47, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 47, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 47, 47, 46, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 46, 46, 46, 47, 46, 46, 46, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 46, 46, 46, 46, 47, 46, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 46, 46, 49, 46, 47, 47, 
	47, 47, 47, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 47, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 47, 47, 46, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 46, 
	46, 46, 47, 46, 46, 46, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	46, 46, 46, 46, 47, 46, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	46, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 50, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 50, 54, 53, 57, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 58, 56, 
	58, 56, 57, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 58, 56, 59, 56, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 60, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	60, 63, 46, 65, 64, 67, 64, 68, 
	46, 70, 69, 72, 69, 73, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 46, 
	46, 46, 46, 46, 46, 46, 73, 73, 
	73, 73, 73, 73, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 73, 73, 
	73, 73, 73, 73, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	74, 46, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 46, 46, 46, 46, 
	46, 46, 46, 75, 75, 75, 75, 75, 
	75, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 75, 75, 75, 75, 75, 
	75, 46, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 46, 46, 46, 46, 
	46, 46, 46, 76, 76, 76, 76, 76, 
	76, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 76, 76, 76, 76, 76, 
	76, 46, 77, 77, 77, 77, 77, 77, 
	77, 77, 77, 77, 46, 46, 46, 46, 
	46, 46, 46, 77, 77, 77, 77, 77, 
	77, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 77, 77, 77, 77, 77, 
	77, 46, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 78, 46, 46, 46, 46, 
	46, 46, 46, 78, 78, 78, 78, 78, 
	78, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 78, 78, 78, 78, 78, 
	78, 46, 74, 74, 74, 74, 74, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 74, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 79, 79, 79, 79, 79, 79, 79, 
	79, 79, 79, 46, 46, 46, 46, 46, 
	46, 46, 79, 79, 79, 79, 79, 79, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 79, 79, 79, 79, 79, 79, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 77, 46, 
	74, 74, 74, 74, 74, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 74, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 46, 46, 46, 46, 46, 46, 46, 
	80, 80, 80, 80, 80, 80, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	80, 80, 80, 80, 80, 80, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 77, 46, 74, 74, 
	74, 74, 74, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 74, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 46, 
	46, 46, 46, 46, 46, 46, 81, 81, 
	81, 81, 81, 81, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 81, 81, 
	81, 81, 81, 81, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 77, 46, 74, 74, 74, 74, 
	74, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 74, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 46, 46, 46, 
	46, 46, 46, 46, 82, 82, 82, 82, 
	82, 82, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 82, 82, 82, 82, 
	82, 82, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	77, 46, 74, 74, 74, 74, 74, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 74, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 83, 83, 83, 83, 83, 83, 83, 
	83, 83, 83, 46, 46, 46, 46, 46, 
	46, 46, 83, 83, 83, 83, 83, 83, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 83, 83, 83, 83, 83, 83, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 77, 46, 
	74, 74, 74, 74, 74, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 74, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 77, 46, 85, 85, 
	85, 85, 85, 85, 85, 85, 85, 85, 
	84, 84, 84, 84, 84, 84, 84, 85, 
	85, 85, 85, 85, 85, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 85, 
	85, 85, 85, 85, 85, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 46, 84, 88, 87, 89, 86, 89, 
	86, 86, 86, 86, 86, 86, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	86, 88, 91, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 92, 92, 92, 92, 92, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 93, 93, 93, 93, 
	93, 93, 93, 93, 94, 94, 94, 94, 
	94, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 95, 96, 96, 97, 98, 
	96, 96, 96, 99, 100, 101, 102, 96, 
	96, 103, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 104, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 105, 106, 
	107, 108, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 109, 110, 
	107, 96, 93, 96, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 92, 92, 92, 92, 92, 111, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 93, 111, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	94, 94, 94, 94, 94, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 95, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 93, 112, 
	95, 95, 95, 95, 95, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 112, 
	112, 112, 112, 112, 112, 112, 112, 95, 
	112, 96, 96, 111, 111, 96, 96, 96, 
	111, 111, 111, 111, 96, 96, 111, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 111, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 111, 111, 111, 111, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 96, 96, 96, 96, 96, 
	96, 96, 96, 111, 111, 111, 96, 111, 
	114, 97, 116, 115, 10, 118, 5, 118, 
	118, 118, 119, 120, 117, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 8, 118, 121, 
	10, 8, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 8, 118, 117, 118, 117, 118, 118, 
	118, 117, 117, 117, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 122, 118, 117, 117, 
	117, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	118, 118, 118, 118, 118, 118, 118, 118, 
	117, 118, 8, 9, 125, 124, 124, 124, 
	124, 124, 124, 124, 124, 124, 124, 124, 
	124, 124, 124, 124, 124, 124, 124, 124, 
	125, 124, 127, 126, 126, 126, 126, 126, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	126, 126, 126, 126, 126, 126, 127, 126, 
	129, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 129, 128, 131, 131, 
	130, 130, 130, 130, 131, 130, 130, 130, 
	132, 130, 130, 130, 130, 130, 130, 130, 
	130, 130, 130, 130, 130, 130, 130, 131, 
	130, 130, 130, 130, 130, 130, 130, 131, 
	130, 130, 130, 130, 133, 130, 130, 130, 
	134, 130, 130, 130, 130, 130, 130, 130, 
	130, 130, 130, 130, 130, 130, 130, 131, 
	130, 136, 135, 135, 135, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 135, 
	137, 46, 46, 46, 137, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 137, 137, 
	46, 46, 46, 137, 137, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	137, 46, 46, 46, 137, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 137, 
	46, 46, 46, 137, 46, 138, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 46, 46, 46, 
	46, 46, 46, 46, 46, 138, 46, 139, 
	139, 139, 139, 139, 139, 139, 139, 139, 
	139, 139, 139, 139, 139, 139, 139, 139, 
	139, 139, 139, 139, 139, 139, 139, 139, 
	139, 139, 139, 139, 139, 140, 140, 140, 
	140, 140, 140, 140, 140, 140, 140, 140, 
	140, 140, 140, 140, 140, 141, 141, 141, 
	141, 141, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 142, 51, 143, 51, 142, 142, 142, 
	142, 51, 144, 142, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 142, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	145, 146, 147, 148, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	142, 142, 142, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 51, 51, 51, 51, 
	51, 51, 51, 51, 149, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 149, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 150, 150, 
	150, 150, 150, 150, 150, 150, 149, 151, 
	149, 153, 152, 152, 152, 152, 152, 152, 
	152, 152, 152, 152, 152, 152, 152, 152, 
	152, 152, 152, 152, 152, 152, 152, 152, 
	152, 152, 152, 152, 152, 152, 152, 152, 
	152, 152, 152, 152, 152, 152, 152, 152, 
	152, 152, 152, 152, 152, 152, 152, 152, 
	152, 152, 152, 152, 152, 152, 152, 152, 
	154, 152, 56, 156, 158, 158, 158, 158, 
	158, 158, 158, 158, 157, 157, 157, 157, 
	157, 157, 157, 157, 157, 157, 157, 159, 
	159, 157, 157, 157, 159, 157, 157, 157, 
	157, 159, 157, 157, 159, 157, 157, 159, 
	157, 157, 157, 159, 157, 157, 157, 159, 
	159, 159, 157, 157, 157, 159, 159, 159, 
	159, 159, 159, 157, 159, 157, 157, 157, 
	157, 157, 159, 157, 159, 157, 159, 159, 
	159, 159, 159, 159, 159, 157, 161, 161, 
	161, 161, 161, 161, 161, 161, 160, 162, 
	162, 162, 162, 162, 162, 162, 162, 160, 
	163, 163, 163, 163, 163, 163, 163, 163, 
	163, 163, 163, 163, 163, 163, 163, 163, 
	163, 163, 163, 163, 163, 163, 163, 163, 
	163, 163, 163, 163, 163, 163, 164, 164, 
	164, 164, 164, 164, 164, 164, 164, 164, 
	164, 164, 164, 164, 164, 164, 165, 165, 
	165, 165, 165, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 166, 61, 61, 61, 166, 166, 
	166, 166, 61, 61, 166, 61, 167, 168, 
	168, 168, 168, 168, 168, 168, 169, 169, 
	61, 61, 61, 61, 61, 166, 61, 46, 
	46, 170, 171, 61, 61, 46, 171, 61, 
	61, 46, 61, 172, 61, 61, 173, 61, 
	171, 171, 61, 61, 61, 171, 171, 61, 
	46, 166, 166, 166, 166, 61, 61, 174, 
	174, 63, 171, 174, 174, 61, 171, 61, 
	61, 61, 61, 61, 174, 61, 173, 61, 
	174, 171, 174, 175, 174, 171, 176, 61, 
	46, 166, 166, 166, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 61, 61, 61, 
	61, 61, 61, 61, 61, 177, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 177, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 177, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	179, 182, 182, 182, 182, 182, 182, 182, 
	182, 181, 184, 64, 186, 185, 64, 188, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 189, 
	69, 191, 190, 69, 72, 69, 193, 193, 
	193, 193, 193, 193, 193, 193, 193, 193, 
	192, 192, 192, 192, 192, 192, 192, 193, 
	193, 193, 193, 193, 193, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 193, 
	193, 193, 193, 193, 193, 192, 195, 194, 
	194, 194, 194, 194, 196, 194, 194, 194, 
	197, 197, 197, 197, 197, 197, 197, 197, 
	197, 194, 194, 198, 194, 88, 87, 87, 
	87, 87, 87, 199, 87, 87, 199, 199, 
	199, 199, 199, 199, 199, 199, 199, 199, 
	87, 90, 90, 90, 90, 90, 90, 90, 
	90, 90, 199, 89, 199, 199, 199, 199, 
	199, 199, 90, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 199, 199, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 199, 91, 91, 199, 199, 199, 199, 
	199, 199, 199, 199, 199, 199, 91, 91, 
	91, 91, 88, 91, 0
]

class << self
	attr_accessor :_re_scanner_trans_targs
	private :_re_scanner_trans_targs, :_re_scanner_trans_targs=
end
self._re_scanner_trans_targs = [
	73, 74, 1, 2, 73, 4, 73, 6, 
	73, 8, 73, 83, 73, 10, 17, 11, 
	73, 12, 16, 14, 13, 15, 18, 19, 
	23, 21, 20, 22, 25, 31, 26, 73, 
	27, 29, 28, 30, 32, 33, 35, 34, 
	36, 73, 38, 73, 39, 41, 0, 42, 
	43, 90, 91, 91, 44, 91, 91, 91, 
	47, 48, 91, 91, 101, 101, 49, 52, 
	101, 107, 101, 109, 55, 101, 110, 101, 
	112, 58, 61, 59, 60, 101, 62, 63, 
	64, 65, 66, 67, 101, 114, 115, 69, 
	70, 115, 71, 72, 3, 75, 76, 77, 
	78, 79, 73, 80, 73, 84, 85, 73, 
	86, 73, 87, 73, 73, 88, 73, 73, 
	73, 73, 73, 73, 81, 73, 82, 5, 
	73, 7, 73, 73, 73, 73, 73, 73, 
	73, 73, 73, 73, 73, 9, 24, 73, 
	37, 89, 40, 92, 93, 94, 91, 95, 
	96, 97, 91, 91, 91, 91, 45, 91, 
	91, 46, 91, 91, 91, 98, 99, 98, 
	98, 100, 98, 102, 103, 104, 101, 105, 
	105, 101, 51, 101, 54, 101, 101, 57, 
	68, 101, 50, 101, 106, 101, 101, 101, 
	108, 101, 53, 101, 111, 113, 101, 56, 
	101, 101, 115, 116, 117, 118, 119, 115
]

class << self
	attr_accessor :_re_scanner_trans_actions
	private :_re_scanner_trans_actions, :_re_scanner_trans_actions=
end
self._re_scanner_trans_actions = [
	1, 2, 0, 0, 3, 4, 5, 0, 
	6, 0, 7, 8, 9, 0, 0, 0, 
	10, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 11, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 12, 0, 13, 0, 0, 0, 0, 
	0, 15, 16, 17, 0, 18, 19, 20, 
	0, 0, 21, 22, 23, 24, 0, 0, 
	26, 0, 27, 0, 0, 28, 0, 29, 
	0, 0, 0, 0, 0, 30, 0, 0, 
	0, 0, 0, 0, 31, 0, 32, 0, 
	0, 33, 0, 0, 0, 0, 0, 0, 
	0, 0, 36, 37, 38, 0, 0, 39, 
	0, 40, 41, 42, 43, 41, 44, 45, 
	46, 47, 48, 49, 50, 51, 0, 0, 
	52, 0, 53, 54, 55, 56, 57, 58, 
	59, 60, 61, 62, 63, 0, 0, 64, 
	0, 66, 0, 0, 41, 41, 67, 0, 
	41, 68, 69, 70, 71, 72, 0, 73, 
	74, 0, 75, 76, 77, 78, 0, 79, 
	80, 0, 81, 0, 41, 41, 82, 83, 
	84, 85, 0, 86, 0, 87, 88, 0, 
	0, 89, 0, 90, 0, 91, 92, 93, 
	41, 94, 0, 95, 41, 0, 96, 0, 
	97, 98, 99, 41, 41, 41, 41, 100
]

class << self
	attr_accessor :_re_scanner_to_state_actions
	private :_re_scanner_to_state_actions, :_re_scanner_to_state_actions=
end
self._re_scanner_to_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 34, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 65, 65, 65, 0, 0, 0, 0, 
	0, 0, 65, 0, 0, 65, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 65, 0, 0, 0, 0
]

class << self
	attr_accessor :_re_scanner_from_state_actions
	private :_re_scanner_from_state_actions, :_re_scanner_from_state_actions=
end
self._re_scanner_from_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 35, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 35, 35, 35, 0, 0, 0, 0, 
	0, 0, 35, 0, 0, 35, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 35, 0, 0, 0, 0
]

class << self
	attr_accessor :_re_scanner_eof_actions
	private :_re_scanner_eof_actions, :_re_scanner_eof_actions=
end
self._re_scanner_eof_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	14, 14, 14, 14, 0, 0, 0, 0, 
	0, 0, 0, 25, 25, 0, 25, 25, 
	0, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 25, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 25, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0
]

class << self
	attr_accessor :_re_scanner_eof_trans
	private :_re_scanner_eof_trans, :_re_scanner_eof_trans=
end
self._re_scanner_eof_trans = [
	0, 1, 1, 1, 5, 5, 5, 5, 
	1, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 42, 42, 42, 
	0, 0, 0, 0, 51, 51, 54, 56, 
	56, 61, 61, 0, 0, 67, 0, 0, 
	72, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 87, 87, 87, 
	87, 0, 112, 112, 113, 113, 112, 114, 
	116, 118, 118, 124, 125, 127, 129, 131, 
	136, 0, 0, 0, 150, 150, 150, 150, 
	153, 156, 0, 161, 161, 0, 178, 178, 
	178, 180, 182, 184, 184, 184, 188, 188, 
	188, 188, 193, 0, 200, 200, 200, 200
]

class << self
	attr_accessor :re_scanner_start
end
self.re_scanner_start = 73;
class << self
	attr_accessor :re_scanner_first_final
end
self.re_scanner_first_final = 73;
class << self
	attr_accessor :re_scanner_error
end
self.re_scanner_error = 0;

class << self
	attr_accessor :re_scanner_en_char_type
end
self.re_scanner_en_char_type = 89;
class << self
	attr_accessor :re_scanner_en_unicode_property
end
self.re_scanner_en_unicode_property = 90;
class << self
	attr_accessor :re_scanner_en_character_set
end
self.re_scanner_en_character_set = 91;
class << self
	attr_accessor :re_scanner_en_set_escape_sequence
end
self.re_scanner_en_set_escape_sequence = 98;
class << self
	attr_accessor :re_scanner_en_escape_sequence
end
self.re_scanner_en_escape_sequence = 101;
class << self
	attr_accessor :re_scanner_en_conditional_expression
end
self.re_scanner_en_conditional_expression = 115;
class << self
	attr_accessor :re_scanner_en_main
end
self.re_scanner_en_main = 73;


# line 749 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
    
# line 1018 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner.rb"
begin
	p ||= 0
	pe ||= data.length
	cs = re_scanner_start
	top = 0
	ts = nil
	te = nil
	act = 0
end

# line 750 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
    
# line 1031 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner.rb"
begin
	testEof = false
	_slen, _trans, _keys, _inds, _acts, _nacts = nil
	_goto_level = 0
	_resume = 10
	_eof_trans = 15
	_again = 20
	_test_eof = 30
	_out = 40
	while true
	if _goto_level <= 0
	if p == pe
		_goto_level = _test_eof
		next
	end
	if cs == 0
		_goto_level = _out
		next
	end
	end
	if _goto_level <= _resume
	case _re_scanner_from_state_actions[cs] 
	when 35 then
# line 1 "NONE"
		begin
ts = p
		end
# line 1059 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner.rb"
	end
	_keys = cs << 1
	_inds = _re_scanner_index_offsets[cs]
	_slen = _re_scanner_key_spans[cs]
	_wide = data[p].ord
	_trans = if (   _slen > 0 && 
			_re_scanner_trans_keys[_keys] <= _wide && 
			_wide <= _re_scanner_trans_keys[_keys + 1] 
		    ) then
			_re_scanner_indicies[ _inds + _wide - _re_scanner_trans_keys[_keys] ] 
		 else 
			_re_scanner_indicies[ _inds + _slen ]
		 end
	end
	if _goto_level <= _eof_trans
	cs = _re_scanner_trans_targs[_trans]
	if _re_scanner_trans_actions[_trans] != 0
	case _re_scanner_trans_actions[_trans]
	when 37 then
# line 147 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth + 1 		end
	when 4 then
# line 148 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1 		end
	when 41 then
# line 1 "NONE"
		begin
te = p+1
		end
	when 66 then
# line 12 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/char_type.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts-1, te)
      when '\d'; emit(:type, :digit,      text)
      when '\D'; emit(:type, :nondigit,   text)
      when '\h'; emit(:type, :hex,        text)
      when '\H'; emit(:type, :nonhex,     text)
      when '\s'; emit(:type, :space,      text)
      when '\S'; emit(:type, :nonspace,   text)
      when '\w'; emit(:type, :word,       text)
      when '\W'; emit(:type, :nonword,    text)
      when '\R'; emit(:type, :linebreak,  text)
      when '\X'; emit(:type, :xgrapheme,  text)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 15 then
# line 16 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/property.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts-1, te)
      type = (text[1] == 'P') ^ (text[3] == '^') ? :nonproperty : :property

      name = text[3..-2].gsub(/[\^\s_\-]/, '').downcase

      token = self.class.short_prop_map[name] || self.class.long_prop_map[name]
      validation_error(:property, name) unless token

      self.emit(type, token.to_sym, text)

      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 19 then
# line 175 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin  # special case, emits two tokens
      emit(:literal, :literal, '-')
      emit(:set, :intersection, '&&')
     end
		end
	when 71 then
# line 180 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if prev_token[1] == :open
        emit(:set, :negate, '^')
      else
        emit(:literal, :literal, '^')
      end
     end
		end
	when 73 then
# line 200 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:set, :intersection, '&&')
     end
		end
	when 69 then
# line 204 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      	begin
		stack[top] = cs
		top+= 1
		cs = 98
		_goto_level = _again
		next
	end

     end
		end
	when 67 then
# line 238 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:literal, :literal, copy(data, ts, te))
     end
		end
	when 17 then
# line 242 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts, te)
      emit(:literal, :literal, text)
     end
		end
	when 74 then
# line 188 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      # ranges cant start with the opening bracket, a subset, or
      # intersection/negation/range operators
      if prev_token[0] == :set
        emit(:literal, :literal, '-')
      else
        emit(:set, :range, '-')
      end
     end
		end
	when 77 then
# line 208 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:set, :open, '[')
      	begin
		stack[top] = cs
		top+= 1
		cs = 91
		_goto_level = _again
		next
	end

     end
		end
	when 72 then
# line 242 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      text = copy(data, ts, te)
      emit(:literal, :literal, text)
     end
		end
	when 18 then
# line 188 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      # ranges cant start with the opening bracket, a subset, or
      # intersection/negation/range operators
      if prev_token[0] == :set
        emit(:literal, :literal, '-')
      else
        emit(:set, :range, '-')
      end
     end
		end
	when 21 then
# line 208 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit(:set, :open, '[')
      	begin
		stack[top] = cs
		top+= 1
		cs = 91
		_goto_level = _again
		next
	end

     end
		end
	when 16 then
# line 242 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      text = copy(data, ts, te)
      emit(:literal, :literal, text)
     end
		end
	when 81 then
# line 252 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :octal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 79 then
# line 258 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      cs = 91;
      	begin
		stack[top] = cs
		top+= 1
		cs = 101
		_goto_level = _again
		next
	end

     end
		end
	when 78 then
# line 267 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :literal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 80 then
# line 252 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:escape, :octal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 85 then
# line 277 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts-1, te)
      emit(:backref, :number, text)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 92 then
# line 283 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :octal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 82 then
# line 288 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts-1, te)
      when '\.';  emit(:escape, :dot,               text)
      when '\|';  emit(:escape, :alternation,       text)
      when '\^';  emit(:escape, :bol,               text)
      when '\$';  emit(:escape, :eol,               text)
      when '\?';  emit(:escape, :zero_or_one,       text)
      when '\*';  emit(:escape, :zero_or_more,      text)
      when '\+';  emit(:escape, :one_or_more,       text)
      when '\(';  emit(:escape, :group_open,        text)
      when '\)';  emit(:escape, :group_close,       text)
      when '\{';  emit(:escape, :interval_open,     text)
      when '\}';  emit(:escape, :interval_close,    text)
      when '\[';  emit(:escape, :set_open,          text)
      when '\]';  emit(:escape, :set_close,         text)
      when "\\\\";
        emit(:escape, :backslash, text)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 88 then
# line 309 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      # \b is emitted as backspace only when inside a character set, otherwise
      # it is a word boundary anchor. A syntax might "normalize" it if needed.
      case text = copy(data, ts-1, te)
      when '\a'; emit(:escape, :bell,           text)
      when '\b'; emit(:escape, :backspace,      text)
      when '\e'; emit(:escape, :escape,         text)
      when '\f'; emit(:escape, :form_feed,      text)
      when '\n'; emit(:escape, :newline,        text)
      when '\r'; emit(:escape, :carriage,       text)
      when '\t'; emit(:escape, :tab,            text)
      when '\v'; emit(:escape, :vertical_tab,   text)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 30 then
# line 325 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts-1, te)
      if text[2] == '{'
        emit(:escape, :codepoint_list, text)
      else
        emit(:escape, :codepoint,      text)
      end
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 98 then
# line 335 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :hex, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 26 then
# line 344 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 28 then
# line 349 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 86 then
# line 354 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      cs = ((in_set? ? 91 : 73));
      	begin
		stack[top] = cs
		top+= 1
		cs = 89
		_goto_level = _again
		next
	end

     end
		end
	when 87 then
# line 360 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      cs = ((in_set? ? 91 : 73));
      	begin
		stack[top] = cs
		top+= 1
		cs = 90
		_goto_level = _again
		next
	end

     end
		end
	when 24 then
# line 366 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:escape, :literal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 91 then
# line 283 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:escape, :octal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 97 then
# line 335 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:escape, :hex, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 94 then
# line 344 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 96 then
# line 349 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 89 then
# line 366 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:escape, :literal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 23 then
# line 366 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit(:escape, :literal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 90 then
# line 1 "NONE"
		begin
	case act
	when 17 then
	begin begin p = ((te))-1; end

      text = copy(data, ts-1, te)
      emit(:backref, :number, text)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

    end
	when 18 then
	begin begin p = ((te))-1; end

      emit(:escape, :octal, copy(data, ts-1, te))
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

    end
end 
			end
	when 33 then
# line 376 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts, te-1)
      emit(:conditional, :condition, text)
      emit(:conditional, :condition_close, ')')
     end
		end
	when 99 then
# line 382 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 73
		_goto_level = _again
		next
	end

     end
		end
	when 100 then
# line 382 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 73
		_goto_level = _again
		next
	end

     end
		end
	when 32 then
# line 382 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      p = p - 1;
      	begin
		stack[top] = cs
		top+= 1
		cs = 73
		_goto_level = _again
		next
	end

     end
		end
	when 39 then
# line 395 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:meta, :dot, copy(data, ts, te))
     end
		end
	when 44 then
# line 399 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if conditional_stack.last == group_depth
        emit(:conditional, :separator, copy(data, ts, te))
      else
        emit(:meta, :alternation, copy(data, ts, te))
      end
     end
		end
	when 43 then
# line 409 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:anchor, :bol, copy(data, ts, te))
     end
		end
	when 36 then
# line 413 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:anchor, :eol, copy(data, ts, te))
     end
		end
	when 63 then
# line 417 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:keep, :mark, copy(data, ts, te))
     end
		end
	when 62 then
# line 421 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '\A';  emit(:anchor, :bos,                text)
      when '\z';  emit(:anchor, :eos,                text)
      when '\Z';  emit(:anchor, :eos_ob_eol,         text)
      when '\b';  emit(:anchor, :word_boundary,      text)
      when '\B';  emit(:anchor, :nonword_boundary,   text)
      when '\G';  emit(:anchor, :match_start,        text)
      end
     end
		end
	when 42 then
# line 432 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      append_literal(data, ts, te)
     end
		end
	when 52 then
# line 447 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts, te)

      conditional_stack << group_depth

      emit(:conditional, :open, text[0..-2])
      emit(:conditional, :condition_open, '(')
      	begin
		stack[top] = cs
		top+= 1
		cs = 115
		_goto_level = _again
		next
	end

     end
		end
	when 53 then
# line 478 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts, te)
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        validation_error(:group_option, $1 || "-#{$2}", text)
      end
      emit_options(text)
     end
		end
	when 7 then
# line 492 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '(?=';  emit(:assertion, :lookahead,    text)
      when '(?!';  emit(:assertion, :nlookahead,   text)
      when '(?<='; emit(:assertion, :lookbehind,   text)
      when '(?<!'; emit(:assertion, :nlookbehind,  text)
      end
     end
		end
	when 6 then
# line 509 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '(?:';  emit(:group, :passive,      text)
      when '(?>';  emit(:group, :atomic,       text)
      when '(?~';  emit(:group, :absence,      text)

      when /^\(\?(?:<>|'')/
        validation_error(:group, 'named group', 'name is empty')

      when /^\(\?<[^>]+>/
        emit(:group, :named_ab,  text)

      when /^\(\?'[^']+'/
        emit(:group, :named_sq,  text)

      end
     end
		end
	when 11 then
# line 550 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when /^\\k(<>|'')/
        validation_error(:backref, 'backreference', 'ref ID is empty')
      when /^\\k(.)[^\p{digit}\-][^+\-]*\D$/
        emit(:backref, $1 == '<' ? :name_ref_ab : :name_ref_sq, text)
      when /^\\k(.)\d+\D$/
        emit(:backref, $1 == '<' ? :number_ref_ab : :number_ref_sq, text)
      when /^\\k(.)-\d+\D$/
        emit(:backref, $1 == '<' ? :number_rel_ref_ab : :number_rel_ref_sq, text)
      when /^\\k(.)[^\p{digit}\-].*[+\-]\d+\D$/
        emit(:backref, $1 == '<' ? :name_recursion_ref_ab : :name_recursion_ref_sq, text)
      when /^\\k(.)-?\d+[+\-]\d+\D$/
        emit(:backref, $1 == '<' ? :number_recursion_ref_ab : :number_recursion_ref_sq, text)
      end
     end
		end
	when 10 then
# line 569 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when /^\\g(<>|'')/
        validation_error(:backref, 'subexpression call', 'ref ID is empty')
      when /^\\g(.)[^\p{digit}+\->][^+\-]*/
        emit(:backref, $1 == '<' ? :name_call_ab : :name_call_sq, text)
      when /^\\g(.)\d+\D$/
        emit(:backref, $1 == '<' ? :number_call_ab : :number_call_sq, text)
      when /^\\g(.)[+-]\d+/
        emit(:backref, $1 == '<' ? :number_rel_call_ab : :number_rel_call_sq, text)
      end
     end
		end
	when 60 then
# line 585 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '?' ;  emit(:quantifier, :zero_or_one,            text)
      when '??';  emit(:quantifier, :zero_or_one_reluctant,  text)
      when '?+';  emit(:quantifier, :zero_or_one_possessive, text)
      end
     end
		end
	when 56 then
# line 593 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '*' ;  emit(:quantifier, :zero_or_more,            text)
      when '*?';  emit(:quantifier, :zero_or_more_reluctant,  text)
      when '*+';  emit(:quantifier, :zero_or_more_possessive, text)
      end
     end
		end
	when 58 then
# line 601 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      case text = copy(data, ts, te)
      when '+' ;  emit(:quantifier, :one_or_more,            text)
      when '+?';  emit(:quantifier, :one_or_more_reluctant,  text)
      when '++';  emit(:quantifier, :one_or_more_possessive, text)
      end
     end
		end
	when 13 then
# line 609 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:quantifier, :interval, copy(data, ts, te))
     end
		end
	when 48 then
# line 624 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if free_spacing
        emit(:free_space, :comment, copy(data, ts, te))
      else
        # consume only the pound sign (#) and backtrack to do regular scanning
        append_literal(data, ts, ts + 1)
         begin p = (( ts + 1))-1; end

      end
     end
		end
	when 51 then
# line 478 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      text = copy(data, ts, te)
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        validation_error(:group_option, $1 || "-#{$2}", text)
      end
      emit_options(text)
     end
		end
	when 54 then
# line 492 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = copy(data, ts, te)
      when '(?=';  emit(:assertion, :lookahead,    text)
      when '(?!';  emit(:assertion, :nlookahead,   text)
      when '(?<='; emit(:assertion, :lookbehind,   text)
      when '(?<!'; emit(:assertion, :nlookbehind,  text)
      end
     end
		end
	when 49 then
# line 527 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      text = copy(data, ts, te)
      emit(:group, :capture, text)
     end
		end
	when 59 then
# line 585 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = copy(data, ts, te)
      when '?' ;  emit(:quantifier, :zero_or_one,            text)
      when '??';  emit(:quantifier, :zero_or_one_reluctant,  text)
      when '?+';  emit(:quantifier, :zero_or_one_possessive, text)
      end
     end
		end
	when 55 then
# line 593 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = copy(data, ts, te)
      when '*' ;  emit(:quantifier, :zero_or_more,            text)
      when '*?';  emit(:quantifier, :zero_or_more_reluctant,  text)
      when '*+';  emit(:quantifier, :zero_or_more_possessive, text)
      end
     end
		end
	when 57 then
# line 601 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      case text = copy(data, ts, te)
      when '+' ;  emit(:quantifier, :one_or_more,            text)
      when '+?';  emit(:quantifier, :one_or_more_reluctant,  text)
      when '++';  emit(:quantifier, :one_or_more_possessive, text)
      end
     end
		end
	when 64 then
# line 614 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      append_literal(data, ts, te)
     end
		end
	when 61 then
# line 620 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      	begin
		stack[top] = cs
		top+= 1
		cs = 101
		_goto_level = _again
		next
	end

     end
		end
	when 47 then
# line 624 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      if free_spacing
        emit(:free_space, :comment, copy(data, ts, te))
      else
        # consume only the pound sign (#) and backtrack to do regular scanning
        append_literal(data, ts, ts + 1)
         begin p = (( ts + 1))-1; end

      end
     end
		end
	when 46 then
# line 634 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      if free_spacing
        emit(:free_space, :whitespace, copy(data, ts, te))
      else
        append_literal(data, ts, te)
      end
     end
		end
	when 45 then
# line 645 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      append_literal(data, ts, te)
     end
		end
	when 3 then
# line 478 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      text = copy(data, ts, te)
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        validation_error(:group_option, $1 || "-#{$2}", text)
      end
      emit_options(text)
     end
		end
	when 12 then
# line 614 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      append_literal(data, ts, te)
     end
		end
	when 9 then
# line 620 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      	begin
		stack[top] = cs
		top+= 1
		cs = 101
		_goto_level = _again
		next
	end

     end
		end
	when 1 then
# line 1 "NONE"
		begin
	case act
	when 0 then
	begin	begin
		cs = 0
		_goto_level = _again
		next
	end
end
	when 41 then
	begin begin p = ((te))-1; end

      text = copy(data, ts, te)
      if text[2..-1] =~ /([^\-mixdau:]|^$)|-.*([dau])/
        validation_error(:group_option, $1 || "-#{$2}", text)
      end
      emit_options(text)
    end
	when 42 then
	begin begin p = ((te))-1; end

      case text = copy(data, ts, te)
      when '(?=';  emit(:assertion, :lookahead,    text)
      when '(?!';  emit(:assertion, :nlookahead,   text)
      when '(?<='; emit(:assertion, :lookbehind,   text)
      when '(?<!'; emit(:assertion, :nlookbehind,  text)
      end
    end
	when 56 then
	begin begin p = ((te))-1; end

      append_literal(data, ts, te)
    end
end 
			end
	when 76 then
# line 135 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 208 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit(:set, :open, '[')
      	begin
		stack[top] = cs
		top+= 1
		cs = 91
		_goto_level = _again
		next
	end

     end
		end
	when 20 then
# line 135 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 208 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit(:set, :open, '[')
      	begin
		stack[top] = cs
		top+= 1
		cs = 91
		_goto_level = _again
		next
	end

     end
		end
	when 93 then
# line 135 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 344 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 95 then
# line 135 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 349 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p
p = p - 1; begin 
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 27 then
# line 135 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 344 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit_meta_control_sequence(data, ts, te, :control)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 29 then
# line 135 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 349 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 begin p = ((te))-1; end
 begin 
      emit_meta_control_sequence(data, ts, te, :meta_sequence)
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 31 then
# line 141 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    validation_error(:sequence, 'sequence', text)
  		end
# line 340 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

     end
		end
	when 5 then
# line 148 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1 		end
# line 463 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:group, :comment, copy(data, ts, te))
     end
		end
	when 38 then
# line 148 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1 		end
# line 532 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      if conditional_stack.last == group_depth + 1
        conditional_stack.pop
        emit(:conditional, :close, ')')
      else
        if spacing_stack.length > 1 &&
           spacing_stack.last[:depth] == group_depth + 1
          spacing_stack.pop
          self.free_spacing = spacing_stack.last[:free_spacing]
        end

        emit(:group, :close, ')')
      end
     end
		end
	when 40 then
# line 149 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   + 1 		end
# line 438 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:set, :open, copy(data, ts, te))
      	begin
		stack[top] = cs
		top+= 1
		cs = 91
		_goto_level = _again
		next
	end

     end
		end
	when 70 then
# line 150 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   - 1 		end
# line 156 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      emit(:set, :close, copy(data, ts, te))
      if in_set?
        	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

      else
        	begin
		cs = 73
		_goto_level = _again
		next
	end

      end
     end
		end
	when 75 then
# line 150 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   - 1 		end
# line 165 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin  # special case, emits two tokens
      emit(:literal, :literal, '-')
      emit(:set, :close, ']')
      if in_set?
        	begin
		top -= 1
		cs = stack[top]
		_goto_level = _again
		next
	end

      else
        	begin
		cs = 73
		_goto_level = _again
		next
	end

      end
     end
		end
	when 22 then
# line 150 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   - 1 		end
# line 213 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
te = p+1
 begin 
      text = copy(data, ts, te)

      type = :posixclass
      class_name = text[2..-3]
      if class_name[0] == '^'
        class_name = class_name[1..-1]
        type = :nonposixclass
      end

      unless self.class.posix_classes.include?(class_name)
        validation_error(:posix_class, text)
      end

      emit(type, class_name.to_sym, text)
     end
		end
	when 68 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 149 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.set_depth   = set_depth   + 1 		end
	when 84 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 277 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
act = 17;		end
	when 83 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 283 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
act = 18;		end
	when 8 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 492 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
act = 42;		end
	when 2 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 645 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
act = 56;		end
	when 50 then
# line 1 "NONE"
		begin
te = p+1
		end
# line 148 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth - 1 		end
# line 147 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
 self.group_depth = group_depth + 1 		end
# line 478 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin
act = 41;		end
# line 2488 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner.rb"
	end
	end
	end
	if _goto_level <= _again
	case _re_scanner_to_state_actions[cs] 
	when 65 then
# line 1 "NONE"
		begin
ts = nil;		end
	when 34 then
# line 1 "NONE"
		begin
ts = nil;		end
# line 1 "NONE"
		begin
act = 0
		end
# line 2506 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner.rb"
	end

	if cs == 0
		_goto_level = _out
		next
	end
	p += 1
	if p != pe
		_goto_level = _resume
		next
	end
	end
	if _goto_level <= _test_eof
	if p == eof
	if _re_scanner_eof_trans[cs] > 0
		_trans = _re_scanner_eof_trans[cs] - 1;
		_goto_level = _eof_trans
		next;
	end
	  case _re_scanner_eof_actions[cs]
	when 14 then
# line 8 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/property.rl"
		begin

    raise PrematureEndError.new('unicode property')
  		end
	when 25 then
# line 135 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"
		begin

    text = copy(data, ts ? ts-1 : 0, -1)
    raise PrematureEndError.new( text )
  		end
# line 2540 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner.rb"
	  end
	end

	end
	if _goto_level <= _out
		break
	end
end
	end

# line 751 "/Users/janosch/code/regexp_parser/tasks/../lib/regexp_parser/scanner/scanner.rl"

    # to avoid "warning: assigned but unused variable - testEof"
    testEof = testEof

    if cs == re_scanner_error
      text = copy(data, ts ? ts-1 : 0, -1)
      raise ScannerError.new("Scan error at '#{text}'")
    end

    raise PrematureEndError.new("(missing group closing paranthesis) "+
          "[#{group_depth}]") if in_group?
    raise PrematureEndError.new("(missing set closing bracket) "+
          "[#{set_depth}]") if in_set?

    # when the entire expression is a literal run
    emit_literal if literal_run

    tokens
  end

  # lazy-load property maps when first needed
  def self.short_prop_map
    @short_prop_map ||= parse_prop_map('short')
  end

  def self.long_prop_map
    @long_prop_map ||= parse_prop_map('long')
  end

  def self.parse_prop_map(name)
    File.read("#{__dir__}/scanner/properties/#{name}.csv").scan(/(.+),(.+)/).to_h
  end

  def self.posix_classes
    %w[alnum alpha ascii blank cntrl digit graph
       lower print punct space upper word xdigit]
  end

  # Emits an array with the details of the scanned pattern
  def emit(type, token, text)
    #puts "EMIT: type: #{type}, token: #{token}, text: #{text}, ts: #{ts}, te: #{te}"

    emit_literal if literal_run

    # Ragel runs with byte-based indices (ts, te). These are of little value to
    # end-users, so we keep track of char-based indices and emit those instead.
    ts_char_pos = char_pos
    te_char_pos = char_pos + text.length

    tok = [type, token, text, ts_char_pos, te_char_pos]

    self.prev_token = tok

    self.char_pos = te_char_pos

    if block
      block.call type, token, text, ts_char_pos, te_char_pos
      # TODO: in v3.0.0, remove `collect_tokens:` kwarg and only collect if no block given
      tokens << tok if collect_tokens
    elsif collect_tokens
      tokens << tok
    end
  end

  attr_accessor :literal_run # only public for #||= to work on ruby <= 2.5

  private

  attr_accessor :block,
                :collect_tokens, :tokens, :prev_token,
                :free_spacing, :spacing_stack,
                :group_depth, :set_depth, :conditional_stack,
                :char_pos

  def free_spacing?(input_object, options)
    if options && !input_object.is_a?(String)
      raise ArgumentError, 'options cannot be supplied unless scanning a String'
    end

    options = input_object.options if input_object.is_a?(::Regexp)

    return false unless options

    options & Regexp::EXTENDED != 0
  end

  def in_group?
    group_depth > 0
  end

  def in_set?
    set_depth > 0
  end

  # Copy from ts to te from data as text
  def copy(data, ts, te)
    data[ts...te].pack('c*').force_encoding('utf-8')
  end

  # Appends one or more characters to the literal buffer, to be emitted later
  # by a call to emit_literal.
  def append_literal(data, ts, te)
    (self.literal_run ||= []) << copy(data, ts, te)
  end

  # Emits the literal run collected by calls to the append_literal method.
  def emit_literal
    text = literal_run.join
    self.literal_run = nil
    emit(:literal, :literal, text)
  end

  def emit_options(text)
    token = nil

    # Ruby allows things like '(?-xxxx)' or '(?xx-xx--xx-:abc)'.
    text =~ /\(\?([mixdau]*)(-(?:[mix]*))*(:)?/
    positive, negative, group_local = $1, $2, $3

    if positive.include?('x')
      self.free_spacing = true
    end

    # If the x appears in both, treat it like ruby does, the second cancels
    # the first.
    if negative && negative.include?('x')
      self.free_spacing = false
    end

    if group_local
      spacing_stack << {:free_spacing => free_spacing, :depth => group_depth}
      token = :options
    else
      # switch for parent group level
      spacing_stack.last[:free_spacing] = free_spacing
      token = :options_switch
    end

    emit(:group, token, text)
  end

  def emit_meta_control_sequence(data, ts, te, token)
    if data.last < 0x00 || data.last > 0x7F
      validation_error(:sequence, 'escape', token.to_s)
    end
    emit(:escape, token, copy(data, ts-1, te))
  end

  # Centralizes and unifies the handling of validation related
  # errors.
  def validation_error(type, what, reason = nil)
    error =
      case type
      when :backref      then InvalidBackrefError.new(what, reason)
      when :group        then InvalidGroupError.new(what, reason)
      when :group_option then InvalidGroupOption.new(what, reason)
      when :posix_class  then UnknownPosixClassError.new(what)
      when :property     then UnknownUnicodePropertyError.new(what)
      when :sequence     then InvalidSequenceError.new(what, reason)
      end

    raise error # unless @@config.validation_ignore
  end
end # module Regexp::Scanner
