##############################################################################
#
# Copyright (c) 2002 Zope Foundation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTLAR PURPOSE.
#
##############################################################################
"""Testing all XML Locale functionality.
"""
import os
from unittest import TestCase, TestSuite

from zope.i18n.locales.xmlfactory import LocaleFactory
import zope.i18n


class LocaleXMLFileTestCase(TestCase):
    """This test verifies that every locale XML file can be loaded."""

    def __init__(self, path):
        self.__path = path
        TestCase.__init__(self)

    def runTest(self):
        # Loading Locale object
        LocaleFactory(self.__path)()

        # XXX: The tests below are commented out because it's not
        # necessary for the xml files to have all format definitions.

        # Making sure all number format patterns parse
        # for category in (u'decimal', u'scientific', u'percent', u'currency'):
        #    for length in getattr(
        #        locale.numbers, category + 'Formats'
        #     ).values():
        #        for format in length.formats.values():
        #            self.assertIsNotNone(parseNumberPattern(format.pattern)

        # Making sure all datetime patterns parse
        # for calendar in locale.dates.calendars.values():
        #     for category in ('date', 'time', 'dateTime'):
        #         for length in getattr(
        #             calendar, category + 'Formats'
        #         ).values():
        #             for format in length.formats.values():
        #                 self.assertIsNotNone(
        #                     parseDateTimePattern(format.pattern)
        #                 )


def test_suite():
    suite = TestSuite()
    locale_dir = os.path.join(os.path.dirname(zope.i18n.__file__),
                              'locales', 'data')
    for path in os.listdir(locale_dir):
        if not path.endswith(".xml"):
            continue
        path = os.path.join(locale_dir, path)
        case = LocaleXMLFileTestCase(path)
        suite.addTest(case)
    return suite
