<?php
/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.0 on 2013-02-01 at 23:10:44.
 */
class JGithubPackageOrgsMembersTest extends \PHPUnit\Framework\TestCase
{
	/**
	 * @var    JRegistry  Options for the GitHub object.
	 * @since  2.5.0
	 */
	protected $options;

	/**
	 * @var    JGithubHttp  Mock client object.
	 * @since  2.5.0
	 */
	protected $client;

	/**
	 * @var    JHttpResponse  Mock response object.
	 * @since  3.1.4
	 */
	protected $response;

	/**
	 * @var JGithubPackageOrgsMembers
	 */
	protected $object;

	/**
	 * @var    string  Sample JSON string.
	 * @since  3.1.4
	 */
	protected $sampleString = '{"a":1,"b":2,"c":3,"d":4,"e":5}';

	/**
	 * @var    string  Sample JSON error message.
	 * @since  3.1.4
	 */
	protected $errorString = '{"message": "Generic Error"}';

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @since   ¿
	 *
	 * @return  void
	 */
	protected function setUp()
	{
		parent::setUp();

		$this->options  = new JRegistry;
		$this->client   = $this->getMockBuilder('JGithubHttp')->setMethods(array('get', 'post', 'delete', 'patch', 'put'))->getMock();
		$this->response = $this->getMockBuilder('JHttpResponse')->getMock();

		$this->object = new JGithubPackageOrgsMembers($this->options, $this->client);
	}

	/**
	 * @covers JGithubPackageOrgsMembers::getList
	 */
	public function testGetList()
	{
		$this->response->code = 200;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/orgs/joomla/members')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->getList('joomla'),
			$this->equalTo(json_decode($this->sampleString))
		);
	}

	/**
	 * @covers JGithubPackageOrgsMembers::getList
	 */
	public function testGetListNotAMember()
	{
		$this->response->code = 302;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/orgs/joomla/members')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->getList('joomla'),
			$this->equalTo(false)
		);
	}

	/**
	 * @covers JGithubPackageOrgsMembers::getList
	 *
	 * @expectedException UnexpectedValueException
	 */
	public function testGetListUnexpected()
	{
		$this->response->code = 666;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/orgs/joomla/members')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->getList('joomla'),
			$this->equalTo(json_decode($this->sampleString))
		);
	}

	/**
	 * @covers JGithubPackageOrgsMembers::check
	 */
	public function testCheck()
	{
		$this->response->code = 204;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/orgs/joomla/members/elkuku')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->check('joomla', 'elkuku'),
			$this->equalTo(true)
		);
	}

	/**
	 * @covers JGithubPackageOrgsMembers::check
	 */
	public function testCheckNoMember()
	{
		$this->response->code = 404;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/orgs/joomla/members/elkuku')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->check('joomla', 'elkuku'),
			$this->equalTo(false)
		);
	}

	/**
	 * @covers JGithubPackageOrgsMembers::check
	 */
	public function testCheckRequesterNoMember()
	{
		$this->response->code = 302;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/orgs/joomla/members/elkuku')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->check('joomla', 'elkuku'),
			$this->equalTo(false)
		);
	}

	/**
	 * @covers JGithubPackageOrgsMembers::check
	 *
	 * @expectedException UnexpectedValueException
	 */
	public function testCheckUnexpectedr()
	{
		$this->response->code = 666;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/orgs/joomla/members/elkuku')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->check('joomla', 'elkuku'),
			$this->equalTo(false)
		);
	}

	/**
	 * @covers JGithubPackageOrgsMembers::remove
	 */
	public function testRemove()
	{
		$this->response->code = 204;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('delete')
			->with('/orgs/joomla/members/elkuku')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->remove('joomla', 'elkuku'),
			$this->equalTo(json_decode($this->sampleString))
		);
	}

	/**
	 * @covers JGithubPackageOrgsMembers::getListPublic
	 */
	public function testGetListPublic()
	{
		$this->response->code = 200;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/orgs/joomla/public_members')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->getListPublic('joomla'),
			$this->equalTo(json_decode($this->sampleString))
		);
	}

	/**
	 * @covers JGithubPackageOrgsMembers::checkPublic
	 */
	public function testCheckPublic()
	{
		$this->response->code = 204;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/orgs/joomla/public_members/elkuku')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->checkPublic('joomla', 'elkuku'),
			$this->equalTo(true)
		);
	}

	/**
	 * @covers JGithubPackageOrgsMembers::checkPublic
	 */
	public function testCheckPublicNo()
	{
		$this->response->code = 404;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/orgs/joomla/public_members/elkuku')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->checkPublic('joomla', 'elkuku'),
			$this->equalTo(false)
		);
	}

	/**
	 * @covers JGithubPackageOrgsMembers::checkPublic
	 *
	 * @expectedException UnexpectedValueException
	 */
	public function testCheckPublicUnexpected()
	{
		$this->response->code = 666;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/orgs/joomla/public_members/elkuku')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->checkPublic('joomla', 'elkuku'),
			$this->equalTo(false)
		);
	}

	/**
	 * @covers JGithubPackageOrgsMembers::publicize
	 */
	public function testPublicize()
	{
		$this->response->code = 204;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('put')
			->with('/orgs/joomla/public_members/elkuku')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->publicize('joomla', 'elkuku'),
			$this->equalTo(json_decode($this->sampleString))
		);
	}

	/**
	 * @covers JGithubPackageOrgsMembers::conceal
	 */
	public function testConceal()
	{
		$this->response->code = 204;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('delete')
			->with('/orgs/joomla/public_members/elkuku')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->conceal('joomla', 'elkuku'),
			$this->equalTo(json_decode($this->sampleString))
		);
	}
}
