<?php

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.0 on 2013-01-30 at 01:41:27.
 */
class JGithubPackageDataTagsTest extends \PHPUnit\Framework\TestCase
{
	/**
	 * @var    JRegistry  Options for the GitHub object.
	 * @since  2.5.0
	 */
	protected $options;

	/**
	 * @var    JGithubHttp  Mock client object.
	 * @since  2.5.0
	 */
	protected $client;

	/**
	 * @var    JHttpResponse  Mock response object.
	 * @since  3.1.4
	 */
	protected $response;

	/**
	 * @var JGithubPackageDataTags
	 */
	protected $object;

	/**
	 * @var    string  Sample JSON string.
	 * @since  3.1.4
	 */
	protected $sampleString = '{"a":1,"b":2,"c":3,"d":4,"e":5}';

	/**
	 * @var    string  Sample JSON error message.
	 * @since  3.1.4
	 */
	protected $errorString = '{"message": "Generic Error"}';

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 */
	protected function setUp()
	{
		parent::setUp();

		$this->options = new JRegistry;
		$this->client = $this->getMockBuilder('JGithubHttp')->setMethods(array('get', 'post', 'delete', 'patch', 'put'))->getMock();
		$this->response = $this->getMockBuilder('JHttpResponse')->getMock();

		$this->object = new JGithubPackageDataTags($this->options, $this->client);
	}

	/**
	 * @covers JGithubPackageDataTags::get
	 *
	 * GET /repos/:owner/:repo/git/tags/:sha
	 *
	 * Response
	 *
	 * Status: 200 OK
	 * X-RateLimit-Limit: 5000
	 * X-RateLimit-Remaining: 4999
	 */
	public function testGet()
	{
		$this->response->code = 200;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/repos/joomla/joomla-platform/git/tags/12345', 0, 0)
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->get('joomla', 'joomla-platform', '12345'),
			$this->equalTo(json_decode($this->response->body))
		);
	}

	/**
	 * @covers JGithubPackageDataTags::create
	 *
	 * POST /repos/:owner/:repo/git/tags
	 *
	 * Parameters
	 *
	 * tag
	 * String of the tag
	 * message
	 * String of the tag message
	 * object
	 * String of the SHA of the git object this is tagging
	 * type
	 * String of the type of the object we’re tagging. Normally this is a commit but it can also be a tree or a blob.
	 * tagger.name
	 * String of the name of the author of the tag
	 * tagger.email
	 * String of the email of the author of the tag
	 * tagger.date
	 * Timestamp of when this object was tagged
	 *
	 * Response
	 *
	 * Status: 201 Created
	 * Location: https://api.github.com/repos/:owner/:repo/git/tags/:sha
	 * X-RateLimit-Limit: 5000
	 * X-RateLimit-Remaining: 4999
	 */
	public function testCreate()
	{
		$this->response->code = 201;
		$this->response->body = $this->sampleString;

		$data = '{"tag":"0.1","message":"Message","object":"12345","type":"commit","tagger_name":"elkuku","tagger_email":"email@example.com","tagger_date":"123456789"}';
		$this->client->expects($this->once())
			->method('post')
			->with('/repos/joomla/joomla-platform/git/tags', $data, 0, 0)
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->create('joomla', 'joomla-platform', '0.1', 'Message', '12345', 'commit', 'elkuku', 'email@example.com', '123456789'),
			$this->equalTo(json_decode($this->response->body))
		);
	}
}
