<?php

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.0 on 2013-01-30 at 20:06:23.
 */
class JGithubPackageActivityStarringTest extends \PHPUnit\Framework\TestCase
{
	/**
	 * @var    JRegistry  Options for the GitHub object.
	 * @since  2.5.0
	 */
	protected $options;

	/**
	 * @var    JGithubHttp  Mock client object.
	 * @since  2.5.0
	 */
	protected $client;

	/**
	 * @var    JHttpResponse  Mock response object.
	 * @since  3.1.4
	 */
	protected $response;

	/**
	 * @var JGithubPackageActivityStarring
	 */
	protected $object;

	/**
	 * @var    string  Sample JSON string.
	 * @since  3.1.4
	 */
	protected $sampleString = '{"a":1,"b":2,"c":3,"d":4,"e":5}';

	/**
	 * @var    string  Sample JSON error message.
	 * @since  3.1.4
	 */
	protected $errorString = '{"message": "Generic Error"}';

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 */
	protected function setUp()
	{
		parent::setUp();

		$this->options = new JRegistry;
		$this->client = $this->getMockBuilder('JGithubHttp')->setMethods(array('get', 'post', 'delete', 'patch', 'put'))->getMock();
		$this->response = $this->getMockBuilder('JHttpResponse')->getMock();

		$this->object = new JGithubPackageActivityStarring($this->options, $this->client);
	}

	/**
	 * @covers JGithubPackageActivityStarring::getList
	 *
	 *     GET /repos/:owner/:repo/stargazers
	 *
	 * # Legacy, using github.beta media type.
	 * GET /repos/:owner/:repo/watchers
	 *
	 * Response
	 *
	 * Status: 200 OK
	 * Link: <https://api.github.com/resource?page=2>; rel="next",
	 * <https://api.github.com/resource?page=5>; rel="last"
	 * X-RateLimit-Limit: 5000
	 * X-RateLimit-Remaining: 4999
	 */
	public function testGetList()
	{
		$this->response->code = 200;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/repos/joomla/joomla-platform/stargazers', 0, 0)
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->getList('joomla', 'joomla-platform'),
			$this->equalTo(json_decode($this->response->body))
		);
	}

	/**
	 * @covers JGithubPackageActivityStarring::getRepositories
	 *
	 * GET /users/:user/starred
	 *
	 * # Legacy, using github.beta media type.
	 * GET /users/:user/watched
	 *
	 * List repositories being watched by the authenticated user.
	 *
	 * GET /user/starred
	 *
	 * # Legacy, using github.beta media type.
	 * GET /user/watched
	 *
	 * Response
	 *
	 * Status: 200 OK
	 * Link: <https://api.github.com/resource?page=2>; rel="next",
	 * <https://api.github.com/resource?page=5>; rel="last"
	 * X-RateLimit-Limit: 5000
	 * X-RateLimit-Remaining: 4999


	 */
	public function testGetRepositories()
	{
		$this->response->code = 200;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/user/starred', 0, 0)
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->getRepositories(),
			$this->equalTo(json_decode($this->response->body))
		);
	}

	/**
	 * @covers JGithubPackageActivityStarring::check
	 *
	 *     GET /user/starred/:owner/:repo
	 *
	 * # Legacy, using github.beta media type.
	 * GET /user/watched/:owner/:repo
	 *
	 * Response if this repository is watched by you
	 *
	 * Status: 204 No Content
	 * X-RateLimit-Limit: 5000
	 * X-RateLimit-Remaining: 4999
	 *
	 * Response if this repository is not watched by you
	 *
	 * Status: 404 Not Found
	 * X-RateLimit-Limit: 5000
	 * X-RateLimit-Remaining: 4999
	 */
	public function testCheck()
	{
		$this->response->code = 204;
		$this->response->body = true;

		$this->client->expects($this->once())
			->method('get')
			->with('/user/starred/joomla/joomla-platform', 0, 0)
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->check('joomla', 'joomla-platform'),
			$this->equalTo(json_decode($this->response->body))
		);
	}

	public function testCheckFalse()
	{
		$this->response->code = 404;
		$this->response->body = false;

		$this->client->expects($this->once())
			->method('get')
			->with('/user/starred/joomla/joomla-platform', 0, 0)
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->check('joomla', 'joomla-platform'),
			$this->equalTo(json_decode($this->response->body))
		);
	}

	/**
	 * @expectedException UnexpectedValueException
	 */
	public function testCheckUnexpected()
	{
		$this->response->code = 666;
		$this->response->body = false;

		$this->client->expects($this->once())
			->method('get')
			->with('/user/starred/joomla/joomla-platform', 0, 0)
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->check('joomla', 'joomla-platform'),
			$this->equalTo(json_decode($this->response->body))
		);
	}

	/**
	 * @covers JGithubPackageActivityStarring::star
	 *
	 *     PUT /user/starred/:owner/:repo
	 *
	 * # Legacy, using github.beta media type.
	 * PUT /user/watched/:owner/:repo
	 *
	 * Response
	 *
	 * Status: 204 No Content
	 * X-RateLimit-Limit: 5000
	 * X-RateLimit-Remaining: 4999
	 */
	public function testStar()
	{
		$this->response->code = 204;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('put')
			->with('/user/starred/joomla/joomla-platform', '', 0, 0)
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->star('joomla', 'joomla-platform'),
			$this->equalTo(json_decode($this->response->body))
		);
	}

	/**
	 * @covers JGithubPackageActivityStarring::unstar
	 *
	 *     DELETE /user/starred/:owner/:repo
	 *
	 * # Legacy, using github.beta media type.
	 * DELETE /user/watched/:owner/:repo
	 *
	 * Response
	 *
	 * Status: 204 No Content
	 * X-RateLimit-Limit: 5000
	 * X-RateLimit-Remaining: 4999
	 */
	public function testUnstar()
	{
		$this->response->code = 204;
		$this->response->body = '';

		$this->client->expects($this->once())
			->method('delete')
			->with('/user/starred/joomla/joomla-platform', 0, 0)
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->unstar('joomla', 'joomla-platform'),
			$this->equalTo(json_decode($this->response->body))
		);
	}
}
