<?php
/**
 * @package     Joomla.UnitTest
 * @subpackage  Archive
 *
 * @copyright   (C) 2013 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

require_once __DIR__ . '/JArchiveTestCase.php';

/**
 * Test class for JArchiveGzip.
 * Generated by PHPUnit on 2011-10-26 at 19:34:32.
 *
 * @package     Joomla.UnitTest
 * @subpackage  Archive
 * @since       1.7.0
 */
class JArchiveGzipTest extends JArchiveTestCase
{
	/**
     * @var  JArchiveGzip
     */
	protected $object;

	/**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
	 *
	 * @return  void
     */
	protected function setUp()
	{
		parent::setUp();

		$this->object = new JArchiveGzip;
	}

	/**
	 * Overrides the parent tearDown method.
	 *
	 * @return  void
	 *
	 * @see     \PHPUnit\Framework\TestCase::tearDown()
	 * @since   3.6
	 */
	protected function tearDown()
	{
		unset($this->object);
		parent::tearDown();
	}

	/**
	 * Tests the extract Method.
	 *
	 * @return  void
	 */
	public function testExtract()
	{
		if (!JArchiveGzip::isSupported())
		{
			$this->markTestSkipped('Gzip files can not be extracted.');
		}

		$this->object->extract(__DIR__ . '/logo-gz.png.gz', $this->outputPath . '/logo-gz.png');
		$this->assertTrue(is_file($this->outputPath . '/logo-gz.png'));
	}

	/**
	 * Tests the extract Method.
	 *
	 * @return  void
	 */
	public function testExtractWithStreams()
	{
		if (!JArchiveGzip::isSupported())
		{
			$this->markTestSkipped('Gzip files can not be extracted.');
		}

		$this->object->extract(__DIR__ . '/logo-gz.png.gz', $this->outputPath . '/logo-gz.png', array('use_streams' => true));
		$this->assertTrue(is_file($this->outputPath . '/logo-gz.png'));
	}

	/**
	 * Tests the isSupported Method.
	 *
	 * @return  void
	 */
	public function testIsSupported()
	{
		$this->assertEquals(
			extension_loaded('zlib'),
			JArchiveGzip::isSupported()
		);
	}
}
