<?php
/**
 * @package     Joomla.UnitTest
 * @subpackage  com_finder
 *
 * @copyright   (C) 2013 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

require_once JPATH_ADMINISTRATOR . '/components/com_finder/helpers/indexer/stemmer/fr.php';

/**
 * Test class for FinderIndexerStemmerFr.
 */
class FinderIndexerStemmerFrTest extends \PHPUnit\Framework\TestCase
{
	/**
	 * @var FinderIndexerStemmerFr
	 */
	protected $object;

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 */
	protected function setUp()
	{
		$this->object = new FinderIndexerStemmerFr;
	}

	/**
	 * Tears down the fixture, for example, closes a network connection.
	 * This method is called after a test is executed.
	 *
	 * @return void
	 *
	 * @see     \PHPUnit\Framework\TestCase::tearDown()
	 * @since   3.6
	 */
	protected function tearDown()
	{
		unset($this->object);
	}

	/**
	 * Tests the stem method of the French language stemmer
	 *
	 * @return  void
	 *
	 * @since   3.1
	 * @covers  FinderIndexerStemmerFr::stem
	 */
	public function testStem()
	{
		$this->assertEquals(
			'mais',
			$this->object->stem('maisons', 'fr')
		);
	}

	/**
	 * Tests the stem method of the French language stemmer to ensure it doesn't stem short words
	 *
	 * @return  void
	 *
	 * @since   3.1
	 * @covers  FinderIndexerStemmerFr::stem
	 */
	public function testStemShort()
	{
		$this->assertEquals(
			'ab',
			$this->object->stem('ab', 'fr')
		);
	}

	/**
	 * Tests the stem method of the French language stemmer to ensure it only stems French
	 *
	 * @return  void
	 *
	 * @since   3.1
	 * @covers  FinderIndexerStemmerFr::stem
	 */
	public function testStemWrongLanguage()
	{
		$this->assertEquals(
			'maisons',
			$this->object->stem('maisons', 'en')
		);
	}
}
