<?php
/**
 * @package     Joomla.UnitTest
 * @subpackage  com_finder
 *
 * @copyright   (C) 2013 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

require_once JPATH_ADMINISTRATOR . '/components/com_finder/helpers/indexer/stemmer.php';

/**
 * Test class for FinderIndexerStemmer.
 * Generated by PHPUnit on 2012-06-10 at 14:52:14.
 */
class FinderIndexerStemmerTest extends \PHPUnit\Framework\TestCase
{
	/**
	 * Tests the getInstance method
	 *
	 * @return  void
	 *
	 * @since   3.0
	 * @covers  FinderIndexerStemmer::getInstance
	 */
	public function testGetInstance()
	{
		$this->assertInstanceOf(
			'FinderIndexerStemmerPorter_en',
			FinderIndexerStemmer::getInstance('porter_en'),
			'getInstance with param "porter_en" returns an instance of FinderIndexerStemmerPorter_en.'
		);
	}

	/**
	 * Tests the getInstance method with a non-existing parser
	 *
	 * @return  void
	 *
	 * @since   3.0
	 *
	 * @covers  FinderIndexerStemmer::getInstance
	 * @expectedException  Exception
	 */
	public function testGetInstance_noParser()
	{
		FinderIndexerStemmer::getInstance('noway');
	}
}
