<?php
/** Adminer Editor - Compact database editor
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2009 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 4.7.9
*/function
adminer_errors($bc,$cc){return!!preg_match('~^(Trying to access array offset on value of type null|Undefined array key)~',$cc);}error_reporting(6135);set_error_handler('adminer_errors',2);$vc=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($vc||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$Og=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($Og)$$X=$Og;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection(){global$h;return$h;}function
adminer(){global$b;return$b;}function
version(){global$ca;return$ca;}function
idf_unescape($t){$Gd=substr($t,-1);return
str_replace($Gd.$Gd,$Gd,substr($t,1,-1));}function
escape_string($X){return
substr(q($X),1,-1);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes($Ye,$vc=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($x,$X)=each($Ye)){foreach($X
as$xd=>$W){unset($Ye[$x][$xd]);if(is_array($W)){$Ye[$x][stripslashes($xd)]=$W;$Ye[]=&$Ye[$x][stripslashes($xd)];}else$Ye[$x][stripslashes($xd)]=($vc?$W:stripslashes($W));}}}}function
bracket_escape($t,$Ia=false){static$_g=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($t,($Ia?array_flip($_g):$_g));}function
min_version($bh,$Sd="",$i=null){global$h;if(!$i)$i=$h;$Hf=$i->server_info;if($Sd&&preg_match('~([\d.]+)-MariaDB~',$Hf,$_)){$Hf=$_[1];$bh=$Sd;}return(version_compare($Hf,$bh)>=0);}function
charset($h){return(min_version("5.5.3",0,$h)?"utf8mb4":"utf8");}function
script($Qf,$zg="\n"){return"<script".nonce().">$Qf</script>$zg";}function
script_src($Tg){return"<script src='".h($Tg)."'".nonce()."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($Q){return
str_replace("\0","&#0;",htmlspecialchars($Q,ENT_QUOTES,'utf-8'));}function
nl_br($Q){return
str_replace("\n","<br>",$Q);}function
checkbox($A,$Y,$Xa,$Cd="",$ue="",$bb="",$Dd=""){$I="<input type='checkbox' name='$A' value='".h($Y)."'".($Xa?" checked":"").($Dd?" aria-labelledby='$Dd'":"").">".($ue?script("qsl('input').onclick = function () { $ue };",""):"");return($Cd!=""||$bb?"<label".($bb?" class='$bb'":"").">$I".h($Cd)."</label>":$I);}function
optionlist($B,$Bf=null,$Xg=false){$I="";foreach($B
as$xd=>$W){$ze=array($xd=>$W);if(is_array($W)){$I.='<optgroup label="'.h($xd).'">';$ze=$W;}foreach($ze
as$x=>$X)$I.='<option'.($Xg||is_string($x)?' value="'.h($x).'"':'').(($Xg||is_string($x)?(string)$x:$X)===$Bf?' selected':'').'>'.h($X);if(is_array($W))$I.='</optgroup>';}return$I;}function
html_select($A,$B,$Y="",$te=true,$Dd=""){if($te)return"<select name='".h($A)."'".($Dd?" aria-labelledby='$Dd'":"").">".optionlist($B,$Y)."</select>".(is_string($te)?script("qsl('select').onchange = function () { $te };",""):"");$I="";foreach($B
as$x=>$X)$I.="<label><input type='radio' name='".h($A)."' value='".h($x)."'".($x==$Y?" checked":"").">".h($X)."</label>";return$I;}function
select_input($Da,$B,$Y="",$te="",$Pe=""){$ig=($B?"select":"input");return"<$ig$Da".($B?"><option value=''>$Pe".optionlist($B,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$Pe'>").($te?script("qsl('$ig').onchange = $te;",""):"");}function
confirm($ae="",$Cf="qsl('input')"){return
script("$Cf.onclick = function () { return confirm('".($ae?js_escape($ae):lang(0))."'); };","");}function
print_fieldset($s,$Id,$eh=false){echo"<fieldset><legend>","<a href='#fieldset-$s'>$Id</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$s');",""),"</legend>","<div id='fieldset-$s'".($eh?"":" class='hidden'").">\n";}function
bold($Qa,$bb=""){return($Qa?" class='active $bb'":($bb?" class='$bb'":""));}function
odd($I=' class="odd"'){static$r=0;if(!$I)$r=-1;return($r++%2?$I:'');}function
js_escape($Q){return
addcslashes($Q,"\r\n'\\/");}function
json_row($x,$X=null){static$wc=true;if($wc)echo"{";if($x!=""){echo($wc?"":",")."\n\t\"".addcslashes($x,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$wc=false;}else{echo"\n}\n";$wc=true;}}function
ini_bool($nd){$X=ini_get($nd);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$I;if($I===null)$I=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$I;}function
set_password($ah,$N,$V,$E){$_SESSION["pwds"][$ah][$N][$V]=($_COOKIE["adminer_key"]&&is_string($E)?array(encrypt_string($E,$_COOKIE["adminer_key"])):$E);}function
get_password(){$I=get_session("pwds");if(is_array($I))$I=($_COOKIE["adminer_key"]?decrypt_string($I[0],$_COOKIE["adminer_key"]):false);return$I;}function
q($Q){global$h;return$h->quote($Q);}function
get_vals($F,$e=0){global$h;$I=array();$H=$h->query($F);if(is_object($H)){while($J=$H->fetch_row())$I[]=$J[$e];}return$I;}function
get_key_vals($F,$i=null,$Kf=true){global$h;if(!is_object($i))$i=$h;$I=array();$H=$i->query($F);if(is_object($H)){while($J=$H->fetch_row()){if($Kf)$I[$J[0]]=$J[1];else$I[]=$J[0];}}return$I;}function
get_rows($F,$i=null,$o="<p class='error'>"){global$h;$mb=(is_object($i)?$i:$h);$I=array();$H=$mb->query($F);if(is_object($H)){while($J=$H->fetch_assoc())$I[]=$J;}elseif(!$H&&!is_object($i)&&$o&&defined("PAGE_HEADER"))echo$o.error()."\n";return$I;}function
unique_array($J,$v){foreach($v
as$u){if(preg_match("~PRIMARY|UNIQUE~",$u["type"])){$I=array();foreach($u["columns"]as$x){if(!isset($J[$x]))continue
2;$I[$x]=$J[$x];}return$I;}}}function
escape_key($x){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$x,$_))return$_[1].idf_escape(idf_unescape($_[2])).$_[3];return
idf_escape($x);}function
where($Z,$q=array()){global$h,$w;$I=array();foreach((array)$Z["where"]as$x=>$X){$x=bracket_escape($x,1);$e=escape_key($x);$I[]=$e.($w=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):($w=="mssql"?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($q[$x],q($X))));if($w=="sql"&&preg_match('~char|text~',$q[$x]["type"])&&preg_match("~[^ -@]~",$X))$I[]="$e = ".q($X)." COLLATE ".charset($h)."_bin";}foreach((array)$Z["null"]as$x)$I[]=escape_key($x)." IS NULL";return
implode(" AND ",$I);}function
where_check($X,$q=array()){parse_str($X,$Va);remove_slashes(array(&$Va));return
where($Va,$q);}function
where_link($r,$e,$Y,$we="="){return"&where%5B$r%5D%5Bcol%5D=".urlencode($e)."&where%5B$r%5D%5Bop%5D=".urlencode(($Y!==null?$we:"IS NULL"))."&where%5B$r%5D%5Bval%5D=".urlencode($Y);}function
convert_fields($f,$q,$L=array()){$I="";foreach($f
as$x=>$X){if($L&&!in_array(idf_escape($x),$L))continue;$_a=convert_field($q[$x]);if($_a)$I.=", $_a AS ".idf_escape($x);}return$I;}function
cookie($A,$Y,$Ld=2592000){global$aa;return
header("Set-Cookie: $A=".urlencode($Y).($Ld?"; expires=".gmdate("D, d M Y H:i:s",time()+$Ld)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).($aa?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
restart_session(){if(!ini_bool("session.use_cookies"))session_start();}function
stop_session($Ac=false){$Wg=ini_bool("session.use_cookies");if(!$Wg||$Ac){session_write_close();if($Wg&&@ini_set("session.use_cookies",false)===false)session_start();}}function&get_session($x){return$_SESSION[$x][DRIVER][SERVER][$_GET["username"]];}function
set_session($x,$X){$_SESSION[$x][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($ah,$N,$V,$m=null){global$Mb;preg_match('~([^?]*)\??(.*)~',remove_from_uri(implode("|",array_keys($Mb))."|username|".($m!==null?"db|":"").session_name()),$_);return"$_[1]?".(sid()?SID."&":"").($ah!="server"||$N!=""?urlencode($ah)."=".urlencode($N)."&":"")."username=".urlencode($V).($m!=""?"&db=".urlencode($m):"").($_[2]?"&$_[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($Nd,$ae=null){if($ae!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($Nd!==null?$Nd:$_SERVER["REQUEST_URI"]))][]=$ae;}if($Nd!==null){if($Nd=="")$Nd=".";header("Location: $Nd");exit;}}function
query_redirect($F,$Nd,$ae,$if=true,$gc=true,$nc=false,$pg=""){global$h,$o,$b;if($gc){$Wf=microtime(true);$nc=!$h->query($F);$pg=format_time($Wf);}$Tf="";if($F)$Tf=$b->messageQuery($F,$pg,$nc);if($nc){$o=error().$Tf.script("messagesPrint();");return
false;}if($if)redirect($Nd,$ae.$Tf);return
true;}function
queries($F){global$h;static$cf=array();static$Wf;if(!$Wf)$Wf=microtime(true);if($F===null)return
array(implode("\n",$cf),format_time($Wf));$cf[]=(preg_match('~;$~',$F)?"DELIMITER ;;\n$F;\nDELIMITER ":$F).";";return$h->query($F);}function
apply_queries($F,$T,$dc='table'){foreach($T
as$R){if(!queries("$F ".$dc($R)))return
false;}return
true;}function
queries_redirect($Nd,$ae,$if){list($cf,$pg)=queries(null);return
query_redirect($cf,$Nd,$ae,$if,false,!$if,$pg);}function
format_time($Wf){return
lang(1,max(0,microtime(true)-$Wf));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($Ge=""){return
substr(preg_replace("~(?<=[?&])($Ge".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
pagination($C,$zb){return" ".($C==$zb?$C+1:'<a href="'.h(remove_from_uri("page").($C?"&page=$C".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($C+1)."</a>");}function
get_file($x,$Cb=false){$sc=$_FILES[$x];if(!$sc)return
null;foreach($sc
as$x=>$X)$sc[$x]=(array)$X;$I='';foreach($sc["error"]as$x=>$o){if($o)return$o;$A=$sc["name"][$x];$wg=$sc["tmp_name"][$x];$sb=file_get_contents($Cb&&preg_match('~\.gz$~',$A)?"compress.zlib://$wg":$wg);if($Cb){$Wf=substr($sb,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$Wf,$jf))$sb=iconv("utf-16","utf-8",$sb);elseif($Wf=="\xEF\xBB\xBF")$sb=substr($sb,3);$I.=$sb."\n\n";}else$I.=$sb;}return$I;}function
upload_error($o){$Xd=($o==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($o?lang(2).($Xd?" ".lang(3,$Xd):""):lang(4));}function
repeat_pattern($Me,$Jd){return
str_repeat("$Me{0,65535}",$Jd/65535)."$Me{0,".($Jd%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
shorten_utf8($Q,$Jd=80,$cg=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$Jd).")($)?)u",$Q,$_))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$Jd).")($)?)",$Q,$_);return
h($_[1]).$cg.(isset($_[2])?"":"<i>…</i>");}function
format_number($X){return
strtr(number_format($X,0,".",lang(5)),preg_split('~~u',lang(6),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~[^a-z0-9_]~i','-',$X);}function
hidden_fields($Ye,$ed=array(),$Te=''){$I=false;foreach($Ye
as$x=>$X){if(!in_array($x,$ed)){if(is_array($X))hidden_fields($X,array(),$x);else{$I=true;echo'<input type="hidden" name="'.h($Te?$Te."[$x]":$x).'" value="'.h($X).'">';}}}return$I;}function
hidden_fields_get(){echo(sid()?'<input type="hidden" name="'.session_name().'" value="'.h(session_id()).'">':''),(SERVER!==null?'<input type="hidden" name="'.DRIVER.'" value="'.h(SERVER).'">':""),'<input type="hidden" name="username" value="'.h($_GET["username"]).'">';}function
table_status1($R,$oc=false){$I=table_status($R,$oc);return($I?$I:array("Name"=>$R));}function
column_foreign_keys($R){global$b;$I=array();foreach($b->foreignKeys($R)as$Ec){foreach($Ec["source"]as$X)$I[$X][]=$Ec;}return$I;}function
enum_input($U,$Da,$p,$Y,$Xb=null){global$b;preg_match_all("~'((?:[^']|'')*)'~",$p["length"],$Ud);$I=($Xb!==null?"<label><input type='$U'$Da value='$Xb'".((is_array($Y)?in_array($Xb,$Y):$Y===0)?" checked":"")."><i>".lang(7)."</i></label>":"");foreach($Ud[1]as$r=>$X){$X=stripcslashes(str_replace("''","'",$X));$Xa=(is_int($Y)?$Y==$r+1:(is_array($Y)?in_array($r+1,$Y):$Y===$X));$I.=" <label><input type='$U'$Da value='".($r+1)."'".($Xa?' checked':'').'>'.h($b->editVal($X,$p)).'</label>';}return$I;}function
input($p,$Y,$Kc){global$Jg,$b,$w;$A=h(bracket_escape($p["field"]));echo"<td class='function'>";if(is_array($Y)&&!$Kc){$ya=array($Y);if(version_compare(PHP_VERSION,5.4)>=0)$ya[]=JSON_PRETTY_PRINT;$Y=call_user_func_array('json_encode',$ya);$Kc="json";}$of=($w=="mssql"&&$p["auto_increment"]);if($of&&!$_POST["save"])$Kc=null;$Lc=(isset($_GET["select"])||$of?array("orig"=>lang(8)):array())+$b->editFunctions($p);$Da=" name='fields[$A]'";if($p["type"]=="enum")echo
h($Lc[""])."<td>".$b->editInput($_GET["edit"],$p,$Da,$Y);else{$Sc=(in_array($Kc,$Lc)||isset($Lc[$Kc]));echo(count($Lc)>1?"<select name='function[$A]'>".optionlist($Lc,$Kc===null||$Sc?$Kc:"")."</select>".on_help("getTarget(event).value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($Lc))).'<td>';$pd=$b->editInput($_GET["edit"],$p,$Da,$Y);if($pd!="")echo$pd;elseif(preg_match('~bool~',$p["type"]))echo"<input type='hidden'$Da value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$Da value='1'>";elseif($p["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$p["length"],$Ud);foreach($Ud[1]as$r=>$X){$X=stripcslashes(str_replace("''","'",$X));$Xa=(is_int($Y)?($Y>>$r)&1:in_array($X,explode(",",$Y),true));echo" <label><input type='checkbox' name='fields[$A][$r]' value='".(1<<$r)."'".($Xa?' checked':'').">".h($b->editVal($X,$p)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$p["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$A'>";elseif(($mg=preg_match('~text|lob|memo~i',$p["type"]))||preg_match("~\n~",$Y)){if($mg&&$w!="sqlite")$Da.=" cols='50' rows='12'";else{$K=min(12,substr_count($Y,"\n")+1);$Da.=" cols='30' rows='$K'".($K==1?" style='height: 1.2em;'":"");}echo"<textarea$Da>".h($Y).'</textarea>';}elseif($Kc=="json"||preg_match('~^jsonb?$~',$p["type"]))echo"<textarea$Da cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';else{$Zd=(!preg_match('~int~',$p["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$p["length"],$_)?((preg_match("~binary~",$p["type"])?2:1)*$_[1]+($_[3]?1:0)+($_[2]&&!$p["unsigned"]?1:0)):($Jg[$p["type"]]?$Jg[$p["type"]]+($p["unsigned"]?0:1):0));if($w=='sql'&&min_version(5.6)&&preg_match('~time~',$p["type"]))$Zd+=7;echo"<input".((!$Sc||$Kc==="")&&preg_match('~(?<!o)int(?!er)~',$p["type"])&&!preg_match('~\[\]~',$p["full_type"])?" type='number'":"")." value='".h($Y)."'".($Zd?" data-maxlength='$Zd'":"").(preg_match('~char|binary~',$p["type"])&&$Zd>20?" size='40'":"")."$Da>";}echo$b->editHint($_GET["edit"],$p,$Y);$wc=0;foreach($Lc
as$x=>$X){if($x===""||!$X)break;$wc++;}if($wc)echo
script("mixin(qsl('td'), {onchange: partial(skipOriginal, $wc), oninput: function () { this.onchange(); }});");}}function
process_input($p){global$b,$n;$t=bracket_escape($p["field"]);$Kc=$_POST["function"][$t];$Y=$_POST["fields"][$t];if($p["type"]=="enum"){if($Y==-1)return
false;if($Y=="")return"NULL";return+$Y;}if($p["auto_increment"]&&$Y=="")return
null;if($Kc=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$p["on_update"])?idf_escape($p["field"]):false);if($Kc=="NULL")return"NULL";if($p["type"]=="set")return
array_sum((array)$Y);if($Kc=="json"){$Kc="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$p["type"])&&ini_bool("file_uploads")){$sc=get_file("fields-$t");if(!is_string($sc))return
false;return$n->quoteBinary($sc);}return$b->processInput($p,$Y,$Kc);}function
fields_from_edit(){global$n;$I=array();foreach((array)$_POST["field_keys"]as$x=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$x];$_POST["fields"][$X]=$_POST["field_vals"][$x];}}foreach((array)$_POST["fields"]as$x=>$X){$A=bracket_escape($x,1);$I[$A]=array("field"=>$A,"privileges"=>array("insert"=>1,"update"=>1),"null"=>1,"auto_increment"=>($x==$n->primary),);}return$I;}function
search_tables(){global$b,$h;$_GET["where"][0]["val"]=$_POST["query"];$Ef="<ul>\n";foreach(table_status('',true)as$R=>$S){$A=$b->tableName($S);if(isset($S["Engine"])&&$A!=""&&(!$_POST["tables"]||in_array($R,$_POST["tables"]))){$H=$h->query("SELECT".limit("1 FROM ".table($R)," WHERE ".implode(" AND ",$b->selectSearchProcess(fields($R),array())),1));if(!$H||$H->fetch_row()){$We="<a href='".h(ME."select=".urlencode($R)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$A</a>";echo"$Ef<li>".($H?$We:"<p class='error'>$We: ".error())."\n";$Ef="";}}}echo($Ef?"<p class='message'>".lang(9):"</ul>")."\n";}function
dump_headers($bd,$fe=false){global$b;$I=$b->dumpHeaders($bd,$fe);$De=$_POST["output"];if($De!="text")header("Content-Disposition: attachment; filename=".$b->dumpFilename($bd).".$I".($De!="file"&&preg_match('~^[0-9a-z]+$~',$De)?".$De":""));session_write_close();ob_flush();flush();return$I;}function
dump_csv($J){foreach($J
as$x=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$J[$x]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$J)."\r\n";}function
apply_sql_function($Kc,$e){return($Kc?($Kc=="unixepoch"?"DATETIME($e, '$Kc')":($Kc=="count distinct"?"COUNT(DISTINCT ":strtoupper("$Kc("))."$e)"):$e);}function
get_temp_dir(){$I=ini_get("upload_tmp_dir");if(!$I){if(function_exists('sys_get_temp_dir'))$I=sys_get_temp_dir();else{$tc=@tempnam("","");if(!$tc)return
false;$I=dirname($tc);unlink($tc);}}return$I;}function
file_open_lock($tc){$Ic=@fopen($tc,"r+");if(!$Ic){$Ic=@fopen($tc,"w");if(!$Ic)return;chmod($tc,0660);}flock($Ic,LOCK_EX);return$Ic;}function
file_write_unlock($Ic,$_b){rewind($Ic);fwrite($Ic,$_b);ftruncate($Ic,strlen($_b));flock($Ic,LOCK_UN);fclose($Ic);}function
password_file($vb){$tc=get_temp_dir()."/adminer.key";$I=@file_get_contents($tc);if($I||!$vb)return$I;$Ic=@fopen($tc,"w");if($Ic){chmod($tc,0660);$I=rand_string();fwrite($Ic,$I);fclose($Ic);}return$I;}function
rand_string(){return
md5(uniqid(mt_rand(),true));}function
select_value($X,$z,$p,$ng){global$b;if(is_array($X)){$I="";foreach($X
as$xd=>$W)$I.="<tr>".($X!=array_values($X)?"<th>".h($xd):"")."<td>".select_value($W,$z,$p,$ng);return"<table cellspacing='0'>$I</table>";}if(!$z)$z=$b->selectLink($X,$p);if($z===null){if(is_mail($X))$z="mailto:$X";if(is_url($X))$z=$X;}$I=$b->editVal($X,$p);if($I!==null){if(!is_utf8($I))$I="\0";elseif($ng!=""&&is_shortable($p))$I=shorten_utf8($I,max(0,+$ng));else$I=h($I);}return$b->selectVal($I,$z,$p,$X);}function
is_mail($Ub){$Aa='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$Lb='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$Me="$Aa+(\\.$Aa+)*@($Lb?\\.)+$Lb";return
is_string($Ub)&&preg_match("(^$Me(,\\s*$Me)*\$)i",$Ub);}function
is_url($Q){$Lb='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($Lb?\\.)+$Lb(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$Q);}function
is_shortable($p){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$p["type"]);}function
count_rows($R,$Z,$ud,$Mc){global$w;$F=" FROM ".table($R).($Z?" WHERE ".implode(" AND ",$Z):"");return($ud&&($w=="sql"||count($Mc)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$Mc).")$F":"SELECT COUNT(*)".($ud?" FROM (SELECT 1$F GROUP BY ".implode(", ",$Mc).") x":$F));}function
slow_query($F){global$b,$yg,$n;$m=$b->database();$qg=$b->queryTimeout();$Nf=$n->slowQuery($F,$qg);if(!$Nf&&support("kill")&&is_object($i=connect())&&($m==""||$i->select_db($m))){$Bd=$i->result(connection_id());echo'<script',nonce(),'>
var timeout = setTimeout(function () {
	ajax(\'',js_escape(ME),'script=kill\', function () {
	}, \'kill=',$Bd,'&token=',$yg,'\');
}, ',1000*$qg,');
</script>
';}else$i=null;ob_flush();flush();$I=@get_key_vals(($Nf?$Nf:$F),$i,false);if($i){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$I;}function
get_token(){$ef=rand(1,1e6);return($ef^$_SESSION["token"]).":$ef";}function
verify_token(){list($yg,$ef)=explode(":",$_POST["token"]);return($ef^$_SESSION["token"])==$yg;}function
lzw_decompress($Na){$Jb=256;$Oa=8;$db=array();$qf=0;$rf=0;for($r=0;$r<strlen($Na);$r++){$qf=($qf<<8)+ord($Na[$r]);$rf+=8;if($rf>=$Oa){$rf-=$Oa;$db[]=$qf>>$rf;$qf&=(1<<$rf)-1;$Jb++;if($Jb>>$Oa)$Oa++;}}$Ib=range("\0","\xFF");$I="";foreach($db
as$r=>$cb){$Tb=$Ib[$cb];if(!isset($Tb))$Tb=$nh.$nh[0];$I.=$Tb;if($r)$Ib[]=$nh.$Tb[0];$nh=$Tb;}return$I;}function
on_help($ib,$Lf=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $ib, $Lf) }, onmouseout: helpMouseout});","");}function
edit_form($a,$q,$J,$Rg){global$b,$w,$yg,$o;$gg=$b->tableName(table_status1($a,true));page_header(($Rg?lang(10):lang(11)),$o,array("select"=>array($a,$gg)),$gg);if($J===false)echo"<p class='error'>".lang(12)."\n";echo'<form action="" method="post" enctype="multipart/form-data" id="form">
';if(!$q)echo"<p class='error'>".lang(13)."\n";else{echo"<table cellspacing='0' class='layout'>".script("qsl('table').onkeydown = editingKeydown;");foreach($q
as$A=>$p){echo"<tr><th>".$b->fieldName($p);$Db=$_GET["set"][bracket_escape($A)];if($Db===null){$Db=$p["default"];if($p["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$Db,$jf))$Db=$jf[1];}$Y=($J!==null?($J[$A]!=""&&$w=="sql"&&preg_match("~enum|set~",$p["type"])?(is_array($J[$A])?array_sum($J[$A]):+$J[$A]):$J[$A]):(!$Rg&&$p["auto_increment"]?"":(isset($_GET["select"])?false:$Db)));if(!$_POST["save"]&&is_string($Y))$Y=$b->editVal($Y,$p);$Kc=($_POST["save"]?(string)$_POST["function"][$A]:($Rg&&preg_match('~^CURRENT_TIMESTAMP~i',$p["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(preg_match("~time~",$p["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$Kc="now";}input($p,$Y,$Kc);echo"\n";}if(!support("table"))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",$b->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($q){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"])){echo"<input type='submit' name='insert' value='".($Rg?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($Rg?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."…', this); };"):"");}}echo($Rg?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":($_POST||!$q?"":script("focus(qsa('td', qs('#form'))[1].firstChild);")));if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo'<input type="hidden" name="referer" value="',h(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"]),'">
<input type="hidden" name="save" value="1">
<input type="hidden" name="token" value="',$yg,'">
</form>
';}if(isset($_GET["file"])){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");if($_GET["file"]=="favicon.ico"){header("Content-Type: image/x-icon");echo
lzw_decompress("\0\0\0` \0\0\n @\0C\"\0`EQ?tvM'Jdd\\b0\0\"fӈs5AXPaJ08#RTz`#.cXȀ?-\0Im?.M\0ȯ(̉/(%\0");}elseif($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("\n1ٌ̇l7B14vb0fsn2Bѱ٘n:#(b.\rDc)a7Elñi1̎s-4f	i7t4yZf4iATVVf:Ϧ,:1Qݼb2`#>:7G1sLXD*bv<܌#e@:4!fot:<咾o\ni',a_:iBv|N4.5Nfivphl֚O= OFQk\$id2Tp6-Z6h:a,2#8А#6nJht4O42ok*r@p@!?6r[L:2Bj!HbP=!1V\"0\nSD7DڛC!!Gʌ +=tC.C:+=%c1MR/EȒ42䱠`8(ӹ[W=ySb=-ܹBS+ɯ@pL4Ydq63ĬAc܌Ψk[&>Zpkm]u-c:Ntδpҝ8=#[.ޯ~myPP|I֛Q9v[Q\nr'g+T2Vz48(	Ey*#j2]R)[NR\$<>:>\$;>\rHT\nwN wأ<Gw\\Y_Rt^>\r}S\rz4=\nL%J\",Z8i0u?s3#ى:㽖E]xs^8K^*0w~:iv2w^77cu+U%{P*4̼LX./!1Cqx!HFdLĠ`65fĆ=Hl V1\0a2;6_ه\0&ZSd)KE'n[X\0ZɊF[Pޘ@!Y,`\"ڷ0Ee9yF>9bF5:\0}Ĵ(\$37H MA6R{Mq7GCCm2(Ct>[-t/&C]etG̬4@r><Sq/QhmL#K|6fKP\r%tV=\"SH\$} )w,W\0Fu@b9\rr2#DXyOI>nǢ%'_t\rτz\\1hl]Q5Mp6kqh\$H~|!*4`SS tPP\\g7\n-:袪plB7Өc(wO0\\:wp4{TjO6HÊrq\n%%y']\$aZ.fcq*-FWkzjlg:\$\"N\r#dÂsc̠\"j\rՒPh1/DA)[knp76YR{MP@\n-a6[zJH,dlBho+#Dr^^eE ĜaPJGzt2XVȳB_%K=Eb弾§kU(.!ܮ8I.@Kxn:P32mH		C*:vT\nR0uҧ]P/JQd{L޳:Y2bT 34cV=L4r!BY6MeLio9< GƕЙMhm^UNTr5HiM/n흳T[-<__3/Xr(<uҖGNX20\r\$^:'9O;kfN'ab,V1HI!%6@\$EGڜ1(mUrս`iN+Ü)0lf0[UV-:I^\$sb\reugh~9߈bf+0 hXrݬ!\$e,w+3_Ak\nkrʛcuWdY\\={.čgp8t\rRZvJ:>Y|+@Ct\rjt6%?ǎ>/9F`וv~KRWzlmwL9Y*qxzSeݛ~Dxɟi72Oݻ_{53t_z3d)C\$?KӪP%T&&\0PNA^~p Ϝ\r\$b*+D6궦ψJ\$(olh&KBS>;zxoz>oZ\nʋ[vȜ2OxِV0f2Blbk6ZkhXcd0*KTH=πp0lV\rnm)( ");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("f:gCI\n83)781x:\nOg#)r7\n\"`|2gSiH)NS\r\"0@)`(\$s6O!V/=' T4=iS6IOG#XVCsZ1.hp8,[H~Cz2lc3sIb4\nF8TIU*fzr0EyfY.:I(c΋!_l^^(N{S)rqYl٦33\n+GyixV3wuh^ra۔c\r(.Ch<\r)ѣ`743'm5\nP:2Pq C}ī38B0hRr(0b\\0Hr44B!p\$rZZ2܉.Ƀ(\\5|\nC(\"P.NRTΓ>HN8HP\\7Jp~2%OC1.C8·H*jS(/6KU<2pOI`ⳈdOH5-4pX25-Ңۈz7\"(P\\32:]U߅!]<Aۤiڰl\r\0v#J8wmɤ<ɠ%m;p#`XDiZN09占`wJD29t*yNiIh\\9:xﭵyl*ȈY8W?ޛ3!\"6n[\r*\$Ƨnzx9\r|*3ףpﻶ:(p\\;mz98Nj2\rHH&(z7ik cet2:SHȠ/)x@tri98yҷV+^WڦkZYlʣ4Ƌ\\E{7\0pDi-T0l%=˃9(5\n\nn,4\0a}܃.Rs\02B\\b1S\0003,XPHJspdK CA!2*W2\$+f^\n1zE Iv\\2.*AE(db܄9Dh&?HsQ2x~nÁJT2&eRGQTwݑP\\)6sh\\3\0R	'\r+*;RH.!['~%t< pK#!lLe,&\$	`CXӆ0֭:Mh	ڜG!&3D<!23?hJe h\rmNiNHl7vWI.-5֧ey\rEJ\ni*\$@RU0,\$UEªu)@(tSJkp!~d`>\n;#\rp9jɹ]&Nc(rTQUS\08n`ybLO5,>xf䴒+\"I{kM[\r%[	ea1! ԮF@b)R720\nWLܜҮtd+0wgl0n@ɢiM\nAM5n\$EױNl%1 AkriFBol,muNx-_֤C( fl\r1p[9x(iBҖzQl8C	XU TbI`p+V\0;CbX+ϒs]H[kxG*]awn!6mSIK~/ӥ7eeNS/;dA>}l~ %^fآpڜDEat\nx=kЎ*dTj2j\n ,e=M84aj@Tsnf\n6\rd0Y'%ԓ~	Ҩ<AHG8΃\$z{u2*a>(wK.bP{o´z#28=8>A,e+Cx*-b=m,alzk\$W,mJiʧ+0[.RsKXZL2`(CvZ\$׹,D?HNxX)M\$,*\nѣ\$<qşh!SxsA!:K}RA2kXp\n<l3VV}g&Yݍ!+;<YYE3rَCo5ճkkۣtU)[}ul:D+Ϗ _oh1400bK㬒lG#|UdIK7^@O\0HHi6\r\\cg\02B*e\n	zr!nWz& {H'\$X w@8DGr*H'p#Į\nd,,;g~\0#E\rI`'%E.]`Л%&m\r%4Sv#\nfH\$%-#qBQ-c2&] qh\rl]sh7n#-jEFrl&dzF6\"|s@z)0rpڏ\0X\0|DL<!o*D{.B<E0nB( |\r\n^ h!r\$(^~/pqBO,\\#RR%dHj`̭ V bSdiEohr<i/k\$-\$o+ŋlO&evƒijMPA'u'( M(h/+WDSo.n.n((\"h&p//1D̊j娸E&⦀,'l\$/.,dWbbO3BsH:J`!.,F7(Կ1ls ҎŢqX\r~R鰱`ҞY*:RrJ%L+n\"\r͇H!qb2Li%Wj#9ObE.I:67\06+%.a7E8VS?(DGӳB%;/<\r >M@HDsZ[tHEnx(Rx@GkjW>#T/8c8Q0_IIGII!YEdE^tdth`DV!C8\rb3!3@33N}ZB3	330M(>}\\tffI\r337 X\"td,\nbtNO`P;ܕҭ\$\nZѭ5U5WU^hotPM/5K4EjKQ&53GXXx)<5D\rV\nr5b܀\\J\">1S\r[-Du\r)00Yˢk{\n#\r^|uܻU_nU4U~Yt\rI@䏳R 3:uePMS0TwWXDKOU;U\nOYYQ,M[\0_DWJ*\rg(]\r\"ZC6u+YY6ô0q(8}3AX3Th9jjfMtPJbqMP5>Yk%&\\1dE4 Yn\$<U]Ӊ1mbֶ^\"NVppeMWܢ\\)\n \nf7\n2r8=Ek7tV7PLa6v@'6ij&>;`a	\0pڨ(J)\\nĬm\02eqJPtfj\"[\0X,<\\+md~s%omn),ׄԇ\r48\rmEH]HWM0D߀~ˁKE}|f^\r>-z]2sxDd[stS\0Qf-K`twT9Z	\nB9 Nb<BI5ooJpJNd\rhލ2\"xHCݍ:9Yn16zr+z\\m T @Y2lQ<2O+%.Ӄh0AZ2R1/hH\rXaNB& M@[xʮ8&LV͜v*jۚGH\\ٮ	&s\0Q\\\"b	\rBsw	BN`7Co(\nè19*E SU0U t'|m?h[\$.#5	 	pyB@R]@|{P\0x/ w%EsBdCU~O׷P@X]Z31{eLYڐ\\(*R`	\nQCF*霬pX|`N\$[@UZ`Zd\"\\\")I:toD\0[-g*`hu%,I7īHm6}Nͳ\$MUYf&1e]pzImG/ w !\\#54IdEhqѬkx|kqDbz?>:[LƬZX:jw5	Y0 \$\0CdSg{@\n`	C M# t}xN{۰)CFKZj\0PFYBpFk0<>D<JEg\r.28U@*5fkJD4TDU76/@K+J@=WIOD85MN\$R\05\r_EIϳNly\\qUQ\n@ۺpP۱7ԽN\rR{*qm\$\0RԓqÈ+U@BOf*CˬMC`_ ˵NT5٦C׻ \\We&_X_؍hB3%FW|Gޛ'[łV#^\rGRPFgYi z\n+^/\\6bdmh@qAh),JWcmem]ӏekZb0Y]ymfeB;OwapDW{\0-2/bNsֽ޾RaϮh&qt\n\"iRmhzeFS7PP䖤:BsmY d7}3?*tlT}~=c	3;TL5*	~#Asx-7f5`#\"NbG@e[s-M6qq he5\0Ң*bISFή9}p-`{ɖkP0T<Z90<՚\r;!g\r\nK\n\0*\nb7(_@,e2\r]K+\0p C\\Ѣ,0^MЧ@;X\r?\$\rj+/BPJ{\"a6䉜|\n\0\\5	156 .[Uد\0d8Y:!=X.uC!SopB7ůRh\\hE=y:< :u280siTsB@\$ @u	Q.T0M\\/d+ƃ\n=dA)\r@@h38.eZa|.7Ykc'D#Y@Xq=M44B AMdU\"Hw4(>8C?e_`X:A9øpGGy6FXrl1ػBÅ9RzhB{\0^-0%D5F\"\"i`nAf \"tDZ\"_V\$!/Dᚆ٦̀F,25jTy\0Nx\rYl#Eq\nB2\n64!/\nQ*;)bRZ0\0CDo˞48e\nS%\\PIk(0u/G\\}4FpG_G?)got[v\0?b;`(یNS)\nx=+@7j0,1Åz>0GcLVX%Q+oFܶ>Q-clwz5G@(hcHr?Nb@lx3U`rwUt8=l#l䨉8E\"O6\n1e`\\hKfV/зPaYKO x	Ojr7F;B̒>ЦV\rĖ|'Jz#PBY5\0NC^\n~LrR[̟RìgeZ\0x^i<Q/)%@ʐfBHf{%P\"\"@)DE(iM2S*yS\"e̒1ט\n4`ʩ>Q*ynTu~%+WXKQ[ʔlPYy#D٬D<FL@6']Ƌ\rF`!%\n0c˩%c8WrpG.TDoUL2*|\$:r@&4H> %0*Zc(@]Q:*(&\"x'JO1`>7	#\"O4PX|B4[٘\$n1`GSAAH\")Sfɦ-\"W+ɖ\0s-[fo٧Dx=C.9fc\07?Ó95֦Z0fH?R'q>o@aDG[;GDBBdġq2|1qw<#EY^Q\\[X>?v[ I g\0)gug42jú'Tvy,uD=pH\\^bqitXFP@PTi2#gDᮙ%9@");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress('');}else{header("Content-Type: image/gif");switch($_GET["file"]){case"plus.gif":echo'';break;case"cross.gif":echo'';break;case"up.gif":echo'';break;case"down.gif":echo'';break;case"arrow.gif":echo'';break;}}exit;}if($_GET["script"]=="version"){$Ic=file_open_lock(get_temp_dir()."/adminer.version");if($Ic)file_write_unlock($Ic,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}global$b,$h,$n,$Mb,$Rb,$Zb,$o,$Lc,$Pc,$aa,$od,$w,$ba,$Fd,$se,$Oe,$Zf,$Tc,$yg,$Bg,$Jg,$Qg,$ca;if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];$aa=($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure");@ini_set("session.use_trans_sid",false);if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");$D=array(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",$aa);if(version_compare(PHP_VERSION,'5.2.0')>=0)$D[]=true;call_user_func_array('session_set_cookie_params',$D);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$vc);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("zend.ze1_compatibility_mode",false);@ini_set("precision",15);$Fd=array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);function
get_lang(){global$ba;return$ba;}function
lang($t,$oe=null){if(is_string($t)){$Re=array_search($t,get_translations("en"));if($Re!==false)$t=$Re;}global$ba,$Bg;$Ag=($Bg[$t]?$Bg[$t]:$t);if(is_array($Ag)){$Re=($oe==1?0:($ba=='cs'||$ba=='sk'?($oe&&$oe<5?1:2):($ba=='fr'?(!$oe?0:1):($ba=='pl'?($oe%10>1&&$oe%10<5&&$oe/10%10!=1?1:2):($ba=='sl'?($oe%100==1?0:($oe%100==2?1:($oe%100==3||$oe%100==4?2:3))):($ba=='lt'?($oe%10==1&&$oe%100!=11?0:($oe%10>1&&$oe/10%10!=1?1:2)):($ba=='bs'||$ba=='ru'||$ba=='sr'||$ba=='uk'?($oe%10==1&&$oe%100!=11?0:($oe%10>1&&$oe%10<5&&$oe/10%10!=1?1:2)):1)))))));$Ag=$Ag[$Re];}$ya=func_get_args();array_shift($ya);$Gc=str_replace("%d","%s",$Ag);if($Gc!=$Ag)$ya[0]=format_number($oe);return
vsprintf($Gc,$ya);}function
switch_lang(){global$ba,$Fd;echo"<form action='' method='post'>\n<div id='lang'>",lang(19).": ".html_select("lang",$Fd,$ba,"this.form.submit();")," <input type='submit' value='".lang(20)."' class='hidden'>\n","<input type='hidden' name='token' value='".get_token()."'>\n";echo"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];$_SESSION["translations"]=array();redirect(remove_from_uri());}$ba="en";if(isset($Fd[$_COOKIE["adminer_lang"]])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ba=$_COOKIE["adminer_lang"];}elseif(isset($Fd[$_SESSION["lang"]]))$ba=$_SESSION["lang"];else{$qa=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$Ud,PREG_SET_ORDER);foreach($Ud
as$_)$qa[$_[1]]=(isset($_[3])?$_[3]:1);arsort($qa);foreach($qa
as$x=>$bf){if(isset($Fd[$x])){$ba=$x;break;}$x=preg_replace('~-.*~','',$x);if(!isset($qa[$x])&&isset($Fd[$x])){$ba=$x;break;}}}$Bg=$_SESSION["translations"];if($_SESSION["translations_version"]!=294525227){$Bg=array();$_SESSION["translations_version"]=294525227;}function
get_translations($Ed){switch($Ed){case"en":$g="A9Dy@s:G(ff	:Sa2\"1..L'Im#s,KOP#I@%9i4o2ύ,9%Pb2ar\n2NC(r41C`(:Eb9Ai:&㙔yFY\r\n 8ZS=\$A`=܌0\ndF	n:Zΰ)QmwOmfpQ΂qaį#qw7SX3o\n>ZMzis;̒_:#|@46:\r-z|(j*0:-h/̸8)+r^1/Лη,ZӈKX9,p:>#(6qB742LtD:\"IR{ p*	.\nHh\n|Z29Cz7LH\nj=5(/\nC:0ʖZtXj84N`;P9Ikl m_H\"0#0ckP:CPS#Iƍ&)EU\nL<A9  ]@\$#-'[Uc+`:P\$Bh\nb-7(.hZ2MJk6B;0\"ƎSH΂\"ލMp򍯃1#:݅P3^\rRb8+!:05`>x(\n[Sɝ/]G@\$cB3[t\$|D7}x!X4;Hy9%	R\n,q	]ñ.ϴ{jֿۆJp#_\"2@A?zBMZxӅHp~=Ò[DZJ0<(b09ih#3;ez&Y0Ɓ\0N20=lyJ_ɨ \n (  \0\"H&4D!~Ni#FD42.eIAbLS\$0{7~\$7xd1\n`47vZ[31hѺ9Gd!0\rm^vI90fȒZKBHIN8d'=W5-o\$H ܐu !ٕHZSthG'ǸʴL\n	L*C5a.S֣>}'rJs}yE܀JAd@H\0gL(H#RtXixd&\0JI&,-Cq\\1%bNPʲS'H\r~3Q_Ʊg3}8+C`+5H⑳N	'G=@BF%sIB0i{Nb[\n0F9zM#qIÛ5J.`.*3j]x5ɠAFb?ᴳcITLF@o'/DNý:jt*j7p<BPN\nQx6AR4UVW_YOVlA\r-Z;HHm0.";break;case"ar":$g="CPl*\r,&\nA(J.0Se\\\rb@0,\nQ,l)µAj_1CMeS\ng@OgXDM)0cAn8e*y#au4 Ir*;rSUdJ	}*zU@X;ai1l(n[ydu'c(oFe3Nbp2NSӳ:LZzP\\bu.[Q`u	!Jy&2(gTSњMx5g5KK¦0ʀ(7\rm87(9\rf\"7N9 4x荶x;#\"2ɰW\"J\nB'hkūbDi\\@pyf9V?TXWF{3)\"W9|eRhUҪ1P>\"o|7LQi\\ H\"#0[~5[guҩ!Jv7cHN&f4(!LX<_T?t*	1DX=î3%׊~\"s1\n?hAj&\$!P#0M8xHimZԏ<dRI\r/hP&ӨRڱ3ŗ!]6N\"7&b-m'= W\$\rDL7rldՊ+nP2ٰQb@	ht)`P5hc0[O= P:\rS<#J70-b\$*\r@0@:Ӄ1C:\07P60ra-6CvaK`(;m1VbE\0006c5 :ӯX@ q?N0@-3:xsAPHp_	RC=A=C8x!J L.SF*2x\rm>Lj7aԡ@ʙ\"'CCy/-ûz'^{uODSI\r׆׺[Q޶M<!҆8\rЧ|u%'cpAe%ֆJCS;\n(p@9CeC4C\r7\nJE6a pV=FIX'Z#s Pp\r\\&~\r*\nG\$D٨CS0hj\rQ524͙B^Cp-b4:775CD10Hgy`4GJlГdS\nAR(B!NTI!'\"iFUst%P\03+bH#V	(e#X.!j#5IQ\$g\0d\r+dӡt 6mx8Sd2\r)B]!bHlNP5>\0¡\"-JsF+[eQA	8U蒤Bܫ*m\"UY:ymO(giD@ý`@CL(@ 5#@a郔hmStF1ALWa`O\nPϪuu1NZD`D7OD[\0T\0Bw3a9WPCHc\rjY<P!鴯4fF!!y¨T)}J]'JŃ[!莭H)l`\0\0PMy5JւHdh{%FItܭnJ\$D\\*:\0PL\r6\"q3͒?צN7ߢHy)2&+]V#}Һшu`ɦQ+wk%\0";break;case"bg":$g="P\rE@4!AwhZ(&~\nfaN`D4\"]4\r;Ae2a.arp@ד|.W.X4FP\$hRs}@ЗpДB4sE΢7f&E,iX\nFC1l7cMEo)_G_<Gӭ},k놊qPX}F+97iZ贚iQ_aZ*n^S9YV~]X\\R6}j}	l4v=3	\0@D|¤[^]#s.3d\0*X7p@2C9( :#9\07A8\\z8Fcm X4;r'HS26A>¦65	ܸkJ&j\"K9{.-^:*U?+*>S3z>J&SK&hR&:ɒ>IJLH,/\r/SYF.Rc[?IL#b6FpAudVe27cHl.(:>ؿ-)V5԰КRferhiʍW4&+Œد\\A#\"-(V\"?	ZxjK\0+@\"M*EV\nCfW%i@\"+)]NJbBY6#',}qA(R*ZWE*˲x؞+o{I|,Kx+HѠ2PBںrZg}**l.Z;:TO27U;k=w˓76)RL\$pRM֨kήv<y?}FLjxJf\n73T5w:o}z~]Q`{ŉ-vl\\PѫB6rA1'3*QfYld\r7\"@r p`paPVzgEx\"1@xat!*j`^I=x_@xa	`\$5<DayAjٓ]a|1pØwaw1ȏbZb'h*b,E28|#):m	r˥}ro+Y+r'^}A5Gttʙ*l*Cclv\0bFAC+!k\$|9a:\0<\$:A?QƝ\01(Vpa\r3LL#xVZ;Jw:\n (Q2g4R^d	Y5mi\0,ڊ7\0Hvi3Κ|GaЩL\rԨ^\$UCH90HcЌ3yjc0p2Ұf'ԠBxLI\rDGI^Y)H̪Xzʃ5j:ShSR+etUq\rIe6isz鬏z{mvAxSRޕZTҰ)FSJ\0ңomvKw΁aHWIy7S{%K\$;pyZw~=5(͓9*:Bh&+hXA\0S\n!0BM0*RT	3Y/)iJ_fFS{vNĨ+\0XP_^>{y!+vX*fY3UibNkʌdIN3}r\rfV3]!@\n&,inWN\\-J\"kt6bcN&Q\00-\n^Vx#c8ч䡌١j,[Zٚ;ՁUiQs\\8d #ΚZ7f1w/dh{O\"Ῠ\"J1˥TA?k)Y-Ϭ:zw*%Rd(TF\\. lKWf^Tijzs7.<7R|MJB\"֦u6aA'\0p&'~yT3eeqϴ#";break;case"bn":$g="S)\nt]\0_ 	XD)L@4l5BQp 9\n\0,hSE0ba%. H\0.b2nDe*DM,OJÐvх\$:IKg5U4L	Nd!u>&a\\@'JxS4PDz.SE<OSkbOafhb\0Br)QWE{KPP~9\\l*_W	7ɼ 4NQ 8'cIg2O9d0<CA:#ܺ%35!nnJmk,q@ᭋ(n+L9xkI2L\0I#Vܦ#`B4: ,X2,(_)7*\npp@2C9.#\0#2\r78M:c2@L S6\\4Gʂ\0/n:&.Htļ/02TgPEt̥L,L5HLGj%Rt-I04=XK\$GfJzR\$a`(+b0z5qL/\nS5\"P`@/rMX~N7cH߆Q(L\$>(]xW}YTW5e޵}*P9/Vu*Reمeݔ^mhO!.8\n@< S\\bѶr8ȊE(ym+Ď+^d@'nE)\\tWZz·+/\$DĬ\$8Zqd敓ZCڷFON{	YJda!sAȭAB9~+gJ\rY(աIMՉW\\Svjc&ޘwE6ڟG4@\$Bh\nb:h\\-_H.+/7Gpѵ`9NC\r3ĘTIQ^U,FZ,u@yha\rVCc>!3P`o09a&jjL0RYȦPQiSWL)TL\nf>AVA\0A7&\\{\rx f4@:;P\\bN	3zx`aчH\0DIISm۲R!!MYwGE#6qJ~ޘOr=\nC&Ci*\"2pc\\m9P]a>£\ra |Chp=?I# 78k<A&3CsfEMʢߘf5b	8͔O\r09\0w=1@\"r\$0ib#´Dd0@\r!65tEL\$߱J;GDٝ@C}ʣ[h{IPeN)\r\"ϙ='T\0r'M!Hw(&|8sPp&:ppr9UDOc\r4x(*<0hSڡ \0FXj-ڞQhGj}bqf#	X:MpX\$\"\0(E\\օ4	j횦X\$9X\n#g&#0\n(p\"aJRG4̟Sn@O}ɸ6ř,:jp;RςY	D5) \n<)B))/[5&hgۅj<vjC#=U8VV/Pvm#8b)5m3`R`I\r3e@l	l<i̴6) 9(p'-J}HwhgIVE2VB~\"nN6,DճstjQ\rXR<&\riBþMC;iゥuRLi*s\rWHc\r`FpM0EiS4h9;FA+'3\rBT0(iuu\n\\U|>V:0ΔHSi}wkY:*\"ޭtndnZ)YJܱLWѭAPMڛZkb.g\"z>6nuڄbKnS+8G88Ju&WI)`cUPSfVi!7txl%4#\nZtۋ~n7A	V_jn\r\nUI!PL*V:| ^ܔx{߇G9ŋw/\\dՊ~JbMWvD,`";break;case"bs":$g="D0\reLS?	E34S6MƨAt7ptp@u9xN0V\"d7dp؈LAHa)̅.RL	p7LX\nFC1l7AGn7(UlbeēѴ>4)yFY\n,΢Af -e3Nw|H\r]ŧ43XݣwA!D6eo7Y>9q\$iMpVtbq\$٤\n%LITk)乪0h4	\n\n:\n:4P ;c\"\\&H\ro4x@,\nlEj+)\nCr5ү/~;.j&f)|0B87,	+-+;2thkVn)(7?7cH>%c\nHxqx(K*-RэL7,UK8ĘMRUcRWUUeI,#R\\ubSj3L֌\"9Knbc,p,#X\"\"(FJ	\"_%.%(\rJ\"1<:ŉ]Ȭ\\Z+]ZF_)Clڰ#N}߷؞\nCu	@t&Ц)C\$,6p<ȺV)	6K4,J3ܿtY67j4<1mP3b7(/0\n+0:@ªR2*4MP:c4(8@ s42c0z\r8a^(]Ð\\{	?}أHx!\\+7\n[AhP98'pR#'\n#,s<;=J;jc[׌ӝ>	#hӱpxK@ՉB95bsb6@MQ+9fOqݙ晱D\\4\r23tZ^l\r6XTA}\r!@>9_	H*X's( ,\\DGD	TAa%\r?hP`14ԯ\rYA(@e!+FDw~͔\rpùqw:\rCᄔ&^;!0&\\aE`Ȉz56Udڱ94ՃaV	1&rzsLA+0@ٽ;ʱ:DECC蜸!\n9FL8ST1Cn1)vbQ86<J	 @'0#\"C!q4h!	2W\r*Cpf!D2QS>}4#6%+Q	&J@B0T\$i4O94r	&\r!Q,F+EBx\$]Uu^rRX=4`E`,EVBX_TJʵY\0CK܊;YButAkEsn\nP#p\\<dWy4 n`v+NL\rhVA(.L0rReCfؕSaI\rԏ.wڅ16/pB|f%IRPCaz\0_U0ڰR4d@#F\r2ߗ%*brX҆\rF0Lݼ#-YM2SA`C";break;case"ca":$g="E9je3NCP\\33ADis9LF(d5MC	@e6Ɠrd`gIhpL9Q*K5L S,W-\r<e4&\"Pb2ar\n1eyg4&Q:h4\rC MXa+\\>RLK&v3épt0Y\$l1\"P d\$Ě`o9>U^y==\n)n+OoM|*uNr9]x{d3jP(c2&\"::\0\rrh(8p\r#{\$j#Ri*hB8BDJ4hn{K !/28,\$ #@:.̀(p4h*; pEꓯS;\$K1T&C\"\0HBU0?	#p3Z&fTMDը#J\0<\0Mi[W+`PH gb4^I#\r87#`7`P9LaZ s=ER#,RR+)W3YSV˂(ꊷ@L\"s )ӵ@w1W68CasFZ#^#z	+ \$	К&B ^6x0tbx\n\0GRh0MJx3C\\\"xxU⌀7<Lr3Z% 3+ˌWi\r@UU>Bkh(;@ _HʌD49Ax^;r?&A|=P^ݻx&)>TśLHn޳@{+	pAhnypt]'Mu]`r^v]DQQ+X^u(F7PCk#T&ī{<3BL	@TPأRőX 演\";||x3=jZC\"X@h#ȫBу&?e02Y\n (`ނyF \0H7395fאvj -`;FPRhXcgI4cV8M;V%\r=\rH03wM7@ÓOxrLRGB,\$ ũ\n9[IR0\nxaI\")e\$E\$i#z7@v \$(\"I3k\\jjۜ	ȜF@xS\nQb|F	gyJ['NT^Ȯ(dBfQ+!/=s<h>k< \naD&80 R2jOd@vj	.&	Մ٘fjE,'0bK%YrlzN`hi%fzĠզ j#N @\0la:__|d6E6IAj&!>T(awT*`Z1⩝*]k\rw!\\Xƴ&+=kRdܴ!:uЉ+l&\$ŽYY;IVВk1!vabF]*KI00ΤbO2\rn];@ŮpȞ|5XRm2km\"M\nj>u\"`EL[2HhyE눏Q3Ahh+<:\0";break;case"cs":$g="O8'c!~\nfaN2\rC2i6Qh90'Hib7ii6ȍA;͆Y@v2\r&yHsJGQ8%9e:L:e2Zt@\nFC1l7AP4Tت;j\nbdWeHa1M̬Ne^/J-{JplPDle2bcu:F\rbʻP77LDn[?j1F7I61T7r{FE3iǓ^0bbp@c4{2&\0r\"JZ\r(挥b䢦k:CP)z=\n 1c(*\n99*^:42Ya8 QF&X?|\$߸\n!\r)<iRB87x4ƈ65n\r#D8je)C֊мH9Cҳҟ>@SJ񌯠6\"+R؎Q! P# P4MIގq958TB'ռ(q; @10U,<\rz:.`P7\rT\\bMMC5t4b,0`P2\"ÀkʌB}9\$qO\"@1t3|{@P<'N\$CtI]N68v#.5#X|Y+y%zW}4\$Bh\nb2h\\-Z(.ݷ{T\r*%(3(P2P5˕\r`Ѝ\"CX9xt΋땃LըmD6-lWӱ.{nV[kn\\`{'c<.çNnv4ܑ[ns>ۉCX14R4;8)?	(@J^7\03:pt\\%#8^1ax7à}V\"ie0:u'!5F	?J27G#dZۛAfd\r5t%#A { 9=s|o󾔢k~*@J>	!1TZp\"&S\nt0u10F126#Aĸirf\r7(I	:V\"fê݌n〜4h!(.j!\0TMD4IYy/i˼!%|GD\nqi@\$\0A'd_\nPjh\"AZ\nx\n#3!JIKNb\rAU! \\y:7ISH<RB8G FhHCY<) hJc[.e688L|V\"Q8N\0A<QaA+#\"F=r4DUȒF(R>#5`ڞ`v_^`7F<!@'0Q=X'oKz6rz~4ppl505jHXV((0	)'*|WG\"7l7nTdttEwWl0߇3S| i\ruG%BѦB~n	媡次(m@Q	uW4]\\ɘ)Ҳ۪[H%a: \nCVZq\n#tbUf4)X\$Q!7o\nP#qC` F܋cL9YfAU	D)&5n^J2\$EAtwsf`P\nW7K)ESK#4BfY	TDӺ\$C4G3K;'lU	(<ANqNIv(!5\\feab2'Z	:\0˚^ʀBy[5f㑍ꐡ?\0(*p(3&dk";break;case"da":$g="E9Qk5NCP\\33AADeA\"o0#cI\\\n&Mpci :IMJs:0#sBS\nNFM,8PFY80cAn8h(r4&	I7S	|lIFS%o7l51r(6n713/)@a:0\n]te8g:`	hB\rgЛ)03h\n!pQTk7WX'\"h.e9<:t=3ȓ.@;)CbҜ)XbDMB*ZH	8:';M<9\r#jEBp:Ѡ欑#j\"<<cr߽\nz(oh 2<&r7I8R\"8߭܉	,\nS\"Bpж\$T8e9CP\"PxH b\niӸ483I/84C\$2@\r)(#TZ'P\r Q\"X,u!\$\nn60:B@	ht)`PنRwJ.Uj2=@PBނ-(3ʩR!P\$U<b*\rl<1o31#=jYêjaLp<42I[m+2#&`dȃ\$Hx0Bz3ˎt\$:[γz#@4́xDmbbxCX@)\$6'KBt7@<\$#,BNZ5Σ+(qpA꺾{*ּPݵL\nTلJ |\$`M;zƑhr۠-\0@3M*Dģon5h|!K3>~#c2d.9L4<e:`f(a91׀Khs\$9Py@0͜*I:2l\0kd\n\\z8!}<\"Ӫ`x.I\$#rFO3f)O31ӍkHw\r1effM`1ªAHeЄ00-,d\$^:y'<֒TK	qP/3M@oa~8sD.\rqС2DC P` ,R':B/i-,Gl>'99	BxS\n9\$B[ 5Mg\$H(BTzbUr鐒p_z=:G	A)d+0j\r@p@`qw9`\n\0ra(PEA|ܚ*D&0pFPʗIi0D%lE\r(p`+\rh5ȦBh% WgQT*`q(g;'Db1sj8`1VTH#515QCCD>l\$@(9_~EIU=yCJF&#D31E6a~?hNC@|F	_xbM.D%b0K#\"a:nk5J^&*\nd)⊫~&2";break;case"de":$g="S4@s4S%pQ \n6LSpo'C)@f2\rs)0aii6Mddb\$RCI[0cI S:y7at\$tCf4(e*,t\n%Mbe6[@rdQfa&7n9ԇCіg/* )aRA`m+G;=DY:֎QK\nc\n|j']C\\<,:\r٨U;Izdg#7%_,aa#\\\np7\r:Cx\$k6#zZ@x:x;C\"f!1J*n.2:8QZ,\$	00sΎH̀KZC\nTm{SC'9\r`P2lº\03#dr5\rZ\$4)h\")ިa\r2\rQq<1hB@9bdp?R4g/\n@9P7Rp60bF=!<HKaXh5 RW\\b펮CĢRJ028Pލ)k^##`H\ns\n:8c0u\rC57͢ė\rKLX|kYac\rDjcT=U\"@	ht)`R6՛Bŷc>Jld/4C7VϡO-7CCV6\rWVhB@\\D8A64 bj \" ):=߭6[%J\rs4NI\r&z\0002?\\h 2\r\rt{DA\0x08z+9Ax^;r5ܯp\\3߲\$whA46\rsL7!^0tg\\\n|\rmڝQ{?;u5<d87a? hx!!ދwOX9=ԫ|D{G-7>H1Q\$&٭JL\"rym4u\nq~ȝP-\ndKϙjlfYjcAEO20[!.`N`:&)ЇHүP g\r#tbA!)n\"^͊<1@:8\"YPvGAAQ0Dh!dƲ%ѫX@ҨsJ%\ncg;1+CS솛bwa܆r&Ԋ,\0FP7r(E×l0͞\0l<;brM'\0'`)X\$dKraѵ<%S,r8:B	3tWM\\#B0@wƍr0VSp&̃E,LO\naPr@HJ(6sR©SrRJZM:zwġ##FY Ia:xgݰk)q\"\rVI\n!2MhT\n4i	vv[dn3.ѯn;W\$X:)6_\0j,3\"U@i4쿰	C`B6JP\$\nX辬A\0U\nKe \$͈So0T8ɛ3թ_HV+>bPR9(%L\\1!!T\$I똋R=c@M +&Ȣ(KI=JەDKCm:1q3o(4S>%ݠ'\$uҀ]!9D\0`Vn6+`\$Ax ";break;case"el":$g="J=Z &r͜gY{=;	E30\ng%!F3,̙i`dLIs9e'A='\nH|xVeH56@TБ:hΧg;B=\\EPTD\rd.g2MF2AV2iq+Nd*S:d[hڲG%..YJ#!j62>h\nQQ34d%Y_\\Rk_U[\nOWx:X +\\g+[Jy\"Ebw1uXK;rhs3D6%`YJF((zlܦ&s/2/%A[7[JX	đKںm늕!iBdABpT20:%#q\\5)*@I\$Ф6>rϼgfy/.J?*X7p@2C9)B :#9\07A58\n8Oc9)A\"\\=.QZ䧾P侪ڝ*\0\\NJ(*k[°b(l1Q#\nM)ƥlhʪFt.KM@\$@JynѼ/J`3NBz,/*V]\$Q+\$ \"U:#6OA9vX\$27cHߐ0R\0JeToiEM:MbEgqOi6F芾N2z9,A(C<@X59r^{c	h!p\$^5Sb.|H_\n~>\"h4T2[zr>滯>6U:e.x]wA~S\nH&r*&qR17\$DAoz^F*_|%6@I:\\HA|]G\"N+};T2tDTsԒ++\$\rZIIUp޹c\\9+Ī+,vYLj-\r`XOi2Na׀,I?1dXXAaqi@0D7x'DE	UvdrЅL=,).܋PT\r4 !\rCHnN16B C0=A:@/V#p3>7Dw!(DԞl\\ʌLE0ݿtˆpƃ(x'bS9|M\rzPJ)I)DWK	\$%q2	y/>r	)\\y\0@ZO\"S^	6A²(Ɓxң)I\$²vh7I0ǜBCvY+(UXLiRfbssR	>. \$A2rP1\r3Ch>])6\n_\0̙VbQb@*~A\n&_b:-a@\$\0@\n)~'6rIYi;r@i΀2zoRa7ZZý]!8'ۗ'WKuQj5G&@iuHyHaDS\nU>(\"RKBS\nA4CZ(CO(4%\"S\$wwohDcZ+!ST[\"4Xszy&Rf\$ݗE0Qâ17K4XLD݃BȓL#g(34X`ފ\"z	A*I<'j _@'0ZA':e\0\n_QʺĥY[tZ2z2Ej4nHI\"4/OI?P'4C#WQP00T #KM51BՒp/X*ɀMa+kY)eö́H#Zk	-RKN!=ͤ}!!gn0m˴6,k\"=H<Cėwݔ\nReٿ\0C`+a,5́[\nyV10+Wl:9Ȏ.}\n%5Ph8)@أ{ܨm^}Kg^/;sBvaN\"1\"%}	bԓ]@+;CV):\r\$hSf`^Qq\"ѦS=]-Pb;\$Uq~4Ex:⊠=(գdu\n\\:`\$ҷRIku\$0AtŐ~[=NĚ-wdH0aӑz9x{{pU\\b9y 8H44jVii7f0v;*DW_R̦)Ej:;v7fBfbfYC";break;case"es":$g="_NgF@s2Χ#x%pQ8 2yb6Dlpt0h4QY(6Xk\nxE̒)te	Nd)\nrb蹖2\0d3\rFqn4U@Qi3L&ȭVt24&̆1)L(N\"-DˌMQvU#vBgSx#WЎu@R <fqӸprq߼n3t\"OB7(%vI U7{є9M	9J: bM;\"h(-\0ϭ`@:0\n@6/̂.#R)ʊ84	0p*\r(4C\$\\.9**aCk쎁B0ʗÎз PHP:F[**.<41h.o?Q\nPA3E?B3#0&F	@暹ks\"%20Lw*z7:\rTḣ4Xʢp2+09(CUlCx^vbRk4e@9*jQh3gL,L+\"8x2\rCGsJW#-̖/7W04ƈh0u0\$	К&B ^6x0\nуpMI.p6L63<r>+݈oL!P\nzz0\r\"N3`O-#-08#ς/KLYCpR\nh;GӔeJ:&q<C4#<!߲еH(iPy\r`C@:t<FCz\r|J7}ԸPx!ٷhh:t- i9k{Sd\0i\0/	T9pk 8\r,dq%r5sÿ@2tAwIu:D	)*C%8k>RP՛|5%Fϱ9gGPd(%Fx1e\n #MՑhBo8;bY@rpA%+0j/Q5f^+6+H0\r`Ǚ#G\"y!=h(AzhRR!0a̎@K:n3FLM1	9DlB4%s5r2u!\r\0w&,	\$F3KC\naH#@AO\"YUra^GSq,aVCq0m;Q''IzJ8 J\n!PI,aǐށA61V@Б\rk#dHPxS\nt&rGH 1m0Tz0xl;b3ɌnL{&hrkCV60q`a#\$ԑ@<;=>W(J*_*bz`!a50ޟ%M|sEzwlFLka&`!\0\nYRY+ڻ%(咖M5:6 0-`73Z2zE[,VBR#\$o)J`qYTnW\rPmÛq\$QHt<r[A*ɆVU=()ٓp%t7CSU\$3oR#0'\r%b\nv3Z^\"jly\$JbFղQQ=Z%M";break;case"et":$g="K0a 5MC)~\nfaF0M\ry9&!\n2IIنcfp(a53#tΧS%9pNS\$X\nFC1l7AGH\n7&xT\n*LP| j\n)NfS9f\\U}:Rɼ 4NғqUj;F| :/IIR7aýatpAߚ'#<{Л]a	U7spr9ZfC)2ӤWROcҽ	jx2nv)\nZގ~2,X#j*D(2<p,<1E`P:Ԡ88#(!jD0`P#+%	JAH#xR\"Z9D\$\rӚR c\r`ܝ\rj&DQ'\r<Eܓ,KB`޶\"	Nx S34CPʈ 2:,3PH i` P5,2Ic\0kP(\r5b42@PnP#!2HM4zڤIf*]Z:P7#X\$	К&B*h\\-8h.y60L/&#x3#ihru5N% .{<6ACc06/90#:2Wӊ<(P9)7f|%)xܞ4N̽(;P3rP9h#\n!xߍ@C@:t\$-#8_\n\\PxDqϮ}#N\\С3j^z4ݣ2\nP\$Xno;R{<X0	J@|\$/ç1O\\7;%*T	P,WI\"U)!Fs}ɱ\$1O՛tlH4eEC\n_4Is&^x2DH@ZtBu8P	B!4**T)\rD5\nO`#f4x8Di:\0M@cV\0,h\rkhnܘvfptv Tpaw@ލS) Q\\*:ZCkvԜ`O	iek\$G)/OP\$2h\0EɖB]MĐ|dipy\nB6`8d(kYGBFC?VI@VYnRKM֧-0k:Itc3{hQ	3)\n\0F\n6Ǻ\"xgktZv׀PUu󪑵TKU>:L\\:yUȭ|VpN0䢙C`+\rdخ@RqƉ0)Ph8O\rj%W\r(N\\i2DnT=K9	4`[`HDs4Q*ԕqja6YrY		PR}K\$LUA4\$Cɚ*o}w\"j+i.V9% rαSlnvbF1q.e)\"_,Y%ᤄ";break;case"fa":$g="B6P텛aTF6(J.0SeSěaQ\n\$6Ma+X!(At^.2[\"S-\\J)Cfh!(i2o	D6\nsRXĨ\0Sm`ۘk6Ѷmkvᶹ6	C!ZQdJɊX+<NCiWQMb\"*5o#dv\\%ZA#g+>mc[Pvrs\rZUs/Hr%)NƓqGXU+)6\r*<7\rcp;\09Cx0C2 2a:#c8AP	c2+d\"%e_!y!m*Tڤ%Br 9jS&%hiT-%,:ɤ%@5Qb<̳^&	\\z\" 72J&Y[MkLn 3XH\rAP0HRP+I2Ø71Jw)!I43Z:/lN#鼩3'1{4,̃	DD*Jƕ,2<iTk0)=tC.kZw8j?,eƔ\"c\\\"vR} \$i))1\\TTF%&%lM!	i%\"q:Ŵ m~4l	@t&Ц)B\"Z6h2aSC ^<C6I)D&&Fx䴶\"1X+.UC0k@KFFlI<e^JRBst;pC\\3?(l%Z<D\\y!fmɝ?dI.╉.\n@\0C#5*:Oh@ k\0RTC\$@4C(C@:t>ϷC8^zRQ^Aǰ3^A[FYEZQi+腸@ʻ,-Ɋ4Rrt	P8d+f	+zwjMGS}?G\r?T00|X:8\$јr6g[	!Y.(VÓ\"*B!USbfYr_4D(CT;\0bB C*!O\$:a:\09쑁:A+Py lI>6:H\"LKur1b\$ЪKH\n8Nk8%\0+n\$رҀ\$K02W@i=jD3əވPʎCAKN@ϤOXPQ\$DjpC{AI)CCazs0hkTDm!\"0-Rd])%,~[3+.\$Ã͢VnIyC>!h00ݛpI!:PҵTRVϧCCׯ@S9_E#(9clqdKi(WJP!uY\$bN1#阒Ux8b}m!Nئ6OaGY%pLuC?R+Τ#IL}G7݊t'3>\".b2n&9Њ<^:Y2SYj8_Z{wZtuaSd@]tZGXWx(BFj8	\$H_Pi6+I=kĭ!\0WZXbT{1h8Lr%U?%rnNU<,`WVۈE-\$xN#}\"w(͒B@a8Ac\$j*i%h+So&<LiXߜS?x.Y?	I`GV,C\$~|%UYFԤ2.@";break;case"fi":$g="O6Nxa9L#P\\33`d7Άi&H\$:GNal4ep(u:&蔲`t:DHb4oABbv?Kd3\rFqt<\rL5 *Xk:+dndj0IZAa\r';e KjINw}G\r,k2h@Ʃ(våap1I݈*mMqzaMC^mv;c㞄凃PFKuҡt2£s1eţxo}Z:L9-fS\\5\rJv)jL0M5nKf(ږ390`KPR2i<\r8'\n\r+9\0ϱvԧN+D #zd:'L@4*fŠA\0,0\rr䨰jjCR\\a\\5S5A-Am6'*ݎBj&@\n_#N7Ql)қ%\n\r:BBX'9-t9L*P25S[1X1pH:0Sc&B;B(\$Ih4l\n&&-^ɁB#M-Mځ1*%vseҍ\r-0˂5e(]\\_ рa\rV HКU:\$Bh\nb8scd;UƟP\rKx3&Z@q((%v#6/4\0ڦNc()s4S2-uOTu\"tM Y/):\\/\\LEaVko=7lZm=FjN\0:S֎G!B،m.D\r4%9t@ 24xA:4C(CB8a^\\Ð]Fz\r|\r&0^d.Kf|MBI=x{ tsEqDg9Թ+BLQ%8=t{i=]|E8DhIK0ޢw(a9ATض!p\n#e/!\0ENs0oK`l4޻T>ؠKYzI#G&VMQ:#MK OHX\0iܡCP4\0Or%0PSLD.La5/X23IЃHrP`'PCqyfnED@JXۢB:H92RcҺYKi(00- \"\\c=rI)A#.仔,O (Eܘtb._v<Á\0KDd9GJq5	Fp&6[!xG{cx\r78eq8'@(k;%pAͱgdu@`G#C99\$S27VyH%PPS\n!1RO0T\n\0Ի\$oGrQ)eBIy1%˔NK^D+ih'v4TtMaDg7nՖ`AJ oںT\r۽eVCkD㪆lj)LfBT \"Bқ?6ɰ^A6bA ː3Db	aw̢`-\n8fèpaBDn3/fUf1pzV(Xii\nQAuNep.юfw^S/WL&\rS5\rCbox\rYآjf?E!A HUR9Ӏ))Q5B7^ze܆!rVz";break;case"fr":$g="E1iu9fSi7\n\0%(m8g3IeIcIiDi6Lİ22@sY2:JeS\ntLM&Ӄ PsLeCf4(iƓ<B\n LgStgMCL7j?7Y3:NxINa;OB',f&BuLK^\rfΈ9g!uzc7'z\\ήknM<303P퍏*X7P0rP2\rTBp;#D2NՎ\$;	C(2#K+\0P4&\\£8)QjC'\rhʣD2B4ˀP윲ɬIN2ɦ;'\"*\\\rBtLm\$ڮHDrp1Js#:O.ڵ>U][=u3(J\nLԍ&62o苌PƁHKd[vH jC*l\\nLCa P9+XUV\\\nv+!w6BS :M(\r&P.h0t#:PΌ2audu=H;VR:dC(ݒ#ttk\$	К&B\rCP^6x0?*b`%.AѡUL)s^0Ц55@jѵwイm,wP#+.շ_ͣR04FP Y6Tn\0A(;pmL8 i47t#5\"8@ =rI\"ʌD47xz')pA|1F߁xD{}s8MMP@kuYU\\*>cASZA=F͊SyO0:<wd9=ْ\rψ> XƩ>bOCjtrDhfU922@b'E%jQJoK;&> (|&\"gCa_LSU1nQ))裳c,%_fO廅\0uCĹ9\n\n4|2B)H͵{|b.䝏,BO\$ȶNb2,~A7Z%Dܛ1\"Ԅ\$P[2) y*)'T+\"jjed<C̬AijY29ks=ĀRd9n4WCgeu#4vF\"8|ʇѤ.\r&Q3ډf:X@'0OrlX%OID*FƔuڟr ד\$M4_CEBM(6L  d`LD%t#Iy\n)KtH`Rhѯ%,96\":X\"P08ؑS\nV5d\"hlODD'\r'LfY@m1i풲v]f,*6nFjNb\r1Z,]Fu8Xp}1 i5,af̎d30Ph8k%sf5Af3{Rbİ#'\$DCyI⃓F?<\nB168}Vv`*a(@HaCϹؚ鐣vV	\"PU;j9#cF<]'D2L0*4\n0-Q|uejʿ12W+D\$ÛfP#ZZWpE";break;case"gl":$g="E9jg:P\\33AADy@Tl2\r&a9\r1h2aBQ<A'6XkYx̒lc\nNFId1\0BM	h,@\nFC1l7AF#\n74u&e7B\rƃb7fS%6P\n\$ף]EFS'M\"cr5z;djQ0·[(p% \n#	ˇ)A`Y'7T8N6BiRhGcKz&Q\nrǓ;T*uZ\n9M=Ӓ4肎K9Ț\nX0А䎬\nkҲCIYJ欥r*40m4pꆖ{Z\\.\r/ \rR8?i:\r~!;	D\nC*(\$V60\0Q!X@1*JD7Dd`0\n%,De\"D+BM1j=#!/B:UH7()IX1S+V0\n)7 J2ҁ6cR:+pxHlz* jjQ̨11Q)\"R`,# 4؋@Ml2bÄFx]dؘd6CSУ)B@	ht)`P2hcd0UyMHpS>ʴiM<Uݛ)MJ	{p#8#`CEpY	:\0؊`: Nꪄ:l-jh&Xl-em[d0BI[\"`C4-S)ZiHxC@:tlF{\0꜊}࿏Xx!e3pݯ*5p\$NΡpAWYvisw!\0 \"*\$E|CyRJA'	DRJYl%~!eMrRa1qʓ\0@l^橇B@ZZҜXf3 s!t\r;aMl`@\"gBzt(ACzFdHSFl@)j\rQH\rbAj\\b	V*paAh4E\0Њibr5pFOP3B:8Tv%q\0006b)\$IA|t#bST#B\$3!D%,UDx>\n37E\$.\n+saZRZqIlԙ2c`O\naQ7C9:&q%m<gk)Yћ6A;!EIi=T\"P0u\$WA\0S\n!1QM	9'daP#yכ:'JSArS_&Qj!,1C\"dƲ/M]ZX1\r\\1'\\kkY!\$dC`+j1\0f%H\$\rSQA[(/HaiO|1 TՈKCa\$q{NjE/&E.FQ~\$\$/Cpn9Uv-+LX,ڔdRZ1TRzRR]m^\r%@AbW`BYKFw AM3,<U\"R02\ni4TxFV5556.	M0pr";break;case"he":$g="J5\rtU@ ak(ffP<=R\rt]SFRd~kT-t^q `z\02nI&A-yZV\r%S`(`1ƃQp9'K&cu4Q K*u\ruIЌ4 MH㖩|Bjs=5.-uF}D 3~G=`1:F9k)\\N5%(n5spr9BQt0'3(o2dp8xY\"O{J!\ryRi&J \nҔ'**- ӯHv&j\nA\n7t.|Ģ6'\\h-,Jk(;.!Rc1)!+b 9#cڥ7K1L(:p4t-m\\.\\n]-iqB1Hr}(fLקkkY0AJ2ALdУj\0!hH6Lv;ۡ<&,i HH#jH#i*G}<µ^8\"	y*XHXvBJij<@t&Ц)B{\"Z6h2UU,>9cɁ!Y\$ȁ>-TL%:6TejIZw0l['p:VĨX0x{MɭgQRD2Tz@%\$4!ah2\rHux0@2D49Ax^;vo3h^̃7|!,Y:}!3N1\n]zPz\$ʍܻ޻;˳;^۷N]6MRJRIGp٪loO{Upנr	0P:4=ǽN!\04`@1=3<ChN#49>|Cf6ԟPi@ڗ m|2&C`s@EЃ<(qOxQ\0 ,ejqjox\0pA;>߼9?G-0}`>3{b+\\gnw\r1Ƣ#=`1{,x0sR\$N%%˱&:nGZ0'ː^\\-H HQ&dr2DR2|(6L%K;Ga'.B@Nҳ9BN l.I54(\$\$8IfZ2KLG5gtFDZ*BL@Ĳ81K0*TsNk{	&3cZ5Rn\rsNbahH3)C'9!tJ_8r}Fzҡ%IFי\"Qy TM!k3`A0-jB:#W孊#FQr(śvMdm/L#RN\rɁ:m1^\\6rdx/YIRklnq1Ja(2!BSV\$2\$@EDy1z5T1%@N1޳\\tzLD*FRvBYԦI ";break;case"hu":$g="B4e7P\\33\r5	d8NF0Q8mC|e6kiL  0CT\\\n Č'LMBl4fjMRr2X)\no9D:OF\\@\nFC1l7AL5 \nLLtn1eJ7)F)\n!aOL5xLsTV\r*DAq2QǙdu'c-L 8'cI'Χ!!4Pd&nMJ6Ap<W>do6N\n\"a}c1=]\n*JUn\\t(;1(6B5x737I8Z7*9c;\"n̘RXҬL玊zd\r謫jmc#%\rTJe^D<cHα(-C\$M#*;9ʻF@ޠqXA>e\09O(Ø7ѩq90\"\r0I%%4%\nB(0HaCRBΈhȃ&aض(pHZA%#Yc#G`Ęrž\\#b-cmw	m NZjSNۣ8n6'\r%Yb3^ 25u߭>6cE#.-c8:\r%\$!8Cl-9.h\\2>퍉(3Q5x3(SKuUo7Fh1l(3Β3XC`3Bj:!@\nE㢛TP2{-\nnc!G.t@x\n@C@:t\\N8^%:Qp^|x8(0HR\rR鹲Xh;]\rC?aDEJSt7Quprݘ]rw0\r\$f'F\"`FF<RC* 6z@g.E\\앣X	Cn!4cfɀcw@sj^A%~C3C\r6ۂhӼd\0c}g\$4ɸN.\"4F@ϰfFU3혷\0P	B2uALEȁpT:rd#hmRCM\$,LcIH)1huTfiwIq\"zpCh\"A3cbaI7'vaL)b`3Y@ڿ<zc|\nF|PZ3)J9Y}9 d0\"nHy42%\\B3GaJPfAdʻ\"5P@ci2\$;\naG\$X5T&	JY9#4y1H9OL`^Q?sUݛm:\\vSR0	5И`\n悰\rZBNiS2PŲ%dsB\n3,CVЩm6&RGV];RQ؉+A1xLilIݑy7H\$U\nn_eOd{\rjnOb! \$D\"OۆxԬxi(ҊT!4s_\nΦcI84Eg9AQ&,%r/khP}If2}<m;\08S@hե;x4oq>&=fZ%UJ<[H\"]l2cuW`k\\aBw\rᬵ;XT9";break;case"id":$g="A7\"Ʉi7BQp 9A8Nig:@e9'1p(e9NRiD0I*70#d@%9L@tAP)l`1ƃQp93||+6bUt0͒Ҝf)NfS+Դo:\r@n7#Il2:c>㘺Mp*4Sq7hA]l7c''D\$H4U7zo9KHd7xNg3ȖC\$s**JH5mܽb\\Ϫˠ,R<Ҏ\0Ε\"IOA\0ArBS87 ڠ&#CԽ4r==&²g'\$3.\"HBM9\n&cN-CjrLct&C2\$3<\0S Ztxjqʎ'(֊n:\"0<ˍ#C\\:C(=lr:^&-X5]vPhYW&\rkК&Bcʹ<h6 S)+@捐ñ)727PB]\\:HM@Ƙc5l\rx΄ab9*FKB\rCn2R;.\rwd[ҋބɎރ\$1˨PVD49Ax^;r%s3^@ʂA7^0״(ŌK%d@8z[:)?Ґ8Wc+hZ&iZfnj7k2=.r	-[0܎6*#@BLS)FT䐤n`4T\no\r#6X41ǯ(#/dQ<0g.VN2JѱɊ:uh\r0L,\"q#Kt\$\n	u2֮Rt)J[	-ez<6hL2ep	>e60(1Ɣ22A{V1V:A4)W)(!) A\$_,m8 y[+\n1m:NOH@EWS)='!Hk(TLA;PL9Pi	!Ԙyk5qc3DO\naPI'&'\"*\\9B.%<IdNhk*<IB GlL\r(e	BĐBdJ`09P\0:ȕ j?LS):?E5ܥP!YR|%l2BP	kJSJ\$JJR|6ZC,; gwU3Ѝ0bL`*@Ag`̡7K ;uFuSL\\\nXH@PRUӬTtfMLUOA.Ȏ\"``(n2`oaV*7HH1LAM}ϗr\r /FWWDTϢ&;6R<+^m0:\0@s";break;case"it":$g="S4Χ#x%(a9@L&)ol2\rp\"u91qp(ab㙦I!6NsYf7Xj\0BcH 2NgC,Z0cAn8S|\\o&N&(܂ZM7\r1Ib2Ms:\$Ɠ9ZY7D	C#\"'j	 !4NzSfʠ 1c0x-TE% \n\"&V3Nw⩸#;pPCΤ&C~~Fthts;#Cbl7\r*(椩j\n4QP%\r(*\r##Cv`N::MпN\\)P2.cʍ\rҶ)J:H5\n-\n1))\nZ\\EB*NS\r\n9P\"#&p޵\$Ӭ4',0\0<MGR\n<xH/:7#4'6pЃ<P-}Z/(Zz'0Ʒk/Ԙ](@ً]IQ}xZ:(v7B@	ht)`P2hc<P7=@\r3\n69@S \"	3Ε\nL\"ތPˎc3=Ac@9cCi-'X\rӠP9/	dr:7rƖՌҪPɘ0Y6~C@&D3at\\:ʴz*cv}Cp}'p:B1@Ó3,IbPz*HOޯz:l;˳+[mpݷKȬׄJ0|\$AEoGBcླ@h<>2\$+>ʬ7ǹ>.H0ܫAρ:\r\rGDcs#)!7a'HBH\n80\\8((3A%(\r	\r&p5E8\"PDC)	ia	\$%PfSqF1`\$108{\$) L\r'pIl&F*c\$B#T=XXJ\n)\$,<bOy\"5CP! Tբa%lᚈv}DHy\"5O\naR6(@\"`IQr-\"c1HKIg aZ%\$%4lpc\0S\n!0^yj4C|4AɉӢS:L9#X\$97);PoJgG!aHQV\"Hb\$7	2 T(%h\0r`+d5Kl}MX6#AT%cr^-ReNSzK1A	͂sDLQ%\0^0y]I #0ִ#v֛\"-tSrL6/&L20\$+\rVCKYBe=6B~0TP2mL[.,!C!̌MS\rRV˝Cv=~&a";break;case"ja":$g="W'\nc/ɘ2-޼Oᙘ@SN4UƂPԑ\\}%QGqB\r[^G0e<	&0S8r&#APKY}t Q\$I+ܪÕ8B0<h5\rSR9P:aKI T\n\n>Ygn4\nT:Shi1zRxL&g`ɼ 4NQ 8'cIg2Myd05CAtt0S~9s=O\\t\\mtTBЪOsW:QP\npp@2C99##X2\rZ7\0\\28B#bB >h1\\se	^1ReLr?h1FzP B**;@1.%[,;L)K2Aɂ\0MRrZzJzK12#eRiYD#|έN(\\#R8U8NOYsI%``P9-Ap8TX9Uc(\rØ715(G,2H#`Q+DyQJsøsQD[VR%\nset]1H\"C A>r<NXa b!8s]g1G[b\"Et%E?4U%\\r]/J	g'1n]0I2\$7AҘIi:Y~My},EҔ=u10c<p6 ȪX?e4\095x3\rH2]|]P7h7!\0\\܎c06`3CXݎ\\3<PAP95ɐ\\*50t3Ut7\02w|X׌ut2A\0x0 C@:t>Xp_\nUv>px>qnG\nl\"pO 8 5ȭHXW:3 R Ḧ&\0sDH\\\"%{π4>'C};r~+w/ED\rm!W o_F9kJAiņhb|\"O2\\fxS\nS51xuZ_A3B4]2tΡ:\r\"N!\r99a0s2F#A,\0\n1FhrCAQ![(V\$		W44a\r^8Mٯ6&ڛpʾr!t3+]Pw2A8Gnn\0sD۠cppw0侃a2F1hSjt\nF-A(c5GRE`	6+4D&y2ГlhCZ,B~+\"L9EKSQLA\$J5e	qMӄ!ܡ̂k҈v`ꐔT#䘬PI&ELĜ O#Br hjt\nZ}>Iʯ\n4UT\\)4`fv];z\\5h1༄6Y*]];	h9xXB;Ajk~\rb|Vciv4pkC4IPh8Uf=A\$|AխRK\$D 	X,2hML:hNq3K\"XQ9́2XA*JI2d,#.%_|Ls!Y2r/Y#zO81Tg 9imV'0_]PuJGWK.cY8ØTlrC	Q&  ";break;case"ka":$g="A 	n\0%`	jᙘ@s@1#		(0\0T0V4]AC%PjXP\n9=A`hJs!O­AG	,I# 	itAg\0Pb2as@U\\)]'V@h]'I.%ڳ:Bă UM@TzƕduS*wyyOd(OƐNo<ht2>\\r֥;7HP<6%Imswi\\:\rP3ZH>{A:P\"9 jt>Ms<.ΚJl*-;.JAJK ZmO1Kӿ2mpvK^(.䯴O!FLڪRkjA/9+e|#w/\n❓K+!Ln=,J\0ͭu4AݥN:<Y.\nJMxݯΓ,H01\$#5),\"҂dW6z,: m:S<z;-[J*Kյ?]r5)jATUNRPq)Q}e9u)2(Ȓj}KOY! j0iR|{\\Z[d>/	QHiI?;mrץď4\$Toq4!ҁfS|`rҕ!Q\n3)-9x5r;C_80e%ۺZAau {ufP:\\2t\$Ro>.{׵4hPݧsC)W;zcʒ\\aW[PyuW5KY:]܎苌Zg~֒NX\nVpAډ^5J(4PP8ύ0# 4(*]K3Zuc[<I:䀣@r p`pa}8/@t\r0 |M7Dx*e/ m~Mv;%1bzdyQ!\0[2c])+hRZ516w8;]+Pzp	3wAJ\nAh1	D*<HV,E~9̒7b^ 7pYTX`Tu>/v;GF6	m)Ju\$y&tn9&|*V%Vb!9)c/.1NNQeՋ}{laijU Nb|6pI=Nbg ߰f*,YKrxuA%\n\n)4rֹ4S!̓JYcy5Y(NuKK6\"K=%+)Q1L\$J),f:ThC\naH#?HPhʂ\0cE7[3aA:ahۣASiU?:g)Y3UZPɧ)j'pbPJ8ٴwRRzGG%MkUko)W+\nX#,d^b~xS\nB`9O._XU;_D%\\&)XTt&S0b1G7Hњ(Μ(h3Ne[	tG+*b`r\$gU⒮!`\r:˷A+ySKR۰l:V0Ss֖-)V~3GcK+M@^\"ɴ(Z)vi(7Zr1ھ6hL-[KYs)˙AD_al\nRߗ0}\\j]0KEYQ3wZտ_3Ңߒr	!rkO\"?TK>]ne.{=qٛ=]mu*ϑM/oL4VRLa1Yטu\"w(\r_F\$\$8ٴ52U9n^\$Kgw(IJj3P,}~),򁃩vrƭgcL\r@-~=Mİ*e(̀";break;case"ko":$g="EdHڕL@؊ZhR?	E30شDc:!#t+BuӐd<LJN\$HiBvrZ2X\\,S\n%ɖ\n؞VA*zc*D0cAn8k#-^O\"\$S6u\$-ah\\%+SLAv:G\n^в(&Mؗ-V*vֲ\$O-F+NR6u-tQ}K槔'Rπlq#Ԩ9NӤ#d`'cIϟV	*[6aM P7\rcp;\09Cx䠈0C2 2a:8H8CC	2JʜBvhLdxR@\0n)0*#Leyp0.CXu<H4\r\rA\0<\nDj /q֫<uz8jrLRX,SǅQvu	\\:ňH\rBPpJR\r3K2Ø7Ԫ	U)q:A(J!a\0eLӚuYdDETjLŝu@@yE}G1h9[U/1NF&%\$1`:PP!hHY9EBbP9dP[Jb0!@vuyTYvHgY<?IXXl\$j4㥥uI͎ͫd2eXMPtu t\"\"Z6h2/Mw[r=bET6%u4{DչGaSe6AB7h7!\0Rc06`3Y1\\h3/AfK:a@[7S.j&\nG5#52:ϰ@ kQSx@!\090z\r8a^H\\0|'	}HSxD~/ 6!HI\\KQA BDo\0TblfaE#i{뽗^|ohnA?'UC\r:@He7PkCptra:d	Tr%V&c~pbC9<`HaЅ'	sNq覘BRq,8WHa\r#CqK5@\$p(*'Q.Q/l\"G:V9A\rTC4E**E!:\"\$z\$Nh;&^D/d9&lSa8:A(r]!4Pg| AI8O(UA\0C\naH#a	Ķ:QIق=+6`(F\0:Q̤XI,'\r /PSM0GQH\0PI#7T:WJ#D+OTBuD3!֝H417&&,(3^5XRc!X5^0]\\MsV4BX#rNޔT:Y )Au)*\n;D3!VZKF7m%=͉hNJX?t;1qW=Ā11-pqD+zƣ@hd9LћKӺ\0C`+5CS%Pl\\(!?\$tT*`ZA`LVP12di68܆M7(p~?\" h o3&lΧt\$F/EF.k\\BveE#1Luv6I+2<9}30%8)'U!&pulka ޘQVJ^g%skxGZfȞm`R!4dM\"0ڬ\"TJ\"6";break;case"lt":$g="T4FH%(e8NǓY@W̦á@f\rQ4k9MaŌ!^-	Nd)!BaS9lt:F 0cAn8Ui0#InP!D@l2Kg\$)L=&:\nb+ulF0jo:\r#(8Yƛ/:E@t4MHI'S9P춛hb&Nq|JPVuo^<k49`\$g,#H(,1XI3&U7spr9XC	X2k>6cF8,c@c#:Lͮ.X@0Xض#rY#z\"*ZH*Cд#RӍ()h\"<\rb	  2C+\n5Hh2l)ht2:H:RdpB\"l.(@CZʧS@7%#}\nn[K5+\"\\Fl-B8?)|7h43[\nB;%DU,Z	i{0PJ2K5%`XC,ˁA b*:T4(XqȔVP:<t\"t^1KUN4FἮv6Ip.f\"	c0xƁKr@t&Ц)B\"Z6h2^W*+̨3b2я43T3ދ%sA6\\cώc06-zD8<B\r0ڳP9) bi{;*7)(b2|*2o^3Ot#&[E%## D49Ax^;pjc\\zB;E}⿳0x!5rA)IRcbS}`D,Ìf5\$i-]t |_]K%u݇evw5\nHny\$q=觤j!l }	qMT\"XyVƝr!V*C>6e`rs/,\0lHx bR gBX9mdA\\b2ɐ!.	u\0eDH(P͚dfzAh\$.a\"c1\"-EW}_h5%Hc\r\0w`L2ه6e;l!0- qdD7\"K*]hAY\$\n1VJ-%4EDXj;E\$vv6|rsI!aj\$y.+\0CAA9\0]<>Khj\$AӗhO\naR4`cA\0SsIf'D5JP+ aTWä*CDOh}M\"wm`ZRBa3TͲ@#X#t7BmM\\#JB.E%ȉ(Wez\n\rk0h9^zWu*ƬQԮvGbV1@/@\nia=VHe	RR=r 'BT'FMN\$5鑢8SYQx\\b:ŮGw4\$HaKS\\{ĖKl\rIڀTy+EHqc-S_M %p6̅|ʾ\$͹,ROd (&d,8VzKUA\rYlyM/_MYX͝6az<ĉJ+*(W)ļ0Zd2dcDt8";break;case"ms":$g="A7\"t4BQp 9S	@n0Mb4d 3d&p(=G#is4Nn30r5h	Nd))WFSQ%h5\rQs7PcaT4 f\$RH\n*(1A7[0!i9`JXe6鱤@k2!)Bɝ/Bk4C%A4Js.g@	œoF6sBe9NyCJ|y`J#h(GuH>Tk7r\":7Nqs|[8z,c*<⌤h7)Z\"íBR| 3P7z0Z%p\n,X0PA#C>cx@J2+J(ɂĤ䌁B*v:Esz4PB[(b(zrT?0P禌0ꅌ(!-\"1RoRX!hHA! Rwj[:\nn&	\n\$Ҷ+9DR-b1\rC(A735:F_C,\r#Boh>\0Sك=h\$Bh\nb-7h.hZ2Uu^'O6C2r727(k)?2(9-	N78CϷcf!@#xrrab!]x<\$LưHx0\$j\n`3b'\\#&sYV81Aga4C(C@:t(=8^\"Ҋ+H^ڀ%^0͓9RaT#C2ڒֆacڼl6ѵmv7or}1x<hq\0 rB=0\r2p>ɄJ9OV\\4>Ƅ-!\0]3=\"0xDcg9`Gɩ~A:}Љy͕ì!p.HP߽lo`!7a@\$j\0()@lNR[*Yx@٘ \n^Aɉ pĝ~{l\0yEBC\r1rSAIOK{'!0Pi*&'fhFh<cѣ(=)%eґdb##dq':0Q dG#c|m]h#`L8 jx[{	ݛO\naQjG0u,25vs>hLI*sz6%2^\"XTQ	\"2*Bdhm!OFY8fITYu2,RbE&)LA\n1*PŰ\"B52Kdh|6[CfgFW HftȀJ14N&#@0-dIEL{vJ5Ğ&uUM@:p\nc̴)\"KQ'#+ZrMZ2Yi2CPOGF<*DZ0rYJ:#Izj(Ƞ%NWˢfdҩ=@]m10Dȵj";break;case"nl":$g="W2N)~\nfaO7Ms)j5FSn2X!o0p(a<MSle2tI&#y+Nb)̅5!Qq;9`1ƃQp9 &pQi3M`(ɤf˔Y;M`@߰\n,ঃ	Xn7s4'S,:*R	5't)<_uFĜ'5>2vt+CN6DϾG#U7~	ʘr({S	X2'@m` c9ȚOc.Nc(j*%\n2Jc2DbO[چJPʙahl8:#H\$#\"::01p@,	,' NKjܠX3; \rш6J.|*Ï>\0ұF\"b>\",Q%n6B1BH6;l:<5\"|1\r '+ètJCVim#2;@ZvbI\n)k\"P cD	v؊+7ÌԡT/,ner2KdW	Mpʛ|):B@	ht)`P2\\hZ-X.R⊣-i9`F(+\r0̏/iP4̦<1i 3`A6/C*(ҨꕅR6#x3c8c4:38@ 9:#4\0xpTAx^;rc!r3_\0:A0^0^q\nXٸ|<僂2ʋ5loD8WS8J]p	qW;۪|J|\$p1\rçENb7-Vz0DɘhzO#eRh\$\"G0T @x!F~ɷ\$JCf%gFSL(ؒԙ,h}KP/y2P \n (<eIR=pPUZ\neO4@p\n@p0`R*%L4]&ua85D!)L3`ASpIx) O[]Ĕ:SA'nl^6''*dI\$h?@AM蔚(Lo-RlM.!ԣ\0S	tr=PK&6h(PTF2TK\nYM˸5&%K#YCWr\$l'¦ރr=9G1,C5E Q	)0u0TlTadJc:Oj8ͤ\$uLGS>OA5W,OH_J^i	5l68A\"\$LT9(˄j\nN,jT*`Z{zM)+1bErqAu32\r!*Y\"+HQ>HLG24\\sk\r!<v_%\nDvzbFr7,EcP\"Oʈu#5`Lv?ZrbwPPjIL.IU\nɑa~\"+UA}C@PExF̊!g\noa#()\\cRQS(";break;case"no":$g="E9Qk5NCP\\33AADeA\"atl\\u6xA%kl9!B)̅)#I̦Zi¨q,@\nFC1l7AGCyo9Lq\n\$?6B%#)\n̳hZr&K(6nWmj4`qe>䶁\rKM7'*\\^w6^MҒa>mv>t4	j	Lw;iy`N-1B9{Sqo;!G+Da:]у!ˢgY8#ØH֍R>O6Lbͨ)2,\"8	ɀ= @CHצּL	;!N2\n86/˓69k[BC\"9C{f*h\n/#\n,0@7 4ܪ	8R3p(@0#s(Ȣs(J@P<Z2A@K>P0H^\0H)ۼ4C:6*\0\05O(	@T6O(Z8\r#1@P4#<54fAjR:(2\n%BX@t&Ц)C ^m5Rd OA Mc`Z4'cp, 5(T	 [xQ*c9è؎9k`3l0*J\rfF2R)7b<R*\rZ\r'#&Y7Fx0B|3Лt1zzjg-}x!Ra[7A#<\0Եܕ#@W:r A;^۷ٽ[4sh¨6_E!\\_E#LҪRvձ)ww!qj5cx:FRl\"1j`MaEa\"(C2e9d 4'\n/P[yq.e1fʅ<#B(M뾥H\n\0uFAE%4׺R˛c\r-wɓ';a-*\0bz*Dd6s>`F\nuH4ZgmZI)-&ІFa2l)5S\"`?Kdbd\$:'a:r%!\$*@T\rvAhOu>83b[=3%01-\0.e H3\\4P#d{N4`ngʗOItG֖0g),&OLjF8\$G7\$DLLfPFf4rx%bˡCg`.?8a3\$sy9(\"4&D%r.jnP߽:!0\nZ	!ӗF>_]a-dM;GqPMTuf[OQC*u9.?ʤY`d)7\r~B_l\0(x/8)Fѥ]SIK69\r0-c	'6JUpX+έZPO~\\+6uv/8LPe";break;case"pl":$g="C=D)eb)e7BQp 9s\r&ybob\$Gs(M0gin0!Sa`b!29)V%9	Y 4I0cAn8X1b2i<\n!GjC\r6\"'CD78k@r2юFF6ՎZB.j4 Ui'\nv7v;=SF7&A<؉rZpk'z\n*κ\0Q+5Ə&(y7r7C\r0c+D7`:#\09ȩ{<em(2ZNx! t*\n-򴇫PȠϢ*#j3< P:;=C;#\0/J9IB87#H{80\"S4H6\r/ڲ?.:1O1`>T< p4Rl&+.o/>;EnhºkY\0cUJ'> ȓ1cWurʎRPH if P=[ bpc\nR ː]ajz40;d,MPML69([zNqf!^,<8D \$	К&BBch\\-︺\n}^Mh1<*σ0̑C鰧PmEih7#ЅLT/098[!RH&<Yg쳚|ŶѴAW:[&:k쓎:qWcmp6nZHvT1Lp2n>ǍӺ|,L420z\r8a^]{3j\0F\rxD4kLxi(PCyy6XiBR4I)(4@BJC脡@(,z]콷	|Y_XeQAET\r! aSe	0\\e)_QM(BXPb)2H2|L:20Hw@\$lB!҄a&@D09cUa̥0ACfPh@AS d\$?.9(zD:\0.׺.r\"Aj%ęe\\&	\" H#.G=D.AAP-0 Fu؁@HH\rAb!8@Hry\rN\\HKM\rhd :Cj-h5&P@ikH4wĖ%gCJj%P3 S\nA7Lk !(r? \"	N۳PRqHzOA\"JARwG=A`Bᯙش\rYLJ4'^:S\r4oB1Is{zV oJLR[_\rձ&IѶ.B#P@p5t1aj)=SRLrD¤@G)J95u7ˈ P(6	DҜ;AsmѐlBERU![io\"ȂuA%ŷFM=96<7\"Гxwu`~<uMb\r5R?H)Mvq<8r\nq)\$%keJc-_r@Q|*@A6[la+Jo`ODǰw,Yl7F+DuWVygYn}(̂\0\0ª50sLj'67gwmwuHr9\$k6'@X:{%B9:L\$L<eLwA&C6UWE'XZZZԁ}A59lkbU).)5H";break;case"pt":$g="T2Dr:OF(J.0Q97js9էc)@e7&2f4SI.&	6'I2dfsXl@%9jTl 7E&Z!8h5\rQz4Fi7MZԞ	&))8&̆X\n\$py1~4נ\"^&aV#'ٞ2Hd0vfβK\$Syx`\\[\rOZxN-&gM[<7ES<n5stIܰl0)\rT:\"m<#0;\"p(.\0C#&/K\$aR`@5(L4cȚ)ҏ6Q`7\r*Cd8\$jCCjPr!/\n\nN㌯%ln1/=m̷:%D꧶PDÚ'c2\"+Is8\$\"Pӽ.t	\nIH#&G\"p;#2>! @1(HՂ-A jBl18ce`/bx304 P6#^1lxJ\"K\n@:ː7+n5h)2PFɽgW #\r_\\#:@t&Ц)C h^-9.C-MĄ\rѴd73z'IIm)k&;ޠ'@êMi.XَZV?WhaNrؤ,9h10n9N6C4;A\r8@ h ΌD49Ax^;tm@+zh^rxl#.	ݫ9<P<nUC\r))kݫ;KMq܇%rp+s\0\rӪ6\r|u|IâW65;@Nqm#rH@:G<vct;LaroM0MnmE 7h\n+\r8pЌT(m%')tBA\r|0 \rA\n \0PTI'+Ň2<	 lF5zA#lY]FWDdoO/KH;Bp	Q\"OHT&aA&O9^(x2C\naH#G2R	7݀4]kR%#@PQ8i rP,@@92zB/Ű@	jUItNI&\$\0s7ά򼆉prƴ73ʀTDiMA\0gJFF%33\$[7Q\00[y\r3u̺+e0lU0c\0`I(.96`r\$*V[m)bItStwLC_kp͆̘.`tAPC<Aҳ\nAM1G\"2[-XV,5 0ׂTp[}'Ϊ3JˤL`V-HC#`\\Hɉ1a<LgC9}.؊HFiU\$/3Za/M(PFJ4r7ˏ`O@P(MU1tJ*\\6-JkeNr(Η	ei4\"Y)b	k*Y\nE/D5t`";break;case"pt-br":$g="V7jm̧(1?	E30\n'0f\rR 8g6e6㱤rG%oihXj2LSIp6NLv>%9\$\\n 7FZ)\r9h5\rQz4Fi7M&)A9\"*RQ\$sNXHfF[\"MQ'Sfs!\r4g฽䧂fLo7TY|%7RA\\iA_fDIA\$QT*fyܕM8䜈;Kn؎v9Ȝ@35z7ȃ2k\nںR43Ґ 30\nD%\r:kCj=p3C!0J\nC,|+/╪r\00e;\nت0#>;b%sA=CSNk.*)mp\"26&\rI4ޯ˭+ʽ @1(0Vn5^ub\n\r8:@Rh&X@6 ,'QMʕJ ͫt3(\"P cġL%h7<67)RX)!ugW_;p3/z,x0H\$	К&B ^6x0o그h6<ST%3ӝF!ij_,ب7)ƅ\$c0 _/?ʋRMk{W2:7Ȩ?X<=B8@ n&ִc0z\r8a^\\0,/8^KxDs}\$l*83\\êB:j#':#*r&2`8Bpv\r.p\\\$<_#'p3͍PDH86\0uSq'\\:h[H\n|1/Ze6̛'Aw\\?R ! mÛNj\nupI%&\\q33.DN\rgȊXP	A!AAX\$#3\$	a\$Ġ37\$ٮslq8G%n\nQ?Pk\$o)Ws@ *!Ķ`BC\nxD7R8A%Ǎ}T(C(e*%Mf֐x C\$ra\$_rya\$V\n\"ĭphifCf7L#kA?S<\n<)DH=PPtv^ K:bp@&,*HE4\rS.Ȑ7ܐ:M΢e3Y7kAPp_\0S\n!1\r`@A\0F\n0*\rri\"N֜4(ӯO'T8:̇A NQOU\"=NU!R䔬*&(ls4,t#h<r^@jLP\rl*@AoIՅ\\hG_~\\ʾ;4_\090x\"IIe+cvcbV	`(c4a̅<cVURS0:dU\r)ý]\rtCzbRrb5<f%Ԏ'}uVX4Ő]J2\0PCZ]KeV3a	`R7ƣcmQf4";break;case"ro":$g="S:VBl 9LSBQp	@p:\$\"cfLL#>eL1p(/iiLI@-	Nde9%	@nh|X\nFC1l7AFsyo9B&\rن7F԰82`uZ:LFSazE2`xHx(n9̹gIf;=,foNƜ :nN,h2YYN;΁ Af2r'-K !{:<ٸ\nd& g-(0`PތP7\rcp;)'#-@2\r1À+C*9Ȟ˨ބ:/a62āJE\nℛ,JhP#JhV9#JA(0\r,+ѡ9P\"ڐ./q) #x2l1	C0LK0q6%3̎A*k*A2sNTwP!.枿\n3K(CY\n0Ήxf./XS҄%=+P\0Mkqh<\0T\\w8bhzCb.úQ1Ũ\n)Жâ(\r׀.Ҕ4\"qHB'Ȏ2),/7\n [!6ڊHB36c^J	@t&Ц)C\$N6p<ȺaC:6P Sbؔ3\r-I\$\n{qd1@:j9a>f_6caJ	,m>'i)j:/@ z;q`D49Ax^;rY#\\}@}K}ȩr19oPx΄:㳯Ќ3,\rq(k,^(AӌOV]{vn۹vnw*>	)ʧqQ)pOhk'h%iX\r/U2|,R_rD*362p'C31=Rl:1pR~(4ViҮ{4F%\rْ7^2n:=\r{)p@\n\n]qdgp\rp7F2嬇Ðt)%\rùr1YXWq&0HD;\n!\nuI\r	=aL)iEa12@	H,\$JJE(y.UkRMC^XJ>\0>^9D\$pliZ4І>r\nq!IG&qUP89DFP	L*F <p*2E89dv6f/.!GEP	.!iQRfO\$~'h/y^`Nw)O^^Ba[G1`q)89l\$fJTb]0cFejٙ(V%Yj*vMLUbd`<Iq+ngeS,e?a\rR5@Vc\rdO\0_C{YXY`\\'6шU\ntI'l9L.Ie63j\"'h@H	|xžd˰M<Rk.5VIH\"	^ZZ+BbqDv;89BCb!v-\n֯\\łRSoTܯIZ<jDֵGmb#4/;\0D2.NE{(TgB:Fdcv6zd\0t";break;case"ru":$g="I4Qb\rh-Z(KA{ᙘ@s4\$hX4mEFyAg\nQBKW2)RA@apz\0]NKWRiAy-]!&	pCE#yl\n@N'R)\0	Nd*;AEJKF\$V&'AA0@\nFC1l7c+&\"IIз>ĹK,qϴ.u9꠆L,&NsDMe!_ZG*r;i9Xpd'ˌ6ky}V\nPػN3\0\$,:)f(nB>\$e\nmz!0<=S<lP*Ei䦖;(P1WjtEk!S<9DzT\nkX]\$ٶj4y>N:D.1ܧ\r=T>+h<F.\"]-1d\nþ\\,3:Mbd5N(+2JUC%G#\nT,`#HkΖŵJLjm})TʣU%cĻ7\$qN\0P4c6\r@2׵}_\09#x9Bhˀ8N\$@#\$_̓W(mԌlq/8u\\Y(\\76@LZt:&ZNh5c%A j'!3y/%Uhɡ&7o@\ra[;r\"Z	CYkQ!~h襡㲨풩J'+E)-k:f\"\$ee_m:{ЪJy|=7P,OZ>=WwKS[Ͼf?<د3YѠ\0P(h)ި`\"j6WPoxhГG4qQPQh6^Rb&&ÖNB> ]?,+/+\\\$da9\$bø-݌>=Ka\nJbT`6jbB8py	%T`~0t3TxaaE!fa	Dz\"Adª Sf*\0%C\"BnVO.%pj][Ne	*0\$3)t1ndmD&ӳ\$@1CHn(CP]:&^P9@es@y2/\0/80Fx\"=IrPb0:Qofy+hO쯋ZT4/pQ\\qO94RWAw)b\np_1f<əs6gQ*S^lV.SsHkI[:;J#z*|I􆐢,&\$*\n%Q\\YM?Ę)EW }L~6dw(Ƣ'\"iQzx4Xu:#u_:b]c#{4YX'Jr=E:,I6`5cM[/TJjB\0Ftcb()`N#EIܩ2rNDB=2j]㶫GZ^;\nlH=+&*UH00-I`BbODDR`IR0+Tg톐nPO[PnġXg(ŞB(\";N F'FDsE5W\"N7\"U'nOSRyW?򃔠)vNІ\$Cљ9X\rA\0P	L*Q3cͤw@)VEW|,yEQM]xZ\$ش¦NpɄ+DCӐlōi4%\"539?eRQA)W5\0BfsTA@PWg]2'5973=d+KצTx)Cjmft!,yv6~9 VY#.ve9n\$]8;}m&.Fy|2ڴڢUMB\rh\n`k%wCʷGT&ہqu4sR`)2W]gX\0U\n'Ӳ.cr\\uCmE\$>Z/VϬԮ?`(J_E)	hX,T]cR'E#Q'G,qF&]%URc=uF:Lo6%9/,ONIDyby/kP*fE]BKa%ܡ##.AbmۜtxZRN7yW@)6R	\\gŴwkҝ\\I	٧וef<6:9v%Z.8`ʩ_˞(k^MCTT&Em^]Ȥ]IZIɐI	\nT\0`diERe(gi";break;case"sk":$g="N0FP%(](a@n2\rC	l7&P\rhl25rxdB\$r:\rFQ\0B18-9H0cAn8)D&sLb\nbM&}0a1g̤k02pQZ@_bԷ0 _0ɾh\rY83Nbp/ƃNbaaWwM\r+o;ICv\0!F\"<lbXjv&g0<zn59\"iH0{TףC8@ØH\0oڞ>dz=\n1H5*j+P2`2I5eKX<b6 P+P,@P)`2h:3 Pʃu%4D999\0F!j\nbC\"Z\rØ7)H&cl\"KZ9B=!\"|_BCTT(RJ *6I!\\08MBv7c\\\0ĂMeY͝dcSZ;CT4`PH ip/ПP5xޟ/6E&% sܪ+I\"Z>	M\$25=[CZDR!&6*'Ed(N86\r820y#.T(_YK\$R\$R\$Bh\nbp8`J ,Jd3J:\r0͖#\nM_^@P7/X<\":q9è\$\"50;Cj:A@;uy_OX1B;WK4:\"@5c2:Cp#'\$\\DYH7j(\" 3:xnȘ!|A<^0VD[<EwXDuuC\0ѹ)JVVOB\\92@HrD<\0@#y)<zar)\$NPn(V\"٬n5<v'!BK1\rQ	7')%Ԇ܏7AId{}5N8@ᢚ\r'T\n]de}38\0NO,021ȄS<h\0=G[ 9\0c{?sLG)Y(D:jq\$(\"\n#rm.@&Hw6wLaRR:d0F`G\"<Vz\08-ZKɋwt	\$*0-zxQk(OBɞXrfA:vLLs	\n4[k,<\$SxS\nPHRxTk'AALTu842'XtHm↶\n%4\$ଢQ	(CE0T\n7,]+%4Y[=EBYD쇓@˲\0\$pju;=Iab(aQv8웸(IJXXȢH0v;\$JBl\r5PI<gDG=B\$JB4	~TVF<c܉v`0ELVn*^@¦380azohw:\0`I~bG>Vf0&݀̓Y5+IQJHq\$(!\nJIZĆ0u:茍dQ1'%!07@DBJоr	Ji)VC'e'\"NZfb<LJ\n\nl02\$JY 	eb]qT7HmH'I_BUI\r\0xSYA";break;case"sl":$g="S:Dib#L&H%(6l7WƓ@d0\rY]0XI \r&y'̲%9JnnS鉆^ #!j6 !n7F9<lI/*LQZvccMQ3g#N\0e3Nb	Pp@sNnbf.Pl5MBz67Qfn_T9n3'Q(p]/SqwNG(.St0FC~k#?9)9ȗ`4c<Mʨ2\$R%Jp@*^;1!ֹ\r#b,0J`:B0H`&#x2!\"l;*1ѫJ26|㔽0[Tkߌ>\rq3\r1S%T9\0T\n4i3\nhԏ2tC	|2\$:!ĘHKOT\rER\rI-NSM,,A lpN\rj0'N\"4P\$2\n3=KҸ	 -6ӬiC-(\$%p]\"l[KvZnCWm׺{|C%Q7t`Wr4^lt^=%P\$	К&B@ch\\-oXih6ISH\n3'JU&3n(*\r앲7,:r9è\$lIh9\rêaLJi9	B%c4\0M-T1Ͱ8n0z\r8a^\\lP\\|K6}ҥ.x!ޛb/Y|\n|rFH(\n^&(jpyrLjr)s9\\c,̓wRH82X:uM9*\"H@SKA!4o#VBLxg\r%17P@ct ;]`\0roA%@Qj\rI5fMB RX e>xB 0ECPBIXEBZ;\0()\0e y\r!ҡ X)^٥>\0` Q}q{\r3w4' Ua0KSDFw+뮳EkVH\0\$l&Țҍ+\n2bV0XԂ\"D@ߩij!/	\$L<NPh?=\nC8ACu3D38f 1h3-:bvdlSC!蛅\0£M,5y.% e*Lx	;U\$eP6w@m\r)2 F\0`ZA쟿ʒ0r&oC6CI27OE4=BeJ_TZzTHb!ؿTF9݄)\0HS>/Ī`5I~E<L04j̿brUŀPCItͩ8/EEPoYF%	Sca\nP#pCs/a31ԅ|F0io_ Zmy!)U1+jIRŮCp#fΡ:8]	L4`Y\r1b5@\"T@sE`*ǩƉ!DQc\"`^9JY=\$&@FH)@.k*Z3@\r62\rhzjN\\kX\r*ߘpˇ.98F\r)Y'N0\"[rBJ-\$ihQA|B%c6D8\0";break;case"sr":$g="J44P-Ak	@6\rh/`P\\33`hEC\\fLJⰦe_DehRƂhQ	jQ*1a1CV9%9P	u6ccUP/ABPb2as\$_TI0.\"uZH-0ՃAcYXZ5V\$Q4Yiqc9m:MQv2\ri;MS9 :q!:\r<˵ɫxbx>DqM|];ٴRTRҔ=q0!/kV֠N)\nS)H3<Ӛƨ2EH2	׊pp@2C9(B##2\rs78Frcf2-d⚓EDN+1\"&,n kBր4 ;XM`&	pIu2Qȧsֲ>k%;+\ryHSI6!,,Rնƌ#LqNSFl\$d@0\ne3jڱn-g`v<:p4r֥J{QM?HnR\n,!\"D	zs3UD<w>)tu\"ϼ`j,˃L\$.`PH g+]:Y,\$ \"Z?o=Sz&\rx	7|*3XȤ\nNq2Y>i;mvCGeɄ6~*,eޑCRN\r6Av/jhl>ۥH+mikki)imK7\03\$	К&B`6ӏ\"Ea1FK\rܷa\098#x3\ra{6#pp1np3`@6\r<\$9#8	f6CaJQY\ryh͹B\n̰êB` GkEgD`a73Dt^@.09#Dfxe\r,P!\"! xaŭDMag\"bY{'x!ObOT%`Nr8!%&Àiw2A  PB\ndC(b!Z |Chp9aHϑd7#k8!##ptIEXȡZ/ @ły\ng08nA\0w9Ox1 8r0h{y>\$]0\r9k0Z)4\n\$Kf-/?§KB\0mw8\rM<. `@cr`e`I9CvA;Ѩ69h9wQqٓa8?(JK'h10C< m`KVEZ RM6v>]\\FEBD#/U*SJWK\$ֳ5\rH\"*COU\r	I8%\nVoB]d\r,t98SC22\r2<zdGSj\$sYMJ\n\"'3ͳ5(\n䤛@)3\\v{rbTP\nSѬ&JTy7)EX\"PѼV@L(@ 90h#JXi)DHFvP*ϳpIpjpHM.+\rtH_	ŹⲰl7O,A8odchs\r(!tMҶ7PfLk`JA*@AĂvI	&tY<SW	Go̙+S͑2W8|韕	k(ҔRWhU\"~Eb\r!<XT\\AeD2j9aIXLhDՑdRF5'V3Hs;SFaC=mr\n+)^C]Rv[ƹXn=vS._Q'B҅=A+nj\"Oj*yZn8v}SA4Pnv\"4yQ\$H_";break;case"sv":$g="BCR̧!(J.! 3԰#IeLADd0i6MQ!3Β:3ybkB BS\nhFLqAd3\rFqt7ATSI:a6&<b2&')Hd7#qu]D).hD1ˤr46\\o0\"򳄢?ԍzM\nggfuRh<#mw\r7B'[m0\n*JL[N^4kMhA\n's5Nu)ɝH'o2&60#rB\"0ʚ~R<9(A02^7*Z0nH9<<P9Bp6mv֍/8Cb*ҋ3B6'R:608܎-\"340j/+\r\"\"5*+;13&\r*#020DTɨCh;;ʩJ:\nX&H*b<5\0AQ#50cp5A bh)b!\nmC(B23F\n:#% E X`!KC5:cH5u0m\r\$P#4wMЅ,x^LO{\r7v>:@t&Ц)C,<ZV\0T\nM܌4	W6H]{FNH!@6Lo<c`}*N[&3Ű䃖D\n܍H6Yrj{	/>J-:w˨\naiP.0{;<SBɪUÖZ\\:Mxδ(x(CCD8a^(\\qr3^2\r{؅}q#x![\r=?cGfQ4\n	:iJ۰\\r5sçAt7PCY>#wjH8&1<`۽M#RI36r`ϒT#|3R@jg-}0k-(&gZQLpΕ&|xYlܿhaXih4Bb^qAĒjA\0P	@Ĥホm>2`PSK& Q)hGIgĠ@eɛ\r&	|aGRcCXRa]dȳ&(\r\rB &!e`҈ aL)hQ3MhuAK6M;-حP	Z\\96{UV-Rl&=WSa3-ꆖpΤqJ\$ P`sG\0£>C	Z 	u|粛Ϛ%1Ft\"JIّ,iUIz3D#@kXFAqD!5<n7JhJBdǘdBңIM^cvU5깍&\rV\"B<NH'ad0y&4\0%08I5MViHTjV*QTPM[h1rkɊbI\n/ęٸqSE%[0]-ܴRwc(\nsO\"tMK)8\r(-SY\"4byZT(@(\"(i)#\ruov]śh<E";break;case"ta":$g="W* iF\\Hd_+BQp 9t\\U@W(<\\@1	|@(:\r	S.WAht]R&\\I`DJ\$:TϠX`*rj1k,Յz@%95|Udߠj䦸Cf4~Lgp:E5e&@.quW[\"+@m\0,-һ[׋&a;Dxr4&)s<!:\r?8\nRl[zR.<\n8N\"0AN*Åq`	&B%0dBBʳ(BֶnK*9QāB4:Nr\$Ţ)20\n*[;\09Cx0o7:\$\n5O9PEȊRZĩ\0BnzAJ<>p4rK)TB|%(DFF\r,t]TjrD:=KW-D4:\0ȩ]_4b-,WBG \rz6O&r̤ʲpՊIG=:2F6JrZ{<CM,s|87-@Z6|YL\"#s*MB#=5Lv`S٥<2-ERTN6iJ鍵B2{iY\nZ9YkBO1ҔPaҲY%괙w)m;duuuamSJGUU(_z(r	f;O/xA jHqI]Iqz\\\rI؋TM\\JUE'R.y26*<9\\ΡZzu̯#||Ugӟqaa\\߳Fsz]%[\\`ÀMT \r@M	)0 /\r\r]ihDAH򚡽Q%!ռ@\n;gt0#0f\r 2DE#d\rc&sjl5/y\r7@Uua0C` (a\$0X|Cn!0A!mI\nb]䤜*𝊎)}[cI\ra>UFA\0A(7&x*wpf4@:;\\Qegɨ3|ӛ6\0 }6OH|^xk谱;˓Ӻv6[* \"+vt+FpٽB5ÔJ+58pyN=\0`91L˙g8\rYK7L\0>	&1P'\$f@ϕ<!\\󠥐	Ѡv色WCE͏ݩ+P4 ڥǐxgɊryq;ǘ!a>5*gl0\$P{RL3BخRE*sʍ-A@\$TQL)0ɟ{\\0x~qyI=ǧNƔ0q+eK柣L梆#(sP\n\n)iVxaV0A0ʽYk~5gV`*CM&pb{o@ա\$h4ָK\no-5[lwKq&\nQ-WTr\n/x✼U;Wadjo9G4ȞnDOzxɤ6M-h}Lr8gvtF\0TȈO4ү L8GCҫL*!LAM (3^\rj̑:<Bnᘗb#do(E^Q	Z/0TѱǆN\$>r΄/M\$p`+O؈%ݎ%=ǎ23Fqm.}m@(adr*8^#`\0[sK\"i))Gp`+ρ1AZvS~C4nx#\\*y+T*`Z̉\$qVMEg<UPyٴX:nؓ\nK\\`rANaˌ%l,~)WyF\$LGpl\"\0PMEk\n:ϰ/mp)PٮUaiGڐwro,cdAH[OrUW\nFoꪜP/V֪\0:u>lqVe7 \n4fg֔/z&H\0cB:Z[AbDʭIhx/bl8OBiRooP>Q\r84\"'dt8Blu5Pv7'~Z`|SQ@KBE";break;case"th":$g="\\! M@0tD\0 \nX:&\0*\n8\0	E30/\0ZB(^\0AK2\0&b8KGn	I?J\\)b.)\\S\"s\0CWJ_6\\+eV6rJé5k]8@%994fv2 #!j65:i\\(zʳyW ej\0MLrS{q\0ק|\\Iq	n[R|馛7;Z4	=j.Y7D	 7i6LS0x4\r/0Oڶp\0@-pBP,JQpXD1jCb2α;󤅗\$3\$\r6мJ+.6Q󄟨1`P#pάP.JV!\00@P7\ro7(9\r㒰\"@`9 >xp89i؃+¿)ä6MJԟ1lY\$O*U@,8nx\\5T(6/\n58BNH\\I1rlHÔY;r|ՌIM&3I h_QB1,nm1,;,dE;&id(UZb!NTE^m0NpL6;eCR2(9#~o,je9.ې9W}ʎsЅ+)wV\rC_XTƞ;Đ+\0Y=\nGPӃ,Ŋg(v\$#\"LCIr/A j((bw;D4`Zb`\\mldʙ[:,d0jvʫ8g\\jฺuTtij'MeSU_UxQSH\$	К&BxI(@/t^Xuߴ⒞{\\EQ=A90lJPm0eCF*Cn :pa:@xgJg)TE@JjU0Rr mG	Fdo?u%\rŎ+P&Xug	XCrn3ț\0<'`z@t9^ü?4C8/Z̤@S D/ 8*UKm(ZHSb1ѳe\rESnJMN(`Rm4\"dXh>H9+%wrv@(ef3^@>	!8(älp \nā\rsPsVʝ*E\\ A-a* ##txT7?3~\"Dhe3@(\0A\0c 4دމ:G=\r>ap]2S꬝ef*`[+2A\0P	@\nUK.\nw&zuKR:4W}?A(0	ODe)ZnE5\rbl@T7|:N;(iDSj{aPMapVr03cIF&ErUM^<0EY4XAoW\\.tci]]e&K[ouENa]-A;na7NVD.iu|VI%'@ᏊO Cu?3'\0gi1ĄS,҆?h>\"ۼetV=e\$\\cL0\nU\$|\0p!BQ.y\n¦:cKme\\UjYP|)pSbpHn8Q	3Y @}XF\n`A\$UĘ@&ܜHm!0\r[\r!S=u1鄂	{0oI7FTVYYiQM`[cK4F㭊WWCHc\ryL3G*emҰmIE@0-BadV\";i5LiRNn=ֺײ_A[\0zpA3(&Y6Fs_֜8WD7Mq͊YS>\$KN92i@]2K8Q2a Q+07@ڜSu]NJѡsō+x-hb-}WҐe?4(a9efVJk9h0Ba+Uה8G#\"fr;A^\0";break;case"tr":$g="E6M	i=BQp 9 3!i6`'y\\\nb,P!= 2̑Ho<NXbn)̅'b):GX@\nFC1l7ASv*|%4F`(a1\r	!^2Q|%O3vKsfSdkXjyat5XlF:ډix\\Fa63]7F	ӺAE= 4\\KK:L&QTk78KH0Ffe9<8SpNÙJ2\$(@:N\r\nl40@50J	/㢐SB:/Bl-P45\n6iA`ЍH `P2`H<4m @3F9tCt>32܃8#N&\r#;M\r#TXB724 4JbJB4\\'-HJ2&ԩ.H iT2\rO+K<j\n0Sԥ++,匬x#H<N꾹.:2[	x00o7\n?q):4{)B h<Ⱥ#Z3P)N\rXaj?z*|9иc:\rx͊0\00PH@7c܌,x\rÄ2'-:\"8H֋nC[Z\$~k+,9;z!b#\"ְQ*x|Id:XV90z\r8a^]tmh\\zbs4!xD={bTyx,x!#[4 :\0ؼ4=hh818t^p7{qp@BGb̳igp|/|oȎԁr47sSJb\"(fvM\nuf䎧 T986#,[1&G<КJ<6%^tI]|X. \\g\"qD'xe2a\$pCr|ԉHY\n (z `ج)8\"@yAa2>JGØރYrK	r\$gfOL?fL̐0#p*~hwMt5:NE:Oo!00j3IbJL[yy\$rRJ&bER4,WE1<bq'E)\0ITC`6*;U\\89@c{N1D.^ZYAĪ^x3@'0kHx3)T\nX*\$]\$]iD	PAGԴ)JR.JL̃H=Z0J\$^<\n7Ց@Ց80Ԅ!IA'48M0d^#)%a0]b7FeE5Meqj\0\rSaD	eA i`+EJPB\$\0U\n&\"	|u<O\roRuʨ!ltWW-l.r\\K}&{DlPAʐ\nH.'װؒYtw)Af6ܟ;nO`˙2TB\$+[ùZKNץ+m+ʔ5!Mxp\"\"2i;m>Iָ ~\\t\nԥc\0{H\0";break;case"uk":$g="I4ɠh-`&KBQp 9	rh--}[ZH`RdbrbhdZGH\rMs6@Se+ȃE6JTdJsh\$g\$Gfj>Cf4jSdRB\rhSE6\rVG!TIV{ZLʔi%QBvUXhZk7*M)4/55CBhഹ	  HT6\\htvclVYj׶ԮpNUf@;If\r:bibﾦj i%lh%.\n{;y\$CCI,#DĖ\r5X?jвH)Lxݦ(kfBK{))ƯFHm\\F \$jH!d*B郴՗.C\$.)D\nlb9kjķ\\̐ʾD\rZ\rqd隅1#D&?l&@1M1\\`hr@:,΢[\nC*(i4c6@7A\07ZVlZ(:[c74PF#M2(rLJ4\"윴GUN/\0;s?Ks3BcH(Ȃ4^&Mr}Mz4PH g8[D5e4X8[\$])_ZhFMqAmC^E\nƸP65҄ԩ\$hFD׃j+?QWI\nХVK|x\\;ڔ۷\07<_w\\͓0Tt;|HѤ9Zthov(ҘZ)xugCqVh\r嬺&]X M\$=&	c\nZ g?LO&IXnɲXG9蒋dɋ}	5k)i?,`Y%IP9\$\"`}	4gL#)x欣N\0&Wppǲ Eq	8ҝl9\\nw83\rԚMT&Q\0A43th\$2 C0=A:@/N`3\"!s^.%ն^A>PBVoHy*i	]`p2esuJS(YbT,՚Fz+^yQ-MܯԲe?PEH\$\$bMI'~R9JYN\"镲Nry[K	O7\"Pb_3@çaԩ{]Gr:Js<ҴI%lyMkSF<	V3\r\ne=ۀJ2AlAUbTʩkFr!q#F'X\\@P<fc(,঎8RkCDGM: k\0_>*	FĝJNiu\0ںehϯ\\HkuJ!겖+iFXZDD3.lh\$^5JzT)6s	XiuIJ01m77F]\"]WI&MyrvB3.n҇C\\ީYd	!	)8CzA)}0z,\$	)h9k7EjpDrq|hbq2@i=GoǆMj2&BɇTQR!D/\0P	L*4w.jdKX21T +rӷ\rp⫒u+^˭jvSAs \$J.C͉\"E	^`)\0a*̏q]4*p\"ql=\">*(7о(=mOjBVt;:̕Y[65ko}*ccN [Ieݫ&5_\0`+5bf+7w!sHhLCsW74¨TȦ:[/jQ{Lqtg8!qnF.blhb\r+[o]Fű)b!.HY0tJWEH tCԤҌD\\K;{cxs됅'^pvc?|rHшnyKl@A1:W'\n,y%oKڋUiWAƗF&^K74*;IrhxUz(<e\"O";break;case"vi":$g="Bp& *(J.0Q,Z)v@Tf\npjp*VC`]rY<#\$b\$L2@%9IΓ4˅d3\rFqt9N1QE3ڡhj[J;o\n(UbdaI¾RiD\0\0A)X8@q:g!C_#y̸6:ڋ.K;.}FͼS06\\vN5n5x!r7C	1#(͍&:;#\"\\!%:8!KH+ڜ0R7wC(\$F]]+0Ҏ9jjPeFdc@J*#ӊX\n\npEɚ44K\nd@3&!\03Z09ʤH(\";mh#Ln1\r?!\07?LwFT<x4K(T43JV %h>%*l΢mS)	RܘAT,\rRE*iX\$@70CLR1SFA bυc5%PƜ3ɆQ7,tWëUة6C\$(;+^d4pA^]3;'I)O<`UzT#YT1B>F[(m}HO1[#T+X	ht)`P<ȺhZ2P=l.́Cb#{40P3c2aC3bOjkZt9>ӎ7l.Qū5l]ACs*0\\PXip8F n9q:4@(cF3:xkۅx?AH|\nNrEl(r#at+UWlTIkx/\rwkEC{*]L6HaBLm}α)j`4!tZP#/*܉hNKV!@Hl\rÐmd0e2Cua#``oM(hѼZ ކCb.E!~ъ3F(\nzB\0	3DxKfoGh]A4ۙAC #Hwn 9ZPÚxuBI\n%0vI|mxtACaL)f_ALeeIPfiV]RANQU)5.Y%Ik@\nc&:-|NcO\r~\$ASkN;I.	\$H<#%tE\r՞vj2\nGmQ4)\"Ќ?miB!,@'03'0E9nHy0؛vqI \"ޯϸr.,bPIGt䡱WU>@]0T=S&\$L#e)&H&Nw\rr@pfSi1% 9Y>#&v%R8NC2\"~EbЕ 9&bQio~!bcRR T*`Z-B\"d#>q@ŏkvHA2i&WEf_\\\nql-틷EmZXWz͚sUsd4RpT;h`s\$D9\$Y(PX*K\rNUr.]\n{!ҕ4*듓\0ؾG:9 ";break;case"zh":$g="A*s\\r|%:\$\nr.2r/dȻ[8 S8r!T\\sI4brЀJs!J:2rST⢔\nh5\rSR9Q*-Y(eȗB+΅FZI9PYj^FX9P2s&֒E~yc~#}Krsk|i-r̀)c(Cݦ#*J!AR\nkP/WtZU9WJQ3Wq*'Os%dbʯC9Mnr;NP)Z'1T*J;)nY59XS#%Ans%O-30*\\OĹlt0]6r^-8\0J|r\nÑ)VS09),00pi+\rFkLJ[\$j?D\nLE*>	(P]Qsš ARLI SA bH8sN]\"^9zW%s]AɱEtIE1jIW)i:R9TQ5L	jy#dPA-,6B-@?G\n\$	К&Bc<p6 YUI=P:Ij-g9t_ƓPC=C&%ZFEb3:bM!^[YC\$HIz?EYcBA`Q@ۺ h7zt\$X!\090z\r8a^(\\0;\rp^2\rp:\r<^S0Vatext%NHa|#4sF1U\0ŗvNVop	q9qw!Ȏ|\$(AwaMi!rsdmX!r!G(l_WPe;ۊ:|O1Ra&#V1A5&8\$FxL N]Da2\"qe&\\4\n&\0l}0GP;xhRng \"_WQFcH	|gs~YsAq(g3Wz9dZ#\\e-i4P@ aL)`@I\$W\$;A5-+&&bpNI4RBya0xNzd!ȉ\$9=ʼ?A;!E8KQ:XUO\naQ0LEQ?+\$XLM\0K9jHVr<.\$`@qA\0P(B(	+aL(O|%̙'pP9ABc3&lK\n;GȲ7q6+x]R>6R\n#ļUJrs#&\r{&`V|H #ؿp\n.P=Öx>wBTa,J3&8FYb魂j갔,@LxZf\"P!k1;-xr:DG_בs]jxCb(P{;*Z<uiHKDH.fI˴Z-(])\nAO+aѣ*V\n+Ft0RU⫢T\0";break;case"zh-tw":$g="^%ӕ\\r|%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	%cJe R)ܫ{	Nd TP\\Õ8Cf4aS@/%NNd%гCɗBQ+B_MK,\$uowfT9WKʏW2mizX:P	*_/g*eSLKۈι^9H\r7Zz>0)ȿN\nr!U=R\n^JTO](I^ܫ]EJ4\$yhr2^?[eCr^[#k֑g1')T'9jB)#,%')n䪪hVd=Oa@IBOs¦KJ12A\$&8mQdlYr%\0JԀD&Hi1ġD)*O\nT:N09DB+ⰥyL)pY@s%^Rpr\$-1M%DMxC2R SA b8!v]!*ZsēGI~Z<^\\CD=MEi te[:tS\\Yz\\W)]%\\	jM^7e]a_*\$Bh\nb-9.h%rd;LC`92AML4rD3,rQ3`瀔KH܂t\$rM!aaA C\$_IFIM	<hNBAXNP h7srZH@4C(C@:tD;x3(x0OdAF\r|A9+\$\nDxP2cl7k^GIEGM)E\$0'7G\0}o^C³\rYۂ\"\"~JמD#Tt\n&A:Tr,ezx_@EN\"qZ)Ѝ Xv*po(4s\$!6ɝ\r	#d|[Dؘ/P8_?Z&P@@PNQE!Jyod,MPZ\"`b\n*e|Y\nqp ,PƲja^erPr@bTGK`q&	 aL)`@xku>&E&%ra\\~9j90\0\\6b(&sG(\na9`噲9Eor 	\nA=:DI\$sB:D2@'0y@E\0S.CMا1,ጛ3m=&Rd+H1-1T^Ol#@NE0	95IEVTTUEs2x_I4%T)j9VMJ	XYϡ!bp@xCfas0'j%#(uq(XJJ=T*`Z*6))#du2]QYz:ArDR¨'xVNaAǇg܊∄^Vx\"TRj\\u6VȠ%6h΁t^IM\"\0\\	k\"1t@e^*rTГ92<TPɗxe#|";break;}$Bg=array();foreach(explode("\n",lzw_decompress($g))as$X)$Bg[]=(strpos($X,"\t")?explode("\t",$X):$X);return$Bg;}if(!$Bg){$Bg=get_translations($ba);$_SESSION["translations"]=$Bg;}if(extension_loaded('pdo')){class
Min_PDO{var$_result,$server_info,$affected_rows,$errno,$error,$pdo;function
__construct(){global$b;$Re=array_search("SQL",$b->operators);if($Re!==false)unset($b->operators[$Re]);}function
dsn($Pb,$V,$E,$B=array()){try{$this->pdo=new
PDO($Pb,$V,$E,$B);}catch(Exception$ec){auth_error(h($ec->getMessage()));}$this->pdo->setAttribute(3,1);$this->pdo->setAttribute(13,array('Min_PDOStatement'));$this->server_info=@$this->pdo->getAttribute(4);}function
quote($Q){return$this->pdo->quote($Q);}function
query($F,$Kg=false){$H=$this->pdo->query($F);$this->error="";if(!$H){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($H);return$H;}function
multi_query($F){return$this->_result=$this->query($F);}function
store_result($H=null){if(!$H){$H=$this->_result;if(!$H)return
false;}if($H->columnCount()){$H->num_rows=$H->rowCount();return$H;}$this->affected_rows=$H->rowCount();return
true;}function
next_result(){if(!$this->_result)return
false;$this->_result->_offset=0;return@$this->_result->nextRowset();}function
result($F,$p=0){$H=$this->query($F);if(!$H)return
false;$J=$H->fetch();return$J[$p];}}class
Min_PDOStatement
extends
PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch(2);}function
fetch_row(){return$this->fetch(3);}function
fetch_field(){$J=(object)$this->getColumnMeta($this->_offset++);$J->orgtable=$J->table;$J->orgname=$J->name;$J->charsetnr=(in_array("blob",(array)$J->flags)?63:0);return$J;}}}$Mb=array();class
Min_SQL{var$_conn;function
__construct($h){$this->_conn=$h;}function
select($R,$L,$Z,$Mc,$_e=array(),$y=1,$C=0,$We=false){global$b,$w;$ud=(count($Mc)<count($L));$F=$b->selectQueryBuild($L,$Z,$Mc,$_e,$y,$C);if(!$F)$F="SELECT".limit(($_GET["page"]!="last"&&$y!=""&&$Mc&&$ud&&$w=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$L)."\nFROM ".table($R),($Z?"\nWHERE ".implode(" AND ",$Z):"").($Mc&&$ud?"\nGROUP BY ".implode(", ",$Mc):"").($_e?"\nORDER BY ".implode(", ",$_e):""),($y!=""?+$y:null),($C?$y*$C:0),"\n");$Wf=microtime(true);$I=$this->_conn->query($F);if($We)echo$b->selectQuery($F,$Wf,!$I);return$I;}function
delete($R,$G,$y=0){$F="FROM ".table($R);return
queries("DELETE".($y?limit1($R,$F,$G):" $F$G"));}function
update($R,$O,$G,$y=0,$M="\n"){$Zg=array();foreach($O
as$x=>$X)$Zg[]="$x = $X";$F=table($R)." SET$M".implode(",$M",$Zg);return
queries("UPDATE".($y?limit1($R,$F,$G,$M):" $F$G"));}function
insert($R,$O){return
queries("INSERT INTO ".table($R).($O?" (".implode(", ",array_keys($O)).")\nVALUES (".implode(", ",$O).")":" DEFAULT VALUES"));}function
insertUpdate($R,$K,$Ue){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($F,$qg){}function
convertSearch($t,$X,$p){return$t;}function
value($X,$p){return(method_exists($this->_conn,'value')?$this->_conn->value($X,$p):(is_resource($X)?stream_get_contents($X):$X));}function
quoteBinary($wf){return
q($wf);}function
warnings(){return'';}function
tableHelp($A){}}$Mb["sqlite"]="SQLite 3";$Mb["sqlite2"]="SQLite 2";if(isset($_GET["sqlite"])||isset($_GET["sqlite2"])){$Se=array((isset($_GET["sqlite"])?"SQLite3":"SQLite"),"PDO_SQLite");define("DRIVER",(isset($_GET["sqlite"])?"sqlite":"sqlite2"));if(class_exists(isset($_GET["sqlite"])?"SQLite3":"SQLiteDatabase")){if(isset($_GET["sqlite"])){class
Min_SQLite{var$extension="SQLite3",$server_info,$affected_rows,$errno,$error,$_link;function
__construct($tc){$this->_link=new
SQLite3($tc);$bh=$this->_link->version();$this->server_info=$bh["versionString"];}function
query($F){$H=@$this->_link->query($F);$this->error="";if(!$H){$this->errno=$this->_link->lastErrorCode();$this->error=$this->_link->lastErrorMsg();return
false;}elseif($H->numColumns())return
new
Min_Result($H);$this->affected_rows=$this->_link->changes();return
true;}function
quote($Q){return(is_utf8($Q)?"'".$this->_link->escapeString($Q)."'":"x'".reset(unpack('H*',$Q))."'");}function
store_result(){return$this->_result;}function
result($F,$p=0){$H=$this->query($F);if(!is_object($H))return
false;$J=$H->_result->fetchArray();return$J[$p];}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;}function
fetch_assoc(){return$this->_result->fetchArray(SQLITE3_ASSOC);}function
fetch_row(){return$this->_result->fetchArray(SQLITE3_NUM);}function
fetch_field(){$e=$this->_offset++;$U=$this->_result->columnType($e);return(object)array("name"=>$this->_result->columnName($e),"type"=>$U,"charsetnr"=>($U==SQLITE3_BLOB?63:0),);}function
__desctruct(){return$this->_result->finalize();}}}else{class
Min_SQLite{var$extension="SQLite",$server_info,$affected_rows,$error,$_link;function
__construct($tc){$this->server_info=sqlite_libversion();$this->_link=new
SQLiteDatabase($tc);}function
query($F,$Kg=false){$de=($Kg?"unbufferedQuery":"query");$H=@$this->_link->$de($F,SQLITE_BOTH,$o);$this->error="";if(!$H){$this->error=$o;return
false;}elseif($H===true){$this->affected_rows=$this->changes();return
true;}return
new
Min_Result($H);}function
quote($Q){return"'".sqlite_escape_string($Q)."'";}function
store_result(){return$this->_result;}function
result($F,$p=0){$H=$this->query($F);if(!is_object($H))return
false;$J=$H->_result->fetch();return$J[$p];}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;if(method_exists($H,'numRows'))$this->num_rows=$H->numRows();}function
fetch_assoc(){$J=$this->_result->fetch(SQLITE_ASSOC);if(!$J)return
false;$I=array();foreach($J
as$x=>$X)$I[($x[0]=='"'?idf_unescape($x):$x)]=$X;return$I;}function
fetch_row(){return$this->_result->fetch(SQLITE_NUM);}function
fetch_field(){$A=$this->_result->fieldName($this->_offset++);$Me='(\[.*]|"(?:[^"]|"")*"|(.+))';if(preg_match("~^($Me\\.)?$Me\$~",$A,$_)){$R=($_[3]!=""?$_[3]:idf_unescape($_[2]));$A=($_[5]!=""?$_[5]:idf_unescape($_[4]));}return(object)array("name"=>$A,"orgname"=>$A,"orgtable"=>$R,);}}}}elseif(extension_loaded("pdo_sqlite")){class
Min_SQLite
extends
Min_PDO{var$extension="PDO_SQLite";function
__construct($tc){$this->dsn(DRIVER.":$tc","","");}}}if(class_exists("Min_SQLite")){class
Min_DB
extends
Min_SQLite{function
__construct(){parent::__construct(":memory:");$this->query("PRAGMA foreign_keys = 1");}function
select_db($tc){if(is_readable($tc)&&$this->query("ATTACH ".$this->quote(preg_match("~(^[/\\\\]|:)~",$tc)?$tc:dirname($_SERVER["SCRIPT_FILENAME"])."/$tc")." AS a")){parent::__construct($tc);$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return
true;}return
false;}function
multi_query($F){return$this->_result=$this->query($F);}function
next_result(){return
false;}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($R,$K,$Ue){$Zg=array();foreach($K
as$O)$Zg[]="(".implode(", ",$O).")";return
queries("REPLACE INTO ".table($R)." (".implode(", ",array_keys(reset($K))).") VALUES\n".implode(",\n",$Zg));}function
tableHelp($A){if($A=="sqlite_sequence")return"fileformat2.html#seqtab";if($A=="sqlite_master")return"fileformat2.html#$A";}}function
idf_escape($t){return'"'.str_replace('"','""',$t).'"';}function
table($t){return
idf_escape($t);}function
connect(){global$b;list(,,$E)=$b->credentials();if($E!="")return
lang(22);return
new
Min_DB;}function
get_databases(){return
array();}function
limit($F,$Z,$y,$qe=0,$M=" "){return" $F$Z".($y!==null?$M."LIMIT $y".($qe?" OFFSET $qe":""):"");}function
limit1($R,$F,$Z,$M="\n"){global$h;return(preg_match('~^INTO~',$F)||$h->result("SELECT sqlite_compileoption_used('ENABLE_UPDATE_DELETE_LIMIT')")?limit($F,$Z,1,0,$M):" $F WHERE rowid = (SELECT rowid FROM ".table($R).$Z.$M."LIMIT 1)");}function
db_collation($m,$fb){global$h;return$h->result("PRAGMA encoding");}function
engines(){return
array();}function
logged_user(){return
get_current_user();}function
tables_list(){return
get_key_vals("SELECT name, type FROM sqlite_master WHERE type IN ('table', 'view') ORDER BY (name = 'sqlite_sequence'), name");}function
count_tables($l){return
array();}function
table_status($A=""){global$h;$I=array();foreach(get_rows("SELECT name AS Name, type AS Engine, 'rowid' AS Oid, '' AS Auto_increment FROM sqlite_master WHERE type IN ('table', 'view') ".($A!=""?"AND name = ".q($A):"ORDER BY name"))as$J){$J["Rows"]=$h->result("SELECT COUNT(*) FROM ".idf_escape($J["Name"]));$I[$J["Name"]]=$J;}foreach(get_rows("SELECT * FROM sqlite_sequence",null,"")as$J)$I[$J["name"]]["Auto_increment"]=$J["seq"];return($A!=""?$I[$A]:$I);}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){global$h;return!$h->result("SELECT sqlite_compileoption_used('OMIT_FOREIGN_KEY')");}function
fields($R){global$h;$I=array();$Ue="";foreach(get_rows("PRAGMA table_info(".table($R).")")as$J){$A=$J["name"];$U=strtolower($J["type"]);$Db=$J["dflt_value"];$I[$A]=array("field"=>$A,"type"=>(preg_match('~int~i',$U)?"integer":(preg_match('~char|clob|text~i',$U)?"text":(preg_match('~blob~i',$U)?"blob":(preg_match('~real|floa|doub~i',$U)?"real":"numeric")))),"full_type"=>$U,"default"=>(preg_match("~'(.*)'~",$Db,$_)?str_replace("''","'",$_[1]):($Db=="NULL"?null:$Db)),"null"=>!$J["notnull"],"privileges"=>array("select"=>1,"insert"=>1,"update"=>1),"primary"=>$J["pk"],);if($J["pk"]){if($Ue!="")$I[$Ue]["auto_increment"]=false;elseif(preg_match('~^integer$~i',$U))$I[$A]["auto_increment"]=true;$Ue=$A;}}$Tf=$h->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R));preg_match_all('~(("[^"]*+")+|[a-z0-9_]+)\s+text\s+COLLATE\s+(\'[^\']+\'|\S+)~i',$Tf,$Ud,PREG_SET_ORDER);foreach($Ud
as$_){$A=str_replace('""','"',preg_replace('~^"|"$~','',$_[1]));if($I[$A])$I[$A]["collation"]=trim($_[3],"'");}return$I;}function
indexes($R,$i=null){global$h;if(!is_object($i))$i=$h;$I=array();$Tf=$i->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R));if(preg_match('~\bPRIMARY\s+KEY\s*\((([^)"]+|"[^"]*"|`[^`]*`)++)~i',$Tf,$_)){$I[""]=array("type"=>"PRIMARY","columns"=>array(),"lengths"=>array(),"descs"=>array());preg_match_all('~((("[^"]*+")+|(?:`[^`]*+`)+)|(\S+))(\s+(ASC|DESC))?(,\s*|$)~i',$_[1],$Ud,PREG_SET_ORDER);foreach($Ud
as$_){$I[""]["columns"][]=idf_unescape($_[2]).$_[4];$I[""]["descs"][]=(preg_match('~DESC~i',$_[5])?'1':null);}}if(!$I){foreach(fields($R)as$A=>$p){if($p["primary"])$I[""]=array("type"=>"PRIMARY","columns"=>array($A),"lengths"=>array(),"descs"=>array(null));}}$Uf=get_key_vals("SELECT name, sql FROM sqlite_master WHERE type = 'index' AND tbl_name = ".q($R),$i);foreach(get_rows("PRAGMA index_list(".table($R).")",$i)as$J){$A=$J["name"];$u=array("type"=>($J["unique"]?"UNIQUE":"INDEX"));$u["lengths"]=array();$u["descs"]=array();foreach(get_rows("PRAGMA index_info(".idf_escape($A).")",$i)as$vf){$u["columns"][]=$vf["name"];$u["descs"][]=null;}if(preg_match('~^CREATE( UNIQUE)? INDEX '.preg_quote(idf_escape($A).' ON '.idf_escape($R),'~').' \((.*)\)$~i',$Uf[$A],$jf)){preg_match_all('/("[^"]*+")+( DESC)?/',$jf[2],$Ud);foreach($Ud[2]as$x=>$X){if($X)$u["descs"][$x]='1';}}if(!$I[""]||$u["type"]!="UNIQUE"||$u["columns"]!=$I[""]["columns"]||$u["descs"]!=$I[""]["descs"]||!preg_match("~^sqlite_~",$A))$I[$A]=$u;}return$I;}function
foreign_keys($R){$I=array();foreach(get_rows("PRAGMA foreign_key_list(".table($R).")")as$J){$Ec=&$I[$J["id"]];if(!$Ec)$Ec=$J;$Ec["source"][]=$J["from"];$Ec["target"][]=$J["to"];}return$I;}function
view($A){global$h;return
array("select"=>preg_replace('~^(?:[^`"[]+|`[^`]*`|"[^"]*")* AS\s+~iU','',$h->result("SELECT sql FROM sqlite_master WHERE name = ".q($A))));}function
collations(){return(isset($_GET["create"])?get_vals("PRAGMA collation_list",1):array());}function
information_schema($m){return
false;}function
error(){global$h;return
h($h->error);}function
check_sqlite_name($A){global$h;$lc="db|sdb|sqlite";if(!preg_match("~^[^\\0]*\\.($lc)\$~",$A)){$h->error=lang(23,str_replace("|",", ",$lc));return
false;}return
true;}function
create_database($m,$d){global$h;if(file_exists($m)){$h->error=lang(24);return
false;}if(!check_sqlite_name($m))return
false;try{$z=new
Min_SQLite($m);}catch(Exception$ec){$h->error=$ec->getMessage();return
false;}$z->query('PRAGMA encoding = "UTF-8"');$z->query('CREATE TABLE adminer (i)');$z->query('DROP TABLE adminer');return
true;}function
drop_databases($l){global$h;$h->__construct(":memory:");foreach($l
as$m){if(!@unlink($m)){$h->error=lang(24);return
false;}}return
true;}function
rename_database($A,$d){global$h;if(!check_sqlite_name($A))return
false;$h->__construct(":memory:");$h->error=lang(24);return@rename(DB,$A);}function
auto_increment(){return" PRIMARY KEY".(DRIVER=="sqlite"?" AUTOINCREMENT":"");}function
alter_table($R,$A,$q,$Bc,$jb,$Yb,$d,$Ga,$Je){global$h;$Vg=($R==""||$Bc);foreach($q
as$p){if($p[0]!=""||!$p[1]||$p[2]){$Vg=true;break;}}$c=array();$Ce=array();foreach($q
as$p){if($p[1]){$c[]=($Vg?$p[1]:"ADD ".implode($p[1]));if($p[0]!="")$Ce[$p[0]]=$p[1][0];}}if(!$Vg){foreach($c
as$X){if(!queries("ALTER TABLE ".table($R)." $X"))return
false;}if($R!=$A&&!queries("ALTER TABLE ".table($R)." RENAME TO ".table($A)))return
false;}elseif(!recreate_table($R,$A,$c,$Ce,$Bc,$Ga))return
false;if($Ga){queries("BEGIN");queries("UPDATE sqlite_sequence SET seq = $Ga WHERE name = ".q($A));if(!$h->affected_rows)queries("INSERT INTO sqlite_sequence (name, seq) VALUES (".q($A).", $Ga)");queries("COMMIT");}return
true;}function
recreate_table($R,$A,$q,$Ce,$Bc,$Ga,$v=array()){global$h;if($R!=""){if(!$q){foreach(fields($R)as$x=>$p){if($v)$p["auto_increment"]=0;$q[]=process_field($p,$p);$Ce[$x]=idf_escape($x);}}$Ve=false;foreach($q
as$p){if($p[6])$Ve=true;}$Ob=array();foreach($v
as$x=>$X){if($X[2]=="DROP"){$Ob[$X[1]]=true;unset($v[$x]);}}foreach(indexes($R)as$_d=>$u){$f=array();foreach($u["columns"]as$x=>$e){if(!$Ce[$e])continue
2;$f[]=$Ce[$e].($u["descs"][$x]?" DESC":"");}if(!$Ob[$_d]){if($u["type"]!="PRIMARY"||!$Ve)$v[]=array($u["type"],$_d,$f);}}foreach($v
as$x=>$X){if($X[0]=="PRIMARY"){unset($v[$x]);$Bc[]="  PRIMARY KEY (".implode(", ",$X[2]).")";}}foreach(foreign_keys($R)as$_d=>$Ec){foreach($Ec["source"]as$x=>$e){if(!$Ce[$e])continue
2;$Ec["source"][$x]=idf_unescape($Ce[$e]);}if(!isset($Bc[" $_d"]))$Bc[]=" ".format_foreign_key($Ec);}queries("BEGIN");}foreach($q
as$x=>$p)$q[$x]="  ".implode($p);$q=array_merge($q,array_filter($Bc));$kg=($R==$A?"adminer_$A":$A);if(!queries("CREATE TABLE ".table($kg)." (\n".implode(",\n",$q)."\n)"))return
false;if($R!=""){if($Ce&&!queries("INSERT INTO ".table($kg)." (".implode(", ",$Ce).") SELECT ".implode(", ",array_map('idf_escape',array_keys($Ce)))." FROM ".table($R)))return
false;$Hg=array();foreach(triggers($R)as$Fg=>$rg){$Eg=trigger($Fg);$Hg[]="CREATE TRIGGER ".idf_escape($Fg)." ".implode(" ",$rg)." ON ".table($A)."\n$Eg[Statement]";}$Ga=$Ga?0:$h->result("SELECT seq FROM sqlite_sequence WHERE name = ".q($R));if(!queries("DROP TABLE ".table($R))||($R==$A&&!queries("ALTER TABLE ".table($kg)." RENAME TO ".table($A)))||!alter_indexes($A,$v))return
false;if($Ga)queries("UPDATE sqlite_sequence SET seq = $Ga WHERE name = ".q($A));foreach($Hg
as$Eg){if(!queries($Eg))return
false;}queries("COMMIT");}return
true;}function
index_sql($R,$U,$A,$f){return"CREATE $U ".($U!="INDEX"?"INDEX ":"").idf_escape($A!=""?$A:uniqid($R."_"))." ON ".table($R)." $f";}function
alter_indexes($R,$c){foreach($c
as$Ue){if($Ue[0]=="PRIMARY")return
recreate_table($R,$R,array(),array(),array(),0,$c);}foreach(array_reverse($c)as$X){if(!queries($X[2]=="DROP"?"DROP INDEX ".idf_escape($X[1]):index_sql($R,$X[0],$X[1],"(".implode(", ",$X[2]).")")))return
false;}return
true;}function
truncate_tables($T){return
apply_queries("DELETE FROM",$T);}function
drop_views($dh){return
apply_queries("DROP VIEW",$dh);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
move_tables($T,$dh,$jg){return
false;}function
trigger($A){global$h;if($A=="")return
array("Statement"=>"BEGIN\n\t;\nEND");$t='(?:[^`"\s]+|`[^`]*`|"[^"]*")+';$Gg=trigger_options();preg_match("~^CREATE\\s+TRIGGER\\s*$t\\s*(".implode("|",$Gg["Timing"]).")\\s+([a-z]+)(?:\\s+OF\\s+($t))?\\s+ON\\s*$t\\s*(?:FOR\\s+EACH\\s+ROW\\s)?(.*)~is",$h->result("SELECT sql FROM sqlite_master WHERE type = 'trigger' AND name = ".q($A)),$_);$pe=$_[3];return
array("Timing"=>strtoupper($_[1]),"Event"=>strtoupper($_[2]).($pe?" OF":""),"Of"=>($pe[0]=='`'||$pe[0]=='"'?idf_unescape($pe):$pe),"Trigger"=>$A,"Statement"=>$_[4],);}function
triggers($R){$I=array();$Gg=trigger_options();foreach(get_rows("SELECT * FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R))as$J){preg_match('~^CREATE\s+TRIGGER\s*(?:[^`"\s]+|`[^`]*`|"[^"]*")+\s*('.implode("|",$Gg["Timing"]).')\s*(.*?)\s+ON\b~i',$J["sql"],$_);$I[$J["name"]]=array($_[1],$_[2]);}return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
begin(){return
queries("BEGIN");}function
last_id(){global$h;return$h->result("SELECT LAST_INSERT_ROWID()");}function
explain($h,$F){return$h->query("EXPLAIN QUERY PLAN $F");}function
found_rows($S,$Z){}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($yf){return
true;}function
create_sql($R,$Ga,$ag){global$h;$I=$h->result("SELECT sql FROM sqlite_master WHERE type IN ('table', 'view') AND name = ".q($R));foreach(indexes($R)as$A=>$u){if($A=='')continue;$I.=";\n\n".index_sql($R,$u['type'],$A,"(".implode(", ",array_map('idf_escape',$u['columns'])).")");}return$I;}function
truncate_sql($R){return"DELETE FROM ".table($R);}function
use_sql($k){}function
trigger_sql($R){return
implode(get_vals("SELECT sql || ';;\n' FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R)));}function
show_variables(){global$h;$I=array();foreach(array("auto_vacuum","cache_size","count_changes","default_cache_size","empty_result_callbacks","encoding","foreign_keys","full_column_names","fullfsync","journal_mode","journal_size_limit","legacy_file_format","locking_mode","page_size","max_page_count","read_uncommitted","recursive_triggers","reverse_unordered_selects","secure_delete","short_column_names","synchronous","temp_store","temp_store_directory","schema_version","integrity_check","quick_check")as$x)$I[$x]=$h->result("PRAGMA $x");return$I;}function
show_status(){$I=array();foreach(get_vals("PRAGMA compile_options")as$ye){list($x,$X)=explode("=",$ye,2);$I[$x]=$X;}return$I;}function
convert_field($p){}function
unconvert_field($p,$I){return$I;}function
support($pc){return
preg_match('~^(columns|database|drop_col|dump|indexes|descidx|move_col|sql|status|table|trigger|variables|view|view_trigger)$~',$pc);}$w="sqlite";$Jg=array("integer"=>0,"real"=>0,"numeric"=>0,"text"=>0,"blob"=>0);$Zf=array_keys($Jg);$Qg=array();$xe=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");$Lc=array("hex","length","lower","round","unixepoch","upper");$Pc=array("avg","count","count distinct","group_concat","max","min","sum");$Rb=array(array(),array("integer|real|numeric"=>"+/-","text"=>"||",));}$Mb["pgsql"]="PostgreSQL";if(isset($_GET["pgsql"])){$Se=array("PgSQL","PDO_PgSQL");define("DRIVER","pgsql");if(extension_loaded("pgsql")){class
Min_DB{var$extension="PgSQL",$_link,$_result,$_string,$_database=true,$server_info,$affected_rows,$error,$timeout;function
_error($bc,$o){if(ini_bool("html_errors"))$o=html_entity_decode(strip_tags($o));$o=preg_replace('~^[^:]*: ~','',$o);$this->error=$o;}function
connect($N,$V,$E){global$b;$m=$b->database();set_error_handler(array($this,'_error'));$this->_string="host='".str_replace(":","' port='",addcslashes($N,"'\\"))."' user='".addcslashes($V,"'\\")."' password='".addcslashes($E,"'\\")."'";$this->_link=@pg_connect("$this->_string dbname='".($m!=""?addcslashes($m,"'\\"):"postgres")."'",PGSQL_CONNECT_FORCE_NEW);if(!$this->_link&&$m!=""){$this->_database=false;$this->_link=@pg_connect("$this->_string dbname='postgres'",PGSQL_CONNECT_FORCE_NEW);}restore_error_handler();if($this->_link){$bh=pg_version($this->_link);$this->server_info=$bh["server"];pg_set_client_encoding($this->_link,"UTF8");}return(bool)$this->_link;}function
quote($Q){return"'".pg_escape_string($this->_link,$Q)."'";}function
value($X,$p){return($p["type"]=="bytea"?pg_unescape_bytea($X):$X);}function
quoteBinary($Q){return"'".pg_escape_bytea($this->_link,$Q)."'";}function
select_db($k){global$b;if($k==$b->database())return$this->_database;$I=@pg_connect("$this->_string dbname='".addcslashes($k,"'\\")."'",PGSQL_CONNECT_FORCE_NEW);if($I)$this->_link=$I;return$I;}function
close(){$this->_link=@pg_connect("$this->_string dbname='postgres'");}function
query($F,$Kg=false){$H=@pg_query($this->_link,$F);$this->error="";if(!$H){$this->error=pg_last_error($this->_link);$I=false;}elseif(!pg_num_fields($H)){$this->affected_rows=pg_affected_rows($H);$I=true;}else$I=new
Min_Result($H);if($this->timeout){$this->timeout=0;$this->query("RESET statement_timeout");}return$I;}function
multi_query($F){return$this->_result=$this->query($F);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($F,$p=0){$H=$this->query($F);if(!$H||!$H->num_rows)return
false;return
pg_fetch_result($H->_result,0,$p);}function
warnings(){return
h(pg_last_notice($this->_link));}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;$this->num_rows=pg_num_rows($H);}function
fetch_assoc(){return
pg_fetch_assoc($this->_result);}function
fetch_row(){return
pg_fetch_row($this->_result);}function
fetch_field(){$e=$this->_offset++;$I=new
stdClass;if(function_exists('pg_field_table'))$I->orgtable=pg_field_table($this->_result,$e);$I->name=pg_field_name($this->_result,$e);$I->orgname=$I->name;$I->type=pg_field_type($this->_result,$e);$I->charsetnr=($I->type=="bytea"?63:0);return$I;}function
__destruct(){pg_free_result($this->_result);}}}elseif(extension_loaded("pdo_pgsql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_PgSQL",$timeout;function
connect($N,$V,$E){global$b;$m=$b->database();$this->dsn("pgsql:host='".str_replace(":","' port='",addcslashes($N,"'\\"))."' client_encoding=utf8 dbname='".($m!=""?addcslashes($m,"'\\"):"postgres")."'",$V,$E);return
true;}function
select_db($k){global$b;return($b->database()==$k);}function
quoteBinary($wf){return
q($wf);}function
query($F,$Kg=false){$I=parent::query($F,$Kg);if($this->timeout){$this->timeout=0;parent::query("RESET statement_timeout");}return$I;}function
warnings(){return'';}function
close(){}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($R,$K,$Ue){global$h;foreach($K
as$O){$Rg=array();$Z=array();foreach($O
as$x=>$X){$Rg[]="$x = $X";if(isset($Ue[idf_unescape($x)]))$Z[]="$x = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$Rg)." WHERE ".implode(" AND ",$Z))&&$h->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
slowQuery($F,$qg){$this->_conn->query("SET statement_timeout = ".(1000*$qg));$this->_conn->timeout=1000*$qg;return$F;}function
convertSearch($t,$X,$p){return(preg_match('~char|text'.(!preg_match('~LIKE~',$X["op"])?'|date|time(stamp)?|boolean|uuid|'.number_type():'').'~',$p["type"])?$t:"CAST($t AS text)");}function
quoteBinary($wf){return$this->_conn->quoteBinary($wf);}function
warnings(){return$this->_conn->warnings();}function
tableHelp($A){$Md=array("information_schema"=>"infoschema","pg_catalog"=>"catalog",);$z=$Md[$_GET["ns"]];if($z)return"$z-".str_replace("_","-",$A).".html";}}function
idf_escape($t){return'"'.str_replace('"','""',$t).'"';}function
table($t){return
idf_escape($t);}function
connect(){global$b,$Jg,$Zf;$h=new
Min_DB;$j=$b->credentials();if($h->connect($j[0],$j[1],$j[2])){if(min_version(9,0,$h)){$h->query("SET application_name = 'Adminer'");if(min_version(9.2,0,$h)){$Zf[lang(25)][]="json";$Jg["json"]=4294967295;if(min_version(9.4,0,$h)){$Zf[lang(25)][]="jsonb";$Jg["jsonb"]=4294967295;}}}return$h;}return$h->error;}function
get_databases(){return
get_vals("SELECT datname FROM pg_database WHERE has_database_privilege(datname, 'CONNECT') ORDER BY datname");}function
limit($F,$Z,$y,$qe=0,$M=" "){return" $F$Z".($y!==null?$M."LIMIT $y".($qe?" OFFSET $qe":""):"");}function
limit1($R,$F,$Z,$M="\n"){return(preg_match('~^INTO~',$F)?limit($F,$Z,1,0,$M):" $F".(is_view(table_status1($R))?$Z:" WHERE ctid = (SELECT ctid FROM ".table($R).$Z.$M."LIMIT 1)"));}function
db_collation($m,$fb){global$h;return$h->result("SELECT datcollate FROM pg_database WHERE datname = ".q($m));}function
engines(){return
array();}function
logged_user(){global$h;return$h->result("SELECT user");}function
tables_list(){$F="SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = current_schema()";if(support('materializedview'))$F.="
UNION ALL
SELECT matviewname, 'MATERIALIZED VIEW'
FROM pg_matviews
WHERE schemaname = current_schema()";$F.="
ORDER BY 1";return
get_key_vals($F);}function
count_tables($l){return
array();}function
table_status($A=""){$I=array();foreach(get_rows("SELECT c.relname AS \"Name\", CASE c.relkind WHEN 'r' THEN 'table' WHEN 'm' THEN 'materialized view' ELSE 'view' END AS \"Engine\", pg_relation_size(c.oid) AS \"Data_length\", pg_total_relation_size(c.oid) - pg_relation_size(c.oid) AS \"Index_length\", obj_description(c.oid, 'pg_class') AS \"Comment\", ".(min_version(12)?"''":"CASE WHEN c.relhasoids THEN 'oid' ELSE '' END")." AS \"Oid\", c.reltuples as \"Rows\", n.nspname
FROM pg_class c
JOIN pg_namespace n ON(n.nspname = current_schema() AND n.oid = c.relnamespace)
WHERE relkind IN ('r', 'm', 'v', 'f', 'p')
".($A!=""?"AND relname = ".q($A):"ORDER BY relname"))as$J)$I[$J["Name"]]=$J;return($A!=""?$I[$A]:$I);}function
is_view($S){return
in_array($S["Engine"],array("view","materialized view"));}function
fk_support($S){return
true;}function
fields($R){$I=array();$xa=array('timestamp without time zone'=>'timestamp','timestamp with time zone'=>'timestamptz',);$cd=min_version(10)?'a.attidentity':'0';foreach(get_rows("SELECT a.attname AS field, format_type(a.atttypid, a.atttypmod) AS full_type, pg_get_expr(d.adbin, d.adrelid) AS default, a.attnotnull::int, col_description(c.oid, a.attnum) AS comment, $cd AS identity
FROM pg_class c
JOIN pg_namespace n ON c.relnamespace = n.oid
JOIN pg_attribute a ON c.oid = a.attrelid
LEFT JOIN pg_attrdef d ON c.oid = d.adrelid AND a.attnum = d.adnum
WHERE c.relname = ".q($R)."
AND n.nspname = current_schema()
AND NOT a.attisdropped
AND a.attnum > 0
ORDER BY a.attnum")as$J){preg_match('~([^([]+)(\((.*)\))?([a-z ]+)?((\[[0-9]*])*)$~',$J["full_type"],$_);list(,$U,$Jd,$J["length"],$sa,$za)=$_;$J["length"].=$za;$Wa=$U.$sa;if(isset($xa[$Wa])){$J["type"]=$xa[$Wa];$J["full_type"]=$J["type"].$Jd.$za;}else{$J["type"]=$U;$J["full_type"]=$J["type"].$Jd.$sa.$za;}if(in_array($J['identity'],array('a','d')))$J['default']='GENERATED '.($J['identity']=='d'?'BY DEFAULT':'ALWAYS').' AS IDENTITY';$J["null"]=!$J["attnotnull"];$J["auto_increment"]=$J['identity']||preg_match('~^nextval\(~i',$J["default"]);$J["privileges"]=array("insert"=>1,"select"=>1,"update"=>1);if(preg_match('~(.+)::[^)]+(.*)~',$J["default"],$_))$J["default"]=($_[1]=="NULL"?null:(($_[1][0]=="'"?idf_unescape($_[1]):$_[1]).$_[2]));$I[$J["field"]]=$J;}return$I;}function
indexes($R,$i=null){global$h;if(!is_object($i))$i=$h;$I=array();$hg=$i->result("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($R));$f=get_key_vals("SELECT attnum, attname FROM pg_attribute WHERE attrelid = $hg AND attnum > 0",$i);foreach(get_rows("SELECT relname, indisunique::int, indisprimary::int, indkey, indoption , (indpred IS NOT NULL)::int as indispartial FROM pg_index i, pg_class ci WHERE i.indrelid = $hg AND ci.oid = i.indexrelid",$i)as$J){$kf=$J["relname"];$I[$kf]["type"]=($J["indispartial"]?"INDEX":($J["indisprimary"]?"PRIMARY":($J["indisunique"]?"UNIQUE":"INDEX")));$I[$kf]["columns"]=array();foreach(explode(" ",$J["indkey"])as$kd)$I[$kf]["columns"][]=$f[$kd];$I[$kf]["descs"]=array();foreach(explode(" ",$J["indoption"])as$ld)$I[$kf]["descs"][]=($ld&1?'1':null);$I[$kf]["lengths"]=array();}return$I;}function
foreign_keys($R){global$se;$I=array();foreach(get_rows("SELECT conname, condeferrable::int AS deferrable, pg_get_constraintdef(oid) AS definition
FROM pg_constraint
WHERE conrelid = (SELECT pc.oid FROM pg_class AS pc INNER JOIN pg_namespace AS pn ON (pn.oid = pc.relnamespace) WHERE pc.relname = ".q($R)." AND pn.nspname = current_schema())
AND contype = 'f'::char
ORDER BY conkey, conname")as$J){if(preg_match('~FOREIGN KEY\s*\((.+)\)\s*REFERENCES (.+)\((.+)\)(.*)$~iA',$J['definition'],$_)){$J['source']=array_map('trim',explode(',',$_[1]));if(preg_match('~^(("([^"]|"")+"|[^"]+)\.)?"?("([^"]|"")+"|[^"]+)$~',$_[2],$Td)){$J['ns']=str_replace('""','"',preg_replace('~^"(.+)"$~','\1',$Td[2]));$J['table']=str_replace('""','"',preg_replace('~^"(.+)"$~','\1',$Td[4]));}$J['target']=array_map('trim',explode(',',$_[3]));$J['on_delete']=(preg_match("~ON DELETE ($se)~",$_[4],$Td)?$Td[1]:'NO ACTION');$J['on_update']=(preg_match("~ON UPDATE ($se)~",$_[4],$Td)?$Td[1]:'NO ACTION');$I[$J['conname']]=$J;}}return$I;}function
constraints($R){global$se;$I=array();foreach(get_rows("SELECT conname, consrc
FROM pg_catalog.pg_constraint
INNER JOIN pg_catalog.pg_namespace ON pg_constraint.connamespace = pg_namespace.oid
INNER JOIN pg_catalog.pg_class ON pg_constraint.conrelid = pg_class.oid AND pg_constraint.connamespace = pg_class.relnamespace
WHERE pg_constraint.contype = 'c'
AND conrelid != 0 -- handle only CONSTRAINTs here, not TYPES
AND nspname = current_schema()
AND relname = ".q($R)."
ORDER BY connamespace, conname")as$J)$I[$J['conname']]=$J['consrc'];return$I;}function
view($A){global$h;return
array("select"=>trim($h->result("SELECT pg_get_viewdef(".$h->result("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($A)).")")));}function
collations(){return
array();}function
information_schema($m){return($m=="information_schema");}function
error(){global$h;$I=h($h->error);if(preg_match('~^(.*\n)?([^\n]*)\n( *)\^(\n.*)?$~s',$I,$_))$I=$_[1].preg_replace('~((?:[^&]|&[^;]*;){'.strlen($_[3]).'})(.*)~','\1<b>\2</b>',$_[2]).$_[4];return
nl_br($I);}function
create_database($m,$d){return
queries("CREATE DATABASE ".idf_escape($m).($d?" ENCODING ".idf_escape($d):""));}function
drop_databases($l){global$h;$h->close();return
apply_queries("DROP DATABASE",$l,'idf_escape');}function
rename_database($A,$d){return
queries("ALTER DATABASE ".idf_escape(DB)." RENAME TO ".idf_escape($A));}function
auto_increment(){return(min_version(11)?" PRIMARY KEY":"");}function
alter_table($R,$A,$q,$Bc,$jb,$Yb,$d,$Ga,$Je){$c=array();$cf=array();if($R!=""&&$R!=$A)$cf[]="ALTER TABLE ".table($R)." RENAME TO ".table($A);foreach($q
as$p){$e=idf_escape($p[0]);$X=$p[1];if(!$X)$c[]="DROP $e";else{$Yg=$X[5];unset($X[5]);if(isset($X[6])&&$p[0]=="")$X[1]=($X[1]==" bigint"?" big":($X[1]==" smallint"?" small":" "))."serial";if($p[0]=="")$c[]=($R!=""?"ADD ":"  ").implode($X);else{if($e!=$X[0])$cf[]="ALTER TABLE ".table($A)." RENAME $e TO $X[0]";$c[]="ALTER $e TYPE$X[1]";if(!$X[6]){$c[]="ALTER $e ".($X[3]?"SET$X[3]":"DROP DEFAULT");$c[]="ALTER $e ".($X[2]==" NULL"?"DROP NOT":"SET").$X[2];}}if($p[0]!=""||$Yg!="")$cf[]="COMMENT ON COLUMN ".table($A).".$X[0] IS ".($Yg!=""?substr($Yg,9):"''");}}$c=array_merge($c,$Bc);if($R=="")array_unshift($cf,"CREATE TABLE ".table($A)." (\n".implode(",\n",$c)."\n)");elseif($c)array_unshift($cf,"ALTER TABLE ".table($R)."\n".implode(",\n",$c));if($R!=""||$jb!="")$cf[]="COMMENT ON TABLE ".table($A)." IS ".q($jb);if($Ga!=""){}foreach($cf
as$F){if(!queries($F))return
false;}return
true;}function
alter_indexes($R,$c){$vb=array();$Nb=array();$cf=array();foreach($c
as$X){if($X[0]!="INDEX")$vb[]=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");elseif($X[2]=="DROP")$Nb[]=idf_escape($X[1]);else$cf[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R)." (".implode(", ",$X[2]).")";}if($vb)array_unshift($cf,"ALTER TABLE ".table($R).implode(",",$vb));if($Nb)array_unshift($cf,"DROP INDEX ".implode(", ",$Nb));foreach($cf
as$F){if(!queries($F))return
false;}return
true;}function
truncate_tables($T){return
queries("TRUNCATE ".implode(", ",array_map('table',$T)));return
true;}function
drop_views($dh){return
drop_tables($dh);}function
drop_tables($T){foreach($T
as$R){$P=table_status($R);if(!queries("DROP ".strtoupper($P["Engine"])." ".table($R)))return
false;}return
true;}function
move_tables($T,$dh,$jg){foreach(array_merge($T,$dh)as$R){$P=table_status($R);if(!queries("ALTER ".strtoupper($P["Engine"])." ".table($R)." SET SCHEMA ".idf_escape($jg)))return
false;}return
true;}function
trigger($A,$R=null){if($A=="")return
array("Statement"=>"EXECUTE PROCEDURE ()");if($R===null)$R=$_GET['trigger'];$K=get_rows('SELECT t.trigger_name AS "Trigger", t.action_timing AS "Timing", (SELECT STRING_AGG(event_manipulation, \' OR \') FROM information_schema.triggers WHERE event_object_table = t.event_object_table AND trigger_name = t.trigger_name ) AS "Events", t.event_manipulation AS "Event", \'FOR EACH \' || t.action_orientation AS "Type", t.action_statement AS "Statement" FROM information_schema.triggers t WHERE t.event_object_table = '.q($R).' AND t.trigger_name = '.q($A));return
reset($K);}function
triggers($R){$I=array();foreach(get_rows("SELECT * FROM information_schema.triggers WHERE event_object_table = ".q($R))as$J)$I[$J["trigger_name"]]=array($J["action_timing"],$J["event_manipulation"]);return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW","FOR EACH STATEMENT"),);}function
routine($A,$U){$K=get_rows('SELECT routine_definition AS definition, LOWER(external_language) AS language, *
FROM information_schema.routines
WHERE routine_schema = current_schema() AND specific_name = '.q($A));$I=$K[0];$I["returns"]=array("type"=>$I["type_udt_name"]);$I["fields"]=get_rows('SELECT parameter_name AS field, data_type AS type, character_maximum_length AS length, parameter_mode AS inout
FROM information_schema.parameters
WHERE specific_schema = current_schema() AND specific_name = '.q($A).'
ORDER BY ordinal_position');return$I;}function
routines(){return
get_rows('SELECT specific_name AS "SPECIFIC_NAME", routine_type AS "ROUTINE_TYPE", routine_name AS "ROUTINE_NAME", type_udt_name AS "DTD_IDENTIFIER"
FROM information_schema.routines
WHERE routine_schema = current_schema()
ORDER BY SPECIFIC_NAME');}function
routine_languages(){return
get_vals("SELECT LOWER(lanname) FROM pg_catalog.pg_language");}function
routine_id($A,$J){$I=array();foreach($J["fields"]as$p)$I[]=$p["type"];return
idf_escape($A)."(".implode(", ",$I).")";}function
last_id(){return
0;}function
explain($h,$F){return$h->query("EXPLAIN $F");}function
found_rows($S,$Z){global$h;if(preg_match("~ rows=([0-9]+)~",$h->result("EXPLAIN SELECT * FROM ".idf_escape($S["Name"]).($Z?" WHERE ".implode(" AND ",$Z):"")),$jf))return$jf[1];return
false;}function
types(){return
get_vals("SELECT typname
FROM pg_type
WHERE typnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema())
AND typtype IN ('b','d','e')
AND typelem = 0");}function
schemas(){return
get_vals("SELECT nspname FROM pg_namespace ORDER BY nspname");}function
get_schema(){global$h;return$h->result("SELECT current_schema()");}function
set_schema($xf,$i=null){global$h,$Jg,$Zf;if(!$i)$i=$h;$I=$i->query("SET search_path TO ".idf_escape($xf));foreach(types()as$U){if(!isset($Jg[$U])){$Jg[$U]=0;$Zf[lang(26)][]=$U;}}return$I;}function
foreign_keys_sql($R){$I="";$P=table_status($R);$zc=foreign_keys($R);ksort($zc);foreach($zc
as$yc=>$xc)$I.="ALTER TABLE ONLY ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." ADD CONSTRAINT ".idf_escape($yc)." $xc[definition] ".($xc['deferrable']?'DEFERRABLE':'NOT DEFERRABLE').";\n";return($I?"$I\n":$I);}function
create_sql($R,$Ga,$ag){global$h;$I='';$tf=array();$Gf=array();$P=table_status($R);if(is_view($P)){$ch=view($R);return
rtrim("CREATE VIEW ".idf_escape($R)." AS $ch[select]",";");}$q=fields($R);$v=indexes($R);ksort($v);$rb=constraints($R);if(!$P||empty($q))return
false;$I="CREATE TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." (\n    ";foreach($q
as$qc=>$p){$Ie=idf_escape($p['field']).' '.$p['full_type'].default_value($p).($p['attnotnull']?" NOT NULL":"");$tf[]=$Ie;if(preg_match('~nextval\(\'([^\']+)\'\)~',$p['default'],$Ud)){$Ff=$Ud[1];$Sf=reset(get_rows(min_version(10)?"SELECT *, cache_size AS cache_value FROM pg_sequences WHERE schemaname = current_schema() AND sequencename = ".q($Ff):"SELECT * FROM $Ff"));$Gf[]=($ag=="DROP+CREATE"?"DROP SEQUENCE IF EXISTS $Ff;\n":"")."CREATE SEQUENCE $Ff INCREMENT $Sf[increment_by] MINVALUE $Sf[min_value] MAXVALUE $Sf[max_value] START ".($Ga?$Sf['last_value']:1)." CACHE $Sf[cache_value];";}}if(!empty($Gf))$I=implode("\n\n",$Gf)."\n\n$I";foreach($v
as$fd=>$u){switch($u['type']){case'UNIQUE':$tf[]="CONSTRAINT ".idf_escape($fd)." UNIQUE (".implode(', ',array_map('idf_escape',$u['columns'])).")";break;case'PRIMARY':$tf[]="CONSTRAINT ".idf_escape($fd)." PRIMARY KEY (".implode(', ',array_map('idf_escape',$u['columns'])).")";break;}}foreach($rb
as$nb=>$pb)$tf[]="CONSTRAINT ".idf_escape($nb)." CHECK $pb";$I.=implode(",\n    ",$tf)."\n) WITH (oids = ".($P['Oid']?'true':'false').");";foreach($v
as$fd=>$u){if($u['type']=='INDEX'){$f=array();foreach($u['columns']as$x=>$X)$f[]=idf_escape($X).($u['descs'][$x]?" DESC":"");$I.="\n\nCREATE INDEX ".idf_escape($fd)." ON ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." USING btree (".implode(', ',$f).");";}}if($P['Comment'])$I.="\n\nCOMMENT ON TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." IS ".q($P['Comment']).";";foreach($q
as$qc=>$p){if($p['comment'])$I.="\n\nCOMMENT ON COLUMN ".idf_escape($P['nspname']).".".idf_escape($P['Name']).".".idf_escape($qc)." IS ".q($p['comment']).";";}return
rtrim($I,';');}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
trigger_sql($R){$P=table_status($R);$I="";foreach(triggers($R)as$Dg=>$Cg){$Eg=trigger($Dg,$P['Name']);$I.="\nCREATE TRIGGER ".idf_escape($Eg['Trigger'])." $Eg[Timing] $Eg[Events] ON ".idf_escape($P["nspname"]).".".idf_escape($P['Name'])." $Eg[Type] $Eg[Statement];;\n";}return$I;}function
use_sql($k){return"\connect ".idf_escape($k);}function
show_variables(){return
get_key_vals("SHOW ALL");}function
process_list(){return
get_rows("SELECT * FROM pg_stat_activity ORDER BY ".(min_version(9.2)?"pid":"procpid"));}function
show_status(){}function
convert_field($p){}function
unconvert_field($p,$I){return$I;}function
support($pc){return
preg_match('~^(database|table|columns|sql|indexes|descidx|comment|view|'.(min_version(9.3)?'materializedview|':'').'scheme|routine|processlist|sequence|trigger|type|variables|drop_col|kill|dump)$~',$pc);}function
kill_process($X){return
queries("SELECT pg_terminate_backend(".number($X).")");}function
connection_id(){return"SELECT pg_backend_pid()";}function
max_connections(){global$h;return$h->result("SHOW max_connections");}$w="pgsql";$Jg=array();$Zf=array();foreach(array(lang(27)=>array("smallint"=>5,"integer"=>10,"bigint"=>19,"boolean"=>1,"numeric"=>0,"real"=>7,"double precision"=>16,"money"=>20),lang(28)=>array("date"=>13,"time"=>17,"timestamp"=>20,"timestamptz"=>21,"interval"=>0),lang(25)=>array("character"=>0,"character varying"=>0,"text"=>0,"tsquery"=>0,"tsvector"=>0,"uuid"=>0,"xml"=>0),lang(29)=>array("bit"=>0,"bit varying"=>0,"bytea"=>0),lang(30)=>array("cidr"=>43,"inet"=>43,"macaddr"=>17,"txid_snapshot"=>0),lang(31)=>array("box"=>0,"circle"=>0,"line"=>0,"lseg"=>0,"path"=>0,"point"=>0,"polygon"=>0),)as$x=>$X){$Jg+=$X;$Zf[$x]=array_keys($X);}$Qg=array();$xe=array("=","<",">","<=",">=","!=","~","!~","LIKE","LIKE %%","ILIKE","ILIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL");$Lc=array("char_length","lower","round","to_hex","to_timestamp","upper");$Pc=array("avg","count","count distinct","max","min","sum");$Rb=array(array("char"=>"md5","date|time"=>"now",),array(number_type()=>"+/-","date|time"=>"+ interval/- interval","char|text"=>"||",));}$Mb["oracle"]="Oracle (beta)";if(isset($_GET["oracle"])){$Se=array("OCI8","PDO_OCI");define("DRIVER","oracle");if(extension_loaded("oci8")){class
Min_DB{var$extension="oci8",$_link,$_result,$server_info,$affected_rows,$errno,$error;function
_error($bc,$o){if(ini_bool("html_errors"))$o=html_entity_decode(strip_tags($o));$o=preg_replace('~^[^:]*: ~','',$o);$this->error=$o;}function
connect($N,$V,$E){$this->_link=@oci_new_connect($V,$E,$N,"AL32UTF8");if($this->_link){$this->server_info=oci_server_version($this->_link);return
true;}$o=oci_error();$this->error=$o["message"];return
false;}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($k){return
true;}function
query($F,$Kg=false){$H=oci_parse($this->_link,$F);$this->error="";if(!$H){$o=oci_error($this->_link);$this->errno=$o["code"];$this->error=$o["message"];return
false;}set_error_handler(array($this,'_error'));$I=@oci_execute($H);restore_error_handler();if($I){if(oci_num_fields($H))return
new
Min_Result($H);$this->affected_rows=oci_num_rows($H);}return$I;}function
multi_query($F){return$this->_result=$this->query($F);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($F,$p=1){$H=$this->query($F);if(!is_object($H)||!oci_fetch($H->_result))return
false;return
oci_result($H->_result,$p);}}class
Min_Result{var$_result,$_offset=1,$num_rows;function
__construct($H){$this->_result=$H;}function
_convert($J){foreach((array)$J
as$x=>$X){if(is_a($X,'OCI-Lob'))$J[$x]=$X->load();}return$J;}function
fetch_assoc(){return$this->_convert(oci_fetch_assoc($this->_result));}function
fetch_row(){return$this->_convert(oci_fetch_row($this->_result));}function
fetch_field(){$e=$this->_offset++;$I=new
stdClass;$I->name=oci_field_name($this->_result,$e);$I->orgname=$I->name;$I->type=oci_field_type($this->_result,$e);$I->charsetnr=(preg_match("~raw|blob|bfile~",$I->type)?63:0);return$I;}function
__destruct(){oci_free_statement($this->_result);}}}elseif(extension_loaded("pdo_oci")){class
Min_DB
extends
Min_PDO{var$extension="PDO_OCI";function
connect($N,$V,$E){$this->dsn("oci:dbname=//$N;charset=AL32UTF8",$V,$E);return
true;}function
select_db($k){return
true;}}}class
Min_Driver
extends
Min_SQL{function
begin(){return
true;}}function
idf_escape($t){return'"'.str_replace('"','""',$t).'"';}function
table($t){return
idf_escape($t);}function
connect(){global$b;$h=new
Min_DB;$j=$b->credentials();if($h->connect($j[0],$j[1],$j[2]))return$h;return$h->error;}function
get_databases(){return
get_vals("SELECT tablespace_name FROM user_tablespaces");}function
limit($F,$Z,$y,$qe=0,$M=" "){return($qe?" * FROM (SELECT t.*, rownum AS rnum FROM (SELECT $F$Z) t WHERE rownum <= ".($y+$qe).") WHERE rnum > $qe":($y!==null?" * FROM (SELECT $F$Z) WHERE rownum <= ".($y+$qe):" $F$Z"));}function
limit1($R,$F,$Z,$M="\n"){return" $F$Z";}function
db_collation($m,$fb){global$h;return$h->result("SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'");}function
engines(){return
array();}function
logged_user(){global$h;return$h->result("SELECT USER FROM DUAL");}function
tables_list(){return
get_key_vals("SELECT table_name, 'table' FROM all_tables WHERE tablespace_name = ".q(DB)."
UNION SELECT view_name, 'view' FROM user_views
ORDER BY 1");}function
count_tables($l){return
array();}function
table_status($A=""){$I=array();$zf=q($A);foreach(get_rows('SELECT table_name "Name", \'table\' "Engine", avg_row_len * num_rows "Data_length", num_rows "Rows" FROM all_tables WHERE tablespace_name = '.q(DB).($A!=""?" AND table_name = $zf":"")."
UNION SELECT view_name, 'view', 0, 0 FROM user_views".($A!=""?" WHERE view_name = $zf":"")."
ORDER BY 1")as$J){if($A!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return
true;}function
fields($R){$I=array();foreach(get_rows("SELECT * FROM all_tab_columns WHERE table_name = ".q($R)." ORDER BY column_id")as$J){$U=$J["DATA_TYPE"];$Jd="$J[DATA_PRECISION],$J[DATA_SCALE]";if($Jd==",")$Jd=$J["DATA_LENGTH"];$I[$J["COLUMN_NAME"]]=array("field"=>$J["COLUMN_NAME"],"full_type"=>$U.($Jd?"($Jd)":""),"type"=>strtolower($U),"length"=>$Jd,"default"=>$J["DATA_DEFAULT"],"null"=>($J["NULLABLE"]=="Y"),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),);}return$I;}function
indexes($R,$i=null){$I=array();foreach(get_rows("SELECT uic.*, uc.constraint_type
FROM user_ind_columns uic
LEFT JOIN user_constraints uc ON uic.index_name = uc.constraint_name AND uic.table_name = uc.table_name
WHERE uic.table_name = ".q($R)."
ORDER BY uc.constraint_type, uic.column_position",$i)as$J){$fd=$J["INDEX_NAME"];$I[$fd]["type"]=($J["CONSTRAINT_TYPE"]=="P"?"PRIMARY":($J["CONSTRAINT_TYPE"]=="U"?"UNIQUE":"INDEX"));$I[$fd]["columns"][]=$J["COLUMN_NAME"];$I[$fd]["lengths"][]=($J["CHAR_LENGTH"]&&$J["CHAR_LENGTH"]!=$J["COLUMN_LENGTH"]?$J["CHAR_LENGTH"]:null);$I[$fd]["descs"][]=($J["DESCEND"]?'1':null);}return$I;}function
view($A){$K=get_rows('SELECT text "select" FROM user_views WHERE view_name = '.q($A));return
reset($K);}function
collations(){return
array();}function
information_schema($m){return
false;}function
error(){global$h;return
h($h->error);}function
explain($h,$F){$h->query("EXPLAIN PLAN FOR $F");return$h->query("SELECT * FROM plan_table");}function
found_rows($S,$Z){}function
alter_table($R,$A,$q,$Bc,$jb,$Yb,$d,$Ga,$Je){$c=$Nb=array();foreach($q
as$p){$X=$p[1];if($X&&$p[0]!=""&&idf_escape($p[0])!=$X[0])queries("ALTER TABLE ".table($R)." RENAME COLUMN ".idf_escape($p[0])." TO $X[0]");if($X)$c[]=($R!=""?($p[0]!=""?"MODIFY (":"ADD ("):"  ").implode($X).($R!=""?")":"");else$Nb[]=idf_escape($p[0]);}if($R=="")return
queries("CREATE TABLE ".table($A)." (\n".implode(",\n",$c)."\n)");return(!$c||queries("ALTER TABLE ".table($R)."\n".implode("\n",$c)))&&(!$Nb||queries("ALTER TABLE ".table($R)." DROP (".implode(", ",$Nb).")"))&&($R==$A||queries("ALTER TABLE ".table($R)." RENAME TO ".table($A)));}function
foreign_keys($R){$I=array();$F="SELECT c_list.CONSTRAINT_NAME as NAME,
c_src.COLUMN_NAME as SRC_COLUMN,
c_dest.OWNER as DEST_DB,
c_dest.TABLE_NAME as DEST_TABLE,
c_dest.COLUMN_NAME as DEST_COLUMN,
c_list.DELETE_RULE as ON_DELETE
FROM ALL_CONSTRAINTS c_list, ALL_CONS_COLUMNS c_src, ALL_CONS_COLUMNS c_dest
WHERE c_list.CONSTRAINT_NAME = c_src.CONSTRAINT_NAME
AND c_list.R_CONSTRAINT_NAME = c_dest.CONSTRAINT_NAME
AND c_list.CONSTRAINT_TYPE = 'R'
AND c_src.TABLE_NAME = ".q($R);foreach(get_rows($F)as$J)$I[$J['NAME']]=array("db"=>$J['DEST_DB'],"table"=>$J['DEST_TABLE'],"source"=>array($J['SRC_COLUMN']),"target"=>array($J['DEST_COLUMN']),"on_delete"=>$J['ON_DELETE'],"on_update"=>null,);return$I;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($dh){return
apply_queries("DROP VIEW",$dh);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
last_id(){return
0;}function
schemas(){return
get_vals("SELECT DISTINCT owner FROM dba_segments WHERE owner IN (SELECT username FROM dba_users WHERE default_tablespace NOT IN ('SYSTEM','SYSAUX'))");}function
get_schema(){global$h;return$h->result("SELECT sys_context('USERENV', 'SESSION_USER') FROM dual");}function
set_schema($yf,$i=null){global$h;if(!$i)$i=$h;return$i->query("ALTER SESSION SET CURRENT_SCHEMA = ".idf_escape($yf));}function
show_variables(){return
get_key_vals('SELECT name, display_value FROM v$parameter');}function
process_list(){return
get_rows('SELECT sess.process AS "process", sess.username AS "user", sess.schemaname AS "schema", sess.status AS "status", sess.wait_class AS "wait_class", sess.seconds_in_wait AS "seconds_in_wait", sql.sql_text AS "sql_text", sess.machine AS "machine", sess.port AS "port"
FROM v$session sess LEFT OUTER JOIN v$sql sql
ON sql.sql_id = sess.sql_id
WHERE sess.type = \'USER\'
ORDER BY PROCESS
');}function
show_status(){$K=get_rows('SELECT * FROM v$instance');return
reset($K);}function
convert_field($p){}function
unconvert_field($p,$I){return$I;}function
support($pc){return
preg_match('~^(columns|database|drop_col|indexes|descidx|processlist|scheme|sql|status|table|variables|view|view_trigger)$~',$pc);}$w="oracle";$Jg=array();$Zf=array();foreach(array(lang(27)=>array("number"=>38,"binary_float"=>12,"binary_double"=>21),lang(28)=>array("date"=>10,"timestamp"=>29,"interval year"=>12,"interval day"=>28),lang(25)=>array("char"=>2000,"varchar2"=>4000,"nchar"=>2000,"nvarchar2"=>4000,"clob"=>4294967295,"nclob"=>4294967295),lang(29)=>array("raw"=>2000,"long raw"=>2147483648,"blob"=>4294967295,"bfile"=>4294967296),)as$x=>$X){$Jg+=$X;$Zf[$x]=array_keys($X);}$Qg=array();$xe=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");$Lc=array("length","lower","round","upper");$Pc=array("avg","count","count distinct","max","min","sum");$Rb=array(array("date"=>"current_date","timestamp"=>"current_timestamp",),array("number|float|double"=>"+/-","date|timestamp"=>"+ interval/- interval","char|clob"=>"||",));}$Mb["mssql"]="MS SQL (beta)";if(isset($_GET["mssql"])){$Se=array("SQLSRV","MSSQL","PDO_DBLIB");define("DRIVER","mssql");if(extension_loaded("sqlsrv")){class
Min_DB{var$extension="sqlsrv",$_link,$_result,$server_info,$affected_rows,$errno,$error;function
_get_error(){$this->error="";foreach(sqlsrv_errors()as$o){$this->errno=$o["code"];$this->error.="$o[message]\n";}$this->error=rtrim($this->error);}function
connect($N,$V,$E){global$b;$m=$b->database();$ob=array("UID"=>$V,"PWD"=>$E,"CharacterSet"=>"UTF-8");if($m!="")$ob["Database"]=$m;$this->_link=@sqlsrv_connect(preg_replace('~:~',',',$N),$ob);if($this->_link){$md=sqlsrv_server_info($this->_link);$this->server_info=$md['SQLServerVersion'];}else$this->_get_error();return(bool)$this->_link;}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($k){return$this->query("USE ".idf_escape($k));}function
query($F,$Kg=false){$H=sqlsrv_query($this->_link,$F);$this->error="";if(!$H){$this->_get_error();return
false;}return$this->store_result($H);}function
multi_query($F){$this->_result=sqlsrv_query($this->_link,$F);$this->error="";if(!$this->_result){$this->_get_error();return
false;}return
true;}function
store_result($H=null){if(!$H)$H=$this->_result;if(!$H)return
false;if(sqlsrv_field_metadata($H))return
new
Min_Result($H);$this->affected_rows=sqlsrv_rows_affected($H);return
true;}function
next_result(){return$this->_result?sqlsrv_next_result($this->_result):null;}function
result($F,$p=0){$H=$this->query($F);if(!is_object($H))return
false;$J=$H->fetch_row();return$J[$p];}}class
Min_Result{var$_result,$_offset=0,$_fields,$num_rows;function
__construct($H){$this->_result=$H;}function
_convert($J){foreach((array)$J
as$x=>$X){if(is_a($X,'DateTime'))$J[$x]=$X->format("Y-m-d H:i:s");}return$J;}function
fetch_assoc(){return$this->_convert(sqlsrv_fetch_array($this->_result,SQLSRV_FETCH_ASSOC));}function
fetch_row(){return$this->_convert(sqlsrv_fetch_array($this->_result,SQLSRV_FETCH_NUMERIC));}function
fetch_field(){if(!$this->_fields)$this->_fields=sqlsrv_field_metadata($this->_result);$p=$this->_fields[$this->_offset++];$I=new
stdClass;$I->name=$p["Name"];$I->orgname=$p["Name"];$I->type=($p["Type"]==1?254:0);return$I;}function
seek($qe){for($r=0;$r<$qe;$r++)sqlsrv_fetch($this->_result);}function
__destruct(){sqlsrv_free_stmt($this->_result);}}}elseif(extension_loaded("mssql")){class
Min_DB{var$extension="MSSQL",$_link,$_result,$server_info,$affected_rows,$error;function
connect($N,$V,$E){$this->_link=@mssql_connect($N,$V,$E);if($this->_link){$H=$this->query("SELECT SERVERPROPERTY('ProductLevel'), SERVERPROPERTY('Edition')");if($H){$J=$H->fetch_row();$this->server_info=$this->result("sp_server_info 2",2)." [$J[0]] $J[1]";}}else$this->error=mssql_get_last_message();return(bool)$this->_link;}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($k){return
mssql_select_db($k);}function
query($F,$Kg=false){$H=@mssql_query($F,$this->_link);$this->error="";if(!$H){$this->error=mssql_get_last_message();return
false;}if($H===true){$this->affected_rows=mssql_rows_affected($this->_link);return
true;}return
new
Min_Result($H);}function
multi_query($F){return$this->_result=$this->query($F);}function
store_result(){return$this->_result;}function
next_result(){return
mssql_next_result($this->_result->_result);}function
result($F,$p=0){$H=$this->query($F);if(!is_object($H))return
false;return
mssql_result($H->_result,0,$p);}}class
Min_Result{var$_result,$_offset=0,$_fields,$num_rows;function
__construct($H){$this->_result=$H;$this->num_rows=mssql_num_rows($H);}function
fetch_assoc(){return
mssql_fetch_assoc($this->_result);}function
fetch_row(){return
mssql_fetch_row($this->_result);}function
num_rows(){return
mssql_num_rows($this->_result);}function
fetch_field(){$I=mssql_fetch_field($this->_result);$I->orgtable=$I->table;$I->orgname=$I->name;return$I;}function
seek($qe){mssql_data_seek($this->_result,$qe);}function
__destruct(){mssql_free_result($this->_result);}}}elseif(extension_loaded("pdo_dblib")){class
Min_DB
extends
Min_PDO{var$extension="PDO_DBLIB";function
connect($N,$V,$E){$this->dsn("dblib:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$N)),$V,$E);return
true;}function
select_db($k){return$this->query("USE ".idf_escape($k));}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($R,$K,$Ue){foreach($K
as$O){$Rg=array();$Z=array();foreach($O
as$x=>$X){$Rg[]="$x = $X";if(isset($Ue[idf_unescape($x)]))$Z[]="$x = $X";}if(!queries("MERGE ".table($R)." USING (VALUES(".implode(", ",$O).")) AS source (c".implode(", c",range(1,count($O))).") ON ".implode(" AND ",$Z)." WHEN MATCHED THEN UPDATE SET ".implode(", ",$Rg)." WHEN NOT MATCHED THEN INSERT (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).");"))return
false;}return
true;}function
begin(){return
queries("BEGIN TRANSACTION");}}function
idf_escape($t){return"[".str_replace("]","]]",$t)."]";}function
table($t){return($_GET["ns"]!=""?idf_escape($_GET["ns"]).".":"").idf_escape($t);}function
connect(){global$b;$h=new
Min_DB;$j=$b->credentials();if($h->connect($j[0],$j[1],$j[2]))return$h;return$h->error;}function
get_databases(){return
get_vals("SELECT name FROM sys.databases WHERE name NOT IN ('master', 'tempdb', 'model', 'msdb')");}function
limit($F,$Z,$y,$qe=0,$M=" "){return($y!==null?" TOP (".($y+$qe).")":"")." $F$Z";}function
limit1($R,$F,$Z,$M="\n"){return
limit($F,$Z,1,0,$M);}function
db_collation($m,$fb){global$h;return$h->result("SELECT collation_name FROM sys.databases WHERE name = ".q($m));}function
engines(){return
array();}function
logged_user(){global$h;return$h->result("SELECT SUSER_NAME()");}function
tables_list(){return
get_key_vals("SELECT name, type_desc FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ORDER BY name");}function
count_tables($l){global$h;$I=array();foreach($l
as$m){$h->select_db($m);$I[$m]=$h->result("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");}return$I;}function
table_status($A=""){$I=array();foreach(get_rows("SELECT ao.name AS Name, ao.type_desc AS Engine, (SELECT value FROM fn_listextendedproperty(default, 'SCHEMA', schema_name(schema_id), 'TABLE', ao.name, null, null)) AS Comment FROM sys.all_objects AS ao WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ".($A!=""?"AND name = ".q($A):"ORDER BY name"))as$J){if($A!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($S){return$S["Engine"]=="VIEW";}function
fk_support($S){return
true;}function
fields($R){$kb=get_key_vals("SELECT objname, cast(value as varchar(max)) FROM fn_listextendedproperty('MS_DESCRIPTION', 'schema', ".q(get_schema()).", 'table', ".q($R).", 'column', NULL)");$I=array();foreach(get_rows("SELECT c.max_length, c.precision, c.scale, c.name, c.is_nullable, c.is_identity, c.collation_name, t.name type, CAST(d.definition as text) [default]
FROM sys.all_columns c
JOIN sys.all_objects o ON c.object_id = o.object_id
JOIN sys.types t ON c.user_type_id = t.user_type_id
LEFT JOIN sys.default_constraints d ON c.default_object_id = d.parent_column_id
WHERE o.schema_id = SCHEMA_ID(".q(get_schema()).") AND o.type IN ('S', 'U', 'V') AND o.name = ".q($R))as$J){$U=$J["type"];$Jd=(preg_match("~char|binary~",$U)?$J["max_length"]:($U=="decimal"?"$J[precision],$J[scale]":""));$I[$J["name"]]=array("field"=>$J["name"],"full_type"=>$U.($Jd?"($Jd)":""),"type"=>$U,"length"=>$Jd,"default"=>$J["default"],"null"=>$J["is_nullable"],"auto_increment"=>$J["is_identity"],"collation"=>$J["collation_name"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),"primary"=>$J["is_identity"],"comment"=>$kb[$J["name"]],);}return$I;}function
indexes($R,$i=null){$I=array();foreach(get_rows("SELECT i.name, key_ordinal, is_unique, is_primary_key, c.name AS column_name, is_descending_key
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE OBJECT_NAME(i.object_id) = ".q($R),$i)as$J){$A=$J["name"];$I[$A]["type"]=($J["is_primary_key"]?"PRIMARY":($J["is_unique"]?"UNIQUE":"INDEX"));$I[$A]["lengths"]=array();$I[$A]["columns"][$J["key_ordinal"]]=$J["column_name"];$I[$A]["descs"][$J["key_ordinal"]]=($J["is_descending_key"]?'1':null);}return$I;}function
view($A){global$h;return
array("select"=>preg_replace('~^(?:[^[]|\[[^]]*])*\s+AS\s+~isU','',$h->result("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = SCHEMA_NAME() AND TABLE_NAME = ".q($A))));}function
collations(){$I=array();foreach(get_vals("SELECT name FROM fn_helpcollations()")as$d)$I[preg_replace('~_.*~','',$d)][]=$d;return$I;}function
information_schema($m){return
false;}function
error(){global$h;return
nl_br(h(preg_replace('~^(\[[^]]*])+~m','',$h->error)));}function
create_database($m,$d){return
queries("CREATE DATABASE ".idf_escape($m).(preg_match('~^[a-z0-9_]+$~i',$d)?" COLLATE $d":""));}function
drop_databases($l){return
queries("DROP DATABASE ".implode(", ",array_map('idf_escape',$l)));}function
rename_database($A,$d){if(preg_match('~^[a-z0-9_]+$~i',$d))queries("ALTER DATABASE ".idf_escape(DB)." COLLATE $d");queries("ALTER DATABASE ".idf_escape(DB)." MODIFY NAME = ".idf_escape($A));return
true;}function
auto_increment(){return" IDENTITY".($_POST["Auto_increment"]!=""?"(".number($_POST["Auto_increment"]).",1)":"")." PRIMARY KEY";}function
alter_table($R,$A,$q,$Bc,$jb,$Yb,$d,$Ga,$Je){$c=array();$kb=array();foreach($q
as$p){$e=idf_escape($p[0]);$X=$p[1];if(!$X)$c["DROP"][]=" COLUMN $e";else{$X[1]=preg_replace("~( COLLATE )'(\\w+)'~",'\1\2',$X[1]);$kb[$p[0]]=$X[5];unset($X[5]);if($p[0]=="")$c["ADD"][]="\n  ".implode("",$X).($R==""?substr($Bc[$X[0]],16+strlen($X[0])):"");else{unset($X[6]);if($e!=$X[0])queries("EXEC sp_rename ".q(table($R).".$e").", ".q(idf_unescape($X[0])).", 'COLUMN'");$c["ALTER COLUMN ".implode("",$X)][]="";}}}if($R=="")return
queries("CREATE TABLE ".table($A)." (".implode(",",(array)$c["ADD"])."\n)");if($R!=$A)queries("EXEC sp_rename ".q(table($R)).", ".q($A));if($Bc)$c[""]=$Bc;foreach($c
as$x=>$X){if(!queries("ALTER TABLE ".idf_escape($A)." $x".implode(",",$X)))return
false;}foreach($kb
as$x=>$X){$jb=substr($X,9);queries("EXEC sp_dropextendedproperty @name = N'MS_Description', @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table',  @level1name = ".q($A).", @level2type = N'Column', @level2name = ".q($x));queries("EXEC sp_addextendedproperty @name = N'MS_Description', @value = ".$jb.", @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table',  @level1name = ".q($A).", @level2type = N'Column', @level2name = ".q($x));}return
true;}function
alter_indexes($R,$c){$u=array();$Nb=array();foreach($c
as$X){if($X[2]=="DROP"){if($X[0]=="PRIMARY")$Nb[]=idf_escape($X[1]);else$u[]=idf_escape($X[1])." ON ".table($R);}elseif(!queries(($X[0]!="PRIMARY"?"CREATE $X[0] ".($X[0]!="INDEX"?"INDEX ":"").idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R):"ALTER TABLE ".table($R)." ADD PRIMARY KEY")." (".implode(", ",$X[2]).")"))return
false;}return(!$u||queries("DROP INDEX ".implode(", ",$u)))&&(!$Nb||queries("ALTER TABLE ".table($R)." DROP ".implode(", ",$Nb)));}function
last_id(){global$h;return$h->result("SELECT SCOPE_IDENTITY()");}function
explain($h,$F){$h->query("SET SHOWPLAN_ALL ON");$I=$h->query($F);$h->query("SET SHOWPLAN_ALL OFF");return$I;}function
found_rows($S,$Z){}function
foreign_keys($R){$I=array();foreach(get_rows("EXEC sp_fkeys @fktable_name = ".q($R))as$J){$Ec=&$I[$J["FK_NAME"]];$Ec["db"]=$J["PKTABLE_QUALIFIER"];$Ec["table"]=$J["PKTABLE_NAME"];$Ec["source"][]=$J["FKCOLUMN_NAME"];$Ec["target"][]=$J["PKCOLUMN_NAME"];}return$I;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($dh){return
queries("DROP VIEW ".implode(", ",array_map('table',$dh)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('table',$T)));}function
move_tables($T,$dh,$jg){return
apply_queries("ALTER SCHEMA ".idf_escape($jg)." TRANSFER",array_merge($T,$dh));}function
trigger($A){if($A=="")return
array();$K=get_rows("SELECT s.name [Trigger],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(s.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(s.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing],
c.text
FROM sysobjects s
JOIN syscomments c ON s.id = c.id
WHERE s.xtype = 'TR' AND s.name = ".q($A));$I=reset($K);if($I)$I["Statement"]=preg_replace('~^.+\s+AS\s+~isU','',$I["text"]);return$I;}function
triggers($R){$I=array();foreach(get_rows("SELECT sys1.name,
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing]
FROM sysobjects sys1
JOIN sysobjects sys2 ON sys1.parent_obj = sys2.id
WHERE sys1.xtype = 'TR' AND sys2.name = ".q($R))as$J)$I[$J["name"]]=array($J["Timing"],$J["Event"]);return$I;}function
trigger_options(){return
array("Timing"=>array("AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("AS"),);}function
schemas(){return
get_vals("SELECT name FROM sys.schemas");}function
get_schema(){global$h;if($_GET["ns"]!="")return$_GET["ns"];return$h->result("SELECT SCHEMA_NAME()");}function
set_schema($xf){return
true;}function
use_sql($k){return"USE ".idf_escape($k);}function
show_variables(){return
array();}function
show_status(){return
array();}function
convert_field($p){}function
unconvert_field($p,$I){return$I;}function
support($pc){return
preg_match('~^(comment|columns|database|drop_col|indexes|descidx|scheme|sql|table|trigger|view|view_trigger)$~',$pc);}$w="mssql";$Jg=array();$Zf=array();foreach(array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"int"=>10,"bigint"=>20,"bit"=>1,"decimal"=>0,"real"=>12,"float"=>53,"smallmoney"=>10,"money"=>20),lang(28)=>array("date"=>10,"smalldatetime"=>19,"datetime"=>19,"datetime2"=>19,"time"=>8,"datetimeoffset"=>10),lang(25)=>array("char"=>8000,"varchar"=>8000,"text"=>2147483647,"nchar"=>4000,"nvarchar"=>4000,"ntext"=>1073741823),lang(29)=>array("binary"=>8000,"varbinary"=>8000,"image"=>2147483647),)as$x=>$X){$Jg+=$X;$Zf[$x]=array_keys($X);}$Qg=array();$xe=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL");$Lc=array("len","lower","round","upper");$Pc=array("avg","count","count distinct","max","min","sum");$Rb=array(array("date|time"=>"getdate",),array("int|decimal|real|float|money|datetime"=>"+/-","char|text"=>"+",));}$Mb['firebird']='Firebird (alpha)';if(isset($_GET["firebird"])){$Se=array("interbase");define("DRIVER","firebird");if(extension_loaded("interbase")){class
Min_DB{var$extension="Firebird",$server_info,$affected_rows,$errno,$error,$_link,$_result;function
connect($N,$V,$E){$this->_link=ibase_connect($N,$V,$E);if($this->_link){$Ug=explode(':',$N);$this->service_link=ibase_service_attach($Ug[0],$V,$E);$this->server_info=ibase_server_info($this->service_link,IBASE_SVC_SERVER_VERSION);}else{$this->errno=ibase_errcode();$this->error=ibase_errmsg();}return(bool)$this->_link;}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($k){return($k=="domain");}function
query($F,$Kg=false){$H=ibase_query($F,$this->_link);if(!$H){$this->errno=ibase_errcode();$this->error=ibase_errmsg();return
false;}$this->error="";if($H===true){$this->affected_rows=ibase_affected_rows($this->_link);return
true;}return
new
Min_Result($H);}function
multi_query($F){return$this->_result=$this->query($F);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($F,$p=0){$H=$this->query($F);if(!$H||!$H->num_rows)return
false;$J=$H->fetch_row();return$J[$p];}}class
Min_Result{var$num_rows,$_result,$_offset=0;function
__construct($H){$this->_result=$H;}function
fetch_assoc(){return
ibase_fetch_assoc($this->_result);}function
fetch_row(){return
ibase_fetch_row($this->_result);}function
fetch_field(){$p=ibase_field_info($this->_result,$this->_offset++);return(object)array('name'=>$p['name'],'orgname'=>$p['name'],'type'=>$p['type'],'charsetnr'=>$p['length'],);}function
__destruct(){ibase_free_result($this->_result);}}}class
Min_Driver
extends
Min_SQL{}function
idf_escape($t){return'"'.str_replace('"','""',$t).'"';}function
table($t){return
idf_escape($t);}function
connect(){global$b;$h=new
Min_DB;$j=$b->credentials();if($h->connect($j[0],$j[1],$j[2]))return$h;return$h->error;}function
get_databases($_c){return
array("domain");}function
limit($F,$Z,$y,$qe=0,$M=" "){$I='';$I.=($y!==null?$M."FIRST $y".($qe?" SKIP $qe":""):"");$I.=" $F$Z";return$I;}function
limit1($R,$F,$Z,$M="\n"){return
limit($F,$Z,1,0,$M);}function
db_collation($m,$fb){}function
engines(){return
array();}function
logged_user(){global$b;$j=$b->credentials();return$j[1];}function
tables_list(){global$h;$F='SELECT RDB$RELATION_NAME FROM rdb$relations WHERE rdb$system_flag = 0';$H=ibase_query($h->_link,$F);$I=array();while($J=ibase_fetch_assoc($H))$I[$J['RDB$RELATION_NAME']]='table';ksort($I);return$I;}function
count_tables($l){return
array();}function
table_status($A="",$oc=false){global$h;$I=array();$_b=tables_list();foreach($_b
as$u=>$X){$u=trim($u);$I[$u]=array('Name'=>$u,'Engine'=>'standard',);if($A==$u)return$I[$u];}return$I;}function
is_view($S){return
false;}function
fk_support($S){return
preg_match('~InnoDB|IBMDB2I~i',$S["Engine"]);}function
fields($R){global$h;$I=array();$F='SELECT r.RDB$FIELD_NAME AS field_name,
r.RDB$DESCRIPTION AS field_description,
r.RDB$DEFAULT_VALUE AS field_default_value,
r.RDB$NULL_FLAG AS field_not_null_constraint,
f.RDB$FIELD_LENGTH AS field_length,
f.RDB$FIELD_PRECISION AS field_precision,
f.RDB$FIELD_SCALE AS field_scale,
CASE f.RDB$FIELD_TYPE
WHEN 261 THEN \'BLOB\'
WHEN 14 THEN \'CHAR\'
WHEN 40 THEN \'CSTRING\'
WHEN 11 THEN \'D_FLOAT\'
WHEN 27 THEN \'DOUBLE\'
WHEN 10 THEN \'FLOAT\'
WHEN 16 THEN \'INT64\'
WHEN 8 THEN \'INTEGER\'
WHEN 9 THEN \'QUAD\'
WHEN 7 THEN \'SMALLINT\'
WHEN 12 THEN \'DATE\'
WHEN 13 THEN \'TIME\'
WHEN 35 THEN \'TIMESTAMP\'
WHEN 37 THEN \'VARCHAR\'
ELSE \'UNKNOWN\'
END AS field_type,
f.RDB$FIELD_SUB_TYPE AS field_subtype,
coll.RDB$COLLATION_NAME AS field_collation,
cset.RDB$CHARACTER_SET_NAME AS field_charset
FROM RDB$RELATION_FIELDS r
LEFT JOIN RDB$FIELDS f ON r.RDB$FIELD_SOURCE = f.RDB$FIELD_NAME
LEFT JOIN RDB$COLLATIONS coll ON f.RDB$COLLATION_ID = coll.RDB$COLLATION_ID
LEFT JOIN RDB$CHARACTER_SETS cset ON f.RDB$CHARACTER_SET_ID = cset.RDB$CHARACTER_SET_ID
WHERE r.RDB$RELATION_NAME = '.q($R).'
ORDER BY r.RDB$FIELD_POSITION';$H=ibase_query($h->_link,$F);while($J=ibase_fetch_assoc($H))$I[trim($J['FIELD_NAME'])]=array("field"=>trim($J["FIELD_NAME"]),"full_type"=>trim($J["FIELD_TYPE"]),"type"=>trim($J["FIELD_SUB_TYPE"]),"default"=>trim($J['FIELD_DEFAULT_VALUE']),"null"=>(trim($J["FIELD_NOT_NULL_CONSTRAINT"])=="YES"),"auto_increment"=>'0',"collation"=>trim($J["FIELD_COLLATION"]),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),"comment"=>trim($J["FIELD_DESCRIPTION"]),);return$I;}function
indexes($R,$i=null){$I=array();return$I;}function
foreign_keys($R){return
array();}function
collations(){return
array();}function
information_schema($m){return
false;}function
error(){global$h;return
h($h->error);}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($xf){return
true;}function
support($pc){return
preg_match("~^(columns|sql|status|table)$~",$pc);}$w="firebird";$xe=array("=");$Lc=array();$Pc=array();$Rb=array();}$Mb["simpledb"]="SimpleDB";if(isset($_GET["simpledb"])){$Se=array("SimpleXML + allow_url_fopen");define("DRIVER","simpledb");if(class_exists('SimpleXMLElement')&&ini_bool('allow_url_fopen')){class
Min_DB{var$extension="SimpleXML",$server_info='2009-04-15',$error,$timeout,$next,$affected_rows,$_result;function
select_db($k){return($k=="domain");}function
query($F,$Kg=false){$D=array('SelectExpression'=>$F,'ConsistentRead'=>'true');if($this->next)$D['NextToken']=$this->next;$H=sdb_request_all('Select','Item',$D,$this->timeout);$this->timeout=0;if($H===false)return$H;if(preg_match('~^\s*SELECT\s+COUNT\(~i',$F)){$dg=0;foreach($H
as$wd)$dg+=$wd->Attribute->Value;$H=array((object)array('Attribute'=>array((object)array('Name'=>'Count','Value'=>$dg,))));}return
new
Min_Result($H);}function
multi_query($F){return$this->_result=$this->query($F);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0;function
__construct($H){foreach($H
as$wd){$J=array();if($wd->Name!='')$J['itemName()']=(string)$wd->Name;foreach($wd->Attribute
as$Ca){$A=$this->_processValue($Ca->Name);$Y=$this->_processValue($Ca->Value);if(isset($J[$A])){$J[$A]=(array)$J[$A];$J[$A][]=$Y;}else$J[$A]=$Y;}$this->_rows[]=$J;foreach($J
as$x=>$X){if(!isset($this->_rows[0][$x]))$this->_rows[0][$x]=null;}}$this->num_rows=count($this->_rows);}function
_processValue($Tb){return(is_object($Tb)&&$Tb['encoding']=='base64'?base64_decode($Tb):(string)$Tb);}function
fetch_assoc(){$J=current($this->_rows);if(!$J)return$J;$I=array();foreach($this->_rows[0]as$x=>$X)$I[$x]=$J[$x];next($this->_rows);return$I;}function
fetch_row(){$I=$this->fetch_assoc();if(!$I)return$I;return
array_values($I);}function
fetch_field(){$Ad=array_keys($this->_rows[0]);return(object)array('name'=>$Ad[$this->_offset++]);}}}class
Min_Driver
extends
Min_SQL{public$Ue="itemName()";function
_chunkRequest($dd,$ra,$D,$hc=array()){global$h;foreach(array_chunk($dd,25)as$Za){$He=$D;foreach($Za
as$r=>$s){$He["Item.$r.ItemName"]=$s;foreach($hc
as$x=>$X)$He["Item.$r.$x"]=$X;}if(!sdb_request($ra,$He))return
false;}$h->affected_rows=count($dd);return
true;}function
_extractIds($R,$G,$y){$I=array();if(preg_match_all("~itemName\(\) = (('[^']*+')+)~",$G,$Ud))$I=array_map('idf_unescape',$Ud[1]);else{foreach(sdb_request_all('Select','Item',array('SelectExpression'=>'SELECT itemName() FROM '.table($R).$G.($y?" LIMIT 1":"")))as$wd)$I[]=$wd->Name;}return$I;}function
select($R,$L,$Z,$Mc,$_e=array(),$y=1,$C=0,$We=false){global$h;$h->next=$_GET["next"];$I=parent::select($R,$L,$Z,$Mc,$_e,$y,$C,$We);$h->next=0;return$I;}function
delete($R,$G,$y=0){return$this->_chunkRequest($this->_extractIds($R,$G,$y),'BatchDeleteAttributes',array('DomainName'=>$R));}function
update($R,$O,$G,$y=0,$M="\n"){$Eb=array();$qd=array();$r=0;$dd=$this->_extractIds($R,$G,$y);$s=idf_unescape($O["`itemName()`"]);unset($O["`itemName()`"]);foreach($O
as$x=>$X){$x=idf_unescape($x);if($X=="NULL"||($s!=""&&array($s)!=$dd))$Eb["Attribute.".count($Eb).".Name"]=$x;if($X!="NULL"){foreach((array)$X
as$xd=>$W){$qd["Attribute.$r.Name"]=$x;$qd["Attribute.$r.Value"]=(is_array($X)?$W:idf_unescape($W));if(!$xd)$qd["Attribute.$r.Replace"]="true";$r++;}}}$D=array('DomainName'=>$R);return(!$qd||$this->_chunkRequest(($s!=""?array($s):$dd),'BatchPutAttributes',$D,$qd))&&(!$Eb||$this->_chunkRequest($dd,'BatchDeleteAttributes',$D,$Eb));}function
insert($R,$O){$D=array("DomainName"=>$R);$r=0;foreach($O
as$A=>$Y){if($Y!="NULL"){$A=idf_unescape($A);if($A=="itemName()")$D["ItemName"]=idf_unescape($Y);else{foreach((array)$Y
as$X){$D["Attribute.$r.Name"]=$A;$D["Attribute.$r.Value"]=(is_array($Y)?$X:idf_unescape($Y));$r++;}}}}return
sdb_request('PutAttributes',$D);}function
insertUpdate($R,$K,$Ue){foreach($K
as$O){if(!$this->update($R,$O,"WHERE `itemName()` = ".q($O["`itemName()`"])))return
false;}return
true;}function
begin(){return
false;}function
commit(){return
false;}function
rollback(){return
false;}function
slowQuery($F,$qg){$this->_conn->timeout=$qg;return$F;}}function
connect(){global$b;list(,,$E)=$b->credentials();if($E!="")return
lang(22);return
new
Min_DB;}function
support($pc){return
preg_match('~sql~',$pc);}function
logged_user(){global$b;$j=$b->credentials();return$j[1];}function
get_databases(){return
array("domain");}function
collations(){return
array();}function
db_collation($m,$fb){}function
tables_list(){global$h;$I=array();foreach(sdb_request_all('ListDomains','DomainName')as$R)$I[(string)$R]='table';if($h->error&&defined("PAGE_HEADER"))echo"<p class='error'>".error()."\n";return$I;}function
table_status($A="",$oc=false){$I=array();foreach(($A!=""?array($A=>true):tables_list())as$R=>$U){$J=array("Name"=>$R,"Auto_increment"=>"");if(!$oc){$ce=sdb_request('DomainMetadata',array('DomainName'=>$R));if($ce){foreach(array("Rows"=>"ItemCount","Data_length"=>"ItemNamesSizeBytes","Index_length"=>"AttributeValuesSizeBytes","Data_free"=>"AttributeNamesSizeBytes",)as$x=>$X)$J[$x]=(string)$ce->$X;}}if($A!="")return$J;$I[$R]=$J;}return$I;}function
explain($h,$F){}function
error(){global$h;return
h($h->error);}function
information_schema(){}function
is_view($S){}function
indexes($R,$i=null){return
array(array("type"=>"PRIMARY","columns"=>array("itemName()")),);}function
fields($R){return
fields_from_edit();}function
foreign_keys($R){return
array();}function
table($t){return
idf_escape($t);}function
idf_escape($t){return"`".str_replace("`","``",$t)."`";}function
limit($F,$Z,$y,$qe=0,$M=" "){return" $F$Z".($y!==null?$M."LIMIT $y":"");}function
unconvert_field($p,$I){return$I;}function
fk_support($S){}function
engines(){return
array();}function
alter_table($R,$A,$q,$Bc,$jb,$Yb,$d,$Ga,$Je){return($R==""&&sdb_request('CreateDomain',array('DomainName'=>$A)));}function
drop_tables($T){foreach($T
as$R){if(!sdb_request('DeleteDomain',array('DomainName'=>$R)))return
false;}return
true;}function
count_tables($l){foreach($l
as$m)return
array($m=>count(tables_list()));}function
found_rows($S,$Z){return($Z?null:$S["Rows"]);}function
last_id(){}function
hmac($wa,$_b,$x,$gf=false){$Pa=64;if(strlen($x)>$Pa)$x=pack("H*",$wa($x));$x=str_pad($x,$Pa,"\0");$yd=$x^str_repeat("\x36",$Pa);$zd=$x^str_repeat("\x5C",$Pa);$I=$wa($zd.pack("H*",$wa($yd.$_b)));if($gf)$I=pack("H*",$I);return$I;}function
sdb_request($ra,$D=array()){global$b,$h;list($Zc,$D['AWSAccessKeyId'],$_f)=$b->credentials();$D['Action']=$ra;$D['Timestamp']=gmdate('Y-m-d\TH:i:s+00:00');$D['Version']='2009-04-15';$D['SignatureVersion']=2;$D['SignatureMethod']='HmacSHA1';ksort($D);$F='';foreach($D
as$x=>$X)$F.='&'.rawurlencode($x).'='.rawurlencode($X);$F=str_replace('%7E','~',substr($F,1));$F.="&Signature=".urlencode(base64_encode(hmac('sha1',"POST\n".preg_replace('~^https?://~','',$Zc)."\n/\n$F",$_f,true)));@ini_set('track_errors',1);$sc=@file_get_contents((preg_match('~^https?://~',$Zc)?$Zc:"http://$Zc"),false,stream_context_create(array('http'=>array('method'=>'POST','content'=>$F,'ignore_errors'=>1,))));if(!$sc){$h->error=$php_errormsg;return
false;}libxml_use_internal_errors(true);$oh=simplexml_load_string($sc);if(!$oh){$o=libxml_get_last_error();$h->error=$o->message;return
false;}if($oh->Errors){$o=$oh->Errors->Error;$h->error="$o->Message ($o->Code)";return
false;}$h->error='';$ig=$ra."Result";return($oh->$ig?$oh->$ig:true);}function
sdb_request_all($ra,$ig,$D=array(),$qg=0){$I=array();$Wf=($qg?microtime(true):0);$y=(preg_match('~LIMIT\s+(\d+)\s*$~i',$D['SelectExpression'],$_)?$_[1]:0);do{$oh=sdb_request($ra,$D);if(!$oh)break;foreach($oh->$ig
as$Tb)$I[]=$Tb;if($y&&count($I)>=$y){$_GET["next"]=$oh->NextToken;break;}if($qg&&microtime(true)-$Wf>$qg)return
false;$D['NextToken']=$oh->NextToken;if($y)$D['SelectExpression']=preg_replace('~\d+\s*$~',$y-count($I),$D['SelectExpression']);}while($oh->NextToken);return$I;}$w="simpledb";$xe=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","IS NOT NULL");$Lc=array();$Pc=array("count");$Rb=array(array("json"));}$Mb["mongo"]="MongoDB";if(isset($_GET["mongo"])){$Se=array("mongo","mongodb");define("DRIVER","mongo");if(class_exists('MongoDB\Driver\Manager')){class
Min_DB{var$extension="MongoDB",$server_info=MONGODB_VERSION,$error,$last_id;var$_link;var$_db,$_db_name;function
connect($Sg,$B){$bb='MongoDB\Driver\Manager';return
new$bb($Sg,$B);}function
query($F){return
false;}function
select_db($k){$this->_db_name=$k;return
true;}function
quote($Q){return$Q;}function
ping($z){$bb='MongoDB\Driver\Command';$z->executeCommand('admin',new$bb(array('ping'=>1)));}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0,$_charset=array();function
__construct($H){foreach($H
as$wd){$J=array();foreach($wd
as$x=>$X){if(is_a($X,'MongoDB\BSON\Binary'))$this->_charset[$x]=63;$J[$x]=(is_a($X,'MongoDB\BSON\ObjectID')?'MongoDB\BSON\ObjectID("'.strval($X).'")':(is_a($X,'MongoDB\BSON\UTCDatetime')?$X->toDateTime()->format('Y-m-d H:i:s'):(is_a($X,'MongoDB\BSON\Binary')?$X->bin:(is_a($X,'MongoDB\BSON\Regex')?strval($X):(is_object($X)?json_encode($X,256):$X)))));}$this->_rows[]=$J;foreach($J
as$x=>$X){if(!isset($this->_rows[0][$x]))$this->_rows[0][$x]=null;}}$this->num_rows=$H->count;}function
fetch_assoc(){$J=current($this->_rows);if(!$J)return$J;$I=array();foreach($this->_rows[0]as$x=>$X)$I[$x]=$J[$x];next($this->_rows);return$I;}function
fetch_row(){$I=$this->fetch_assoc();if(!$I)return$I;return
array_values($I);}function
fetch_field(){$Ad=array_keys($this->_rows[0]);$A=$Ad[$this->_offset++];return(object)array('name'=>$A,'charsetnr'=>$this->_charset[$A],);}}class
Min_Driver
extends
Min_SQL{public$Ue="_id";function
select($R,$L,$Z,$Mc,$_e=array(),$y=1,$C=0,$We=false){global$h;$L=($L==array("*")?array():array_fill_keys($L,1));if(count($L)&&!isset($L['_id']))$L['_id']=0;$Z=where_to_query($Z);$Pf=array();foreach($_e
as$X){$X=preg_replace('~ DESC$~','',$X,1,$ub);$Pf[$X]=($ub?-1:1);}if(isset($_GET['limit'])&&is_numeric($_GET['limit'])&&$_GET['limit']>0)$y=$_GET['limit'];$y=min(200,max(1,(int)$y));$Mf=$C*$y;$bb='MongoDB\Driver\Query';$F=new$bb($Z,array('projection'=>$L,'limit'=>$y,'skip'=>$Mf,'sort'=>$Pf));$sf=$h->_link->executeQuery("$h->_db_name.$R",$F);return
new
Min_Result($sf);}function
update($R,$O,$G,$y=0,$M="\n"){global$h;$m=$h->_db_name;$Z=sql_query_where_parser($G);$bb='MongoDB\Driver\BulkWrite';$Ta=new$bb(array());if(isset($O['_id']))unset($O['_id']);$lf=array();foreach($O
as$x=>$Y){if($Y=='NULL'){$lf[$x]=1;unset($O[$x]);}}$Rg=array('$set'=>$O);if(count($lf))$Rg['$unset']=$lf;$Ta->update($Z,$Rg,array('upsert'=>false));$sf=$h->_link->executeBulkWrite("$m.$R",$Ta);$h->affected_rows=$sf->getModifiedCount();return
true;}function
delete($R,$G,$y=0){global$h;$m=$h->_db_name;$Z=sql_query_where_parser($G);$bb='MongoDB\Driver\BulkWrite';$Ta=new$bb(array());$Ta->delete($Z,array('limit'=>$y));$sf=$h->_link->executeBulkWrite("$m.$R",$Ta);$h->affected_rows=$sf->getDeletedCount();return
true;}function
insert($R,$O){global$h;$m=$h->_db_name;$bb='MongoDB\Driver\BulkWrite';$Ta=new$bb(array());if(isset($O['_id'])&&empty($O['_id']))unset($O['_id']);$Ta->insert($O);$sf=$h->_link->executeBulkWrite("$m.$R",$Ta);$h->affected_rows=$sf->getInsertedCount();return
true;}}function
get_databases($_c){global$h;$I=array();$bb='MongoDB\Driver\Command';$ib=new$bb(array('listDatabases'=>1));$sf=$h->_link->executeCommand('admin',$ib);foreach($sf
as$Bb){foreach($Bb->databases
as$m)$I[]=$m->name;}return$I;}function
count_tables($l){$I=array();return$I;}function
tables_list(){global$h;$bb='MongoDB\Driver\Command';$ib=new$bb(array('listCollections'=>1));$sf=$h->_link->executeCommand($h->_db_name,$ib);$gb=array();foreach($sf
as$H)$gb[$H->name]='table';return$gb;}function
drop_databases($l){return
false;}function
indexes($R,$i=null){global$h;$I=array();$bb='MongoDB\Driver\Command';$ib=new$bb(array('listIndexes'=>$R));$sf=$h->_link->executeCommand($h->_db_name,$ib);foreach($sf
as$u){$Hb=array();$f=array();foreach(get_object_vars($u->key)as$e=>$U){$Hb[]=($U==-1?'1':null);$f[]=$e;}$I[$u->name]=array("type"=>($u->name=="_id_"?"PRIMARY":(isset($u->unique)?"UNIQUE":"INDEX")),"columns"=>$f,"lengths"=>array(),"descs"=>$Hb,);}return$I;}function
fields($R){$q=fields_from_edit();if(!count($q)){global$n;$H=$n->select($R,array("*"),null,null,array(),10);while($J=$H->fetch_assoc()){foreach($J
as$x=>$X){$J[$x]=null;$q[$x]=array("field"=>$x,"type"=>"string","null"=>($x!=$n->primary),"auto_increment"=>($x==$n->primary),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,),);}}}return$q;}function
found_rows($S,$Z){global$h;$Z=where_to_query($Z);$bb='MongoDB\Driver\Command';$ib=new$bb(array('count'=>$S['Name'],'query'=>$Z));$sf=$h->_link->executeCommand($h->_db_name,$ib);$xg=$sf->toArray();return$xg[0]->n;}function
sql_query_where_parser($G){$G=trim(preg_replace('/WHERE[\s]?[(]?\(?/','',$G));$G=preg_replace('/\)\)\)$/',')',$G);$lh=explode(' AND ',$G);$mh=explode(') OR (',$G);$Z=array();foreach($lh
as$jh)$Z[]=trim($jh);if(count($mh)==1)$mh=array();elseif(count($mh)>1)$Z=array();return
where_to_query($Z,$mh);}function
where_to_query($hh=array(),$ih=array()){global$b;$_b=array();foreach(array('and'=>$hh,'or'=>$ih)as$U=>$Z){if(is_array($Z)){foreach($Z
as$ic){list($eb,$ve,$X)=explode(" ",$ic,3);if($eb=="_id"){$X=str_replace('MongoDB\BSON\ObjectID("',"",$X);$X=str_replace('")',"",$X);$bb='MongoDB\BSON\ObjectID';$X=new$bb($X);}if(!in_array($ve,$b->operators))continue;if(preg_match('~^\(f\)(.+)~',$ve,$_)){$X=(float)$X;$ve=$_[1];}elseif(preg_match('~^\(date\)(.+)~',$ve,$_)){$Ab=new
DateTime($X);$bb='MongoDB\BSON\UTCDatetime';$X=new$bb($Ab->getTimestamp()*1000);$ve=$_[1];}switch($ve){case'=':$ve='$eq';break;case'!=':$ve='$ne';break;case'>':$ve='$gt';break;case'<':$ve='$lt';break;case'>=':$ve='$gte';break;case'<=':$ve='$lte';break;case'regex':$ve='$regex';break;default:continue
2;}if($U=='and')$_b['$and'][]=array($eb=>array($ve=>$X));elseif($U=='or')$_b['$or'][]=array($eb=>array($ve=>$X));}}}return$_b;}$xe=array("=","!=",">","<",">=","<=","regex","(f)=","(f)!=","(f)>","(f)<","(f)>=","(f)<=","(date)=","(date)!=","(date)>","(date)<","(date)>=","(date)<=",);}elseif(class_exists('MongoDB')){class
Min_DB{var$extension="Mongo",$server_info=MongoClient::VERSION,$error,$last_id,$_link,$_db;function
connect($Sg,$B){return@new
MongoClient($Sg,$B);}function
query($F){return
false;}function
select_db($k){try{$this->_db=$this->_link->selectDB($k);return
true;}catch(Exception$ec){$this->error=$ec->getMessage();return
false;}}function
quote($Q){return$Q;}function
ping($z){}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0,$_charset=array();function
__construct($H){foreach($H
as$wd){$J=array();foreach($wd
as$x=>$X){if(is_a($X,'MongoBinData'))$this->_charset[$x]=63;$J[$x]=(is_a($X,'MongoId')?'ObjectId("'.strval($X).'")':(is_a($X,'MongoDate')?gmdate("Y-m-d H:i:s",$X->sec)." GMT":(is_a($X,'MongoBinData')?$X->bin:(is_a($X,'MongoRegex')?strval($X):(is_object($X)?get_class($X):$X)))));}$this->_rows[]=$J;foreach($J
as$x=>$X){if(!isset($this->_rows[0][$x]))$this->_rows[0][$x]=null;}}$this->num_rows=count($this->_rows);}function
fetch_assoc(){$J=current($this->_rows);if(!$J)return$J;$I=array();foreach($this->_rows[0]as$x=>$X)$I[$x]=$J[$x];next($this->_rows);return$I;}function
fetch_row(){$I=$this->fetch_assoc();if(!$I)return$I;return
array_values($I);}function
fetch_field(){$Ad=array_keys($this->_rows[0]);$A=$Ad[$this->_offset++];return(object)array('name'=>$A,'charsetnr'=>$this->_charset[$A],);}}class
Min_Driver
extends
Min_SQL{public$Ue="_id";function
select($R,$L,$Z,$Mc,$_e=array(),$y=1,$C=0,$We=false){$L=($L==array("*")?array():array_fill_keys($L,true));$Pf=array();foreach($_e
as$X){$X=preg_replace('~ DESC$~','',$X,1,$ub);$Pf[$X]=($ub?-1:1);}return
new
Min_Result($this->_conn->_db->selectCollection($R)->find(array(),$L)->sort($Pf)->limit($y!=""?+$y:0)->skip($C*$y));}function
insert($R,$O){try{$I=$this->_conn->_db->selectCollection($R)->insert($O);$this->_conn->errno=$I['code'];$this->_conn->error=$I['err'];$this->_conn->last_id=$O['_id'];return!$I['err'];}catch(Exception$ec){$this->_conn->error=$ec->getMessage();return
false;}}}function
get_databases($_c){global$h;$I=array();$Bb=$h->_link->listDBs();foreach($Bb['databases']as$m)$I[]=$m['name'];return$I;}function
count_tables($l){global$h;$I=array();foreach($l
as$m)$I[$m]=count($h->_link->selectDB($m)->getCollectionNames(true));return$I;}function
tables_list(){global$h;return
array_fill_keys($h->_db->getCollectionNames(true),'table');}function
drop_databases($l){global$h;foreach($l
as$m){$pf=$h->_link->selectDB($m)->drop();if(!$pf['ok'])return
false;}return
true;}function
indexes($R,$i=null){global$h;$I=array();foreach($h->_db->selectCollection($R)->getIndexInfo()as$u){$Hb=array();foreach($u["key"]as$e=>$U)$Hb[]=($U==-1?'1':null);$I[$u["name"]]=array("type"=>($u["name"]=="_id_"?"PRIMARY":($u["unique"]?"UNIQUE":"INDEX")),"columns"=>array_keys($u["key"]),"lengths"=>array(),"descs"=>$Hb,);}return$I;}function
fields($R){return
fields_from_edit();}function
found_rows($S,$Z){global$h;return$h->_db->selectCollection($_GET["select"])->count($Z);}$xe=array("=");}function
table($t){return$t;}function
idf_escape($t){return$t;}function
table_status($A="",$oc=false){$I=array();foreach(tables_list()as$R=>$U){$I[$R]=array("Name"=>$R);if($A==$R)return$I[$R];}return$I;}function
create_database($m,$d){return
true;}function
last_id(){global$h;return$h->last_id;}function
error(){global$h;return
h($h->error);}function
collations(){return
array();}function
logged_user(){global$b;$j=$b->credentials();return$j[1];}function
connect(){global$b;$h=new
Min_DB;list($N,$V,$E)=$b->credentials();$B=array();if($V.$E!=""){$B["username"]=$V;$B["password"]=$E;}$m=$b->database();if($m!="")$B["db"]=$m;if(($Fa=getenv("MONGO_AUTH_SOURCE")))$B["authSource"]=$Fa;try{$h->_link=$h->connect("mongodb://$N",$B);if($E!=""){$B["password"]="";try{$h->ping($h->connect("mongodb://$N",$B));return
lang(22);}catch(Exception$ec){}}return$h;}catch(Exception$ec){return$ec->getMessage();}}function
alter_indexes($R,$c){global$h;foreach($c
as$X){list($U,$A,$O)=$X;if($O=="DROP")$I=$h->_db->command(array("deleteIndexes"=>$R,"index"=>$A));else{$f=array();foreach($O
as$e){$e=preg_replace('~ DESC$~','',$e,1,$ub);$f[$e]=($ub?-1:1);}$I=$h->_db->selectCollection($R)->ensureIndex($f,array("unique"=>($U=="UNIQUE"),"name"=>$A,));}if($I['errmsg']){$h->error=$I['errmsg'];return
false;}}return
true;}function
support($pc){return
preg_match("~database|indexes|descidx~",$pc);}function
db_collation($m,$fb){}function
information_schema(){}function
is_view($S){}function
convert_field($p){}function
unconvert_field($p,$I){return$I;}function
foreign_keys($R){return
array();}function
fk_support($S){}function
engines(){return
array();}function
alter_table($R,$A,$q,$Bc,$jb,$Yb,$d,$Ga,$Je){global$h;if($R==""){$h->_db->createCollection($A);return
true;}}function
drop_tables($T){global$h;foreach($T
as$R){$pf=$h->_db->selectCollection($R)->drop();if(!$pf['ok'])return
false;}return
true;}function
truncate_tables($T){global$h;foreach($T
as$R){$pf=$h->_db->selectCollection($R)->remove();if(!$pf['ok'])return
false;}return
true;}$w="mongo";$Lc=array();$Pc=array();$Rb=array(array("json"));}$Mb["elastic"]="Elasticsearch (beta)";if(isset($_GET["elastic"])){$Se=array("json + allow_url_fopen");define("DRIVER","elastic");if(function_exists('json_decode')&&ini_bool('allow_url_fopen')){class
Min_DB{var$extension="JSON",$server_info,$errno,$error,$_url,$_db;function
rootQuery($Le,$sb=array(),$de='GET'){@ini_set('track_errors',1);$sc=@file_get_contents("$this->_url/".ltrim($Le,'/'),false,stream_context_create(array('http'=>array('method'=>$de,'content'=>$sb===null?$sb:json_encode($sb),'header'=>'Content-Type: application/json','ignore_errors'=>1,))));if(!$sc){$this->error=$php_errormsg;return$sc;}if(!preg_match('~^HTTP/[0-9.]+ 2~i',$http_response_header[0])){$this->error=lang(32)." $http_response_header[0]";return
false;}$I=json_decode($sc,true);if($I===null){$this->errno=json_last_error();if(function_exists('json_last_error_msg'))$this->error=json_last_error_msg();else{$qb=get_defined_constants(true);foreach($qb['json']as$A=>$Y){if($Y==$this->errno&&preg_match('~^JSON_ERROR_~',$A)){$this->error=$A;break;}}}}return$I;}function
query($Le,$sb=array(),$de='GET'){return$this->rootQuery(($this->_db!=""?"$this->_db/":"/").ltrim($Le,'/'),$sb,$de);}function
connect($N,$V,$E){preg_match('~^(https?://)?(.*)~',$N,$_);$this->_url=($_[1]?$_[1]:"http://")."$V:$E@$_[2]";$I=$this->query('');if($I)$this->server_info=$I['version']['number'];return(bool)$I;}function
select_db($k){$this->_db=$k;return
true;}function
quote($Q){return$Q;}}class
Min_Result{var$num_rows,$_rows;function
__construct($K){$this->num_rows=count($K);$this->_rows=$K;reset($this->_rows);}function
fetch_assoc(){$I=current($this->_rows);next($this->_rows);return$I;}function
fetch_row(){return
array_values($this->fetch_assoc());}}}class
Min_Driver
extends
Min_SQL{function
select($R,$L,$Z,$Mc,$_e=array(),$y=1,$C=0,$We=false){global$b;$_b=array();$F="$R/_search";if($L!=array("*"))$_b["fields"]=$L;if($_e){$Pf=array();foreach($_e
as$eb){$eb=preg_replace('~ DESC$~','',$eb,1,$ub);$Pf[]=($ub?array($eb=>"desc"):$eb);}$_b["sort"]=$Pf;}if($y){$_b["size"]=+$y;if($C)$_b["from"]=($C*$y);}foreach($Z
as$X){list($eb,$ve,$X)=explode(" ",$X,3);if($eb=="_id")$_b["query"]["ids"]["values"][]=$X;elseif($eb.$X!=""){$lg=array("term"=>array(($eb!=""?$eb:"_all")=>$X));if($ve=="=")$_b["query"]["filtered"]["filter"]["and"][]=$lg;else$_b["query"]["filtered"]["query"]["bool"]["must"][]=$lg;}}if($_b["query"]&&!$_b["query"]["filtered"]["query"]&&!$_b["query"]["ids"])$_b["query"]["filtered"]["query"]=array("match_all"=>array());$Wf=microtime(true);$zf=$this->_conn->query($F,$_b);if($We)echo$b->selectQuery("$F: ".json_encode($_b),$Wf,!$zf);if(!$zf)return
false;$I=array();foreach($zf['hits']['hits']as$Yc){$J=array();if($L==array("*"))$J["_id"]=$Yc["_id"];$q=$Yc['_source'];if($L!=array("*")){$q=array();foreach($L
as$x)$q[$x]=$Yc['fields'][$x];}foreach($q
as$x=>$X){if($_b["fields"])$X=$X[0];$J[$x]=(is_array($X)?json_encode($X):$X);}$I[]=$J;}return
new
Min_Result($I);}function
update($U,$hf,$G,$y=0,$M="\n"){$Ke=preg_split('~ *= *~',$G);if(count($Ke)==2){$s=trim($Ke[1]);$F="$U/$s";return$this->_conn->query($F,$hf,'POST');}return
false;}function
insert($U,$hf){$s="";$F="$U/$s";$pf=$this->_conn->query($F,$hf,'POST');$this->_conn->last_id=$pf['_id'];return$pf['created'];}function
delete($U,$G,$y=0){$dd=array();if(is_array($_GET["where"])&&$_GET["where"]["_id"])$dd[]=$_GET["where"]["_id"];if(is_array($_POST['check'])){foreach($_POST['check']as$Va){$Ke=preg_split('~ *= *~',$Va);if(count($Ke)==2)$dd[]=trim($Ke[1]);}}$this->_conn->affected_rows=0;foreach($dd
as$s){$F="{$U}/{$s}";$pf=$this->_conn->query($F,'{}','DELETE');if(is_array($pf)&&$pf['found']==true)$this->_conn->affected_rows++;}return$this->_conn->affected_rows;}}function
connect(){global$b;$h=new
Min_DB;list($N,$V,$E)=$b->credentials();if($E!=""&&$h->connect($N,$V,""))return
lang(22);if($h->connect($N,$V,$E))return$h;return$h->error;}function
support($pc){return
preg_match("~database|table|columns~",$pc);}function
logged_user(){global$b;$j=$b->credentials();return$j[1];}function
get_databases(){global$h;$I=$h->rootQuery('_aliases');if($I){$I=array_keys($I);sort($I,SORT_STRING);}return$I;}function
collations(){return
array();}function
db_collation($m,$fb){}function
engines(){return
array();}function
count_tables($l){global$h;$I=array();$H=$h->query('_stats');if($H&&$H['indices']){$jd=$H['indices'];foreach($jd
as$id=>$Xf){$hd=$Xf['total']['indexing'];$I[$id]=$hd['index_total'];}}return$I;}function
tables_list(){global$h;if(min_version(6))return
array('_doc'=>'table');$I=$h->query('_mapping');if($I)$I=array_fill_keys(array_keys($I[$h->_db]["mappings"]),'table');return$I;}function
table_status($A="",$oc=false){global$h;$zf=$h->query("_search",array("size"=>0,"aggregations"=>array("count_by_type"=>array("terms"=>array("field"=>"_type")))),"POST");$I=array();if($zf){$T=$zf["aggregations"]["count_by_type"]["buckets"];foreach($T
as$R){$I[$R["key"]]=array("Name"=>$R["key"],"Engine"=>"table","Rows"=>$R["doc_count"],);if($A!=""&&$A==$R["key"])return$I[$A];}}return$I;}function
error(){global$h;return
h($h->error);}function
information_schema(){}function
is_view($S){}function
indexes($R,$i=null){return
array(array("type"=>"PRIMARY","columns"=>array("_id")),);}function
fields($R){global$h;$Qd=array();if(min_version(6)){$H=$h->query("_mapping");if($H)$Qd=$H[$h->_db]['mappings']['properties'];}else{$H=$h->query("$R/_mapping");if($H){$Qd=$H[$R]['properties'];if(!$Qd)$Qd=$H[$h->_db]['mappings'][$R]['properties'];}}$I=array();if($Qd){foreach($Qd
as$A=>$p){$I[$A]=array("field"=>$A,"full_type"=>$p["type"],"type"=>$p["type"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),);if($p["properties"]){unset($I[$A]["privileges"]["insert"]);unset($I[$A]["privileges"]["update"]);}}}return$I;}function
foreign_keys($R){return
array();}function
table($t){return$t;}function
idf_escape($t){return$t;}function
convert_field($p){}function
unconvert_field($p,$I){return$I;}function
fk_support($S){}function
found_rows($S,$Z){return
null;}function
create_database($m){global$h;return$h->rootQuery(urlencode($m),null,'PUT');}function
drop_databases($l){global$h;return$h->rootQuery(urlencode(implode(',',$l)),array(),'DELETE');}function
alter_table($R,$A,$q,$Bc,$jb,$Yb,$d,$Ga,$Je){global$h;$Ze=array();foreach($q
as$mc){$qc=trim($mc[1][0]);$rc=trim($mc[1][1]?$mc[1][1]:"text");$Ze[$qc]=array('type'=>$rc);}if(!empty($Ze))$Ze=array('properties'=>$Ze);return$h->query("_mapping/{$A}",$Ze,'PUT');}function
drop_tables($T){global$h;$I=true;foreach($T
as$R)$I=$I&&$h->query(urlencode($R),array(),'DELETE');return$I;}function
last_id(){global$h;return$h->last_id;}$w="elastic";$xe=array("=","query");$Lc=array();$Pc=array();$Rb=array(array("json"));$Jg=array();$Zf=array();foreach(array(lang(27)=>array("long"=>3,"integer"=>5,"short"=>8,"byte"=>10,"double"=>20,"float"=>66,"half_float"=>12,"scaled_float"=>21),lang(28)=>array("date"=>10),lang(25)=>array("string"=>65535,"text"=>65535),lang(29)=>array("binary"=>255),)as$x=>$X){$Jg+=$X;$Zf[$x]=array_keys($X);}}$Mb["clickhouse"]="ClickHouse (alpha)";if(isset($_GET["clickhouse"])){define("DRIVER","clickhouse");class
Min_DB{var$extension="JSON",$server_info,$errno,$_result,$error,$_url;var$_db='default';function
rootQuery($m,$F){@ini_set('track_errors',1);$sc=@file_get_contents("$this->_url/?database=$m",false,stream_context_create(array('http'=>array('method'=>'POST','content'=>$this->isQuerySelectLike($F)?"$F FORMAT JSONCompact":$F,'header'=>'Content-type: application/x-www-form-urlencoded','ignore_errors'=>1,))));if($sc===false){$this->error=$php_errormsg;return$sc;}if(!preg_match('~^HTTP/[0-9.]+ 2~i',$http_response_header[0])){$this->error=lang(32)." $http_response_header[0]";return
false;}$I=json_decode($sc,true);if($I===null){if(!$this->isQuerySelectLike($F)&&$sc==='')return
true;$this->errno=json_last_error();if(function_exists('json_last_error_msg'))$this->error=json_last_error_msg();else{$qb=get_defined_constants(true);foreach($qb['json']as$A=>$Y){if($Y==$this->errno&&preg_match('~^JSON_ERROR_~',$A)){$this->error=$A;break;}}}}return
new
Min_Result($I);}function
isQuerySelectLike($F){return(bool)preg_match('~^(select|show)~i',$F);}function
query($F){return$this->rootQuery($this->_db,$F);}function
connect($N,$V,$E){preg_match('~^(https?://)?(.*)~',$N,$_);$this->_url=($_[1]?$_[1]:"http://")."$V:$E@$_[2]";$I=$this->query('SELECT 1');return(bool)$I;}function
select_db($k){$this->_db=$k;return
true;}function
quote($Q){return"'".addcslashes($Q,"\\'")."'";}function
multi_query($F){return$this->_result=$this->query($F);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($F,$p=0){$H=$this->query($F);return$H['data'];}}class
Min_Result{var$num_rows,$_rows,$columns,$meta,$_offset=0;function
__construct($H){$this->num_rows=$H['rows'];$this->_rows=$H['data'];$this->meta=$H['meta'];$this->columns=array_column($this->meta,'name');reset($this->_rows);}function
fetch_assoc(){$J=current($this->_rows);next($this->_rows);return$J===false?false:array_combine($this->columns,$J);}function
fetch_row(){$J=current($this->_rows);next($this->_rows);return$J;}function
fetch_field(){$e=$this->_offset++;$I=new
stdClass;if($e<count($this->columns)){$I->name=$this->meta[$e]['name'];$I->orgname=$I->name;$I->type=$this->meta[$e]['type'];}return$I;}}class
Min_Driver
extends
Min_SQL{function
delete($R,$G,$y=0){if($G==='')$G='WHERE 1=1';return
queries("ALTER TABLE ".table($R)." DELETE $G");}function
update($R,$O,$G,$y=0,$M="\n"){$Zg=array();foreach($O
as$x=>$X)$Zg[]="$x = $X";$F=$M.implode(",$M",$Zg);return
queries("ALTER TABLE ".table($R)." UPDATE $F$G");}}function
idf_escape($t){return"`".str_replace("`","``",$t)."`";}function
table($t){return
idf_escape($t);}function
explain($h,$F){return'';}function
found_rows($S,$Z){$K=get_vals("SELECT COUNT(*) FROM ".idf_escape($S["Name"]).($Z?" WHERE ".implode(" AND ",$Z):""));return
empty($K)?false:$K[0];}function
alter_table($R,$A,$q,$Bc,$jb,$Yb,$d,$Ga,$Je){$c=$_e=array();foreach($q
as$p){if($p[1][2]===" NULL")$p[1][1]=" Nullable({$p[1][1]})";elseif($p[1][2]===' NOT NULL')$p[1][2]='';if($p[1][3])$p[1][3]='';$c[]=($p[1]?($R!=""?($p[0]!=""?"MODIFY COLUMN ":"ADD COLUMN "):" ").implode($p[1]):"DROP COLUMN ".idf_escape($p[0]));$_e[]=$p[1][0];}$c=array_merge($c,$Bc);$P=($Yb?" ENGINE ".$Yb:"");if($R=="")return
queries("CREATE TABLE ".table($A)." (\n".implode(",\n",$c)."\n)$P$Je".' ORDER BY ('.implode(',',$_e).')');if($R!=$A){$H=queries("RENAME TABLE ".table($R)." TO ".table($A));if($c)$R=$A;else
return$H;}if($P)$c[]=ltrim($P);return($c||$Je?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$c).$Je):true);}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($dh){return
drop_tables($dh);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
connect(){global$b;$h=new
Min_DB;$j=$b->credentials();if($h->connect($j[0],$j[1],$j[2]))return$h;return$h->error;}function
get_databases($_c){global$h;$H=get_rows('SHOW DATABASES');$I=array();foreach($H
as$J)$I[]=$J['name'];sort($I);return$I;}function
limit($F,$Z,$y,$qe=0,$M=" "){return" $F$Z".($y!==null?$M."LIMIT $y".($qe?", $qe":""):"");}function
limit1($R,$F,$Z,$M="\n"){return
limit($F,$Z,1,0,$M);}function
db_collation($m,$fb){}function
engines(){return
array('MergeTree');}function
logged_user(){global$b;$j=$b->credentials();return$j[1];}function
tables_list(){$H=get_rows('SHOW TABLES');$I=array();foreach($H
as$J)$I[$J['name']]='table';ksort($I);return$I;}function
count_tables($l){return
array();}function
table_status($A="",$oc=false){global$h;$I=array();$T=get_rows("SELECT name, engine FROM system.tables WHERE database = ".q($h->_db));foreach($T
as$R){$I[$R['name']]=array('Name'=>$R['name'],'Engine'=>$R['engine'],);if($A===$R['name'])return$I[$R['name']];}return$I;}function
is_view($S){return
false;}function
fk_support($S){return
false;}function
convert_field($p){}function
unconvert_field($p,$I){if(in_array($p['type'],array("Int8","Int16","Int32","Int64","UInt8","UInt16","UInt32","UInt64","Float32","Float64")))return"to$p[type]($I)";return$I;}function
fields($R){$I=array();$H=get_rows("SELECT name, type, default_expression FROM system.columns WHERE ".idf_escape('table')." = ".q($R));foreach($H
as$J){$U=trim($J['type']);$me=strpos($U,'Nullable(')===0;$I[trim($J['name'])]=array("field"=>trim($J['name']),"full_type"=>$U,"type"=>$U,"default"=>trim($J['default_expression']),"null"=>$me,"auto_increment"=>'0',"privileges"=>array("insert"=>1,"select"=>1,"update"=>0),);}return$I;}function
indexes($R,$i=null){return
array();}function
foreign_keys($R){return
array();}function
collations(){return
array();}function
information_schema($m){return
false;}function
error(){global$h;return
h($h->error);}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($xf){return
true;}function
auto_increment(){return'';}function
last_id(){return
0;}function
support($pc){return
preg_match("~^(columns|sql|status|table|drop_col)$~",$pc);}$w="clickhouse";$Jg=array();$Zf=array();foreach(array(lang(27)=>array("Int8"=>3,"Int16"=>5,"Int32"=>10,"Int64"=>19,"UInt8"=>3,"UInt16"=>5,"UInt32"=>10,"UInt64"=>20,"Float32"=>7,"Float64"=>16,'Decimal'=>38,'Decimal32'=>9,'Decimal64'=>18,'Decimal128'=>38),lang(28)=>array("Date"=>13,"DateTime"=>20),lang(25)=>array("String"=>0),lang(29)=>array("FixedString"=>0),)as$x=>$X){$Jg+=$X;$Zf[$x]=array_keys($X);}$Qg=array();$xe=array("=","<",">","<=",">=","!=","~","!~","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");$Lc=array();$Pc=array("avg","count","count distinct","max","min","sum");$Rb=array();}$Mb=array("server"=>"MySQL")+$Mb;if(!defined("DRIVER")){$Se=array("MySQLi","MySQL","PDO_MySQL");define("DRIVER","server");if(extension_loaded("mysqli")){class
Min_DB
extends
MySQLi{var$extension="MySQLi";function
__construct(){parent::init();}function
connect($N="",$V="",$E="",$k=null,$Qe=null,$Of=null){global$b;mysqli_report(MYSQLI_REPORT_OFF);list($Zc,$Qe)=explode(":",$N,2);$Vf=$b->connectSsl();if($Vf)$this->ssl_set($Vf['key'],$Vf['cert'],$Vf['ca'],'','');$I=@$this->real_connect(($N!=""?$Zc:ini_get("mysqli.default_host")),($N.$V!=""?$V:ini_get("mysqli.default_user")),($N.$V.$E!=""?$E:ini_get("mysqli.default_pw")),$k,(is_numeric($Qe)?$Qe:ini_get("mysqli.default_port")),(!is_numeric($Qe)?$Qe:$Of),($Vf?64:0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return$I;}function
set_charset($Ua){if(parent::set_charset($Ua))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $Ua");}function
result($F,$p=0){$H=$this->query($F);if(!$H)return
false;$J=$H->fetch_array();return$J[$p];}function
quote($Q){return"'".$this->escape_string($Q)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Min_DB{var$extension="MySQL",$server_info,$affected_rows,$errno,$error,$_link,$_result;function
connect($N,$V,$E){if(ini_bool("mysql.allow_local_infile")){$this->error=lang(33,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");return
false;}$this->_link=@mysql_connect(($N!=""?$N:ini_get("mysql.default_host")),("$N$V"!=""?$V:ini_get("mysql.default_user")),("$N$V$E"!=""?$E:ini_get("mysql.default_password")),true,131072);if($this->_link)$this->server_info=mysql_get_server_info($this->_link);else$this->error=mysql_error();return(bool)$this->_link;}function
set_charset($Ua){if(function_exists('mysql_set_charset')){if(mysql_set_charset($Ua,$this->_link))return
true;mysql_set_charset('utf8',$this->_link);}return$this->query("SET NAMES $Ua");}function
quote($Q){return"'".mysql_real_escape_string($Q,$this->_link)."'";}function
select_db($k){return
mysql_select_db($k,$this->_link);}function
query($F,$Kg=false){$H=@($Kg?mysql_unbuffered_query($F,$this->_link):mysql_query($F,$this->_link));$this->error="";if(!$H){$this->errno=mysql_errno($this->_link);$this->error=mysql_error($this->_link);return
false;}if($H===true){$this->affected_rows=mysql_affected_rows($this->_link);$this->info=mysql_info($this->_link);return
true;}return
new
Min_Result($H);}function
multi_query($F){return$this->_result=$this->query($F);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($F,$p=0){$H=$this->query($F);if(!$H||!$H->num_rows)return
false;return
mysql_result($H->_result,0,$p);}}class
Min_Result{var$num_rows,$_result,$_offset=0;function
__construct($H){$this->_result=$H;$this->num_rows=mysql_num_rows($H);}function
fetch_assoc(){return
mysql_fetch_assoc($this->_result);}function
fetch_row(){return
mysql_fetch_row($this->_result);}function
fetch_field(){$I=mysql_fetch_field($this->_result,$this->_offset++);$I->orgtable=$I->table;$I->orgname=$I->name;$I->charsetnr=($I->blob?63:0);return$I;}function
__destruct(){mysql_free_result($this->_result);}}}elseif(extension_loaded("pdo_mysql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_MySQL";function
connect($N,$V,$E){global$b;$B=array(PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$Vf=$b->connectSsl();if($Vf){if(!empty($Vf['key']))$B[PDO::MYSQL_ATTR_SSL_KEY]=$Vf['key'];if(!empty($Vf['cert']))$B[PDO::MYSQL_ATTR_SSL_CERT]=$Vf['cert'];if(!empty($Vf['ca']))$B[PDO::MYSQL_ATTR_SSL_CA]=$Vf['ca'];}$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$N)),$V,$E,$B);return
true;}function
set_charset($Ua){$this->query("SET NAMES $Ua");}function
select_db($k){return$this->query("USE ".idf_escape($k));}function
query($F,$Kg=false){$this->pdo->setAttribute(1000,!$Kg);return
parent::query($F,$Kg);}}}class
Min_Driver
extends
Min_SQL{function
insert($R,$O){return($O?parent::insert($R,$O):queries("INSERT INTO ".table($R)." ()\nVALUES ()"));}function
insertUpdate($R,$K,$Ue){$f=array_keys(reset($K));$Te="INSERT INTO ".table($R)." (".implode(", ",$f).") VALUES\n";$Zg=array();foreach($f
as$x)$Zg[$x]="$x = VALUES($x)";$cg="\nON DUPLICATE KEY UPDATE ".implode(", ",$Zg);$Zg=array();$Jd=0;foreach($K
as$O){$Y="(".implode(", ",$O).")";if($Zg&&(strlen($Te)+$Jd+strlen($Y)+strlen($cg)>1e6)){if(!queries($Te.implode(",\n",$Zg).$cg))return
false;$Zg=array();$Jd=0;}$Zg[]=$Y;$Jd+=strlen($Y)+2;}return
queries($Te.implode(",\n",$Zg).$cg);}function
slowQuery($F,$qg){if(min_version('5.7.8','10.1.2')){if(preg_match('~MariaDB~',$this->_conn->server_info))return"SET STATEMENT max_statement_time=$qg FOR $F";elseif(preg_match('~^(SELECT\b)(.+)~is',$F,$_))return"$_[1] /*+ MAX_EXECUTION_TIME(".($qg*1000).") */ $_[2]";}}function
convertSearch($t,$X,$p){return(preg_match('~char|text|enum|set~',$p["type"])&&!preg_match("~^utf8~",$p["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($t USING ".charset($this->_conn).")":$t);}function
warnings(){$H=$this->_conn->query("SHOW WARNINGS");if($H&&$H->num_rows){ob_start();select($H);return
ob_get_clean();}}function
tableHelp($A){$Rd=preg_match('~MariaDB~',$this->_conn->server_info);if(information_schema(DB))return
strtolower(($Rd?"information-schema-$A-table/":str_replace("_","-",$A)."-table.html"));if(DB=="mysql")return($Rd?"mysql$A-table/":"system-database.html");}}function
idf_escape($t){return"`".str_replace("`","``",$t)."`";}function
table($t){return
idf_escape($t);}function
connect(){global$b,$Jg,$Zf;$h=new
Min_DB;$j=$b->credentials();if($h->connect($j[0],$j[1],$j[2])){$h->set_charset(charset($h));$h->query("SET sql_quote_show_create = 1, autocommit = 1");if(min_version('5.7.8',10.2,$h)){$Zf[lang(25)][]="json";$Jg["json"]=4294967295;}return$h;}$I=$h->error;if(function_exists('iconv')&&!is_utf8($I)&&strlen($wf=iconv("windows-1250","utf-8",$I))>strlen($I))$I=$wf;return$I;}function
get_databases($_c){$I=get_session("dbs");if($I===null){$F=(min_version(5)?"SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME":"SHOW DATABASES");$I=($_c?slow_query($F):get_vals($F));restart_session();set_session("dbs",$I);stop_session();}return$I;}function
limit($F,$Z,$y,$qe=0,$M=" "){return" $F$Z".($y!==null?$M."LIMIT $y".($qe?" OFFSET $qe":""):"");}function
limit1($R,$F,$Z,$M="\n"){return
limit($F,$Z,1,0,$M);}function
db_collation($m,$fb){global$h;$I=null;$vb=$h->result("SHOW CREATE DATABASE ".idf_escape($m),1);if(preg_match('~ COLLATE ([^ ]+)~',$vb,$_))$I=$_[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$vb,$_))$I=$fb[$_[1]][-1];return$I;}function
engines(){$I=array();foreach(get_rows("SHOW ENGINES")as$J){if(preg_match("~YES|DEFAULT~",$J["Support"]))$I[]=$J["Engine"];}return$I;}function
logged_user(){global$h;return$h->result("SELECT USER()");}function
tables_list(){return
get_key_vals(min_version(5)?"SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME":"SHOW TABLES");}function
count_tables($l){$I=array();foreach($l
as$m)$I[$m]=count(get_vals("SHOW TABLES IN ".idf_escape($m)));return$I;}function
table_status($A="",$oc=false){$I=array();foreach(get_rows($oc&&min_version(5)?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($A!=""?"AND TABLE_NAME = ".q($A):"ORDER BY Name"):"SHOW TABLE STATUS".($A!=""?" LIKE ".q(addcslashes($A,"%_\\")):""))as$J){if($J["Engine"]=="InnoDB")$J["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$J["Comment"]);if(!isset($J["Engine"]))$J["Comment"]="";if($A!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($S){return$S["Engine"]===null;}function
fk_support($S){return
preg_match('~InnoDB|IBMDB2I~i',$S["Engine"])||(preg_match('~NDB~i',$S["Engine"])&&min_version(5.6));}function
fields($R){$I=array();foreach(get_rows("SHOW FULL COLUMNS FROM ".table($R))as$J){preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$J["Type"],$_);$I[$J["Field"]]=array("field"=>$J["Field"],"full_type"=>$J["Type"],"type"=>$_[1],"length"=>$_[2],"unsigned"=>ltrim($_[3].$_[4]),"default"=>($J["Default"]!=""||preg_match("~char|set~",$_[1])?(preg_match('~text~',$_[1])?stripslashes(preg_replace("~^'(.*)'\$~",'\1',$J["Default"])):$J["Default"]):null),"null"=>($J["Null"]=="YES"),"auto_increment"=>($J["Extra"]=="auto_increment"),"on_update"=>(preg_match('~^on update (.+)~i',$J["Extra"],$_)?$_[1]:""),"collation"=>$J["Collation"],"privileges"=>array_flip(preg_split('~, *~',$J["Privileges"])),"comment"=>$J["Comment"],"primary"=>($J["Key"]=="PRI"),"generated"=>preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$J["Extra"]),);}return$I;}function
indexes($R,$i=null){$I=array();foreach(get_rows("SHOW INDEX FROM ".table($R),$i)as$J){$A=$J["Key_name"];$I[$A]["type"]=($A=="PRIMARY"?"PRIMARY":($J["Index_type"]=="FULLTEXT"?"FULLTEXT":($J["Non_unique"]?($J["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$I[$A]["columns"][]=$J["Column_name"];$I[$A]["lengths"][]=($J["Index_type"]=="SPATIAL"?null:$J["Sub_part"]);$I[$A]["descs"][]=null;}return$I;}function
foreign_keys($R){global$h,$se;static$Me='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$I=array();$wb=$h->result("SHOW CREATE TABLE ".table($R),1);if($wb){preg_match_all("~CONSTRAINT ($Me) FOREIGN KEY ?\\(((?:$Me,? ?)+)\\) REFERENCES ($Me)(?:\\.($Me))? \\(((?:$Me,? ?)+)\\)(?: ON DELETE ($se))?(?: ON UPDATE ($se))?~",$wb,$Ud,PREG_SET_ORDER);foreach($Ud
as$_){preg_match_all("~$Me~",$_[2],$Qf);preg_match_all("~$Me~",$_[5],$jg);$I[idf_unescape($_[1])]=array("db"=>idf_unescape($_[4]!=""?$_[3]:$_[4]),"table"=>idf_unescape($_[4]!=""?$_[4]:$_[3]),"source"=>array_map('idf_unescape',$Qf[0]),"target"=>array_map('idf_unescape',$jg[0]),"on_delete"=>($_[6]?$_[6]:"RESTRICT"),"on_update"=>($_[7]?$_[7]:"RESTRICT"),);}}return$I;}function
view($A){global$h;return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',$h->result("SHOW CREATE VIEW ".table($A),1)));}function
collations(){$I=array();foreach(get_rows("SHOW COLLATION")as$J){if($J["Default"])$I[$J["Charset"]][-1]=$J["Collation"];else$I[$J["Charset"]][]=$J["Collation"];}ksort($I);foreach($I
as$x=>$X)asort($I[$x]);return$I;}function
information_schema($m){return(min_version(5)&&$m=="information_schema")||(min_version(5.5)&&$m=="performance_schema");}function
error(){global$h;return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",$h->error));}function
create_database($m,$d){return
queries("CREATE DATABASE ".idf_escape($m).($d?" COLLATE ".q($d):""));}function
drop_databases($l){$I=apply_queries("DROP DATABASE",$l,'idf_escape');restart_session();set_session("dbs",null);return$I;}function
rename_database($A,$d){$I=false;if(create_database($A,$d)){$mf=array();foreach(tables_list()as$R=>$U)$mf[]=table($R)." TO ".idf_escape($A).".".table($R);$I=(!$mf||queries("RENAME TABLE ".implode(", ",$mf)));if($I)queries("DROP DATABASE ".idf_escape(DB));restart_session();set_session("dbs",null);}return$I;}function
auto_increment(){$Ha=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$u){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$u["columns"],true)){$Ha="";break;}if($u["type"]=="PRIMARY")$Ha=" UNIQUE";}}return" AUTO_INCREMENT$Ha";}function
alter_table($R,$A,$q,$Bc,$jb,$Yb,$d,$Ga,$Je){$c=array();foreach($q
as$p)$c[]=($p[1]?($R!=""?($p[0]!=""?"CHANGE ".idf_escape($p[0]):"ADD"):" ")." ".implode($p[1]).($R!=""?$p[2]:""):"DROP ".idf_escape($p[0]));$c=array_merge($c,$Bc);$P=($jb!==null?" COMMENT=".q($jb):"").($Yb?" ENGINE=".q($Yb):"").($d?" COLLATE ".q($d):"").($Ga!=""?" AUTO_INCREMENT=$Ga":"");if($R=="")return
queries("CREATE TABLE ".table($A)." (\n".implode(",\n",$c)."\n)$P$Je");if($R!=$A)$c[]="RENAME TO ".table($A);if($P)$c[]=ltrim($P);return($c||$Je?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$c).$Je):true);}function
alter_indexes($R,$c){foreach($c
as$x=>$X)$c[$x]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($R).implode(",",$c));}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($dh){return
queries("DROP VIEW ".implode(", ",array_map('table',$dh)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('table',$T)));}function
move_tables($T,$dh,$jg){$mf=array();foreach(array_merge($T,$dh)as$R)$mf[]=table($R)." TO ".idf_escape($jg).".".table($R);return
queries("RENAME TABLE ".implode(", ",$mf));}function
copy_tables($T,$dh,$jg){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($T
as$R){$A=($jg==DB?table("copy_$R"):idf_escape($jg).".".table($R));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $A"))||!queries("CREATE TABLE $A LIKE ".table($R))||!queries("INSERT INTO $A SELECT * FROM ".table($R)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$J){$Eg=$J["Trigger"];if(!queries("CREATE TRIGGER ".($jg==DB?idf_escape("copy_$Eg"):idf_escape($jg).".".idf_escape($Eg))." $J[Timing] $J[Event] ON $A FOR EACH ROW\n$J[Statement];"))return
false;}}foreach($dh
as$R){$A=($jg==DB?table("copy_$R"):idf_escape($jg).".".table($R));$ch=view($R);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $A"))||!queries("CREATE VIEW $A AS $ch[select]"))return
false;}return
true;}function
trigger($A){if($A=="")return
array();$K=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($A));return
reset($K);}function
triggers($R){$I=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$J)$I[$J["Trigger"]]=array($J["Timing"],$J["Event"]);return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($A,$U){global$h,$Zb,$od,$Jg;$xa=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$Rf="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Ig="((".implode("|",array_merge(array_keys($Jg),$xa)).")\\b(?:\\s*\\(((?:[^'\")]|$Zb)++)\\))?\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$Me="$Rf*(".($U=="FUNCTION"?"":$od).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$Ig";$vb=$h->result("SHOW CREATE $U ".idf_escape($A),2);preg_match("~\\(((?:$Me\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$Ig\\s+":"")."(.*)~is",$vb,$_);$q=array();preg_match_all("~$Me\\s*,?~is",$_[1],$Ud,PREG_SET_ORDER);foreach($Ud
as$Ge)$q[]=array("field"=>str_replace("``","`",$Ge[2]).$Ge[3],"type"=>strtolower($Ge[5]),"length"=>preg_replace_callback("~$Zb~s",'normalize_enum',$Ge[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$Ge[8] $Ge[7]"))),"null"=>1,"full_type"=>$Ge[4],"inout"=>strtoupper($Ge[1]),"collation"=>strtolower($Ge[9]),);if($U!="FUNCTION")return
array("fields"=>$q,"definition"=>$_[11]);return
array("fields"=>$q,"returns"=>array("type"=>$_[12],"length"=>$_[13],"unsigned"=>$_[15],"collation"=>$_[16]),"definition"=>$_[17],"language"=>"SQL",);}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = ".q(DB));}function
routine_languages(){return
array();}function
routine_id($A,$J){return
idf_escape($A);}function
last_id(){global$h;return$h->result("SELECT LAST_INSERT_ID()");}function
explain($h,$F){return$h->query("EXPLAIN ".(min_version(5.1)?"PARTITIONS ":"").$F);}function
found_rows($S,$Z){return($Z||$S["Engine"]!="InnoDB"?null:$S["Rows"]);}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($xf,$i=null){return
true;}function
create_sql($R,$Ga,$ag){global$h;$I=$h->result("SHOW CREATE TABLE ".table($R),1);if(!$Ga)$I=preg_replace('~ AUTO_INCREMENT=\d+~','',$I);return$I;}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
use_sql($k){return"USE ".idf_escape($k);}function
trigger_sql($R){$I="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")),null,"-- ")as$J)$I.="\nCREATE TRIGGER ".idf_escape($J["Trigger"])." $J[Timing] $J[Event] ON ".table($J["Table"])." FOR EACH ROW\n$J[Statement];;\n";return$I;}function
show_variables(){return
get_key_vals("SHOW VARIABLES");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
show_status(){return
get_key_vals("SHOW STATUS");}function
convert_field($p){if(preg_match("~binary~",$p["type"]))return"HEX(".idf_escape($p["field"]).")";if($p["type"]=="bit")return"BIN(".idf_escape($p["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$p["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($p["field"]).")";}function
unconvert_field($p,$I){if(preg_match("~binary~",$p["type"]))$I="UNHEX($I)";if($p["type"]=="bit")$I="CONV($I, 2, 10) + 0";if(preg_match("~geometry|point|linestring|polygon~",$p["type"]))$I=(min_version(8)?"ST_":"")."GeomFromText($I, SRID($p[field]))";return$I;}function
support($pc){return!preg_match("~scheme|sequence|type|view_trigger|materializedview".(min_version(8)?"":"|descidx".(min_version(5.1)?"":"|event|partitioning".(min_version(5)?"":"|routine|trigger|view")))."~",$pc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){global$h;return$h->result("SELECT @@max_connections");}$w="sql";$Jg=array();$Zf=array();foreach(array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(28)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(25)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(34)=>array("enum"=>65535,"set"=>64),lang(29)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(31)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),)as$x=>$X){$Jg+=$X;$Zf[$x]=array_keys($X);}$Qg=array("unsigned","zerofill","unsigned zerofill");$xe=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");$Lc=array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper");$Pc=array("avg","count","count distinct","group_concat","max","min","sum");$Rb=array(array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",),array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",));}define("SERVER",$_GET[DRIVER]);define("DB",$_GET["db"]);define("ME",preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));$ca="4.7.9";class
Adminer{var$operators=array("<=",">=");var$_values=array();function
name(){return"<a href='https://www.adminer.org/editor/'".target_blank()." id='h1'>".lang(35)."</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($vb=false){return
password_file($vb);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($N){}function
database(){global$h;if($h){$l=$this->databases(false);return(!$l?$h->result("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1)"):$l[(information_schema($l[0])?1:0)]);}}function
schemas(){return
schemas();}function
databases($_c=true){return
get_databases($_c);}function
queryTimeout(){return
5;}function
headers(){}function
csp(){return
csp();}function
head(){return
true;}function
css(){$I=array();$tc="adminer.css";if(file_exists($tc))$I[]=$tc;return$I;}function
loginForm(){echo"<table cellspacing='0' class='layout'>\n",$this->loginFormField('username','<tr><th>'.lang(36).'<td>','<input type="hidden" name="auth[driver]" value="server"><input name="auth[username]" id="username" value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("focus(qs('#username'));")),$this->loginFormField('password','<tr><th>'.lang(37).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'."\n"),"</table>\n","<p><input type='submit' value='".lang(38)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(39))."\n";}function
loginFormField($A,$Wc,$Y){return$Wc.$Y;}function
login($Od,$E){return
true;}function
tableName($fg){return
h($fg["Comment"]!=""?$fg["Comment"]:$fg["Name"]);}function
fieldName($p,$_e=0){return
h(preg_replace('~\s+\[.*\]$~','',($p["comment"]!=""?$p["comment"]:$p["field"])));}function
selectLinks($fg,$O=""){$a=$fg["Name"];if($O!==null)echo'<p class="tabs"><a href="'.h(ME.'edit='.urlencode($a).$O).'">'.lang(40)."</a>\n";}function
foreignKeys($R){return
foreign_keys($R);}function
backwardKeys($R,$eg){$I=array();foreach(get_rows("SELECT TABLE_NAME, CONSTRAINT_NAME, COLUMN_NAME, REFERENCED_COLUMN_NAME
FROM information_schema.KEY_COLUMN_USAGE
WHERE TABLE_SCHEMA = ".q($this->database())."
AND REFERENCED_TABLE_SCHEMA = ".q($this->database())."
AND REFERENCED_TABLE_NAME = ".q($R)."
ORDER BY ORDINAL_POSITION",null,"")as$J)$I[$J["TABLE_NAME"]]["keys"][$J["CONSTRAINT_NAME"]][$J["COLUMN_NAME"]]=$J["REFERENCED_COLUMN_NAME"];foreach($I
as$x=>$X){$A=$this->tableName(table_status($x,true));if($A!=""){$zf=preg_quote($eg);$M="(:|\\s*-)?\\s+";$I[$x]["name"]=(preg_match("(^$zf$M(.+)|^(.+?)$M$zf\$)iu",$A,$_)?$_[2].$_[3]:$A);}else
unset($I[$x]);}return$I;}function
backwardKeysPrint($Ka,$J){foreach($Ka
as$R=>$Ja){foreach($Ja["keys"]as$hb){$z=ME.'select='.urlencode($R);$r=0;foreach($hb
as$e=>$X)$z.=where_link($r++,$e,$J[$X]);echo"<a href='".h($z)."'>".h($Ja["name"])."</a>";$z=ME.'edit='.urlencode($R);foreach($hb
as$e=>$X)$z.="&set".urlencode("[".bracket_escape($e)."]")."=".urlencode($J[$X]);echo"<a href='".h($z)."' title='".lang(40)."'>+</a> ";}}}function
selectQuery($F,$Wf,$nc=false){return"<!--\n".str_replace("--","--><!-- ",$F)."\n(".format_time($Wf).")\n-->\n";}function
rowDescription($R){foreach(fields($R)as$p){if(preg_match("~varchar|character varying~",$p["type"]))return
idf_escape($p["field"]);}return"";}function
rowDescriptions($K,$Dc){$I=$K;foreach($K[0]as$x=>$X){if(list($R,$s,$A)=$this->_foreignColumn($Dc,$x)){$dd=array();foreach($K
as$J)$dd[$J[$x]]=q($J[$x]);$Gb=$this->_values[$R];if(!$Gb)$Gb=get_key_vals("SELECT $s, $A FROM ".table($R)." WHERE $s IN (".implode(", ",$dd).")");foreach($K
as$he=>$J){if(isset($J[$x]))$I[$he][$x]=(string)$Gb[$J[$x]];}}}return$I;}function
selectLink($X,$p){}function
selectVal($X,$z,$p,$Be){$I=$X;$z=h($z);if(preg_match('~blob|bytea~',$p["type"])&&!is_utf8($X)){$I=lang(41,strlen($Be));if(preg_match("~^(GIF|\xFF\xD8\xFF|\x89PNG\x0D\x0A\x1A\x0A)~",$Be))$I="<img src='$z' alt='$I'>";}if(like_bool($p)&&$I!="")$I=(preg_match('~^(1|t|true|y|yes|on)$~i',$X)?lang(42):lang(43));if($z)$I="<a href='$z'".(is_url($z)?target_blank():"").">$I</a>";if(!$z&&!like_bool($p)&&preg_match(number_type(),$p["type"]))$I="<div class='number'>$I</div>";elseif(preg_match('~date~',$p["type"]))$I="<div class='datetime'>$I</div>";return$I;}function
editVal($X,$p){if(preg_match('~date|timestamp~',$p["type"])&&$X!==null)return
preg_replace('~^(\d{2}(\d+))-(0?(\d+))-(0?(\d+))~',lang(44),$X);return$X;}function
selectColumnsPrint($L,$f){}function
selectSearchPrint($Z,$f,$v){$Z=(array)$_GET["where"];echo'<fieldset id="fieldset-search"><legend>'.lang(45)."</legend><div>\n";$Ad=array();foreach($Z
as$x=>$X)$Ad[$X["col"]]=$x;$r=0;$q=fields($_GET["select"]);foreach($f
as$A=>$Fb){$p=$q[$A];if(preg_match("~enum~",$p["type"])||like_bool($p)){$x=$Ad[$A];$r--;echo"<div>".h($Fb)."<input type='hidden' name='where[$r][col]' value='".h($A)."'>:",(like_bool($p)?" <select name='where[$r][val]'>".optionlist(array(""=>"",lang(43),lang(42)),$Z[$x]["val"],true)."</select>":enum_input("checkbox"," name='where[$r][val][]'",$p,(array)$Z[$x]["val"],($p["null"]?0:null))),"</div>\n";unset($f[$A]);}elseif(is_array($B=$this->_foreignKeyOptions($_GET["select"],$A))){if($q[$A]["null"])$B[0]='('.lang(7).')';$x=$Ad[$A];$r--;echo"<div>".h($Fb)."<input type='hidden' name='where[$r][col]' value='".h($A)."'><input type='hidden' name='where[$r][op]' value='='>: <select name='where[$r][val]'>".optionlist($B,$Z[$x]["val"],true)."</select></div>\n";unset($f[$A]);}}$r=0;foreach($Z
as$X){if(($X["col"]==""||$f[$X["col"]])&&"$X[col]$X[val]"!=""){echo"<div><select name='where[$r][col]'><option value=''>(".lang(46).")".optionlist($f,$X["col"],true)."</select>",html_select("where[$r][op]",array(-1=>"")+$this->operators,$X["op"]),"<input type='search' name='where[$r][val]' value='".h($X["val"])."'>".script("mixin(qsl('input'), {onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});","")."</div>\n";$r++;}}echo"<div><select name='where[$r][col]'><option value=''>(".lang(46).")".optionlist($f,null,true)."</select>",script("qsl('select').onchange = selectAddRow;",""),html_select("where[$r][op]",array(-1=>"")+$this->operators),"<input type='search' name='where[$r][val]'></div>",script("mixin(qsl('input'), {onchange: function () { this.parentNode.firstChild.onchange(); }, onsearch: selectSearchSearch});"),"</div></fieldset>\n";}function
selectOrderPrint($_e,$f,$v){$Ae=array();foreach($v
as$x=>$u){$_e=array();foreach($u["columns"]as$X)$_e[]=$f[$X];if(count(array_filter($_e,'strlen'))>1&&$x!="PRIMARY")$Ae[$x]=implode(", ",$_e);}if($Ae){echo'<fieldset><legend>'.lang(47)."</legend><div>","<select name='index_order'>".optionlist(array(""=>"")+$Ae,($_GET["order"][0]!=""?"":$_GET["index_order"]),true)."</select>","</div></fieldset>\n";}if($_GET["order"])echo"<div style='display: none;'>".hidden_fields(array("order"=>array(1=>reset($_GET["order"])),"desc"=>($_GET["desc"]?array(1=>1):array()),))."</div>\n";}function
selectLimitPrint($y){echo"<fieldset><legend>".lang(48)."</legend><div>";echo
html_select("limit",array("","50","100"),$y),"</div></fieldset>\n";}function
selectLengthPrint($ng){}function
selectActionPrint($v){echo"<fieldset><legend>".lang(49)."</legend><div>","<input type='submit' value='".lang(50)."'>","</div></fieldset>\n";}function
selectCommandPrint(){return
true;}function
selectImportPrint(){return
true;}function
selectEmailPrint($Vb,$f){if($Vb){print_fieldset("email",lang(51),$_POST["email_append"]);echo"<div>",script("qsl('div').onkeydown = partialArg(bodyKeydown, 'email');"),"<p>".lang(52).": <input name='email_from' value='".h($_POST?$_POST["email_from"]:$_COOKIE["adminer_email"])."'>\n",lang(53).": <input name='email_subject' value='".h($_POST["email_subject"])."'>\n","<p><textarea name='email_message' rows='15' cols='75'>".h($_POST["email_message"].($_POST["email_append"]?'{$'."$_POST[email_addition]}":""))."</textarea>\n","<p>".script("qsl('p').onkeydown = partialArg(bodyKeydown, 'email_append');","").html_select("email_addition",$f,$_POST["email_addition"])."<input type='submit' name='email_append' value='".lang(11)."'>\n";echo"<p>".lang(54).": <input type='file' name='email_files[]'>".script("qsl('input').onchange = emailFileChange;"),"<p>".(count($Vb)==1?'<input type="hidden" name="email_field" value="'.h(key($Vb)).'">':html_select("email_field",$Vb)),"<input type='submit' name='email' value='".lang(55)."'>".confirm(),"</div>\n","</div></fieldset>\n";}}function
selectColumnsProcess($f,$v){return
array(array(),array());}function
selectSearchProcess($q,$v){global$n;$I=array();foreach((array)$_GET["where"]as$x=>$Z){$eb=$Z["col"];$ve=$Z["op"];$X=$Z["val"];if(($x<0?"":$eb).$X!=""){$lb=array();foreach(($eb!=""?array($eb=>$q[$eb]):$q)as$A=>$p){if($eb!=""||is_numeric($X)||!preg_match(number_type(),$p["type"])){$A=idf_escape($A);if($eb!=""&&$p["type"]=="enum")$lb[]=(in_array(0,$X)?"$A IS NULL OR ":"")."$A IN (".implode(", ",array_map('intval',$X)).")";else{$og=preg_match('~char|text|enum|set~',$p["type"]);$Y=$this->processInput($p,(!$ve&&$og&&preg_match('~^[^%]+$~',$X)?"%$X%":$X));$lb[]=$n->convertSearch($A,$X,$p).($Y=="NULL"?" IS".($ve==">="?" NOT":"")." $Y":(in_array($ve,$this->operators)||$ve=="="?" $ve $Y":($og?" LIKE $Y":" IN (".str_replace(",","', '",$Y).")")));if($x<0&&$X=="0")$lb[]="$A IS NULL";}}}$I[]=($lb?"(".implode(" OR ",$lb).")":"1 = 0");}}return$I;}function
selectOrderProcess($q,$v){$gd=$_GET["index_order"];if($gd!="")unset($_GET["order"][1]);if($_GET["order"])return
array(idf_escape(reset($_GET["order"])).($_GET["desc"]?" DESC":""));foreach(($gd!=""?array($v[$gd]):$v)as$u){if($gd!=""||$u["type"]=="INDEX"){$Rc=array_filter($u["descs"]);$Fb=false;foreach($u["columns"]as$X){if(preg_match('~date|timestamp~',$q[$X]["type"])){$Fb=true;break;}}$I=array();foreach($u["columns"]as$x=>$X)$I[]=idf_escape($X).(($Rc?$u["descs"][$x]:$Fb)?" DESC":"");return$I;}}return
array();}function
selectLimitProcess(){return(isset($_GET["limit"])?$_GET["limit"]:"50");}function
selectLengthProcess(){return"100";}function
selectEmailProcess($Z,$Dc){if($_POST["email_append"])return
true;if($_POST["email"]){$Df=0;if($_POST["all"]||$_POST["check"]){$p=idf_escape($_POST["email_field"]);$bg=$_POST["email_subject"];$ae=$_POST["email_message"];preg_match_all('~\{\$([a-z0-9_]+)\}~i',"$bg.$ae",$Ud);$K=get_rows("SELECT DISTINCT $p".($Ud[1]?", ".implode(", ",array_map('idf_escape',array_unique($Ud[1]))):"")." FROM ".table($_GET["select"])." WHERE $p IS NOT NULL AND $p != ''".($Z?" AND ".implode(" AND ",$Z):"").($_POST["all"]?"":" AND ((".implode(") OR (",array_map('where_check',(array)$_POST["check"]))."))"));$q=fields($_GET["select"]);foreach($this->rowDescriptions($K,$Dc)as$J){$nf=array('{\\'=>'{');foreach($Ud[1]as$X)$nf['{$'."$X}"]=$this->editVal($J[$X],$q[$X]);$Ub=$J[$_POST["email_field"]];if(is_mail($Ub)&&send_mail($Ub,strtr($bg,$nf),strtr($ae,$nf),$_POST["email_from"],$_FILES["email_files"]))$Df++;}}cookie("adminer_email",$_POST["email_from"]);redirect(remove_from_uri(),lang(56,$Df));}return
false;}function
selectQueryBuild($L,$Z,$Mc,$_e,$y,$C){return"";}function
messageQuery($F,$pg,$nc=false){return" <span class='time'>".@date("H:i:s")."</span><!--\n".str_replace("--","--><!-- ",$F)."\n".($pg?"($pg)\n":"")."-->";}function
editFunctions($p){$I=array();if($p["null"]&&preg_match('~blob~',$p["type"]))$I["NULL"]=lang(7);$I[""]=($p["null"]||$p["auto_increment"]||like_bool($p)?"":"*");if(preg_match('~date|time~',$p["type"]))$I["now"]=lang(57);if(preg_match('~_(md5|sha1)$~i',$p["field"],$_))$I[]=strtolower($_[1]);return$I;}function
editInput($R,$p,$Da,$Y){if($p["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$Da value='-1' checked><i>".lang(8)."</i></label> ":"").enum_input("radio",$Da,$p,($Y||isset($_GET["select"])?$Y:0),($p["null"]?"":null));$B=$this->_foreignKeyOptions($R,$p["field"],$Y);if($B!==null)return(is_array($B)?"<select$Da>".optionlist($B,$Y,true)."</select>":"<input value='".h($Y)."'$Da class='hidden'>"."<input value='".h($B)."' class='jsonly'>"."<div></div>".script("qsl('input').oninput = partial(whisper, '".ME."script=complete&source=".urlencode($R)."&field=".urlencode($p["field"])."&value=');
qsl('div').onclick = whisperClick;",""));if(like_bool($p))return'<input type="checkbox" value="1"'.(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?' checked':'')."$Da>";$Xc="";if(preg_match('~time~',$p["type"]))$Xc=lang(58);if(preg_match('~date|timestamp~',$p["type"]))$Xc=lang(59).($Xc?" [$Xc]":"");if($Xc)return"<input value='".h($Y)."'$Da> ($Xc)";if(preg_match('~_(md5|sha1)$~i',$p["field"]))return"<input type='password' value='".h($Y)."'$Da>";return'';}function
editHint($R,$p,$Y){return(preg_match('~\s+(\[.*\])$~',($p["comment"]!=""?$p["comment"]:$p["field"]),$_)?h(" $_[1]"):'');}function
processInput($p,$Y,$Kc=""){if($Kc=="now")return"$Kc()";$I=$Y;if(preg_match('~date|timestamp~',$p["type"])&&preg_match('(^'.str_replace('\$1','(?P<p1>\d*)',preg_replace('~(\\\\\\$([2-6]))~','(?P<p\2>\d{1,2})',preg_quote(lang(44)))).'(.*))',$Y,$_))$I=($_["p1"]!=""?$_["p1"]:($_["p2"]!=""?($_["p2"]<70?20:19).$_["p2"]:gmdate("Y")))."-$_[p3]$_[p4]-$_[p5]$_[p6]".end($_);$I=($p["type"]=="bit"&&preg_match('~^[0-9]+$~',$Y)?$I:q($I));if($Y==""&&like_bool($p))$I="'0'";elseif($Y==""&&($p["null"]||!preg_match('~char|text~',$p["type"])))$I="NULL";elseif(preg_match('~^(md5|sha1)$~',$Kc))$I="$Kc($I)";return
unconvert_field($p,$I);}function
dumpOutput(){return
array();}function
dumpFormat(){return
array('csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($m){}function
dumpTable($R,$ag,$vd=0){echo"\xef\xbb\xbf";}function
dumpData($R,$ag,$F){global$h;$H=$h->query($F,1);if($H){while($J=$H->fetch_assoc()){if($ag=="table"){dump_csv(array_keys($J));$ag="INSERT";}dump_csv($J);}}}function
dumpFilename($bd){return
friendly_url($bd);}function
dumpHeaders($bd,$fe=false){$jc="csv";header("Content-Type: text/csv; charset=utf-8");return$jc;}function
importServerPath(){}function
homepage(){return
true;}function
navigation($ee){global$ca;echo'<h1>
',$this->name(),' <span class="version">',$ca,'</span>
<a href="https://www.adminer.org/editor/#download"',target_blank(),' id="version">',(version_compare($ca,$_COOKIE["adminer_version"])<0?h($_COOKIE["adminer_version"]):""),'</a>
</h1>
';if($ee=="auth"){$wc=true;foreach((array)$_SESSION["pwds"]as$ah=>$If){foreach($If[""]as$V=>$E){if($E!==null){if($wc){echo"<ul id='logins'>",script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");$wc=false;}echo"<li><a href='".h(auth_url($ah,"",$V))."'>".($V!=""?h($V):"<i>".lang(7)."</i>")."</a>\n";}}}}else{$this->databasesPrint($ee);if($ee!="db"&&$ee!="ns"){$S=table_status('',true);if(!$S)echo"<p class='message'>".lang(9)."\n";else$this->tablesPrint($S);}}}function
databasesPrint($ee){}function
tablesPrint($T){echo"<ul id='tables'>",script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($T
as$J){echo'<li>';$A=$this->tableName($J);if(isset($J["Engine"])&&$A!="")echo"<a href='".h(ME).'select='.urlencode($J["Name"])."'".bold($_GET["select"]==$J["Name"]||$_GET["edit"]==$J["Name"],"select")." title='".lang(60)."'>$A</a>\n";}echo"</ul>\n";}function
_foreignColumn($Dc,$e){foreach((array)$Dc[$e]as$Cc){if(count($Cc["source"])==1){$A=$this->rowDescription($Cc["table"]);if($A!=""){$s=idf_escape($Cc["target"][0]);return
array($Cc["table"],$s,$A);}}}}function
_foreignKeyOptions($R,$e,$Y=null){global$h;if(list($jg,$s,$A)=$this->_foreignColumn(column_foreign_keys($R),$e)){$I=&$this->_values[$jg];if($I===null){$S=table_status($jg);$I=($S["Rows"]>1000?"":array(""=>"")+get_key_vals("SELECT $s, $A FROM ".table($jg)." ORDER BY 2"));}if(!$I&&$Y!==null)return$h->result("SELECT $A FROM ".table($jg)." WHERE $s = ".q($Y));return$I;}}}$b=(function_exists('adminer_object')?adminer_object():new
Adminer);function
page_header($sg,$o="",$Sa=array(),$tg=""){global$ba,$ca,$b,$Mb,$w;page_headers();if(is_ajax()&&$o){page_messages($o);exit;}$ug=$sg.($tg!=""?": $tg":"");$vg=strip_tags($ug.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".$b->name());echo'<!DOCTYPE html>
<html lang="',$ba,'" dir="',lang(61),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<title>',$vg,'</title>
<link rel="stylesheet" type="text/css" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=4.7.9"),'">
',script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=4.7.9");if($b->head()){echo'<link rel="shortcut icon" type="image/x-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.7.9"),'">
<link rel="apple-touch-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.7.9"),'">
';foreach($b->css()as$yb){echo'<link rel="stylesheet" type="text/css" href="',h($yb),'">
';}}echo'
<body class="',lang(61),' nojs">
';$tc=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($tc)&&filemtime($tc)+86400>time()){$bh=unserialize(file_get_contents($tc));$af="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($bh["version"],base64_decode($bh["signature"]),$af)==1)$_COOKIE["adminer_version"]=$bh["version"];}echo'<script',nonce(),'>
mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick',(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '$ca', '".js_escape(ME)."', '".get_token()."')");?>});
document.body.className = document.body.className.replace(/ nojs/, ' js');
var offlineMessage = '<?php echo
js_escape(lang(62)),'\';
var thousandsSeparator = \'',js_escape(lang(5)),'\';
</script>

<div id="help" class="jush-',$w,' jsonly hidden"></div>
',script("mixin(qs('#help'), {onmouseover: function () { helpOpen = 1; }, onmouseout: helpMouseout});"),'
<div id="content">
';if($Sa!==null){$z=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($z?$z:".").'">'.$Mb[DRIVER].'</a> &raquo; ';$z=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$N=$b->serverName(SERVER);$N=($N!=""?$N:lang(63));if($Sa===false)echo"$N\n";else{echo"<a href='".h($z)."' accesskey='1' title='Alt+Shift+1'>$N</a> &raquo; ";if($_GET["ns"]!=""||(DB!=""&&is_array($Sa)))echo'<a href="'.h($z."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> &raquo; ';if(is_array($Sa)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> &raquo; ';foreach($Sa
as$x=>$X){$Fb=(is_array($X)?$X[1]:h($X));if($Fb!="")echo"<a href='".h(ME."$x=").urlencode(is_array($X)?$X[0]:$X)."'>$Fb</a> &raquo; ";}}echo"$sg\n";}}echo"<h2>$ug</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($o);$l=&get_session("dbs");if(DB!=""&&$l&&!in_array(DB,$l,true))$l=null;stop_session();define("PAGE_HEADER",1);}function
page_headers(){global$b;header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach($b->csp()as$xb){$Uc=array();foreach($xb
as$x=>$X)$Uc[]="$x $X";header("Content-Security-Policy: ".implode("; ",$Uc));}$b->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$le;if(!$le)$le=base64_encode(rand_string());return$le;}function
page_messages($o){$Sg=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$be=$_SESSION["messages"][$Sg];if($be){echo"<div class='message'>".implode("</div>\n<div class='message'>",$be)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$Sg]);}if($o)echo"<div class='error'>$o</div>\n";}function
page_footer($ee=""){global$b,$yg;echo'</div>

';switch_lang();if($ee!="auth"){echo'<form action="" method="post">
<p class="logout">
<input type="submit" name="logout" value="',lang(64),'" id="logout">
<input type="hidden" name="token" value="',$yg,'">
</p>
</form>
';}echo'<div id="menu">
';$b->navigation($ee);echo'</div>
',script("setupSubmitHighlight(document);");}function
int32($he){while($he>=2147483648)$he-=4294967296;while($he<=-2147483649)$he+=4294967296;return(int)$he;}function
long2str($W,$fh){$wf='';foreach($W
as$X)$wf.=pack('V',$X);if($fh)return
substr($wf,0,end($W));return$wf;}function
str2long($wf,$fh){$W=array_values(unpack('V*',str_pad($wf,4*ceil(strlen($wf)/4),"\0")));if($fh)$W[]=strlen($wf);return$W;}function
xxtea_mx($qh,$ph,$dg,$xd){return
int32((($qh>>5&0x7FFFFFF)^$ph<<2)+(($ph>>3&0x1FFFFFFF)^$qh<<4))^int32(($dg^$ph)+($xd^$qh));}function
encrypt_string($Yf,$x){if($Yf=="")return"";$x=array_values(unpack("V*",pack("H*",md5($x))));$W=str2long($Yf,true);$he=count($W)-1;$qh=$W[$he];$ph=$W[0];$bf=floor(6+52/($he+1));$dg=0;while($bf-->0){$dg=int32($dg+0x9E3779B9);$Qb=$dg>>2&3;for($Ee=0;$Ee<$he;$Ee++){$ph=$W[$Ee+1];$ge=xxtea_mx($qh,$ph,$dg,$x[$Ee&3^$Qb]);$qh=int32($W[$Ee]+$ge);$W[$Ee]=$qh;}$ph=$W[0];$ge=xxtea_mx($qh,$ph,$dg,$x[$Ee&3^$Qb]);$qh=int32($W[$he]+$ge);$W[$he]=$qh;}return
long2str($W,false);}function
decrypt_string($Yf,$x){if($Yf=="")return"";if(!$x)return
false;$x=array_values(unpack("V*",pack("H*",md5($x))));$W=str2long($Yf,false);$he=count($W)-1;$qh=$W[$he];$ph=$W[0];$bf=floor(6+52/($he+1));$dg=int32($bf*0x9E3779B9);while($dg){$Qb=$dg>>2&3;for($Ee=$he;$Ee>0;$Ee--){$qh=$W[$Ee-1];$ge=xxtea_mx($qh,$ph,$dg,$x[$Ee&3^$Qb]);$ph=int32($W[$Ee]-$ge);$W[$Ee]=$ph;}$qh=$W[$he];$ge=xxtea_mx($qh,$ph,$dg,$x[$Ee&3^$Qb]);$ph=int32($W[0]-$ge);$W[0]=$ph;$dg=int32($dg-0x9E3779B9);}return
long2str($W,true);}$h='';$Tc=$_SESSION["token"];if(!$Tc)$_SESSION["token"]=rand(1,1e6);$yg=get_token();$Oe=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($x)=explode(":",$X);$Oe[$x]=$X;}}function
add_invalid_login(){global$b;$Ic=file_open_lock(get_temp_dir()."/adminer.invalid");if(!$Ic)return;$sd=unserialize(stream_get_contents($Ic));$pg=time();if($sd){foreach($sd
as$td=>$X){if($X[0]<$pg)unset($sd[$td]);}}$rd=&$sd[$b->bruteForceKey()];if(!$rd)$rd=array($pg+30*60,0);$rd[1]++;file_write_unlock($Ic,serialize($sd));}function
check_invalid_login(){global$b;$sd=unserialize(@file_get_contents(get_temp_dir()."/adminer.invalid"));$rd=$sd[$b->bruteForceKey()];$ke=($rd[1]>29?$rd[0]-time():0);if($ke>0)auth_error(lang(65,ceil($ke/60)));}$Ea=$_POST["auth"];if($Ea){session_regenerate_id();$ah=$Ea["driver"];$N=$Ea["server"];$V=$Ea["username"];$E=(string)$Ea["password"];$m=$Ea["db"];set_password($ah,$N,$V,$E);$_SESSION["db"][$ah][$N][$V][$m]=true;if($Ea["permanent"]){$x=base64_encode($ah)."-".base64_encode($N)."-".base64_encode($V)."-".base64_encode($m);$Xe=$b->permanentLogin(true);$Oe[$x]="$x:".base64_encode($Xe?encrypt_string($E,$Xe):"");cookie("adminer_permanent",implode(" ",$Oe));}if(count($_POST)==1||DRIVER!=$ah||SERVER!=$N||$_GET["username"]!==$V||DB!=$m)redirect(auth_url($ah,$N,$V,$m));}elseif($_POST["logout"]&&(!$Tc||verify_token())){foreach(array("pwds","db","dbs","queries")as$x)set_session($x,null);unset_permanent();redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(66).' '.lang(67));}elseif($Oe&&!$_SESSION["pwds"]){session_regenerate_id();$Xe=$b->permanentLogin();foreach($Oe
as$x=>$X){list(,$ab)=explode(":",$X);list($ah,$N,$V,$m)=array_map('base64_decode',explode("-",$x));set_password($ah,$N,$V,decrypt_string(base64_decode($ab),$Xe));$_SESSION["db"][$ah][$N][$V][$m]=true;}}function
unset_permanent(){global$Oe;foreach($Oe
as$x=>$X){list($ah,$N,$V,$m)=array_map('base64_decode',explode("-",$x));if($ah==DRIVER&&$N==SERVER&&$V==$_GET["username"]&&$m==DB)unset($Oe[$x]);}cookie("adminer_permanent",implode(" ",$Oe));}function
auth_error($o){global$b,$Tc;$Jf=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$Jf]||$_GET[$Jf])&&!$Tc)$o=lang(68);else{restart_session();add_invalid_login();$E=get_password();if($E!==null){if($E===false)$o.='<br>'.lang(69,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent();}}if(!$_COOKIE[$Jf]&&$_GET[$Jf]&&ini_bool("session.use_only_cookies"))$o=lang(70);$D=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?$_COOKIE["adminer_key"]:rand_string()),$D["lifetime"]);page_header(lang(38),$o,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(71)."\n";echo"</div>\n";$b->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists("Min_DB")){unset($_SESSION["pwds"][DRIVER]);unset_permanent();page_header(lang(72),lang(73,implode(", ",$Se)),false);page_footer("auth");exit;}stop_session(true);if(isset($_GET["username"])&&is_string(get_password())){list($Zc,$Qe)=explode(":",SERVER,2);if(preg_match('~^\s*([-+]?\d+)~',$Qe,$_)&&($_[1]<1024||$_[1]>65535))auth_error(lang(74));check_invalid_login();$h=connect();$n=new
Min_Driver($h);}$Od=null;if(!is_object($h)||($Od=$b->login($_GET["username"],get_password()))!==true){$o=(is_string($h)?h($h):(is_string($Od)?$Od:lang(32)));auth_error($o.(preg_match('~^ | $~',get_password())?'<br>'.lang(75):''));}if($_POST["logout"]&&$Tc&&!verify_token()){page_header(lang(64),lang(76));page_footer("db");exit;}if($Ea&&$_POST["token"])$_POST["token"]=$yg;$o='';if($_POST){if(!verify_token()){$nd="max_input_vars";$Yd=ini_get($nd);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$x){$X=ini_get($x);if($X&&(!$Yd||$X<$Yd)){$nd=$x;$Yd=$X;}}}$o=(!$_POST["token"]&&$Yd?lang(77,"'$nd'"):lang(76).' '.lang(78));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$o=lang(79,"'post_max_size'");if(isset($_GET["sql"]))$o.=' '.lang(80);}function
email_header($Uc){return"=?UTF-8?B?".base64_encode($Uc)."?=";}function
send_mail($Ub,$bg,$ae,$Jc="",$uc=array()){$ac=(DIRECTORY_SEPARATOR=="/"?"\n":"\r\n");$ae=str_replace("\n",$ac,wordwrap(str_replace("\r","","$ae\n")));$Ra=uniqid("boundary");$Ba="";foreach((array)$uc["error"]as$x=>$X){if(!$X)$Ba.="--$Ra$ac"."Content-Type: ".str_replace("\n","",$uc["type"][$x]).$ac."Content-Disposition: attachment; filename=\"".preg_replace('~["\n]~','',$uc["name"][$x])."\"$ac"."Content-Transfer-Encoding: base64$ac$ac".chunk_split(base64_encode(file_get_contents($uc["tmp_name"][$x])),76,$ac).$ac;}$Ma="";$Vc="Content-Type: text/plain; charset=utf-8$ac"."Content-Transfer-Encoding: 8bit";if($Ba){$Ba.="--$Ra--$ac";$Ma="--$Ra$ac$Vc$ac$ac";$Vc="Content-Type: multipart/mixed; boundary=\"$Ra\"";}$Vc.=$ac."MIME-Version: 1.0$ac"."X-Mailer: Adminer Editor".($Jc?$ac."From: ".str_replace("\n","",$Jc):"");return
mail($Ub,email_header($bg),$Ma.$ae.$Ba,$Vc);}function
like_bool($p){return
preg_match("~bool|(tinyint|bit)\\(1\\)~",$p["full_type"]);}$h->select_db($b->database());$se="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";$Mb[DRIVER]=lang(38);if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["download"])){$a=$_GET["download"];$q=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$L=array(idf_escape($_GET["field"]));$H=$n->select($a,$L,array(where($_GET,$q)),$L);$J=($H?$H->fetch_row():array());echo$n->value($J[0],$q[$_GET["field"]]);exit;}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$q=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$q):""):where($_GET,$q));$Rg=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($q
as$A=>$p){if(!isset($p["privileges"][$Rg?"update":"insert"])||$b->fieldName($p)==""||$p["generated"])unset($q[$A]);}if($_POST&&!$o&&!isset($_GET["select"])){$Nd=$_POST["referer"];if($_POST["insert"])$Nd=($Rg?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$Nd))$Nd=ME."select=".urlencode($a);$v=indexes($a);$Mg=unique_array($_GET["where"],$v);$df="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($Nd,lang(81),$n->delete($a,$df,!$Mg));else{$O=array();foreach($q
as$A=>$p){$X=process_input($p);if($X!==false&&$X!==null)$O[idf_escape($A)]=$X;}if($Rg){if(!$O)redirect($Nd);queries_redirect($Nd,lang(82),$n->update($a,$O,$df,!$Mg));if(is_ajax()){page_headers();page_messages($o);exit;}}else{$H=$n->insert($a,$O);$Hd=($H?last_id():0);queries_redirect($Nd,lang(83,($Hd?" $Hd":"")),$H);}}}$J=null;if($_POST["save"])$J=(array)$_POST["fields"];elseif($Z){$L=array();foreach($q
as$A=>$p){if(isset($p["privileges"]["select"])){$_a=convert_field($p);if($_POST["clone"]&&$p["auto_increment"])$_a="''";if($w=="sql"&&preg_match("~enum|set~",$p["type"]))$_a="1*".idf_escape($A);$L[]=($_a?"$_a AS ":"").idf_escape($A);}}$J=array();if(!support("table"))$L=array("*");if($L){$H=$n->select($a,$L,array($Z),$L,array(),(isset($_GET["select"])?2:1));if(!$H)$o=error();else{$J=$H->fetch_assoc();if(!$J)$J=false;}if(isset($_GET["select"])&&(!$J||$H->fetch_assoc()))$J=null;}}if(!support("table")&&!$q){if(!$Z){$H=$n->select($a,array("*"),$Z,array("*"));$J=($H?$H->fetch_assoc():false);if(!$J)$J=array($n->primary=>"");}if($J){foreach($J
as$x=>$X){if(!$Z)$J[$x]=null;$q[$x]=array("field"=>$x,"null"=>($x!=$n->primary),"auto_increment"=>($x==$n->primary));}}}edit_form($a,$q,$J,$Rg);}elseif(isset($_GET["select"])){$a=$_GET["select"];$S=table_status1($a);$v=indexes($a);$q=fields($a);$Fc=column_foreign_keys($a);$re=$S["Oid"];parse_str($_COOKIE["adminer_import"],$ta);$uf=array();$f=array();$ng=null;foreach($q
as$x=>$p){$A=$b->fieldName($p);if(isset($p["privileges"]["select"])&&$A!=""){$f[$x]=html_entity_decode(strip_tags($A),ENT_QUOTES);if(is_shortable($p))$ng=$b->selectLengthProcess();}$uf+=$p["privileges"];}list($L,$Mc)=$b->selectColumnsProcess($f,$v);$ud=count($Mc)<count($L);$Z=$b->selectSearchProcess($q,$v);$_e=$b->selectOrderProcess($q,$v);$y=$b->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$Ng=>$J){$_a=convert_field($q[key($J)]);$L=array($_a?$_a:idf_escape(key($J)));$Z[]=where_check($Ng,$q);$I=$n->select($a,$L,$Z,$L);if($I)echo
reset($I->fetch_row());}exit;}$Ue=$Pg=null;foreach($v
as$u){if($u["type"]=="PRIMARY"){$Ue=array_flip($u["columns"]);$Pg=($L?$Ue:array());foreach($Pg
as$x=>$X){if(in_array(idf_escape($x),$L))unset($Pg[$x]);}break;}}if($re&&!$Ue){$Ue=$Pg=array($re=>0);$v[]=array("type"=>"PRIMARY","columns"=>array($re));}if($_POST&&!$o){$kh=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$Ya=array();foreach($_POST["check"]as$Va)$Ya[]=where_check($Va,$q);$kh[]="((".implode(") OR (",$Ya)."))";}$kh=($kh?"\nWHERE ".implode(" AND ",$kh):"");if($_POST["export"]){cookie("adminer_import","output=".urlencode($_POST["output"])."&format=".urlencode($_POST["format"]));dump_headers($a);$b->dumpTable($a,"");$Jc=($L?implode(", ",$L):"*").convert_fields($f,$q,$L)."\nFROM ".table($a);$Oc=($Mc&&$ud?"\nGROUP BY ".implode(", ",$Mc):"").($_e?"\nORDER BY ".implode(", ",$_e):"");if(!is_array($_POST["check"])||$Ue)$F="SELECT $Jc$kh$Oc";else{$Lg=array();foreach($_POST["check"]as$X)$Lg[]="(SELECT".limit($Jc,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$q).$Oc,1).")";$F=implode(" UNION ALL ",$Lg);}$b->dumpData($a,"table",$F);exit;}if(!$b->selectEmailProcess($Z,$Fc)){if($_POST["save"]||$_POST["delete"]){$H=true;$ua=0;$O=array();if(!$_POST["delete"]){foreach($f
as$A=>$X){$X=process_input($q[$A]);if($X!==null&&($_POST["clone"]||$X!==false))$O[idf_escape($A)]=($X!==false?$X:idf_escape($A));}}if($_POST["delete"]||$O){if($_POST["clone"])$F="INTO ".table($a)." (".implode(", ",array_keys($O)).")\nSELECT ".implode(", ",$O)."\nFROM ".table($a);if($_POST["all"]||($Ue&&is_array($_POST["check"]))||$ud){$H=($_POST["delete"]?$n->delete($a,$kh):($_POST["clone"]?queries("INSERT $F$kh"):$n->update($a,$O,$kh)));$ua=$h->affected_rows;}else{foreach((array)$_POST["check"]as$X){$gh="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$q);$H=($_POST["delete"]?$n->delete($a,$gh,1):($_POST["clone"]?queries("INSERT".limit1($a,$F,$gh)):$n->update($a,$O,$gh,1)));if(!$H)break;$ua+=$h->affected_rows;}}}$ae=lang(84,$ua);if($_POST["clone"]&&$H&&$ua==1){$Hd=last_id();if($Hd)$ae=lang(83," $Hd");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$ae,$H);if(!$_POST["delete"]){edit_form($a,$q,(array)$_POST["fields"],!$_POST["clone"]);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$o=lang(85);else{$H=true;$ua=0;foreach($_POST["val"]as$Ng=>$J){$O=array();foreach($J
as$x=>$X){$x=bracket_escape($x,1);$O[idf_escape($x)]=(preg_match('~char|text~',$q[$x]["type"])||$X!=""?$b->processInput($q[$x],$X):"NULL");}$H=$n->update($a,$O," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($Ng,$q),!$ud&&!$Ue," ");if(!$H)break;$ua+=$h->affected_rows;}queries_redirect(remove_from_uri(),lang(84,$ua),$H);}}elseif(!is_string($sc=get_file("csv_file",true)))$o=upload_error($sc);elseif(!preg_match('~~u',$sc))$o=lang(86);else{cookie("adminer_import","output=".urlencode($ta["output"])."&format=".urlencode($_POST["separator"]));$H=true;$hb=array_keys($q);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$sc,$Ud);$ua=count($Ud[0]);$n->begin();$M=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$K=array();foreach($Ud[0]as$x=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$M]*)$M~",$X.$M,$Vd);if(!$x&&!array_diff($Vd[1],$hb)){$hb=$Vd[1];$ua--;}else{$O=array();foreach($Vd[1]as$r=>$eb)$O[idf_escape($hb[$r])]=($eb==""&&$q[$hb[$r]]["null"]?"NULL":q(str_replace('""','"',preg_replace('~^"|"$~','',$eb))));$K[]=$O;}}$H=(!$K||$n->insertUpdate($a,$K,$Ue));if($H)$H=$n->commit();queries_redirect(remove_from_uri("page"),lang(87,$ua),$H);$n->rollback();}}}$gg=$b->tableName($S);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(50).": $gg",$o);$O=null;if(isset($uf["insert"])||!support("table")){$O="";foreach((array)$_GET["where"]as$X){if($Fc[$X["col"]]&&count($Fc[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&!preg_match('~[_%]~',$X["val"]))))$O.="&set".urlencode("[".bracket_escape($X["col"])."]")."=".urlencode($X["val"]);}}$b->selectLinks($S,$O);if(!$f&&support("table"))echo"<p class='error'>".lang(88).($q?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?'<input type="hidden" name="db" value="'.h(DB).'">'.(isset($_GET["ns"])?'<input type="hidden" name="ns" value="'.h($_GET["ns"]).'">':""):"");echo'<input type="hidden" name="select" value="'.h($a).'">',"</div>\n";$b->selectColumnsPrint($L,$f);$b->selectSearchPrint($Z,$f,$v);$b->selectOrderPrint($_e,$f,$v);$b->selectLimitPrint($y);$b->selectLengthPrint($ng);$b->selectActionPrint($v);echo"</form>\n";$C=$_GET["page"];if($C=="last"){$Hc=$h->result(count_rows($a,$Z,$ud,$Mc));$C=floor(max(0,$Hc-1)/$y);}$Af=$L;$Nc=$Mc;if(!$Af){$Af[]="*";$tb=convert_fields($f,$q,$L);if($tb)$Af[]=substr($tb,2);}foreach($L
as$x=>$X){$p=$q[idf_unescape($X)];if($p&&($_a=convert_field($p)))$Af[$x]="$_a AS $X";}if(!$ud&&$Pg){foreach($Pg
as$x=>$X){$Af[]=idf_escape($x);if($Nc)$Nc[]=idf_escape($x);}}$H=$n->select($a,$Af,$Z,$Nc,$_e,$y,$C,true);if(!$H)echo"<p class='error'>".error()."\n";else{if($w=="mssql"&&$C)$H->seek($y*$C);$Wb=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$K=array();while($J=$H->fetch_assoc()){if($C&&$w=="oracle")unset($J["RNUM"]);$K[]=$J;}if($_GET["page"]!="last"&&$y!=""&&$Mc&&$ud&&$w=="sql")$Hc=$h->result(" SELECT FOUND_ROWS()");if(!$K)echo"<p class='message'>".lang(12)."\n";else{$La=$b->backwardKeys($a,$gg);echo"<div class='scrollable'>","<table id='table' cellspacing='0' class='nowrap checkable'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$Mc&&$L?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(89)."</a>");$ie=array();$Lc=array();reset($L);$ff=1;foreach($K[0]as$x=>$X){if(!isset($Pg[$x])){$X=$_GET["columns"][key($L)];$p=$q[$L?($X?$X["col"]:current($L)):$x];$A=($p?$b->fieldName($p,$ff):($X["fun"]?"*":$x));if($A!=""){$ff++;$ie[$x]=$A;$e=idf_escape($x);$ad=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($x);$Fb="&desc%5B0%5D=1";echo"<th>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});",""),'<a href="'.h($ad.($_e[0]==$e||$_e[0]==$x||(!$_e&&$ud&&$Mc[0]==$e)?$Fb:'')).'">';echo
apply_sql_function($X["fun"],$A)."</a>";echo"<span class='column hidden'>","<a href='".h($ad.$Fb)."' title='".lang(90)."' class='text'> ↓</a>";if(!$X["fun"]){echo'<a href="#fieldset-search" title="'.lang(45).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($x)."');");}echo"</span>";}$Lc[$x]=$X["fun"];next($L);}}$Kd=array();if($_GET["modify"]){foreach($K
as$J){foreach($J
as$x=>$X)$Kd[$x]=max($Kd[$x],min(40,strlen(utf8_decode($X))));}}echo($La?"<th>".lang(91):"")."</thead>\n";if(is_ajax()){if($y%2==1&&$C%2==1)odd();ob_end_clean();}foreach($b->rowDescriptions($K,$Fc)as$he=>$J){$Mg=unique_array($K[$he],$v);if(!$Mg){$Mg=array();foreach($K[$he]as$x=>$X){if(!preg_match('~^(COUNT\((\*|(DISTINCT )?`(?:[^`]|``)+`)\)|(AVG|GROUP_CONCAT|MAX|MIN|SUM)\(`(?:[^`]|``)+`\))$~',$x))$Mg[$x]=$X;}}$Ng="";foreach($Mg
as$x=>$X){if(($w=="sql"||$w=="pgsql")&&preg_match('~char|text|enum|set~',$q[$x]["type"])&&strlen($X)>64){$x=(strpos($x,'(')?$x:idf_escape($x));$x="MD5(".($w!='sql'||preg_match("~^utf8~",$q[$x]["collation"])?$x:"CONVERT($x USING ".charset($h).")").")";$X=md5($X);}$Ng.="&".($X!==null?urlencode("where[".bracket_escape($x)."]")."=".urlencode($X):"null%5B%5D=".urlencode($x));}echo"<tr".odd().">".(!$Mc&&$L?"":"<td>".checkbox("check[]",substr($Ng,1),in_array(substr($Ng,1),(array)$_POST["check"])).($ud||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$Ng)."' class='edit'>".lang(92)."</a>"));foreach($J
as$x=>$X){if(isset($ie[$x])){$p=$q[$x];$X=$n->value($X,$p);if($X!=""&&(!isset($Wb[$x])||$Wb[$x]!=""))$Wb[$x]=(is_mail($X)?$ie[$x]:"");$z="";if(preg_match('~blob|bytea|raw|file~',$p["type"])&&$X!="")$z=ME.'download='.urlencode($a).'&field='.urlencode($x).$Ng;if(!$z&&$X!==null){foreach((array)$Fc[$x]as$Ec){if(count($Fc[$x])==1||end($Ec["source"])==$x){$z="";foreach($Ec["source"]as$r=>$Qf)$z.=where_link($r,$Ec["target"][$r],$K[$he][$Qf]);$z=($Ec["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($Ec["db"]),ME):ME).'select='.urlencode($Ec["table"]).$z;if($Ec["ns"])$z=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($Ec["ns"]),$z);if(count($Ec["source"])==1)break;}}}if($x=="COUNT(*)"){$z=ME."select=".urlencode($a);$r=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$Mg))$z.=where_link($r++,$W["col"],$W["val"],$W["op"]);}foreach($Mg
as$xd=>$W)$z.=where_link($r++,$xd,$W);}$X=select_value($X,$z,$p,$ng);$s=h("val[$Ng][".bracket_escape($x)."]");$Y=$_POST["val"][$Ng][bracket_escape($x)];$Sb=!is_array($J[$x])&&is_utf8($X)&&$K[$he][$x]==$J[$x]&&!$Lc[$x];$mg=preg_match('~text|lob~',$p["type"]);echo"<td id='$s'";if(($_GET["modify"]&&$Sb)||$Y!==null){$Qc=h($Y!==null?$Y:$J[$x]);echo">".($mg?"<textarea name='$s' cols='30' rows='".(substr_count($J[$x],"\n")+1)."'>$Qc</textarea>":"<input name='$s' value='$Qc' size='$Kd[$x]'>");}else{$Pd=strpos($X,"<i>…</i>");echo" data-text='".($Pd?2:($mg?1:0))."'".($Sb?"":" data-warning='".h(lang(93))."'").">$X</td>";}}}if($La)echo"<td>";$b->backwardKeysPrint($La,$K[$he]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($K||$C){$fc=true;if($_GET["page"]!="last"){if($y==""||(count($K)<$y&&($K||!$C)))$Hc=($C?$C*$y:0)+count($K);elseif($w!="sql"||!$ud){$Hc=($ud?false:found_rows($S,$Z));if($Hc<max(1e4,2*($C+1)*$y))$Hc=reset(slow_query(count_rows($a,$Z,$ud,$Mc)));else$fc=false;}}$Fe=($y!=""&&($Hc===false||$Hc>$y||$C));if($Fe){echo(($Hc===false?count($K)+1:$Hc-$C*$y)>$y?'<p><a href="'.h(remove_from_uri("page")."&page=".($C+1)).'" class="loadmore">'.lang(94).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, ".(+$y).", '".lang(95)."…');",""):''),"\n";}}echo"<div class='footer'><div>\n";if($K||$C){if($Fe){$Wd=($Hc===false?$C+(count($K)>=$y?2:1):floor(($Hc-1)/$y));echo"<fieldset>";if($w!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(96)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(96)."', '".($C+1)."')); return false; };"),pagination(0,$C).($C>5?" …":"");for($r=max(1,$C-4);$r<min($Wd,$C+5);$r++)echo
pagination($r,$C);if($Wd>0){echo($C+5<$Wd?" …":""),($fc&&$Hc!==false?pagination($Wd,$C):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$Wd'>".lang(97)."</a>");}}else{echo"<legend>".lang(96)."</legend>",pagination(0,$C).($C>1?" …":""),($C?pagination($C,$C):""),($Wd>$C?pagination($C+1,$C).($Wd>$C+1?" …":""):"");}echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(98)."</legend>";$Kb=($fc?"":"~ ").$Hc;echo
checkbox("all",1,0,($Hc!==false?($fc?"":"~ ").lang(99,$Hc):""),"var checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$Kb' : checked); selectCount('selected2', this.checked || !checked ? '$Kb' : checked);")."\n","</fieldset>\n";if($b->selectCommandPrint()){echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(89),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(85).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(100),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(101),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';}$Gc=$b->dumpFormat();foreach((array)$_GET["columns"]as$e){if($e["fun"]){unset($Gc['sql']);break;}}if($Gc){print_fieldset("export",lang(102)." <span id='selected2'></span>");$De=$b->dumpOutput();echo($De?html_select("output",$De,$ta["output"])." ":""),html_select("format",$Gc,$ta["format"])," <input type='submit' name='export' value='".lang(102)."'>\n","</div></fieldset>\n";}$b->selectEmailPrint(array_filter($Wb,'strlen'),$f);}echo"</div></div>\n";if($b->selectImportPrint()){echo"<div>","<a href='#import'>".lang(103)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import' class='hidden'>: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$ta["format"],1);echo" <input type='submit' name='import' value='".lang(103)."'>","</span>","</div>";}echo"<input type='hidden' name='token' value='$yg'>\n","</form>\n",(!$Mc&&$L?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["script"])){if($_GET["script"]=="kill")$h->query("KILL ".number($_POST["kill"]));elseif(list($R,$s,$A)=$b->_foreignColumn(column_foreign_keys($_GET["source"]),$_GET["field"])){$y=11;$H=$h->query("SELECT $s, $A FROM ".table($R)." WHERE ".(preg_match('~^[0-9]+$~',$_GET["value"])?"$s = $_GET[value] OR ":"")."$A LIKE ".q("$_GET[value]%")." ORDER BY 2 LIMIT $y");for($r=1;($J=$H->fetch_row())&&$r<$y;$r++)echo"<a href='".h(ME."edit=".urlencode($R)."&where".urlencode("[".bracket_escape(idf_unescape($s))."]")."=".urlencode($J[0]))."'>".h($J[1])."</a><br>\n";if($J)echo"...\n";}exit;}else{page_header(lang(63),"",false);if($b->homepage()){echo"<form action='' method='post'>\n","<p>".lang(104).": <input type='search' name='query' value='".h($_POST["query"])."'> <input type='submit' value='".lang(45)."'>\n";if($_POST["query"]!="")search_tables();echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^tables\[/);",""),'<th>'.lang(105),'<td>'.lang(106),"</thead>\n";foreach(table_status()as$R=>$J){$A=$b->tableName($J);if(isset($J["Engine"])&&$A!=""){echo'<tr'.odd().'><td>'.checkbox("tables[]",$R,in_array($R,(array)$_POST["tables"],true)),"<th><a href='".h(ME).'select='.urlencode($R)."'>$A</a>";$X=format_number($J["Rows"]);echo"<td align='right'><a href='".h(ME."edit=").urlencode($R)."'>".($J["Engine"]=="InnoDB"&&$X?"~ $X":$X)."</a>";}}echo"</table>\n","</div>\n","</form>\n",script("tableCheck();");}}page_footer();