<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 4.7.9
*/function
adminer_errors($Cc,$Ec){return!!preg_match('~^(Trying to access array offset on value of type null|Undefined array key)~',$Ec);}error_reporting(6135);set_error_handler('adminer_errors',2);$cd=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($cd||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$Qi=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($Qi)$$X=$Qi;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection(){global$h;return$h;}function
adminer(){global$b;return$b;}function
version(){global$ia;return$ia;}function
idf_unescape($v){$ve=substr($v,-1);return
str_replace($ve.$ve,$ve,substr($v,1,-1));}function
escape_string($X){return
substr(q($X),1,-1);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes($zg,$cd=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($z,$X)=each($zg)){foreach($X
as$ke=>$W){unset($zg[$z][$ke]);if(is_array($W)){$zg[$z][stripslashes($ke)]=$W;$zg[]=&$zg[$z][stripslashes($ke)];}else$zg[$z][stripslashes($ke)]=($cd?$W:stripslashes($W));}}}}function
bracket_escape($v,$Pa=false){static$Ai=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($v,($Pa?array_flip($Ai):$Ai));}function
min_version($ij,$Je="",$i=null){global$h;if(!$i)$i=$h;$uh=$i->server_info;if($Je&&preg_match('~([\d.]+)-MariaDB~',$uh,$B)){$uh=$B[1];$ij=$Je;}return(version_compare($uh,$ij)>=0);}function
charset($h){return(min_version("5.5.3",0,$h)?"utf8mb4":"utf8");}function
script($Eh,$_i="\n"){return"<script".nonce().">$Eh</script>$_i";}function
script_src($Vi){return"<script src='".h($Vi)."'".nonce()."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($Q){return
str_replace("\0","&#0;",htmlspecialchars($Q,ENT_QUOTES,'utf-8'));}function
nl_br($Q){return
str_replace("\n","<br>",$Q);}function
checkbox($C,$Y,$gb,$re="",$_f="",$lb="",$se=""){$I="<input type='checkbox' name='$C' value='".h($Y)."'".($gb?" checked":"").($se?" aria-labelledby='$se'":"").">".($_f?script("qsl('input').onclick = function () { $_f };",""):"");return($re!=""||$lb?"<label".($lb?" class='$lb'":"").">$I".h($re)."</label>":$I);}function
optionlist($Ff,$oh=null,$aj=false){$I="";foreach($Ff
as$ke=>$W){$Gf=array($ke=>$W);if(is_array($W)){$I.='<optgroup label="'.h($ke).'">';$Gf=$W;}foreach($Gf
as$z=>$X)$I.='<option'.($aj||is_string($z)?' value="'.h($z).'"':'').(($aj||is_string($z)?(string)$z:$X)===$oh?' selected':'').'>'.h($X);if(is_array($W))$I.='</optgroup>';}return$I;}function
html_select($C,$Ff,$Y="",$zf=true,$se=""){if($zf)return"<select name='".h($C)."'".($se?" aria-labelledby='$se'":"").">".optionlist($Ff,$Y)."</select>".(is_string($zf)?script("qsl('select').onchange = function () { $zf };",""):"");$I="";foreach($Ff
as$z=>$X)$I.="<label><input type='radio' name='".h($C)."' value='".h($z)."'".($z==$Y?" checked":"").">".h($X)."</label>";return$I;}function
select_input($Ka,$Ff,$Y="",$zf="",$lg=""){$fi=($Ff?"select":"input");return"<$fi$Ka".($Ff?"><option value=''>$lg".optionlist($Ff,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$lg'>").($zf?script("qsl('$fi').onchange = $zf;",""):"");}function
confirm($Te="",$ph="qsl('input')"){return
script("$ph.onclick = function () { return confirm('".($Te?js_escape($Te):lang(0))."'); };","");}function
print_fieldset($u,$_e,$lj=false){echo"<fieldset><legend>","<a href='#fieldset-$u'>$_e</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$u');",""),"</legend>","<div id='fieldset-$u'".($lj?"":" class='hidden'").">\n";}function
bold($Xa,$lb=""){return($Xa?" class='active $lb'":($lb?" class='$lb'":""));}function
odd($I=' class="odd"'){static$t=0;if(!$I)$t=-1;return($t++%2?$I:'');}function
js_escape($Q){return
addcslashes($Q,"\r\n'\\/");}function
json_row($z,$X=null){static$dd=true;if($dd)echo"{";if($z!=""){echo($dd?"":",")."\n\t\"".addcslashes($z,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$dd=false;}else{echo"\n}\n";$dd=true;}}function
ini_bool($Xd){$X=ini_get($Xd);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$I;if($I===null)$I=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$I;}function
set_password($hj,$N,$V,$F){$_SESSION["pwds"][$hj][$N][$V]=($_COOKIE["adminer_key"]&&is_string($F)?array(encrypt_string($F,$_COOKIE["adminer_key"])):$F);}function
get_password(){$I=get_session("pwds");if(is_array($I))$I=($_COOKIE["adminer_key"]?decrypt_string($I[0],$_COOKIE["adminer_key"]):false);return$I;}function
q($Q){global$h;return$h->quote($Q);}function
get_vals($G,$e=0){global$h;$I=array();$H=$h->query($G);if(is_object($H)){while($J=$H->fetch_row())$I[]=$J[$e];}return$I;}function
get_key_vals($G,$i=null,$xh=true){global$h;if(!is_object($i))$i=$h;$I=array();$H=$i->query($G);if(is_object($H)){while($J=$H->fetch_row()){if($xh)$I[$J[0]]=$J[1];else$I[]=$J[0];}}return$I;}function
get_rows($G,$i=null,$o="<p class='error'>"){global$h;$zb=(is_object($i)?$i:$h);$I=array();$H=$zb->query($G);if(is_object($H)){while($J=$H->fetch_assoc())$I[]=$J;}elseif(!$H&&!is_object($i)&&$o&&defined("PAGE_HEADER"))echo$o.error()."\n";return$I;}function
unique_array($J,$x){foreach($x
as$w){if(preg_match("~PRIMARY|UNIQUE~",$w["type"])){$I=array();foreach($w["columns"]as$z){if(!isset($J[$z]))continue
2;$I[$z]=$J[$z];}return$I;}}}function
escape_key($z){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$z,$B))return$B[1].idf_escape(idf_unescape($B[2])).$B[3];return
idf_escape($z);}function
where($Z,$q=array()){global$h,$y;$I=array();foreach((array)$Z["where"]as$z=>$X){$z=bracket_escape($z,1);$e=escape_key($z);$I[]=$e.($y=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):($y=="mssql"?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($q[$z],q($X))));if($y=="sql"&&preg_match('~char|text~',$q[$z]["type"])&&preg_match("~[^ -@]~",$X))$I[]="$e = ".q($X)." COLLATE ".charset($h)."_bin";}foreach((array)$Z["null"]as$z)$I[]=escape_key($z)." IS NULL";return
implode(" AND ",$I);}function
where_check($X,$q=array()){parse_str($X,$eb);remove_slashes(array(&$eb));return
where($eb,$q);}function
where_link($t,$e,$Y,$Bf="="){return"&where%5B$t%5D%5Bcol%5D=".urlencode($e)."&where%5B$t%5D%5Bop%5D=".urlencode(($Y!==null?$Bf:"IS NULL"))."&where%5B$t%5D%5Bval%5D=".urlencode($Y);}function
convert_fields($f,$q,$L=array()){$I="";foreach($f
as$z=>$X){if($L&&!in_array(idf_escape($z),$L))continue;$Ha=convert_field($q[$z]);if($Ha)$I.=", $Ha AS ".idf_escape($z);}return$I;}function
cookie($C,$Y,$Ce=2592000){global$ba;return
header("Set-Cookie: $C=".urlencode($Y).($Ce?"; expires=".gmdate("D, d M Y H:i:s",time()+$Ce)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).($ba?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
restart_session(){if(!ini_bool("session.use_cookies"))session_start();}function
stop_session($id=false){$Zi=ini_bool("session.use_cookies");if(!$Zi||$id){session_write_close();if($Zi&&@ini_set("session.use_cookies",false)===false)session_start();}}function&get_session($z){return$_SESSION[$z][DRIVER][SERVER][$_GET["username"]];}function
set_session($z,$X){$_SESSION[$z][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($hj,$N,$V,$m=null){global$kc;preg_match('~([^?]*)\??(.*)~',remove_from_uri(implode("|",array_keys($kc))."|username|".($m!==null?"db|":"").session_name()),$B);return"$B[1]?".(sid()?SID."&":"").($hj!="server"||$N!=""?urlencode($hj)."=".urlencode($N)."&":"")."username=".urlencode($V).($m!=""?"&db=".urlencode($m):"").($B[2]?"&$B[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($Ee,$Te=null){if($Te!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($Ee!==null?$Ee:$_SERVER["REQUEST_URI"]))][]=$Te;}if($Ee!==null){if($Ee=="")$Ee=".";header("Location: $Ee");exit;}}function
query_redirect($G,$Ee,$Te,$Kg=true,$Jc=true,$Uc=false,$ni=""){global$h,$o,$b;if($Jc){$Mh=microtime(true);$Uc=!$h->query($G);$ni=format_time($Mh);}$Hh="";if($G)$Hh=$b->messageQuery($G,$ni,$Uc);if($Uc){$o=error().$Hh.script("messagesPrint();");return
false;}if($Kg)redirect($Ee,$Te.$Hh);return
true;}function
queries($G){global$h;static$Dg=array();static$Mh;if(!$Mh)$Mh=microtime(true);if($G===null)return
array(implode("\n",$Dg),format_time($Mh));$Dg[]=(preg_match('~;$~',$G)?"DELIMITER ;;\n$G;\nDELIMITER ":$G).";";return$h->query($G);}function
apply_queries($G,$T,$Fc='table'){foreach($T
as$R){if(!queries("$G ".$Fc($R)))return
false;}return
true;}function
queries_redirect($Ee,$Te,$Kg){list($Dg,$ni)=queries(null);return
query_redirect($Dg,$Ee,$Te,$Kg,false,!$Kg,$ni);}function
format_time($Mh){return
lang(1,max(0,microtime(true)-$Mh));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($Vf=""){return
substr(preg_replace("~(?<=[?&])($Vf".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
pagination($E,$Pb){return" ".($E==$Pb?$E+1:'<a href="'.h(remove_from_uri("page").($E?"&page=$E".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($E+1)."</a>");}function
get_file($z,$Xb=false){$ad=$_FILES[$z];if(!$ad)return
null;foreach($ad
as$z=>$X)$ad[$z]=(array)$X;$I='';foreach($ad["error"]as$z=>$o){if($o)return$o;$C=$ad["name"][$z];$vi=$ad["tmp_name"][$z];$Eb=file_get_contents($Xb&&preg_match('~\.gz$~',$C)?"compress.zlib://$vi":$vi);if($Xb){$Mh=substr($Eb,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$Mh,$Qg))$Eb=iconv("utf-16","utf-8",$Eb);elseif($Mh=="\xEF\xBB\xBF")$Eb=substr($Eb,3);$I.=$Eb."\n\n";}else$I.=$Eb;}return$I;}function
upload_error($o){$Qe=($o==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($o?lang(2).($Qe?" ".lang(3,$Qe):""):lang(4));}function
repeat_pattern($ig,$Ae){return
str_repeat("$ig{0,65535}",$Ae/65535)."$ig{0,".($Ae%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
shorten_utf8($Q,$Ae=80,$Th=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$Ae).")($)?)u",$Q,$B))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$Ae).")($)?)",$Q,$B);return
h($B[1]).$Th.(isset($B[2])?"":"<i>…</i>");}function
format_number($X){return
strtr(number_format($X,0,".",lang(5)),preg_split('~~u',lang(6),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~[^a-z0-9_]~i','-',$X);}function
hidden_fields($zg,$Md=array(),$rg=''){$I=false;foreach($zg
as$z=>$X){if(!in_array($z,$Md)){if(is_array($X))hidden_fields($X,array(),$z);else{$I=true;echo'<input type="hidden" name="'.h($rg?$rg."[$z]":$z).'" value="'.h($X).'">';}}}return$I;}function
hidden_fields_get(){echo(sid()?'<input type="hidden" name="'.session_name().'" value="'.h(session_id()).'">':''),(SERVER!==null?'<input type="hidden" name="'.DRIVER.'" value="'.h(SERVER).'">':""),'<input type="hidden" name="username" value="'.h($_GET["username"]).'">';}function
table_status1($R,$Vc=false){$I=table_status($R,$Vc);return($I?$I:array("Name"=>$R));}function
column_foreign_keys($R){global$b;$I=array();foreach($b->foreignKeys($R)as$r){foreach($r["source"]as$X)$I[$X][]=$r;}return$I;}function
enum_input($U,$Ka,$p,$Y,$zc=null){global$b;preg_match_all("~'((?:[^']|'')*)'~",$p["length"],$Le);$I=($zc!==null?"<label><input type='$U'$Ka value='$zc'".((is_array($Y)?in_array($zc,$Y):$Y===0)?" checked":"")."><i>".lang(7)."</i></label>":"");foreach($Le[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$gb=(is_int($Y)?$Y==$t+1:(is_array($Y)?in_array($t+1,$Y):$Y===$X));$I.=" <label><input type='$U'$Ka value='".($t+1)."'".($gb?' checked':'').'>'.h($b->editVal($X,$p)).'</label>';}return$I;}function
input($p,$Y,$s){global$Li,$b,$y;$C=h(bracket_escape($p["field"]));echo"<td class='function'>";if(is_array($Y)&&!$s){$Fa=array($Y);if(version_compare(PHP_VERSION,5.4)>=0)$Fa[]=JSON_PRETTY_PRINT;$Y=call_user_func_array('json_encode',$Fa);$s="json";}$Ug=($y=="mssql"&&$p["auto_increment"]);if($Ug&&!$_POST["save"])$s=null;$rd=(isset($_GET["select"])||$Ug?array("orig"=>lang(8)):array())+$b->editFunctions($p);$Ka=" name='fields[$C]'";if($p["type"]=="enum")echo
h($rd[""])."<td>".$b->editInput($_GET["edit"],$p,$Ka,$Y);else{$Ad=(in_array($s,$rd)||isset($rd[$s]));echo(count($rd)>1?"<select name='function[$C]'>".optionlist($rd,$s===null||$Ad?$s:"")."</select>".on_help("getTarget(event).value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($rd))).'<td>';$Zd=$b->editInput($_GET["edit"],$p,$Ka,$Y);if($Zd!="")echo$Zd;elseif(preg_match('~bool~',$p["type"]))echo"<input type='hidden'$Ka value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$Ka value='1'>";elseif($p["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$p["length"],$Le);foreach($Le[1]as$t=>$X){$X=stripcslashes(str_replace("''","'",$X));$gb=(is_int($Y)?($Y>>$t)&1:in_array($X,explode(",",$Y),true));echo" <label><input type='checkbox' name='fields[$C][$t]' value='".(1<<$t)."'".($gb?' checked':'').">".h($b->editVal($X,$p)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$p["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$C'>";elseif(($li=preg_match('~text|lob|memo~i',$p["type"]))||preg_match("~\n~",$Y)){if($li&&$y!="sqlite")$Ka.=" cols='50' rows='12'";else{$K=min(12,substr_count($Y,"\n")+1);$Ka.=" cols='30' rows='$K'".($K==1?" style='height: 1.2em;'":"");}echo"<textarea$Ka>".h($Y).'</textarea>';}elseif($s=="json"||preg_match('~^jsonb?$~',$p["type"]))echo"<textarea$Ka cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';else{$Se=(!preg_match('~int~',$p["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$p["length"],$B)?((preg_match("~binary~",$p["type"])?2:1)*$B[1]+($B[3]?1:0)+($B[2]&&!$p["unsigned"]?1:0)):($Li[$p["type"]]?$Li[$p["type"]]+($p["unsigned"]?0:1):0));if($y=='sql'&&min_version(5.6)&&preg_match('~time~',$p["type"]))$Se+=7;echo"<input".((!$Ad||$s==="")&&preg_match('~(?<!o)int(?!er)~',$p["type"])&&!preg_match('~\[\]~',$p["full_type"])?" type='number'":"")." value='".h($Y)."'".($Se?" data-maxlength='$Se'":"").(preg_match('~char|binary~',$p["type"])&&$Se>20?" size='40'":"")."$Ka>";}echo$b->editHint($_GET["edit"],$p,$Y);$dd=0;foreach($rd
as$z=>$X){if($z===""||!$X)break;$dd++;}if($dd)echo
script("mixin(qsl('td'), {onchange: partial(skipOriginal, $dd), oninput: function () { this.onchange(); }});");}}function
process_input($p){global$b,$n;$v=bracket_escape($p["field"]);$s=$_POST["function"][$v];$Y=$_POST["fields"][$v];if($p["type"]=="enum"){if($Y==-1)return
false;if($Y=="")return"NULL";return+$Y;}if($p["auto_increment"]&&$Y=="")return
null;if($s=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$p["on_update"])?idf_escape($p["field"]):false);if($s=="NULL")return"NULL";if($p["type"]=="set")return
array_sum((array)$Y);if($s=="json"){$s="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$p["type"])&&ini_bool("file_uploads")){$ad=get_file("fields-$v");if(!is_string($ad))return
false;return$n->quoteBinary($ad);}return$b->processInput($p,$Y,$s);}function
fields_from_edit(){global$n;$I=array();foreach((array)$_POST["field_keys"]as$z=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$z];$_POST["fields"][$X]=$_POST["field_vals"][$z];}}foreach((array)$_POST["fields"]as$z=>$X){$C=bracket_escape($z,1);$I[$C]=array("field"=>$C,"privileges"=>array("insert"=>1,"update"=>1),"null"=>1,"auto_increment"=>($z==$n->primary),);}return$I;}function
search_tables(){global$b,$h;$_GET["where"][0]["val"]=$_POST["query"];$rh="<ul>\n";foreach(table_status('',true)as$R=>$S){$C=$b->tableName($S);if(isset($S["Engine"])&&$C!=""&&(!$_POST["tables"]||in_array($R,$_POST["tables"]))){$H=$h->query("SELECT".limit("1 FROM ".table($R)," WHERE ".implode(" AND ",$b->selectSearchProcess(fields($R),array())),1));if(!$H||$H->fetch_row()){$vg="<a href='".h(ME."select=".urlencode($R)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$C</a>";echo"$rh<li>".($H?$vg:"<p class='error'>$vg: ".error())."\n";$rh="";}}}echo($rh?"<p class='message'>".lang(9):"</ul>")."\n";}function
dump_headers($Jd,$cf=false){global$b;$I=$b->dumpHeaders($Jd,$cf);$Sf=$_POST["output"];if($Sf!="text")header("Content-Disposition: attachment; filename=".$b->dumpFilename($Jd).".$I".($Sf!="file"&&preg_match('~^[0-9a-z]+$~',$Sf)?".$Sf":""));session_write_close();ob_flush();flush();return$I;}function
dump_csv($J){foreach($J
as$z=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$J[$z]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$J)."\r\n";}function
apply_sql_function($s,$e){return($s?($s=="unixepoch"?"DATETIME($e, '$s')":($s=="count distinct"?"COUNT(DISTINCT ":strtoupper("$s("))."$e)"):$e);}function
get_temp_dir(){$I=ini_get("upload_tmp_dir");if(!$I){if(function_exists('sys_get_temp_dir'))$I=sys_get_temp_dir();else{$bd=@tempnam("","");if(!$bd)return
false;$I=dirname($bd);unlink($bd);}}return$I;}function
file_open_lock($bd){$pd=@fopen($bd,"r+");if(!$pd){$pd=@fopen($bd,"w");if(!$pd)return;chmod($bd,0660);}flock($pd,LOCK_EX);return$pd;}function
file_write_unlock($pd,$Rb){rewind($pd);fwrite($pd,$Rb);ftruncate($pd,strlen($Rb));flock($pd,LOCK_UN);fclose($pd);}function
password_file($j){$bd=get_temp_dir()."/adminer.key";$I=@file_get_contents($bd);if($I||!$j)return$I;$pd=@fopen($bd,"w");if($pd){chmod($bd,0660);$I=rand_string();fwrite($pd,$I);fclose($pd);}return$I;}function
rand_string(){return
md5(uniqid(mt_rand(),true));}function
select_value($X,$A,$p,$mi){global$b;if(is_array($X)){$I="";foreach($X
as$ke=>$W)$I.="<tr>".($X!=array_values($X)?"<th>".h($ke):"")."<td>".select_value($W,$A,$p,$mi);return"<table cellspacing='0'>$I</table>";}if(!$A)$A=$b->selectLink($X,$p);if($A===null){if(is_mail($X))$A="mailto:$X";if(is_url($X))$A=$X;}$I=$b->editVal($X,$p);if($I!==null){if(!is_utf8($I))$I="\0";elseif($mi!=""&&is_shortable($p))$I=shorten_utf8($I,max(0,+$mi));else$I=h($I);}return$b->selectVal($I,$A,$p,$X);}function
is_mail($wc){$Ia='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$jc='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$ig="$Ia+(\\.$Ia+)*@($jc?\\.)+$jc";return
is_string($wc)&&preg_match("(^$ig(,\\s*$ig)*\$)i",$wc);}function
is_url($Q){$jc='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($jc?\\.)+$jc(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$Q);}function
is_shortable($p){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$p["type"]);}function
count_rows($R,$Z,$fe,$ud){global$y;$G=" FROM ".table($R).($Z?" WHERE ".implode(" AND ",$Z):"");return($fe&&($y=="sql"||count($ud)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$ud).")$G":"SELECT COUNT(*)".($fe?" FROM (SELECT 1$G GROUP BY ".implode(", ",$ud).") x":$G));}function
slow_query($G){global$b,$xi,$n;$m=$b->database();$oi=$b->queryTimeout();$Bh=$n->slowQuery($G,$oi);if(!$Bh&&support("kill")&&is_object($i=connect())&&($m==""||$i->select_db($m))){$pe=$i->result(connection_id());echo'<script',nonce(),'>
var timeout = setTimeout(function () {
	ajax(\'',js_escape(ME),'script=kill\', function () {
	}, \'kill=',$pe,'&token=',$xi,'\');
}, ',1000*$oi,');
</script>
';}else$i=null;ob_flush();flush();$I=@get_key_vals(($Bh?$Bh:$G),$i,false);if($i){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$I;}function
get_token(){$Gg=rand(1,1e6);return($Gg^$_SESSION["token"]).":$Gg";}function
verify_token(){list($xi,$Gg)=explode(":",$_POST["token"]);return($Gg^$_SESSION["token"])==$xi;}function
lzw_decompress($Ta){$gc=256;$Ua=8;$nb=array();$Wg=0;$Xg=0;for($t=0;$t<strlen($Ta);$t++){$Wg=($Wg<<8)+ord($Ta[$t]);$Xg+=8;if($Xg>=$Ua){$Xg-=$Ua;$nb[]=$Wg>>$Xg;$Wg&=(1<<$Xg)-1;$gc++;if($gc>>$Ua)$Ua++;}}$fc=range("\0","\xFF");$I="";foreach($nb
as$t=>$mb){$vc=$fc[$mb];if(!isset($vc))$vc=$wj.$wj[0];$I.=$vc;if($t)$fc[]=$wj.$vc[0];$wj=$vc;}return$I;}function
on_help($tb,$zh=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $tb, $zh) }, onmouseout: helpMouseout});","");}function
edit_form($a,$q,$J,$Ti){global$b,$y,$xi,$o;$Yh=$b->tableName(table_status1($a,true));page_header(($Ti?lang(10):lang(11)),$o,array("select"=>array($a,$Yh)),$Yh);if($J===false)echo"<p class='error'>".lang(12)."\n";echo'<form action="" method="post" enctype="multipart/form-data" id="form">
';if(!$q)echo"<p class='error'>".lang(13)."\n";else{echo"<table cellspacing='0' class='layout'>".script("qsl('table').onkeydown = editingKeydown;");foreach($q
as$C=>$p){echo"<tr><th>".$b->fieldName($p);$Yb=$_GET["set"][bracket_escape($C)];if($Yb===null){$Yb=$p["default"];if($p["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$Yb,$Qg))$Yb=$Qg[1];}$Y=($J!==null?($J[$C]!=""&&$y=="sql"&&preg_match("~enum|set~",$p["type"])?(is_array($J[$C])?array_sum($J[$C]):+$J[$C]):$J[$C]):(!$Ti&&$p["auto_increment"]?"":(isset($_GET["select"])?false:$Yb)));if(!$_POST["save"]&&is_string($Y))$Y=$b->editVal($Y,$p);$s=($_POST["save"]?(string)$_POST["function"][$C]:($Ti&&preg_match('~^CURRENT_TIMESTAMP~i',$p["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(preg_match("~time~",$p["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$s="now";}input($p,$Y,$s);echo"\n";}if(!support("table"))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",$b->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($q){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"])){echo"<input type='submit' name='insert' value='".($Ti?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($Ti?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."…', this); };"):"");}}echo($Ti?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":($_POST||!$q?"":script("focus(qsa('td', qs('#form'))[1].firstChild);")));if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo'<input type="hidden" name="referer" value="',h(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"]),'">
<input type="hidden" name="save" value="1">
<input type="hidden" name="token" value="',$xi,'">
</form>
';}if(isset($_GET["file"])){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");if($_GET["file"]=="favicon.ico"){header("Content-Type: image/x-icon");echo
lzw_decompress("\0\0\0` \0\0\n @\0C\"\0`EQ?tvM'Jdd\\b0\0\"fӈs5AXPaJ08#RTz`#.cXȀ?-\0Im?.M\0ȯ(̉/(%\0");}elseif($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("\n1ٌ̇l7B14vb0fsn2Bѱ٘n:#(b.\rDc)a7Elñi1̎s-4f	i7t4yZf4iATVVf:Ϧ,:1Qݼb2`#>:7G1sLXD*bv<܌#e@:4!fot:<咾o\ni',a_:iBv|N4.5Nfivphl֚O= OFQk\$id2Tp6-Z6h:a,2#8А#6nJht4O42ok*r@p@!?6r[L:2Bj!HbP=!1V\"0\nSD7DڛC!!Gʌ +=tC.C:+=%c1MR/EȒ42䱠`8(ӹ[W=ySb=-ܹBS+ɯ@pL4Ydq63ĬAc܌Ψk[&>Zpkm]u-c:Ntδpҝ8=#[.ޯ~myPP|I֛Q9v[Q\nr'g+T2Vz48(	Ey*#j2]R)[NR\$<>:>\$;>\rHT\nwN wأ<Gw\\Y_Rt^>\r}S\rz4=\nL%J\",Z8i0u?s3#ى:㽖E]xs^8K^*0w~:iv2w^77cu+U%{P*4̼LX./!1Cqx!HFdLĠ`65fĆ=Hl V1\0a2;6_ه\0&ZSd)KE'n[X\0ZɊF[Pޘ@!Y,`\"ڷ0Ee9yF>9bF5:\0}Ĵ(\$37H MA6R{Mq7GCCm2(Ct>[-t/&C]etG̬4@r><Sq/QhmL#K|6fKP\r%tV=\"SH\$} )w,W\0Fu@b9\rr2#DXyOI>nǢ%'_t\rτz\\1hl]Q5Mp6kqh\$H~|!*4`SS tPP\\g7\n-:袪plB7Өc(wO0\\:wp4{TjO6HÊrq\n%%y']\$aZ.fcq*-FWkzjlg:\$\"N\r#dÂsc̠\"j\rՒPh1/DA)[knp76YR{MP@\n-a6[zJH,dlBho+#Dr^^eE ĜaPJGzt2XVȳB_%K=Eb弾§kU(.!ܮ8I.@Kxn:P32mH		C*:vT\nR0uҧ]P/JQd{L޳:Y2bT 34cV=L4r!BY6MeLio9< GƕЙMhm^UNTr5HiM/n흳T[-<__3/Xr(<uҖGNX20\r\$^:'9O;kfN'ab,V1HI!%6@\$EGڜ1(mUrս`iN+Ü)0lf0[UV-:I^\$sb\reugh~9߈bf+0 hXrݬ!\$e,w+3_Ak\nkrʛcuWdY\\={.čgp8t\rRZvJ:>Y|+@Ct\rjt6%?ǎ>/9F`וv~KRWzlmwL9Y*qxzSeݛ~Dxɟi72Oݻ_{53t_z3d)C\$?KӪP%T&&\0PNA^~p Ϝ\r\$b*+D6궦ψJ\$(olh&KBS>;zxoz>oZ\nʋ[vȜ2OxِV0f2Blbk6ZkhXcd0*KTH=πp0lV\rnm)((:#E:CC\rG\ré0i:`Z1Q\n:\r\0q:`-M#}1;q#|ShlD\0fiDpL``0y1\r=MQ\\%oq\01211 ќbi:\r/Ѣ `)0@I1NCOZ1q1 ,\rdIǦvj1 tB⁒0:01A2V0%fi3!&QRc%q&w%\rV#Qw`% m*ry&i+r{*(rg(#(2()R@i- 1\"\0R.e.r,ry(2Cb!Bޏ3%ҵ,R1&tba\rL-3\0Bp194O'R3*=\$[^iI;/3i5&}17# ѹ8\"789*23!!1\\\08rk9;S23ړ*:q]5S<#383#e=>~9S螳r)T*a@іbes:-*;,ؙ3!iLҲ#1 +n *@3i71_FS;3F\rA3>x: \r0@-/w7SJ3 .F\$OB%4+t'gLq\rJtJM2\r7T@)ⓣd2P>ΰFi಴\nr\0bk(DKQ1\"2tP\r,\$KCt5#)P#Pi.U2C~\"");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("f:gCI\n83)781x:\nOg#)r7\n\"`|2gSiH)NS\r\"0@)`(\$s6O!V/=' T4=iS6IOG#XVCsZ1.hp8,[H~Cz2lc3sIb4\nF8TIU*fzr0EyfY.:I(c΋!_l^^(N{S)rqYl٦33\n+GyixV3wuh^ra۔c\r(.Ch<\r)ѣ`743'm5\nP:2Pq C}ī38B0hRr(0b\\0Hr44B!p\$rZZ2܉.Ƀ(\\5|\nC(\"P.NRTΓ>HN8HP\\7Jp~2%OC1.C8·H*jS(/6KU<2pOI`ⳈdOH5-4pX25-Ңۈz7\"(P\\32:]U߅!]<Aۤiڰl\r\0v#J8wmɤ<ɠ%m;p#`XDiZN09占`wJD29t*yNiIh\\9:xﭵyl*ȈY8W?ޛ3!\"6n[\r*\$Ƨnzx9\r|*3ףpﻶ:(p\\;mz98Nj2\rHH&(z7ik cet2:SHȠ/)x@tri98yҷV+^WڦkZYlʣ4Ƌ\\E{7\0pDi-T0l%=˃9(5\n\nn,4\0a}܃.Rs\02B\\b1S\0003,XPHJspdK CA!2*W2\$+f^\n1zE Iv\\2.*AE(db܄9Dh&?HsQ2x~nÁJT2&eRGQTwݑP\\)6sh\\3\0R	'\r+*;RH.!['~%t< pK#!lLe,&\$	`CXӆ0֭:Mh	ڜG!&3D<!23?hJe h\rmNiNHl7vWI.-5֧ey\rEJ\ni*\$@RU0,\$UEªu)@(tSJkp!~d`>\n;#\rp9jɹ]&Nc(rTQUS\08n`ybLO5,>xf䴒+\"I{kM[\r%[	ea1! ԮF@b)R720\nWLܜҮtd+0wgl0n@ɢiM\nAM5n\$EױNl%1 AkriFBol,muNx-_֤C( fl\r1p[9x(iBҖzQl8C	XU TbI`p+V\0;CbX+ϒs]H[kxG*]awn!6mSIK~/ӥ7eeNS/;dA>}l~ %^fآpڜDEat\nx=kЎ*dTj2j\n ,e=M84aj@Tsnf\n6\rd0Y'%ԓ~	Ҩ<AHG8΃\$z{u2*a>(wK.bP{o´z#28=8>A,e+Cx*-b=m,alzk\$W,mJiʧ+0[.RsKXZL2`(CvZ\$׹,D?HNxX)M\$,*\nѣ\$<qşh!SxsA!:K}RA2kXp\n<l3VV}g&Yݍ!+;<YYE3rَCo5ճkkۣtU)[}ul:D+Ϗ _oh1400bK㬒lG#|UdIK7^@O\0HHi6\r\\cg\02B*e\n	zr!nWz& {H'\$X w@8DGr*H'p#Į\nd,,;g~\0#E\rI`'%E.]`Л%&m\r%4Sv#\nfH\$%-#qBQ-c2&] qh\rl]sh7n#-jEFrl&dzF6\"|s@z)0rpڏ\0X\0|DL<!o*D{.B<E0nB( |\r\n^ h!r\$(^~/pqBO,\\#RR%dHj`̭ V bSdiEohr<i/k\$-\$o+ŋlO&evƒijMPA'u'( M(h/+WDSo.n.n((\"h&p//1D̊j娸E&⦀,'l\$/.,dWbbO3BsH:J`!.,F7(Կ1ls ҎŢqX\r~R鰱`ҞY*:RrJ%L+n\"\r͇H!qb2Li%Wj#9ObE.I:67\06+%.a7E8VS?(DGӳB%;/<\r >M@HDsZ[tHEnx(Rx@GkjW>#T/8c8Q0_IIGII!YEdE^tdth`DV!C8\rb3!3@33N}ZB3	330M(>}\\tffI\r337 X\"td,\nbtNO`P;ܕҭ\$\nZѭ5U5WU^hotPM/5K4EjKQ&53GXXx)<5D\rV\nr5b܀\\J\">1S\r[-Du\r)00Yˢk{\n#\r^|uܻU_nU4U~Yt\rI@䏳R 3:uePMS0TwWXDKOU;U\nOYYQ,M[\0_DWJ*\rg(]\r\"ZC6u+YY6ô0q(8}3AX3Th9jjfMtPJbqMP5>Yk%&\\1dE4 Yn\$<U]Ӊ1mbֶ^\"NVppeMWܢ\\)\n \nf7\n2r8=Ek7tV7PLa6v@'6ij&>;`a	\0pڨ(J)\\nĬm\02eqJPtfj\"[\0X,<\\+md~s%omn),ׄԇ\r48\rmEH]HWM0D߀~ˁKE}|f^\r>-z]2sxDd[stS\0Qf-K`twT9Z	\nB9 Nb<BI5ooJpJNd\rhލ2\"xHCݍ:9Yn16zr+z\\m T @Y2lQ<2O+%.Ӄh0AZ2R1/hH\rXaNB& M@[xʮ8&LV͜v*jۚGH\\ٮ	&s\0Q\\\"b	\rBsw	BN`7Co(\nè19*E SU0U t'|m?h[\$.#5	 	pyB@R]@|{P\0x/ w%EsBdCU~O׷P@X]Z31{eLYڐ\\(*R`	\nQCF*霬pX|`N\$[@UZ`Zd\"\\\")I:toD\0[-g*`hu%,I7īHm6}Nͳ\$MUYf&1e]pzImG/ w !\\#54IdEhqѬkx|kqDbz?>:[LƬZX:jw5	Y0 \$\0CdSg{@\n`	C M# t}xN{۰)CFKZj\0PFYBpFk0<>D<JEg\r.28U@*5fkJD4TDU76/@K+J@=WIOD85MN\$R\05\r_EIϳNly\\qUQ\n@ۺpP۱7ԽN\rR{*qm\$\0RԓqÈ+U@BOf*CˬMC`_ ˵NT5٦C׻ \\We&_X_؍hB3%FW|Gޛ'[łV#^\rGRPFgYi z\n+^/\\6bdmh@qAh),JWcmem]ӏekZb0Y]ymfeB;OwapDW{\0-2/bNsֽ޾RaϮh&qt\n\"iRmhzeFS7PP䖤:BsmY d7}3?*tlT}~=c	3;TL5*	~#Asx-7f5`#\"NbG@e[s-M6qq he5\0Ң*bISFή9}p-`{ɖkP0T<Z90<՚\r;!g\r\nK\n\0*\nb7(_@,e2\r]K+\0p C\\Ѣ,0^MЧ@;X\r?\$\rj+/BPJ{\"a6䉜|\n\0\\5	156 .[Uد\0d8Y:!=X.uC!SopB7ůRh\\hE=y:< :u280siTsB@\$ @u	Q.T0M\\/d+ƃ\n=dA)\r@@h38.eZa|.7Ykc'D#Y@Xq=M44B AMdU\"Hw4(>8C?e_`X:A9øpGGy6FXrl1ػBÅ9RzhB{\0^-0%D5F\"\"i`nAf \"tDZ\"_V\$!/Dᚆ٦̀F,25jTy\0Nx\rYl#Eq\nB2\n64!/\nQ*;)bRZ0\0CDo˞48e\nS%\\PIk(0u/G\\}4FpG_G?)got[v\0?b;`(یNS)\nx=+@7j0,1Åz>0GcLVX%Q+oFܶ>Q-clwz5G@(hcHr?Nb@lx3U`rwUt8=l#l䨉8E\"O6\n1e`\\hKfV/зPaYKO x	Ojr7F;B̒>ЦV\rĖ|'Jz#PBY5\0NC^\n~LrR[̟RìgeZ\0x^i<Q/)%@ʐfBHf{%P\"\"@)DE(iM2S*yS\"e̒1ט\n4`ʩ>Q*ynTu~%+WXKQ[ʔlPYy#D٬D<FL@6']Ƌ\rF`!%\n0c˩%c8WrpG.TDoUL2*|\$:Xt5XYIp# ^\n:#D@1\r*K7@D\0CCxBhEnK,1\"*y[#!יٙl_/x\05Z4\0005Jh\"2%Yaa1SO4%niPߴq_ʽ6~I\\ddD3g^@^6_HD.ksL@ɈnI~\rb@ӀNt\0s]:uXb@^1\02?T6dLNe+\0:Ёlz6q=̺xN6O,%@s0\n\\)L<C|PbA>I\"	^K4gIXi@PjE&/1@f	Nx0coaߧ,C'y#6F@РH0{z3t|cXMJ.*B)ZDQ\0T-vXa*,*<b#xјdPKG8 yK	\\#=)gȑh&8])C\nô9zW\\gM 7!,9\$T\",%.F!˚ A--g\0002R>KE'U_I9˼j(Q@@4/7'J.RT\0]KSDAp5\rH0!´e	d@Rҝิ9S;7HBbxJ_viU`@SAMXGXiU*':VWJvDN'\$zh\$d_yZ]Y8ؔ]P*h֧e;pe\$kw*7NDTx_ԧGi&PԆt͆b\\EH\$iE\"cr0l?>C(W@322aI{B`ڳiŸGo^6E\rGMp1iIX\00032Kzl&ֆ'IL\\\"7>j(>jFG_& 10IA31=h q\0Fķ_JԳVΖ܆q՚	(/dOC_sm<gx\0\"\n@EkH\0J8(km[S4\nY40+L\n#Bӫb%R֖׭R:<\$!ۥr;	%|ʨ(|H\0]cҡ=0Z\"\"=X)fN6V}F=[ৢhu-\0tbW~QiJL5׭q#kbWnQT!encS[+ִE<-a]ŃYb\n\nJ~|JɃ8 Lpo NܨJ.ŃS2c9jy-`a\0*ֈ@\0+mg61Me\0Q _}!IGLf)Xo,Shx\0000\"h+LM јZ	j\0/\$>u*Z9Ze+JtzRKԯDyq0C-fmBI|HBsQlX.|c[ZhZlx@'mlKrQ26]ҷnd[񎩇d\"GJ9uBoZߖan@nlW|*gX\nn2F|x`DkuPP!Q\rr`W/	1[-o,71bUsN7Gq.\\Q\"CCT\"*?uts]٩Pz[[YFϹFD3\"]u۝)wz:#Iiwpɛ{o0n;\\x\0qm&~79[HqdLO2v|Bt\\ƤHdH\" N\n\0GgFF}\"&QEK{}\ryǎrכt7Nuó[Agh;S.Ҡ¥|y[Ն_bȨ!+RZX@0NP%jD¯z	[U\"{e8>EL4Jн07 d Q^`0`]c<g@hy8p.ef\nehaXmSjBژQ\"\rK3=>ǪAX[,,\"'<%aӴ.\$\0%\0sVpM\$@j>}Ve\$@̈́#(3:`UYu@V#EG/XD\$havxS\"]k18aя9dJROӊs`EJUom{lB8(\n}eib, ;N͇Q\\ǸI5yR\$!>\\ʉguj*?nM޲h\r%U(dNd#}pA:-\\A*42I\r֣ 0h@\\Ե83rq]d8\"Qƙ:cy4	ᑚdaΠ6>UA:@2\$eh2FəN+\rԀ(Ard*\0[#cj>!(SLeTM	9\0W:BD3J_@srue +'B}\"B\"z2rlxF[L˲Ea9cdb^,UC=/2/\$C#8}D6`^;6B0U7_=	,1j1V[.	H9(1ҏLzC	\$.Afh㖫DrY	He~or19م\\߄P)\"Q,eLw0\0;wXǝqo~>9>}dc\0gfq&9-J#3^4m/\0\0006n8>䈴.ӗcph_A@[7|9\$pMh>5KE=hAt^V	\"	cB;iQҠt@,\n)s`;4Iy-0yeʨUBv3HPG5s|\r\$01l3(*oF~PK.,'J/Ӳtd:n\njYz(wZ#Z	Io@1λ\$=VWz	nBaAq@Ip	@5ӖlH{UoXfӿ\\z.,-\\ڗ^y n^BqzX㉡\$*J72D4.!M0DFGLmc*mcI5Ɍ^tjl7替SQ.ihLڱB6Ԅh&Jl\\Wecf%kj pR=i@.(2klHUW\"ojp!S5pL'`\0O *Q3XlJ\08\n\r*a떞r`<&XBh8!x&Bht\$]n߆cL[Ƶd<`\0ςawO%;BCQ\r̭pPQZZAu=N&ia\nmK6I}n	t\nd)bp\"g'07u&@78XNx\$BZB/MgBiѧ\\mmIĀ;5=#&4PՍqA\\,qcޟ\ncBw\0BgjD@;=0mk\rĲ`'5k-{\0_Mu2׆q>)9W\nd+ԧG\rn4O:581:Κ?(yGgWK\r7m5.eHhJAk#L..\\=UЄ:>7W+^yDbGOZ4r(|xPr,y8qaܩO2kn#p2ǈؔ.cUcłj\$8Ĭ~7ZR:׆89Ψw(aL%-,쿌#f%8|c%XW\n}6H˞#&J,'zMMຑ܆ /y6YQںdәd:Ep2gg/,Ո'8^;UWN{OCziKXڔNdGRCJYiy#>zSMUcRORԾ0)0]:=Ϟt'\$srF67	=\$B!qs	1\"v%Il<b!ۮ6(Cd-^<H`~2KzKٜԱy,qA*\0}Cpb\\S5'(|MW5;\$5T|;kt@;9);i.;_F=DM`H\0	 N @%wdPb\$H|k[dCI!:l,<utNeϝW^w'6Dfu ihIZ:~ϣrz3+uoCs2buaXwWK	HԶ27>WyMJrpTL|`f:Atd|i[wjW 7aueA5Q' ʐ\03Ҿ\$\rk)a;H=֐~IGI<\"I1'蠙Gcm\0P\nw#>xB\"Em|2\$}<3PYXgod߶<qE\"`4g8r]\n:qVbTm9K&ғĤm7)@Qz=ߵűH\n}Oi}\r٣.vpJW&u550	5PI\n{ \rm@@ P x4i4+@\0,͛\\C1ӎ誕L>n\0	 ##@]/4JR IRr<ǯj?1Mv\nZ`v\0a-bψ+-yA[|7\r\$ZʭRtޓCErL	rgeR/`J	7~%Xo4di\"QrI:QDQQM~\0Q)ة*,i\0_(,^+c&S~opC@gրBA~s֤\0]/zÃ(_zFOڿ\\\rvEK0<??P=`D^=v*|\n@-\\?kDi4?0l#{%\r3F<P<k4*@}?F \0];?[\r:\0؜dND2?\\hU\0/֢	?Q4c2o5+\rL?N(ڌ(\0|>A[?[/ɿ;]/\\}so`2vh]0\0!PAXJl<\r/\"(D \\TvaRO.#PEH#C*)>tk\nP.0EIH\$f%P0]%ɻXFA@4[\0	)P AM`h\0pd@~A@AkA\no@H֡r\n\$CC;\0-)8s5@/\0zC~  eB^\"P\0XK1^{\n	!lZQR41jZߟ㩋á,gI<HOf\"H,R^yB`҉~ڴ}ۖ N፩q:~M>^k'\$ʈj\n\"	#;``Pqǿ\\\\+<:ca`\ndd\n@jn5p2p@0&0r.Hh\rwȴB	@|~\r\0C\01:CQ1\\pӑY[(Б.RGЍ0\"8P<%<#BX73₤5B	t(b4<&\rV\0G\n;\\");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0\0Dbc!Q7Шd8~N)Eг`Ns`S)O/<x9o3n2!r:;+9CȨ\n<`b\\?`4\r#`<BeB#N \r.D`j4par㢺>8\$c1cc{n7ANRLi\r1!(j´+62X8+.\r!xh'6S\0RO\n1(W07q:NE:68n+մ5_(s\r/m6P@EQ9\nV-\".:J8weq|؇X]Y XezW 7Z1hQfuj4Z{p\\AUJ<k@ɍ@}&L7UwuYh2@u P7Ah3ÛXEͅZ]l@Mplv) HWy>Y-Y/hC[*F#~!`\r#0PC˝f\\^%B<\\fޱ&/OL\\jFjZ1\\:ƴ>NXaFAfh{\"s\n64?8^p\"띰ȸ\\e(PNq[gr&}PhW*r_sPh\nom#.\0@pdW \$ҺQ۽Tl0 HdH)ۏ)PHgUBe\rt:\0)\"t,[(DO\nR8!Ƭ֚lAV4hSq<@}gK]]=90'wA<a~WD|A2XU2yŊ=p)\0P	sn3rf\0FvGI@%+_I`\r.NKI[ʖSJaUfSzM%\"Q|9Bcaq\08#<a:z1Uf>Zle5#U@iUGn%Ұs;gxLpP?BQ\\b龒Q=7:ݡQ\r:t:y( \nd)\nX;CaA\rPGH!@9\n\nAl~HV\nsիƯbBr3\rP%ф\r}b/Α\$5PC\"wB_UgAt夅^QUjBvh졄4)+)<j^<L4U*Bg*nʖ-	9O\$طzyM3\\9.oE(i7	tߚ-&\nj!\ryyD1g]yR7\"~)TZ0E9MYZtXe!f@{Ȭyl	8;R{8Įe+UL'F18PE5-	_!7[2J;HRǹ8p痲݇@0,ծpsK0\r4\$sJ4DZI'\$cLRMpY&iz3GzҚJ%P-[/xT{pzCv:V'\\KJaM&Ӿ\"eo^Q+h^iT1ORl,5[ݘ\$)jLƁU`S`Z^|r=n登TU	1Hykt+\0vD\r	<ƙjGt*3%kYܲT*|\"ClhE(\r8r{0D_.6и;rBjO'ۜ>\$`^69#4Xmh8:c0;/ԉ;\\'(t'+̷^]Nv#,vOiϖ><SA\\\\!3*tl`u\0p'7P9bs{v{7\"{ra(^Eg/U9g/`\nL\n)(Aa\" 	&P@O\n師0(M&FJ'! 0<H*|*OZm*n/b/.o\0dn)i:RP2m\0/vOXFʳψ\"000bgj\$n0}	@=MƂ0nP/pot.̽g\0)o\n0\rFbio}\n̯	NQ'xFaJL\r\r0'd	oep4Dʐq(~ \rEprQVFHlKjN&j!H`_bh\r1n!Ɏz\\\r`V_k\"\\ׂ'V\0ʾ`ACV`\r%\rk@NB횙 !\n\0Z6\$d,%%laH\n#S\$!\$@2I\$r{!J2HZM\\hb,'||cj~gr`ļ\$+A1E <L\$Y%-FDdL焳\n@bVf;2_(Lп<%@ڜ,\"dNer\0`Z4'ld9-#`Ŗj6ƣvN͐f@܆&B\$(Z&278I P\rk\\2`\rdLb@E2`P( B'0&{:dB1^؉*\r\0c<K|5sZ`O35=@5C>@W*	=\0N<g6s67Sm7u?	{<&L.3~D\rŚx),rin/O\0o{0k]3>m1\0I@9T34+ԙ@eGFMC\rE3Etm!#1D @H(n <g,V`R]@3Cr7s~GIi@\0v5\rV'P\r\$<b%(DdPWbfO x\0} lb&vj4LSִԶ5&dsF M4\".HM01uL\"/J`{xǐYu*\"U.I53Q3QJg5s&jьu٭ЪGQMTmGBtl-c*\rZ7*hs/RUVBNˈԊiLk.t龩rYi-S3\\TOM^G>ZQj\"iMsSS\$Ib	fu:SB|iY¦8	v#D4`.^HM_ռuUz`ZJ	e@Cea\"mb6ԯJRT?ԣXMZІpQvjjV{C\r7Tʞ 5{P]\r?QAA2񾠓V)Ji-N99fl Jm;u@<FѠejĦI<+CW@Zl1<2iF7`KG~L&+NYtWH飑w	ls'gq+LzbizŢ.ЊzW zdW(y)vE4,\0\"d\$B{!)1U5bp#}m=@w	P\0\r`O|	ɍYJՂEOu_\n`F`}M.#1f*ա  zuc xf8kZRs2ʂ-Z2+ʷ(sUcDѷX!u&-vPر\0'LX Lo	>Վ\r@P\rxFEȭ%=5N֜?7NÅw`hX98 qzd%6̂t/Ll,KaN~,'ǀM\rf9w!xx[ϑG8;xA-I&5\$D\$%xѬ´]&o-39Lzy6;uzZ 8_ɐx\0D?X7yOY.#38ǀeQ=؀*Gwm Y]YOYF)z#\$e)/z?z;^FZg`^e#?eM3u偃0>\"?@חXv\"*Ԣ\r6v~OV~&ר^gđٞ'f6:-Z~O6;zx;&!+{9Mٳd \r,9Wݭ:\rٜ@睂+]-[gۇ[s[iiqyx+|7{7|w}EWWk|J؁xmq xwyj#e(ߞþ {ڏyM@ɂY(g͚-J(@;y#SYp@%so9;+	;ZNٯº kVu[x|qON?	`u6||Xس|Ox!:ϗY]c\rh9n8'\rS.1USȸX+z]ɵ?C\r\\\$`)U|ˤ|Ѩx'՜<̙e|ͳLMy(ۧlкO]{ѾFD}yuĒ,XL\\x;UWtv\\OxWJ9ȒR5WiMi[Kf(\0dĚ迩\rM7;6KʦI\rxv\rV3ɱ.R|^2^0߾\$Q[Dܣ>1'^X~t1\"6L+AeI~@pM>m<SK-HT76SMfg=GPʰP\r>2Sb\$C[()%Q#G`uGwp\rkKezhjzi(rOT=7~4\"ef~dVZU-b'VJZ7)T8.<RM\$'by\n5_wU`ei޿JbguS?`+ Mg7`\0_-_?F\0X[J8&~D#{P4ܗ\"\0@ғ\0F ?*^wО:u3xK^w߯y[Ԟ(#/zr_g?\0?1wMR&M?StT]ݴG:I)B v1<t6:W{x:=ޚ:!!\0xq&0}z\"]ozjw6JP۞[\\ }`S\0qHM/7BP]FT8S5/I\r\n O0aQ\n>2j;=ڬdA=pVL)X\n¦`e\$TƦQJk7*O .ġ\r\$#pWT>!v|}נ.%,;f*?焘\0pD! #:MRcB/06	7@\0VvghZ\nR\"@F	+ʚEI\n8&2bXPĬͤ=h[+ʉ\r:F\0:*\r}#!\"c;hŦ/0ޒEj]Z\0@iW_h;VRbP%!b]SBUl	r\r-\0\"Q=Ih	 FLFxRэ@\0*j5k\00'	@ElOHCx@\"G41`ϼP(G91\0\"f:Qʍ@`'>7ȎdR41>rIHGt\nRH	bҏ71fh)D8B`(V<Q8c? 2E4j\09\r͐@\0'FD,!H=*E(?Ѫ&xd_HǢE6~uG\0RXZ~P'U=@l+A\nhIiƔPGZ`\$P.;E\0} Q%jAWإ\$!3r1 {Ӊ%i=IfK!e\$80!h#\\HF|i8tl\$lli*(GL	 \$x.q\"Wzs{8d`&W\0&E15jWbćVR-#{\0Xig*7VF3`妏p@#7	0[Ү[éh˖\\o{T]Ŧᑀ8l`f@reh\nW2*@\0`K(L̷\0vT\0c'L: 0@L1T0bhW|\\-DN\ns3\"`Ǣ肒2&\rU+^ReSni0u˚b	J2sps^n<♱Fla\0\0mA2`|؟6	nr\0Dټ7&mߧ-)\\݌\n=;*b蓈Ty7c|o/:tP<Y:K&C'G/@Q*8v/&W6p.\0u3Bq:(eOPp	駲\r0(ac>N|	t\n6v_e;y6fgQ;yβ[S	gǰOuddHH=Z\r'qC*)gEO \"!k('`\nkhT*s5REa\n#!1\0;Siȼ@(lI v\rnj~63ΈI:h\n.2pl9Bt0\$bp+ǀ*tJsJQ8;4P(ҧѶ!.Ppk@)65!(\n+{`=H,Ɂ\\Ѵ4\"[C1-luo4[E%\"w] ( ʏTe)KAE={ \n`;?-G5I.%q%EsgFs	KGn4i/,i0ux)73SzgV[hDp'L<TMjP*o≴\nH\n4M-WNA/@8mHRptpV=h*0	1;\0uGT6@s\0)6ƣT\\(\"U,C:5iKlۧE*\"r.@jRJQ/L@SZP)(jjJL*\0\r-Q*Qڜg9~P@H\n-e\0Qw%^ ET< 2H@޴e\0 e#;ITl+A+C*Yh/D\\!鬚8»3AЙEE/}0tJ|1Qmn%(p!\n±U)\rsEX5u%B- w]*E)<+qyV@mFH BN#]YQ1:V#\$<&Xxt@]GԶj)-@qL\ncIY?qC\rv(@X\0Ov<R3XQJ99lxCuīd vTZkl\rJ\\o&?o6Eq\r'3ɪJ6'Y@6FZ50VTyC`\0VS!&66rDf`ꛨJvqzF@ݵ҅Z.\$kXkJ\\\"\"֝i:E\roX\0>PPmi]\0aV=I6jK3ZQmEb0:32V4N6!l^ڦ@hhU>:	E>j0g\\|Sh7yބ\$,5aė7&:[WX4q Jׂc8!HVDĎ+D:9,DUa!X\$ЯڋG܌Bt9-+otL}ĭqKx6&%xtR\"πRIWA`c}l6~*0vkp68z+qXw*EIN*qPKFO\0,(|k *YF5;<6@QU\"\rbOAXÎvv)Ho`STpbj1+ŋe ʀQx8@5\\Q,ĉNޘb#YHp1kB8NoX3,#Uک'\"销eeH#zq^rG[:\rmng5V]-(W0~kh\\Z`lk ojW!.hF[tAweM૫3!nK_SFj-S[r̀w0^hf-?X5/IY V7ad 8bqbn\n1YRvT,+!NT2I߷K`K\"O)\nY4!}K^D@na\$@ \$Aj\\D[=	bHpSOAGho!F@lU`Xn\$\\͈_˘`HB]2\"z0i1\\w.fy޻K) p0XS>1	*,]\r\"<cQ\$tq.	<+t,]L!{gX\$6v %GHEX*0ۊ)qnC)I\"툳`KF@d5Ap{\\pɾNr'S(+5Њ+\"ĀU0iː!nMbrK6úr|a@x|ka9WR4\"?5pۓkrĘߒ7Hp5YpWG#rʶAWD+`=\"}@H\\pЀߋ)C3!sO:)_F/\r4<A\nn/T3f7P16OYлϲq;؁aXtS<9nwsx@1Ξxs?3Ş@54oȃ0pR\0yqL&S^:Q>\\4OInZnv33+PL(.x\$«CCnAkc:L6rwhnrZ==jђ6}MGu~3bg4s6sQ#:3g~v3<+<a}ϧ=e8'n)ӞcCz4L=h{iJ^~wgDjL^=6ΧNӔ\\DNE?h:S*>+uhh҅WE1jxt't[wS9T[,jvtA#T枂9jK-ޠYiQe?4Ӟ_Wz@JkWYhpuj|z4	im	O5\0>|9ז轠gVyu=}gs_Vsծ{k@r^(wH'a=iN4_{6tϨϗe[h-Ul?J0O\0^Hl\0.Zxu\"<	/7 i:\nǠ;!3_0`\0H`2\0H#h[P<עgm@~(\0ߵkYv#>\nz\n@Q\n(G\n'k5n5ۨ@_`Ї_l1wpPw\0coEl{ݾ7o0Ibϝnz﷛ {8w=|/y3a߼#xq@ka!\08dmR[wvǋRGp8v\$Zmtǽuop`2m|;#xmn~;VE3O\r,~ow[N} clyO;?~^j\"Wz:'xW.	u(Ýq<gvhWq\\;ߟ8)M\\5vڷx=hib-|bpyDЕHh\rcey7pxG@D= 1!4Ra\r9!\0'Y@>iS>oofsO 9.\"Fl20E!QːD9dBW4\0y`RoF>Fa00	2<IP'\\I\0\$\n RaU.sЄ\"1ІeY砢Zq1|#G!PP\0|HFnp>W:`YP%ď\na8P>`]4`<r\0Îz484`mh:ΪHDj+p>*8ՠ08A:с]wúz>9\n+:iiPoG01)ZږneR֖gMgsLCr8Ѐ!3R)00sIJVPpK\n|9e[ˑD0z4ϑo,N8ns#{蓷z3>BS\";e5VD0[\$7z0=8	T 3Q'RnLyŋ'\0o,\0:[}(|X>xvqW?tBE1wG;!݋5΀|0JI@#uņI\\p8!']߮l-lSB,ӗ]1ԕHN8%%	/;FGSh\\لct2|W\$t<hO+#BaN1{yw2\\Z&)db',Xxm~H@:d	>=-lK܏J\0́@rϥ@\"(AZ7h>\\#>\0XrYYxŝq=:Թ\rlomgbD_TxC0.yR]_ZǻWIG	Mɪ(|@\0SOs {@k}FXSb8=_l\0=g{HyG s_J\$hkFqd4ω'>vϏ!_7Vq@1zuSejKdyuS.2\"{K?s˦hRd`:yGھ\nQow'hS>LX}eG@9퟈W|Ϲ@_uZ=,!}\0I@#\"'Y`\\?p,Gל_'G	T#oH\r\"o}?O鼔7|'=8MQyaH?߮ \0bUd67I O\"-2_0\r?hO׿t\0\0002~° 4K,oh	Pcz`@\"H; ,='S.bSCc욌R,~X@ '8Z0&(np<pȣ32(.@R3@^\r+@,\$	ϟEtB,⪀ʰh\r><6]#;C.Ҏ8P3;@L,+>p(#-f1z,8ߠƐP:9R۳)e\0ڢR!\nr{eGA@*nD6N\rR8QK0颽>PNIQ=r<;&fNGJ;UAAP&`);!s\0pp\rn(@%&	SdYuC,8O#oRv,#|7\"CpB`jX3~R@v9B#@\n0>T-5/= E\nd\"!;p*nZ\08/jX\r>F	Pϐe>OLO0\0)k㦃[	ϳ'L	1 1\0C1T`RʐzĚp< .>5\0> Bnˊ<\"he>кîs!H{ܐ!\r\r\"|>R1d\"U@D63>o\rvL:K2+0쾁>\0 B{!r*Hy;`8\0دd\r02A?+\0Å\0AwSl\r[ԡ6co=0z/J+ꆌW[~C0e30HQPDPY}4#YDp)	|@&-/F	T	aH5#H.A>0;.Yġ	*D2=3	pBnuDw\n!zCQ \0HQ4D*7\0J%ıpuD(O=!>u,71TM+31:\"PRQ?P+11= M\$ZlT7,Nq%E!S2&U*>GDS&ozh8881\\:Z0hT C+#ʱA%D!\0XDA3\0!\\#h9bT!dYj2S\nA+ͽHwD`(AB*+%EX.ˠB#ȿ&XeEo\"|r8W2@8Da|NhJ8[۳Wz{Z\"L\0\0Ȇ8x۶X@ Eh;af1;nhZ3E0| 옑AtB,~W8^Ǡ׃<2/	8+۔O+%P#ή\n?߉?e˔O\\]7(#D۾(!c)NMFE#DXg)0A\0:rB``  QH>!\rB\0V%ceHFHm2B2I`#D>n\n:L9C0\0x(ޏ(\nL\"G\n@`[\ni'\0)y)&(p\0N	\"N:8.\r!'4|ל~ʀ\"cDlt0c5kQQר+ZGk!Fc4Rx@&>z=\$(?(\n쀨>	ҵCqیt-}G,tGW xqHfb\0\0zT9zwЅDmn'ccbH\0z3! HHz׀Iy\",-\0\"<2'#H`d-#cljĞ`i(_dgȎǂ*j\r\0> 662kj<Cq9ĐI\r\$CAI\$x\rH78 ܀ZpZrR_U\0l\rIRXi\0<r~xS%^%j@^T33ɀGHz&\$(q\0f&8+\rɗ%2hCxIlbɀ(hSY&B`fxvn.L+/\"=I0d\$47rA(42gJ(D=F(-'ĠXG29Z=,r`);x\"8;>&',@2pl:0lI\rrJDhAz22p`O2h8HĄwtBFg`72{,Kl߰%C%om+X41򹸎\n2p	ZB!=VܨȀ+H6*\0k%< K',3rI;8\0Z+Eܭ`+lW+Yҵ-tfbQ_-Ӏޅ+ 95LjJ.Gʩ,\\ԅ.\$2J\\-1-cˇ.lfxBqK,dˀ8AKo-3Kr/|/\\r,HϤ!Y10@.&|+J\00P3J-ZQ	\r&\nL*jĉ|#Ծ\"˺A/8)1#7\$\"6\n>\n7L1h9\0BZd#b:\0+A22'̕\nt̜O2lʳ.LHC\02+L\\rKk+˳.ꌒ;(Dƀ1sds9P4쌜@.AnhJ13K03J\$\02Lk3Q;3n\0\0,sI@u/VA1UM<Le4D2V% Ap\nȬ235A-Tu53۹1+fL~\n	-> ҡM4XLSdٲ͟*\\@ͨYkSDM5 XfDsUs%	̱p+K6/ݒ8Xނ=K6pH%3ͫ7lIK0LDu`P\rSO͙&(;L@ψN>S28(`JErF	2SEMM\$qE\$ã/I\$\\ID\"\n䱺w.tS	ђP#\nW-\0Cҵ:jR^S8;d`5ԪaʖE+(XrM;3;B,*1&2XS)< L9;RSNgIs+ӰK<sLY-Z:A<OO*2vW7+|˻<T9hy\$<#ρ;v\$O\0 ,Hk-Ϛ\rϣ;O>7>3@O{.4pO?Tb..~O4S>1SS*4Pȣ>3\0W>2><P?4@t\nNAxp%=P@C@R˟?x\n0NwO?TJC@#	.dMt&=\\4A:L\$N:\rI'Arግ;\r/CBӮi>L7:9|C\$)z@tl:>C\nBi0G,\0FD%p)o\0\n>`)QZIKG%M\0#\0DQ.H'\$E\n \$ܐ%4ID3o:L\$m 0	B\\(8通hDCsDX4TK{x`\n,\nE:p\n'>o\0tI` -\0D/KP`/H\$\n=>UFP0UG}4B\$?E%TWD} *H0T\0t\"!o\0E7R.tfRFu!ԐD\n\0F-4VQH%40uN\0DQRuE	)I\n&Qm)ǚm #\\D(\$̓x4WFM&ԜR5H%q[F+IF \nTR3DLoy4TQ/E[ў<t^F)Q+4QI#IF'TiѪX!ѱF*nR>5pKm+sIRE+ԩM\0(R?+HҀJ\"TD\$	4wQ}Tz\0G8|xR6R	4XR6\n4ymNQNM&RH&2Q/7#қ{'ҍ,|\n	.\0>{o#1D;?UҕJ9*jFNщJ #~%-?CL3@EP{`>QȔ%O)4R%I@%,\"I<\$ԉTP>\n\0QP5DkOFTY<oQ=T\0x	5D,0?i?x  mE}>|[\0&RLHS9GI1䀖M4VHoT-S)QGF [TQRjN#x]N(U8\nuU\n?5,TmԞ??@U\nu-R9U/S \nU3IEStQYJu.QFo\$&i	KPC6>5G\0uRu)U'R0ЀDuIUJ@	:V8*Rf%&\\RMU9RfUAU[TUQSe[\0KeZUaUhmS<,Rs`&Tj@G!\\x^0>\0&p΂QQ)TUPs@%\0W	`\$(1Q?\$CQp\nOJX#V7Xu;!YBSc+V#MUWHURǅU-+VmY}\\OKM\$SeToVHT!!<{RZA5R!=3U({@*Ratz\0)QP5H؏հN5+P[9V%\"\nGSL9l\rVؤ[ouUIYR_TYp5O֧\\q`U[Bu'Uw\\mRUԭ\\Es5K\\V\\S{AZ%O\$F>5EWVm`Wd]& \$Ό!RZ}ԅ]}v5ZUgQ^y` !^=FR^vUKex@+r5#@?=uΓsץYNsS!^c5\$.u`\0XE~19JUZ@#1_[4J2\n\$VI4n\0?4aR!U~)&B>tRI0_EkTUS|Uk_8&E(‘?@J5JUBQT}HVjQx\neVsU=VN4ղؗ\\xR34GD\":	KQ>[\rY_#!#][j<6خX	c#KL}>`'\05XcU[\0(Wt|tR]p/]H2IQO1SQjZHm)d^SXCY\rtu@Jp%M?UQ\n=Rar:ԿE-G\0\$d]meh*QWtc`AY=S\r	m-=MwH]J\"䴏f\"{#9TeMcNIDU6g2ݝeaLQ&&uTX51Y>S֊Q#Ij\0WP?ub5FULn)V5R@\$!%oP'EUP-Bp\nF\$S4tUF|{qȓ0Umjs\$ڛjcڐ֫aZI5Xj26&>v\n\r)2_kGTJeQ-cZVMֽz>]acc`tHj6+kM\0>##3l='^6\0èvZ9Se\"bΡB>)/T=9\0`P\$\0]/0ڪ䵏k-6{k[F\r|SѿJMQD=/WXVa'atol冶Xj}C@\"KPom3\0#HVv~{?gx	n|[?U[rhG`3#Gk%L\0I`CD	 \"\0ŧ#cN6ڹfzێ;ѤeeF7/N\r:QG9	\$Iռ]TWGsdWMIfBcۤ!#cnu&(S_wSf&TZ:0CSLN`ܳYj=>ŲZ!=rV]g	ӣrXl-.U'uJuJ\0sJ'W%\\>?BVj4J}I/-ҝrRLS3\0,RgqӭTf>1\0_\\V8Ztc耆<^\\llj\0T]CwΓzIZwNpVWjvY>2	o\$|UWL%{toX3_RJ5~6\"Zl}`kceR=^UԎ1ѽw7edvb=\0f,m)Gp-Ӽ)9L>| \"@5`:\0,t@xlJb6aA\0ػAR[A0\$qoAS@<@y\"as.V^讥^\0H[H@bK)z\r=^zB\0No<̇t<x\0ڬ0*RI{^E:{KՐ1E0Y/c\"\04F7'\n0`UT?MPl4r(	Z|&t\"ILw+m}Wi\r>U__u63y[8T-V}x_~%7{jMo_E~]P\$JCaXG9\0007Ń5A#\0.\r˴_%\n\r#<MxJ|2\0;o^a+F笀Lk;_#M\\pr@õOR~zANEYO	(1N׉R8Cn?O)1ADo\0\rǢ?kJ\",OFa-b6]PS)ƙ5xC=@jLL:\"胻Ίl#Bk@N:>|B9	:N\$S CB:j6ΉJkuK_W͢ØI=@Tv\n0^o\\Ӡ?/&u._\rC+c~Jb6e\0yѡ\0wxh8j%SVH@N'\\ۯN`n\runKqUB+f>G\r=@Gd\n)FO hʷÈfCɅX|I]3auyUi^9y\no^rt\r8͇#N	VY;c*%V<#h9r\rxcv(\ra(xja`g0V̼Qx(glհ{gh`sW<Kj';)Gnq\$p+Ɍ_d^& Dx!bv!EjPV'(=b\r\"bL\0bt\n>J1;ۈ4^sQp`fr`7xE<l	8s'PTֺ˃z_T[>:`1.;7@[>6!*\$`\0`,@?m>>\0LCǸRn/+`;C\0*<F+q M;1K\n:b3j1l:c>Yhގ#;3ֺ85:\\\0XHaM1\\L[YCvN\0+\0t#\$!@*l	FdhdF&Ƙf)=04x\0004ED6K䢣\0nN];q4sj-=-8\0sǨDf5p4J^'Ӕ[H^NR FKwz EgF|!codbx\0-6,E_3up /wz(exRaHYce59d\00@2@ҐYfeyYcMוh[ez\rv\\0e\\cʃ[ueNY`ۖ]9h姗~^Yqe]qe_|6!u`fJ{7M{YهjeCS6\0DuasFL}\$ȇ(MbƤ,0Buίт2gxFљ{an:i\rPjerrGBYM+qiYd˙`0,>6fo0o Xf\0VL!fl6 /1e\0>kbf\r!uf<%(r˛a&	Y!mBg=@\r; \r5phI9bm\$BYˋgx#@QEOm90\"!tˉЇO* \0>%\$orN&s9f4g~jMfwygy\\`X1y5x^z_,& k|1xA6 \no蔻&xgg{r?緛-|t3}gHgK9J<CC197gh6!0HcdyfDA;9T0\0p! 6^.S²?E(PΈ .5hEPJv.+\$5>P+?~g6\rhpz(W`\"y:FadŬ6:fi\0A;e^wf >y`-\r\0hr\rr8i\"_	9CIfXˈ2\"ŢhL~\"%V:!%xyizygvx]}qgZi|`+ _g٣譞6PAʀ\$=9h|p!.!i^iˢ8zVCZ\"(9U)!DgU\0j?`4LTo@BNa{r:\n̟E8æ&=E*Z:\n?g̊h.N5(Shi2*cf@7z\"|rP.ǀL8T'k:(q2&ED2~ر9v8@^X=X`qZQ֮`9j5^@竸nqv3(I6jdT\\ 3,hk3(3PuV|\0阮Uk;JQ.	:J\r1nBI\r\0ɬh@?N\nsh\";r~7O\$(5R	ʽjFYFܔ~x޾f\"vۓo˨º#aP<h-3麝/Gxni@\"G?,ZpxX`v4X[I7åXc	!b}j_95qti6fٞ5FƹiѱpX'2r0ƺD,#GU2؏I\rl( 챣=Aa쩳-8dbS4~H;06b{޺Rs3zNބ`ˆ+4<^ay	}ryk&4@?~cE@LS@z^qqN</Hj^sC`sbgGy^\nN\n:GN}c\n +=p1NTB[dЋܹ`noj;jěwhc9p̡[y405͋N+ο`Xda/zn*P#t赸~9W	V~=#n)	2;j:JkC!>x5==2.|'[';v;:SA	&[men˵<6ma=Y.神:g腀;I߻x[IJ\0~zaYwT\\`V\n~P)zJQ@[{rʉDBv|i-EK;^n{:Nh;2ƀpѴ6罘99XhQ~iA@D j}ozLVѳ~	8B?#F}FTdezcFg7Η 6#.E££S.J35KɥJ;n5:ySCvoս.{	d\\0?W\0!)'Eg;+\0YNtbp+c\0B=\"cT:BcPIDV0!ROlON~aF|%ߺ)O	WoQw:ٟl0h@:օ8Q&[nFp,æ@JTw9(<{ƐO\r	ڂ\$m/HnP\$o^U\"{Ė<.nq8\r\0;n硟+޳3n{D\$7,Ez7\0l!{8x҂.s8PAFxrQۮ1̅p+@d9OP5lK/\\msqvQ/	!z7oEǆ:qV5?GHOO\$l+,\r;~Ač錳{`7|Ăr'Ji\rc+|#+<&қ<W,>^P&nJhe%dCizXA'D>ΈEk@Bw(.\n99AhNckNd`p`%23Hb2&<9R(tTH	z' o>4?\rZwӂ4`Ї鍆NӀ'-I0(Srw,Kr'-2Hlo-U_'W#'/H֟j6̉ȫ\0<j1EQTTrBcm16͈g٫:w6ͯh@1I:2pL/w:őK<E<J76Ӏs.̲sZ/\$AsEyϜrr:w?Չ!?ǙZM9՝\01?ARͦ%7>MARr}sr)\\t-8=ЎU,WOCsՆ#w5ERlM*D1>]gKV\n\\s܇8͹seͧ9so~w4xf@D96\0	@.@9\0C;Ky+J٥u<\\`c{ӋE>yJ=l/-7Z46uC5PΩRVʳlVaNx`մ?U7(HP}jVJzNQJSs-gQ!aV_SwRO3amZXwZo'waOoZ![\n<ZOҶ'Omo[a=Q>:T\n\0=mjATRbu(I:\$vWuS\\V8v\\g!Mжu_&is\\CRVM]tXT7\\UoTo_ԯݛS?alS-LutZGei`	}XZi}QyW[iTYo(ZE\\}nٍifڋWd%Tpu3uTf5)v]UR3VEY]X\n^VqSS}XiGfv>SvJMQvڕ\\g]QYEݵ#1Vl5UEK]\0SU?\\BwSU7mZV5\\Wfէ[eUr{G\\U,W[]xVj5mTVj~u7\0VU'tw?ms5Vvݏq}u-Uq]ݗc]W]Tt:fMke][-p}^I[XDYVdO]	seNZWY[tV?3ǵMݙ`t^wd:qTL@@>]j\rFqv-LvGKwiLwIPMoǹMgv[Uss~	w:BANE{!-do\0}&hXA5%٣fzLH5d Y_%vә!m]%=B>E [#^}hYFa>{gSp[FDa6nx98LI㈫Na=S@bPk.NHl\0:2#Θ;vO}9ik]	&{ 2|a&Q)oفǸ:&.\05q\0JL64hy3ޢaރIzOﮈ\"yBʳ{3%5r(mx.7rb%^eM2\0x!b}.Y6\$qS\"^|xEaXǡ59'TR	c9W1AΔP؏h6'o-pT(\nn\rŐ1RRUgxPe#*kT<<>b;\0gL.<kZvz8~y7Yȁ7wOdn><E3wSۆ@ oW1Һze޽1z\0f=c㊤g{>np\0Α:HBn6FBrW=C>M.1~@3G98q<S|Y8QP`L[qz۫PN<{_-ٮdOd-NB74BN.V9ƨQ3{IcP\$h<R yy?G:ng;Ah!&+>ˀ;Mˌ	6SNڌ=#`T#+n;r,X|#\r#?\nD>|VSeϗ~Jm99\ns{S|r],~˹ qI?\"|w%|j\0rE,kSnqƕd8B.1\"/|؃]EϜNlxI IcŸ.|\$8DFPK3\\jxUC/җA{eܾ\rpU\n՟Wlo­Y{`]'s/|o3r};[nOM7ߣؼqq(_lqsNy;igt:ՙqk{?zMȗo'jcy߄ggkwf8Vc7fAY+Kx=gKAkT,95rd+Gٯ[%Aw柞7ଅ%{m8%_mqV˨_%!Ei~h~C߭~%_rLkDy~?p1O!?v\\Pm\"<E6 EVzk9z~/պ!Q>ONm3r Fle;M߷Ͻ_a!~Cfb}3 Kf. 	}.DX	i5|?=\0???@Õfu~a^nyQ;q)sS,\"G\nu%UYAKl\nBI86VCcO\0`}.x,-N@~TG'dJy1zlæfgABa!M\\<gʃz4ƿ@/CÂ@	Qq)x/.7inD#= *79cFd2(.V3\$g`A᧋rl|mb/qEô!bU@9i;ppdפ=1yxx	=v=(vs_Boɂց#K\r n\\# fPXu-3&	J&,F(9v0&@khZygCԋz Áhi=s9T eT>g3dtF2b&:\0PB-Q8~LSMڷcgTh'f(\$.EVLAIߌrg\r0T1P`1d\r4=6@F F=ɂ6A>NAV	(\$A/;?gf^	\n&KOn{]g˛8cўϷ\n7Lt:ѠhFVO\rJ)b(\"OBm	o\$]TSHZ^Kw\\[A9('لcۑb0 KsrBx\n*Baz6o\ry&tX1p'^M<Cg`48GHzd?gX.@,7w۞:+TiUX16Ls:\rL6fr\r`t67~gxgH9JO=-\$4?r٪4O:z{D`21Fܵ(DM;&́ڭU>I6c߸@\r//ԕ_H\n7z 7aɻ[9D'}BORݟB#s]z!(D@L^	x@ouOD!e`\nak>0`-*8EZ6=f%c㛰K=F\rShyN[v*v\r@#߸퉁Ah*L\$AA\\%*	p\r*==8\$W\r [Jx0yZ+&YHA~A\n,\\(p!F<6S&IP`6Xz+df\rJ£is+&5/rEM^\$R(RQEw3lH*m\0BqarLBQz6~lB\rI®GXٸXVbsmBHc_K\$p-:8Nj:х-#F	\0aiBs\\)<.!\\NbIw8͹tPjW`y\0&0i?Ҕ:Ia)=C,a&Mapƃ\$IIFc\0!Yxa)~C1PZL3TjC\0y`\\W\\t\$2\n+a\0aKb\n]C@?I\rHヮKs%N^9CL/=%ۨh:?&PEY>5n[Gْ%V*w<gJ]*wd]B5^֢OQ>%s{ԅ畫;WzGi*RnG9E,(u*Ւ×XsR:5;)RNvK(RMb_{F<<3:%HVYS\n%L+{o.>Z(QkN!,:rH}nRNkI		[ӧg֤;mYҳg%9V~-J_g\\ɮQ\n!t\\UY-tZnd:Bʽ*]')twɫ[BUm*r4ؖ*yvvZչ+GHZnP܅|\nT %#\\AX\0}5b+wrXwܲ1u%Cg=Iv`cre0`..<h+H̝^\\jyF%]B\0r+>%Zx %C.`Vn1KSk\rX|[;6H	U@D:޻Mj	Ε?]ڤbA+G\0thxbL`64MޛY#hfD=ew=c+H:.%^\$DZrAzjfLl7o\0-Edމyz'V ӞW	ZK+d(AfyP?xR^h'A\0:p\rd(Vdt	SFcHȟ]rrCHY	X_/fͽ 4 7e6D{,<<Z^j\"	\n+ƀMY9A(<Pllp	,>Ѐ{E9&Ghh{(Agg8(@jTngZŰJx@icՋ(p'oJ0MnĀ&\r'\0Ց\rqF4)cL_oJ}5co|6m}Q4Qb[xm( &@;+򘥮f|IR48 {	`k`ur`W㸱`\")fI\n;8Zjg~AΈ!j%TE\\\r3EjjFXZ	AykHXdgCQ΀0dt	zk`@\0001\0nH\04\0g&.\0\0O(P@\rE\0l\0X\rE8x@ԋ\0^z@E\0.^Qq\"YD_p&3\0mZ.Pp\rEϋsv\"0`w,_`\rc/]xq3\0q.pq\0002_iъE\0a1bwJ \0l\01,`1y\09#?0T^q\$F6/\$dFDyJ0b\0	W\0.c{c E\0s3l]@\rbF\"\02`\"7/\0a	^04eQ{c<ьj/_ѐc\0001*28BA\0000xƔiؾ1F50ljH\"F30\\_q\0fTl_0тBEČ#3]sƽ64_X1\0ƽd``\rS_JMV/f1\0005I6tf4F34fF-6d\"4k\$h±#Ě\06_01c@F/d]XQ#G\n5gqEF\nm\\DnqYFv1/4`q4=8bq|\00043mX1e\0.\\QcI	.7\\x`\"\0i^3(籒\"Ev4l_q\$FoȾ\r#UE䍩^9t.\03|r1\069l^xѼPF-]\n0vQy\"G2,sxQq#F+\0/Diq}8[6,j\0cmoN5ehQvGLH<T_Q?Fɋ..\$fyEC2l1s#EDlohѲj8eűbF!9`xqC7hx٣Ŏ7^xK<h	,u鱑G);lu#Eߎ<kb\0sR.wֱ#z~w2|x(\0001':v\0001G挿?|` .2X#G8K@<z1ƹ\"9|j	G/6qGs7/\0001bߍ:|8Q#~FW4g#<F\r 2XQ#Fvk7x1#Ǝ@rhFZ;frcy!\r	_x1\"H10Twٲc\rF1 \n8dXrԌ2Db{d4HrA<~1dBHI[J?q~k0t#F\r#0\\h\rGEttc7U!=D_cN\0y6a Fg!v1q1KǇ@eѳcGo\n/ƲE\"3t`#cH<cqF%?Tb蹱d) r0qcE>3\$tyQңECl`9)VFHMJ7f\$HHQ ;ri7#F-FHQ#\0G!1^&4vG&7gృ\$\0G\rr/dR(s6@'RAǬ&g\0k z=|Hٱ^J]sd,\$1<cqǦJ_bGQvJرH5FpIc[@rvH%3Dc<I\$M.dr1c=F.4c2bG.!L|{Xѳ{INFdxqscݍ#Ea)#GJm.\$=GhAN=sŤE͑GG\\a10HF.tg8ä[Idn8F.TF3E6riqsF6xrL=nFTod>-3|2\$0= :xcHI\"NP\$bQ\$F DĂ}F%?(G3\$O\$^x2T0R#D:E|i/2XG8-\$Hv=d `:laxI:XRJRmxJ#\nGG9!N{cI&IR=I\r&j:8g#H'3_xbH}>7cُ\"&K<x2H\"6@db뱭e;)!.]/dm*f6,vɪL(qAI87d9TtcULX%HI*z:|IXqs-Bq^(Raq(~e9JU+-eq*nT>\$ѫerαp\nռ\$es+VIbeq:#]cc7r\nf,gYTC%	}\0\\*EWPa:E,&Wp)xlM3\0t\0/IipD'\0	k\$TF]fdMȀK\$H(@ɔ(znWҤ_Mݔ*\0elF^H	W*BZPe֘R/dRRʅ\0Ku,yH)\"SXI'Z=LR3\n'[k6@;}RI_)w[ \nnʓbBrl,\$v԰H\\s*.QtBdb@?3S`a@K\\.~f),?|&ӶKZ9.X+S|\0PʼEe/\0V^K\0\n-	:Sز)ת0j9TXBK\"ů²,2'2P,xpKꗪ\"D#TVD1Ao;ؕ/9TH%V`WJ<9aeʰK/V^/Q\nBZ\"9XүM~\$5\$0dIU2^X\n*E7I\nV3+aIiNKKg0az*V#bJyMҦeZ V`U1C.\rF-j&LUp9s鹊+Q&1RmӱgZ	,.XryZ첰032A1ւeN(?Al ,Nue\$|r_%E05E}\$X2%Ze \n\";<9ah㶥a]8*uLdR0+Qm.,GM_2edBݸ,S2>U԰4vl~e22eĵYg2nf=\$%ٖFfa)fTƶGg2W,[X>)tA]R*&Z6j2|\0(p	9 uҪ?`n-lZn!H9zL9VLϹyݢZJhRgEfLU~`4Yx)\$BQR#ÕS,6i#Y,;Cri&X]\nw54Kx\n*&TW+SлqNcyIW\0W5cɫ&+Vr)Kg? |gRhR%K)Z#5,ֵk漻`l:LsC[MUB6ldѓJ1nl:jLߖ\0h *)p/ާ5\\<9V/ޫhTdjrMbx\n]RWR MaU3=`0o,Zl}m월lmLS6\\tΙL\\%JK7oѩefMoCYv慭NV4=RsJ*hhn-m44yHM|isU=A\$ڭiϙ>ppQfq,5sUL8}ݬ٪#XHI9U8c:If7kl5}fLYN2ް}&	ic,I3R6r؉3b͍6>lXYfL)+S,ى*elU\"ed\"Zږ6ZDE9%΂Y9rmtE'.M[4^ɷ;Mw59av+70ld%<3_<lN(v+7YRl΅Ӫ].4I)=փNT]۹'U^?S7XCũӨ1u9EߙkL;NhSqNXk;1[LgpVB1_gs;RlENT8w,s1Pxrq3(;Z	yӾ'{O	_rȪMg|I92eLfO\rYnkuSNv9Vk	3ǧ.̛v9zyd)NY&s\$jd'6͔Q<V)e+:جYjtpu<ʖ3]qMY:9XSgIÝ*mCvGR@֯jT=:e(\0_Vn,?p	3'Π\r|\"igTnP皤\nӔq,Sf.YQ AA,ZeSsE\rvTQZ\"pIsUAϛ\0vZ}rKtfPf9疮{^Jς\n0%NGګ*~lD.Ke6[,%O՘-~쵕jRO;@	˨enb_%sKŜYY0LWjrՐφ!BPvfwګMR22z4rh;#M@}\0|M\0=ځ=f-!6pg[P4C[5:\rCtàu@ۺ<ifNun[!u8j{&9KuFQlRi(CA䮙s4\0Y;fB<{嘼R_I~6|MWTA]4e@JeP|[r5*OΠBt)%-\0Pjm	us}ИBi^*z0YK.`[Y2Ы|XB(?З.\$l,XD\njOD->_<֝\0sh\\ea\\\0e䑙Y`7U\"eCYTzt:V9P_aЕF;݀\0M2eHCZ?V'}cYa脬?Qh8	0QCM`6,JeZZ\"GWuu\r>49KI%LV9։Z{VEOX;oagP\$\nRX@}!-SiRqz	ITH.\nk\n\ndϮT>\n?E`5D+f?#zIZ7T[Qs#D\$PI	3*:9YIHHX0D!u7JmYB}E简r8Q\n}'PS	Q\$`R)^(OP\0aKm3\$H.X)V`9 .Y18eU`X9	\\LcjIE N鍫6WDXB	Z:|Ϥ:	E-P-&)*l)Puy|RLh.p_*QA@ ?,ƧY)tч<P*jVuQ:2\0L?J,TPHLE%\0yP(YJZTHX\r	Q4hO;\\vV#TWw\\`Oҡ?JR2=F]I5TMjI9,(ƤDv|t)Wy-]zea,pQ6\$I-g=%SW#TPܐ)T&]X15jB8Vӥ\nem yh*d4ςbd!0gRJ\\ Mt1R\n\nx._u+Ƽ;*4θ)]\\l(m\"QnT(*\0`1H@2	6hYcH_f?a7=KKdetH2\0/\062@b~`\0.\0v) !~JPĝTO{t\0005/ீ\rJ^0a!)8%KޘPP4~H\r+Lb/24)GKe0eS1B	-0jfSwLΙid L\r1hȩS MJJht)+?Le5n|FHMN5jɩSHL4=TDMn6Zm@I@S`)'7fzSzx~OU1kSFMOU4p٣2\000076k#xSl'K77\nlxSuLR77stxS}GM78*qt#xSOM\"78u)ӏ\09r)Sr2;)7Njm/xӿsNڞ:jy4SgO:1=\ncTSͧ;{Sȧ/ORH\r=tTIݧO\\zx4SM>j|TiSO~\$lO}t٧Oz*%]PPvU\"ݧK@\nojH;P>1FdP.5Bظ\r3uB<L#<QPECʁu*\nۨyPNl\r6?KmBZijHO2}1JM_MmD&KQ6Fzv6ӹQj;jj)*mEʌ9FdQv5eGɵdԄEM\0+D\"j)SDQҤpZfƂmR&HUہ%{Rv0m0z䧟Lƥ@'ER?eJ>ԝMIYTR/Bʕ.UTYRΡL:jNԅRL5ji&,OmJD5,9Q1hTfNޥQ'7Lih\rcjԝSzu\0nԺg9@c\rT%LAfTMT9uQ\n)USuD:jU	ƨPږq*EڪKSbl\\ڤFŪGTzgJHSF	\"Q:1;RꦵL*~EߪoTҦ\\z:]SꕱBU^JuR*kE	TQtRg2UjV\$_SmPHU\\T[Uʫ5Jhٵ\\UpV7a_*=R>\0I*VX:hU8jTKZ\\:)jT8	WZUbJ8R=YUVUR\\:-jѫiV.[zҪ-{TZuojU3 [>E %\\h#bՅWZ-\\CW>]ںg4#KTrZʤwj\$z-RjtjU*Wtp\n4'NMxUX32[x+\$BUS*qUͪqXZ}Sx@-W\n5XZՅJU2=\\F+V0]XXU0-VJ+/Zʮ5sjDU޲%bɵV%Y^u@dբW愔ŲRk&YR\\ŒRkYcVO-\\	kdKoXK/9]VO-U<@嬥Vγ[6U=eϵo4TݭY0eHդ\r96(󮝕+7ybrI |\0:Fz\n|s<R%J]F3jΣYZ^<5XIJM`nO\\B&rsQuzx	TVwJ5g	?vqF49ӝ6zjOV\ru=@ʒfT͚y	֫pKaXU9m\nekMo5\nhTꦦVv:s\\p>L:)O=nk}jS&֮~yeܚZֵ)jtVRVsr:+ao,!TlUϕ*n5\\Udv+M\\)]B|Jl;45pLӵئ7Li[~bmtSe\"Bvd@ͧS4)ؒZ\$)5ic!Ό\\R*SDw\$9tS\nGfPԛʸ*	KDVy5uȦJב\\C\$W,M\\5k^Vs5kֻM^{uϤwFQJHgWNk8ʉ+1br˕VX]dLjYTv6twy˕kvx=5h8]˷x\"c|ufU\0ҧ5jȩ}Pkn̚Rlf٪+ۣ>c4W+TDoqSXb}}hn&<?/3-áhqn	p%)SyP\r͵m-f5[\\=T}y )Ydؤ46#Y>3נm\n09h;40+ae\nȃİȞ!)@xx}\$AFÑ0N R	ӄiܥU?b5!+׭\0Gw{ӤlI )w-4;p8ؤ;@\r\n\rN5ƅF\\ӹhgPE il0X%)\nLk^2<5FdI<FjbMd'	ƲDBmaOYXgg8ZV%mf%F-,\naFwfs0G乑Z\n	1;J1\"iPByCtzӉ;l4ҡJmLX+lᘪ{8\"\nV(\$Y\0d\\݆6D9BHd%16f \"TJ`/>C=c쨱?e!k*3l~i,Az/dMoڲn\"ɽzTr}eٌ{MaC7fiT/6WP8Fa`5Mf2V]['}cn4]heZŧ\r2XllGa`((\0_lOf&f1c8D{Q	S6p\0Y\0\rq3m&*f;p6r^cϳ`ɵ&zn^ڱ;DSoj^=L'g5&Ef&|\nK 6?bX*.fψE~&9!dk@v\"FGx\\=E7XP2[:\0׎X~7X64(\";B\nXhy&DֈZl\nKCp`mS	2U;G8{-WBm\$F\rl&BY2\rmAőwZ6RВ%d_T5``BaGcXK\r\0gN\\;Ns^\nuѲVwzUF\"\0T-,^\02 / EW/\0¼ľ4;\"K-NZMcλRVNeZwj6aÿKVlN?jt2T/[Nj|0t% #\0`5F<X@\nӢZF\\-mcd2p5Gv'B'7{k*'LAZ|Ik\n-.C6k-Sk]_\$+Gנ[^z]k8\\F|?B^B̎|@BzPW/R?[!bBkѠ'	(e:xfr7\r_qMa\0#7|Q&\0Ɂ@)1뮆LA[Pt\0`6\\ezxS݀vՈπU:ڱTϗ>f\nql+K(|\\ѠGU؋@(*iS%F\rR\$CL;dļg-\$m?lhʝ3?PY\0");}else{header("Content-Type: image/gif");switch($_GET["file"]){case"plus.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0!M*)o) qe#L\0;";break;case"cross.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0##\naFo~y._wa1JGL6]\0\0;";break;case"up.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 MQN\n}a8yaŶ\0\0;";break;case"down.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 M*)[W\\L&ٜƶ\0\0;";break;case"arrow.gif":echo"GIF89a\0\n\0\0\0!\0\0\0,\0\0\0\0\0\n\0\0iӲ޻\0\0;";break;}}exit;}if($_GET["script"]=="version"){$pd=file_open_lock(get_temp_dir()."/adminer.version");if($pd)file_write_unlock($pd,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}global$b,$h,$n,$kc,$sc,$Bc,$o,$rd,$xd,$ba,$Yd,$y,$ca,$ue,$yf,$kg,$Qh,$Bd,$xi,$Ci,$Li,$Si,$ia;if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];$ba=($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure");@ini_set("session.use_trans_sid",false);if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");$Wf=array(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",$ba);if(version_compare(PHP_VERSION,'5.2.0')>=0)$Wf[]=true;call_user_func_array('session_set_cookie_params',$Wf);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$cd);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("zend.ze1_compatibility_mode",false);@ini_set("precision",15);$ue=array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);function
get_lang(){global$ca;return$ca;}function
lang($v,$pf=null){if(is_string($v)){$ng=array_search($v,get_translations("en"));if($ng!==false)$v=$ng;}global$ca,$Ci;$Bi=($Ci[$v]?$Ci[$v]:$v);if(is_array($Bi)){$ng=($pf==1?0:($ca=='cs'||$ca=='sk'?($pf&&$pf<5?1:2):($ca=='fr'?(!$pf?0:1):($ca=='pl'?($pf%10>1&&$pf%10<5&&$pf/10%10!=1?1:2):($ca=='sl'?($pf%100==1?0:($pf%100==2?1:($pf%100==3||$pf%100==4?2:3))):($ca=='lt'?($pf%10==1&&$pf%100!=11?0:($pf%10>1&&$pf/10%10!=1?1:2)):($ca=='bs'||$ca=='ru'||$ca=='sr'||$ca=='uk'?($pf%10==1&&$pf%100!=11?0:($pf%10>1&&$pf%10<5&&$pf/10%10!=1?1:2)):1)))))));$Bi=$Bi[$ng];}$Fa=func_get_args();array_shift($Fa);$md=str_replace("%d","%s",$Bi);if($md!=$Bi)$Fa[0]=format_number($pf);return
vsprintf($md,$Fa);}function
switch_lang(){global$ca,$ue;echo"<form action='' method='post'>\n<div id='lang'>",lang(19).": ".html_select("lang",$ue,$ca,"this.form.submit();")," <input type='submit' value='".lang(20)."' class='hidden'>\n","<input type='hidden' name='token' value='".get_token()."'>\n";echo"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];$_SESSION["translations"]=array();redirect(remove_from_uri());}$ca="en";if(isset($ue[$_COOKIE["adminer_lang"]])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ca=$_COOKIE["adminer_lang"];}elseif(isset($ue[$_SESSION["lang"]]))$ca=$_SESSION["lang"];else{$va=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$Le,PREG_SET_ORDER);foreach($Le
as$B)$va[$B[1]]=(isset($B[3])?$B[3]:1);arsort($va);foreach($va
as$z=>$Cg){if(isset($ue[$z])){$ca=$z;break;}$z=preg_replace('~-.*~','',$z);if(!isset($va[$z])&&isset($ue[$z])){$ca=$z;break;}}}$Ci=$_SESSION["translations"];if($_SESSION["translations_version"]!=3391858657){$Ci=array();$_SESSION["translations_version"]=3391858657;}function
get_translations($te){switch($te){case"en":$g="A9Dy@s:G(ff	:Sa2\"1..L'Im#s,KOP#I@%9i4o2ύ,9%Pb2ar\n2NC(r41C`(:Eb9Ai:&㙔yFY\r\n 8ZS=\$A`=܌0\ndF	n:Zΰ)QmwOmfpQ΂qaį#qw7SX3o\n>ZMzis;̒_:#|@46:\r-z|(j*0:-h/̸8)+r^1/Лη,ZӈKX9,p:>#(6qB742LtD:\"IR{ p*	*/h\nHh\n|Z28\0Cz7MH\nj=9B6pʥ):812<sЂ9XЀD49Ax^;rA@73\0_MӣJ\0|63,bׇx481Rӈ#c:9;Ϸ*ɫu/&#΁7A}37|*B>6ƍ:ƀˌ3#rMڀP:֤	#8΀0D9\0 -CG8nRZ\n\0@54642j1@&\rvM|1:m5q7dp;B [R0ͻ3ǹm\$C\"Jŝ.ᨢ\$鈂Qn`R/7 ;3,NT*\r7(nє͍hwOK0wVF6k!]f	[=e=1Cxv4\n[Y#hSt	ܕRTEUVUՀYO\rl9WҎEXnX\0㚳VzSY\0ҏpǍnZA*Kˑ^&ɨ.T\n*uRjV*n`S@`,& #C	Nᬞ\r\nJCOMC,7F	L;*T/F0f;QKxQYG!`aKNߥ9&(z'D@I9\$ƈ00o23D42.eI'ƀgb~'3ܣnX|fP,/vHBS\nAˆSH,F'&)%d6O0pOz&BcZ؜I\$A!F@@C*\$dx@{t@£e0)Ug1Jx6{\$892]&1LG R6IQ\$a*Hv/t_-'f\"%k.N<'\0 A\nU@(LFo\ngM4!Tib@('6NC\$879a\rQG;\0*C2<IaS_I5Hq CzDrM88WoA֓vT@PVD	&4g'Ɋ=xuBHi a@N,A+}rf !͙:\0]#9hrm3\"Y xsiq[HW2\nsݕ^xC-\nBJ2V&H3@YBhɔXZLc\nߛZxOb},9cBaƛ<xkoD BH_IY\$'܁/\"q6_B`ú	fJzwĄ'>\"s_NYyleܿ.bْ+<AyhΒsMw6]WA<]thJ\0&Q	8#L;FH6+jSbA\\2#x8Xtג/qlMr3NF(\$%YBLeڥL01d~r%F,&(E:G)?in{r[<אV\nntFj[27GX)[>]s60^\$^+0Vk2͙7u# abPvACHaiۛS~k?N [ΐ͔{מ'\rJ{܂w{2sCUL˯,QX!P[P\\`ekS2,Sz%\n؟	Y9h<Q`.e@F~Sj:bV1>%RCќ/WwW\\Je}=n~ITdo8~5	:_5W&7mx%GQiX<?-)Eo/)cX,ЬÐ\")*bPЂ%AnnQ\0Hd80euJhr!#,XLx Z06pJОaNPW.	/\0IQЍ\rgFL3	nPBg\n/܊PpD \nG\nyOЊ:)QЊ<D\0MNN_\"\$.>mZ2ZV#~b#\"-t^-/MNDnL蒤 \rV``F0tȀ\r u\"A\"p~w \npIc\\.ZplۑQIp3&O|4K.񺱃D&6.Xu*f:4dEQ#18: <B\n.'K.q M[KWNF+%5'k'Nm'fƼ6%\0'n'ꎾ+lpw%.pNnpJi&fk,\rL߬P0bQ@%ʯҒ\\\"vm=\r`n\$?R,\n/-!\"-LZDD_\$쟂33h(3\\";break;case"ar":$g="CPl*\r,&\nA(J.0Se\\\rb@0,\nQ,l)µAj_1CMeS\ng@OgXDM)0cAn8e*y#au4 Ir*;rSUdJ	}*zU@X;ai1l(n[ydu'c(oFe3Nbp2NSӳ:LZzP\\bu.[Q`u	!Jy&2(gTSњMx5g5KK¦0ʀ(7\rm87(9\rf\"7N9 4x荶x;#\"2ɰW\"J\nB'hkūbDi\\@pyf9V?TXWF{3)\"W9|eRhUҪ1P>\"o|7LQi\\ H\"#0[~5[guҩ!Jv7cHN&f4(!]-lB<_(=t*	1DbkbB(\$OhJh=î3%ksl25` k(3\r1Tvܰh޳\02\0y3:x\rqPHp_pBJ`|6-+3A#kuO\r^0zC=23O2NADʖz	,ZiZɻB9\rPΎ%#Ȓ'jo|Ze/J]`Ԩ\"ac6B6+/sIVJ㩧	j>\\RlUHE*܌e&dF2Ѱ[uVLB76661#ubI	Ȧ(RV3\rDXu۩X[l[2)YnrǵhNhoq׎`!q1wi/!mV*nou&C_sS&- \0Q4\r҆b04㨋	:BAP7d p:8 \r3Cr!3\"{i7Sv\n)0jBX4ZL¡@͘(t8 \\Q0PƧd\\аØbY1Cd 	) @>fpSA{%6aWA/PgEV3	<Hɘ4DD~a=6*ûca<SjuOTChp5ᵐI,tSXC[.Ct]H%'Tdr=4Jz6<\0iCq-P>dD8ѽ6Ň4z}PeX¶K-Ԇi?fVIijBԙ5?3^s\\l+jCPxٛ*(oF~f\\lsC( Cz˃pp&c\rL4v(=4:Ih) kF3ӂڐт&r\$BCKb&X%x`Q	>(bURQ{6bQJ99jm\n3Z\$y%LI&}rԺ!ٰC 6)+:q\rQM!@Y8xS\n,{5\rTQqF!&f^JyMyTjͥ:\$Z:pDmO@\0x64u,&\0S_*Pi+}krCAG㣢+eAZ!6-߈A<'\0 A\n%ЈB`Ej.-KDip-	܋bJ`FJٹrO%%&_2lG&)(>o(B	b\nj̛_|ܲXI5ZѰLoEẃ]M(.C%hR\\Bz,XTNTA#\$n9+5	rmrS _t9Դh`\n\r\na=86b\naԚI(=>btzFRHS[Qݬ֤לc`R&m*<Sk' 2\$iP@rq;\\܀\\CpGQ׬qo{\\WHҷ8[*X\n)>C-k2_;\$)Aa \\\n!%WC©DL߄`^AxJH,ڋ[TʤR{ł}VZ:ٵ&\n2e\$&A%瑹2>,4ޟYmޑM\"2P\\[WģO\\ݑu4QFwY\n	GUN\0ǕA	xD`-}LKeyt<IOh+(F=]:F\rV c\0002\nnL(anjk2K=iJZ.M,HT1/S\\<\$Bw\"&!XOP@cf	-	c}:n\"Z&&ƎnL\$>>A\nn)~ǂVH/ilzn<?oв1%`J\r03N4?*1^nbI'.B(,H@%X؋*\0{,(-\\0{EgԱ--ԍ8~Cqeh0C8gEhaogrZ\$'yRQ\$}#\" \n\$򍔿.M<Ю^pўH\$Qtx*#Ѻ1A!Ѹ1OJrN6\nED1#	P\"i/f8fvĜ`c  tmGnHL1I&dL/WrM2P nNbj1e0V5LYPH#dsvFj/SXԁ1R3)EW'O6k*\",2\rç-\"mw&\"p\$gxW%zCiMf3pCҽ+q1Rp~s1(WR0/3'֐2R*	3Q--j,Xd0)=6q):k(13s7/5-B	7743o8KU6ND/+%SMS:ӕ6\$1p*Z3+#4Nhu3<ja,=L+rnUm\n0nVμbXe1x-o.>sUé3l#P1)n122nCT'0t)m* k\r \re,@qG7l\r\r ̇%&`\0گ.(\nZ\"=pBmttA8o*wb:m\$p#\0'D	I@k'p(0 \0@RL8P\nW֨\r>e^Q4lh(RQXt>PtϦirsqIU5UVUUh0Pj\n&6cD4BRz.MWLRsDrko	 &\0.vl\"B[k_F1,L\n\r\"IIc&j9C|8Ψ1|1Dq<K`V@@5cvUr&*/쓃,\$	\0@	t\n`";break;case"bg":$g="P\rE@4!AwhZ(&~\nfaN`D4\"]4\r;Ae2a.arp@ד|.W.X4FP\$hRs}@ЗpДB4sE΢7f&E,iX\nFC1l7cMEo)_G_<Gӭ},k놊qPX}F+97iZ贚iQ_aZ*n^S9YV~]X\\R6}j}	l4v=3	\0@D|¤[^]#s.3d\0*X7p@2C9( :#9\07A8\\z8Fcm X4;r'HS26A>¦65	ܸkJ&j\"K9{.-^:*U?+*>S3z>J&SK&hR&:ɒ>IJLH,/\r/SYF.Rc[?IL#b6FpAudVe27cHl.(:>ÉqKƁ?CմMushޙ2`3Z;I\$*Z@2U\r,	# 4DmGQ} HA\01qͲ7m1j;#7H\$If4C(C@:t㾔8)X~kC ^-Ƹ}7x.7{Г`ĀQVUN l<;ݴN<XPbUr\n7b:<kT`OI(3J>M+{PHhvT4 ӡP3	8iqG+3[;\rM'w+ۄ{e#yqtL\"=wWJH{m4Gٸ( \r~a_IQ6'((H0\nL%tM𦒢|ل)d&yW	AL(!)?FMN=(ۣBq`\\>q\0ӑ&[}Y`rqbq`9'H!Z¢wPɦJD B`I#\\\0smx&r'S(\n\n.Eq(6@N;l/K%Ĉ\"S44hrHQ&*3Ӓ|Ȣ:40i8u1ꟸ>8 uf2J8y<YFW)y\nUY]_Ճˉ^\$Li0,KDXɔ,5yRID\n0tÐ &COkmlF,΁<g4FPwi:5ڪ7Yѳ}H3\$m-nlJM^,iKI:ZL\ni\$ASTIcO\np	#	vd\n!DAhmh;PjMP75EkmucTUOX`a#L&ڈGrJtXzm<Ok8VRa*\nOJj+ە:U\nhՏE`l\r1#P(\0m0e@Cud3[Vxgb@ˑƶ@1 a\r3LVOЗB@^/\nZE4)WgD(vzd8ɜ\0P[IyEeTQb2K٠r\r!4l٢BGKej%A6tÚDd ܌H1f#PHcL3+Xq0c42Ұf'BT_ayuҪ_%<@T`7i&s++\r (/}<u,\\7/RRɔ&I˨I\rB`[7AQ%dXt:J\$[\nMz5\nxeeϳҀNHƓ/((g\"3%)rQFECI/(W	dX3\"(	MJ2j3!Ti4.IK2<A!vYMŬm*@^RI/ev釅cT~GၳLDmK_s(g\n	|/2WApTnoTC8'nP<T\"6yD:\$S0//IV\rƉ?J Mza+abi .81T۩R\nYX	/uXۣ+[]Afu|RgD欣31Uo+{o{׻[W=#6ߓ-w!\\-G Tcj)]Ȑ~᜾?5M&}?ؒ\nTU0_\nevsvly.N4<<C/Ckm?3wM?S+0S~n\\#nB#<f+Ȅ0H*⢺P\n\0.\n\"Aw.d:8\0006BF⨦^n⎦0.^rcB \n`\0P\r\$rcz¤z&8EI%NӢPn	hM\"u`^0tUa>/a\n؄+\$upc~bɑm \r\rO\rIBdD_PAp_`9ʂZ}(:B*(0b\rkV_%Tr>mQh1K'N-^\rnJБv.dP.{Mb.!</w%ѦQ!z,񌮮*\\i3\n{u >7#Jc<?LyE0/ohEJ~&*2N0Wb!~&\rz~2\"6`7g&./@'XQ#^RbHr(*Z&HP<;&pfq)%L))\$+}D̳L@E@஢/Я-.r8.&'+(6gLU(r\"1	\\\$rJR%VH©.&*HB.%4*b	ZJ\"8xC'VsD\$	()\"N*2ԡ705G6't'⋲s5}&bM%I:=)8P;s&J1sm\"=,;آnJ?0R&PL#+=_>s->.pf??i\$1T;.*\r<ӫ4s5=1q;6tN_?3VD\rĦiyD&/A^#ނH:Ɓ@Bllt|۱c/aL).`\09Tl]&]\0T:oo'P ~CLGhSKXpuFSES!QT+?6SOCRFMi0u7TPϺ4\0004CCTX)UЉ)B};gU픔Tg878un(7tcFA)VfS.>u#sR>&r̯N\0PI=AQ.Y'A\\җ65VC?u)4n]҇gƍUXgN4*=n`D|u`ՓS#aUa-,0d+pJm.1?0%[E]3'kdz#^2_e_cdfQf!eS=5*5Oհ)fmh2/bde:J7JSR\$BUp1_U}_D{`:ajPp*e:'H.'ol[VQ%NmREXV</1jv[w(^7lU'U0&WotA]VKTP1Vg8QvU{qwmq!O^ R)\rqBi?@u#\0'\$	z4zmY0R_/%w,ii+44AIe#g5uSuB79:,\0b:bb!dhVWB۷e^mTK47@\nZD?g-(!4HC|iTBǼ2RfV`,4ָ i`+!\"tX?v*DSrm7,JyDTY0HR'oX~\$*p?dHNos`%G\0004&&tvwaW+%kpԙ/˒8uuv_ҏN+V-,D-x%oRͩ\0R0_\nx1l:Va+4ny\$?id0SDOVL9TpKDJjBZ)\rF~4	 i8!06m5{t6h\0Osތ+M2J PZKg'i푂F\"_1r%[{Vt8\0";break;case"bn":$g="S)\nt]\0_ 	XD)L@4l5BQp 9\n\0,hSE0ba%. H\0.b2nDe*DM,OJÐvх\$:IKg5U4L	Nd!u>&a\\@'JxS4PDz.SE<OSkbOafhb\0Br)QWE{KPP~9\\l*_W	7ɼ 4NQ 8'cIg2O9d0<CA:#ܺ%35!nnJmk,q@ᭋ(n+L9xkI2L\0I#Vܦ#`B4: ,X2,(_)7*\npp@2C9.#\0#2\r78M:c2@L S6\\4Gʂ\0/n:&.Htļ/02TgPEt̥L,L5HLGj%Rt-I04=XK\$GfJzR\$a`(+b0z5qL/\nS5\"P`@/rMX~N7cH߆Q(L\$wKRWF7+,ԕ_-eR8zB.aPDaQR*zHvyB6ɓ`A<OO49@0cɺ9S;/>/E	CC XH90z\r8a^\\0zl7x7BxDlI468p}\nܯGǤZlVM\$_,#MJDпbPw*0Xx+{sz%[G +#&J2Sֱ>Kn@\\){U'\$18*TܢVR]Q\n0P؟Ca\r20S:	Pu6u~oY>Uz\\XR:E%(P+B8mL5kDZ;9\n\\ۡ\$x\0L1bh,\$0B`-RŢ.U)6hehgqp/aIp1txQ?&1\$[C	SI[HŭJMLb]o,ۮB.\\` StV.)wm޹0iGa	@#4zK]XY@(yxf)`d|@yn :Zf6Γo}R` /~@s3;I< DjVג<)9?g\r*{\r9ݛzo8'	M\\8rq.,9Τ@I-l-fCn@5d-\nVE<f6hu<eoL`MNꗸ SXx(ܩwo-\rɰ8Ka=9@C\r,:Up|lϠZMUo	֚.ܨ#+*%dch<b0@dhG8&]h@a?P@E驲r\0a`1[H`sQ'ITi9Jxt\0P	B*R{`Ar2P/5ZXe&,6dPk{+P:#E\r[m!A\$\r@w?4Z wFꝔI[gS\0FXj,֖ SK4ŗD^/_&SeMaDX#4FdAQŲrV<_Dfhb<fg8S&#0\nr;tQ8\$wxi}\rH8XOt0p9̛m3M; AS(Jf\0tKJvmV QDY	j5R;vz>Q[Sb)bD彑~Zb)\0@8 =#L	_@i\rYCN٘h{U2V,9B=_\nziwnX'bG¾5)l20nr觙E/)hBu\nGgYn<GG-V\$,:*+\nǪ8*e~uL|0\r٤rMBq]tf.h&Hsʴ`	bLS:NM^l*TSaiqeĳc0 tzXF~ym#:x##gQ<:UYO2~~~^)pt)S݈qL,J>48ˎ)^\n}w)VOF@.M;Ί06jD/|0FvAL{\$F']e.HCLR/Qn&MXM4XEN/ȏ\n]\\KM3+%\"b0DeX3(#VnzH)p \n`\rvMOIV?E^=#<]إ }^6}\n~}8<wQHWABҊ.1B*\r8dϏ\"\0(PIuL1f\\uM;K1LRnu1,OIpho1`@QRTQ~JpBPBx1		4BU*8T&Po#\",\"f8\\/dU+OtGL-),:QeV/2<.RFUuLFW'ql-Ĭ2n0wnZz&zUҝmwwL*&\$bGzUP@jyNx\0Jrq{i0]zq*Ώ{%\"7'a#ajO&R1z 	FJu70R0]ġ!3SQLΓPyq\"R2sc2bpa0X(R6P\re*H%#Q(~YNohV0ӿ\r93; m;6jxu8gZH#Vr\\@8HR:	V+!\\~7qVg3uQ̊SFB4,.g	818?@TcD?FL;4_6Tc1\\a5jP_G*0D	qG\n49Q6.KLV4S2#][IԉqdXtHA,&eneu0C]Hsy'cOkAB~tu4J(H3Dh58C5Qt,<S!4e5D5Nn5TnFziz7!NveB%&G>fB	M/\nU\$%OrQ?UVQՀ!=(5Rd#nd1ѵ-kC+0!SU4uu9353.d[	0z.\\K&.w7WT,drCsZJIStd)FLA6?eV1Jo4r(PoduE0UI2acg1Rz7N5Kh%Shl:CfccΖVRh3?f9gc6XGkĢG\"+w'/eL\$)B(QoISW6Qc\\+y.tjvfSqume9r_؄\"i].V*&.nTrr'r#qj7=lW\\/o&Qs-+`ԇXld\rggIjz\\x:_{70΍0zvueKScz2Z֏H7Ro~7zw,w}[YZCzIƘ%-L@w(Xo1aVo7R;TkQy0:שq4;zA}O%~s3Oo?UvC6]7erV5~onv˃i疯:n&HHq9dc֚Cogg_ sjm61ڏff5:m')k.x<q7NuReER/V}uDQQѠ/N*>}ɑVwU)\$6tR!NZE/\\91S1~2S8}8j\rV`m(2c\0l\"\rO \np`JqĚ._*|%*ctW˅Ia\"R-7Ska3m%LԮ/25y@2!t}\nYvO;\nI3Dr`B\0%L0uO 	},n@\0G|Jߐ` ⏭-odAiEI)Q7.]8;U_:i^׫e}\$.84Zqx݌`<#@qy\niQ3j5~CgbI\r2\07-<(՘NN&}22qWϊe3{69bGLKQ~@k\0{css(HuWt(/NĶ[)/ןk!_]</zX2WU	۲BZ@@=C{ln7c]U,DEnMϾ@	\0t	@\n`";break;case"bs":$g="D0\reLS?	E34S6MƨAt7ptp@u9xN0V\"d7dp؈LAHa)̅.RL	p7LX\nFC1l7AGn7(UlbeēѴ>4)yFY\n,΢Af -e3Nw|H\r]ŧ43XݣwA!D6eo7Y>9q\$iMpVtbq\$٤\n%LITk)乪0h4	\n\n:\n:4P ;c\"\\&H\ro4x@,\nlEj+)\nCr5ү/~;.j&f)|0B87,	+-+;2thkVn)(7?7cH>%cPcj.cxqx *0B5(K*Ӻq.AЀ1mT	1@@\rmp*42c0z\r8a^\\0j+.c8^%\nC ^)ڹ\n(̹7x0c>T0̼:c:B\r5h3&+lp U,+(j3hO`\rCi9O,Cd#H1rE#@kkҿH(0d hN	P:Sbz#K'/#<14h2mb)u#Pꚺ:ڇr:2Db^S[&p4:6\r;m:.(不#ː)L1X7/ԷcٸH65~MR\"rBv=<?-J❭3<Py>X4LíQL7x3 j\\'EBj\r䓧fk\$7rb^0S~ U82\nIpU%!dL̲83կtJx UJƟN8-V[kt;«W r\\ˠx>K\$N*def*cP*4.RO!@\\V|>ZYl-4Q&%Ξr}9\r;IX'Q9 JqzT\\Y5D# ¢yXa6\0h.10b՜Y0*^.!}\r 9;(4pK|'\nmKG&FW%r\0P	@E8U[< 0ʰc>M3JiJ'V m/xwʆi3jW0^i/Ptp];0<0gZ9).L)_RΙOv: yѬ Kw/֟Wl!#OTONpiat0@ٽ;:MECɚ(fɳ5fL8ST1Cpq'sds,&ʆSRA=('[Ыҕ\0!w\np4h5!	2spf!D1[;XRڃzW\0M`=BVWfInL5#S\ne;HO	*\0BE\0ѐ76C3JʠR &[ziKQ5[LѤt6b^[R-tROL='ANٔ%.6r\0g^0LPNO%0Gw^b/p9\"}*-LT5#fnĤ\"._1N'pt\n&nyOI	Lf,*U~g)A}v2=Pss#r4\\O1=O/A>q26SB 4;F8e4)#'#` jv΢7퐷<q3 U;C1:YpU\n(́RRm#()4ŅiosK>G@BHՂ CZ\r.d%(QaAA^26@G!)}236\0ldⓩ\\wDk 'eI%胔~0(M;pXg7xp6\$G]x!]R/X|׮BNƺ00\\3ϻ7^bTB;1x\n9\$%OiP\$kU\r\\Qx\"D@SA1\\Ӗ>1@LS.}QTvj<S΀H>gSKŵO><	6CQh˅6U۹o'7秏Y\n|!}H~\rUw٦X@;=Tt6	[ܥbhiM o@l<+\r\05\0\n1 ժ;,09Gdthxhb\0q'Lto^ȉ%.P\\49Y\nǰ|b\\}-,0bpi		*9ИĀ0oM'L'x\rJoBtC02k\rNp+\r0Zc(mMC(pI؋	/\r #Ma/u:'Bh&!Tc6n@heH 1L'p= \"bqB\n\\	_Lv\$nZ\rtQ.4MsdmVp2gQn\r(oMND;ǸYmnF8,zQq)\"|*\rd9\\׍bo{q!~oB18>F\"V1/NF@`N1`ېO%ͻq	p\$Y ccHlbcB\rs)A!rnrRs(C\r'2&Ą#HB^}Qje*LN*!hwd!Ƕ,n8h1Dv8(=\$h͎*	%-0R0͛0a)20loQʲ]3i3[C<=\0	b%b\n1,4'02zRHn7T쓀i7N+8@* b4&p1F729\0PsDfM.<b	kKk5\$1q%4P% ,\nZ<nQk䦰AbOB0B*\nL%P6l~HB|0 +#CQcIb3c6dj+DTD\r,\nU~-b0 rKnvƴo,.LK\"Vn2`	MhtBTԷ\n,G<0оKQc&#q7	KL/-#\0DL40nۑT`I+O4}b~ l#%<d8l&,{P4l>\$GmHAV8#..E Oc\nDAP\nD\$*";break;case"ca":$g="E9je3NCP\\33ADis9LF(d5MC	@e6Ɠrd`gIhpL9Q*K5L S,W-\r<e4&\"Pb2ar\n1eyg4&Q:h4\rC MXa+\\>RLK&v3épt0Y\$l1\"P d\$Ě`o9>U^y==\n)n+OoM|*uNr9]x{d3jP(c2&\"::\0\rrh(8p\r#{\$j#Ri*hB8BDJ4hn{K !/28,\$ #@:.̀(p4h*; pEꓯS;\$K1T&C	+H\$ #.PL<tԅ\0GRh7\r3:hŠ2aoT4ՍZ0#\"mZ7@1pΏT;CIbpd9x\rC@:t#^.8^Z1kxDjꎯ#2=Px!\"<RT\n4&@6:cbrV\\~ERŲ.9ºKRYRhJ29{ǔ:{f,6 o`猣0@:r9ELLp35aVi{\n&6 ޔ`߭ôbV@2aVlTc⌔5qUV80p@)\"b%츖S@O)\$d#NGS#23\\C;GZס& \"\$yvvsPlK=0MJx81jLT\rp򆌓Y`3.C)K>	]\n)ajO?4`ϑ`D\n@WprC0bL\\r.eкWEwz/L, }`\$5RF+4#˫:*S Z`weP|kZK\\ksֻb0?WB[F0|JeF̚RV@9.Y\"t*+H%<ƅ\rAXp-@@P3X\n1V1f\"M\rVy*~0Fde>a(AzIH\nP5\"ʐ#\r\r!t+4a!\r[MDüRhZȄSm䀂\0001j]=73p¡C~C|>) `M@\$03Ј'3H1ʘVC&잩\nEQh jMQ[BLBI&*A\\F<2JmM^RC7Ul	L*eX}&ZV!!ab!PhDPz81i+!13kcCHX7u!Ԡ@VCC5yU!,RV6X<mj	8PT@-R=T@VL~N]j\"(L21aNiWRRubP?wy[	<C,6I6x꒴@VObam\03bT/Ebv5\rUp;G\0+pKXE:&ѤYTZt.͞,ɀX[GH=6U.Ea3f\"ze_{ΨuG8Nmg2|sMOCFJSe0hFS\rpA\"6U6(䛨.>ӨabZlxs\0MЈ3CJM+^BH퐻'V\n{ivDlA@CY4j/Ɔ.5T2з&E߇@\\wғ߅uqaC{AW{pYDT\\慺+䓋.	7	.eō6mTo\0LV?!WDI H+\n<&pӓ6T#\\\"M:(D՜<	us>tnQ/Wz7'~]<y;GC@M\n:)PBCb0\\+) i5oؕΈx1	c V0Ϩ3GL\\	;9:HSꉚqT|c|f(|HXP~L9Q! g(V<Z\"'9߮]T>!1 RPҡZGĀ)N2ƌi YBX\$OxďƇ)\rʔR/E>0<,OUGbPRNǂyRptyG#4nxLmi2M/NuP		ǡ\n\nN8bN|PeiBr0Pz|2(/K d.bBL>x++`=\nC+oD-;C4E.86):[8+:\"Fd'ys\rHg+ePdkĦL0gMMьHсOc1qbw~'19;MvdLN#&lBLn[p1QīПcM&U*';!H(vYj|Tm.\")\02q<qU ;Q  RW%EQ&U%M %&2fT*rq&RtMK*D)%)!fs1>ҡ)0hգ&R#PQxmm#BDC+\n\\tH,\0RE(\r2\\M.b	 @n`?>@\"\"Emf3c`\"qgСBH/4S\03hhSlN d\rVJYlOQ\$ZpBbǰ&(@`\npO\n1ŕ+{G\n3s<d<Ę Xaf|-%m:{==nqV1˳9\$®/r	jguCn2,#@1f'fpoIp,y(X0de;EBtFl\rrGcyG<>яFT1Tj\n 5\nd	=lHmGEnОh&G'',DK8r\0'Acp !F:DFCp/D;@ w  99G9~8RtR'H\"蹠.pUҁ(x	R%j\0m%n	\0@	t\n`";break;case"cs":$g="O8'c!~\nfaN2\rC2i6Qh90'Hib7ii6ȍA;͆Y@v2\r&yHsJGQ8%9e:L:e2Zt@\nFC1l7AP4Tت;j\nbdWeHa1M̬Ne^/J-{JplPDle2bcu:F\rbʻP77LDn[?j1F7I61T7r{FE3iǓ^0bbp@c4{2&\0r\"JZ\r(挥b䢦k:CP)z=\n 1c(*\n99*^:42Ya8 QF&X?|\$߸\n!\r)<iRB87x4ƈ65n\r#D8je)C֊мH9Cҳҟ>@SJ񌯠6\"Gm9(jF\$AH̐P\0(MRD9h*SKPI l2\$2@9Z2+^8C(٭H@1QEB0\0xߤ(C@:t5~%#8^1ax'cR2ɬfJ#2Rhx!V+G㛏g<h襍mzS\r%55E75{VM0~Pʁ(i0h:.o2:(\n%ˉ\"P#BL>9Ŋzd3xЉz\\@:\\g FQgCX'CHF\"k#W+cFMBb`ȈƘWi.{fk\"3%l=[;2k:-U)R#Ӝ(d>J\rs/-RTBr6X<|wwVځ^L\"^\"P4ДQf	PU-T;v\0mn-3\0\\Y	[LCOFCVDW`I'H7B%VpP[!;BHY0(#\\Wa!>NRQ6AziF5pfHJoȒ7)^BVA\roƹW:]k?/\0众/@%>a8D,X[\r#QTR%rMDTΑ҄j52FQBd4D\n +?kinHE\"];܀t^JܿWLm/(AEL`7`)ABN@s&`zt*IXAtKL:ynP98	]IHvQKh\0W^YXiqNaxz;IXLGdL>Jp!)8Ԅ\0 4Vj:\n\n)Afz# .(PPU%.}	 (AIqAY \\yAlG#y\"ek 8T13DF^pI aL)`\\ 8e;D=0`?虄\"CcDH<XK3M]Ӂih!:&<-?BJ-3~~kQDǮH\n޶R#5=\n5BN P\n<)G_fW)'ؽmo-Ȧ!C8u8b64\\TQaX\\q%\$Z➈ \$V60T&>SI #jb?CY;Җ0	\"J5i2Ji:h!ՁZCoAd87I9QyRa:I,vN?)bIIK1a.Nmcayg%h'Sݚxϩ>TbH=EN<<e@刊:Ov>TzRNCxjv\rkRggD@!(%D!5/,'J\\\0To.ǿ0s{.Ֆ(T	8pK,\$Gs\$xjAh7cMN#TK3;M+Xwqvf19>X_o3xtG<2-zsK/iAF@BT!\${I#yr\$LŢ#\rm ,Vdyki.S8xJ[Hm1ػ>-okgp<{c\$L託׻]>1 ;^yL4OK-2fUdG^lV̄3;G(\\=;>Yw.{HlTg*'QDD<dR0[	4k_ffVGv\$cS\$)(KcD'iFMY<kbD,S(RL8\nt1\07p@f~C~lxCgzN75J#'P:\"~7ymn6=2d`pX#K0e@:Vа^3LeH\$7nmfߤnH-cl7 d 4 'mJ'f \n|M+)O\0cJƪY+/i`@J0P-PoZlKq@XNXLTq,PiJ\nm3P| *qZ)YbygymQtN\0=\n Pv kdgHK@.Qdg\\7P4,HQ㱍1V=_x0LT` GpYQE%m&f/~a\"2FMbwBB@mKfk\\G[\"<tc\$\nFf9\"le[ģ\r7jvj'\"+0V-\r\nuP~(jM R5QbdNpr\rg',ZۦR\nJ{Pp0#)1r2,1Jy7/,\r02#:=@F	d䰠dC͎MmnqQ,-9?P7I3	@@&9Zx*	f'У{69r}M6f,4#\$jDBC L@|079`9S9y:#4O/;?7U6P+0m+cJ%s)\r	8\\j`e='!.?Q 1>ᒿ\\NX ᄄSn`G=\nl+C@ѿ=8SJo!#hsG@P\"NvxгB,nGG(tx#T4tn.ܷ-&#+8=u\0lG#G2:-N4L4QM1t45tQTf6\rV;rl e[&:X\n|?fOSD'^mBHvi&l\nZ=E:riNMNmT6-kIqRT#UYUd	MTLB&\"/\\\$}df46B? j	b9GHFG&BNY4FLb'\\kfĨb#MP4ϳ2̈XG_jgLe	aVu,3,<_c0'pMbc9G#AP\$pbf&²i'IY@E1h\0B2\"cF#dD<cpQ3g\\&{*kaJ*|~LԬn#`b6&tq1Ě!";break;case"da":$g="E9Qk5NCP\\33AADeA\"o0#cI\\\n&Mpci :IMJs:0#sBS\nNFM,8PFY80cAn8h(r4&	I7S	|lIFS%o7l51r(6n713/)@a:0\n]te8g:`	hB\rgЛ)03h\n!pQTk7WX'\"h.e9<:t=3ȓ.@;)CbҜ)XbDMB*ZH	8:';M<9\r#jEBp:Ѡ欑#j\"<<cr߽\nz(oh 2<&r7I8P&&(@T߭܉Z	,\nS\"B6j/\n?12ϠOP#:\rxЌ/C XhОD42xa\r 8A{9^(ڳ[n92)| ڌP+),8:cd3HH;WԧP<-.\n'.#\$X %	cz>CI#kDKUūƞl0264#:)MsB2+x3#0JVb:aঝ;@쳎k#4mjRE@\r4*)ьؐ3Hx\0c\$\nbk%Iߤ*;W24LQhK\"	n?>_+Կ#k9M Pl7\"mW\r1]vi5S>ҍ0͵*:\"91:3fa1Vp0\n(rMU@,:\$%m:ͭcU2 Af\n^E|XEd%Tl[i\"hz\\HiNSlbZ	@tɈ\$䤨&C)re\nJW^úQ0,aLpQj0|H)I\ryc\$O.gg'NɢUdZyKRjF1W&g_i3	Ljv?\$)mJyA!8h&9B0ډ\r%9rbd_(=?rs6H\n\0J|P((K2!B/!y0ET4\\K>+K>*\$d~Ud7VI!4&42*uUH)FNkakQ2TK	qdx3S\rƛ'	c腈С2DC˺/%K&i=,cK߼e1ڪi.TY\0¢OJf` /d\rN	\n\".Je;'@\rq\$4#Zc k2Dp\\Wn9F0T\n&rp\$q\0ROr8PT@-OmDRTM);KiܷSrɫ=\r%\\EшF\rHE \$#}TTJ ^!:D.̺.unM׸>hf(Oɇ%IUʶ\\˹zebZaФ`Cn(61LÛ+76>B]΀iH~f'.:@}M2b4W_K\0HYqF\$6+[	RI(f'AYf-\0ٔTCߨE\rK-h콟Vhhg[()*A( !dP*;'ݑj-g5ܶπpe0@ʳ7,Db1EA,  	-Y-PcL_!ȄnfY]O\n^d<R\"m	S[2k\rvoWm݇mqÊA#|ۍžy1Q+P0-L%ƳlI[c\$+k\"J9APZ_ftR|ѽ\$CÃ*7tH}~N_xѿC5Fb-ұFIF[r>o\0R,i>*}/Rn\"cnO3bQpqaDh0\n0q\$@[g/{\$^\\\n[ 9J?mӇS@u_/:lqw)^m90q=Ƌt'svs鱵#{+ftIÄ?|nBH\r:YsgL(\\[^_C&X]ܭ	s(^\\a9ū5Ohhf3rJ.l~-mVc 7`*\"z>#;b)jx/γ/%*pF,f4t_o^]poxv\$fv\$PPu\nH\n\nM:Cf:`UlN%/lfo	lEOR.		_;'g?+/C41\nhX:S'F\0)V8\rqCJpcJ(XLQ(rqi.FcvD/=`cFl\nS;1Bl/DNq\n@;qKl3C\rㄚsUTb,C>UndRSAr&cm<,d- 0D`0O6毲O٠d8\rV\rd\rmr\$(2d[+J\n\nO\$\$l	kRm)/(B@Xq#\\B&nECz67ZmR\\L\"Q&B9hg^,>	|#BfkFd\"(\"G&AfǬ@as+߫\",0 4&22=534S64.p&#\"1s.pik62m:	g.&Cl3kk.\nBBBt;#6)L-/l'U\"&03J»ܹc3L/@-qOlfԤ)F\".\r@";break;case"de":$g="S4@s4S%pQ \n6LSpo'C)@f2\rs)0aii6Mddb\$RCI[0cI S:y7at\$tCf4(e*,t\n%Mbe6[@rdQfa&7n9ԇCіg/* )aRA`m+G;=DY:֎QK\nc\n|j']C\\<,:\r٨U;Izdg#7%_,aa#\\\np7\r:Cx\$k6#zZ@x:x;C\"f!1J*n.2:8QZ,\$	00sΎH̀KZC\nTm{SC'9\r`P2lº\03#dr5\rZ\$4)h\")ިa\r2\rQq<1hB@9bdq*\$h0H \r;.2,@9:7S&\r:U?\rk# ڀ'\n5X7cƖ{v ;C@Z}Whx0.J8a^\\Xz8UJ|6Jd?cJ@}1mR:Cz::b;K%&V(dF=BCH&Iū5>,8 |8zb+_Ƨ\nrɲF\0#<-؃:2mCCI;<\"nss7崘6eIfmۃr1آ&^P\$E:4L]j59'=Sۡ}6c/٥5-\\\$|r=b(8O^\\PI4A2x[9K06Y	1O-7CSVzW\n7Ь\$2Kzt!2TM ' BO	9\r<1\0@%r@`49. Âh(.AHV@~\0002xCy+8ey  kC\" bLR9O4EκC*]\rx/%轗_a~^Tj\rVGV\rmL Ďيq9ŖnC,'Ġ7y{\\\n4Pypn䉀!J@R]ѵyP4r;U▏l9{^zCAQ!506kR8ȜBnA9o\0BddY'2'T(Bnj\$6uo+d0B֌z:!͗A60cVԝ	@äF\$&@G\$LE(r:F(H@Jq:~nbOD1Y;M+:\nA#Gf{hk@Aˣl.|Ve2@.=	aNr\n:!NWэl ΁R*LxzqNpx0elSA\n!6CrMO'\0'`)&,NdKrxFXk4xh),r9q-Bjih|i\rBƖ0TtQyJf&3͌<jDt\\-F^:dQYz0f5\"9\\:;:P(.JѤ<\$,l'r5%桹L3]|`E'\0 A\n .Ci߆ԗtBj̭ܪm	=@M2a8Dhpz\$/D7N9V(d#X2\nF5]Ox	^ :AXÆnt+Oච:ZWMNـؼTC7\0A<rFc-62Y:\rtRev.Kɇ?GyEǯ:rfMN~tϠ>e'e)\r:=2lAi!oXrw]t2&L*F\\x)E%Wf\$y%M+jRK]hVBn7ъaM~HOoFd BHG3vpРoB9\rFJKy\$)g*m\0DrAg&ip	Є\0kzrgFq+@OG,X9#׻R]PTy6RjcFv\\Sn4a	\"B믌?c?6t ƙׅ	A;Py/84L(T#i(ByaI5Jl7,cs }d'[\n9`[<SY1өVvts0!鹡\"ؙ0)&2M\0z`b6Q>)b\r\0-o{GȣU\0M;MHMf/ rfJ!̨G(^Wnfz+gM%R`Z\n9ol\0P	,T0\0d05Tkd吴i\nfO3g(W\rǍ\0\r	X=`\nO\n4ξ`/d1?QΦ3nNՌf#\r6w\n,`qPU/81Lߑd0hp*&`f\r0\0C1R4>6XHBV`E #ZBiWÞ_K*n+/\\k Ԃkb+Q_1bg;-vb=Cde!Rlpd{D\"Ǹ'ZR/\"c<(A!m\$G\$rU#ݦi\$I&20>:V#`	JM҈Tk<Ȝ!;Q.2C\0)q30fr\nmn*\n\ro+Ҷ@J&,(:jX#e\nC\"`o0I.h#\$Tq/+030r%1&C1&o0	PYұ%728юE3Jre\r5;6%43m-ф]1V)PUsO\"RDddS\rFs20\0A?8F=`\r\$Rc(h`A,\0ʬC\"3,,nb\r&`\n`̜V\$)#ֈ\0V\04wNFcsk6\n;Ȧ\"H21e\nZJ\rZh \"f1!1o/Zg;ERQK	BNh&5-q0ƥ9+h74!IC4Bt,%%\$TV`@#'VBTX-FL::0M{I:BZ\0PctH0!NB:'T\":`GTx4i	tN5N˂qQ,0Q\"*PÔXBM.(|)m#`UMp8Hz#3ҀfdrXlNtTm,#<#RC؇EoNIO&:\rOvft5eCPK4ke\\5t޿ /S&:it'X84zB  ";break;case"el":$g="J=Z &r͜gY{=;	E30\ng%!F3,̙i`dLIs9e'A='\nH|xVeH56@TБ:hΧg;B=\\EPTD\rd.g2MF2AV2iq+Nd*S:d[hڲG%..YJ#!j62>h\nQQ34d%Y_\\Rk_U[\nOWx:X +\\g+[Jy\"Ebw1uXK;rhs3D6%`YJF((zlܦ&s/2/%A[7[JX	đKںm늕!iBdABpT20:%#q\\5)*@I\$Ф6>rϼgfy/.J?*X7p@2C9)B :#9\07A58\n8Oc9)A\"\\=.QZ䧾P侪ڝ*\0\\NJ(*k[°b(l1Q#\nM)ƥlhʪFt.KM@\$@JynѼ/J`3NBz,/*V]\$Q+\$ \"U:#6OA9vX\$27cHߐ0RQ9E7dK>~Rjsgge4]5[Av\0٪^AKq86j3# 4ӄ@PT%\rDQA\01tB7;3;#7(QH\0yÍ3:xυʹNt3_cL|6s3Ncl\r^0.,ȗi\$Vsd>/SR{\n\\9/vbN2z9,B9\r@G(d<\0`P-M<E)ieLMU\\`}-C}O5r%/@>2cUR)\\!Ġ޲.!+/HMc!'pdp˓PHPd,na\$A8)UER1\0.<S༬Q2k5(\nGL(@+!!\$*|#0=>sI\$*J>t^(6'Ȼy(pIF^d-Ґɡ(,R,4d4G\r+L*%h-Jz¦@PDP2WL!Z\r9\$uHZQ` .EU'\r]4|,rHvqeĦrd=\nбe3ű5D k>+73!)^v1'oJ&OW@J}IJ҂dL{VǲD)TSj35heʚBqH РԐqX^̑eS\n@4\$@aM*	 @[yl'!ǂ\"ܫs.mι]ut:Ńv\0ǻ肭ê\\ʊ[Ĥ^VzHjy\"LYʋg43IqA9G,Ӝs΁WGJHnu,uF8IPRݘB}ZmRPEI		*5Ra!8(|ٝ!tJy_Y#<5/Js,8\0 }	¶\0fcո9V݃0u7vч\\h	>LaȆ)6,OFVRU+	֧XP>ݔU[\n (\0P`K<!JI/-x[Hc-Hv\r,@3w\rPaaىpv	Ç5A7ǚ7\njut4ǎ8grጀke0eX#ʪ%\$!0,?d1.h<	f3\n)L\"*r\\YBET܊Rǀw>ЄVf'IIv]D^R\\	,D,/ʿ;a&Z\0JPn\rL4γϽ䤄~,TxiѩNBO\naRiEHjx*!57~W9VbV䁭=Ï*Č>#:&Hd:DC%uNJl	x@m4uK=H<ge(LV\0#ʂD-\"LSНI92o(Gˌ6 PFs;yWuE)N{ez`-K<wSΡY[˹\"?ostZ;\\q3iZwO̡[(}2}\$ᑎD[Q??~.(CzxO_xʘ(0B:Th8H%b~E̤¢4}@tN DNIi-lͣ:j}ǎ:l#T}D `yz-ͰBdeLFgf&d~-|)\\B`Ynyg֡z)0H^Rk=)N;<N	1C&p0&[K(|{i.Z/vژ H\"F8.Eݩz/Z/)J26&EXTkodk϶ee\n\$\">f(\"@r u	WPy&0)Wg \n`\0\r%nG\$e\nŦF<R(K.=HK@h@#(C2h +@EE . Vxx\$J2ô+{oGB(XW#\"p~L䂠e1#{#-\$P\$!2,G\"ľdk.p*% ^H/\0i#a#V(./h+M+'lOBlde\nb3\"ۑlDDr[\ržDG8!0Nj*0&fF%WX\$34/àI{.QF(BQ05c\$[d(*DAG&p%>\0G{seb-禍\$,ȅPPH9Ƣ[)~JSJ5=x~̉S*->Kn/#(Ϣ@	iE?/xdX7gTD/Ad1C\$zDVAEB趑-D\"\$-(K\$iΨ.`[`,ʟ򢞖ExJ4\n\"k);C'8YH\$Pa4sؓ \\t&(F[)%4!PE1GEL1CD4-QHWJT+SsS@Q!E9\"O\rCLq*BUJSdi(?!)&r7prt\$ry#r!S,5|{5Յ-uQ!kX\$U 0+!/*r\"?\r,CC>uRRX8Sk\"]Ki&+DYT]2tQUpUA>Q+1D<YT#\r;࿎Dd@i.LN1MB:n=4BPocC[Ed`2R^\r^MP<-`CTO{Gã` neU}G/L_=|'LBGm'n0)vfT:5#UEQY=*3/sUnP5`,\$_>rRYqw+]UVQ5om۷(w-7pvbsYp\$gB(jBx|!BVKȾ6i5WTCn*qr5%Z)ssWW7oUp7^I;{J9},	}t&hEѯpl+Vt7wGpn8J`DT80(dzEz_.\"JU0w|:PۄW\rVKsԙX,XFE|.x+B-AR{WBJ!^5_AgeQ{tX|QW7OV?>hv+xw&\$z­5F8as5oa&8τ1UqWK1&vRaQkINwuOA|L\\ӃxC&hLXkVgRY%\rfɄWh6{{4!	M&E6Kk/([Z u3~%k2]9RXo,xD.T='3\$2w-(S@pjYb'y3&a\"#%Li\rV`eNYNbL.\"2{?#`3k0(6?eLDcCY@\np)@I\$o%)ڈT?WYQZ!z_Adw\0\$c΢]Nz\$G2@b!GFT\$ZymP21\"dSDDMNc\n͢&np\n8\$KiG_ȭQArjbF䧪LUC/E^1,xra雩\n&83*SSbv5BhUpWvY6},xմL-I5^q[3MbL'HUQC[}bM#	Ob	j6p*R%:(n4if(kyjZv֘ɱf!GrXY<i3;zC\0줤Z+fミIOp&\$1.i7p4EC'N4|?@EIwcȉxAEK@j|,ein\$<)SB#Qkar";break;case"es":$g="_NgF@s2Χ#x%pQ8 2yb6Dlpt0h4QY(6Xk\nxE̒)te	Nd)\nrb蹖2\0d3\rFqn4U@Qi3L&ȭVt24&̆1)L(N\"-DˌMQvU#vBgSx#WЎu@R <fqӸprq߼n3t\"OB7(%vI U7{є9M	9J: bM;\"h(-\0ϭ`@:0\n@6/̂.#R)ʊ84	0p*\r(4C\$\\.9**aCk쎁B0ʗÎз PHP:F[**.<41h.o?Q\nPA3E?B3#0&F	@0##?<RTx4sw220Lw*O`7#s%N9TŌ jC|7 2-ImXUC:Jc	A#8410z\r8a^h]Ws-8^Ͷ9xDjܑ-#2ܜ x!h+F\r=7F4Ԃ;R,1\\l+4F03~Jp2+09R-TxJ29 UF6lm#T.x7ld\r 3,&: x,îT{FeFIYNs!~P-چ9;2Te|U:<RLLpnЛH;YTi˚b`[{wXK%UM-\0U~I@㙽bߣ>^RsUҰyLBH!1-\$rP݈x._=ʾWLI ~tQl8Cx\"FG\\G\np[DYKh36>HsBɀKIOx`\n)&n8\$\\4C1RP4\nxJ\nxd,C%KxήƹW:]k;z^#^>0\nˠ/F21d\n&Lu8lz@732d`x%K/ IA&.2]Kw/_\nØ>{}#I)j#T	k` :~(b2Dei2#H@vFahM\$- K%>%4\0a\n&j\rpQ\r%<pd\$\$T\$8\"\"\08o|f\nJA 9H\nR\rɐD%\$hɋ5\ra!-;}!%8%ppZmHVɁ/rEK^!7\"RP;Ssp \n66^M)ަY5CU)83\\8ƺI={Z60Gj%QLI\"a͡1H)yhRǔ@Б\r+\"UK][ʚTY\\(uE-Fa8'D?֚E1V!laHRqUGPKѬg\"hL\0(\$ot4SͥG5'Q\r\\9nAaP*\0R17H!u\r*QxRAear'xphn	%D5i\rG<T6n{}yvGoL]0A!sZSw*KʕXp!9T DcKJRg*Z*qݹ9U\0R\n|8ߘZe+SA=9SLEbkCLԁ>ӭ@iC(wLAhoQ<~[IpIxZN{d!gF pN䪆lfu\$AZwJ׫Q;0\"|PBTA <j_@Rbj},'f*A(!\0oh3#iE1c\\{\$3'vO<o8\"ܓ#hcJ:#~:HgiB)yhr葎9ǡ6twMw3)=ʁ`w{wr^F\r{cg9㬧Kq*8E9]U%RC~|RzFH\0nA_i!!FK|-\$͟U<>\0ac۳O\\Qcha:|:3X=9^oā:d}08J;}Ȓ?>d?~41-o#0j0N,8	r,/rɥ2rweǣ*Bi,xǏA)Vew\"yd\\p*Vyp`~-\$Pej	>|N>c&B@SQ./	3\0I0Z-\n\$7u턆pF@D,iBCւ8'\nB:ʼ``BG B\$^ iCHjb#n\$I\rpHP\"¥Α\"pl\reϬRn-tw͖Φ\rFQ8pRMI	7w\rFLl&̢{a\"{/v)Nխv%Ml|ѱjIiHd1\"X8bJ\$)zuDF>;\rF~\rWO0qpgZx(*ni ~Q k7GQ2sUf8Sn:I\$FfQ\$o!H]\"2g\$nQ7oćQ%m1&Pj-ֲ\0l=\$j؊)D#tҗ ok(R*vC+m\$pyf2 ݤK)1-ok-&/Ŭ.J\$ܔm7f\"M.&4qʬw0jq5BP.hzyqj&s2Lǳ5	.liD\rVMc/HR:B-#XI&{	`C(B\nZ8c-Bh&oHs98b4npH:oL6rf/mϠ8ȥ{Um\"hW&(V̹U`L?&Fz\nV\$I(3/αK\rcfI}*\$F/IfAÆ(}D,ڗC\$CW\nAPD#e%J0x,g18cE\$7g*§0G.s\"E\0r<;\0E+6#v?vKM7oRo68X}P\$ICGDv\rD2i'1^D%3\0@	\0t	@\n`";break;case"et":$g="K0a 5MC)~\nfaF0M\ry9&!\n2IIنcfp(a53#tΧS%9pNS\$X\nFC1l7AGH\n7&xT\n*LP| j\n)NfS9f\\U}:Rɼ 4NғqUj;F| :/IIR7aýatpAߚ'#<{Л]a	U7spr9ZfC)2ӤWROcҽ	jx2nv)\nZގ~2,X#j*D(2<p,<1E`P:Ԡ88#(!jD0`P#+%	JAH#xR\"Z9D\$\rӚR c\r`ܝ\rj&DQ\r{O'\no{7' s|7\$<U7r,&\rb*0`P෎/eE7%O\0?1Ӵ7Z42\nUK X4D49Ax^;rH=r3_6^)ڴ(P̴Bx&FMj'8*~¨Z,j߲I \"47b,@U9H5P&ӎ,:,.<8;70mDK[6?\nH@P2㮸2C`뜻/%\n	R\rT0LGl{P4#':BT4cZ4r.#lcM=\"\n\"`Z(:hS7b-t0\"-\rxYeJ]9v/[}Se[6F*1`6	(\">\n`<xo~Bw-ks*ɩH3zI%6N)/AUC3f/Atg#'!fB0eI]tZzaJ2'p/QP *%):!l\\tuj^!*Y\n͢`jԐYTZ\r\0M#mhUMI=Mzu\0iamDuW\\uu\"P(QBEEH_5xR%G֩LLcS8S4I9tHdJVX=869*Ô6M 3Py.z7Ɇ3}\"/\0ƚcT\r\$9PT\nyz/e\nC`o28i @\$	քЬz0PBP)=m!c`h\r @D\rA%Ibh\rbJkn> X0c\rkfӢv&7FT\0C\naH#F{IZ*0;0nLx'逓[	Y!\naԃA15SA\$,	)͚,s?u(=7:@&@'0_Q42rUYEvtVTh+I*\r6<otGpoѠgMSD' R&Ru4zQ%Q\rxgA<)*-<'\0 A\n^PB`Ei=u8IRMQu:✣\"(Fd\0:ݺƄG!+p4dH{ᕀ\\ZnR*bjkq2dpߟL\$ԩ|ؓ|STbW82qíY}-˧.܃p:N]Y?')\0	L*ES.`;M乖QL=C<-Gv\0OI@oK3idІP[}\$B;!D0UE1\\0+3._ٛ\"֮	ENXZ rKZkIҠT\nA\$#pӨV!\"نq#1@(N\nM-bz1U0@@ (ҿ.JpTu`TQr4\rԱ|.7ek_kh:SeQV7Ŧ-\"hkhԝYyJvxA'?;bF\$\$~M^0ʑHn3q8szj\\ן\n@\r-B[9-	(9'3;oyQFFLɸ}fV0֬;|I=JVY|œ!sy\r㖝/\\1Tcй]`[/~Ԏ_rύVZRzA)ugE!\"Hzi\rHJPFK/{҇_-ibudW=?!tŧCnDr-Lo8,b\0\0O^?<G(Ȏc\0/n(LOex*x8΅oj\ngx#ia0,R)/pM_`/f~/~RM(Lb\"rO/\06<jM\\#pM	Xkǃ\ncNzJխY\nO\0ffP<5ZHt\\6=⨕in.BDH`\$k0f&\0Z:dsj.IrУM6E+XBEn402P'P-F	Р`ficaF<JDdSrPRd&Fdq\nqgm/s\rlr5\0cJ0\rMV@c9@5oQ!xۄ/P&'GcN\0q @P\nmO	^	.kkl7qI0[Q\n삝1=?cQ\"ЂOн\rQchjnno!##%`h\r\"\$.(4\\\$\"q\0(\$)'?h%\n*FQ	KRNwq,`M(dFr5Lα\r}-q*gxrw-R-حܤQE*7ҹ\"zS3&Y2r/p,P	\rd,\0 &'r`yt\n}'c*	5\\,ii77ov@n	`n<qN/	3xfpEpb9L `&fXH)kc:\nZJ;BjD*B8hRƨVwFl\0M`#3ӾhhCC#٪)p_j@YTE?#	o\\#)Zg b&VփLl8{- #pfs#oax\rpv#iԼLW4PqOyH:!\0ޖIHGWJQ+hOB3#6( `iNdNB2:5Xo/L9I4(yHOJ9P'.aD<b\0 uo\$Ɩ,&Qx3jM,(7Y<4L{9Ԭf R-CY(b֣`XHTC|1fQiE¼'-	\0t	@\n`";break;case"fa":$g="B6P텛aTF6(J.0SeSěaQ\n\$6Ma+X!(At^.2[\"S-\\J)Cfh!(i2o	D6\nsRXĨ\0Sm`ۘk6Ѷmkvᶹ6	C!ZQdJɊX+<NCiWQMb\"*5o#dv\\%ZA#g+>mc[Pvrs\rZUs/Hr%)NƓqGXU+)6\r*<7\rcp;\09Cx0C2 2a:#c8AP	c2+d\"%e_!y!m*Tڤ%Br 9jS&%hiT-%,:ɤ%@5Qb<̳^&	\\z\" 72J&Y[MkLn 3XH\rAP0HRP+I2Ø71Jw)!IKS+JsDK[/Eӹo*MX<`E5\\ k°3\rðB#TOm\nЄ%\nH4\r80`@^@2D49Ax^;pj\\3\0_{_J|6P3AClQ^0T{40r\r;*q.j7;t7+d#Q'o<2+#J2<ATWN-,H[-&ްR|̒%r-%H	3iVtKDB:3S\n@V+ꦚ >\nɒ\"vOg;kiB!\0(\r;|:6iyMwͲk\$upb*>\rb2EݚB,FD{Np%uB B}O8v`@Pr\"J(7+&#]0k8EbQʆ04<J^!FCa\rPDA@^\nrWEDޥ#H	T΢|6PϛHwaeQ#DI\\Mf<伣uj\$QXIRG (*\$@:P\r}5H\"_03aL0;!\"ؐrbY)p>XVѺVJHݣZm!p2YMڰ 0HH8N % \\IacIRh}X`%\"8.blT71U<cytpΑOw\$*KI3`ZV!E@ta<!͘#RM1P'.\0bB [\0a~A0긗 f6{)*\r\0wEK\0c_D7JpBF+2EfJy\\tnbC~@P(u(Ĝk\"t&)5I\"\\7POZz2o^tP;\"C+95*E8/%34:;(R0!C-}\naH#T@W1MR5V\n􆋒d#l<)	t~Y3+(஻3KNkY6an,Hy^(T4s`]AfA!DIQP(cNZ2Y(E5zLO1(?Q_XB1d&`<HIѼzENLtMn#R8x3(RWM` FE+Us\$MeCD]Ye:bXWcj'UGSFP*\\ E	>hg>KϪNw+ihL!4.&TDPؗ	Db>~K\rY\$em@w`|>\r\n\\TQuHZ6\$?l_ُZb38@c:UFL[VTHh%\nLcOUpUHS|nXQ(qOlbFr·૴t({VjɺZ	_*ƻfLDyO7OMD|K3!GyUsE9s3Щn,Y*Quz,T8B3?rZFc]>iЫzAa _P_ESe\\h+S&)l\0F#LH\$A;Lw1ku;S5PX|FޚElTWq?:<4\rUeKD\\=d%3lLjL>>׻h|D\":x2;CǦӿV)^E=Ni\$I4ۅZ\rb\n<jOT2hv-,2b\0fcƼX0؏t8/v\r?&\r\r&\rVLZf8ƈppA H~JpjJqMOBlevGX/HF1͌f7^bml\0PBn-Q\rf٨:04ihօG\$ͦ\n0׭#r;PR.P>̐nj)J>F0)plg(v'кR.+Jo.'ôLjV\r'QQ5Q#]N|?%C,:EUKQhNK?;Ntдl,{Hq,'5b &NhX!.jͥ12&82 ,2X]#\$&hiBF0֗xqdpb#1c p?'qm(1NR#.{(.QLM~!u*\0HgD>m0#2#n!2*#Ǻ\$r.̼r-))r\0\r,/g\np=.ڑ10r1R)R)19/3D>cdy\"El81R#4X5S,\"2\0)MDIsHK܄AtP&͸OQ\\1aT8(%~W^)um`hS7^P,ёz%q`\"	7.O4p \rVKZ\roSg1\nZ7Z̤g\001m,q4Ƭhdhv>{3O!'lۯ>m\ns-&	E˯R%iO&8ˏ-Hu]\0BgfTez1oLT@#Ϩ'LÌNMMGRNM\$rԌ~ۨLN4R	\"VFtbq\"u']nxl,6*6Ctѯ|ҤyLQPK.GFop &Q|ČmMQMG;)oF	j;MmDxT S.M(4D܄\$`";break;case"fi":$g="O6Nxa9L#P\\33`d7Άi&H\$:GNal4ep(u:&蔲`t:DHb4oABbv?Kd3\rFqt<\rL5 *Xk:+dndj0IZAa\r';e KjINw}G\r,k2h@Ʃ(våap1I݈*mMqzaMC^mv;c㞄凃PFKuҡt2£s1eţxo}Z:L9-fS\\5\rJv)jL0M5nKf(ږ390`KPR2i<\r8'\n\r+9\0ϱvԧN+D #zd:'L@4*fŠA\0,0\rr䨰jjCR\\a\\5S5A-Am6'*ݎBj&@\n_	K`\nIx\n	b\\/C)қ%\n?JD\n<[`2P6I<c]/;4\0-rTO\n\r#b@>09H\r@#@2D4(xw=xx3^ă2=k`x&XӺP	[T\r0m:7-XGkn;9*ϫ\0Xtv膌x:!.rl@-(<Ƒ)&O|l R.H>ߘ㣪p֢E3c>4ŕ^63X	N +s26)B(vi>ؖ[-<ɰ&&;;Qq93Zuj	Cjf(;BrPP%9k(襌5(2\$N/46XH\rKNpˤ[rL%+tZpZ\$pOg^;4\\@6@O#?50&(\n`:=p,@,)\n(.l`ѳ\n#a\$h:jy\r9g: H'EjN\n\\tڻúWe9/UCp/#ݴGD(hDPPw5bMBLL={tpTpKDg9բWD\$y2RBLQ%\0q.E̺]x/(2S\n4В-Ja29K`*b\n(6;4¢f՗34)	KжzisiL	#R<LpµHP	A	tBs8G@Q=fN`W@e/Dh\r*졃M<'~lErV?(&\0ʴK)X@#fUi5,t\0C\naH#JQ(&zR4X:0ywj\n]ɋ\$1lEOPya-tH&(=!]T\0=R\r,*kE 1\r-Y:7;:@'0X[msu\rk;,GlN7`\"i\$ۙL`<0С bHD#{DbKMd.mM!{%\n8\r@BD!P\"@(LQN1OJD41\n\n,lHꓗMrǦ&e;SM4Q7xSW4cXGX!<q;:fd\"4'\\:P6(\r\nP/u.elh/F%9璶Irx)HsymEz%5'яG2FcdLGCs,bΩ15ȴf25\$t8\r\$})Hhd\0Qh;EQ3ZRVjېZQv\n!Bu4	xy\\Ȗw\r3@2!'O4H\0Cu/? dE`ykҩmɬd\\+^W:(5m;\r9p3.Gp!CP^\"/⓿52^jI_dr9ʶI{q3#^/%[ 5vu'xRoAlՁAXkR}k1.݋d}+*Zf pZhíf{/g&rCyW{\0(V.O*.Xe#N~WE_lqOu\n\nMyZwQN!>_1B̿f}D,\\@vjt\rnfhf0@ PFORF碫e\\ʐ,LB*01o0'a)\0ejCPjDngKz<`nfmh5A	Fm̪Ǔ\n/믟l\nFׇH\"h@\$i(0>(R8ZDg\0ҋ[8>C\$ĵ\rl@7˔Z\r4΢%\$\nZ=FDp'&RU-1Lf'TMPuRoP/1Y\r0J˩KC-Ο_-!PQp/ij%1~,w@h\"`\"k80l.p>X	nHh1ܑkp뱞0Gf#l9Mj\"rѬ 3 rE:LB5\0p\\30, #̑q>\rr2̑gO֣\$BC#˲[\$2h撚;rm!{2-˰iH<ٍ#')	)ٰlNm)˲m\$6!DZфbE\nU'E,UzU`>S`#vC\rrr6*XR\n̂Kȉ)bDE13 <n]Κ'\\@rKNK3<@ePld\rV6Ԉ0rnkؐq4\npC(\nCLXTt7#b?N(/<'W,b8c\nv25BMKvq,26=j%JjLCq,/,g`dj [-ЅAH`B-Cl/,uB{&f\"2p:\$({}qX`@+5b\rbRqP\"o\nzņɬ\$cx\0DECneScr\n&reL/tX4Y&@p-6HRcRK&HF\"Щ.S#";break;case"fr":$g="E1iu9fSi7\n\0%(m8g3IeIcIiDi6Lİ22@sY2:JeS\ntLM&Ӄ PsLeCf4(iƓ<B\n LgStgMCL7j?7Y3:NxINa;OB',f&BuLK^\rfΈ9g!uzc7'z\\ήknM<303P퍏*X7P0rP2\rTBp;#D2NՎ\$;	C(2#K+\0P4&\\£8)QjC'\rhʣD2B4ˀP윲ɬIN2ɦ;'\"*\\\rBtLm\$ڮH<PBԷ\\9ʵ+1\nG2P#u#S\\s_32䡰 j C\\hZFz2B5d;BlUJz420z\r\r9Ax^;߁pf\\3(H9xDj\\\"2\\#px!t *b`VulTlBdi1rOyj}GRԍ&62o\n7[J2QC::6V\$(HΔ͕:U3\0<#&E2\n>3ؓW1Yc%7e*J;X6 :ԝþգΔ\rۙUK☢&/Z:ϓ癲bU[dո)i#&\"9ml4|5zziHήAP3(,c(xD!FnaYgOB}?\"NՀQ:&4gR0r5	E<Np7fv26O%@.`aU4cmvȨr--\0&B[,*A2Ia߂jSq)1D24\0BB	!,YCdH!BWWra^+zEW_&{X8I#'JmB]C\rSr` ؿ bJ0䷤'V@\0ʼ_~u.`l\$rvXs!ʳU&AӖIs*Iwʆe-Hbȕhz~٩F)I\"Nb[.B'@rNWLc[A3b\\OPnQ))ƃ23%6eI)gPZY[\0PU+09b,1p1P+jX8AAGK.5,V(-],-rnM|^o\rl01,P%)O2fhHb+,!,@Sy)2r;Zn(#BYɤƜԚ,!!F/Wʕa倮K釧/	5\n<)B|XstꦱR1}w#crbv]{^rQhVt(+Tmh ZS2K+d0T'\\ZPB!jCARXgSɤU{JA<'\0 A\nЈB`Em,zv1ǖQ׷T'nPʸ8Q*{n3LIBHoTL'~^(WbT69TSC+y6ݣP1YT%12:%ި^\\SFDJ rzfu\"V'yT8J5YTMStBJr8b0߅Lc/0Ri7GEQ;@:Ӻ(gRC1ly̍	!ieP#\$|O#LfXn2iВp8X1ʾCSXQ5.uGFx´wSAa#_:Rq(CtkC7דm\rjuc	+Yj3ǃ6PAR\nS^#uJ5\r*\0miv;ckvD,޹ѤVBBtֺ^B|PxЍ|#rpI-%lJ\nvg'ilaDSA ZSb>w\n1QG\n͈'A[}GA'm̓	0/m~ͣ1\\ C	Nh撕ip!R	v'p0ע{POk;d\"\rmw0Qi~'p\\P;0>Ke/\n#'ȇyȖonNti`\rX\"iöb`5\nP,\$FvaRBVk̂\0P'Z7\rlinҬO-Pj'-'覰Fo(ψd0A+{}1=q\nа/h&'+q.0CJ(qO\rpB\$<N?Pp\nJQO8ID!1A=n.%f?q !In AP?Qcb8BP<Ǯ*c%hP KȬJ0(* Fb \ndߢkѲ\0Q<Hm=.,1 zDq#&&f'<.-#uurQD e\r\$g\$&aP!QS¯2+9('g,Nh*012tO,rҧ.R-lT̂0&Hđ\0f2%F&r6\$	s!212.Fzb>c-S@od2bpI.Ru\rf2tT-~7S')82s~S7û8o-=.3O9,Le5ӊ3uC\r!\$1T2Jo34'5<s*r<'d.P<(W?.:+3>gA>.@0zt?tsr^2PJD\nU>/3S,44J;@/:DK<?qJ夤0n6:3.i6x:x\$h:~\rtÃ1洌't!ͮ4frDﴳPH6װ=:\n<b\rVV36Os?E cSL,1c8Q\\\npn\"YuQf\$BHPZ-pF|wrE4wNâ@d~KwD\0EU@D5\rb`QNL6I	`؃\0iP>!D3<4;p)UDRB;'t&II<t)GZ'2㰔\r\r[\\PuD+UUcZ;e'_(b:\$rN,:Uoucɦ)RHe6!6&&0\n<F/x:\nlu00\r81mY#̕ˬ;	R7hL<\r: M;b:	\\T*vbF=\0>`A`";break;case"gl":$g="E9jg:P\\33AADy@Tl2\r&a9\r1h2aBQ<A'6XkYx̒lc\nNFId1\0BM	h,@\nFC1l7AF#\n74u&e7B\rƃb7fS%6P\n\$ף]EFS'M\"cr5z;djQ0·[(p% \n#	ˇ)A`Y'7T8N6BiRhGcKz&Q\nrǓ;T*uZ\n9M=Ӓ4肎K9Ț\nX0А䎬\nkҲCIYJ欥r*40m4pꆖ{Z\\.\r/ \rR8?i:\r~!;	D\nC*(\$V60\0Q!X@1*JD7Dd`0\n%,De\"D+BM\nqJӊSR2tsЎc\$*:IuH2Lx'5ƥNp<ȦVLP\$ma6Q@;h\\\0xC@:tFB/#8^M\rˮ7r\"^0ɠ2Ԋ /}CdhƨRYVX7\r|I#uh\nDza(CJFUH:z\$Ȍl{ZZ+.J5b6435Dl Ib.1誨EG2_:	oJXEH[sHlޱ:{\nbQd4HmVO:2ßGXTؠ5Q|\$\";?jV?iMSzݒ+V3TѺ4:@o)]pA`D:w*!a(D\0UZ:l&	*T >( 20BTEl*~1\\-a`\" >ɠT0R֪_Ar:PJJv.༗cWn@t?1Dd2uZ*Â42BKI-!Hb5X,UNvR	\r@'2茋wW80(`w`83Ƹc>%@\nhZ	=M_R&Ė\r'3u((TcQ&X@jјY\$p)dL9c<g;|:o6zIN靮&ء`* CV%3ֆL!SATXD:@P !U eMvG2\"nJÃ\$-HrM`oZ! t6QC!=Xp[ T\r!w4C=aaB啫	S\nA?B 1X{\$	R:|%LC<LXxW5䐒?(/u>:MPIMRlj)Bz}k(vi[\0bSpr-JϛI'\nՒi\n<)F[p'J4)b1nni\$i=\r\"d 1G5WA	vٚ@NI+P)`D\$ͶBVdyj&;i^3rI	G*\n[6!*PHZ!I7P*\\IB	H)a<+ E	)>j[`J`!Naxp;r2f,`]2]%н@Ax0yu9`2vV~,w7n163ͪmLJCzIm(@#k)R /%\"nB5\"BU(*j8EA&K\r͹3/5ʜ,vQ w<j%1*s*WL)ثՂHe<aXy6ᶽ\nb4)L{ui;p_R`Q́ֆ_~(Txds2C`&BALPÞRX[UM[ϒ]l*d Ta =riD@fugjnCH/LΙ~Ax i֎KC`ahu.gqbW}znJI,tQ(\\3ectGuPMl^޺ya}[~me;L㼫|]sju7-UEEޢO[9B?53+|qjlJnzlKAPVCa),\$)F^S.Ԝjd+N]\$wju9)[qhdLcqb\$&ZO?cOOH6lbM[N͛h2H-J4(`IL!n8%\"JP	g`0%\0&S`3.\$#ZcZhGy\rkFj\n\r>ƶmh{̸bhK\"I/0{FC7ΧVx]	Вy'z	gfi<p*ca/fJTN1N\rN&/n\ne	\$+/\ndCƣ	d)	X0b'/-I\$F\",2jؗ8a\"o(iEԊ-}eL-I4eԧ\$Ҷ(4XC<&Dej+v\r}mM`fS\nb	^\$17PPeͯ\r@i/H3\r¬Q'%.,# G6@;\rvڠu7z0y\noD!P#\nN2KpoQm7H(o pbu%2;&氇\0FB>0bף\0MQ0)g,&p*RMr\0)'rMb7\$)% fY,)5,%I+rQ./2\r=-ǚ/S0@z& 1#1\rkS.H,6 AB`%9#*K\$*ƛ\$歠)Bs\\5,ffiNVNU'#NfZ\ndL `P`Ƣ`3iw(f턴1ĂE4\nzH7%D\np\$O,N>*AO#9H/2g5&06#SsCE/R. )\$3?-vG!BMD'<h~3>(-F-<u(g(H\n\neM\$Cx@DACHHMkG4P)ԏJ\rmGE6pLYJ84oǐldˬǧ@xr\0A (J:\r>Q2e^cJm6*%Z6\"b.#+Fd1|ɫ|OP	G\"kTq,;/+ҝ:#~\"F}\$'B\r";break;case"he":$g="J5\rtU@ ak(ffP<=R\rt]SFRd~kT-t^q `z\02nI&A-yZV\r%S`(`1ƃQp9'K&cu4Q K*u\ruIЌ4 MH㖩|Bjs=5.-uF}D 3~G=`1:F9k)\\N5%(n5spr9BQt0'3(o2dp8xY\"O{J!\ryRi&J \nҔ'**- ӯHv&j\nA\n7t.|Ģ6'\\h-,Jk(;.!Rc1)!+b 9#cڥ7K1L(:p4t-m\\/S	:pTLitקp{	0qI4G-bkz{F/b6#s>?@0c7=V<KH4\r0@`@X@2D49Ax^;pO.\\|V 2\rPpx!98&~!4PHTIRI0Ap+#PJ2ALd5iȌC)j*I2#ɬb:6Ԋ{>9.[%i-2Ĵ.kTi9-qk :;kF!۠\"	Ʃ,z@B&mI.7vDRWF`*ŧimԳr,BJU_%%hHjz{L:r@j\$_|L_Cߍ`9c*\"#%k|jyѧzcΥ\nwij_X<}b[yɮItS)zfTA2BAD,@5}f%uRYAi-E[!o%¸zdt`BLX^\n5981HR\r \$T5PِrvC&f֊Z]lex\rˉ5ޜWJzd(v(X> 8/\rK5J4!Hak%^Bh=@C`lCm0dCuU3Y\$xgT2=]@j\\@1țaa\rFI9\"3\rqFH\n\0Ri]iQ8FexoX!4`җ<X'%;rlHϒgW	W,'n\n`xh\r!W*\0δ\$0S؀16@d㚕{\0tϥpDA3H	0l\$؊Z.A1&b\$E,BHX2PZ:#0ZT;Jh!b# 'QfdI&(xS\nȎRb)r3\" \$_oȎU@m<Q\$e\$UKO`21\\Gaz1)aIrP5اI]t0OENi=nƺh,\\5-D\$6vxa\"u,耡9d4L'IrI͜RBTG\rVQtWwi9snI:3/0H\"s70P\$CpJ`{ELY2f]i	Q%oJ4֡ŗHuMbr	9%wߠ %Lmzu\$F\n*d9dP>C{M!:7s_g^?7[#;F啌PbpL8Vo	g%U3Gn`\"ƌISĈ @BHf1HZ)?t~<~I+HN\"\neiL\$pDK˗ؕ#thC1k4Cpt\$ҙyN GPa(KIK#m\r4Ky(ĆfPr>3TPC@DgmtHAn4-f[^B\$[HClj.`#4ڒ h*b^ZC6Q0 ; #4kP)v9joA|73qZ<!3ZT@ twgLNxJȯvªF0}o2\n,6|107Dp:\"90jw{^N}MޘArPG<Zt|{Vyj-Nv3b7 aj	|~FX%\$iYe/^{ˍR^W-f~7<s'v\"Nl{X,~_^{5|Edv1Kw嬁ʒqJ\\lg\$Ȗ\r,00a\rP`CDs(0,\$ʺ#dP0-l\0˩\"!ox&bPH#vNr~LrN@mg`mя0MЀ\n3p~o'FqfLrE2׎e5	J0{Fep,B 9`L^+\rp\"0k._bE7\n!p81,_/\nG6E XI,#t *4-q#PPQ2'#hb0^hCiQVP1[w]	q#2:L49:n\"(MB&\nsf5Z:i\nm.#MQ\ndjg.hTdB%)I\$e.mz#ZJE.O#l(l2MCo{ĨT@Wq83vP@lNhF'tgcd2ܦNR!j@\$O1b^G\$\$\"3K~I<1FdRRh0\$Ǥj\$Qnچ&̝	]'̨##Up4A+g!2\r(\"x.:r{#O\n2{*\$/LndjR.O@lBoK}ŭ-T˶Iբ6uBk'\$F_@mxB6ÖڱԹkƅ_\\+0\r;kA1NzB@BS!";break;case"hu":$g="B4e7P\\33\r5	d8NF0Q8mC|e6kiL  0CT\\\n Č'LMBl4fjMRr2X)\no9D:OF\\@\nFC1l7AL5 \nLLtn1eJ7)F)\n!aOL5xLsTV\r*DAq2QǙdu'c-L 8'cI'Χ!!4Pd&nMJ6Ap<W>do6N\n\"a}c1=]\n*JUn\\t(;1(6B5x737I8Z7*9c;\"n̘RXҬL玊zd\r謫jmc#%\rTJe^D<cHα(-C\$M#*;9ʻF@ޠqXA>e\09O(Ø7ѩi1\"ܠN\"\r0I%%4K7CM1	B8: P6 =))-\n\rJP1l-7酋P@;COg6@9`@&#B3:x{Ӹa`|:9^)5\r7x&f#bK5Lk'*i /n/YfM\rI\n:B67=xJ2 ɠJp:B{\r'*3,[ \":+z O2ꔄ::Pٿ12H֜:3h\\9[\0[5Kzl .\rpbPm!5(#Xj6n-1#t~(ޯ S\$3qՃ]M\"RNpQ9j	1ڑo1~\\\"\n\rhHHf/}:\"f_:g7Vdj()P!=aRrq'Rc1cf7`PQ7ogZP{4`!3sGAC0ᄻzWnl0R`\n2jBP)<HjAG5\rJ]x5úXD)~%I\"m\nAĖbdQJ6/EeStWJAt?pEPp\r%!.ur^K{/r`(`m z.nIфpBl} T	3EZLM\\+F%rZ!>l8lG24&H!JB!߆nkNNC7	ܼĴ^F>,gϣ3xv@׀ \n (PaDN()9nԁ\nTmMH,:ǃrRbч 0ܓD+l0DHg]6KInN	dR=).,+í؟08'D\"VJA6՛P(ud<s>` tH\"M:KFp@qo̥dH\" 1[i*d#,ְP	L*A\0CeМ<ee\\C\r?N-eAVzV\rNX1U@2\rփ\0)+iL2ekI545@knoɇkx\nCLq*ᆪxp*a>7!X\$:CpHg#NUPscpmؔ@voIT:qJ(%=KexbnS(\"QX9t> 111bÌ1:!fbaC@	\rfS\n0yIV\0Gy!-9D\$|IPr`A܎ٮ\r<Luf'|# |<J\\mN `lJfkrE62	:XމvA+?0)wږ TEoʐ7Z\0dAP*#AAHPG43:\$4^WiM1r.HPf@Kqn]fp۲*rp	!ƣ'1A3py%kйZܻ9e7%NwVT3>sNQ*uoy6u齋 ^P1o5N[y*3x󬟛L69Ñ@\\2#TAQG%1OFvs&Id\$d\nA.+e;XBY#&a6\n}Xl5꣜&l}bn[\0匵I{f7;caBn?R?& c\"\r\$eB0B!cfp qWbPŚ\r,dΐEg\nVo*-|%x.xBRGegƶfFDRְ'ʬ/uVO\nK}\n	f&{G++\r1\rC0?-mxnn\0{\n6Q'!Z~-J0o.d@ء:S%p:;: ƛ%\04@x/C0I^Q6\\caRG\"FʗbZ>rZÂnYPq%FቺQ^Gb1g\0;'?BtG'0eOmaS  fe)(΀WhK\n#ꬒД3Fɨs\"/Rp#%?\$	b\0	d!b\$*s03+kdP#Fҝm!\$%v2&LB#*+.d22f\r,ր(LWÖ% *.A\n<0/is\n<[\r.As\r&+fS0)rpfCS7|=2Oc3&5 bB\r3d-X!3d%+F35i,&;7C5fdĹ&L|TMI3`FӖdk:\rH0Dc3rylZ#sWi;,ؐ@ʼ//O=lu>\"~O83S?33/	m@^%ohU@fi%i&,3FB\rVH Z\rrEn+Xz\nZt\\ZCcnNH|~'<\$D\$@&Fgz%bGNj\"^VAC0HTcE<qܳA+4ú\"R@޽f)RP=7\0leLo:leo/\rB.@:҂3iIUN',UN0cP5cZ d&_m`*5d\n'B<tW['}LpbvNuHG\0	Xf: #Ȃ?<B)S	CVf\rTD[5Jj쩵Z<uh+\n[\"6<\"q`6B\\S ͬ\r\$|Ka\"lY`t\r";break;case"id":$g="A7\"Ʉi7BQp 9A8Nig:@e9'1p(e9NRiD0I*70#d@%9L@tAP)l`1ƃQp93||+6bUt0͒Ҝf)NfS+Դo:\r@n7#Il2:c>㘺Mp*4Sq7hA]l7c''D\$H4U7zo9KHd7xNg3ȖC\$s**JH5mܽb\\Ϫˠ,R<Ҏ\0Ε\"IOA\0ArBS87 ڠ&#CԽ4r==&²g'\$3.k\\1Er:#dBjV:sDڜP2\rBP)>1i m9øѱ?X90z\r8a^\\УrP=8^9xDk!3?(x!Z(2JKKBe\"B\r[.\\2B(!\$ɐ\nޢ!(ȓSnh7s8s0BKTaiX	㤀/@PT#؍H2V4B2B3tT\$yh2I96r:k\"\"r5E|h'w`@#PᒥBbSÚ\rmڒs\\C9S]Xon\n,SkV^01n6l戂CcĦLp3Mtz1\n{#!B͏jx΄u?،)xw86(P9*ZPůz6uihż)AA)EF1˨RUEUVUՅeZV׵5AZИ13ңz('CI-Nɐ#ÚUR*gԪjV*ZunJ`%K*Y\$ՙ\0UH!7-[?\$z+6*a\nxMѠiX422X\"P)CE\"~ݻV`젩FS\$t87J	BB[LM\0	:f\$PRL0t2ʮއLʙs2WҨCfE FT(&f~IZX2JC:&6:onE!0RI ek6F=5ˠuCm\\2Cj\n' jDԞs5\n@5*KBI& p484#7O<|bT\n&dO\naQ\"	1=3U\"&p1)ҢvYP!7`H)Lbg)C(Ln67d 2#INWQn\$ \n	d16\$YEe<'\0 A\nV@(L@K(M\njh躺#ghC䩂GD\n>r'f.-w6[q%؍Ja2G&\0aU5J*J4)	e0`:BZU.@I%[Lb,JtΫZDbciPWQE\\ wQiftJbHPMj1{ l%Ë\"5I貕FPR6!xZzӣd( C	\06Lxo>49>'#e9HZ,S(Y&ԆF_3Ĕ_ʑnȁ%	H6\0lCj=q9;yBȉE4TLd؝	=ф4rMƤP1]u>:1>29\0FQC1\r(̂^A~.)ݗ?AZ/DEvBIn3S_4=.Y2k[ڮڬ:wxf[\n#NQ8!RѲizfz TnGf@Z^ܡzdDɾwX)8{O7տ|ɼ9*>KlK\"a~Dr]iN|76ҷq._۟XޛْwwiSNe:&˺s}c՛.u֫d{;ްg[GP*\n  Pbq#lp@CQ?NY6I1K؛\nZ|\nBƘ3m?P*სͫ	a)6sFӿuMu?6|P|g_n:9q~ϝH~M2oFj	z^aB-m5ӰDn'%poo(n#Zn&,i@hޛVetp4HD0bIXpcP[-EQϥn;`PM%L&FQc,6\r,;\n0\n	0k8ð:P^%Mlxg\rcvDňT,fhL˰2֍@&/ǌbr\0ZxȌN깬%Cj/\nB,,d'4G^v%6%-x`\npJL->Ϯ0IpF\\NP&b@>,ö@2lL(bF\"r\$\$_bbb\0\rYEPreFj,ä(nK HLOzlZ	,bEmA sF2&'L\r!\r*\r*׏5fJ`ʉ Zhji,p9X	L%@%쾷Ȯб4A\" M,9\"bk0i-F,;ű!i+l箓Vj\"HR5M 2CЂG@Fg hFDh1+BDj2\0";break;case"it":$g="S4Χ#x%(a9@L&)ol2\rp\"u91qp(ab㙦I!6NsYf7Xj\0BcH 2NgC,Z0cAn8S|\\o&N&(܂ZM7\r1Ib2Ms:\$Ɠ9ZY7D	C#\"'j	 !4NzSfʠ 1c0x-TE% \n\"&V3Nw⩸#;pPCΤ&C~~Fthts;#Cbl7\r*(椩j\n4QP%\r(*\r##Cv`N::MпN\\)P2.cʍ\rҶ)J:H5\n-\n1))\nZ\\EH2-{NS\r\n9{1=@P\"#&p޵\$4 j#/kV#9>1pA\0NP@;cC#L3`4HC0z\r8a^\\0Ѵ{ʴz*2\rC7Brݤ^0h7=T\roEƘ*cP: k/8K5	 #sD7B!\r:\0<N!b7\"\rø@k4Эc 3#I4)>#19\n <PІ/:79'Ύ%(:vČ@@Y~H7ctC\nb,\n~4W34#-M\rO\0(3l\n\$|ԁ!&r;4\"M8itfsk \"	3Ε\$67@3fA;Buc,jzx7O@\$c7\nN'czZ*2WjMkgU~5s&UV]\nXabs[nYcS¬PUc1E\$H9RbHp\$?~Py!ZV]+|I.V{|>TDГpOmiBpCᕁ`	s#T6Tc*fL\"D0hZ|^1;yq5HALR8lLN#DSQ|\n\"\0sƜ`RL\\E0ܢc4-<\\ѫ5E9L C)	}\$!iPVT1EX!ᘜ7%aL)bA8La0\".4C\"A%̆0`s1WjI&D(ptT5&!4GH m~%HMBJ5@P\$DsS'R\r!?Eϒbi6CZ-NrSFVbF17\"SiF\nd枡Ԅ&-MIADr O	*\0BEi\"Pl	oG51bHr)Ƹח#O=4I9aLk*1-AS*0rF\\w\n*Ih4:d9S+tH3\$UD<:F``\"RW1BJ\$\r%<(>b\$hMH*Ζx@h*2Hzhk&VзH)-pHߔ'w\\U>K &/Y^QX)7RF\"Wϰ)\$\\<gk@xpxJ#S3[\$N΁s8T\n!AG\\It2/`X/ųCN2*j6`xa<%/-0\09ARZD6МaK\rTC8u\r)}Ll澬LÓZӿhaV|)iCH|Xƍt(#(](K8a60lwajuxp>%C4'j챠3-y*-dqp[0-ӂ&m'{w7f%3q6̈́oh7}QWC#p\"рEcFBJAD8pr\nrB}d\nŷ}@V{/>@o.WX)DS*[>ovŹTDDpiW(=r>\n+8:n.7u,\\:i\nY=D1f7Dƍ8\\oE\n?xѡp-zlB[2ӳO0VEQC>3Oz׍xJ|TΦѤg}&He~\$:̪5wМ|T~?Dj4\$T=>.L~&,9f/tŢ\\&h^^]=`js`CBw0x.NLTp`qB2\0&~#Z~j'j64Cv[9M:g	/j`SxPR&С\nEⵤr i%MJ<H^g\\\0qP>J]f\n&@>b|B4DCD%mJDQPe1UCwK!nnRF.>ǱZM9B\"X\nA!Q^@'D2NlOi&.3P*ݮ\nѱ;)jBb\"-\0BC#fK#BF\ne)C⩱QA 9@jP  mBIO\ncNA^*i \0\npJr/Fխ0&\n>G3%OLMK\0t.@Ĕ1bP%G6ìjG	򳑄;#z-rR%I¦# Յ%#*rH9Pd/0B1,~tI@!!,:%&-e4c.,-C1/GC//.-\r.,,\$V2.*J7eC6*hƐ&-2-4ʲkA#.nK DXi22\"\\K2(_ZC 6rskHbzkEO3_70F0@\"+H^l_b	\0@	t\n`";break;case"ja":$g="W'\nc/ɘ2-޼Oᙘ@SN4UƂPԑ\\}%QGqB\r[^G0e<	&0S8r&#APKY}t Q\$I+ܪÕ8B0<h5\rSR9P:aKI T\n\n>Ygn4\nT:Shi1zRxL&g`ɼ 4NQ 8'cIg2Myd05CAtt0S~9s=O\\t\\mtTBЪOsW:QP\npp@2C99##X2\rZ7\0\\28B#bB >h1\\se	^1ReLr?h1FzP B**;@1.%[,;L)K2Aɂ\0MRrZzJzK12#eRiYD#|έN(\\#R8U8NOYsI%``P9-Ap8TX9Uc(\rØ715(9~!bA'9PW%򏩖T2H#`Q+Dؖ53*^ATrqRŁpQ*]ڤT6#tB]c:9C#153	PX;.#MF9`@b@2D49Ax^;p0@]x7\0DxDl`#465}_X_9tB8I,I(\$IM	]P96WE8s+#݀PJ2aS%1Gt9VQ)SY@>gI\\St:s̝a!8s]g1Gխξ\$nLExBK[0qqJ*E#`0P(8Osi<KE;9v9VZMR6࣠/xy@u Q1bxS[e'T\\Kd!mB\$\r\0*p>^i\r9CLYZ63|ALt*^py\\VC37v4DA3#{\0007S\n)((¡@F+@Ę!5x#e^Y5fȴDB:5fUbma\"a.Q{\"OLKASc]C S3HiNh! pK+DV\\4f;xrh-\r+vJi\$6lZtUφ<\rs!!'̮\nYjI<|%fXHB@)U c#XD@0ihH́7a0>\0cS4b0FH#t14.HqЎHx*\$<	_,T%40A\$a&J!+7f؛3jm+aad._oQؓasDB8 cpp̅7 (c\r4vaIN<!CSA) [1C<\0 Nq!%!FjkMGSQ>(\$~*vkIlhA|%dI(!	{+FhA\$K`inXqdAgˠ`;ȀTk(j I!G%ˆ)e4A,.*F0A?Q@]LAF.@n#w΁dglVP@` F,Pbꇣ9^E \"A!E;yc]<@\0U\n @ &\\^S[G+{XO1=b(拄|E!AuM!_\\yt\r=cBDut6<I:X=1#\\SL.,a>S8ØB\"򐖎loW\nnUrWRܥD*< dR̎|ᜅ\0ΏZIqLIش!ƾ#\\9Mf|FB*)-`8(\"`riܪ6ږT,Pf%yVWB,YV)Ϡ>y/n<ǨqL[Nl\ro8W뼏0/\"pBQ!dV^M;(^=BAa `.HIl&\nc\0AyRL̂7*md\0Mk1!FoiE\">b\">D~+bj쾇^K>@2(;QJ/5g.%iH\$o(jBW~ZQ/#8eKSMϲJn@n+!'}\0bO!Zn!b62\$2oC>ONg<o\$o!FP\"@0v,3nd0aGPp	ЖPh\\GnPp 2QLLuLA@I ~[/G#PIfx] twtIo0\"1\\r*'{*4[0G]h֐	rQJՑ.[&𠀢/h\\Z.0hogQx\\G\nh#Ak<3ђыQa\"*N쐡nVѲnLGh nq醼pG!Ά#n\"SS[z Ђʦ4BX莌rq*oz0~0d+RA#	\$/~JMEnn%HNZm1\n`YfңR)q+1+n^mr=k\nrҽ1?Q|~a.jAC(^c pg:1\\Q\r2	.#212sGvD%m#<]3kp2\no4ESK,.QYac2h* g7Sx\$ε87q7r#\r!s)837#YdYKM59;\"?;q˗;ˏ-1q<MS;:S[3MsRON)=©@?@@>#Ap*dOg`'3@#>DC4	\"1s\$]630a0=aFh=F\$ȎS@T*&ny./ӘxJvrEgIayԝ/Op}h\rV`Ubh\rȴc̨\rC*L\npU&9 GHC+R	°n\$Bb:d^S69\\2m2hPUP2#&!on.lEL)aT%.|>uz ~=c#T\"z'1Aj9|B/а#v[S\"N\"8+A\n3A\0Vt5#VU\0KZ2gLGudƥ0EKQ6.ob\"@3B`\n\rTMdզnB%hOTS\n\".Wa\$LFrv\\W\\{1]/0\rd8S8y7p,k2DOk\0";break;case"ka":$g="A 	n\0%`	jᙘ@s@1#		(0\0T0V4]AC%PjXP\n9=A`hJs!O­AG	,I# 	itAg\0Pb2as@U\\)]'V@h]'I.%ڳ:Bă UM@TzƕduS*wyyOd(OƐNo<ht2>\\r֥;7HP<6%Imswi\\:\rP3ZH>{A:P\"9 jt>Ms<.ΚJl*-;.JAJK ZmO1Kӿ2mpvK^(.䯴O!FLڪRkjA/9+e|#w/\n❓K+!Ln=,J\0ͭu4AݥN:<Y.\nJMxݯΓ,H01\$#5),\"҂dW6z,: m:S̡R0ݧsC;V/VwYԢ30v5QU:K=@k;YOdA3 zx)+tKWC`v\0X@ h7e_R7pUV_nJ(J\r3:x海K!p9x79c2@*NBx8*juJJ.Sk6\r{PBtV8\r=`)\"_nz9pm8JWCR4/=!(ɉ7:\\8}Ե\$mKQo0}xS{p5-l\\Ē©y\0;Ch	է}٣ҕ|OBBJ)ϑB>)SKXRms\"r<\\dy%C;\$X>nTJyXQ!L(V^	W}CSrCe_,c_O#{WbEv9BlQ/;	!IWlo(.YUT}|d#~/Wv^	>D2r?y'Xq)W,f_RX)|9\"v֓^y+&	\0JEW?9	y^u)m&SCzWqjӰH(2fHəC*(ǕYV^&\\e֝F]#lDW܇J;Bh4ӚRjZp5Z/7hcim&XctGI|-ŹDeS8De#9\nROs+g<RJK\"iDr`tkzr5٧/'Eh%֞Zwj^pכ\0eѯ: PskR'Yh>eJՍK:QXsRHŗcl{6(02JGivAvii%2H&:F^3\0~>qM[wJ~uB\$CZU188gLq޲?\\{)6e؏As\0(+ӫ-S0jx\"ɘ59ob]d0,QƯJt)z,ܴHۘ;K4nڛ6vi03+!JLHwzЉ[\rL ӝe|t)>ˇ\\!x:Bw65ԴגhQCSBS@ԩW1vH\n65&4q:Y^,9l('SLOO\naRѾQl)\$'cdۻW+Z3*tfr[%[5ntԹmZY?=SUc*YTePew7\\K|ĕLLJ=\$m,urb8x.2O\0w>C.󔼡w`vg2I{^VV8?K#qL[}ҍAeBQeJۇMTXheϲc^!@}ŸnY\r쫓&끿?Ȧn;OX(V̸4%ǐ-JdFH*d*mԼʲe*2<OC(V9YcKX)Brԧ`b9vM^dⰓluٸg;V杭wOnYogIW?0\$tᘽMN_?%G2Fc0LaT_kfO6}\r]h>\n!P*_uA/TrGoREүo͆X\"G^uθf*8|E<ǉ##6B# ƣ,,.Pw\\8h`pZ^⪶rvK>'#A֯DJ+@K\rvwgno\nXFkN9LPl\rÏgb\n/bNn\\AHUH%*'ԾH}\r[)î(Kvдs.=vKLm'OF\nA\r !0ZQn)LO\"&7O\$4H=(Y\n\"L4nw,('d'װ@,\01WR\$X\"q@.ĀD)K\"|29#	]U1&QNRO74&Pv|.P*ap1c2a\$d8.&rIG\\qRPvV(&'\"<*ZLx|7q8Hё.*,Kدnf.jqlE*q{Qr4-P\\#`LY(J`xR)RER(K/.3.No(UKIrL/O70q0z8(䗪nwN|)^r0g4BK2\$*A\"/926mVe://NL\"R޴/n/Lz21!6\rNtWʀ),\\eg<nM\$1k^\n>'16q'wIЕ\"rj@Ozr7@Q>OA'Af)*bBO)&B%+C=BNO.FCCcw1QBQbstj̊/\nUT}F3ݭTÒ.Y.5Ie+,-aI/**Ja+IǗD'l(S}LmMFG4Kԛ,Kq8wELǨ;EJ)F>,Lzq34\".zJ'qFat-!4@5U,&2C%\rQ1E4Ms@U=UUSO*RB(4eS2s1J=Qn@y\"OUS3BTv7sTmYU5XUM[aTDN#CtKEQHʖKU1ZUuZ1^ImK3/]Ex]eW`?llWV4PGfE|`S'-+I[cNU)o,xV1[1sYQq<unlTئʋ+%+67ei\rVRh:L042\"3Jb\r-\nBO4f'ps	%̏4;%O5QmD\0EaXdgo+{VFlRI4hQh}hȆ8G;VAv\r/)Nwqn@W]j	IQdE~^Sv&}QLXc]y.ypdzּWpzWEW=AvآWoh\r#35@@U\$|1DJ7)uVfu7Rr1xk+R,Sw:\0(҃3%	ORu Z<.K<ql}&9!z!zR\r*:fŵS,mIlc~";break;case"ko":$g="EdHڕL@؊ZhR?	E30شDc:!#t+BuӐd<LJN\$HiBvrZ2X\\,S\n%ɖ\n؞VA*zc*D0cAn8k#-^O\"\$S6u\$-ah\\%+SLAv:G\n^в(&Mؗ-V*vֲ\$O-F+NR6u-tQ}K槔'Rπlq#Ԩ9NӤ#d`'cIϟV	*[6aM P7\rcp;\09Cx䠈0C2 2a:8H8CC	2JʜBvhLdxR@\0n)0*#Leyp0.CXu<H4\r\rA\0<\nDj /q֫<uz8jrLRX,SǅQvu	\\:ňH\rBPpJR\r3K2Ø7Ԫ	U)q:7-XhjW\"`YMd3SdSNk֤AL1g]bj5TjLŝu@@yEGB6|;1K#H0cAS>\05H4\rE]\0y3:x\rzpԁ~+C ^*	C	\rN7xUVij֒<BiN\\%I\$PGi\"+fZO1f@!6{VYm9[U/1NF&%\$?n@1`i\nK}Q%y-dy2: 0ꚵ^bp³<\n9EBcDP[D?ӊJĵ.q2rQ\0 P\r9c\"cU%sNcX7V[[\$Ur{upvE!Sa_O~y;~8G?~<(Ƕx8̓p2-	84, CKb\n@\n/쐫֪SF%(!YYQ՜Lؕ/lAx h<\0C`a\09ld:(C8a>5W\ns9TLKd-H5FY&@Z!hi:@pAd1LuFY;)eaݖ܃s2f6;;ҹf\n3bH:|\$K\"zrJ \$)voBG!Pd47EX1cLq2D3(eLI&b5T*RxI\rJH%>FH2CQh죖C\rBH*4Ud8%46=ć(rs6ZbqXkLA)94d53\0239LG`G`!,X5Q)`% }g~DBo_׺KQlD,9kh!81&(fۅ40Hgd`48dhe\"yBuS\nAf MО%e\nIbLx+Bi\$rѡF0E1*LAJ) \"n	\"^H2J(% u!\"@MjiHyb(t4UuL fB!HJedhcnY^P	L*fV/b,ZO2Sʍ\",U>j\nJ=mnp !*hqXJi/&\"q#d榯K@fOu*9.Dȸb鿛	fޛ%L!9i)PYS`L^c&?A1}<tF@W6aD@%%XYOe\"RHSaZ~Y)aw2W:\rSYǗW{ot*f3\n V?]Z@J`vգҋun ^pUTf͑\$E9R o^6@f5ngSZlTC{2v!\"SkVnCWHs\\Ӛn'Kz|(ïc\r-\n\\t.N0ؘ\nzbvvZ:\0D/3!P*A0k}*_Ka\0^!&d\rێfxMAqSR>?FsB\"|]:A=GOWYD9B^S*U1^DߴWw!UlB6~kzۢ*HH!ld)8;wt#3#63DU\0ϰo=b l#\$Cp%4+t#XD20Mm\"PL1P/LnH9P^6oJHL4[cbX\$ND#=\$\"l#F8a7Ix*\n\n0xnMF4#\\Q\0P\\/lM׭iGaZA|3ipWhJ\rqiIdb81>hrA4X\$ENY6XB4~f~͂m~?n1aJ1.%0H!)m\"V+:)*\"8,ĆWAn/̤\r*vO@&ĺB<vſځ/+,!*QMK>Oѵ#Eqg\"Ru1\r<0\$1c\$2K66Ndy2Jk<D%ЇHj\"b 66:Qp)DPI2&BrTfugÙ&uqt8%Na`\r'.\$ʁ\09gr*X!S/,x-0h.NOS\$\r!93,o\"O\$Xdz#z`֑5j1%:I6S0j\$Sm8rS'2XM`X.N4)/ћ7is4ŋ:ssR7:6MQ&1'	4)̂C̓Nx#=Z\"٢^H#F#~!!1/lj\"?5p+@K@B/'P(0-fh\rVK:\re0AtgJCg\r ̊( \r%*IDJ`\npSI+E/IC,<#%1`6lu&4pw;D;2pw#_Lt|1Dm*'M\rw=\0PPK\$sLizN2,gnUgtcAa!JolL<6!ԡS0q0%KbgAMU38D)8HS\0\$cVڻ%<˅ hTdv+8Nt [M]'\nC?(VE1!jkտ%+SBOo~m6G,^Ex%'R/Sy`*9N";break;case"lt":$g="T4FH%(e8NǓY@W̦á@f\rQ4k9MaŌ!^-	Nd)!BaS9lt:F 0cAn8Ui0#InP!D@l2Kg\$)L=&:\nb+ulF0jo:\r#(8Yƛ/:E@t4MHI'S9P춛hb&Nq|JPVuo^<k49`\$g,#H(,1XI3&U7spr9XC	X2k>6cF8,c@c#:Lͮ.X@0Xض#rY#z\"*ZH*Cд#RӍ()h\"<\rb	  2C+\n5Hh2l)ht2:H:RdpB\"l.(@CZʧS@7%#}\nn[;8ʕ4Qn)KP%_\r鬛8.1=-P43[\nB;%DY,Z jp<#ϥ.bʎACAЀXD49Ax^;ށp`c\\z2t\r*VA^0 :<c[2U)TъUN򽯭@; ɕ8k.Hۂ6jZ^*+ @*\0h ΂iV:.6A4~:!\07n4:N*@:zX:V/45u_6\"Hʮ\"7d@P+ʕk`74 BbU񋆋34i2%\rcW?7;ٶ@S4cC{ݕC\rXL#cIbJ:ǵ9'Ukb_t^4l#lB*QnK{dgOQ60U`N>5([#DǙleCxfa`蚓`g/P7bV9hf[yfQ:>AaA@s\$%2r^aDVbRpԛELorfuQ)r%кb^zu\n_7Zu@;3Ę3588RQ@j%\\|IB,fzH*X3/R>2vj^+zx_Cߨp.\r@B4𘓰C'l	5#\"yWƝ!W)UAv-,̈Pa߬Xas\$PpN`aKXbt0oK@CHo-t&F^K=%v@PC#PN\nj(4B~% KQ[7yFx^Cq\r-'ZPw5/h, λ'%A\0002\$ƙNaL)iFB&	ۓ9&C#9j( H(@o\"3ZK˃Te6X;;ěHjMI;*:Lx-pҍA8ż2>~Cl[H5DD@ٴ<)JܜLh {`_%{'oJ\$a,zVƘYY9q34:1eSFHE;>g[*Qʆ߲;6.,}y\\,iPRNT0DZ-0Yݻp\nmmu,\rU}%0DTu\$6:KtJA1.q۶|͑_CÑ\\k8<Ԙyw\nաAȘXjw\"[j0\$RdHk|o->zvG4BZYg?	(PaP*]5tD4o{NrW{HPLH|KЦCyoRI#ɹrRe2L)jeΤ9})͍%Q@K\nU ,&j崋Ġo;@<EMÍ&3̤W5nGi/xTPCB3Z78,v\\L)P#vT\n!Ai7jqM\\/n\$\\RP94کQ᧜c,-xxpft(+LPp	\ntA_ь)L*twzwTK'-+[5Dr];JvR)g9}ڶ^ab߿]>th(~\0LNq8ǚ)M/rR%ע=OA[ȑ@g053\\Vd;Ā	kL3\0{qPa_Yo>Ojd?[̹k΄z!2؁7ڗDu< (8cX+}E,m\0ԇ7\0? DH|8fDX;@DE!<DLN\rA\0\0h%\n\"/#^@\":l,6n:5@Pu\"l,G-N%)Ooאʰ\n\nQ׏hǎ.δNDNe0펜hB=\r?.\rLо׃pf<4B\"ƴL*J^\nNu~#GFii#\"\":@pn\rh  2àJ1tz(S,Z6J`7\nN\$(r11Q6kgUk#ƭftޤj\rO͋<fI,#a0.pOO!)!c\".\"g&\\˘޲<#\r\"^,%ji<\"Oery#f:אm&-׀olo;r&5/rҒ>29B822ne#ozScqD\r-P\"I)Z+4{bR˲l#OO.O y0Øm!/1\" ݄-0}2#\$3s-\$Ir[\"Fl|܁B6G\$')a5S1\\\0/'\0̣)kdjI06q3&d sS+:r\$H9f@;3VK.|=1\r_>~\$c\0`ƃ\rd>&&̆ò'੬`(r\nZ\"I?,z4D#Hө3D#NKf!Tz'\$\"Ìe	-XC\\8R01BHc3fbTt ޽&CJ, K>U\\TA\$hNRnb4ri`%5{5OԌ>4\$P0*\$SN;'T/@c&IȵT'F\$\"!2<q]pZ,JGp|~huZJF&%1P϶F\r	8XT=-9Y%&ǎ\nD%iP{E~!\nЎgl[Q\r..e*\" kI^C\n2)@/c@";break;case"ms":$g="A7\"t4BQp 9S	@n0Mb4d 3d&p(=G#is4Nn30r5h	Nd))WFSQ%h5\rQs7PcaT4 f\$RH\n*(1A7[0!i9`JXe6鱤@k2!)Bɝ/Bk4C%A4Js.g@	œoF6sBe9NyCJ|y`J#h(GuH>Tk7r\":7Nqs|[8z,c*<⌤h7)Z\"íBR| 3P7z0Z%p\n,X0PA#C>cx@J2+J(ɂĤ䌸; \n*0\"sz4PB[(b(G\nݠC&\r˒TEl#kR?Kc'\nt4@:Ӣ\rA`@ c@2D49Ax^;rK\r΀\\z|2\r{ԌzZ-!^0(46(* KÆ^1o}(XBK0è+\rRp#\n<N#舖7DcR%҄ |Uv#3£-]a6DvIjl)L\rë\n\$2p9|K|s`y|3\n(S~Ip8k=\rBZ\"|P[ӫ3I:ϰ:9P|`Kͻ4%\"I7`\rot0̶٩-ȥ*:&:9n!>Q1	BɄYp(eYy0\$7WLI`JloК5pҼWa,E4-xd-\$T4	d:s.d~ANbyJ3.|C?TS[vUXkcVxrZ+M/&sǌJ\0c_\$R68ePF\0 Y>\$N\r!>}c\\U>OcFqsÑQ`Gb5 UԕСj!p.HPLoei!7a@\$j\0()@<NR\\*Yuy`٘ }J\r%F<K|Ws9S2\nyU|7D%P:ד42:}2~Q_lo'!0I٠)@b=(#,Q%sjYiznՙfĦi;>\n\n@C\"1\0Ɋ&:4Pu\r\$^:P*sSZ+;F&(rxS\n)~Ddv\n@Ϛ-:Þd1Tʅ%)H#duvRf-)=B2D<#,FOڬeo&8\nlpH0p \n@\"l&[>c?ks8̝Z\n\$I3\01(;tAxs0h*Bv]\rh:ۛ~ךOhp=͜[\0-&Pƈc\nP:>Jɐ%)J5樴FX,)RC\$[z-(!H8Zis\r4S9o:\$q)i0k'ưN&u)5ok%\"R]2ȵ`|V_m0%\nlɴҾwAIXpay'DBu:ao-!* qA<\$0_Y'er\\Mճ0ȒH]%I\rJcGr/Mi->OC]jpΦMEj\"Dȭq#Dv*F6t#CQ-0%:ؐj3ʗs6:S`^G05ovptm9i2:]N)\rcJ1s5T\"@o\0uZOl/-e9ISl`({y-غB۔UtƂ4JYu.ك俚GaK5rf-q66{S'<cݮw99(2DmvE(M?^]'}{\nxX鱗/8~<J|PinwT9U6 07X0<|x:%j}!MO6\$Qm38dL`];|նLHf):/HqD*S\r]d2*aⵇmy5bo6O/f\0nN/.ϥ:.OJ#G(͖>LN(hL(D\"GΩ\nѰ|.7.no8fKZ_0-M	@\09Ɯ0/:&{\0(א~}\r\0._p\rF{MY?0	.A-PZ͌?p&yP?Llº\ȓ/\"HgpN0FA4ƱD	j R>lFb,!		i20&.>Lx>:*b|!\r4UZDd>\rVbgcTf\0@YC*3TdDJ,h\nZJONrR(Nv\r\$Ƀ	\0(VPܶQ2\"g(g(qpd_\\򶊌Qw_d>hNXOBu'`c'NB'q'K}6&nG'h6f_~Ǽg,\rP\nnjrlhrvӀ\nX	M)2;&^1\rK-b4-&\"%'cKػf!a/#\r:\00-b^9/6";break;case"nl":$g="W2N)~\nfaO7Ms)j5FSn2X!o0p(a<MSle2tI&#y+Nb)̅5!Qq;9`1ƃQp9 &pQi3M`(ɤf˔Y;M`@߰\n,ঃ	Xn7s4'S,:*R	5't)<_uFĜ'5>2vt+CN6DϾG#U7~	ʘr({S	X2'@m` c9ȚOc.Nc(j*%\n2Jc2DbO[چJPʙahl8:#H\$#\"::01p@,	,' NKjܠX3; \rш6J.|*Ï>\0ұF\"b>o2P%nH4lI	#tԊ9t6P2\r@!@AOi\$C3nFb n9s:D\\3@:7A^(\\+zfvJ|J̻\r7xB|(ƕc\"م\naڣݏ9r:cJWN:΋H<`Nbf8,d2s7\$Υl:Uy1.=H26 c6(B07az\$\"~宮&IAk\" |0,FCZJ0:W[l2>6X9m(Z9S빲#{XԖ[d?H:=MN?~R|ߠPT6Ȉs\0ّuL\\Q v5뚦.̠X7ۍtUV)JN<1ضͩ980򢊽*MӤ@\n^#gm+Cxy3ĩV8g\ntӢ i8leV\\k;upXr]\0`נ>3Zx3܋  /xpWC+(*&53.MA^(4|Q.f\"].rKPz0|r&ay)i/KD&NGRO\$Sм\$\"G0T \r	!91b}4ph%RL9Xq2hpkLܢH\nYAHbFr:X\0n/md4FM)Gf3fڹ/10&I6zC\nX.UAAqPsdIxTv)Mм\0F'.-rX!qC(&ܜzRI#ȣ\"(i\r\r6	RjHy3GJ\r+I6h8a=vPK:*h(PT2Rm(85')\\E#DE%+#gI>80gbfJ)%d*\nj=NƔ`0Qw	\nX@r8#`^\n)Q*EXNT(@-\"j\0S;%M)u%s(&6M/HY`c	ᶵK<|GS?Hc4	u0&u%SJFXKCdB&IBQ\"}aLItU'#OG(u1'1cRAM<ĭZz.#Q^]ھf2v0ưU<;lxpE0B~_BAfF`fC+\$pGU/a#'iTcؾM_^ޱC#H8B,T7Ww/6C	\0DҲ@Ŗ'fA^4#ؔS\"ZΓ tYC/Rk=R-QH\$cWKtq)Q,]'ȁes,/YS*:Q>Ms2E;bMz&ɺ\nI6{T)	(@8xnHhtGrA	b2%d#fT9R?0 Het9b}9#Ns MRo3sNm\"g~Ν&8ۻ|[9T;\n`pD>ۻTͧR\"-{l<jtoERLJn2T<'RqR7a, Tw{k\r|y 9N΂'I G7g6dh5jS;4{XRYAf796||;(e%e>D=^ G	RPlr\$D#Pn:*&/Nbq؀!K2	p> l#^HC?p\$Ҍ##rac;C\"c,j\"J&4/HHPY.N{6φΈYoJl?v9)<NPh8cP\$t,ULEWDC#T\r;ھJ}ҽp\$okPZi\rG\nkˬo\nvd:H\$\nl\rP^'iΥ14%812k1(Y>QLl\nYEYm\0̹\rnopQ;,1їtL=wHB,8QQ	Ph`8bVZ1&if\$!ffG\r¦5*\rr8@Xf5F/r&TRUS\"`*qib@jBg,Czz&B#1C.L%voi2\0\npI0M\$&Rxgt --<( (\r0#B#C*aG&M ҇f(NN`1Q\$\$8#\0E,D% %rL8a1Rtj	䬪xp̶yxM(\$E\njX\":0.n2KB8\\E8`#t\0,+ꄕ)=SZOb3<(Å tS75ƍF'(uLT=9o\n*vMr9f*R+'Lb?#\r)<h.N	%bXB(de0&P?> *1X&gy.C|DJH@	\0t	@\n`";break;case"no":$g="E9Qk5NCP\\33AADeA\"atl\\u6xA%kl9!B)̅)#I̦Zi¨q,@\nFC1l7AGCyo9Lq\n\$?6B%#)\n̳hZr&K(6nWmj4`qe>䶁\rKM7'*\\^w6^MҒa>mv>t4	j	Lw;iy`N-1B9{Sqo;!G+Da:]у!ˢgY8#ØH֍R>O6Lbͨ)2,\"8	ɀ= @CHצּL	;!N2\n86/˓69k[BC\"9C{f*h\n/#\n,0@7 4ܪ	)*R<HR;\rP\0s(-̢HS\"t)B6\n\"1o\r'(1>a\04@:L\09P XHПD4&Àxe]0Ar3X_[#J(|6ĩ+>L}'CBo:+RՎH;WT>-'.#\n7-8憌`!.*1b&7*EC.>65޶\riR:1(0c;-îM8#\"lh0#P 0)ۼ4C:6*h)90HNF#BC\$2A:صZ9l(hֲx\rUoX2 P%46\n|*(-7HP\0.۫b]\"LEX6Dc(ZhН-Y.P3n*3F7IS8孃w-¶0&+gփ(P9)H:Rrz\ry!@MU !S,Ri5z6XK:,ebS+EiPϩm&iinRK]Dasl'a@r	bJIEnbДj@6wXmbuúRi%JkMn0|ꃁyfd* !7ɂSNQ;5f0\$RcѻBvMm8aBxC#G\nbn\"{!9)Ʈ(l|IW+\0LsiD`1YKro.%̦+EL.H/IH#P	@h*p((*#VDBz\r-pLr2;aR&^jx%\0_dR#&T4\0_\\A8+IJPU49n:AO7JKI!08ol\0#Rs܋2&Ia.&E7@Or)=IrK!ÈH-!RHyzIՊ'ş {	r4Pe@̤B>i̻.Q4җ9| e֖RZ/xOĥ8e%Lh̿o; ! <M\$.6I4_#@iumvAJ?HRz\rJԌ\n3\0\0U\n @\0D0\"f>T:PL:]\$BaKķ4+&>䁡Ȗ]g&BJIU;TB1  -w8*pNVaD| a\r4ThҚZd&V&,<5\\b,WC&Ƃ!4fCJ\r0NS*W_\0*cn\\La-u,D;l	#;\$Ծqq\0xT-/`xQjDBC)\$R1|?l45l'<MDZ@@ )OWS]@2r2oH'@ʾ1A]v`\\\n3H#ZF.\nULL;lM6F,ɽj9)6@N'[[YM6)<,kA7cz9O9ǰ;2	#ٞ:9sxȐb-0\\2*螭/B`K!#Pc+夝п;&9=\0_dKn3^QA{1iˣ	.^6SwI	X1t(e-؈\rs6G6-Ȟ0Hd(3~T9CH߿4	u`mcj)Ew>rPڌ`)A:_YSA`#鏙LdHݣv=G쨅ΫKc~)FXBߤgGAm04i?aL߷uhY.-R!=o&v}KhB~I͋\nCN\niD^O4v4(Gb)͛go\rvFC8l*B|4L)zio\0BaJцq޼:EPp@̷	P\nh6:`\0үx%0Λ\nBҧ,~:hfOEb\r\n.x:R\n.|QnP	0|IJyLkKPv;`( |0e)ǆ0\0\rqcI\rqk#bq<afFd\0HEi\rQ~̑]B8	σA!' 1lJ\nlm'OpDLPm3-!`֝P:)yXlmR#Ep(d%\"	fBbd\rgE+\"Dm-cO@D``A\"b\nڏXKn.iV\n\r6%2`Tv.+V0@h\0.gl6Pn#8\\8AcI(l>ocjAd^/,\nh*Dd\0p\\cLx#\\kVju2B12X\$6+S*0!3j54N53D&c\"2,}Pb`\nU\$09.._͸Ni*rl- eڼ\ng&!V@\$2f41%M=(cT0\nx!@-+q0#\n-i Fn\"";break;case"pl":$g="C=D)eb)e7BQp 9s\r&ybob\$Gs(M0gin0!Sa`b!29)V%9	Y 4I0cAn8X1b2i<\n!GjC\r6\"'CD78k@r2юFF6ՎZB.j4 Ui'\nv7v;=SF7&A<؉rZpk'z\n*κ\0Q+5Ə&(y7r7C\r0c+D7`:#\09ȩ{<em(2ZNx! t*\n-򴇫PȠϢ*#j3< P:;=C;#\0/J9IB87#H{80\"S4H6\r/ڲ?.:1O1`>T< p4Rl&+.)12X P/>ּ2܌cCw85幣\n寍d9U2.\nX#Ƃcp(,S\0@Hp4\r㭘&420z\r8a^\\0N?#8^pBAxD{ \r3򞎔`|Xkp1[`-.JhfDVBd%h'> ,J:23::&58ZN錨	cx\$({LB\r#pI.}eF6\"xbëӭ\n9Y%4=d,X3\r)(5\n1U :R:(L8L 8oDCIΠL?q@>s횤Nk@B&P8YU1Ue]惝Z?\0or1\rV¬!܀:HU	#mΈ{͎bZypCsp=\"\01)A1R\nAJ|!lʰrF!VKC}ʆ @+(Zq[%̠X.02BbaLUY`3CDHT>Jx<(D*qN&S4(خEΜZn\$Y\$ !@X((CoBeruҺj^+zu\"`!2Tkƌ26SjpÙ))N+҅l^:RBE3\\IP@*]x/%轤!	HTAQr0|lKO-`abPP\\d/Q%jC(t'.D @@P&R@*qB\r!6dCI%A)Y@3ZZ*[f5l9k630^xoD5'@1ECΨ4OY \n`f]ch,PWAP1 Fuء@AI@ùJ(jQRZhNy@VVRY\nHZ\r\\(H˨g]T[(xNLt4U-S\"\0!0Sg[Q)mLZ hk?	J7OrNܤĉ))eK D:@MQKd#.t5da1(\\TjXS\r`ˣ\\=~ш4MVPVpoJLW]D/2N)\r׈\0UA\"5E/*L/r甪&CP0\0+LhNxxCi6	m^eZ;\0\0» (82B]`!H|fޱ0cL9TZ՚ϖe3t391t.t4!w4\r<LNAfJO8 XP*gzE\\(| =}\rpEtU;9\".~o7aWeos*9\rr&w\nI\n<rQ^P*wiZp	bٔOSNNn2w@PPG]_+e=CBY:7C\\agoC(ŔCtn\\.Xjl\r=[t~KD\n\\io=iCr FUUL&&ߊDw:\0Aa OZiMb<Mҙi<ȡ fĒ	lpumȖCnnN/yϠqS)̘/Zz*7Hsy#zLe(c@e=π\"0LҼGN'{_H,lBG_@aiA4dHv#B8o*\n\nB0S\$^OlP<\0ZL\n\0H7d \"z58ĭ2Bc)5HB(MC@R#L@JFK0k9 ;gnC#p&ВD|+&&ЎBDP@hTm(0׉	~äF\nprB[B&wnCF6DbKC\"@g4&YcpPб44`\n((~\"wz/Pxj\r&|tRHHU(zQU\r,	~|oXpUT'?0\rqbP\ngA%0Q1#ܿG\n\006\rB(d1[pOtEg ДD1 R! R'- #1#ojLLC,Mf%%%\nNJQj2pâkD,Ntd@%jI'h8B\\!Z%\"%8pdY,v?%RI,\$)G@ED k9'd%G-bfn5@f^03c\rDFZ2bl\n&W3<f%s0+BDP泓XH6ez`6.Im8[HkZc8s\rXŤ\05AlpX,nY\"P03\$(q2sA=s(Q@֕eI#=VH?@M@sf M+E42\"hl͹2WBC3#(1e6\rt.43%?sMC\r4ENÆ&d{(C(sBFt(/s6,;\n;I_>cr6_DP\n鴜{Ը'Ξ 7sk@~*ԓCt4t4J3sTMq:H [-=#}rLf63HBS!:#!ꨏ\$-Rh4%C3brFӃe1Rkͩ!oU!ȇ72Pg;VoyTL@`*?Fuj\$)ú),1,B.\$6)B/82\nZmVYG,~o0m\r,]UC-5y^Ng@\$#L@#&O8pIY\$\n@5\$Yptd.;uh?rCYX5d;>?	@#tP;N({\n\r&1zP1 L%g#6h֟}V/֠R\\r^g}4;1tpH[6t~^1Y\\\n`Rj(6\$pfR\rG- ,=Px-l0p-\\'\$C:MAuѶ\rU+J>RlP36khr@8LbB_CTf̉|@%";break;case"pt":$g="T2Dr:OF(J.0Q97js9էc)@e7&2f4SI.&	6'I2dfsXl@%9jTl 7E&Z!8h5\rQz4Fi7MZԞ	&))8&̆X\n\$py1~4נ\"^&aV#'ٞ2Hd0vfβK\$Syx`\\[\rOZxN-&gM[<7ES<n5stIܰl0)\rT:\"m<#0;\"p(.\0C#&/K\$aR`@5(L4cȚ)ҏ6Q`7\r*Cd8\$jCCjPr!/\n\nN㌯%ln1/=m̷:%D꧶PDÚ'c2\"Kh\0A;q!<:U%\"#HLRHQ\"ҳ&+< D# ڼ @?P`.`1΁lHH蟎\"B430z\r8a^H]Vr.8^%jxD3:/29hx!p)(AU5NSbZ#1,[%Js,tX6'\r3.+\03(CY|؁B6th-.,1s69\"6Av/~66E(j4 x8cf\\{Fb9\r[)vg@.B،[pؓYMz&\rjx7)\0(SC;[G,m(vVOB~r\"Q%Iwh4(	#l8(VL(e>(\"OOLc(l3Fҥ83]N\0r](ɒy@' \rs͌8d⁁3A]D2\nX\\/&psX̛N~\r%ycUA^2I\\LV\\ksղ@+y^REry;	0˕MQa[=\r!^ye BŦЩ~u-\\t.r^K@sW{!׵`A|	9ggZYtrP	A6P\"IV<xlZ5ϳ:I0h\$Z՞n9I>JrV%2Nq(\r\"I+PPP	AplAP\$#@\${7tֆ^ΡX&ޫԀb4 8-%ټ&Rl.}Fr\0007RЁ7M%G(6Kr'rpB@Ws#_1H@!ZqD5>DɤA	2Py3!l@R1?\\R@'0jy<PNt)X K:\\o;AՐb촩07dE`)Rz\$oF 1gT@`;	;(m ]pr\$rHl5?h\n	8PTj@-S3NfYe@@1E':%'܌[k/\$1fQ\n3e{%bSUB89emO9M*ha'9IOay1n11|G+;(5\n\0P\n\$3/9!2@IrxGL<(:aPJQnZ!Ѿуbk:pLEKBE*ڈHdIta6H0&(^;%A;s3HYͯaPLZ#dhVuv\rE妌{sG(!tIcaSPЀ	.6zԃ)I짂5D+MÝ`f7|xb䲧\$\\ 5)ڝS@@ o?گÃۢGidG-8oh|dswS+9hƕ a1\\Z4EdXS	/ղ+80&eN*K	A\\XM9jWcQOqNcM^3d;I&NQ)g_ToR*M[D;]PBeܷcd;PğHx糔}S1MsbYDi%\01uknb|hs\0A8f(1|Ntz\r'|)0\0Y6b/rY5BW/7etAF/B0!6	B[fT8te:E4A^w਎:\$_^\n:#\r`(>c:?DLj)\06OcDOk\0}>Zrlt~7'㌊&!N&03(iBPf:o.R|^+dCiĤ.P9n/ҖrĜb6o[o&@ O-^&L9b2߯*[%ֹDrGP,OG P	.0&Q91	%B0Co+2T(a+FБbwsr2\"Dmg:(-|,V2(ᣌʲ(|/B:jk1j1nf+/b}gCF&d<SfC%~O*oF%qHS R	1F!R1MP%'\"0%b),TA1vi9ւ\$h\0ׂ[P3%&*pio'h'\"i]GvO2E2^IQBq*\$)L	\r\rG.\"-zq8Ƃhf#/-1\$\n-Fp,!v?I>0Bh%3por޸EGF\rVo@\$AHhE#1J\$  Zp\$Xt@C04\nZNjo`fSn.q6άɴ)8GjŲ \$ll8ҰK.*p/HXFv_ǡ\0;ratlXficPVer.v.0XC^6M\\жkp|TVt4wA\r9o2,c\n'6&Nz\"D\0O~OçrKSp^ì#%:-\"~o\$BT@h/28̐.lsFS?eVcZ,F\$-zh9tr2\"&Q=!\0004R29@@";break;case"pt-br":$g="V7jm̧(1?	E30\n'0f\rR 8g6e6㱤rG%oihXj2LSIp6NLv>%9\$\\n 7FZ)\r9h5\rQz4Fi7M&)A9\"*RQ\$sNXHfF[\"MQ'Sfs!\r4g฽䧂fLo7TY|%7RA\\iA_fDIA\$QT*fyܕM8䜈;Kn؎v9Ȝ@35z7ȃ2k\nںR43Ґ 30\nD%\r:kCj=p3C!0J\nC,|+/╪r\00e;\nت0#>;b%sA=CSNk.tR+\nhZZoPNVJDI*J.\"26&\rI4P2*5za7#0hRFIT(	\$p2\0yc\r\rC@:tT5/8^'ixD;F2nx!t3@P<nìY\r5L%\"7cXMpޯ˭+ʽ\nx\"# @1(0Ycx:)vgs-/Lâ8 Ϛk8\".(#hlTLN1̢h&X@6 ,'s7im4J'I|S,N;6?\rK167Z*|b1onOG>3纾wc(mɰ6#\$(\"7%ɇ.ƁVOPa wOaL2͵Mb^\r090'Cz1.V	auRx3s`2V82\n_%7Фrd9\nLVk9-VeʣvZm-ż\\t+C\0j\r>6\n,*µPCvQ.42cBXECFֲ؆uoƹW: _@8V7	8:dӁ=\rgx\$EZOA7e߬c1[b6L̙IA,[ZdC4i\nX\\8xA.\r<Ќ:aM%L2(\$(`̌̐s\$%rCrgH3@lYfJ%t\\KҬCq'\n_\r~8!4I;ɭW\$C\naH#/(S\nR9-ZH61Xutv%iF<!\"`(.d!nL\n\"V(*MZ\$*0pMn\rr\n?፼\"	pg@'0R'PΕNe	t2RLNqfEVS.6\\E)|d(oT6>SWBc`7z2pYr\$\rΚN1>QTW+&O	*\0BEow,\"PnLkɦ3\na)y݊/A<86ЬKa0\$8!,)Ga̝,\n}~Y!<Qڝ{!\n x%\$5V-q>\$0<wxr.K5?%\0KIC\$}b[KE,V\"EJ=XDپV\0RUpu\"t:̇=v|s'f06Cұh95<FmBB̘,Xe(+rVb4%Ы	O[0CD:%|Cy߱pظT9{֣!`((	0t[\rg\r%`\rK/RNtRa`fT!\$_P[響_P7ȀH9fpyi捕vn̷\"4\$}a:ΊWqML1\r^K&1FzniJB2k)Ŀ!K߅OS[XU\0ɿ8k*,qbDSWŹ(TӇr/!\$&ey2+e5s*9^D0\"B8xT|VH^w(=N.L\nL&' cA!g`@}U%C@O|߆dK~>y}VS_9+ AoCF]T_M,zE^\r^A6iÄ\"jA־S_ϳrzqZ:ЉZ_13怱A@\$Lgf,4H24cI6A/f\0xL00OjN*ͥ\0p\nFdʕP>xBP8(G3`c\0.\"4O4/&ߐj׎^Ptޯ.,#C`ӫ\0o	8->\0m+\0аp\nP'0O0.Ob%cGiD*b Z|cD#Z\"TT[\r1C98.F\nB/dx/F2DˌLϬu:1\\0*f3P<؂`c~jpHq7I)a̀sG2l sVB8ɩ\nK%\$uK͵opo\nw*&@uŃ\$ih,2Vkoq\"/\"&\r+Qm\02IU#Yr@5\$r;п\nS\$!1&1*t1O'1TvBCG(T3\0?D/Iī'*F\$)(F7* Ԇ&&,\0 0/2=rRIRHe+Br	\rf:>iKłG4VŰJ*nof#b7#0o2*CCЖS!4.)5:<j\r&\"E#\"nc ZosG2\r>A`\nq2M>.f5&##:#Ϯ)%#0òƱbJѨK`0>ʇ#:&( dC7QDOȯUB=-X(eTAtc\"nq-\$rq=1 hDDqAO!Ncj7\r6jEDTNsEMFZ51\r*b\$.DpϜD>Meo\"THoq+\00003LG\"/j^D#G>υDot6#Nc376TP23~&%JLQ-Vg>k@/%E&MLCJnJ1.J/";break;case"ro":$g="S:VBl 9LSBQp	@p:\$\"cfLL#>eL1p(/iiLI@-	Nde9%	@nh|X\nFC1l7AFsyo9B&\rن7F԰82`uZ:LFSazE2`xHx(n9̹gIf;=,foNƜ :nN,h2YYN;΁ Af2r'-K !{:<ٸ\nd& g-(0`PތP7\rcp;)'#-@2\r1À+C*9Ȟ˨ބ:/a62āJE\nℛ,JhP#JhV9#JA(0\r,+ѡ9P\"ڐ./q) #x2l1	C0LK0q6%3̎A*k*A2sNTwP!.枿\n)('I(CBn P0C:&\r<n	7Ti/㒵*#&û446W?ģX4<0z\r8a^H\\)/8_PzxDj/c2x!BJC: ʔ@`{2%S8<իgӞ:&6&R5q;(9c%=HK\rlZqP73?hkR̮QHΈ(F\r쾎~Xͽ)1ţLJsɴ!\rCsDռ\\k^?` #:Ѹj:ʴZ2jiQWB<(<\\sc9ӞV%pnXYX\"GY3Ƣ:.tr1=7<\\=?=ZS(zk4#	2lHS3ŲOBI&.L*p24r0Pb>@³1le0PIUE)`@8c\\*DS^3\0r;hÕ~_VC0|db'e1'rBH\n>]%8\$|Mg\\;xRafdBzP^l]#._+~Ŷ3aL1l:=;ieS@q5BZeqᬣC'^l%`w\rɓpS^!IV!4(Fws5RÝ2:UY\nFы6îC7-b(*P巆5A7!ݠFJq[y2)84DU87B\$w9v`30ГІFRTVCI@4N'KLRG%j.>j9%ľh\$Ԑ\rEEiky6H\\4h\\9'\"ZOaj\nP9(HCQC\n<)J<h*LH9E EbQL:	6dDZ_\\ψ!P	Å%)t[G&`偩ˊb	r'l==ÒGmH\"Ӹ,c9)PK	7Mho`o.8'smv:3Z03z@PM(B-\$~*|јd,(H@l+WTJŵLF%(7W4\nivkx\0v\ne@IM>#Wip(Cr\"~0~3?jbv\"Vr@H,К;VZrS>c>aqY5Q!2Z6a\nL3mLۗQ~\0(07l\nV:D9-5:mڲ3hdIΤ`&E|\nKBT!\$<La6qp\"\nN۩\r[WA\0/b:ؚj&Kr|C>EY	zKɉ(£MW#Jɞ,r{@q7N9L@nuW6꼜ҔA`)ŗUq7KCiV8S6>3Йj4PѼ7suAMLkfbԀ rÉ2b0^bd8VKm0Wxt<:8UkEx0;nu[k\n3X?n+G1J5)CGύH-e\\?6f&	ci1%on]/dA*B\$E(k\$T\0X40'WĨ&J/̚JPKB2M&-K ihG/ǄnTG],t	Lpv|o{jOĭ<fч\nh\nµ	.jo+P	DZ#*: i,dɂD宀fȾ0筶Af5059h2ʸ\"M:nr`\"?pRp3\r1)\rZ+Ɏ\"8(*>MDK hX<\\c,c_\\\rc;(D-P&qT [,%J(X{JmxR3B>qh&u*3p>Q@{gG&e@ub0~Ǐ~2!BDP!!-!)G*Y<\"bFP*l:@aDE,'d:b@yG&\n<&o2ҏdNp)\$N|(@mD&\$Q/'AW\r Aw(-\"{-T. g/I.!7.r)P:s!,3-/72w2.Ϻ6\$4\rnF4/\rr5\n{!X!S]\")r?6mHrm6m55lK\$R DKLs^;9u:mp'9Ӣs|	*{m)3ZJ3Ǟ@ca܆rUpC!=HS?(,|hRZid/~e+7΂l3.f4!\rV\rq7`/ Bh](?)dG ډbb\nZt\$>ΨkFnH\rHN\":#B\$hbS~ǈO~C3G.L#1b]BΊfH#3:\$#u-У3XFc8YkEzBjMł1F+qL.PAQLlQ*Ե'B RU!bϾ26l2e@SM\0Dљ  BRqo.(U13NmdY	WԸ3msI;#DGf,2di<䌢@UjhP/.EF:uJ	CW\"8p#\$g]Jm(: ޼`/--022R:#9	\0t	@\n`";break;case"ru":$g="I4Qb\rh-Z(KA{ᙘ@s4\$hX4mEFyAg\nQBKW2)RA@apz\0]NKWRiAy-]!&	pCE#yl\n@N'R)\0	Nd*;AEJKF\$V&'AA0@\nFC1l7c+&\"IIз>ĹK,qϴ.u9꠆L,&NsDMe!_ZG*r;i9Xpd'ˌ6ky}V\nPػN3\0\$,:)f(nB>\$e\nmz!0<=S<lP*Ei䦖;(P1WjtEk!S<9DzT\nkX]\$ٶj4y>N:D.1ܧ\r=T>+h<F.\"]-1d\nþ\\,3:Mbd5N(+2JUC%G#\nT,`#HkΖŵJLjm})TʣU%cĻ7\$qN\0P4c6\r@2׵}_\09#x9Bv\r9\0Gj\nu2N\$=\\R2OճuƌnT6HhԿ2O9r0wdVr# 4-1d?3S\r\$Bb_EV۹A\rc[ЌG\0x0@2D49Ax^;påip]~~\09K}e>zr{C)x!Ȳ<}c-mkDb0&K<cZge_G&B!3%۴C M͑3 ֻj}?GԪ_o}lKQ\n즗4^J{!䡨2\$S)̡bv(	+\n]D.XRłu:)V*&9\"6W\\!1'-EB4 A/xEѭ6V^XhiG9Jy( (\$xRBE#\$> kyy)h`z^LJF{9zGEB`-{+]JbJ[i #DJˁj%?D ٙ-fBǙ!y4gq_;Ҕ!I8zaY R%/i_hEbEJztdV4]Fd<\rzZP\$XRvM2l@:\$mbUhГ*)R?qYLeL\rERv2'^ĩ*vԑz)H4[CntaK?nt耶KyV)M=\nk}2	*Dtt4JOaE!%Js-:HxQƘUDSyJ\r\nb9q4Ӊ@+mAiL4-Z*%ʹU^@ i--&ڑ9Ad؆\\BC9Xnۋsnݼ8#!цDBgNTꟑ1x\"FvAtk:QsrqODkPbU W\rɺ7fޛ~p8JÓqaJ8ptTM\\E_<ՀR!NBdUI\\H)p1(8%#a.)q֚(#ja#ޱܦɰ5B\nP\"%JOsiǑt,S`ڈD\n굋qyOf&]qPE0\nK#xh5^NM3t:yb.\\R,I{53Quo>&H~h!V\rsGdӂCS͵@dR%IZ)G>P*FyBFLv{QrC֥nġO#քxT(\";XRFD1E3BlcNXP٫=;enW\$6!9r\"GsڝW6r\n\"*M\0TM0Tf\r-eM(rȄU*LthLays4h'zU\$)F(\0p.ţ]m1vhqo#Dy\0F\nA]veC\$i!x:ޕw\nΙيӠgSdpaJ{UjȟbI>Ez ֐rg\rH5y*L[mߌ*2cm\nB<#7jL(-8B7#;s|\${Mme|6T[O%HI}<%N~&M;,N{rJt&('hfEm&p-xJBF\$L	\0׈&\$osiѣP><s\n^E2k>!\0O\$9(.'5&&ǸuLy/*	\0I#c[M#DLΦC䖯dۈ\"xg(8GV{TGgHG,ʋbfy˭BxNC<\$)4h'zXg\\ʈ/Dx~C-nk0[\n)X6	/gQ@j#!JF*8B)8'rn~TΠnZpKPs%V9%\\e@\n 	-U̦L҉@& .xĮKw| \"G}*/-~OCbf2#(.;Ǎº+z\0n0\nw 2!!n>N~r,baq#\"[##P˱!Ĭ+%eh\r\\:*tP%ԛ-&(o!#Vrb;,j\$!(6(#)iR򨖬2sc*rM%qC҅)\\O(Q ʿ(p{cR4Bb%=Fc [/%/-/\"!NF+\n7/0QR\r0\n0Rn.1!vgpmP^J(y\"dJls@dUgÄϞ0a#4\$RǎJ#O{o2:S:3-\r3K0'K/\"&.pΔ=B&<<{=do[26D0H\reHzTd<^Bw	px\"0zKIZ@bdtٴ\0Pez&HSЧPAoibE2ͤ4/WE/ZF`vQb5J\"oK=\$+g.Dnb紸)LM2gGT(<s)4\0@֥)<tE;Pd\"/+N,Dg3<5/\$*#Nr\$\nwR(UO-S!aSr;r¬1UAQ%Tu>1U&0\0005sSJ2VsT2gnYX!:!\rYHyZ5fRYY)ZZF&h%\\&-O`ӄ\$CxzHtˀhj&%C5BJ)\nt+mn\rK,/^,0D\\uYzlh%`/P)~q	\0o}DRy/?W5ԸU\$uofx;/Qhs	0isEuOUQXk8?O0-v[[Yvm֛mҗ[m>D6ltI#WTS΢!A\rqB|ymۦ}!@N,6{RV@uO	)sUXYtj\$R?QWtVMVMu'6ks-9W0&	-poC WFWA׉t'tgSH&0dCO_EAV*.UmSzOBJWǏ]]-}B~ga|weUKkW[֋u)x) &Ej箹|\r}Wkd8)7уTJb66#={w6/vO}q*.(Zc=,11VI\\\"1Co6aGXeXkz3x 07py9ՇF[X~S]*x+8.K\\s}ivUHW1:4T=&5#p\05qJ5^JÒw\$9\$y3ral~y>\$<.~9B*9=	W8>)UNE?ewrNY/Y9'%a-di\rVRօ|bsABeB72\0HYm2Q6>V^6`@\n`qw.tEGkC:y@ť *v1t/z! 	K1S%,bOcAk(7ϕGChř~-Ẽj.%PdcOBT\0A~yE9&Q(Db4	:xdѤuEfgk8:!7\$Sk`hS>tue`E<AMKeKɛ2RIGfPvh+:d6/Ӱ:Q:=jRY\nm[\ruViO'j~rtEZGOFvr+w_b!dDKڷ.p y9l+/[.hɹs.GؚW8/ueN7gHvxt%\n}睊L9{(%''ۀ0x,CD89CT{	77@";break;case"sk":$g="N0FP%(](a@n2\rC	l7&P\rhl25rxdB\$r:\rFQ\0B18-9H0cAn8)D&sLb\nbM&}0a1g̤k02pQZ@_bԷ0 _0ɾh\rY83Nbp/ƃNbaaWwM\r+o;ICv\0!F\"<lbXjv&g0<zn59\"iH0{TףC8@ØH\0oڞ>dz=\n1H5*j+P2`2I5eKX<b6 P+P,@P)`2h:3 Pʃu%4D999\0F!j\nbC\"Z\rØ7)H&cl)*̒6z9B=!\"|_BCTJ#\0ʰ;&9ʢ䍒HA:%7EP2\rA0[Gp'OQI\r;hVCH43Ň\n,0z\r8a^\\Y\"c8^vxDj&.2&|dZīKc̓:\"\nC5Y\n\"44'n\rsM*n(\\CPZ::Ƨ:2`P&B\\Ҝ\rH h@\$c˜0d`J8d`:܀ ox_/P5xޟ/6E#\$J8.b]sJ+!{e\rsܫōcYA0p&Xka[K#g7ՠ(fPZ-L=g4S.KUۥYR\r'	Z`;#D\$C>o蜶`+J+'zU̘V!)\$tb%!<2+ o\$'7@c[A38@H^	K -eP\n)pbtZ(bؐe\\u%!PVƈu[yeSb\r.t/ @_K0sa,,7Lb@?CQ5JIJ\"xNa^\\5xJќRJaY[^+ͽG`!݁\na<Ø>7*j\\lB?бHǞK{')^ڠygG ALOR.Wz\ncgQ5500qW*5@Kp/aB_L<',KZîeb(#At/NTLVSAN@(!B0ݙ\$jZ5f-zú%,Т?Gsa;JRC:<8IJo٠S\nAHu)7'C	)DlG>#g0eMq\\OJZI㮡ha<P)Ĥ\$gk05Qqpdd\0,y1@\"5(iBOZHIA@'0E	l׫_	8\"RnF֙IEASbUoL!FxbsMZ|O'\0F\n@KBA4~HC='Oȅ-DLcEPO	*\0BE8\"PqJn- 6FƈP̢JEӳJYϋē;x#ȆS\"t7Jޖ:'-Ƌ]iM@\nER@KBnT0d+9srl{<CsS޶Pg	ͱ)BPF@'QTS\$)xbS \"\nBC@#*qN.!I3'Z|j~^D\0002uJܻ>fUsM·\0jrQxL=R./ȍmDx35*Ym#o0ƌ1zVMx\nm,e}YN\nr1Ԭʠ8h:TVPT\n!AljRh>frAژ/+d̠׌0#Ć̛1It;謄zPu^I>s{d\0gSvŀO\\{:[TɅ+E\"M\$ܐKJ{cЇ e߷hPUkB^J<NSZ	ݖ-fYGxONLhxcY9\0r@	'(M|t\re|4Mg*sRąlT:\$d?Ui!`\$h/)΢eTϢN	a4dFN0JMb\"θ; =b.4ĨԢ;paQp'vBmh۰0\"6mPۂn\"\r0gd@`'R(\"~HP](OZd\0b  G:ÖnPLIh#pZIܨ\\I6g	(I*\nlllƦ\0vPf0v~G30 pxqNV1\rFp}qoِyL},zQQҲ4Cn.k)610j.ζBOpGtBK|JeQwm.	ofQb-0CqޡZE1]C\0\rFIB,q!,jlIRB,=bfI6&F&f!}#!nЌ\"j^^.[>XQt2*,F²O\"Oq-Uf'FX&P+2 m\r&QMTҷ 15 ndZ}0zや(G+N6;9pG1+.}.k F/<r(c&|E010@m(E	bLu	mdTBu:Doα+4[3Q6,sM8jqhvrf7s7C-	1QhJl/?#B\rbzEi.-p\nd_;'up+<'36.|%w<39S9=3h\n5kq7,mꀤ\r.m++WYTߴ-@R->9tt4TK.U-'!CZb+4oEOGR,]F4RӜLN\$_3ŴLfE)43hn]JTLol	b@k\$~\rT\0JOK0,2\$_B9	'M,\"M`ք#*!Z8^f\"e:D~Dt\r(n\$&AȤlH\np?V#cΰK&Q/JXBTUST\$5jl/=Qq2)).#\nF#>(&	PĜ\nVFI_\0&p)#djC	֊\\nE0P@Ʀb~\$]<Β#DDN;_nXk&~Ǹ/pv,qV0p('6;i'V4zrPc\$3`([w-u2evT:FA.hiȩYT5tUO@@~Us@&pj\ndTM9#~1̢,˕x#&Cm249<6S<G*\nxƧoK	\0@	t\n`";break;case"sl":$g="S:Dib#L&H%(6l7WƓ@d0\rY]0XI \r&y'̲%9JnnS鉆^ #!j6 !n7F9<lI/*LQZvccMQ3g#N\0e3Nb	Pp@sNnbf.Pl5MBz67Qfn_T9n3'Q(p]/SqwNG(.St0FC~k#?9)9ȗ`4c<Mʨ2\$R%Jp@*^;1!ֹ\r#b,0J`:B0H`&#x2!\"l;*1ѫJ26|㔽0[Tk^Ҡ.\"`<1@2P@IAѤ\n4i3\nhԏ2tc#\$Lϣ?4#9p&H41u\"#X2D49Ax^;فsmMAr43x^UJ@|8̍\rH6x% p薁B5)L=h1-\"2m3#૒-\"ptԘ\nU\",(1&#\0ԹxB49.CP8!B\\c-&<	2Z6'H:wsԾë1є2C:N\rj0'N%F4K#l8&A	\$h\"\reJ%iz63(1nފb89v6@=`8g:\r\"*Mt'Kr;\r+D@a˭b]FKZ|13Ҡ%Pb\\pMcLc6\$lIIMP90#(ɸul^q3k3@#H(1S21`5JY<-Cp/>xոZUKulQH%\nOP@oAG%C\$: \$&\0@I\\ ҿc,SP9- eM(=6BI\r˰P\rgIaZ!C:J!\$ ga&ȣM\$\$(7v#St1Ӑ;%'\$(C4O\"SM0\0c/L4K7С,TzBʟbr*AH\$t)Gpny/iIgH93e36iOp;4zg,yhqÃVf)sHrQO\0Q.NdZrS\nA+cn	!= @xk5#diFA!YQd<H|0Dɡ\ndv0b8iBi-P\0{2@#?e4N\"CP(\"Z|!LE43ILjM~6)MD6!h,eXK` r!2SB`	F\n\\D~)\"gT\$VpiJ慍CxTpnr88å.fi!O\$RPn򆝇(6O1&҅K'pcԣĘZ cÕAzIRJ@s'	ndzf	@\0enRg`dhro)xr	t8'2fPZ&ťFe#Ps9˳5 ,(-`KDTn\$2R3B\0002u%XI|	s\r{6E\nt59n13[CrB\\ڦ7˾E&\rzBanOgN>	˙sArOxpEwVKMF)+ϧT!\$\nϳҞ'8ZL'5_ /+gvi%k@ ˵6v_س=pge=lhxFͪaʰ	^mȺz@%YٹFteQ\rev\rn	wܛ0N/'p{qnNvȌW4G'{p>@nGp?]FߜXsvI'>s^\$E\"?8Mz{>2MzOav?=܊?(lD;wJkIfZ	y{<SJOf\\:91;1&\"Lh{.f#kK_Ks\$G^ԬMaPE/jʸ7V,O=BeKR6v/Hc@YW1os72rWl4\$ITۋ4F\n{^!ևN_ܒ;#w\n-`@\n\0ҀZ8F\0ohi>\$b<\"`;QP!|0HPH!lE~Hm/Vy\r5LUuTBt'G9	'<\r@fvLNR͜0 PU	CdTP\"0\n-\r\$\rp0sݰHό\0Q7q!0r0lw\$hkq\rkf<#fqL0Ⰳd\$*b&K[6rΎPfk6AeŀtP\"1-Q&Ƈa7q,a	.NBMpRa0Dwǀ^1Ԅ&(q\$Q)oͱqoKATO/ b\"2OlhXg.fϔf@1s\$^Я!OE%PPQ&	&M1\$ket,*&)2~\rf\rO50(.wp\0&`qU*Ұ(r됓'\rrA+({-\n'R2w\"8g.1l%bv`Ⱦkw/0 !\$s'\r!.3 ;us=2G;]1)BsBD#&qOZO0S5L'6\"&а/dNR9q\0 TgSRؙcTÌ{;#5\rGnQS3F&%MtΠ\$7f=9w=i&2-	.s?B?hQ\$\"?*sD\rV~b^<xh\nZ+\$&:w?\rFQ'nD4tmdF#4`:\"@ҖmGC<dN#|hN%- OC#%\r,\\=MUFb6,r6ÂF.,,0ϪKK\$Pn2aDQP'3Q3c2-B\$U*xI9&&d/\0̀\n'.fl'Up,I-@+ TG\0	TG=\"Zf⽫^-B5\08T&*ΫڐdC&,v3#&Ϊ@2+'m]\r#v?+p";break;case"sr":$g="J44P-Ak	@6\rh/`P\\33`hEC\\fLJⰦe_DehRƂhQ	jQ*1a1CV9%9P	u6ccUP/ABPb2as\$_TI0.\"uZH-0ՃAcYXZ5V\$Q4Yiqc9m:MQv2\ri;MS9 :q!:\r<˵ɫxbx>DqM|];ٴRTRҔ=q0!/kV֠N)\nS)H3<Ӛƨ2EH2	׊pp@2C9(B##2\rs78Frcf2-d⚓EDN+1\"&,n kBր4 ;XM`&	pIu2Qȧsֲ>k%;+\ryHSI6!,,Rնƌ#LqNSFl\$d@0\ne3jڱn-g`v<:p4r֥J{j#/AJ*σT\$R&ˋ`Ϊ\n.LBHOTS6QAG9r(@0cgxQ˂;.w .,%C X(90z\r8a^\\0Lix78\$axDlfC4f6ր|1?nSښ?ƅ4@\",W\"*TkFp\\6r3h(@`p0Ct\$3a(Ȃ3:2%5ʲI>};V̶H'ixZ¾Dv/@# :qHS;?J5JLc²J	I?AǮL'puSϧ-NZoOf4^_G?I5JcXCK1mBbSI.'XJUDSnN2oNyxTף]@QއSҡ 2TDatlɴòLd[1f%h4؜0\$et[^D6y`<0nMf3`KXKj@qn :Xfx@6΄+IP .uu@s%|k]0۔ oQjJ14F1S-73Fl<ge40Z8/G:5YBmqH<5F8|ap\$jXQQט)2^if	12٫7g,힇v~Cr04Vzi@\$rkG,LY: I5EBy\"Pvݐ O7Ch8,Rr@`la0鋗!\$)0b}2t*\"4:'LKe!q|ezĺ)ST2!A\0P	Be\\SW.ո=/JCZ41V3N19G02t;hVYF\rPPشEe+3Ke\\;)iֱ\n:-eDBS\nA&\0\\AYvo,WRʑ	UK\$@y5aH\n*CY턈Ti<%\nV%iBdd\r.]&Nf4m\\\\:#SPQd'0d3I9b\$C%(Xf[+Ae\n*AD6(F^\\t@cA?C5%`gnrᦗ1&B1oH9hz_S	LyP(^BxNT(@( aj<6T`\n@V\"5ּ|J	qbȋ [\"1/6m%ojnW\n_MG\"L	/-+D`V9ԇhJ}D#,5pdXҶ_r6UKg]<>X\\CkMzlj.Eo&u(ӎr./b\$vF	Ӫώ`U5r\$ź:sD\nSjiIj`076{r\"]Mꥠ	Lkb\n\na=<UK{\nakCj:;`CcgĶgʃda`d?}r\$2uRofӁ=p0zxҐSq3Pbޯ̈j,\"u9O&IzwW	̺+\nyӆCDe@@L~w?b	VFv2v[۶P 01G@ n:~'C#.AdGC+h|qG50b'il)	r)FS**VsC*\\(nl).0V-34&PhT0pn(y6TYcb\n0j(PP̷	B-m	\$-\rD\rk	E0\n0\r\"i'P	B\\(`	(dF\$,芈PME)Aom%+-<.@΢wE&->N&Ab[hmOTn{HQ\rͤM|\0C,\0m'OMPC,uG(@0LCpq	?(.1sep瘟pq_F1\n.M #!Q䁢dc]dE5\nP3D\$D쩠d\nl#\\D(L'#V\$m!%&'2̆?LOoDQeNᢖk&=>M(Δ3\r^OrKԍn2&dT2f*й-n<)r806Ȧ\n&+*Љ12&#-s91(1-2kIqM5R3\">P1o~	F6M6V7aS\rW3{s~hX{8p1\n</|/Ԣ,.#3UH\$9<1-F3\nD(R1H2m*r.3>14QbelC3\0Iu@gts+r'@`%1od`%ꃂ*-'䲂ک!b?Q=>3=ohDpH_*jpoL12#YQ(tS3.OIJ#i>KC܎\$QI4|PZ<<tަgIsM2S-H%KS?1)hWL`۴NDo?q1k&#ʦ>QIt#HS4TS+7KsTF~ԇIn`s=VCz4'~1Ht(d?\"A~VHLLA[0fuK)KNUruS]]r!+T<U>W6aN;OppEZj5(_Z	o[Q^\\χaV#Ut<8c),@HUX4c\$I)gSL\\]uaJIf-bSJĩgC_ScBHA>T56>T7ïQVQ וp|<'jp\rk3sQucl\$T\$\$QfmМrmP q/(\"_+^Lm:-p1mpM`ng4=5`\"RI`b\r˺Mf\npXD'\rJVvkk\\Ө<֮w\$2KFJJTF 	@/%4C<fLvCTqL)+pћl&0ns1}YF1I(\"|oj,eTbnNAv3mgjJ'P׈4ςT{R\nVg\".5r)6h11R3C;u'.ppG@HIQ%G%,~ݘTZOҽM30CV0@bi1O*̔hkS[&QK{=N@Y6\"'@C81cK/\r<:VQoys&VB";break;case"sv":$g="BCR̧!(J.! 3԰#IeLADd0i6MQ!3Β:3ybkB BS\nhFLqAd3\rFqt7ATSI:a6&<b2&')Hd7#qu]D).hD1ˤr46\\o0\"򳄢?ԍzM\nggfuRh<#mw\r7B'[m0\n*JL[N^4kMhA\n's5Nu)ɝH'o2&60#rB\"0ʚ~R<9(A02^7*Z0nH9<<P9Bp6mv֍/8Cb*ҋ3B6'R:608܎-\"340j/+\r\"\"5*+;13&\r*#))ʵ\nh\\S&\rt(O*((!cl@\"+6⟔:\$\r\n/c`ǋ4ϊY	-?p@%#C3t㽤\$U (8^9^)0-4px!\rRBc:\05`c#PL/\0CC>42`P7TKdKLjb\rf3ʐDM@3QV2E#|ރP#u4ݱ:8E\nikgC(!>j<zd(茔:b9q)\"`Z5Y߄bA	%5#mo-\rST{\\rG/Kb:H8k.@<uf)+^Ԑ!9<ޠT\nN܌4	ke(HB3>\r+O51/W*N&3Ű䃖D\n܍IkVap|ާT<Xr|ϾԝP1i}`7+3E)AT\0v|DP*R A\$%gUrXdVzZkV岶p/1x&@B2DG	C낪U Rhv|ESW+=#L4YK1g-֤\$P9-U+rLYY10&no\$2lhEM-r<l!d':E*~5\nRh[yJ>#H`p1.Ҥ\"{},IH\n4U4e|11S6p\\R5 (fNQl\n()%N)\$+fըl\\̙`'dPmb.KҰ\$Ƹ}ãt( &!`҈ aL)iQ34{'Jxrr l!X))\"A1FBuCSW#fDƁ3R\n<@)B*YƓY	B!\n<)@ZP1D@Hx\$]7#V-sty䘑I#3oϣ4JB0T\n溷[bugAfRc(O!ia|P\n @HN T!']**('^9ά\"&\"S\\z|G^*('m\r+<K/q0.9>Ьj'ec|B%گ|\rO@M|0]9`1آtSvo\$[IIie7SBv]0\nvB[ba\\>\n-]йrhM\r.	Bv>Ha^mdKГ\0F	9ߊB-޷pkâ&	ReM|\0Ueh@PRVpTG.iBV׮ma\"Y\n->XEk\rc\\A`dcde\$\$7L\\\r筶wk@G14Ēk'bIã~yMFolo}q6 &,yfFمΒX04r@+k޶[5rT?[Jo筧MG,&}BLG7rFJAHA\nlM/@b1ɼgo͓LqNL4^/Z(ԭ6(C}81bl!@ɓۄrW|Ew\"~k@n=66~ĂLgW񭡔^fCjǪ\\yOl/ PTκEwc89]z\rڷb7vSdޜ)ӪtJkǢ#[\\:)tpv<no _\\[tۍH4\n]0s]o_Ưz8nꯒ\rZnb@PC\$b	BEȡ[ظ.!d*9<=esT\0Ђ!LHaϒ돆EdæԭN\"ݍLSBRÏLn9%dHF&@k~/WLG\r\r,o	/#쎯ogVhƟcP2B àh'i\r1(b`&mA)E\0\nnq0QYrB\r4>q|d Eδ|QИdZݐ5Q5\r8-M1\$1AQ%1M\"kGSPND3B.&NPA1R\0./ \r!rCh>C\$<;\nU\$c>͖`%3%xJ-v&:m1 .r߉b2a\"r=?!&D``@m0<@hbRL*#V5\0ҹ\0p>h\r+\\vQs%mΛ.J0RhUNh'lMn\n8v9 <=1dV#ʦ)G+0/.%	  Es3f,\ndz0h'Bj/\"R8JHN)\"\"A\0E&_/Vvbp\0ra7C[p8̍@ފ/7FJ+D`	(RKB <D8)3D!P=F(GBc/êkQ6x'AkW RT\0S9sJn?1XG|A0eAD'Z";break;case"ta":$g="W* iF\\Hd_+BQp 9t\\U@W(<\\@1	|@(:\r	S.WAht]R&\\I`DJ\$:TϠX`*rj1k,Յz@%95|Udߠj䦸Cf4~Lgp:E5e&@.quW[\"+@m\0,-һ[׋&a;Dxr4&)s<!:\r?8\nRl[zR.<\n8N\"0AN*Åq`	&B%0dBBʳ(BֶnK*9QāB4:Nr\$Ţ)20\n*[;\09Cx0o7:\$\n5O9PEȊRZĩ\0BnzAJ<>p4rK)TB|%(DFF\r,t]TjrD:=KW-D4:\0ȩ]_4b-,WBG \rz6O&r̤ʲpՊIG=:2F6JrZ{<CM,s|87-@Z6|YL\"#s*MB#=5Lv`S٥<2-ERTN6iJ鍵DQ\nq?bb9mŦGv4Z*օjRx8*MQP`-B.o_]+%].Im|\"ڣ\\!aq. l3O>1p8<CO2\0yۍ3:x/47Lt3_?tL\0|6O3MCkxPF*BF\\vӛC\$REr W,\n0˼s\rqx\$B++p[q@\$uP\"҂!tj\rU*Q+TZ8A\\0 ܒ9!/bE%ޣ`0tD(HD60N|69|G!KDv!:RpR)naѠ׻'HLg}jǈ\0d\rhqdEyΦ!ѻBM	@zSED-peAKrDH\07\$0BaH0-ȳ!<EG7,QN^&)ĸW__p\r@W&\n1J	~M-(w~J!8#!]t\\e@/Em+EDRZ+=k\$t, X?5{΀˷ARyšSN\$&\0DS}ihHQG0{JOo69goK\"@y_Pn @'NC4o3XI XȒé=g2%-%R+Pch8'5;/x*|@r30;jQG8x<si뽐ӛ6K})vZj&\"+M 8S+Wjiҁk'\$ }{3^w<W^[y蹛{LP;C>3v2UDCk|3לMw+D(\nՊ*keq\\R]Yx5Lc\0xg,V\"̀{dXK0P@N&\r19iT(Ì9ʥ\$Z	B:̨@P)Q߫ם\ruA\rRI<rgm1xw93cÚ~u52wuD@~ha3|~3\\į01H6fyH|a!`&or_dѴF#]'f%2\\DMADǻۢ\rVZR7x\$7\nn/tb-\\As=\r~	ȻGs\":@ϱq>8V2i\r=Ke(c(i5j{\\,P	L*r\nC(FXV9Ҍ=yz#wb0 )?a3le 2àM'Y&^u3)A(e-n4mUcSIb96,L|RB.P*P\0D0\"\rX\"w|?Pʍ_ֶP&}J!Z^_+ڹʾJm\"0	\$Xo\"G`VhVb&\r0\n~DBI|p _dn؜-NG+ZE]MB ~.΄j~Xʼͺf_J\0\$:BH`WG.ڡP\n	Ψm\n2Ͼ	+J,pzҀ?jUƲ)2>ͦ5nN*( tCM ٠@\rf~Td8Bŭ\0_G9\0`xg`j7lb\"ǐ\r 84\"ؐmO*^H>,VJ{C|#\nh\r䭨\nm4²\0j(=@UTfQjC[1F 	 ܷ(O4O nT#FB1\rJPʼd\n:	8n+qB8RFrh%p q)S\$ܟ\nc@.+,h\nE(>ƮR-\rm&\"'n\n&FUE:c,*8Ϙ\n`LN\rR>3ޖМD1GE	8ȒB6%22R\0P10#0^0nd,HJ\".5)N91gz3\"22^4D-\$ik	q45263se\"ѓ\rqi0f3DeM)H^j  	3&PS)3M&s&Y5Ss}4\n;3:G;ӏ5SpX3+%Ѝ00O:C8->Ӻ^ާӭ@88fnP:4(\0	CrpT:E(DRq4W:#S9>JGS9aƾ:e!4S:py#(rB):*IKAsdZMFpD5撞[%Pc؇59:AD-ePt4*tq5#6VK!:mνJ74PRuAsWSN=S8ޕOԦR7\nU+?5Q?c8q:\"'WU\$UjWX:k8u1<ՏW7YUҠՇSwZSsZ7Jȕ><\0ҷ\r5Y1+D=-ef'܎ ߑKE&F&ZM fB5LA4`0O|aޓ]\"%__һ}9_3O'G(\\s\\Q`2:܋G&x\0,H42u\0UЊ0>3hQMSW53ZpHPrKbJ6N>Ս\\6M֯iv=#ՉeU	VUe	WTЇ[;\\Q')eSlZplSicj5jvwl\rZn)rB**6i|ǖVZ\$1^0[9Y67:Vzԓow#\$S[P[[)vvT~!jo9Ew(:6hI7cGwHDKTQR0:ppX4|S?z+l3o\"u|ryU/t6PeK:QD4}zj0k6>dy_nRT\n[֥<lӴNjMN/-2X-H8~m!sN+DumeuKgb)ls24brg\0\n\0LuKJcS*oq'Fo}u7^A~2!\r{TyzQ牪jKaHH'ױ~HYO~%Y|%~q9#o\n\\r7]yxr:VumD%]`P\rW	?lUuSp9*cLM zA}uw*Y+cz ahY;=;C揋G YDtݛ(9ŖyQO\$2kxR@PFHdyGXN뭿aAťOm\nr@~*?t/r%wYsN9EtיxՃyVȐ	Yˈk%1q[C|h-?2{\nI&MQrTR튵sjWU3/d	ݧw9[:Z]a}_si/tZh-aipJ26hSgy)z:2˚\rǲvgv)P-g 79\$%rK|oyZZ-;cm%ds)YVwYo	/~QMq&:ЊW^Ɂ,EY/\rײ/ZEhEW*}kx_2%,o*{hp)3}}V	t;&^V4aҀ+-Ԃ\"fG8t>5eus?\\O<S@t0PjucPEKBK{^8gISmy]{X{h1\\<_'ʹ}M뮗_p<sǍ6Y\0n\r \r`Ao,V\rvbH\rO׏\npfvd+C4e:Q5bjo88;`]˺#<e],aMUV)?Ŕ5'HM`Aw#p@ϕXuxE黂mwc=T,_;҇{Qps\\_Yۈ[	M'u](_y;@ڽ~{wᩪ3wխY>O#o\nV5Hx⹇Xka^Cr:٢=e\\\nn><-g5-kY^f؊,pz'_w3k\nG%]ydc\$si+*[\$̪\$\0xH93`\rYrc'G56xpEĖ @S=O#Z0aCޖ'^&>)\"#s{i0>E܎9	p_9Bri\r>ሼc\\f<A8`	\0@	t\n`";break;case"th":$g="\\! M@0tD\0 \nX:&\0*\n8\0	E30/\0ZB(^\0AK2\0&b8KGn	I?J\\)b.)\\S\"s\0CWJ_6\\+eV6rJé5k]8@%994fv2 #!j65:i\\(zʳyW ej\0MLrS{q\0ק|\\Iq	n[R|馛7;Z4	=j.Y7D	 7i6LS0x4\r/0Oڶp\0@-pBP,JQpXD1jCb2α;󤅗\$3\$\r6мJ+.6Q󄟨1`P#pάP.JV!\00@P7\ro7(9\r㒰\"@`9 >xp89i؃+¿)ä6MJԟ1lY\$O*U@,8nx\\5T(6/\n58BNH\\I1rlHÔY;r|ՌIM&3I h_QB1,nm1,;,dE;&id(UZb!NTE^m0NpL6;eCR2(9#~o,jBjiHꊲ;pNM'1VՅPH+\"xvV;M ֈgn֞N* l7AS1oq+:S;0;>t=9`@s@2D49Ax^;ps3(ÝE\r*ӈg#px!}7;u2*\nZkh̳c1Mjтd\naNw>S'm?C\r:?Lp#%v\n\0CnJ9IR%9	4<(V`Hhm;K-ܶl[Zh\$!\"vAv!:VL*,C91\n4O+\$ؕvVtDl&Y!D8ܑi=9Q6D;hr]'`V+/ºJA+˔\0c!9b@ \naD&@udU-U\\%	J}peY4WVU6'nM{jNI\\BcsL11=ab1ǅVdbq`91fw)gDSuNxw0\nxo68@RSQ!ry{a<\0ësA+\0:Un:*jC8aJXNpu@9N߭|g2	{A{,:EPMθ1pc=nڻwrx/<`P/OL:=ע[J}𕀦ꩇ1ՒA+!ꦕǥ K{-MǷ\\_hS-耀UpMN<מhx٨^kw;\rɸ<w٣6g0C\r(:Y@|o=*nwg'sV6/.ufft1t lZ'!(\nr^u<Ha\0qo ijäseWU;dAxVù=Ql<\0(A*\nMe`OI;j@)rWA\r]<>	ܠt?%>lþgI<3p*yήt:ohi`B{mK0dp,ݞ) \nc)YcXP]lĂ;oc!]ǯi`[~B<%Na]-H;rAUNV@:Dk%|VI%'ƆNʽh 0C63lt<bء,ግDAOJ.,2IיBP`> TKDEa. V+ABBy\$M7;tT3fP@}F\nYpx%L[t#ܜkJAYD	 H\n	8PT@/rGKY?\0ak\$XsVKpRh`am\$ecg±IP;, ZɛFӥqC'o\rU{ԖuK1yX{ۡpJ8D<㵸-IIVʓ喌ʔE&FHO.drpa]Ǔie0Cܶn2 \0\"k\r^N:죺1l#Ioj\n`HˋHĴiҜ@\0/XKxJKN>))\"FD<'C+`Dv,c</AJ%K:I8ɖ%f&iT\\CL8<B8Gͤ;&>?j8DE:<(X;T<*P8E8]+Wc- e6j&W\$  	\0@\r\$&P.\\6R9C~`J\0^3Dov^DBgmk\nh\$ER;Cvc/<Q#1XVq&+Ѩhkj\$ADqDF\nJJ;9\"\n\"9C)!\"ppձ!p&l9i&4\nDQH򈆲BJTXRHr_'f帥\n#-G#f 2iC's\$;%&iD\$Pknf>Q6;DO*[lGR\n-g%OE%`@U1oHYLp.:TS*c;r*b036X~~\$20REE.QĈlV2efԱ,|+jX(STb}E9::q-6N7s:E▥C0B023a2pJI.E^Vhd	,Ef.6o>DQ2ճb[jflO4N~#72t75CB,SCQ\nѯ/)A/Tc2f!\$P#Q>38UFEEOgD\0h.rX(*EBS#+QN\\\"_hP;qHi	LIdζν\r/oAsHi-;N|K)IpNL4,N44IT~PͶ %R@(7bg?fCeMLVi?+ECc}i&,CU\$X% \\&6iT;HIcOu;%fKuP3W+Z	r\\dQӈEFDOS/ PPIPP]gA^v}<8T/2D y{N: _\nRm)\$3)!qaK/5:3~!a/aR9b3SI2c޾bs,=[0 v)ft\\w8^V6g	vF).[P<#hMlVU\nGNqt{/4DְVdS^cB-kvN#`etS @uD^S>ds gfYnooIidԁp\0pW\0n[)TB'01	 \0/=Kk?t(tvR3WNDVI5IOEtMuvUDiePn4vSwm]`H/Ŵw-tIUrz7{_	XQ3Y\n^r\rX+qH\\t\nVVy~\r~Wgc7xWqcgt4?nWkon@A0|OMe[nRgT	elYP=Lx?}f4v>	\r()6قzb쀌nLO&rA(x]&LafU(.(r³Q0#M76i]6m\r \rn?+O\nC3~W2+\0ڭʖ\nZXȄqL.qUQ}CTE3U4g&l@\r&4E`T\0Y9xV6Xj*4RaX9;\nx8/rX̴	Ǫvg>A`ǆrS'׍)[Ksml嚀l@ʪ-[wJTTq&Chk07BCBL\n\\?=e@౧#&^zkPL\"\0ss>=To\";w@:p7Y	=	s?XYs0*\n.\r`[|\"S(~[zmh'!Lgi㾑d;f:hzh0CD/F)_đ\r@>xb?6v+߃r4/\\;;{(.hn	\0@	t\n`";break;case"tr":$g="E6M	i=BQp 9 3!i6`'y\\\nb,P!= 2̑Ho<NXbn)̅'b):GX@\nFC1l7ASv*|%4F`(a1\r	!^2Q|%O3vKsfSdkXjyat5XlF:ډix\\Fa63]7F	ӺAE= 4\\KK:L&QTk78KH0Ffe9<8SpNÙJ2\$(@:N\r\nl40@50J	/㢐SB:/Bl-P45\n6iA`ЍH `P2`H<4m @3F9tCt>32܃8#N&\r#;D厣p꧵PEE(AC|\nx@p\r++CҠȀ7>#&9p\"k5ø:\rzuc9`@\"@2D49Ax^;ځpMH\\zbׯJ(|6r3\$4!^0=+6#0e [NΘL6\rH{F1⤪,JBqbԊa(ț0CeR%\n߉(6Bx\$#K0 \rK-}Ph2HF^\$NV0CC4SÒ#ZkSԉX!'	,jܽK@8q9b	;0c[=gF!Er s<AC;?K/7IJViIL|#_\0',=(3_\"]5Om6I`QC2w}BO_8@3#ѧcoX3qmN2Ab['ppN\":Cɢ\$ӿ3Xy}|IҜSQ?O	3di#|Ѭ@@BY9h-%ֲSn-ɚb]r	ŉea0^/+\ny/H&_sE0\r:d<`b\n#\nB)eb4eqbFh\r\0gP,d֊Z^D@VhMI#PL&q=E|TܑѠ%8I29TxlKQTr\nwLd]O#ɻ Iª\rR\$|#!S(r'q\na_l'ʪC(,1b_OHt\\zHZ*rKA \$g<?fL̐5ppp*_p׃8 !fc]K\rپ ) @Q8!D4L\\weH	|L/ XVk@#dn h	qT\$nU![!?*:'0O+8JU/T5|,*CUk쨑t`#dyӎCgO.Hm8*OrH-VnΠ2)UÒgAlFH_5R \"}X&% \nqʶJ	8PT(\$90\"V89,@.3`ǌ(S:\\&ZB8>Ճ;<܀r9'L L9Ad:4VoCwAdD[j2O!:.{d\$8rq(b.``@S<O҂\$!gA0xAdXH\nz|:Ӊ& |ur^\n݈ߖt'&L\$<eG&^[A[g3LS)f9\"2bl6yvزnnXq.1dT`Tn('Ca,,q|Bz	HȧQgO\0@Ae߰)m<I#MnT\rK\\eYS,Z}fx~.ml^?@&'>\0qNy[.׮dQ9~\\f9~7TL)u@,/ʠBGiH?\0q\$v/e}vFs+o\r-!jFH3\"Hj>q,4=@A2\"!yDYx2EhA#Q͇0,c2\"!*0͎Cy[2fWa9Ը<@3KUﵚgQbۨhyT\\Ҳzd!X{-^/iO'ƒB:< DQdZ/Tf\"Ơ*`e4Qu,r /R ,ҹ;)PbuZot'.*BOPvޥ7Zbdgn@`	7.]\nnв)Ͷmۃ	0^H0ώDrͪqRd`'*&#xGXQ\0Y8&Hvbl;\$7ЊAC)vڑ\$o.0׍}\0p0-zp}PlqpFrQ~m0Pў/Lqm(qrcQ1,nN;\nlDvGG7.СIk\0cѽni\"OPv_4ou \0j#81	CsD_\0 DXp,?#<%qJ:(	:MOzr@c\$po&, q!gf\$zz3Q;,O*abP2*GY+RloHBe6@@^4,>k!fNb܃(*ڀD5\$C..,Pvd.ϛ/䎖0`BQR#0\"6^S@d\rVc.j\nZ}ΈE-!\nx|\n/\nG3fՀ4hGĂ,t:r./,5%2T3e:CfeB|5hR}/92!9}fRb7(8,Tz@1-,1N0JүBf*\"CpBRɜDG/iT	F\$ph6P:@G9\r߬c\nÈf	]/@@Rz4F/Sq3Hg|z:'/AǼPB&aB\r>C\\K\$j\r`d\n|k<@";break;case"uk":$g="I4ɠh-`&KBQp 9	rh--}[ZH`RdbrbhdZGH\rMs6@Se+ȃE6JTdJsh\$g\$Gfj>Cf4jSdRB\rhSE6\rVG!TIV{ZLʔi%QBvUXhZk7*M)4/55CBhഹ	  HT6\\htvclVYj׶ԮpNUf@;If\r:bibﾦj i%lh%.\n{;y\$CCI,#DĖ\r5X?jвH)Lxݦ(kfBK{))ƯFHm\\F \$jH!d*B郴՗.C\$.)D\nlb9kjķ\\̐ʾD\rZ\rqd隅1#D&?l&@1M1\\`hr@:,΢[\nC*(i4c6@7A\07ZVlZ(:[c74PF]t\"VUZ`=4MtK(>J1^o\$_rZ4QS&%NB# 4-̥5ʋMYLżĤ\n13@4C(C@:t㾼9VYax0clxDћ}ORs'TvhNx!󀒖17%Ķ8H8kRVWJ,A}%CvfE;|b4FN*P*vRD`J2h^\rWxM6h`zJ(|%w?7oM:\\N=sǹvr<\$ʤPTIYrh\n#O\"7F\\\naf D9r4PJ_ ZԔQ\"Jau+HxTH7yQ@g.r+nAur*㬆Y8)Wj#G5(I9愆)/ѡ]B, eEe@4	4 5BQY#fN*F10̚Ȱ%b&`=ЛEp!'\nXDQ<HS\r9?M\nE\n	'yfQBTJI`bc)ข.ɊKIIʩ,=#]p	˗4 ~BR:Ys.f908tF93śo8ܸMӞ^ˢ0	>xՕ2l9MI5̔٠3qeMK,u(a'zSuM̪nw	h|,;J RhrL˶#4( i=6[k}Ԇٛ@nt\"n\0' )k]^EzC̑SLUτU:%TtKLN;oYZ-%G>RI(6ŦNņZfU6ԚVk\ri5IlɳĹMhnMhbQNry'\"4} OLbP\\uUe5˩M:IERV3S\r0XAŕLs%6B&rb#|\\9Pu=2(,0S9iD['3sj*\0\"֍O)٧ҎFfh(pyïp\0PYM̗)+hW\nJB0q]ĵ8eJ6:0\$)ܺht{Ί/X	@{!	FX['s.8\$]\"FzP\$6u2.i1ue\\!03{0˂K,S\062d1q\\:·\0CxAR/ ü;oj7/bc}Im=iZYX6cL+<\$;:?wj Glu*%9\\vM|ӓ9!d*oW( ܠ2.+bu%P|JuxϱېW+%H-kv%SA)yiqKc\r]	ܹI1v\"lO荣`2<9zEi|:\$m23@.5	q\"\0*b)oDFVh	t#n@:2|#@M	 G:ٙHm\"hg_pчb.UN\"DڟAѠQA*Uw<AZ{<¦-AQb	6Ii-/e03%K@CRM&~]Ʉ3i5:w>=J]g\\9b\\Op[-izOe5]L:ԬGde1Fu8\$f)؍N!H1(n-b|o7ˀ7Rʆtf7o3Et<6	)\"l\nȾr\"RADF\$L>htf(Cp*!nGJgFVPdLl\$/zggк	(b8(̎h0-(((dDV,Xip\r\0sHX),ҋ&2Ef \n`m#dLzȧKHd\rgG,tG7HQNWqRSD%m)%\$Ί#+gPDOP?:Q`u1dGgqPQl,Q\"_\"mli!}k,QXQe46bq@e4g;xx%\r1̩+l ' l:q16X8wcy(,+q_\$>~cSˋ>_*Vp\0Fb'P#%cBdRP,cgNJͣ0D:\n2HC\nPt&*~\$F>bT\r@SC(<d..BQx|M/.H;l-eGZR3(4F&{O386%LsLSFq׫~%B1#.D,\$	6#-F\$4և~)ɐJ!\\SxS'0&?4'.pL!Ӽ4dhl%@RSY'\"ODS2/Rbhs|l@@̪K;5.-4\nt?+3/hht>s-0iHL5r4)ETF!D7hDb\\beЖtJLvA4AGA#G5HtylF!MeGJTTKEKjd!FC#kX0<2E4ENO'Op24bTP\$_ΔQFFS@.\r_>\rT).gp_x<EM,S,(h0Cp.,Őq p0FuV%VbR*NPrv!#Pr^S\\uz\0')U!>:twQ4o</GP<tXTG0^uRt/F4E=0GE]A2TE\nWFVdNv__V\$um`64FLqLg `Qzz̭;nX(}>)BEcHԶsu2DVt2IkLT^iyM}bR&urisH`)V(c9V/T@%`.,vǶDO^b'fZMWO(Tsp6>wg+NbҾcphPwmcq3okmgorzKjo55rq<ǱsqvB	fi\no7S	=a5C!ExpjW%N\nn\$Wh`UxЬSvWR\\at5C7(@5xV!DW|?p\\-aJ>Wb>aVH'%(9(	hKW(Q.fOOq}M֭r IizH˃7~{Pl.EB\$x@6gov;3GK\n(8#ׇ8ui1NAd'u7*%K\n<~GkAؔNue-N{t0;Y\nqwW7hgɍx7É4sAԣZU'DL1eiqd)zu=V9cdct%%BTAVQֲJ97-X>˝QV2rvsn0X&2LBo\nD\$lW.ۇ06/\\}S0u=V<1E13]tevUhy43!8Vh'˝NcHxٷd(YbQPr7hJUo-uNbA?=W85Һg<*/9 \n`Z(kY|Grf80zORh6R5-K\\O#5*,of1ʗf\$:O|8z#Y`w\nKD6DtbT\\Mdxpq";break;case"vi":$g="Bp& *(J.0Q,Z)v@Tf\npjp*VC`]rY<#\$b\$L2@%9IΓ4˅d3\rFqt9N1QE3ڡhj[J;o\n(UbdaI¾RiD\0\0A)X8@q:g!C_#y̸6:ڋ.K;.}FͼS06\\vN5n5x!r7C	1#(͍&:;#\"\\!%:8!KH+ڜ0R7wC(\$F]]+0Ҏ9jjPeFdc@J*#ӊX\n\npEɚ44K\nd@3&!\03Z09ʤH(\";mh#Ln1\r?!\07?LwFT<x4K(T4BB-KdPɒpSωcʛ'>a3R-Ȇc(q(ɈH#huQĵAw[LH7B6o	APAÔ0c\rM;(:\"9pX90z\r8a^\\0wk}xh2\rӃpx!\\,˳5-h	K)Ft @V]`ά;\n7;c:(LS\$Du@2t&d[q*JѢ\"b:VqR)*#*knRRZivT&DܰE^4\$Z4[kIr@(, P\$*P(S;F:R\"&CƊ\r437\nJ\"}?\\\$dɢR@yGS\0j٬µ	BK\$ݠ8&Ķ52 08\rXn,4BݍLZ5GWӽ^A\rqFeb+AAʆ\\k;(<\"8k@JUFRAɇ5:C\"b V.Xc;6K\"s(eADPC1ҙHF	.\nBT() \$\$:/äeH/H79X%]+شԽU<BZba1<\$GP&RԺ\rnT 9 Iq,\0##>hB8\"H^ra& 5+@ `6\r̦T_+3Z*zh DbD7JQHt]!ܱђ\$-w\0зAA@\$h@\$\"eJBE(1 HpA(GR@x:(|\rb0Wt*RB<y;Ը2k'閂FaFyKy/)@AF.XuFm=*蘐\\DxHAZF9xi:&!oD_-E\0EI?;'i\r\$\$ \$76;[@(3\"Y5.iTk9k,̒<Q	`/\n<)Hw99\"a3#QI;.	(xZ\"vħq}rGD#Js%>rVEY\$9dxIаFb%e^7b,I#V-10tJbYUFbNZ\$9m-`xԏ@YQ'ܵeB[D;X \"Np'D)LÚ\"5@gFn-&vi\n*eN*if=z,|n)Eg6D\"jM\rt,bq\\N5ţI4(de칖Xzh2sM]\$p\"ijˋ\0:cTGzNT1&ϒ?3O8s7ZYn3\$WEDWT&SV\0	Re2I0\$\\nWHT\n!ׄDkB7ZMm!o s d\\Bĝ>}-kr앎iR,I<b}Y\$K\$7n	U\n4wL1QFQROIQ,ν[J\r=IZB~\$K<&YULyY{ZGYOV]~Q/eۻ	I+S+wZk{\\ڴw	)3C<Nǣ?/#~߂6BFM6)mfl\0.8BR92*J~*\0۠?P)\0~'dikt\"ؖpJoHVD90H[0Fan'6̔zFF\$|'\r&%ѯfJ;HPآĭ80\0	-0h܈pڀ~gfv%O&aa̟Pc\"O\"\$湄*9^%( 120HpL9~uH\rW&aXP0~D`phhd\$Ĥ.N<\\ĔkFIQ81=-koeM'IGMf\r熗	 1j}R0.	!<ha G^ANr	nN:&NAvlj> aȃkq%ns \$d]2nI&(,'XJ2(\"۰pX20*/c5e>h*T̫<0*'V-G;#!-\$%K'2.LrCΆ-rr\",.	0lNr(1\r\$R)2S~ej\$\\w!.}0.,W3%fh%4ST	|L'Bf%PX0('sz5eЍ\\:K#V;z)s!*|Q\0B\\	:-\n*V-Ms\n\$G0bH\\CJIE \nq/޵J̮/EqX\$yAv^\\,RP(s2}=RC6(jrFo̆6dZ,\0I{̎L8D9hFa/%	̊Ӣ{@mɒII6'H7pkK!#wdSJXeacxډm´\\i \"i81zt. Nh'F`@~PXB\$k*D\n	2Fߤ\$ ^!M44iuY:J@\r>e3*Nb+ZH#:\\E3lrTۣF* ";break;case"zh":$g="A*s\\r|%:\$\nr.2r/dȻ[8 S8r!T\\sI4brЀJs!J:2rST⢔\nh5\rSR9Q*-Y(eȗB+΅FZI9PYj^FX9P2s&֒E~yc~#}Krsk|i-r̀)c(Cݦ#*J!AR\nkP/WtZU9WJQ3Wq*'Os%dbʯC9Mnr;NP)Z'1T*J;)nY59XS#%Ans%O-30*\\OĹlt0]6r^-8\0J|r\nÑ)VS09),00pi+\rFeb%ʁP˽DF/@[r)3K|I# 4(tdlR>(\\.D/rOi&\r3:xe\r5NSp9x79c2:e1AANI\\|GI\0DYS1,ZZL9H]6\$O]VJ7Q\r&Sㆮi,Xu~=ZS8tIdKLWeEݑ9TrPDO]}Pg)\0^^Tzxy D%8sN]\"^9zW%s]g̲:Da&I\\V]2Ą!gD#ECGm|)\"fBnI58QtkM'1Q>\\9rSGD\n^8=|su9a'Dߵ[.}C`9%;E],C=-H%ZFEb3:bMW1I-w#e|޼DOWƐ,\0;guL:(@1&DDDD]tXKc,tZ+Mjp^xn!4Q\"ŉ<\"Z:(`yx&BnR\\~аpO.UXkcjπIj-eCtZ\$\nAH1D5#bT \\ 0\\Q# N!N}LhIPXyU~O\$9ظ!\"1Ydb}(SQcLi*𩏪@\$`xт&	#*@D(9X<Q_a\\@,PgX#(LN^/UCQ	jZh1@RI/Y^uMK̖lE%MlN	¸ZzRglP%681VOqv#*T,DN0B%E?*@'0U1fSyA.1@PUELB־@sHA)F\n@@O{	0N#8O <~'^.@PO	*\0BE6\"Pmi^UZDx_tQ~3E03/0d`\\*.S諹=m&eie{/x۵t7ݣ*[+NsL3\"Q	rބ&q\0٘&K9H	U\0@s9AiEaB9s,7taސn।\$s:BZqI˱<hM@!ܕWch`]LGws/'&CIa'ۡ!}hy;;p6O)K`C	1DcthOPHx E/%+Ju@XYK0&5q#Q8/E\r %0姢̫~\\ow!\nH	)4kAV1tRQUfS_A\\2-fz%L	Ɣ<[QRkVbOAi<G!.\$/%쾷 9BK^6	3W&AetNKq,^hEav?H(L)s?TBR4&y_5ˑgDDt\\KKC-(_/)aej\r\"ŸSDH|<:ܷ06Uݯ^hxux^#h;g#gwSjsfތhOyb~,a8KLr)igN#IStBBZKYz*dVG-aWO#\"Sf}C&G2pN}T׋{_U);r|x=3b8s<Y_Da)cP%s\0mBq-\n2d<F}NN*Ȳz'0*0N/cPX\0VُԦ,9O'<6πL:ep&	pN0lpPc\n\nF0p0amTblpOa˭P̣ބpGP\rc0HDan*[`Pm	(-!t׃BbH\"B|qLJQ@.DmV0Z@g\rzD 4.|G|&ϒ\\;\np6,P׍B8)#b::mbȫa!(4!^cp;( Cn/A^&CjziC4|gJ-2!,Z|JJf!.rAA\0.p&B/2CI!m%dx*lq&*Z/\\4ijL!nr.VĹN(p,pDMD\\ \r\$2hΈ`G##aBbP?\$#L@-nr	Rc|BDrL";break;case"zh-tw":$g="^%ӕ\\r|%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	%cJe R)ܫ{	Nd TP\\Õ8Cf4aS@/%NNd%гCɗBQ+B_MK,\$uowfT9WKʏW2mizX:P	*_/g*eSLKۈι^9H\r7Zz>0)ȿN\nr!U=R\n^JTO](I^ܫ]EJ4\$yhr2^?[eCr^[#k֑g1')T'9jB)#,%')n䪪hVd=Oa@IBOs¦KJ12A\$&8mQdlYr%\0JԀD&Hi1ġD)*O\nT:N09DB+Yqb*\\gA2@1DQV%^Rpr\$)RP2\rH2GI@H&PpF	hS1M;̵\r3:xq\ri[Wp9x79c2JHAALEKFPxQ@Da	^sDH{_rX-Cc	(\\CWUq6W<EiLr\$R2:@a	*b|Sobd1uw^Vd:\\C)xGrBHreB^1I?{BzP@j1pM~B<JLj8\"s@(p^	DrjřNEgTnUtl㽹wAYoZycx%ϥbr9tx?T?Q<__k6.T\$DG!tCM\0X.hAa8	:QIg@C UE\"FLA?IN!t#QPժP=N!EqFRB H\"[in-\"+u o\r:ApV\"@XCt	,%ЦWV\rι\r\$5\nSQJe@('UkV\\arxdb^Me\rQb%c`>OY+tVW%o1Ir(#\0i<N+E\"xrfapq6&Ù35 #Os(C}3gKDH\n	u(	!\"JR_bLPo\"Y\neYj}\np ,PŠLbs	^PpJu6lnS!6) o\rkJ86J%q@`L6HcWT. EbrSPQ͚BAL 06]g9U*(0Qtq8DHtDeO\naP*HJ	qBl:8B*'*i!RP,#@N(	:N\rEIU+L9Xr*#EMP\0U\n @ &[Z8*B@FrfK{H-w.EӛksΉ:슋.^\r#\0Fj|¬a\n2ϵǸ\r~<BdJq @p(@K^i	b\0sRkH.	j]~'ؠ,\0P\"j*ʏjn(12\n!Z;!+PD&`}iDnɊ)fN_CZ\n&̘\"К^h9А#t-rwVݖ.*Ru}@&EU*VЖ6xBTr1\\\nP:[hB'\n!|W헧<Rz>Vx;Fe6<%\raBBX>/=YBEIJg\$܆:\"3ܐI*v-&Q -F9E@\\Nx!\$r3	10(4s+C\nrԗ1\\o(=I(Ar+E.`鋱}&BSE9`Z^GHP⧚!]!y<;ǀ\"JiK1fHV^'3\\@x3}*BWEcR?C֕k\"P~w[XqO<y2\\Z{jSd+Bttj:iH%Hj%J?|ĺ8!CxgU[9<ǋP6W^oGTG}p#zoa~/6һ	\0ϔQ-9\0j\r,h\$8(XB!ʗt^8ɰOJZ	m*Ƌ	@5z#(&CPD*Pӭ&d08H421D\$dldO0гd6n0,pMv\nnQ-xPzv.^m	 Nb~cv*op0w&O[\rqJ}lt'1mm̓qB\\dx\$pTio͌fB161z*dQ,Lid#,/OEv\rL%+oPQ~ԭN10lQRIdIlG102^`)CF{DC	@h`P\0RDJ&az#pl\n.C0F2*5BA1ON g\r(9'\\k2DM~*=\np8G|8j bEKa냌08ǘӒ̲Tށ)/H)؜A:3vlx.ObqE\\,A.%lLP.'-moO5O|01pe	wn%|/\"0s58*DA,\"2\n`B\0S`\nFHچRAR*{s33l(&LM=\$G4goo\$\\* ";break;}$Ci=array();foreach(explode("\n",lzw_decompress($g))as$X)$Ci[]=(strpos($X,"\t")?explode("\t",$X):$X);return$Ci;}if(!$Ci){$Ci=get_translations($ca);$_SESSION["translations"]=$Ci;}if(extension_loaded('pdo')){class
Min_PDO{var$_result,$server_info,$affected_rows,$errno,$error,$pdo;function
__construct(){global$b;$ng=array_search("SQL",$b->operators);if($ng!==false)unset($b->operators[$ng]);}function
dsn($pc,$V,$F,$Ff=array()){try{$this->pdo=new
PDO($pc,$V,$F,$Ff);}catch(Exception$Hc){auth_error(h($Hc->getMessage()));}$this->pdo->setAttribute(3,1);$this->pdo->setAttribute(13,array('Min_PDOStatement'));$this->server_info=@$this->pdo->getAttribute(4);}function
quote($Q){return$this->pdo->quote($Q);}function
query($G,$Mi=false){$H=$this->pdo->query($G);$this->error="";if(!$H){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($H);return$H;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result($H=null){if(!$H){$H=$this->_result;if(!$H)return
false;}if($H->columnCount()){$H->num_rows=$H->rowCount();return$H;}$this->affected_rows=$H->rowCount();return
true;}function
next_result(){if(!$this->_result)return
false;$this->_result->_offset=0;return@$this->_result->nextRowset();}function
result($G,$p=0){$H=$this->query($G);if(!$H)return
false;$J=$H->fetch();return$J[$p];}}class
Min_PDOStatement
extends
PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch(2);}function
fetch_row(){return$this->fetch(3);}function
fetch_field(){$J=(object)$this->getColumnMeta($this->_offset++);$J->orgtable=$J->table;$J->orgname=$J->name;$J->charsetnr=(in_array("blob",(array)$J->flags)?63:0);return$J;}}}$kc=array();class
Min_SQL{var$_conn;function
__construct($h){$this->_conn=$h;}function
select($R,$L,$Z,$ud,$Hf=array(),$_=1,$E=0,$vg=false){global$b,$y;$fe=(count($ud)<count($L));$G=$b->selectQueryBuild($L,$Z,$ud,$Hf,$_,$E);if(!$G)$G="SELECT".limit(($_GET["page"]!="last"&&$_!=""&&$ud&&$fe&&$y=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$L)."\nFROM ".table($R),($Z?"\nWHERE ".implode(" AND ",$Z):"").($ud&&$fe?"\nGROUP BY ".implode(", ",$ud):"").($Hf?"\nORDER BY ".implode(", ",$Hf):""),($_!=""?+$_:null),($E?$_*$E:0),"\n");$Mh=microtime(true);$I=$this->_conn->query($G);if($vg)echo$b->selectQuery($G,$Mh,!$I);return$I;}function
delete($R,$Eg,$_=0){$G="FROM ".table($R);return
queries("DELETE".($_?limit1($R,$G,$Eg):" $G$Eg"));}function
update($R,$O,$Eg,$_=0,$M="\n"){$fj=array();foreach($O
as$z=>$X)$fj[]="$z = $X";$G=table($R)." SET$M".implode(",$M",$fj);return
queries("UPDATE".($_?limit1($R,$G,$Eg,$M):" $G$Eg"));}function
insert($R,$O){return
queries("INSERT INTO ".table($R).($O?" (".implode(", ",array_keys($O)).")\nVALUES (".implode(", ",$O).")":" DEFAULT VALUES"));}function
insertUpdate($R,$K,$tg){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($G,$oi){}function
convertSearch($v,$X,$p){return$v;}function
value($X,$p){return(method_exists($this->_conn,'value')?$this->_conn->value($X,$p):(is_resource($X)?stream_get_contents($X):$X));}function
quoteBinary($hh){return
q($hh);}function
warnings(){return'';}function
tableHelp($C){}}$kc["sqlite"]="SQLite 3";$kc["sqlite2"]="SQLite 2";if(isset($_GET["sqlite"])||isset($_GET["sqlite2"])){$qg=array((isset($_GET["sqlite"])?"SQLite3":"SQLite"),"PDO_SQLite");define("DRIVER",(isset($_GET["sqlite"])?"sqlite":"sqlite2"));if(class_exists(isset($_GET["sqlite"])?"SQLite3":"SQLiteDatabase")){if(isset($_GET["sqlite"])){class
Min_SQLite{var$extension="SQLite3",$server_info,$affected_rows,$errno,$error,$_link;function
__construct($bd){$this->_link=new
SQLite3($bd);$ij=$this->_link->version();$this->server_info=$ij["versionString"];}function
query($G){$H=@$this->_link->query($G);$this->error="";if(!$H){$this->errno=$this->_link->lastErrorCode();$this->error=$this->_link->lastErrorMsg();return
false;}elseif($H->numColumns())return
new
Min_Result($H);$this->affected_rows=$this->_link->changes();return
true;}function
quote($Q){return(is_utf8($Q)?"'".$this->_link->escapeString($Q)."'":"x'".reset(unpack('H*',$Q))."'");}function
store_result(){return$this->_result;}function
result($G,$p=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->_result->fetchArray();return$J[$p];}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;}function
fetch_assoc(){return$this->_result->fetchArray(SQLITE3_ASSOC);}function
fetch_row(){return$this->_result->fetchArray(SQLITE3_NUM);}function
fetch_field(){$e=$this->_offset++;$U=$this->_result->columnType($e);return(object)array("name"=>$this->_result->columnName($e),"type"=>$U,"charsetnr"=>($U==SQLITE3_BLOB?63:0),);}function
__desctruct(){return$this->_result->finalize();}}}else{class
Min_SQLite{var$extension="SQLite",$server_info,$affected_rows,$error,$_link;function
__construct($bd){$this->server_info=sqlite_libversion();$this->_link=new
SQLiteDatabase($bd);}function
query($G,$Mi=false){$Ze=($Mi?"unbufferedQuery":"query");$H=@$this->_link->$Ze($G,SQLITE_BOTH,$o);$this->error="";if(!$H){$this->error=$o;return
false;}elseif($H===true){$this->affected_rows=$this->changes();return
true;}return
new
Min_Result($H);}function
quote($Q){return"'".sqlite_escape_string($Q)."'";}function
store_result(){return$this->_result;}function
result($G,$p=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->_result->fetch();return$J[$p];}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;if(method_exists($H,'numRows'))$this->num_rows=$H->numRows();}function
fetch_assoc(){$J=$this->_result->fetch(SQLITE_ASSOC);if(!$J)return
false;$I=array();foreach($J
as$z=>$X)$I[($z[0]=='"'?idf_unescape($z):$z)]=$X;return$I;}function
fetch_row(){return$this->_result->fetch(SQLITE_NUM);}function
fetch_field(){$C=$this->_result->fieldName($this->_offset++);$ig='(\[.*]|"(?:[^"]|"")*"|(.+))';if(preg_match("~^($ig\\.)?$ig\$~",$C,$B)){$R=($B[3]!=""?$B[3]:idf_unescape($B[2]));$C=($B[5]!=""?$B[5]:idf_unescape($B[4]));}return(object)array("name"=>$C,"orgname"=>$C,"orgtable"=>$R,);}}}}elseif(extension_loaded("pdo_sqlite")){class
Min_SQLite
extends
Min_PDO{var$extension="PDO_SQLite";function
__construct($bd){$this->dsn(DRIVER.":$bd","","");}}}if(class_exists("Min_SQLite")){class
Min_DB
extends
Min_SQLite{function
__construct(){parent::__construct(":memory:");$this->query("PRAGMA foreign_keys = 1");}function
select_db($bd){if(is_readable($bd)&&$this->query("ATTACH ".$this->quote(preg_match("~(^[/\\\\]|:)~",$bd)?$bd:dirname($_SERVER["SCRIPT_FILENAME"])."/$bd")." AS a")){parent::__construct($bd);$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return
true;}return
false;}function
multi_query($G){return$this->_result=$this->query($G);}function
next_result(){return
false;}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($R,$K,$tg){$fj=array();foreach($K
as$O)$fj[]="(".implode(", ",$O).")";return
queries("REPLACE INTO ".table($R)." (".implode(", ",array_keys(reset($K))).") VALUES\n".implode(",\n",$fj));}function
tableHelp($C){if($C=="sqlite_sequence")return"fileformat2.html#seqtab";if($C=="sqlite_master")return"fileformat2.html#$C";}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
connect(){global$b;list(,,$F)=$b->credentials();if($F!="")return
lang(22);return
new
Min_DB;}function
get_databases(){return
array();}function
limit($G,$Z,$_,$D=0,$M=" "){return" $G$Z".($_!==null?$M."LIMIT $_".($D?" OFFSET $D":""):"");}function
limit1($R,$G,$Z,$M="\n"){global$h;return(preg_match('~^INTO~',$G)||$h->result("SELECT sqlite_compileoption_used('ENABLE_UPDATE_DELETE_LIMIT')")?limit($G,$Z,1,0,$M):" $G WHERE rowid = (SELECT rowid FROM ".table($R).$Z.$M."LIMIT 1)");}function
db_collation($m,$qb){global$h;return$h->result("PRAGMA encoding");}function
engines(){return
array();}function
logged_user(){return
get_current_user();}function
tables_list(){return
get_key_vals("SELECT name, type FROM sqlite_master WHERE type IN ('table', 'view') ORDER BY (name = 'sqlite_sequence'), name");}function
count_tables($l){return
array();}function
table_status($C=""){global$h;$I=array();foreach(get_rows("SELECT name AS Name, type AS Engine, 'rowid' AS Oid, '' AS Auto_increment FROM sqlite_master WHERE type IN ('table', 'view') ".($C!=""?"AND name = ".q($C):"ORDER BY name"))as$J){$J["Rows"]=$h->result("SELECT COUNT(*) FROM ".idf_escape($J["Name"]));$I[$J["Name"]]=$J;}foreach(get_rows("SELECT * FROM sqlite_sequence",null,"")as$J)$I[$J["name"]]["Auto_increment"]=$J["seq"];return($C!=""?$I[$C]:$I);}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){global$h;return!$h->result("SELECT sqlite_compileoption_used('OMIT_FOREIGN_KEY')");}function
fields($R){global$h;$I=array();$tg="";foreach(get_rows("PRAGMA table_info(".table($R).")")as$J){$C=$J["name"];$U=strtolower($J["type"]);$Yb=$J["dflt_value"];$I[$C]=array("field"=>$C,"type"=>(preg_match('~int~i',$U)?"integer":(preg_match('~char|clob|text~i',$U)?"text":(preg_match('~blob~i',$U)?"blob":(preg_match('~real|floa|doub~i',$U)?"real":"numeric")))),"full_type"=>$U,"default"=>(preg_match("~'(.*)'~",$Yb,$B)?str_replace("''","'",$B[1]):($Yb=="NULL"?null:$Yb)),"null"=>!$J["notnull"],"privileges"=>array("select"=>1,"insert"=>1,"update"=>1),"primary"=>$J["pk"],);if($J["pk"]){if($tg!="")$I[$tg]["auto_increment"]=false;elseif(preg_match('~^integer$~i',$U))$I[$C]["auto_increment"]=true;$tg=$C;}}$Hh=$h->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R));preg_match_all('~(("[^"]*+")+|[a-z0-9_]+)\s+text\s+COLLATE\s+(\'[^\']+\'|\S+)~i',$Hh,$Le,PREG_SET_ORDER);foreach($Le
as$B){$C=str_replace('""','"',preg_replace('~^"|"$~','',$B[1]));if($I[$C])$I[$C]["collation"]=trim($B[3],"'");}return$I;}function
indexes($R,$i=null){global$h;if(!is_object($i))$i=$h;$I=array();$Hh=$i->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R));if(preg_match('~\bPRIMARY\s+KEY\s*\((([^)"]+|"[^"]*"|`[^`]*`)++)~i',$Hh,$B)){$I[""]=array("type"=>"PRIMARY","columns"=>array(),"lengths"=>array(),"descs"=>array());preg_match_all('~((("[^"]*+")+|(?:`[^`]*+`)+)|(\S+))(\s+(ASC|DESC))?(,\s*|$)~i',$B[1],$Le,PREG_SET_ORDER);foreach($Le
as$B){$I[""]["columns"][]=idf_unescape($B[2]).$B[4];$I[""]["descs"][]=(preg_match('~DESC~i',$B[5])?'1':null);}}if(!$I){foreach(fields($R)as$C=>$p){if($p["primary"])$I[""]=array("type"=>"PRIMARY","columns"=>array($C),"lengths"=>array(),"descs"=>array(null));}}$Kh=get_key_vals("SELECT name, sql FROM sqlite_master WHERE type = 'index' AND tbl_name = ".q($R),$i);foreach(get_rows("PRAGMA index_list(".table($R).")",$i)as$J){$C=$J["name"];$w=array("type"=>($J["unique"]?"UNIQUE":"INDEX"));$w["lengths"]=array();$w["descs"]=array();foreach(get_rows("PRAGMA index_info(".idf_escape($C).")",$i)as$gh){$w["columns"][]=$gh["name"];$w["descs"][]=null;}if(preg_match('~^CREATE( UNIQUE)? INDEX '.preg_quote(idf_escape($C).' ON '.idf_escape($R),'~').' \((.*)\)$~i',$Kh[$C],$Qg)){preg_match_all('/("[^"]*+")+( DESC)?/',$Qg[2],$Le);foreach($Le[2]as$z=>$X){if($X)$w["descs"][$z]='1';}}if(!$I[""]||$w["type"]!="UNIQUE"||$w["columns"]!=$I[""]["columns"]||$w["descs"]!=$I[""]["descs"]||!preg_match("~^sqlite_~",$C))$I[$C]=$w;}return$I;}function
foreign_keys($R){$I=array();foreach(get_rows("PRAGMA foreign_key_list(".table($R).")")as$J){$r=&$I[$J["id"]];if(!$r)$r=$J;$r["source"][]=$J["from"];$r["target"][]=$J["to"];}return$I;}function
view($C){global$h;return
array("select"=>preg_replace('~^(?:[^`"[]+|`[^`]*`|"[^"]*")* AS\s+~iU','',$h->result("SELECT sql FROM sqlite_master WHERE name = ".q($C))));}function
collations(){return(isset($_GET["create"])?get_vals("PRAGMA collation_list",1):array());}function
information_schema($m){return
false;}function
error(){global$h;return
h($h->error);}function
check_sqlite_name($C){global$h;$Rc="db|sdb|sqlite";if(!preg_match("~^[^\\0]*\\.($Rc)\$~",$C)){$h->error=lang(23,str_replace("|",", ",$Rc));return
false;}return
true;}function
create_database($m,$d){global$h;if(file_exists($m)){$h->error=lang(24);return
false;}if(!check_sqlite_name($m))return
false;try{$A=new
Min_SQLite($m);}catch(Exception$Hc){$h->error=$Hc->getMessage();return
false;}$A->query('PRAGMA encoding = "UTF-8"');$A->query('CREATE TABLE adminer (i)');$A->query('DROP TABLE adminer');return
true;}function
drop_databases($l){global$h;$h->__construct(":memory:");foreach($l
as$m){if(!@unlink($m)){$h->error=lang(24);return
false;}}return
true;}function
rename_database($C,$d){global$h;if(!check_sqlite_name($C))return
false;$h->__construct(":memory:");$h->error=lang(24);return@rename(DB,$C);}function
auto_increment(){return" PRIMARY KEY".(DRIVER=="sqlite"?" AUTOINCREMENT":"");}function
alter_table($R,$C,$q,$jd,$vb,$_c,$d,$Na,$cg){global$h;$Yi=($R==""||$jd);foreach($q
as$p){if($p[0]!=""||!$p[1]||$p[2]){$Yi=true;break;}}$c=array();$Qf=array();foreach($q
as$p){if($p[1]){$c[]=($Yi?$p[1]:"ADD ".implode($p[1]));if($p[0]!="")$Qf[$p[0]]=$p[1][0];}}if(!$Yi){foreach($c
as$X){if(!queries("ALTER TABLE ".table($R)." $X"))return
false;}if($R!=$C&&!queries("ALTER TABLE ".table($R)." RENAME TO ".table($C)))return
false;}elseif(!recreate_table($R,$C,$c,$Qf,$jd,$Na))return
false;if($Na){queries("BEGIN");queries("UPDATE sqlite_sequence SET seq = $Na WHERE name = ".q($C));if(!$h->affected_rows)queries("INSERT INTO sqlite_sequence (name, seq) VALUES (".q($C).", $Na)");queries("COMMIT");}return
true;}function
recreate_table($R,$C,$q,$Qf,$jd,$Na,$x=array()){global$h;if($R!=""){if(!$q){foreach(fields($R)as$z=>$p){if($x)$p["auto_increment"]=0;$q[]=process_field($p,$p);$Qf[$z]=idf_escape($z);}}$ug=false;foreach($q
as$p){if($p[6])$ug=true;}$nc=array();foreach($x
as$z=>$X){if($X[2]=="DROP"){$nc[$X[1]]=true;unset($x[$z]);}}foreach(indexes($R)as$ne=>$w){$f=array();foreach($w["columns"]as$z=>$e){if(!$Qf[$e])continue
2;$f[]=$Qf[$e].($w["descs"][$z]?" DESC":"");}if(!$nc[$ne]){if($w["type"]!="PRIMARY"||!$ug)$x[]=array($w["type"],$ne,$f);}}foreach($x
as$z=>$X){if($X[0]=="PRIMARY"){unset($x[$z]);$jd[]="  PRIMARY KEY (".implode(", ",$X[2]).")";}}foreach(foreign_keys($R)as$ne=>$r){foreach($r["source"]as$z=>$e){if(!$Qf[$e])continue
2;$r["source"][$z]=idf_unescape($Qf[$e]);}if(!isset($jd[" $ne"]))$jd[]=" ".format_foreign_key($r);}queries("BEGIN");}foreach($q
as$z=>$p)$q[$z]="  ".implode($p);$q=array_merge($q,array_filter($jd));$ii=($R==$C?"adminer_$C":$C);if(!queries("CREATE TABLE ".table($ii)." (\n".implode(",\n",$q)."\n)"))return
false;if($R!=""){if($Qf&&!queries("INSERT INTO ".table($ii)." (".implode(", ",$Qf).") SELECT ".implode(", ",array_map('idf_escape',array_keys($Qf)))." FROM ".table($R)))return
false;$Ii=array();foreach(triggers($R)as$Gi=>$pi){$Fi=trigger($Gi);$Ii[]="CREATE TRIGGER ".idf_escape($Gi)." ".implode(" ",$pi)." ON ".table($C)."\n$Fi[Statement]";}$Na=$Na?0:$h->result("SELECT seq FROM sqlite_sequence WHERE name = ".q($R));if(!queries("DROP TABLE ".table($R))||($R==$C&&!queries("ALTER TABLE ".table($ii)." RENAME TO ".table($C)))||!alter_indexes($C,$x))return
false;if($Na)queries("UPDATE sqlite_sequence SET seq = $Na WHERE name = ".q($C));foreach($Ii
as$Fi){if(!queries($Fi))return
false;}queries("COMMIT");}return
true;}function
index_sql($R,$U,$C,$f){return"CREATE $U ".($U!="INDEX"?"INDEX ":"").idf_escape($C!=""?$C:uniqid($R."_"))." ON ".table($R)." $f";}function
alter_indexes($R,$c){foreach($c
as$tg){if($tg[0]=="PRIMARY")return
recreate_table($R,$R,array(),array(),array(),0,$c);}foreach(array_reverse($c)as$X){if(!queries($X[2]=="DROP"?"DROP INDEX ".idf_escape($X[1]):index_sql($R,$X[0],$X[1],"(".implode(", ",$X[2]).")")))return
false;}return
true;}function
truncate_tables($T){return
apply_queries("DELETE FROM",$T);}function
drop_views($kj){return
apply_queries("DROP VIEW",$kj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
move_tables($T,$kj,$gi){return
false;}function
trigger($C){global$h;if($C=="")return
array("Statement"=>"BEGIN\n\t;\nEND");$v='(?:[^`"\s]+|`[^`]*`|"[^"]*")+';$Hi=trigger_options();preg_match("~^CREATE\\s+TRIGGER\\s*$v\\s*(".implode("|",$Hi["Timing"]).")\\s+([a-z]+)(?:\\s+OF\\s+($v))?\\s+ON\\s*$v\\s*(?:FOR\\s+EACH\\s+ROW\\s)?(.*)~is",$h->result("SELECT sql FROM sqlite_master WHERE type = 'trigger' AND name = ".q($C)),$B);$rf=$B[3];return
array("Timing"=>strtoupper($B[1]),"Event"=>strtoupper($B[2]).($rf?" OF":""),"Of"=>($rf[0]=='`'||$rf[0]=='"'?idf_unescape($rf):$rf),"Trigger"=>$C,"Statement"=>$B[4],);}function
triggers($R){$I=array();$Hi=trigger_options();foreach(get_rows("SELECT * FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R))as$J){preg_match('~^CREATE\s+TRIGGER\s*(?:[^`"\s]+|`[^`]*`|"[^"]*")+\s*('.implode("|",$Hi["Timing"]).')\s*(.*?)\s+ON\b~i',$J["sql"],$B);$I[$J["name"]]=array($B[1],$B[2]);}return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
begin(){return
queries("BEGIN");}function
last_id(){global$h;return$h->result("SELECT LAST_INSERT_ROWID()");}function
explain($h,$G){return$h->query("EXPLAIN QUERY PLAN $G");}function
found_rows($S,$Z){}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($kh){return
true;}function
create_sql($R,$Na,$Rh){global$h;$I=$h->result("SELECT sql FROM sqlite_master WHERE type IN ('table', 'view') AND name = ".q($R));foreach(indexes($R)as$C=>$w){if($C=='')continue;$I.=";\n\n".index_sql($R,$w['type'],$C,"(".implode(", ",array_map('idf_escape',$w['columns'])).")");}return$I;}function
truncate_sql($R){return"DELETE FROM ".table($R);}function
use_sql($k){}function
trigger_sql($R){return
implode(get_vals("SELECT sql || ';;\n' FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R)));}function
show_variables(){global$h;$I=array();foreach(array("auto_vacuum","cache_size","count_changes","default_cache_size","empty_result_callbacks","encoding","foreign_keys","full_column_names","fullfsync","journal_mode","journal_size_limit","legacy_file_format","locking_mode","page_size","max_page_count","read_uncommitted","recursive_triggers","reverse_unordered_selects","secure_delete","short_column_names","synchronous","temp_store","temp_store_directory","schema_version","integrity_check","quick_check")as$z)$I[$z]=$h->result("PRAGMA $z");return$I;}function
show_status(){$I=array();foreach(get_vals("PRAGMA compile_options")as$Ef){list($z,$X)=explode("=",$Ef,2);$I[$z]=$X;}return$I;}function
convert_field($p){}function
unconvert_field($p,$I){return$I;}function
support($Wc){return
preg_match('~^(columns|database|drop_col|dump|indexes|descidx|move_col|sql|status|table|trigger|variables|view|view_trigger)$~',$Wc);}$y="sqlite";$Li=array("integer"=>0,"real"=>0,"numeric"=>0,"text"=>0,"blob"=>0);$Qh=array_keys($Li);$Si=array();$Cf=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");$rd=array("hex","length","lower","round","unixepoch","upper");$xd=array("avg","count","count distinct","group_concat","max","min","sum");$sc=array(array(),array("integer|real|numeric"=>"+/-","text"=>"||",));}$kc["pgsql"]="PostgreSQL";if(isset($_GET["pgsql"])){$qg=array("PgSQL","PDO_PgSQL");define("DRIVER","pgsql");if(extension_loaded("pgsql")){class
Min_DB{var$extension="PgSQL",$_link,$_result,$_string,$_database=true,$server_info,$affected_rows,$error,$timeout;function
_error($Cc,$o){if(ini_bool("html_errors"))$o=html_entity_decode(strip_tags($o));$o=preg_replace('~^[^:]*: ~','',$o);$this->error=$o;}function
connect($N,$V,$F){global$b;$m=$b->database();set_error_handler(array($this,'_error'));$this->_string="host='".str_replace(":","' port='",addcslashes($N,"'\\"))."' user='".addcslashes($V,"'\\")."' password='".addcslashes($F,"'\\")."'";$this->_link=@pg_connect("$this->_string dbname='".($m!=""?addcslashes($m,"'\\"):"postgres")."'",PGSQL_CONNECT_FORCE_NEW);if(!$this->_link&&$m!=""){$this->_database=false;$this->_link=@pg_connect("$this->_string dbname='postgres'",PGSQL_CONNECT_FORCE_NEW);}restore_error_handler();if($this->_link){$ij=pg_version($this->_link);$this->server_info=$ij["server"];pg_set_client_encoding($this->_link,"UTF8");}return(bool)$this->_link;}function
quote($Q){return"'".pg_escape_string($this->_link,$Q)."'";}function
value($X,$p){return($p["type"]=="bytea"?pg_unescape_bytea($X):$X);}function
quoteBinary($Q){return"'".pg_escape_bytea($this->_link,$Q)."'";}function
select_db($k){global$b;if($k==$b->database())return$this->_database;$I=@pg_connect("$this->_string dbname='".addcslashes($k,"'\\")."'",PGSQL_CONNECT_FORCE_NEW);if($I)$this->_link=$I;return$I;}function
close(){$this->_link=@pg_connect("$this->_string dbname='postgres'");}function
query($G,$Mi=false){$H=@pg_query($this->_link,$G);$this->error="";if(!$H){$this->error=pg_last_error($this->_link);$I=false;}elseif(!pg_num_fields($H)){$this->affected_rows=pg_affected_rows($H);$I=true;}else$I=new
Min_Result($H);if($this->timeout){$this->timeout=0;$this->query("RESET statement_timeout");}return$I;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$p=0){$H=$this->query($G);if(!$H||!$H->num_rows)return
false;return
pg_fetch_result($H->_result,0,$p);}function
warnings(){return
h(pg_last_notice($this->_link));}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;$this->num_rows=pg_num_rows($H);}function
fetch_assoc(){return
pg_fetch_assoc($this->_result);}function
fetch_row(){return
pg_fetch_row($this->_result);}function
fetch_field(){$e=$this->_offset++;$I=new
stdClass;if(function_exists('pg_field_table'))$I->orgtable=pg_field_table($this->_result,$e);$I->name=pg_field_name($this->_result,$e);$I->orgname=$I->name;$I->type=pg_field_type($this->_result,$e);$I->charsetnr=($I->type=="bytea"?63:0);return$I;}function
__destruct(){pg_free_result($this->_result);}}}elseif(extension_loaded("pdo_pgsql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_PgSQL",$timeout;function
connect($N,$V,$F){global$b;$m=$b->database();$this->dsn("pgsql:host='".str_replace(":","' port='",addcslashes($N,"'\\"))."' client_encoding=utf8 dbname='".($m!=""?addcslashes($m,"'\\"):"postgres")."'",$V,$F);return
true;}function
select_db($k){global$b;return($b->database()==$k);}function
quoteBinary($hh){return
q($hh);}function
query($G,$Mi=false){$I=parent::query($G,$Mi);if($this->timeout){$this->timeout=0;parent::query("RESET statement_timeout");}return$I;}function
warnings(){return'';}function
close(){}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($R,$K,$tg){global$h;foreach($K
as$O){$Ti=array();$Z=array();foreach($O
as$z=>$X){$Ti[]="$z = $X";if(isset($tg[idf_unescape($z)]))$Z[]="$z = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$Ti)." WHERE ".implode(" AND ",$Z))&&$h->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
slowQuery($G,$oi){$this->_conn->query("SET statement_timeout = ".(1000*$oi));$this->_conn->timeout=1000*$oi;return$G;}function
convertSearch($v,$X,$p){return(preg_match('~char|text'.(!preg_match('~LIKE~',$X["op"])?'|date|time(stamp)?|boolean|uuid|'.number_type():'').'~',$p["type"])?$v:"CAST($v AS text)");}function
quoteBinary($hh){return$this->_conn->quoteBinary($hh);}function
warnings(){return$this->_conn->warnings();}function
tableHelp($C){$De=array("information_schema"=>"infoschema","pg_catalog"=>"catalog",);$A=$De[$_GET["ns"]];if($A)return"$A-".str_replace("_","-",$C).".html";}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
connect(){global$b,$Li,$Qh;$h=new
Min_DB;$Mb=$b->credentials();if($h->connect($Mb[0],$Mb[1],$Mb[2])){if(min_version(9,0,$h)){$h->query("SET application_name = 'Adminer'");if(min_version(9.2,0,$h)){$Qh[lang(25)][]="json";$Li["json"]=4294967295;if(min_version(9.4,0,$h)){$Qh[lang(25)][]="jsonb";$Li["jsonb"]=4294967295;}}}return$h;}return$h->error;}function
get_databases(){return
get_vals("SELECT datname FROM pg_database WHERE has_database_privilege(datname, 'CONNECT') ORDER BY datname");}function
limit($G,$Z,$_,$D=0,$M=" "){return" $G$Z".($_!==null?$M."LIMIT $_".($D?" OFFSET $D":""):"");}function
limit1($R,$G,$Z,$M="\n"){return(preg_match('~^INTO~',$G)?limit($G,$Z,1,0,$M):" $G".(is_view(table_status1($R))?$Z:" WHERE ctid = (SELECT ctid FROM ".table($R).$Z.$M."LIMIT 1)"));}function
db_collation($m,$qb){global$h;return$h->result("SELECT datcollate FROM pg_database WHERE datname = ".q($m));}function
engines(){return
array();}function
logged_user(){global$h;return$h->result("SELECT user");}function
tables_list(){$G="SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = current_schema()";if(support('materializedview'))$G.="
UNION ALL
SELECT matviewname, 'MATERIALIZED VIEW'
FROM pg_matviews
WHERE schemaname = current_schema()";$G.="
ORDER BY 1";return
get_key_vals($G);}function
count_tables($l){return
array();}function
table_status($C=""){$I=array();foreach(get_rows("SELECT c.relname AS \"Name\", CASE c.relkind WHEN 'r' THEN 'table' WHEN 'm' THEN 'materialized view' ELSE 'view' END AS \"Engine\", pg_relation_size(c.oid) AS \"Data_length\", pg_total_relation_size(c.oid) - pg_relation_size(c.oid) AS \"Index_length\", obj_description(c.oid, 'pg_class') AS \"Comment\", ".(min_version(12)?"''":"CASE WHEN c.relhasoids THEN 'oid' ELSE '' END")." AS \"Oid\", c.reltuples as \"Rows\", n.nspname
FROM pg_class c
JOIN pg_namespace n ON(n.nspname = current_schema() AND n.oid = c.relnamespace)
WHERE relkind IN ('r', 'm', 'v', 'f', 'p')
".($C!=""?"AND relname = ".q($C):"ORDER BY relname"))as$J)$I[$J["Name"]]=$J;return($C!=""?$I[$C]:$I);}function
is_view($S){return
in_array($S["Engine"],array("view","materialized view"));}function
fk_support($S){return
true;}function
fields($R){$I=array();$Da=array('timestamp without time zone'=>'timestamp','timestamp with time zone'=>'timestamptz',);$Kd=min_version(10)?'a.attidentity':'0';foreach(get_rows("SELECT a.attname AS field, format_type(a.atttypid, a.atttypmod) AS full_type, pg_get_expr(d.adbin, d.adrelid) AS default, a.attnotnull::int, col_description(c.oid, a.attnum) AS comment, $Kd AS identity
FROM pg_class c
JOIN pg_namespace n ON c.relnamespace = n.oid
JOIN pg_attribute a ON c.oid = a.attrelid
LEFT JOIN pg_attrdef d ON c.oid = d.adrelid AND a.attnum = d.adnum
WHERE c.relname = ".q($R)."
AND n.nspname = current_schema()
AND NOT a.attisdropped
AND a.attnum > 0
ORDER BY a.attnum")as$J){preg_match('~([^([]+)(\((.*)\))?([a-z ]+)?((\[[0-9]*])*)$~',$J["full_type"],$B);list(,$U,$Ae,$J["length"],$xa,$Ga)=$B;$J["length"].=$Ga;$fb=$U.$xa;if(isset($Da[$fb])){$J["type"]=$Da[$fb];$J["full_type"]=$J["type"].$Ae.$Ga;}else{$J["type"]=$U;$J["full_type"]=$J["type"].$Ae.$xa.$Ga;}if(in_array($J['identity'],array('a','d')))$J['default']='GENERATED '.($J['identity']=='d'?'BY DEFAULT':'ALWAYS').' AS IDENTITY';$J["null"]=!$J["attnotnull"];$J["auto_increment"]=$J['identity']||preg_match('~^nextval\(~i',$J["default"]);$J["privileges"]=array("insert"=>1,"select"=>1,"update"=>1);if(preg_match('~(.+)::[^)]+(.*)~',$J["default"],$B))$J["default"]=($B[1]=="NULL"?null:(($B[1][0]=="'"?idf_unescape($B[1]):$B[1]).$B[2]));$I[$J["field"]]=$J;}return$I;}function
indexes($R,$i=null){global$h;if(!is_object($i))$i=$h;$I=array();$Zh=$i->result("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($R));$f=get_key_vals("SELECT attnum, attname FROM pg_attribute WHERE attrelid = $Zh AND attnum > 0",$i);foreach(get_rows("SELECT relname, indisunique::int, indisprimary::int, indkey, indoption , (indpred IS NOT NULL)::int as indispartial FROM pg_index i, pg_class ci WHERE i.indrelid = $Zh AND ci.oid = i.indexrelid",$i)as$J){$Rg=$J["relname"];$I[$Rg]["type"]=($J["indispartial"]?"INDEX":($J["indisprimary"]?"PRIMARY":($J["indisunique"]?"UNIQUE":"INDEX")));$I[$Rg]["columns"]=array();foreach(explode(" ",$J["indkey"])as$Ud)$I[$Rg]["columns"][]=$f[$Ud];$I[$Rg]["descs"]=array();foreach(explode(" ",$J["indoption"])as$Vd)$I[$Rg]["descs"][]=($Vd&1?'1':null);$I[$Rg]["lengths"]=array();}return$I;}function
foreign_keys($R){global$yf;$I=array();foreach(get_rows("SELECT conname, condeferrable::int AS deferrable, pg_get_constraintdef(oid) AS definition
FROM pg_constraint
WHERE conrelid = (SELECT pc.oid FROM pg_class AS pc INNER JOIN pg_namespace AS pn ON (pn.oid = pc.relnamespace) WHERE pc.relname = ".q($R)." AND pn.nspname = current_schema())
AND contype = 'f'::char
ORDER BY conkey, conname")as$J){if(preg_match('~FOREIGN KEY\s*\((.+)\)\s*REFERENCES (.+)\((.+)\)(.*)$~iA',$J['definition'],$B)){$J['source']=array_map('trim',explode(',',$B[1]));if(preg_match('~^(("([^"]|"")+"|[^"]+)\.)?"?("([^"]|"")+"|[^"]+)$~',$B[2],$Ke)){$J['ns']=str_replace('""','"',preg_replace('~^"(.+)"$~','\1',$Ke[2]));$J['table']=str_replace('""','"',preg_replace('~^"(.+)"$~','\1',$Ke[4]));}$J['target']=array_map('trim',explode(',',$B[3]));$J['on_delete']=(preg_match("~ON DELETE ($yf)~",$B[4],$Ke)?$Ke[1]:'NO ACTION');$J['on_update']=(preg_match("~ON UPDATE ($yf)~",$B[4],$Ke)?$Ke[1]:'NO ACTION');$I[$J['conname']]=$J;}}return$I;}function
constraints($R){global$yf;$I=array();foreach(get_rows("SELECT conname, consrc
FROM pg_catalog.pg_constraint
INNER JOIN pg_catalog.pg_namespace ON pg_constraint.connamespace = pg_namespace.oid
INNER JOIN pg_catalog.pg_class ON pg_constraint.conrelid = pg_class.oid AND pg_constraint.connamespace = pg_class.relnamespace
WHERE pg_constraint.contype = 'c'
AND conrelid != 0 -- handle only CONSTRAINTs here, not TYPES
AND nspname = current_schema()
AND relname = ".q($R)."
ORDER BY connamespace, conname")as$J)$I[$J['conname']]=$J['consrc'];return$I;}function
view($C){global$h;return
array("select"=>trim($h->result("SELECT pg_get_viewdef(".$h->result("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($C)).")")));}function
collations(){return
array();}function
information_schema($m){return($m=="information_schema");}function
error(){global$h;$I=h($h->error);if(preg_match('~^(.*\n)?([^\n]*)\n( *)\^(\n.*)?$~s',$I,$B))$I=$B[1].preg_replace('~((?:[^&]|&[^;]*;){'.strlen($B[3]).'})(.*)~','\1<b>\2</b>',$B[2]).$B[4];return
nl_br($I);}function
create_database($m,$d){return
queries("CREATE DATABASE ".idf_escape($m).($d?" ENCODING ".idf_escape($d):""));}function
drop_databases($l){global$h;$h->close();return
apply_queries("DROP DATABASE",$l,'idf_escape');}function
rename_database($C,$d){return
queries("ALTER DATABASE ".idf_escape(DB)." RENAME TO ".idf_escape($C));}function
auto_increment(){return(min_version(11)?" PRIMARY KEY":"");}function
alter_table($R,$C,$q,$jd,$vb,$_c,$d,$Na,$cg){$c=array();$Dg=array();if($R!=""&&$R!=$C)$Dg[]="ALTER TABLE ".table($R)." RENAME TO ".table($C);foreach($q
as$p){$e=idf_escape($p[0]);$X=$p[1];if(!$X)$c[]="DROP $e";else{$ej=$X[5];unset($X[5]);if(isset($X[6])&&$p[0]=="")$X[1]=($X[1]==" bigint"?" big":($X[1]==" smallint"?" small":" "))."serial";if($p[0]=="")$c[]=($R!=""?"ADD ":"  ").implode($X);else{if($e!=$X[0])$Dg[]="ALTER TABLE ".table($C)." RENAME $e TO $X[0]";$c[]="ALTER $e TYPE$X[1]";if(!$X[6]){$c[]="ALTER $e ".($X[3]?"SET$X[3]":"DROP DEFAULT");$c[]="ALTER $e ".($X[2]==" NULL"?"DROP NOT":"SET").$X[2];}}if($p[0]!=""||$ej!="")$Dg[]="COMMENT ON COLUMN ".table($C).".$X[0] IS ".($ej!=""?substr($ej,9):"''");}}$c=array_merge($c,$jd);if($R=="")array_unshift($Dg,"CREATE TABLE ".table($C)." (\n".implode(",\n",$c)."\n)");elseif($c)array_unshift($Dg,"ALTER TABLE ".table($R)."\n".implode(",\n",$c));if($R!=""||$vb!="")$Dg[]="COMMENT ON TABLE ".table($C)." IS ".q($vb);if($Na!=""){}foreach($Dg
as$G){if(!queries($G))return
false;}return
true;}function
alter_indexes($R,$c){$j=array();$lc=array();$Dg=array();foreach($c
as$X){if($X[0]!="INDEX")$j[]=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");elseif($X[2]=="DROP")$lc[]=idf_escape($X[1]);else$Dg[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R)." (".implode(", ",$X[2]).")";}if($j)array_unshift($Dg,"ALTER TABLE ".table($R).implode(",",$j));if($lc)array_unshift($Dg,"DROP INDEX ".implode(", ",$lc));foreach($Dg
as$G){if(!queries($G))return
false;}return
true;}function
truncate_tables($T){return
queries("TRUNCATE ".implode(", ",array_map('table',$T)));return
true;}function
drop_views($kj){return
drop_tables($kj);}function
drop_tables($T){foreach($T
as$R){$P=table_status($R);if(!queries("DROP ".strtoupper($P["Engine"])." ".table($R)))return
false;}return
true;}function
move_tables($T,$kj,$gi){foreach(array_merge($T,$kj)as$R){$P=table_status($R);if(!queries("ALTER ".strtoupper($P["Engine"])." ".table($R)." SET SCHEMA ".idf_escape($gi)))return
false;}return
true;}function
trigger($C,$R=null){if($C=="")return
array("Statement"=>"EXECUTE PROCEDURE ()");if($R===null)$R=$_GET['trigger'];$K=get_rows('SELECT t.trigger_name AS "Trigger", t.action_timing AS "Timing", (SELECT STRING_AGG(event_manipulation, \' OR \') FROM information_schema.triggers WHERE event_object_table = t.event_object_table AND trigger_name = t.trigger_name ) AS "Events", t.event_manipulation AS "Event", \'FOR EACH \' || t.action_orientation AS "Type", t.action_statement AS "Statement" FROM information_schema.triggers t WHERE t.event_object_table = '.q($R).' AND t.trigger_name = '.q($C));return
reset($K);}function
triggers($R){$I=array();foreach(get_rows("SELECT * FROM information_schema.triggers WHERE event_object_table = ".q($R))as$J)$I[$J["trigger_name"]]=array($J["action_timing"],$J["event_manipulation"]);return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW","FOR EACH STATEMENT"),);}function
routine($C,$U){$K=get_rows('SELECT routine_definition AS definition, LOWER(external_language) AS language, *
FROM information_schema.routines
WHERE routine_schema = current_schema() AND specific_name = '.q($C));$I=$K[0];$I["returns"]=array("type"=>$I["type_udt_name"]);$I["fields"]=get_rows('SELECT parameter_name AS field, data_type AS type, character_maximum_length AS length, parameter_mode AS inout
FROM information_schema.parameters
WHERE specific_schema = current_schema() AND specific_name = '.q($C).'
ORDER BY ordinal_position');return$I;}function
routines(){return
get_rows('SELECT specific_name AS "SPECIFIC_NAME", routine_type AS "ROUTINE_TYPE", routine_name AS "ROUTINE_NAME", type_udt_name AS "DTD_IDENTIFIER"
FROM information_schema.routines
WHERE routine_schema = current_schema()
ORDER BY SPECIFIC_NAME');}function
routine_languages(){return
get_vals("SELECT LOWER(lanname) FROM pg_catalog.pg_language");}function
routine_id($C,$J){$I=array();foreach($J["fields"]as$p)$I[]=$p["type"];return
idf_escape($C)."(".implode(", ",$I).")";}function
last_id(){return
0;}function
explain($h,$G){return$h->query("EXPLAIN $G");}function
found_rows($S,$Z){global$h;if(preg_match("~ rows=([0-9]+)~",$h->result("EXPLAIN SELECT * FROM ".idf_escape($S["Name"]).($Z?" WHERE ".implode(" AND ",$Z):"")),$Qg))return$Qg[1];return
false;}function
types(){return
get_vals("SELECT typname
FROM pg_type
WHERE typnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema())
AND typtype IN ('b','d','e')
AND typelem = 0");}function
schemas(){return
get_vals("SELECT nspname FROM pg_namespace ORDER BY nspname");}function
get_schema(){global$h;return$h->result("SELECT current_schema()");}function
set_schema($jh,$i=null){global$h,$Li,$Qh;if(!$i)$i=$h;$I=$i->query("SET search_path TO ".idf_escape($jh));foreach(types()as$U){if(!isset($Li[$U])){$Li[$U]=0;$Qh[lang(26)][]=$U;}}return$I;}function
foreign_keys_sql($R){$I="";$P=table_status($R);$gd=foreign_keys($R);ksort($gd);foreach($gd
as$fd=>$ed)$I.="ALTER TABLE ONLY ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." ADD CONSTRAINT ".idf_escape($fd)." $ed[definition] ".($ed['deferrable']?'DEFERRABLE':'NOT DEFERRABLE').";\n";return($I?"$I\n":$I);}function
create_sql($R,$Na,$Rh){global$h;$I='';$Zg=array();$th=array();$P=table_status($R);if(is_view($P)){$jj=view($R);return
rtrim("CREATE VIEW ".idf_escape($R)." AS $jj[select]",";");}$q=fields($R);$x=indexes($R);ksort($x);$Db=constraints($R);if(!$P||empty($q))return
false;$I="CREATE TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." (\n    ";foreach($q
as$Yc=>$p){$Zf=idf_escape($p['field']).' '.$p['full_type'].default_value($p).($p['attnotnull']?" NOT NULL":"");$Zg[]=$Zf;if(preg_match('~nextval\(\'([^\']+)\'\)~',$p['default'],$Le)){$sh=$Le[1];$Gh=reset(get_rows(min_version(10)?"SELECT *, cache_size AS cache_value FROM pg_sequences WHERE schemaname = current_schema() AND sequencename = ".q($sh):"SELECT * FROM $sh"));$th[]=($Rh=="DROP+CREATE"?"DROP SEQUENCE IF EXISTS $sh;\n":"")."CREATE SEQUENCE $sh INCREMENT $Gh[increment_by] MINVALUE $Gh[min_value] MAXVALUE $Gh[max_value] START ".($Na?$Gh['last_value']:1)." CACHE $Gh[cache_value];";}}if(!empty($th))$I=implode("\n\n",$th)."\n\n$I";foreach($x
as$Pd=>$w){switch($w['type']){case'UNIQUE':$Zg[]="CONSTRAINT ".idf_escape($Pd)." UNIQUE (".implode(', ',array_map('idf_escape',$w['columns'])).")";break;case'PRIMARY':$Zg[]="CONSTRAINT ".idf_escape($Pd)." PRIMARY KEY (".implode(', ',array_map('idf_escape',$w['columns'])).")";break;}}foreach($Db
as$_b=>$Bb)$Zg[]="CONSTRAINT ".idf_escape($_b)." CHECK $Bb";$I.=implode(",\n    ",$Zg)."\n) WITH (oids = ".($P['Oid']?'true':'false').");";foreach($x
as$Pd=>$w){if($w['type']=='INDEX'){$f=array();foreach($w['columns']as$z=>$X)$f[]=idf_escape($X).($w['descs'][$z]?" DESC":"");$I.="\n\nCREATE INDEX ".idf_escape($Pd)." ON ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." USING btree (".implode(', ',$f).");";}}if($P['Comment'])$I.="\n\nCOMMENT ON TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." IS ".q($P['Comment']).";";foreach($q
as$Yc=>$p){if($p['comment'])$I.="\n\nCOMMENT ON COLUMN ".idf_escape($P['nspname']).".".idf_escape($P['Name']).".".idf_escape($Yc)." IS ".q($p['comment']).";";}return
rtrim($I,';');}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
trigger_sql($R){$P=table_status($R);$I="";foreach(triggers($R)as$Ei=>$Di){$Fi=trigger($Ei,$P['Name']);$I.="\nCREATE TRIGGER ".idf_escape($Fi['Trigger'])." $Fi[Timing] $Fi[Events] ON ".idf_escape($P["nspname"]).".".idf_escape($P['Name'])." $Fi[Type] $Fi[Statement];;\n";}return$I;}function
use_sql($k){return"\connect ".idf_escape($k);}function
show_variables(){return
get_key_vals("SHOW ALL");}function
process_list(){return
get_rows("SELECT * FROM pg_stat_activity ORDER BY ".(min_version(9.2)?"pid":"procpid"));}function
show_status(){}function
convert_field($p){}function
unconvert_field($p,$I){return$I;}function
support($Wc){return
preg_match('~^(database|table|columns|sql|indexes|descidx|comment|view|'.(min_version(9.3)?'materializedview|':'').'scheme|routine|processlist|sequence|trigger|type|variables|drop_col|kill|dump)$~',$Wc);}function
kill_process($X){return
queries("SELECT pg_terminate_backend(".number($X).")");}function
connection_id(){return"SELECT pg_backend_pid()";}function
max_connections(){global$h;return$h->result("SHOW max_connections");}$y="pgsql";$Li=array();$Qh=array();foreach(array(lang(27)=>array("smallint"=>5,"integer"=>10,"bigint"=>19,"boolean"=>1,"numeric"=>0,"real"=>7,"double precision"=>16,"money"=>20),lang(28)=>array("date"=>13,"time"=>17,"timestamp"=>20,"timestamptz"=>21,"interval"=>0),lang(25)=>array("character"=>0,"character varying"=>0,"text"=>0,"tsquery"=>0,"tsvector"=>0,"uuid"=>0,"xml"=>0),lang(29)=>array("bit"=>0,"bit varying"=>0,"bytea"=>0),lang(30)=>array("cidr"=>43,"inet"=>43,"macaddr"=>17,"txid_snapshot"=>0),lang(31)=>array("box"=>0,"circle"=>0,"line"=>0,"lseg"=>0,"path"=>0,"point"=>0,"polygon"=>0),)as$z=>$X){$Li+=$X;$Qh[$z]=array_keys($X);}$Si=array();$Cf=array("=","<",">","<=",">=","!=","~","!~","LIKE","LIKE %%","ILIKE","ILIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL");$rd=array("char_length","lower","round","to_hex","to_timestamp","upper");$xd=array("avg","count","count distinct","max","min","sum");$sc=array(array("char"=>"md5","date|time"=>"now",),array(number_type()=>"+/-","date|time"=>"+ interval/- interval","char|text"=>"||",));}$kc["oracle"]="Oracle (beta)";if(isset($_GET["oracle"])){$qg=array("OCI8","PDO_OCI");define("DRIVER","oracle");if(extension_loaded("oci8")){class
Min_DB{var$extension="oci8",$_link,$_result,$server_info,$affected_rows,$errno,$error;function
_error($Cc,$o){if(ini_bool("html_errors"))$o=html_entity_decode(strip_tags($o));$o=preg_replace('~^[^:]*: ~','',$o);$this->error=$o;}function
connect($N,$V,$F){$this->_link=@oci_new_connect($V,$F,$N,"AL32UTF8");if($this->_link){$this->server_info=oci_server_version($this->_link);return
true;}$o=oci_error();$this->error=$o["message"];return
false;}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($k){return
true;}function
query($G,$Mi=false){$H=oci_parse($this->_link,$G);$this->error="";if(!$H){$o=oci_error($this->_link);$this->errno=$o["code"];$this->error=$o["message"];return
false;}set_error_handler(array($this,'_error'));$I=@oci_execute($H);restore_error_handler();if($I){if(oci_num_fields($H))return
new
Min_Result($H);$this->affected_rows=oci_num_rows($H);}return$I;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$p=1){$H=$this->query($G);if(!is_object($H)||!oci_fetch($H->_result))return
false;return
oci_result($H->_result,$p);}}class
Min_Result{var$_result,$_offset=1,$num_rows;function
__construct($H){$this->_result=$H;}function
_convert($J){foreach((array)$J
as$z=>$X){if(is_a($X,'OCI-Lob'))$J[$z]=$X->load();}return$J;}function
fetch_assoc(){return$this->_convert(oci_fetch_assoc($this->_result));}function
fetch_row(){return$this->_convert(oci_fetch_row($this->_result));}function
fetch_field(){$e=$this->_offset++;$I=new
stdClass;$I->name=oci_field_name($this->_result,$e);$I->orgname=$I->name;$I->type=oci_field_type($this->_result,$e);$I->charsetnr=(preg_match("~raw|blob|bfile~",$I->type)?63:0);return$I;}function
__destruct(){oci_free_statement($this->_result);}}}elseif(extension_loaded("pdo_oci")){class
Min_DB
extends
Min_PDO{var$extension="PDO_OCI";function
connect($N,$V,$F){$this->dsn("oci:dbname=//$N;charset=AL32UTF8",$V,$F);return
true;}function
select_db($k){return
true;}}}class
Min_Driver
extends
Min_SQL{function
begin(){return
true;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
connect(){global$b;$h=new
Min_DB;$Mb=$b->credentials();if($h->connect($Mb[0],$Mb[1],$Mb[2]))return$h;return$h->error;}function
get_databases(){return
get_vals("SELECT tablespace_name FROM user_tablespaces");}function
limit($G,$Z,$_,$D=0,$M=" "){return($D?" * FROM (SELECT t.*, rownum AS rnum FROM (SELECT $G$Z) t WHERE rownum <= ".($_+$D).") WHERE rnum > $D":($_!==null?" * FROM (SELECT $G$Z) WHERE rownum <= ".($_+$D):" $G$Z"));}function
limit1($R,$G,$Z,$M="\n"){return" $G$Z";}function
db_collation($m,$qb){global$h;return$h->result("SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'");}function
engines(){return
array();}function
logged_user(){global$h;return$h->result("SELECT USER FROM DUAL");}function
tables_list(){return
get_key_vals("SELECT table_name, 'table' FROM all_tables WHERE tablespace_name = ".q(DB)."
UNION SELECT view_name, 'view' FROM user_views
ORDER BY 1");}function
count_tables($l){return
array();}function
table_status($C=""){$I=array();$lh=q($C);foreach(get_rows('SELECT table_name "Name", \'table\' "Engine", avg_row_len * num_rows "Data_length", num_rows "Rows" FROM all_tables WHERE tablespace_name = '.q(DB).($C!=""?" AND table_name = $lh":"")."
UNION SELECT view_name, 'view', 0, 0 FROM user_views".($C!=""?" WHERE view_name = $lh":"")."
ORDER BY 1")as$J){if($C!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return
true;}function
fields($R){$I=array();foreach(get_rows("SELECT * FROM all_tab_columns WHERE table_name = ".q($R)." ORDER BY column_id")as$J){$U=$J["DATA_TYPE"];$Ae="$J[DATA_PRECISION],$J[DATA_SCALE]";if($Ae==",")$Ae=$J["DATA_LENGTH"];$I[$J["COLUMN_NAME"]]=array("field"=>$J["COLUMN_NAME"],"full_type"=>$U.($Ae?"($Ae)":""),"type"=>strtolower($U),"length"=>$Ae,"default"=>$J["DATA_DEFAULT"],"null"=>($J["NULLABLE"]=="Y"),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),);}return$I;}function
indexes($R,$i=null){$I=array();foreach(get_rows("SELECT uic.*, uc.constraint_type
FROM user_ind_columns uic
LEFT JOIN user_constraints uc ON uic.index_name = uc.constraint_name AND uic.table_name = uc.table_name
WHERE uic.table_name = ".q($R)."
ORDER BY uc.constraint_type, uic.column_position",$i)as$J){$Pd=$J["INDEX_NAME"];$I[$Pd]["type"]=($J["CONSTRAINT_TYPE"]=="P"?"PRIMARY":($J["CONSTRAINT_TYPE"]=="U"?"UNIQUE":"INDEX"));$I[$Pd]["columns"][]=$J["COLUMN_NAME"];$I[$Pd]["lengths"][]=($J["CHAR_LENGTH"]&&$J["CHAR_LENGTH"]!=$J["COLUMN_LENGTH"]?$J["CHAR_LENGTH"]:null);$I[$Pd]["descs"][]=($J["DESCEND"]?'1':null);}return$I;}function
view($C){$K=get_rows('SELECT text "select" FROM user_views WHERE view_name = '.q($C));return
reset($K);}function
collations(){return
array();}function
information_schema($m){return
false;}function
error(){global$h;return
h($h->error);}function
explain($h,$G){$h->query("EXPLAIN PLAN FOR $G");return$h->query("SELECT * FROM plan_table");}function
found_rows($S,$Z){}function
alter_table($R,$C,$q,$jd,$vb,$_c,$d,$Na,$cg){$c=$lc=array();foreach($q
as$p){$X=$p[1];if($X&&$p[0]!=""&&idf_escape($p[0])!=$X[0])queries("ALTER TABLE ".table($R)." RENAME COLUMN ".idf_escape($p[0])." TO $X[0]");if($X)$c[]=($R!=""?($p[0]!=""?"MODIFY (":"ADD ("):"  ").implode($X).($R!=""?")":"");else$lc[]=idf_escape($p[0]);}if($R=="")return
queries("CREATE TABLE ".table($C)." (\n".implode(",\n",$c)."\n)");return(!$c||queries("ALTER TABLE ".table($R)."\n".implode("\n",$c)))&&(!$lc||queries("ALTER TABLE ".table($R)." DROP (".implode(", ",$lc).")"))&&($R==$C||queries("ALTER TABLE ".table($R)." RENAME TO ".table($C)));}function
foreign_keys($R){$I=array();$G="SELECT c_list.CONSTRAINT_NAME as NAME,
c_src.COLUMN_NAME as SRC_COLUMN,
c_dest.OWNER as DEST_DB,
c_dest.TABLE_NAME as DEST_TABLE,
c_dest.COLUMN_NAME as DEST_COLUMN,
c_list.DELETE_RULE as ON_DELETE
FROM ALL_CONSTRAINTS c_list, ALL_CONS_COLUMNS c_src, ALL_CONS_COLUMNS c_dest
WHERE c_list.CONSTRAINT_NAME = c_src.CONSTRAINT_NAME
AND c_list.R_CONSTRAINT_NAME = c_dest.CONSTRAINT_NAME
AND c_list.CONSTRAINT_TYPE = 'R'
AND c_src.TABLE_NAME = ".q($R);foreach(get_rows($G)as$J)$I[$J['NAME']]=array("db"=>$J['DEST_DB'],"table"=>$J['DEST_TABLE'],"source"=>array($J['SRC_COLUMN']),"target"=>array($J['DEST_COLUMN']),"on_delete"=>$J['ON_DELETE'],"on_update"=>null,);return$I;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($kj){return
apply_queries("DROP VIEW",$kj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
last_id(){return
0;}function
schemas(){return
get_vals("SELECT DISTINCT owner FROM dba_segments WHERE owner IN (SELECT username FROM dba_users WHERE default_tablespace NOT IN ('SYSTEM','SYSAUX'))");}function
get_schema(){global$h;return$h->result("SELECT sys_context('USERENV', 'SESSION_USER') FROM dual");}function
set_schema($kh,$i=null){global$h;if(!$i)$i=$h;return$i->query("ALTER SESSION SET CURRENT_SCHEMA = ".idf_escape($kh));}function
show_variables(){return
get_key_vals('SELECT name, display_value FROM v$parameter');}function
process_list(){return
get_rows('SELECT sess.process AS "process", sess.username AS "user", sess.schemaname AS "schema", sess.status AS "status", sess.wait_class AS "wait_class", sess.seconds_in_wait AS "seconds_in_wait", sql.sql_text AS "sql_text", sess.machine AS "machine", sess.port AS "port"
FROM v$session sess LEFT OUTER JOIN v$sql sql
ON sql.sql_id = sess.sql_id
WHERE sess.type = \'USER\'
ORDER BY PROCESS
');}function
show_status(){$K=get_rows('SELECT * FROM v$instance');return
reset($K);}function
convert_field($p){}function
unconvert_field($p,$I){return$I;}function
support($Wc){return
preg_match('~^(columns|database|drop_col|indexes|descidx|processlist|scheme|sql|status|table|variables|view|view_trigger)$~',$Wc);}$y="oracle";$Li=array();$Qh=array();foreach(array(lang(27)=>array("number"=>38,"binary_float"=>12,"binary_double"=>21),lang(28)=>array("date"=>10,"timestamp"=>29,"interval year"=>12,"interval day"=>28),lang(25)=>array("char"=>2000,"varchar2"=>4000,"nchar"=>2000,"nvarchar2"=>4000,"clob"=>4294967295,"nclob"=>4294967295),lang(29)=>array("raw"=>2000,"long raw"=>2147483648,"blob"=>4294967295,"bfile"=>4294967296),)as$z=>$X){$Li+=$X;$Qh[$z]=array_keys($X);}$Si=array();$Cf=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");$rd=array("length","lower","round","upper");$xd=array("avg","count","count distinct","max","min","sum");$sc=array(array("date"=>"current_date","timestamp"=>"current_timestamp",),array("number|float|double"=>"+/-","date|timestamp"=>"+ interval/- interval","char|clob"=>"||",));}$kc["mssql"]="MS SQL (beta)";if(isset($_GET["mssql"])){$qg=array("SQLSRV","MSSQL","PDO_DBLIB");define("DRIVER","mssql");if(extension_loaded("sqlsrv")){class
Min_DB{var$extension="sqlsrv",$_link,$_result,$server_info,$affected_rows,$errno,$error;function
_get_error(){$this->error="";foreach(sqlsrv_errors()as$o){$this->errno=$o["code"];$this->error.="$o[message]\n";}$this->error=rtrim($this->error);}function
connect($N,$V,$F){global$b;$m=$b->database();$Ab=array("UID"=>$V,"PWD"=>$F,"CharacterSet"=>"UTF-8");if($m!="")$Ab["Database"]=$m;$this->_link=@sqlsrv_connect(preg_replace('~:~',',',$N),$Ab);if($this->_link){$Wd=sqlsrv_server_info($this->_link);$this->server_info=$Wd['SQLServerVersion'];}else$this->_get_error();return(bool)$this->_link;}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($k){return$this->query("USE ".idf_escape($k));}function
query($G,$Mi=false){$H=sqlsrv_query($this->_link,$G);$this->error="";if(!$H){$this->_get_error();return
false;}return$this->store_result($H);}function
multi_query($G){$this->_result=sqlsrv_query($this->_link,$G);$this->error="";if(!$this->_result){$this->_get_error();return
false;}return
true;}function
store_result($H=null){if(!$H)$H=$this->_result;if(!$H)return
false;if(sqlsrv_field_metadata($H))return
new
Min_Result($H);$this->affected_rows=sqlsrv_rows_affected($H);return
true;}function
next_result(){return$this->_result?sqlsrv_next_result($this->_result):null;}function
result($G,$p=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->fetch_row();return$J[$p];}}class
Min_Result{var$_result,$_offset=0,$_fields,$num_rows;function
__construct($H){$this->_result=$H;}function
_convert($J){foreach((array)$J
as$z=>$X){if(is_a($X,'DateTime'))$J[$z]=$X->format("Y-m-d H:i:s");}return$J;}function
fetch_assoc(){return$this->_convert(sqlsrv_fetch_array($this->_result,SQLSRV_FETCH_ASSOC));}function
fetch_row(){return$this->_convert(sqlsrv_fetch_array($this->_result,SQLSRV_FETCH_NUMERIC));}function
fetch_field(){if(!$this->_fields)$this->_fields=sqlsrv_field_metadata($this->_result);$p=$this->_fields[$this->_offset++];$I=new
stdClass;$I->name=$p["Name"];$I->orgname=$p["Name"];$I->type=($p["Type"]==1?254:0);return$I;}function
seek($D){for($t=0;$t<$D;$t++)sqlsrv_fetch($this->_result);}function
__destruct(){sqlsrv_free_stmt($this->_result);}}}elseif(extension_loaded("mssql")){class
Min_DB{var$extension="MSSQL",$_link,$_result,$server_info,$affected_rows,$error;function
connect($N,$V,$F){$this->_link=@mssql_connect($N,$V,$F);if($this->_link){$H=$this->query("SELECT SERVERPROPERTY('ProductLevel'), SERVERPROPERTY('Edition')");if($H){$J=$H->fetch_row();$this->server_info=$this->result("sp_server_info 2",2)." [$J[0]] $J[1]";}}else$this->error=mssql_get_last_message();return(bool)$this->_link;}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($k){return
mssql_select_db($k);}function
query($G,$Mi=false){$H=@mssql_query($G,$this->_link);$this->error="";if(!$H){$this->error=mssql_get_last_message();return
false;}if($H===true){$this->affected_rows=mssql_rows_affected($this->_link);return
true;}return
new
Min_Result($H);}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
mssql_next_result($this->_result->_result);}function
result($G,$p=0){$H=$this->query($G);if(!is_object($H))return
false;return
mssql_result($H->_result,0,$p);}}class
Min_Result{var$_result,$_offset=0,$_fields,$num_rows;function
__construct($H){$this->_result=$H;$this->num_rows=mssql_num_rows($H);}function
fetch_assoc(){return
mssql_fetch_assoc($this->_result);}function
fetch_row(){return
mssql_fetch_row($this->_result);}function
num_rows(){return
mssql_num_rows($this->_result);}function
fetch_field(){$I=mssql_fetch_field($this->_result);$I->orgtable=$I->table;$I->orgname=$I->name;return$I;}function
seek($D){mssql_data_seek($this->_result,$D);}function
__destruct(){mssql_free_result($this->_result);}}}elseif(extension_loaded("pdo_dblib")){class
Min_DB
extends
Min_PDO{var$extension="PDO_DBLIB";function
connect($N,$V,$F){$this->dsn("dblib:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$N)),$V,$F);return
true;}function
select_db($k){return$this->query("USE ".idf_escape($k));}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($R,$K,$tg){foreach($K
as$O){$Ti=array();$Z=array();foreach($O
as$z=>$X){$Ti[]="$z = $X";if(isset($tg[idf_unescape($z)]))$Z[]="$z = $X";}if(!queries("MERGE ".table($R)." USING (VALUES(".implode(", ",$O).")) AS source (c".implode(", c",range(1,count($O))).") ON ".implode(" AND ",$Z)." WHEN MATCHED THEN UPDATE SET ".implode(", ",$Ti)." WHEN NOT MATCHED THEN INSERT (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).");"))return
false;}return
true;}function
begin(){return
queries("BEGIN TRANSACTION");}}function
idf_escape($v){return"[".str_replace("]","]]",$v)."]";}function
table($v){return($_GET["ns"]!=""?idf_escape($_GET["ns"]).".":"").idf_escape($v);}function
connect(){global$b;$h=new
Min_DB;$Mb=$b->credentials();if($h->connect($Mb[0],$Mb[1],$Mb[2]))return$h;return$h->error;}function
get_databases(){return
get_vals("SELECT name FROM sys.databases WHERE name NOT IN ('master', 'tempdb', 'model', 'msdb')");}function
limit($G,$Z,$_,$D=0,$M=" "){return($_!==null?" TOP (".($_+$D).")":"")." $G$Z";}function
limit1($R,$G,$Z,$M="\n"){return
limit($G,$Z,1,0,$M);}function
db_collation($m,$qb){global$h;return$h->result("SELECT collation_name FROM sys.databases WHERE name = ".q($m));}function
engines(){return
array();}function
logged_user(){global$h;return$h->result("SELECT SUSER_NAME()");}function
tables_list(){return
get_key_vals("SELECT name, type_desc FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ORDER BY name");}function
count_tables($l){global$h;$I=array();foreach($l
as$m){$h->select_db($m);$I[$m]=$h->result("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");}return$I;}function
table_status($C=""){$I=array();foreach(get_rows("SELECT ao.name AS Name, ao.type_desc AS Engine, (SELECT value FROM fn_listextendedproperty(default, 'SCHEMA', schema_name(schema_id), 'TABLE', ao.name, null, null)) AS Comment FROM sys.all_objects AS ao WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ".($C!=""?"AND name = ".q($C):"ORDER BY name"))as$J){if($C!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($S){return$S["Engine"]=="VIEW";}function
fk_support($S){return
true;}function
fields($R){$xb=get_key_vals("SELECT objname, cast(value as varchar(max)) FROM fn_listextendedproperty('MS_DESCRIPTION', 'schema', ".q(get_schema()).", 'table', ".q($R).", 'column', NULL)");$I=array();foreach(get_rows("SELECT c.max_length, c.precision, c.scale, c.name, c.is_nullable, c.is_identity, c.collation_name, t.name type, CAST(d.definition as text) [default]
FROM sys.all_columns c
JOIN sys.all_objects o ON c.object_id = o.object_id
JOIN sys.types t ON c.user_type_id = t.user_type_id
LEFT JOIN sys.default_constraints d ON c.default_object_id = d.parent_column_id
WHERE o.schema_id = SCHEMA_ID(".q(get_schema()).") AND o.type IN ('S', 'U', 'V') AND o.name = ".q($R))as$J){$U=$J["type"];$Ae=(preg_match("~char|binary~",$U)?$J["max_length"]:($U=="decimal"?"$J[precision],$J[scale]":""));$I[$J["name"]]=array("field"=>$J["name"],"full_type"=>$U.($Ae?"($Ae)":""),"type"=>$U,"length"=>$Ae,"default"=>$J["default"],"null"=>$J["is_nullable"],"auto_increment"=>$J["is_identity"],"collation"=>$J["collation_name"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),"primary"=>$J["is_identity"],"comment"=>$xb[$J["name"]],);}return$I;}function
indexes($R,$i=null){$I=array();foreach(get_rows("SELECT i.name, key_ordinal, is_unique, is_primary_key, c.name AS column_name, is_descending_key
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE OBJECT_NAME(i.object_id) = ".q($R),$i)as$J){$C=$J["name"];$I[$C]["type"]=($J["is_primary_key"]?"PRIMARY":($J["is_unique"]?"UNIQUE":"INDEX"));$I[$C]["lengths"]=array();$I[$C]["columns"][$J["key_ordinal"]]=$J["column_name"];$I[$C]["descs"][$J["key_ordinal"]]=($J["is_descending_key"]?'1':null);}return$I;}function
view($C){global$h;return
array("select"=>preg_replace('~^(?:[^[]|\[[^]]*])*\s+AS\s+~isU','',$h->result("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = SCHEMA_NAME() AND TABLE_NAME = ".q($C))));}function
collations(){$I=array();foreach(get_vals("SELECT name FROM fn_helpcollations()")as$d)$I[preg_replace('~_.*~','',$d)][]=$d;return$I;}function
information_schema($m){return
false;}function
error(){global$h;return
nl_br(h(preg_replace('~^(\[[^]]*])+~m','',$h->error)));}function
create_database($m,$d){return
queries("CREATE DATABASE ".idf_escape($m).(preg_match('~^[a-z0-9_]+$~i',$d)?" COLLATE $d":""));}function
drop_databases($l){return
queries("DROP DATABASE ".implode(", ",array_map('idf_escape',$l)));}function
rename_database($C,$d){if(preg_match('~^[a-z0-9_]+$~i',$d))queries("ALTER DATABASE ".idf_escape(DB)." COLLATE $d");queries("ALTER DATABASE ".idf_escape(DB)." MODIFY NAME = ".idf_escape($C));return
true;}function
auto_increment(){return" IDENTITY".($_POST["Auto_increment"]!=""?"(".number($_POST["Auto_increment"]).",1)":"")." PRIMARY KEY";}function
alter_table($R,$C,$q,$jd,$vb,$_c,$d,$Na,$cg){$c=array();$xb=array();foreach($q
as$p){$e=idf_escape($p[0]);$X=$p[1];if(!$X)$c["DROP"][]=" COLUMN $e";else{$X[1]=preg_replace("~( COLLATE )'(\\w+)'~",'\1\2',$X[1]);$xb[$p[0]]=$X[5];unset($X[5]);if($p[0]=="")$c["ADD"][]="\n  ".implode("",$X).($R==""?substr($jd[$X[0]],16+strlen($X[0])):"");else{unset($X[6]);if($e!=$X[0])queries("EXEC sp_rename ".q(table($R).".$e").", ".q(idf_unescape($X[0])).", 'COLUMN'");$c["ALTER COLUMN ".implode("",$X)][]="";}}}if($R=="")return
queries("CREATE TABLE ".table($C)." (".implode(",",(array)$c["ADD"])."\n)");if($R!=$C)queries("EXEC sp_rename ".q(table($R)).", ".q($C));if($jd)$c[""]=$jd;foreach($c
as$z=>$X){if(!queries("ALTER TABLE ".idf_escape($C)." $z".implode(",",$X)))return
false;}foreach($xb
as$z=>$X){$vb=substr($X,9);queries("EXEC sp_dropextendedproperty @name = N'MS_Description', @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table',  @level1name = ".q($C).", @level2type = N'Column', @level2name = ".q($z));queries("EXEC sp_addextendedproperty @name = N'MS_Description', @value = ".$vb.", @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table',  @level1name = ".q($C).", @level2type = N'Column', @level2name = ".q($z));}return
true;}function
alter_indexes($R,$c){$w=array();$lc=array();foreach($c
as$X){if($X[2]=="DROP"){if($X[0]=="PRIMARY")$lc[]=idf_escape($X[1]);else$w[]=idf_escape($X[1])." ON ".table($R);}elseif(!queries(($X[0]!="PRIMARY"?"CREATE $X[0] ".($X[0]!="INDEX"?"INDEX ":"").idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R):"ALTER TABLE ".table($R)." ADD PRIMARY KEY")." (".implode(", ",$X[2]).")"))return
false;}return(!$w||queries("DROP INDEX ".implode(", ",$w)))&&(!$lc||queries("ALTER TABLE ".table($R)." DROP ".implode(", ",$lc)));}function
last_id(){global$h;return$h->result("SELECT SCOPE_IDENTITY()");}function
explain($h,$G){$h->query("SET SHOWPLAN_ALL ON");$I=$h->query($G);$h->query("SET SHOWPLAN_ALL OFF");return$I;}function
found_rows($S,$Z){}function
foreign_keys($R){$I=array();foreach(get_rows("EXEC sp_fkeys @fktable_name = ".q($R))as$J){$r=&$I[$J["FK_NAME"]];$r["db"]=$J["PKTABLE_QUALIFIER"];$r["table"]=$J["PKTABLE_NAME"];$r["source"][]=$J["FKCOLUMN_NAME"];$r["target"][]=$J["PKCOLUMN_NAME"];}return$I;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($kj){return
queries("DROP VIEW ".implode(", ",array_map('table',$kj)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('table',$T)));}function
move_tables($T,$kj,$gi){return
apply_queries("ALTER SCHEMA ".idf_escape($gi)." TRANSFER",array_merge($T,$kj));}function
trigger($C){if($C=="")return
array();$K=get_rows("SELECT s.name [Trigger],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(s.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(s.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing],
c.text
FROM sysobjects s
JOIN syscomments c ON s.id = c.id
WHERE s.xtype = 'TR' AND s.name = ".q($C));$I=reset($K);if($I)$I["Statement"]=preg_replace('~^.+\s+AS\s+~isU','',$I["text"]);return$I;}function
triggers($R){$I=array();foreach(get_rows("SELECT sys1.name,
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing]
FROM sysobjects sys1
JOIN sysobjects sys2 ON sys1.parent_obj = sys2.id
WHERE sys1.xtype = 'TR' AND sys2.name = ".q($R))as$J)$I[$J["name"]]=array($J["Timing"],$J["Event"]);return$I;}function
trigger_options(){return
array("Timing"=>array("AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("AS"),);}function
schemas(){return
get_vals("SELECT name FROM sys.schemas");}function
get_schema(){global$h;if($_GET["ns"]!="")return$_GET["ns"];return$h->result("SELECT SCHEMA_NAME()");}function
set_schema($jh){return
true;}function
use_sql($k){return"USE ".idf_escape($k);}function
show_variables(){return
array();}function
show_status(){return
array();}function
convert_field($p){}function
unconvert_field($p,$I){return$I;}function
support($Wc){return
preg_match('~^(comment|columns|database|drop_col|indexes|descidx|scheme|sql|table|trigger|view|view_trigger)$~',$Wc);}$y="mssql";$Li=array();$Qh=array();foreach(array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"int"=>10,"bigint"=>20,"bit"=>1,"decimal"=>0,"real"=>12,"float"=>53,"smallmoney"=>10,"money"=>20),lang(28)=>array("date"=>10,"smalldatetime"=>19,"datetime"=>19,"datetime2"=>19,"time"=>8,"datetimeoffset"=>10),lang(25)=>array("char"=>8000,"varchar"=>8000,"text"=>2147483647,"nchar"=>4000,"nvarchar"=>4000,"ntext"=>1073741823),lang(29)=>array("binary"=>8000,"varbinary"=>8000,"image"=>2147483647),)as$z=>$X){$Li+=$X;$Qh[$z]=array_keys($X);}$Si=array();$Cf=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL");$rd=array("len","lower","round","upper");$xd=array("avg","count","count distinct","max","min","sum");$sc=array(array("date|time"=>"getdate",),array("int|decimal|real|float|money|datetime"=>"+/-","char|text"=>"+",));}$kc['firebird']='Firebird (alpha)';if(isset($_GET["firebird"])){$qg=array("interbase");define("DRIVER","firebird");if(extension_loaded("interbase")){class
Min_DB{var$extension="Firebird",$server_info,$affected_rows,$errno,$error,$_link,$_result;function
connect($N,$V,$F){$this->_link=ibase_connect($N,$V,$F);if($this->_link){$Wi=explode(':',$N);$this->service_link=ibase_service_attach($Wi[0],$V,$F);$this->server_info=ibase_server_info($this->service_link,IBASE_SVC_SERVER_VERSION);}else{$this->errno=ibase_errcode();$this->error=ibase_errmsg();}return(bool)$this->_link;}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($k){return($k=="domain");}function
query($G,$Mi=false){$H=ibase_query($G,$this->_link);if(!$H){$this->errno=ibase_errcode();$this->error=ibase_errmsg();return
false;}$this->error="";if($H===true){$this->affected_rows=ibase_affected_rows($this->_link);return
true;}return
new
Min_Result($H);}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$p=0){$H=$this->query($G);if(!$H||!$H->num_rows)return
false;$J=$H->fetch_row();return$J[$p];}}class
Min_Result{var$num_rows,$_result,$_offset=0;function
__construct($H){$this->_result=$H;}function
fetch_assoc(){return
ibase_fetch_assoc($this->_result);}function
fetch_row(){return
ibase_fetch_row($this->_result);}function
fetch_field(){$p=ibase_field_info($this->_result,$this->_offset++);return(object)array('name'=>$p['name'],'orgname'=>$p['name'],'type'=>$p['type'],'charsetnr'=>$p['length'],);}function
__destruct(){ibase_free_result($this->_result);}}}class
Min_Driver
extends
Min_SQL{}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
connect(){global$b;$h=new
Min_DB;$Mb=$b->credentials();if($h->connect($Mb[0],$Mb[1],$Mb[2]))return$h;return$h->error;}function
get_databases($hd){return
array("domain");}function
limit($G,$Z,$_,$D=0,$M=" "){$I='';$I.=($_!==null?$M."FIRST $_".($D?" SKIP $D":""):"");$I.=" $G$Z";return$I;}function
limit1($R,$G,$Z,$M="\n"){return
limit($G,$Z,1,0,$M);}function
db_collation($m,$qb){}function
engines(){return
array();}function
logged_user(){global$b;$Mb=$b->credentials();return$Mb[1];}function
tables_list(){global$h;$G='SELECT RDB$RELATION_NAME FROM rdb$relations WHERE rdb$system_flag = 0';$H=ibase_query($h->_link,$G);$I=array();while($J=ibase_fetch_assoc($H))$I[$J['RDB$RELATION_NAME']]='table';ksort($I);return$I;}function
count_tables($l){return
array();}function
table_status($C="",$Vc=false){global$h;$I=array();$Rb=tables_list();foreach($Rb
as$w=>$X){$w=trim($w);$I[$w]=array('Name'=>$w,'Engine'=>'standard',);if($C==$w)return$I[$w];}return$I;}function
is_view($S){return
false;}function
fk_support($S){return
preg_match('~InnoDB|IBMDB2I~i',$S["Engine"]);}function
fields($R){global$h;$I=array();$G='SELECT r.RDB$FIELD_NAME AS field_name,
r.RDB$DESCRIPTION AS field_description,
r.RDB$DEFAULT_VALUE AS field_default_value,
r.RDB$NULL_FLAG AS field_not_null_constraint,
f.RDB$FIELD_LENGTH AS field_length,
f.RDB$FIELD_PRECISION AS field_precision,
f.RDB$FIELD_SCALE AS field_scale,
CASE f.RDB$FIELD_TYPE
WHEN 261 THEN \'BLOB\'
WHEN 14 THEN \'CHAR\'
WHEN 40 THEN \'CSTRING\'
WHEN 11 THEN \'D_FLOAT\'
WHEN 27 THEN \'DOUBLE\'
WHEN 10 THEN \'FLOAT\'
WHEN 16 THEN \'INT64\'
WHEN 8 THEN \'INTEGER\'
WHEN 9 THEN \'QUAD\'
WHEN 7 THEN \'SMALLINT\'
WHEN 12 THEN \'DATE\'
WHEN 13 THEN \'TIME\'
WHEN 35 THEN \'TIMESTAMP\'
WHEN 37 THEN \'VARCHAR\'
ELSE \'UNKNOWN\'
END AS field_type,
f.RDB$FIELD_SUB_TYPE AS field_subtype,
coll.RDB$COLLATION_NAME AS field_collation,
cset.RDB$CHARACTER_SET_NAME AS field_charset
FROM RDB$RELATION_FIELDS r
LEFT JOIN RDB$FIELDS f ON r.RDB$FIELD_SOURCE = f.RDB$FIELD_NAME
LEFT JOIN RDB$COLLATIONS coll ON f.RDB$COLLATION_ID = coll.RDB$COLLATION_ID
LEFT JOIN RDB$CHARACTER_SETS cset ON f.RDB$CHARACTER_SET_ID = cset.RDB$CHARACTER_SET_ID
WHERE r.RDB$RELATION_NAME = '.q($R).'
ORDER BY r.RDB$FIELD_POSITION';$H=ibase_query($h->_link,$G);while($J=ibase_fetch_assoc($H))$I[trim($J['FIELD_NAME'])]=array("field"=>trim($J["FIELD_NAME"]),"full_type"=>trim($J["FIELD_TYPE"]),"type"=>trim($J["FIELD_SUB_TYPE"]),"default"=>trim($J['FIELD_DEFAULT_VALUE']),"null"=>(trim($J["FIELD_NOT_NULL_CONSTRAINT"])=="YES"),"auto_increment"=>'0',"collation"=>trim($J["FIELD_COLLATION"]),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),"comment"=>trim($J["FIELD_DESCRIPTION"]),);return$I;}function
indexes($R,$i=null){$I=array();return$I;}function
foreign_keys($R){return
array();}function
collations(){return
array();}function
information_schema($m){return
false;}function
error(){global$h;return
h($h->error);}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($jh){return
true;}function
support($Wc){return
preg_match("~^(columns|sql|status|table)$~",$Wc);}$y="firebird";$Cf=array("=");$rd=array();$xd=array();$sc=array();}$kc["simpledb"]="SimpleDB";if(isset($_GET["simpledb"])){$qg=array("SimpleXML + allow_url_fopen");define("DRIVER","simpledb");if(class_exists('SimpleXMLElement')&&ini_bool('allow_url_fopen')){class
Min_DB{var$extension="SimpleXML",$server_info='2009-04-15',$error,$timeout,$next,$affected_rows,$_result;function
select_db($k){return($k=="domain");}function
query($G,$Mi=false){$Wf=array('SelectExpression'=>$G,'ConsistentRead'=>'true');if($this->next)$Wf['NextToken']=$this->next;$H=sdb_request_all('Select','Item',$Wf,$this->timeout);$this->timeout=0;if($H===false)return$H;if(preg_match('~^\s*SELECT\s+COUNT\(~i',$G)){$Uh=0;foreach($H
as$ie)$Uh+=$ie->Attribute->Value;$H=array((object)array('Attribute'=>array((object)array('Name'=>'Count','Value'=>$Uh,))));}return
new
Min_Result($H);}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0;function
__construct($H){foreach($H
as$ie){$J=array();if($ie->Name!='')$J['itemName()']=(string)$ie->Name;foreach($ie->Attribute
as$Ja){$C=$this->_processValue($Ja->Name);$Y=$this->_processValue($Ja->Value);if(isset($J[$C])){$J[$C]=(array)$J[$C];$J[$C][]=$Y;}else$J[$C]=$Y;}$this->_rows[]=$J;foreach($J
as$z=>$X){if(!isset($this->_rows[0][$z]))$this->_rows[0][$z]=null;}}$this->num_rows=count($this->_rows);}function
_processValue($vc){return(is_object($vc)&&$vc['encoding']=='base64'?base64_decode($vc):(string)$vc);}function
fetch_assoc(){$J=current($this->_rows);if(!$J)return$J;$I=array();foreach($this->_rows[0]as$z=>$X)$I[$z]=$J[$z];next($this->_rows);return$I;}function
fetch_row(){$I=$this->fetch_assoc();if(!$I)return$I;return
array_values($I);}function
fetch_field(){$oe=array_keys($this->_rows[0]);return(object)array('name'=>$oe[$this->_offset++]);}}}class
Min_Driver
extends
Min_SQL{public$tg="itemName()";function
_chunkRequest($Ld,$wa,$Wf,$Lc=array()){global$h;foreach(array_chunk($Ld,25)as$jb){$Xf=$Wf;foreach($jb
as$t=>$u){$Xf["Item.$t.ItemName"]=$u;foreach($Lc
as$z=>$X)$Xf["Item.$t.$z"]=$X;}if(!sdb_request($wa,$Xf))return
false;}$h->affected_rows=count($Ld);return
true;}function
_extractIds($R,$Eg,$_){$I=array();if(preg_match_all("~itemName\(\) = (('[^']*+')+)~",$Eg,$Le))$I=array_map('idf_unescape',$Le[1]);else{foreach(sdb_request_all('Select','Item',array('SelectExpression'=>'SELECT itemName() FROM '.table($R).$Eg.($_?" LIMIT 1":"")))as$ie)$I[]=$ie->Name;}return$I;}function
select($R,$L,$Z,$ud,$Hf=array(),$_=1,$E=0,$vg=false){global$h;$h->next=$_GET["next"];$I=parent::select($R,$L,$Z,$ud,$Hf,$_,$E,$vg);$h->next=0;return$I;}function
delete($R,$Eg,$_=0){return$this->_chunkRequest($this->_extractIds($R,$Eg,$_),'BatchDeleteAttributes',array('DomainName'=>$R));}function
update($R,$O,$Eg,$_=0,$M="\n"){$bc=array();$ae=array();$t=0;$Ld=$this->_extractIds($R,$Eg,$_);$u=idf_unescape($O["`itemName()`"]);unset($O["`itemName()`"]);foreach($O
as$z=>$X){$z=idf_unescape($z);if($X=="NULL"||($u!=""&&array($u)!=$Ld))$bc["Attribute.".count($bc).".Name"]=$z;if($X!="NULL"){foreach((array)$X
as$ke=>$W){$ae["Attribute.$t.Name"]=$z;$ae["Attribute.$t.Value"]=(is_array($X)?$W:idf_unescape($W));if(!$ke)$ae["Attribute.$t.Replace"]="true";$t++;}}}$Wf=array('DomainName'=>$R);return(!$ae||$this->_chunkRequest(($u!=""?array($u):$Ld),'BatchPutAttributes',$Wf,$ae))&&(!$bc||$this->_chunkRequest($Ld,'BatchDeleteAttributes',$Wf,$bc));}function
insert($R,$O){$Wf=array("DomainName"=>$R);$t=0;foreach($O
as$C=>$Y){if($Y!="NULL"){$C=idf_unescape($C);if($C=="itemName()")$Wf["ItemName"]=idf_unescape($Y);else{foreach((array)$Y
as$X){$Wf["Attribute.$t.Name"]=$C;$Wf["Attribute.$t.Value"]=(is_array($Y)?$X:idf_unescape($Y));$t++;}}}}return
sdb_request('PutAttributes',$Wf);}function
insertUpdate($R,$K,$tg){foreach($K
as$O){if(!$this->update($R,$O,"WHERE `itemName()` = ".q($O["`itemName()`"])))return
false;}return
true;}function
begin(){return
false;}function
commit(){return
false;}function
rollback(){return
false;}function
slowQuery($G,$oi){$this->_conn->timeout=$oi;return$G;}}function
connect(){global$b;list(,,$F)=$b->credentials();if($F!="")return
lang(22);return
new
Min_DB;}function
support($Wc){return
preg_match('~sql~',$Wc);}function
logged_user(){global$b;$Mb=$b->credentials();return$Mb[1];}function
get_databases(){return
array("domain");}function
collations(){return
array();}function
db_collation($m,$qb){}function
tables_list(){global$h;$I=array();foreach(sdb_request_all('ListDomains','DomainName')as$R)$I[(string)$R]='table';if($h->error&&defined("PAGE_HEADER"))echo"<p class='error'>".error()."\n";return$I;}function
table_status($C="",$Vc=false){$I=array();foreach(($C!=""?array($C=>true):tables_list())as$R=>$U){$J=array("Name"=>$R,"Auto_increment"=>"");if(!$Vc){$Ye=sdb_request('DomainMetadata',array('DomainName'=>$R));if($Ye){foreach(array("Rows"=>"ItemCount","Data_length"=>"ItemNamesSizeBytes","Index_length"=>"AttributeValuesSizeBytes","Data_free"=>"AttributeNamesSizeBytes",)as$z=>$X)$J[$z]=(string)$Ye->$X;}}if($C!="")return$J;$I[$R]=$J;}return$I;}function
explain($h,$G){}function
error(){global$h;return
h($h->error);}function
information_schema(){}function
is_view($S){}function
indexes($R,$i=null){return
array(array("type"=>"PRIMARY","columns"=>array("itemName()")),);}function
fields($R){return
fields_from_edit();}function
foreign_keys($R){return
array();}function
table($v){return
idf_escape($v);}function
idf_escape($v){return"`".str_replace("`","``",$v)."`";}function
limit($G,$Z,$_,$D=0,$M=" "){return" $G$Z".($_!==null?$M."LIMIT $_":"");}function
unconvert_field($p,$I){return$I;}function
fk_support($S){}function
engines(){return
array();}function
alter_table($R,$C,$q,$jd,$vb,$_c,$d,$Na,$cg){return($R==""&&sdb_request('CreateDomain',array('DomainName'=>$C)));}function
drop_tables($T){foreach($T
as$R){if(!sdb_request('DeleteDomain',array('DomainName'=>$R)))return
false;}return
true;}function
count_tables($l){foreach($l
as$m)return
array($m=>count(tables_list()));}function
found_rows($S,$Z){return($Z?null:$S["Rows"]);}function
last_id(){}function
hmac($Ca,$Rb,$z,$Ig=false){$Wa=64;if(strlen($z)>$Wa)$z=pack("H*",$Ca($z));$z=str_pad($z,$Wa,"\0");$le=$z^str_repeat("\x36",$Wa);$me=$z^str_repeat("\x5C",$Wa);$I=$Ca($me.pack("H*",$Ca($le.$Rb)));if($Ig)$I=pack("H*",$I);return$I;}function
sdb_request($wa,$Wf=array()){global$b,$h;list($Hd,$Wf['AWSAccessKeyId'],$mh)=$b->credentials();$Wf['Action']=$wa;$Wf['Timestamp']=gmdate('Y-m-d\TH:i:s+00:00');$Wf['Version']='2009-04-15';$Wf['SignatureVersion']=2;$Wf['SignatureMethod']='HmacSHA1';ksort($Wf);$G='';foreach($Wf
as$z=>$X)$G.='&'.rawurlencode($z).'='.rawurlencode($X);$G=str_replace('%7E','~',substr($G,1));$G.="&Signature=".urlencode(base64_encode(hmac('sha1',"POST\n".preg_replace('~^https?://~','',$Hd)."\n/\n$G",$mh,true)));@ini_set('track_errors',1);$ad=@file_get_contents((preg_match('~^https?://~',$Hd)?$Hd:"http://$Hd"),false,stream_context_create(array('http'=>array('method'=>'POST','content'=>$G,'ignore_errors'=>1,))));if(!$ad){$h->error=$php_errormsg;return
false;}libxml_use_internal_errors(true);$xj=simplexml_load_string($ad);if(!$xj){$o=libxml_get_last_error();$h->error=$o->message;return
false;}if($xj->Errors){$o=$xj->Errors->Error;$h->error="$o->Message ($o->Code)";return
false;}$h->error='';$fi=$wa."Result";return($xj->$fi?$xj->$fi:true);}function
sdb_request_all($wa,$fi,$Wf=array(),$oi=0){$I=array();$Mh=($oi?microtime(true):0);$_=(preg_match('~LIMIT\s+(\d+)\s*$~i',$Wf['SelectExpression'],$B)?$B[1]:0);do{$xj=sdb_request($wa,$Wf);if(!$xj)break;foreach($xj->$fi
as$vc)$I[]=$vc;if($_&&count($I)>=$_){$_GET["next"]=$xj->NextToken;break;}if($oi&&microtime(true)-$Mh>$oi)return
false;$Wf['NextToken']=$xj->NextToken;if($_)$Wf['SelectExpression']=preg_replace('~\d+\s*$~',$_-count($I),$Wf['SelectExpression']);}while($xj->NextToken);return$I;}$y="simpledb";$Cf=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","IS NOT NULL");$rd=array();$xd=array("count");$sc=array(array("json"));}$kc["mongo"]="MongoDB";if(isset($_GET["mongo"])){$qg=array("mongo","mongodb");define("DRIVER","mongo");if(class_exists('MongoDB\Driver\Manager')){class
Min_DB{var$extension="MongoDB",$server_info=MONGODB_VERSION,$error,$last_id;var$_link;var$_db,$_db_name;function
connect($Ui,$Ff){$lb='MongoDB\Driver\Manager';return
new$lb($Ui,$Ff);}function
query($G){return
false;}function
select_db($k){$this->_db_name=$k;return
true;}function
quote($Q){return$Q;}function
ping($A){$lb='MongoDB\Driver\Command';$A->executeCommand('admin',new$lb(array('ping'=>1)));}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0,$_charset=array();function
__construct($H){foreach($H
as$ie){$J=array();foreach($ie
as$z=>$X){if(is_a($X,'MongoDB\BSON\Binary'))$this->_charset[$z]=63;$J[$z]=(is_a($X,'MongoDB\BSON\ObjectID')?'MongoDB\BSON\ObjectID("'.strval($X).'")':(is_a($X,'MongoDB\BSON\UTCDatetime')?$X->toDateTime()->format('Y-m-d H:i:s'):(is_a($X,'MongoDB\BSON\Binary')?$X->bin:(is_a($X,'MongoDB\BSON\Regex')?strval($X):(is_object($X)?json_encode($X,256):$X)))));}$this->_rows[]=$J;foreach($J
as$z=>$X){if(!isset($this->_rows[0][$z]))$this->_rows[0][$z]=null;}}$this->num_rows=$H->count;}function
fetch_assoc(){$J=current($this->_rows);if(!$J)return$J;$I=array();foreach($this->_rows[0]as$z=>$X)$I[$z]=$J[$z];next($this->_rows);return$I;}function
fetch_row(){$I=$this->fetch_assoc();if(!$I)return$I;return
array_values($I);}function
fetch_field(){$oe=array_keys($this->_rows[0]);$C=$oe[$this->_offset++];return(object)array('name'=>$C,'charsetnr'=>$this->_charset[$C],);}}class
Min_Driver
extends
Min_SQL{public$tg="_id";function
select($R,$L,$Z,$ud,$Hf=array(),$_=1,$E=0,$vg=false){global$h;$L=($L==array("*")?array():array_fill_keys($L,1));if(count($L)&&!isset($L['_id']))$L['_id']=0;$Z=where_to_query($Z);$Dh=array();foreach($Hf
as$X){$X=preg_replace('~ DESC$~','',$X,1,$Jb);$Dh[$X]=($Jb?-1:1);}if(isset($_GET['limit'])&&is_numeric($_GET['limit'])&&$_GET['limit']>0)$_=$_GET['limit'];$_=min(200,max(1,(int)$_));$Ah=$E*$_;$lb='MongoDB\Driver\Query';$G=new$lb($Z,array('projection'=>$L,'limit'=>$_,'skip'=>$Ah,'sort'=>$Dh));$Yg=$h->_link->executeQuery("$h->_db_name.$R",$G);return
new
Min_Result($Yg);}function
update($R,$O,$Eg,$_=0,$M="\n"){global$h;$m=$h->_db_name;$Z=sql_query_where_parser($Eg);$lb='MongoDB\Driver\BulkWrite';$ab=new$lb(array());if(isset($O['_id']))unset($O['_id']);$Sg=array();foreach($O
as$z=>$Y){if($Y=='NULL'){$Sg[$z]=1;unset($O[$z]);}}$Ti=array('$set'=>$O);if(count($Sg))$Ti['$unset']=$Sg;$ab->update($Z,$Ti,array('upsert'=>false));$Yg=$h->_link->executeBulkWrite("$m.$R",$ab);$h->affected_rows=$Yg->getModifiedCount();return
true;}function
delete($R,$Eg,$_=0){global$h;$m=$h->_db_name;$Z=sql_query_where_parser($Eg);$lb='MongoDB\Driver\BulkWrite';$ab=new$lb(array());$ab->delete($Z,array('limit'=>$_));$Yg=$h->_link->executeBulkWrite("$m.$R",$ab);$h->affected_rows=$Yg->getDeletedCount();return
true;}function
insert($R,$O){global$h;$m=$h->_db_name;$lb='MongoDB\Driver\BulkWrite';$ab=new$lb(array());if(isset($O['_id'])&&empty($O['_id']))unset($O['_id']);$ab->insert($O);$Yg=$h->_link->executeBulkWrite("$m.$R",$ab);$h->affected_rows=$Yg->getInsertedCount();return
true;}}function
get_databases($hd){global$h;$I=array();$lb='MongoDB\Driver\Command';$tb=new$lb(array('listDatabases'=>1));$Yg=$h->_link->executeCommand('admin',$tb);foreach($Yg
as$Wb){foreach($Wb->databases
as$m)$I[]=$m->name;}return$I;}function
count_tables($l){$I=array();return$I;}function
tables_list(){global$h;$lb='MongoDB\Driver\Command';$tb=new$lb(array('listCollections'=>1));$Yg=$h->_link->executeCommand($h->_db_name,$tb);$rb=array();foreach($Yg
as$H)$rb[$H->name]='table';return$rb;}function
drop_databases($l){return
false;}function
indexes($R,$i=null){global$h;$I=array();$lb='MongoDB\Driver\Command';$tb=new$lb(array('listIndexes'=>$R));$Yg=$h->_link->executeCommand($h->_db_name,$tb);foreach($Yg
as$w){$ec=array();$f=array();foreach(get_object_vars($w->key)as$e=>$U){$ec[]=($U==-1?'1':null);$f[]=$e;}$I[$w->name]=array("type"=>($w->name=="_id_"?"PRIMARY":(isset($w->unique)?"UNIQUE":"INDEX")),"columns"=>$f,"lengths"=>array(),"descs"=>$ec,);}return$I;}function
fields($R){$q=fields_from_edit();if(!count($q)){global$n;$H=$n->select($R,array("*"),null,null,array(),10);while($J=$H->fetch_assoc()){foreach($J
as$z=>$X){$J[$z]=null;$q[$z]=array("field"=>$z,"type"=>"string","null"=>($z!=$n->primary),"auto_increment"=>($z==$n->primary),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,),);}}}return$q;}function
found_rows($S,$Z){global$h;$Z=where_to_query($Z);$lb='MongoDB\Driver\Command';$tb=new$lb(array('count'=>$S['Name'],'query'=>$Z));$Yg=$h->_link->executeCommand($h->_db_name,$tb);$wi=$Yg->toArray();return$wi[0]->n;}function
sql_query_where_parser($Eg){$Eg=trim(preg_replace('/WHERE[\s]?[(]?\(?/','',$Eg));$Eg=preg_replace('/\)\)\)$/',')',$Eg);$uj=explode(' AND ',$Eg);$vj=explode(') OR (',$Eg);$Z=array();foreach($uj
as$sj)$Z[]=trim($sj);if(count($vj)==1)$vj=array();elseif(count($vj)>1)$Z=array();return
where_to_query($Z,$vj);}function
where_to_query($qj=array(),$rj=array()){global$b;$Rb=array();foreach(array('and'=>$qj,'or'=>$rj)as$U=>$Z){if(is_array($Z)){foreach($Z
as$Oc){list($ob,$Af,$X)=explode(" ",$Oc,3);if($ob=="_id"){$X=str_replace('MongoDB\BSON\ObjectID("',"",$X);$X=str_replace('")',"",$X);$lb='MongoDB\BSON\ObjectID';$X=new$lb($X);}if(!in_array($Af,$b->operators))continue;if(preg_match('~^\(f\)(.+)~',$Af,$B)){$X=(float)$X;$Af=$B[1];}elseif(preg_match('~^\(date\)(.+)~',$Af,$B)){$Tb=new
DateTime($X);$lb='MongoDB\BSON\UTCDatetime';$X=new$lb($Tb->getTimestamp()*1000);$Af=$B[1];}switch($Af){case'=':$Af='$eq';break;case'!=':$Af='$ne';break;case'>':$Af='$gt';break;case'<':$Af='$lt';break;case'>=':$Af='$gte';break;case'<=':$Af='$lte';break;case'regex':$Af='$regex';break;default:continue
2;}if($U=='and')$Rb['$and'][]=array($ob=>array($Af=>$X));elseif($U=='or')$Rb['$or'][]=array($ob=>array($Af=>$X));}}}return$Rb;}$Cf=array("=","!=",">","<",">=","<=","regex","(f)=","(f)!=","(f)>","(f)<","(f)>=","(f)<=","(date)=","(date)!=","(date)>","(date)<","(date)>=","(date)<=",);}elseif(class_exists('MongoDB')){class
Min_DB{var$extension="Mongo",$server_info=MongoClient::VERSION,$error,$last_id,$_link,$_db;function
connect($Ui,$Ff){return@new
MongoClient($Ui,$Ff);}function
query($G){return
false;}function
select_db($k){try{$this->_db=$this->_link->selectDB($k);return
true;}catch(Exception$Hc){$this->error=$Hc->getMessage();return
false;}}function
quote($Q){return$Q;}function
ping($A){}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0,$_charset=array();function
__construct($H){foreach($H
as$ie){$J=array();foreach($ie
as$z=>$X){if(is_a($X,'MongoBinData'))$this->_charset[$z]=63;$J[$z]=(is_a($X,'MongoId')?'ObjectId("'.strval($X).'")':(is_a($X,'MongoDate')?gmdate("Y-m-d H:i:s",$X->sec)." GMT":(is_a($X,'MongoBinData')?$X->bin:(is_a($X,'MongoRegex')?strval($X):(is_object($X)?get_class($X):$X)))));}$this->_rows[]=$J;foreach($J
as$z=>$X){if(!isset($this->_rows[0][$z]))$this->_rows[0][$z]=null;}}$this->num_rows=count($this->_rows);}function
fetch_assoc(){$J=current($this->_rows);if(!$J)return$J;$I=array();foreach($this->_rows[0]as$z=>$X)$I[$z]=$J[$z];next($this->_rows);return$I;}function
fetch_row(){$I=$this->fetch_assoc();if(!$I)return$I;return
array_values($I);}function
fetch_field(){$oe=array_keys($this->_rows[0]);$C=$oe[$this->_offset++];return(object)array('name'=>$C,'charsetnr'=>$this->_charset[$C],);}}class
Min_Driver
extends
Min_SQL{public$tg="_id";function
select($R,$L,$Z,$ud,$Hf=array(),$_=1,$E=0,$vg=false){$L=($L==array("*")?array():array_fill_keys($L,true));$Dh=array();foreach($Hf
as$X){$X=preg_replace('~ DESC$~','',$X,1,$Jb);$Dh[$X]=($Jb?-1:1);}return
new
Min_Result($this->_conn->_db->selectCollection($R)->find(array(),$L)->sort($Dh)->limit($_!=""?+$_:0)->skip($E*$_));}function
insert($R,$O){try{$I=$this->_conn->_db->selectCollection($R)->insert($O);$this->_conn->errno=$I['code'];$this->_conn->error=$I['err'];$this->_conn->last_id=$O['_id'];return!$I['err'];}catch(Exception$Hc){$this->_conn->error=$Hc->getMessage();return
false;}}}function
get_databases($hd){global$h;$I=array();$Wb=$h->_link->listDBs();foreach($Wb['databases']as$m)$I[]=$m['name'];return$I;}function
count_tables($l){global$h;$I=array();foreach($l
as$m)$I[$m]=count($h->_link->selectDB($m)->getCollectionNames(true));return$I;}function
tables_list(){global$h;return
array_fill_keys($h->_db->getCollectionNames(true),'table');}function
drop_databases($l){global$h;foreach($l
as$m){$Vg=$h->_link->selectDB($m)->drop();if(!$Vg['ok'])return
false;}return
true;}function
indexes($R,$i=null){global$h;$I=array();foreach($h->_db->selectCollection($R)->getIndexInfo()as$w){$ec=array();foreach($w["key"]as$e=>$U)$ec[]=($U==-1?'1':null);$I[$w["name"]]=array("type"=>($w["name"]=="_id_"?"PRIMARY":($w["unique"]?"UNIQUE":"INDEX")),"columns"=>array_keys($w["key"]),"lengths"=>array(),"descs"=>$ec,);}return$I;}function
fields($R){return
fields_from_edit();}function
found_rows($S,$Z){global$h;return$h->_db->selectCollection($_GET["select"])->count($Z);}$Cf=array("=");}function
table($v){return$v;}function
idf_escape($v){return$v;}function
table_status($C="",$Vc=false){$I=array();foreach(tables_list()as$R=>$U){$I[$R]=array("Name"=>$R);if($C==$R)return$I[$R];}return$I;}function
create_database($m,$d){return
true;}function
last_id(){global$h;return$h->last_id;}function
error(){global$h;return
h($h->error);}function
collations(){return
array();}function
logged_user(){global$b;$Mb=$b->credentials();return$Mb[1];}function
connect(){global$b;$h=new
Min_DB;list($N,$V,$F)=$b->credentials();$Ff=array();if($V.$F!=""){$Ff["username"]=$V;$Ff["password"]=$F;}$m=$b->database();if($m!="")$Ff["db"]=$m;if(($Ma=getenv("MONGO_AUTH_SOURCE")))$Ff["authSource"]=$Ma;try{$h->_link=$h->connect("mongodb://$N",$Ff);if($F!=""){$Ff["password"]="";try{$h->ping($h->connect("mongodb://$N",$Ff));return
lang(22);}catch(Exception$Hc){}}return$h;}catch(Exception$Hc){return$Hc->getMessage();}}function
alter_indexes($R,$c){global$h;foreach($c
as$X){list($U,$C,$O)=$X;if($O=="DROP")$I=$h->_db->command(array("deleteIndexes"=>$R,"index"=>$C));else{$f=array();foreach($O
as$e){$e=preg_replace('~ DESC$~','',$e,1,$Jb);$f[$e]=($Jb?-1:1);}$I=$h->_db->selectCollection($R)->ensureIndex($f,array("unique"=>($U=="UNIQUE"),"name"=>$C,));}if($I['errmsg']){$h->error=$I['errmsg'];return
false;}}return
true;}function
support($Wc){return
preg_match("~database|indexes|descidx~",$Wc);}function
db_collation($m,$qb){}function
information_schema(){}function
is_view($S){}function
convert_field($p){}function
unconvert_field($p,$I){return$I;}function
foreign_keys($R){return
array();}function
fk_support($S){}function
engines(){return
array();}function
alter_table($R,$C,$q,$jd,$vb,$_c,$d,$Na,$cg){global$h;if($R==""){$h->_db->createCollection($C);return
true;}}function
drop_tables($T){global$h;foreach($T
as$R){$Vg=$h->_db->selectCollection($R)->drop();if(!$Vg['ok'])return
false;}return
true;}function
truncate_tables($T){global$h;foreach($T
as$R){$Vg=$h->_db->selectCollection($R)->remove();if(!$Vg['ok'])return
false;}return
true;}$y="mongo";$rd=array();$xd=array();$sc=array(array("json"));}$kc["elastic"]="Elasticsearch (beta)";if(isset($_GET["elastic"])){$qg=array("json + allow_url_fopen");define("DRIVER","elastic");if(function_exists('json_decode')&&ini_bool('allow_url_fopen')){class
Min_DB{var$extension="JSON",$server_info,$errno,$error,$_url,$_db;function
rootQuery($gg,$Eb=array(),$Ze='GET'){@ini_set('track_errors',1);$ad=@file_get_contents("$this->_url/".ltrim($gg,'/'),false,stream_context_create(array('http'=>array('method'=>$Ze,'content'=>$Eb===null?$Eb:json_encode($Eb),'header'=>'Content-Type: application/json','ignore_errors'=>1,))));if(!$ad){$this->error=$php_errormsg;return$ad;}if(!preg_match('~^HTTP/[0-9.]+ 2~i',$http_response_header[0])){$this->error=lang(32)." $http_response_header[0]";return
false;}$I=json_decode($ad,true);if($I===null){$this->errno=json_last_error();if(function_exists('json_last_error_msg'))$this->error=json_last_error_msg();else{$Cb=get_defined_constants(true);foreach($Cb['json']as$C=>$Y){if($Y==$this->errno&&preg_match('~^JSON_ERROR_~',$C)){$this->error=$C;break;}}}}return$I;}function
query($gg,$Eb=array(),$Ze='GET'){return$this->rootQuery(($this->_db!=""?"$this->_db/":"/").ltrim($gg,'/'),$Eb,$Ze);}function
connect($N,$V,$F){preg_match('~^(https?://)?(.*)~',$N,$B);$this->_url=($B[1]?$B[1]:"http://")."$V:$F@$B[2]";$I=$this->query('');if($I)$this->server_info=$I['version']['number'];return(bool)$I;}function
select_db($k){$this->_db=$k;return
true;}function
quote($Q){return$Q;}}class
Min_Result{var$num_rows,$_rows;function
__construct($K){$this->num_rows=count($K);$this->_rows=$K;reset($this->_rows);}function
fetch_assoc(){$I=current($this->_rows);next($this->_rows);return$I;}function
fetch_row(){return
array_values($this->fetch_assoc());}}}class
Min_Driver
extends
Min_SQL{function
select($R,$L,$Z,$ud,$Hf=array(),$_=1,$E=0,$vg=false){global$b;$Rb=array();$G="$R/_search";if($L!=array("*"))$Rb["fields"]=$L;if($Hf){$Dh=array();foreach($Hf
as$ob){$ob=preg_replace('~ DESC$~','',$ob,1,$Jb);$Dh[]=($Jb?array($ob=>"desc"):$ob);}$Rb["sort"]=$Dh;}if($_){$Rb["size"]=+$_;if($E)$Rb["from"]=($E*$_);}foreach($Z
as$X){list($ob,$Af,$X)=explode(" ",$X,3);if($ob=="_id")$Rb["query"]["ids"]["values"][]=$X;elseif($ob.$X!=""){$ji=array("term"=>array(($ob!=""?$ob:"_all")=>$X));if($Af=="=")$Rb["query"]["filtered"]["filter"]["and"][]=$ji;else$Rb["query"]["filtered"]["query"]["bool"]["must"][]=$ji;}}if($Rb["query"]&&!$Rb["query"]["filtered"]["query"]&&!$Rb["query"]["ids"])$Rb["query"]["filtered"]["query"]=array("match_all"=>array());$Mh=microtime(true);$lh=$this->_conn->query($G,$Rb);if($vg)echo$b->selectQuery("$G: ".json_encode($Rb),$Mh,!$lh);if(!$lh)return
false;$I=array();foreach($lh['hits']['hits']as$Gd){$J=array();if($L==array("*"))$J["_id"]=$Gd["_id"];$q=$Gd['_source'];if($L!=array("*")){$q=array();foreach($L
as$z)$q[$z]=$Gd['fields'][$z];}foreach($q
as$z=>$X){if($Rb["fields"])$X=$X[0];$J[$z]=(is_array($X)?json_encode($X):$X);}$I[]=$J;}return
new
Min_Result($I);}function
update($U,$Jg,$Eg,$_=0,$M="\n"){$eg=preg_split('~ *= *~',$Eg);if(count($eg)==2){$u=trim($eg[1]);$G="$U/$u";return$this->_conn->query($G,$Jg,'POST');}return
false;}function
insert($U,$Jg){$u="";$G="$U/$u";$Vg=$this->_conn->query($G,$Jg,'POST');$this->_conn->last_id=$Vg['_id'];return$Vg['created'];}function
delete($U,$Eg,$_=0){$Ld=array();if(is_array($_GET["where"])&&$_GET["where"]["_id"])$Ld[]=$_GET["where"]["_id"];if(is_array($_POST['check'])){foreach($_POST['check']as$eb){$eg=preg_split('~ *= *~',$eb);if(count($eg)==2)$Ld[]=trim($eg[1]);}}$this->_conn->affected_rows=0;foreach($Ld
as$u){$G="{$U}/{$u}";$Vg=$this->_conn->query($G,'{}','DELETE');if(is_array($Vg)&&$Vg['found']==true)$this->_conn->affected_rows++;}return$this->_conn->affected_rows;}}function
connect(){global$b;$h=new
Min_DB;list($N,$V,$F)=$b->credentials();if($F!=""&&$h->connect($N,$V,""))return
lang(22);if($h->connect($N,$V,$F))return$h;return$h->error;}function
support($Wc){return
preg_match("~database|table|columns~",$Wc);}function
logged_user(){global$b;$Mb=$b->credentials();return$Mb[1];}function
get_databases(){global$h;$I=$h->rootQuery('_aliases');if($I){$I=array_keys($I);sort($I,SORT_STRING);}return$I;}function
collations(){return
array();}function
db_collation($m,$qb){}function
engines(){return
array();}function
count_tables($l){global$h;$I=array();$H=$h->query('_stats');if($H&&$H['indices']){$Td=$H['indices'];foreach($Td
as$Sd=>$Nh){$Rd=$Nh['total']['indexing'];$I[$Sd]=$Rd['index_total'];}}return$I;}function
tables_list(){global$h;if(min_version(6))return
array('_doc'=>'table');$I=$h->query('_mapping');if($I)$I=array_fill_keys(array_keys($I[$h->_db]["mappings"]),'table');return$I;}function
table_status($C="",$Vc=false){global$h;$lh=$h->query("_search",array("size"=>0,"aggregations"=>array("count_by_type"=>array("terms"=>array("field"=>"_type")))),"POST");$I=array();if($lh){$T=$lh["aggregations"]["count_by_type"]["buckets"];foreach($T
as$R){$I[$R["key"]]=array("Name"=>$R["key"],"Engine"=>"table","Rows"=>$R["doc_count"],);if($C!=""&&$C==$R["key"])return$I[$C];}}return$I;}function
error(){global$h;return
h($h->error);}function
information_schema(){}function
is_view($S){}function
indexes($R,$i=null){return
array(array("type"=>"PRIMARY","columns"=>array("_id")),);}function
fields($R){global$h;$He=array();if(min_version(6)){$H=$h->query("_mapping");if($H)$He=$H[$h->_db]['mappings']['properties'];}else{$H=$h->query("$R/_mapping");if($H){$He=$H[$R]['properties'];if(!$He)$He=$H[$h->_db]['mappings'][$R]['properties'];}}$I=array();if($He){foreach($He
as$C=>$p){$I[$C]=array("field"=>$C,"full_type"=>$p["type"],"type"=>$p["type"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),);if($p["properties"]){unset($I[$C]["privileges"]["insert"]);unset($I[$C]["privileges"]["update"]);}}}return$I;}function
foreign_keys($R){return
array();}function
table($v){return$v;}function
idf_escape($v){return$v;}function
convert_field($p){}function
unconvert_field($p,$I){return$I;}function
fk_support($S){}function
found_rows($S,$Z){return
null;}function
create_database($m){global$h;return$h->rootQuery(urlencode($m),null,'PUT');}function
drop_databases($l){global$h;return$h->rootQuery(urlencode(implode(',',$l)),array(),'DELETE');}function
alter_table($R,$C,$q,$jd,$vb,$_c,$d,$Na,$cg){global$h;$Ag=array();foreach($q
as$Tc){$Yc=trim($Tc[1][0]);$Zc=trim($Tc[1][1]?$Tc[1][1]:"text");$Ag[$Yc]=array('type'=>$Zc);}if(!empty($Ag))$Ag=array('properties'=>$Ag);return$h->query("_mapping/{$C}",$Ag,'PUT');}function
drop_tables($T){global$h;$I=true;foreach($T
as$R)$I=$I&&$h->query(urlencode($R),array(),'DELETE');return$I;}function
last_id(){global$h;return$h->last_id;}$y="elastic";$Cf=array("=","query");$rd=array();$xd=array();$sc=array(array("json"));$Li=array();$Qh=array();foreach(array(lang(27)=>array("long"=>3,"integer"=>5,"short"=>8,"byte"=>10,"double"=>20,"float"=>66,"half_float"=>12,"scaled_float"=>21),lang(28)=>array("date"=>10),lang(25)=>array("string"=>65535,"text"=>65535),lang(29)=>array("binary"=>255),)as$z=>$X){$Li+=$X;$Qh[$z]=array_keys($X);}}$kc["clickhouse"]="ClickHouse (alpha)";if(isset($_GET["clickhouse"])){define("DRIVER","clickhouse");class
Min_DB{var$extension="JSON",$server_info,$errno,$_result,$error,$_url;var$_db='default';function
rootQuery($m,$G){@ini_set('track_errors',1);$ad=@file_get_contents("$this->_url/?database=$m",false,stream_context_create(array('http'=>array('method'=>'POST','content'=>$this->isQuerySelectLike($G)?"$G FORMAT JSONCompact":$G,'header'=>'Content-type: application/x-www-form-urlencoded','ignore_errors'=>1,))));if($ad===false){$this->error=$php_errormsg;return$ad;}if(!preg_match('~^HTTP/[0-9.]+ 2~i',$http_response_header[0])){$this->error=lang(32)." $http_response_header[0]";return
false;}$I=json_decode($ad,true);if($I===null){if(!$this->isQuerySelectLike($G)&&$ad==='')return
true;$this->errno=json_last_error();if(function_exists('json_last_error_msg'))$this->error=json_last_error_msg();else{$Cb=get_defined_constants(true);foreach($Cb['json']as$C=>$Y){if($Y==$this->errno&&preg_match('~^JSON_ERROR_~',$C)){$this->error=$C;break;}}}}return
new
Min_Result($I);}function
isQuerySelectLike($G){return(bool)preg_match('~^(select|show)~i',$G);}function
query($G){return$this->rootQuery($this->_db,$G);}function
connect($N,$V,$F){preg_match('~^(https?://)?(.*)~',$N,$B);$this->_url=($B[1]?$B[1]:"http://")."$V:$F@$B[2]";$I=$this->query('SELECT 1');return(bool)$I;}function
select_db($k){$this->_db=$k;return
true;}function
quote($Q){return"'".addcslashes($Q,"\\'")."'";}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$p=0){$H=$this->query($G);return$H['data'];}}class
Min_Result{var$num_rows,$_rows,$columns,$meta,$_offset=0;function
__construct($H){$this->num_rows=$H['rows'];$this->_rows=$H['data'];$this->meta=$H['meta'];$this->columns=array_column($this->meta,'name');reset($this->_rows);}function
fetch_assoc(){$J=current($this->_rows);next($this->_rows);return$J===false?false:array_combine($this->columns,$J);}function
fetch_row(){$J=current($this->_rows);next($this->_rows);return$J;}function
fetch_field(){$e=$this->_offset++;$I=new
stdClass;if($e<count($this->columns)){$I->name=$this->meta[$e]['name'];$I->orgname=$I->name;$I->type=$this->meta[$e]['type'];}return$I;}}class
Min_Driver
extends
Min_SQL{function
delete($R,$Eg,$_=0){if($Eg==='')$Eg='WHERE 1=1';return
queries("ALTER TABLE ".table($R)." DELETE $Eg");}function
update($R,$O,$Eg,$_=0,$M="\n"){$fj=array();foreach($O
as$z=>$X)$fj[]="$z = $X";$G=$M.implode(",$M",$fj);return
queries("ALTER TABLE ".table($R)." UPDATE $G$Eg");}}function
idf_escape($v){return"`".str_replace("`","``",$v)."`";}function
table($v){return
idf_escape($v);}function
explain($h,$G){return'';}function
found_rows($S,$Z){$K=get_vals("SELECT COUNT(*) FROM ".idf_escape($S["Name"]).($Z?" WHERE ".implode(" AND ",$Z):""));return
empty($K)?false:$K[0];}function
alter_table($R,$C,$q,$jd,$vb,$_c,$d,$Na,$cg){$c=$Hf=array();foreach($q
as$p){if($p[1][2]===" NULL")$p[1][1]=" Nullable({$p[1][1]})";elseif($p[1][2]===' NOT NULL')$p[1][2]='';if($p[1][3])$p[1][3]='';$c[]=($p[1]?($R!=""?($p[0]!=""?"MODIFY COLUMN ":"ADD COLUMN "):" ").implode($p[1]):"DROP COLUMN ".idf_escape($p[0]));$Hf[]=$p[1][0];}$c=array_merge($c,$jd);$P=($_c?" ENGINE ".$_c:"");if($R=="")return
queries("CREATE TABLE ".table($C)." (\n".implode(",\n",$c)."\n)$P$cg".' ORDER BY ('.implode(',',$Hf).')');if($R!=$C){$H=queries("RENAME TABLE ".table($R)." TO ".table($C));if($c)$R=$C;else
return$H;}if($P)$c[]=ltrim($P);return($c||$cg?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$c).$cg):true);}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($kj){return
drop_tables($kj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
connect(){global$b;$h=new
Min_DB;$Mb=$b->credentials();if($h->connect($Mb[0],$Mb[1],$Mb[2]))return$h;return$h->error;}function
get_databases($hd){global$h;$H=get_rows('SHOW DATABASES');$I=array();foreach($H
as$J)$I[]=$J['name'];sort($I);return$I;}function
limit($G,$Z,$_,$D=0,$M=" "){return" $G$Z".($_!==null?$M."LIMIT $_".($D?", $D":""):"");}function
limit1($R,$G,$Z,$M="\n"){return
limit($G,$Z,1,0,$M);}function
db_collation($m,$qb){}function
engines(){return
array('MergeTree');}function
logged_user(){global$b;$Mb=$b->credentials();return$Mb[1];}function
tables_list(){$H=get_rows('SHOW TABLES');$I=array();foreach($H
as$J)$I[$J['name']]='table';ksort($I);return$I;}function
count_tables($l){return
array();}function
table_status($C="",$Vc=false){global$h;$I=array();$T=get_rows("SELECT name, engine FROM system.tables WHERE database = ".q($h->_db));foreach($T
as$R){$I[$R['name']]=array('Name'=>$R['name'],'Engine'=>$R['engine'],);if($C===$R['name'])return$I[$R['name']];}return$I;}function
is_view($S){return
false;}function
fk_support($S){return
false;}function
convert_field($p){}function
unconvert_field($p,$I){if(in_array($p['type'],array("Int8","Int16","Int32","Int64","UInt8","UInt16","UInt32","UInt64","Float32","Float64")))return"to$p[type]($I)";return$I;}function
fields($R){$I=array();$H=get_rows("SELECT name, type, default_expression FROM system.columns WHERE ".idf_escape('table')." = ".q($R));foreach($H
as$J){$U=trim($J['type']);$nf=strpos($U,'Nullable(')===0;$I[trim($J['name'])]=array("field"=>trim($J['name']),"full_type"=>$U,"type"=>$U,"default"=>trim($J['default_expression']),"null"=>$nf,"auto_increment"=>'0',"privileges"=>array("insert"=>1,"select"=>1,"update"=>0),);}return$I;}function
indexes($R,$i=null){return
array();}function
foreign_keys($R){return
array();}function
collations(){return
array();}function
information_schema($m){return
false;}function
error(){global$h;return
h($h->error);}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($jh){return
true;}function
auto_increment(){return'';}function
last_id(){return
0;}function
support($Wc){return
preg_match("~^(columns|sql|status|table|drop_col)$~",$Wc);}$y="clickhouse";$Li=array();$Qh=array();foreach(array(lang(27)=>array("Int8"=>3,"Int16"=>5,"Int32"=>10,"Int64"=>19,"UInt8"=>3,"UInt16"=>5,"UInt32"=>10,"UInt64"=>20,"Float32"=>7,"Float64"=>16,'Decimal'=>38,'Decimal32'=>9,'Decimal64'=>18,'Decimal128'=>38),lang(28)=>array("Date"=>13,"DateTime"=>20),lang(25)=>array("String"=>0),lang(29)=>array("FixedString"=>0),)as$z=>$X){$Li+=$X;$Qh[$z]=array_keys($X);}$Si=array();$Cf=array("=","<",">","<=",">=","!=","~","!~","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");$rd=array();$xd=array("avg","count","count distinct","max","min","sum");$sc=array();}$kc=array("server"=>"MySQL")+$kc;if(!defined("DRIVER")){$qg=array("MySQLi","MySQL","PDO_MySQL");define("DRIVER","server");if(extension_loaded("mysqli")){class
Min_DB
extends
MySQLi{var$extension="MySQLi";function
__construct(){parent::init();}function
connect($N="",$V="",$F="",$k=null,$mg=null,$Ch=null){global$b;mysqli_report(MYSQLI_REPORT_OFF);list($Hd,$mg)=explode(":",$N,2);$Lh=$b->connectSsl();if($Lh)$this->ssl_set($Lh['key'],$Lh['cert'],$Lh['ca'],'','');$I=@$this->real_connect(($N!=""?$Hd:ini_get("mysqli.default_host")),($N.$V!=""?$V:ini_get("mysqli.default_user")),($N.$V.$F!=""?$F:ini_get("mysqli.default_pw")),$k,(is_numeric($mg)?$mg:ini_get("mysqli.default_port")),(!is_numeric($mg)?$mg:$Ch),($Lh?64:0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return$I;}function
set_charset($db){if(parent::set_charset($db))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $db");}function
result($G,$p=0){$H=$this->query($G);if(!$H)return
false;$J=$H->fetch_array();return$J[$p];}function
quote($Q){return"'".$this->escape_string($Q)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Min_DB{var$extension="MySQL",$server_info,$affected_rows,$errno,$error,$_link,$_result;function
connect($N,$V,$F){if(ini_bool("mysql.allow_local_infile")){$this->error=lang(33,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");return
false;}$this->_link=@mysql_connect(($N!=""?$N:ini_get("mysql.default_host")),("$N$V"!=""?$V:ini_get("mysql.default_user")),("$N$V$F"!=""?$F:ini_get("mysql.default_password")),true,131072);if($this->_link)$this->server_info=mysql_get_server_info($this->_link);else$this->error=mysql_error();return(bool)$this->_link;}function
set_charset($db){if(function_exists('mysql_set_charset')){if(mysql_set_charset($db,$this->_link))return
true;mysql_set_charset('utf8',$this->_link);}return$this->query("SET NAMES $db");}function
quote($Q){return"'".mysql_real_escape_string($Q,$this->_link)."'";}function
select_db($k){return
mysql_select_db($k,$this->_link);}function
query($G,$Mi=false){$H=@($Mi?mysql_unbuffered_query($G,$this->_link):mysql_query($G,$this->_link));$this->error="";if(!$H){$this->errno=mysql_errno($this->_link);$this->error=mysql_error($this->_link);return
false;}if($H===true){$this->affected_rows=mysql_affected_rows($this->_link);$this->info=mysql_info($this->_link);return
true;}return
new
Min_Result($H);}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$p=0){$H=$this->query($G);if(!$H||!$H->num_rows)return
false;return
mysql_result($H->_result,0,$p);}}class
Min_Result{var$num_rows,$_result,$_offset=0;function
__construct($H){$this->_result=$H;$this->num_rows=mysql_num_rows($H);}function
fetch_assoc(){return
mysql_fetch_assoc($this->_result);}function
fetch_row(){return
mysql_fetch_row($this->_result);}function
fetch_field(){$I=mysql_fetch_field($this->_result,$this->_offset++);$I->orgtable=$I->table;$I->orgname=$I->name;$I->charsetnr=($I->blob?63:0);return$I;}function
__destruct(){mysql_free_result($this->_result);}}}elseif(extension_loaded("pdo_mysql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_MySQL";function
connect($N,$V,$F){global$b;$Ff=array(PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$Lh=$b->connectSsl();if($Lh){if(!empty($Lh['key']))$Ff[PDO::MYSQL_ATTR_SSL_KEY]=$Lh['key'];if(!empty($Lh['cert']))$Ff[PDO::MYSQL_ATTR_SSL_CERT]=$Lh['cert'];if(!empty($Lh['ca']))$Ff[PDO::MYSQL_ATTR_SSL_CA]=$Lh['ca'];}$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$N)),$V,$F,$Ff);return
true;}function
set_charset($db){$this->query("SET NAMES $db");}function
select_db($k){return$this->query("USE ".idf_escape($k));}function
query($G,$Mi=false){$this->pdo->setAttribute(1000,!$Mi);return
parent::query($G,$Mi);}}}class
Min_Driver
extends
Min_SQL{function
insert($R,$O){return($O?parent::insert($R,$O):queries("INSERT INTO ".table($R)." ()\nVALUES ()"));}function
insertUpdate($R,$K,$tg){$f=array_keys(reset($K));$rg="INSERT INTO ".table($R)." (".implode(", ",$f).") VALUES\n";$fj=array();foreach($f
as$z)$fj[$z]="$z = VALUES($z)";$Th="\nON DUPLICATE KEY UPDATE ".implode(", ",$fj);$fj=array();$Ae=0;foreach($K
as$O){$Y="(".implode(", ",$O).")";if($fj&&(strlen($rg)+$Ae+strlen($Y)+strlen($Th)>1e6)){if(!queries($rg.implode(",\n",$fj).$Th))return
false;$fj=array();$Ae=0;}$fj[]=$Y;$Ae+=strlen($Y)+2;}return
queries($rg.implode(",\n",$fj).$Th);}function
slowQuery($G,$oi){if(min_version('5.7.8','10.1.2')){if(preg_match('~MariaDB~',$this->_conn->server_info))return"SET STATEMENT max_statement_time=$oi FOR $G";elseif(preg_match('~^(SELECT\b)(.+)~is',$G,$B))return"$B[1] /*+ MAX_EXECUTION_TIME(".($oi*1000).") */ $B[2]";}}function
convertSearch($v,$X,$p){return(preg_match('~char|text|enum|set~',$p["type"])&&!preg_match("~^utf8~",$p["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($v USING ".charset($this->_conn).")":$v);}function
warnings(){$H=$this->_conn->query("SHOW WARNINGS");if($H&&$H->num_rows){ob_start();select($H);return
ob_get_clean();}}function
tableHelp($C){$Ie=preg_match('~MariaDB~',$this->_conn->server_info);if(information_schema(DB))return
strtolower(($Ie?"information-schema-$C-table/":str_replace("_","-",$C)."-table.html"));if(DB=="mysql")return($Ie?"mysql$C-table/":"system-database.html");}}function
idf_escape($v){return"`".str_replace("`","``",$v)."`";}function
table($v){return
idf_escape($v);}function
connect(){global$b,$Li,$Qh;$h=new
Min_DB;$Mb=$b->credentials();if($h->connect($Mb[0],$Mb[1],$Mb[2])){$h->set_charset(charset($h));$h->query("SET sql_quote_show_create = 1, autocommit = 1");if(min_version('5.7.8',10.2,$h)){$Qh[lang(25)][]="json";$Li["json"]=4294967295;}return$h;}$I=$h->error;if(function_exists('iconv')&&!is_utf8($I)&&strlen($hh=iconv("windows-1250","utf-8",$I))>strlen($I))$I=$hh;return$I;}function
get_databases($hd){$I=get_session("dbs");if($I===null){$G=(min_version(5)?"SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME":"SHOW DATABASES");$I=($hd?slow_query($G):get_vals($G));restart_session();set_session("dbs",$I);stop_session();}return$I;}function
limit($G,$Z,$_,$D=0,$M=" "){return" $G$Z".($_!==null?$M."LIMIT $_".($D?" OFFSET $D":""):"");}function
limit1($R,$G,$Z,$M="\n"){return
limit($G,$Z,1,0,$M);}function
db_collation($m,$qb){global$h;$I=null;$j=$h->result("SHOW CREATE DATABASE ".idf_escape($m),1);if(preg_match('~ COLLATE ([^ ]+)~',$j,$B))$I=$B[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$j,$B))$I=$qb[$B[1]][-1];return$I;}function
engines(){$I=array();foreach(get_rows("SHOW ENGINES")as$J){if(preg_match("~YES|DEFAULT~",$J["Support"]))$I[]=$J["Engine"];}return$I;}function
logged_user(){global$h;return$h->result("SELECT USER()");}function
tables_list(){return
get_key_vals(min_version(5)?"SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME":"SHOW TABLES");}function
count_tables($l){$I=array();foreach($l
as$m)$I[$m]=count(get_vals("SHOW TABLES IN ".idf_escape($m)));return$I;}function
table_status($C="",$Vc=false){$I=array();foreach(get_rows($Vc&&min_version(5)?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($C!=""?"AND TABLE_NAME = ".q($C):"ORDER BY Name"):"SHOW TABLE STATUS".($C!=""?" LIKE ".q(addcslashes($C,"%_\\")):""))as$J){if($J["Engine"]=="InnoDB")$J["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$J["Comment"]);if(!isset($J["Engine"]))$J["Comment"]="";if($C!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($S){return$S["Engine"]===null;}function
fk_support($S){return
preg_match('~InnoDB|IBMDB2I~i',$S["Engine"])||(preg_match('~NDB~i',$S["Engine"])&&min_version(5.6));}function
fields($R){$I=array();foreach(get_rows("SHOW FULL COLUMNS FROM ".table($R))as$J){preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$J["Type"],$B);$I[$J["Field"]]=array("field"=>$J["Field"],"full_type"=>$J["Type"],"type"=>$B[1],"length"=>$B[2],"unsigned"=>ltrim($B[3].$B[4]),"default"=>($J["Default"]!=""||preg_match("~char|set~",$B[1])?(preg_match('~text~',$B[1])?stripslashes(preg_replace("~^'(.*)'\$~",'\1',$J["Default"])):$J["Default"]):null),"null"=>($J["Null"]=="YES"),"auto_increment"=>($J["Extra"]=="auto_increment"),"on_update"=>(preg_match('~^on update (.+)~i',$J["Extra"],$B)?$B[1]:""),"collation"=>$J["Collation"],"privileges"=>array_flip(preg_split('~, *~',$J["Privileges"])),"comment"=>$J["Comment"],"primary"=>($J["Key"]=="PRI"),"generated"=>preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$J["Extra"]),);}return$I;}function
indexes($R,$i=null){$I=array();foreach(get_rows("SHOW INDEX FROM ".table($R),$i)as$J){$C=$J["Key_name"];$I[$C]["type"]=($C=="PRIMARY"?"PRIMARY":($J["Index_type"]=="FULLTEXT"?"FULLTEXT":($J["Non_unique"]?($J["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$I[$C]["columns"][]=$J["Column_name"];$I[$C]["lengths"][]=($J["Index_type"]=="SPATIAL"?null:$J["Sub_part"]);$I[$C]["descs"][]=null;}return$I;}function
foreign_keys($R){global$h,$yf;static$ig='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$I=array();$Kb=$h->result("SHOW CREATE TABLE ".table($R),1);if($Kb){preg_match_all("~CONSTRAINT ($ig) FOREIGN KEY ?\\(((?:$ig,? ?)+)\\) REFERENCES ($ig)(?:\\.($ig))? \\(((?:$ig,? ?)+)\\)(?: ON DELETE ($yf))?(?: ON UPDATE ($yf))?~",$Kb,$Le,PREG_SET_ORDER);foreach($Le
as$B){preg_match_all("~$ig~",$B[2],$Eh);preg_match_all("~$ig~",$B[5],$gi);$I[idf_unescape($B[1])]=array("db"=>idf_unescape($B[4]!=""?$B[3]:$B[4]),"table"=>idf_unescape($B[4]!=""?$B[4]:$B[3]),"source"=>array_map('idf_unescape',$Eh[0]),"target"=>array_map('idf_unescape',$gi[0]),"on_delete"=>($B[6]?$B[6]:"RESTRICT"),"on_update"=>($B[7]?$B[7]:"RESTRICT"),);}}return$I;}function
view($C){global$h;return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',$h->result("SHOW CREATE VIEW ".table($C),1)));}function
collations(){$I=array();foreach(get_rows("SHOW COLLATION")as$J){if($J["Default"])$I[$J["Charset"]][-1]=$J["Collation"];else$I[$J["Charset"]][]=$J["Collation"];}ksort($I);foreach($I
as$z=>$X)asort($I[$z]);return$I;}function
information_schema($m){return(min_version(5)&&$m=="information_schema")||(min_version(5.5)&&$m=="performance_schema");}function
error(){global$h;return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",$h->error));}function
create_database($m,$d){return
queries("CREATE DATABASE ".idf_escape($m).($d?" COLLATE ".q($d):""));}function
drop_databases($l){$I=apply_queries("DROP DATABASE",$l,'idf_escape');restart_session();set_session("dbs",null);return$I;}function
rename_database($C,$d){$I=false;if(create_database($C,$d)){$Tg=array();foreach(tables_list()as$R=>$U)$Tg[]=table($R)." TO ".idf_escape($C).".".table($R);$I=(!$Tg||queries("RENAME TABLE ".implode(", ",$Tg)));if($I)queries("DROP DATABASE ".idf_escape(DB));restart_session();set_session("dbs",null);}return$I;}function
auto_increment(){$Oa=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$w){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$w["columns"],true)){$Oa="";break;}if($w["type"]=="PRIMARY")$Oa=" UNIQUE";}}return" AUTO_INCREMENT$Oa";}function
alter_table($R,$C,$q,$jd,$vb,$_c,$d,$Na,$cg){$c=array();foreach($q
as$p)$c[]=($p[1]?($R!=""?($p[0]!=""?"CHANGE ".idf_escape($p[0]):"ADD"):" ")." ".implode($p[1]).($R!=""?$p[2]:""):"DROP ".idf_escape($p[0]));$c=array_merge($c,$jd);$P=($vb!==null?" COMMENT=".q($vb):"").($_c?" ENGINE=".q($_c):"").($d?" COLLATE ".q($d):"").($Na!=""?" AUTO_INCREMENT=$Na":"");if($R=="")return
queries("CREATE TABLE ".table($C)." (\n".implode(",\n",$c)."\n)$P$cg");if($R!=$C)$c[]="RENAME TO ".table($C);if($P)$c[]=ltrim($P);return($c||$cg?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$c).$cg):true);}function
alter_indexes($R,$c){foreach($c
as$z=>$X)$c[$z]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($R).implode(",",$c));}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($kj){return
queries("DROP VIEW ".implode(", ",array_map('table',$kj)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('table',$T)));}function
move_tables($T,$kj,$gi){$Tg=array();foreach(array_merge($T,$kj)as$R)$Tg[]=table($R)." TO ".idf_escape($gi).".".table($R);return
queries("RENAME TABLE ".implode(", ",$Tg));}function
copy_tables($T,$kj,$gi){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($T
as$R){$C=($gi==DB?table("copy_$R"):idf_escape($gi).".".table($R));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $C"))||!queries("CREATE TABLE $C LIKE ".table($R))||!queries("INSERT INTO $C SELECT * FROM ".table($R)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$J){$Fi=$J["Trigger"];if(!queries("CREATE TRIGGER ".($gi==DB?idf_escape("copy_$Fi"):idf_escape($gi).".".idf_escape($Fi))." $J[Timing] $J[Event] ON $C FOR EACH ROW\n$J[Statement];"))return
false;}}foreach($kj
as$R){$C=($gi==DB?table("copy_$R"):idf_escape($gi).".".table($R));$jj=view($R);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $C"))||!queries("CREATE VIEW $C AS $jj[select]"))return
false;}return
true;}function
trigger($C){if($C=="")return
array();$K=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($C));return
reset($K);}function
triggers($R){$I=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$J)$I[$J["Trigger"]]=array($J["Timing"],$J["Event"]);return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($C,$U){global$h,$Bc,$Yd,$Li;$Da=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$Fh="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Ki="((".implode("|",array_merge(array_keys($Li),$Da)).")\\b(?:\\s*\\(((?:[^'\")]|$Bc)++)\\))?\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$ig="$Fh*(".($U=="FUNCTION"?"":$Yd).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$Ki";$j=$h->result("SHOW CREATE $U ".idf_escape($C),2);preg_match("~\\(((?:$ig\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$Ki\\s+":"")."(.*)~is",$j,$B);$q=array();preg_match_all("~$ig\\s*,?~is",$B[1],$Le,PREG_SET_ORDER);foreach($Le
as$Vf)$q[]=array("field"=>str_replace("``","`",$Vf[2]).$Vf[3],"type"=>strtolower($Vf[5]),"length"=>preg_replace_callback("~$Bc~s",'normalize_enum',$Vf[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$Vf[8] $Vf[7]"))),"null"=>1,"full_type"=>$Vf[4],"inout"=>strtoupper($Vf[1]),"collation"=>strtolower($Vf[9]),);if($U!="FUNCTION")return
array("fields"=>$q,"definition"=>$B[11]);return
array("fields"=>$q,"returns"=>array("type"=>$B[12],"length"=>$B[13],"unsigned"=>$B[15],"collation"=>$B[16]),"definition"=>$B[17],"language"=>"SQL",);}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = ".q(DB));}function
routine_languages(){return
array();}function
routine_id($C,$J){return
idf_escape($C);}function
last_id(){global$h;return$h->result("SELECT LAST_INSERT_ID()");}function
explain($h,$G){return$h->query("EXPLAIN ".(min_version(5.1)?"PARTITIONS ":"").$G);}function
found_rows($S,$Z){return($Z||$S["Engine"]!="InnoDB"?null:$S["Rows"]);}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($jh,$i=null){return
true;}function
create_sql($R,$Na,$Rh){global$h;$I=$h->result("SHOW CREATE TABLE ".table($R),1);if(!$Na)$I=preg_replace('~ AUTO_INCREMENT=\d+~','',$I);return$I;}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
use_sql($k){return"USE ".idf_escape($k);}function
trigger_sql($R){$I="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")),null,"-- ")as$J)$I.="\nCREATE TRIGGER ".idf_escape($J["Trigger"])." $J[Timing] $J[Event] ON ".table($J["Table"])." FOR EACH ROW\n$J[Statement];;\n";return$I;}function
show_variables(){return
get_key_vals("SHOW VARIABLES");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
show_status(){return
get_key_vals("SHOW STATUS");}function
convert_field($p){if(preg_match("~binary~",$p["type"]))return"HEX(".idf_escape($p["field"]).")";if($p["type"]=="bit")return"BIN(".idf_escape($p["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$p["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($p["field"]).")";}function
unconvert_field($p,$I){if(preg_match("~binary~",$p["type"]))$I="UNHEX($I)";if($p["type"]=="bit")$I="CONV($I, 2, 10) + 0";if(preg_match("~geometry|point|linestring|polygon~",$p["type"]))$I=(min_version(8)?"ST_":"")."GeomFromText($I, SRID($p[field]))";return$I;}function
support($Wc){return!preg_match("~scheme|sequence|type|view_trigger|materializedview".(min_version(8)?"":"|descidx".(min_version(5.1)?"":"|event|partitioning".(min_version(5)?"":"|routine|trigger|view")))."~",$Wc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){global$h;return$h->result("SELECT @@max_connections");}$y="sql";$Li=array();$Qh=array();foreach(array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(28)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(25)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(34)=>array("enum"=>65535,"set"=>64),lang(29)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(31)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),)as$z=>$X){$Li+=$X;$Qh[$z]=array_keys($X);}$Si=array("unsigned","zerofill","unsigned zerofill");$Cf=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");$rd=array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper");$xd=array("avg","count","count distinct","group_concat","max","min","sum");$sc=array(array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",),array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",));}define("SERVER",$_GET[DRIVER]);define("DB",$_GET["db"]);define("ME",preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));$ia="4.7.9";class
Adminer{var$operators;function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($j=false){return
password_file($j);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($N){return
h($N);}function
database(){return
DB;}function
databases($hd=true){return
get_databases($hd);}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
headers(){}function
csp(){return
csp();}function
head(){return
true;}function
css(){$I=array();$bd="adminer.css";if(file_exists($bd))$I[]="$bd?v=".crc32(file_get_contents($bd));return$I;}function
loginForm(){global$kc;echo"<table cellspacing='0' class='layout'>\n",$this->loginFormField('driver','<tr><th>'.lang(35).'<td>',html_select("auth[driver]",$kc,DRIVER,"loginDriver(this);")."\n"),$this->loginFormField('server','<tr><th>'.lang(36).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'."\n"),$this->loginFormField('username','<tr><th>'.lang(37).'<td>','<input name="auth[username]" id="username" value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("focus(qs('#username')); qs('#username').form['auth[driver]'].onchange();")),$this->loginFormField('password','<tr><th>'.lang(38).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'."\n"),$this->loginFormField('db','<tr><th>'.lang(39).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'."\n"),"</table>\n","<p><input type='submit' value='".lang(40)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(41))."\n";}function
loginFormField($C,$Dd,$Y){return$Dd.$Y;}function
login($Fe,$F){if($F=="")return
lang(42,target_blank());return
true;}function
tableName($Xh){return
h($Xh["Name"]);}function
fieldName($p,$Hf=0){return'<span title="'.h($p["full_type"]).'">'.h($p["field"]).'</span>';}function
selectLinks($Xh,$O=""){global$y,$n;echo'<p class="links">';$De=array("select"=>lang(43));if(support("table")||support("indexes"))$De["table"]=lang(44);if(support("table")){if(is_view($Xh))$De["view"]=lang(45);else$De["create"]=lang(46);}if($O!==null)$De["edit"]=lang(47);$C=$Xh["Name"];foreach($De
as$z=>$X)echo" <a href='".h(ME)."$z=".urlencode($C).($z=="edit"?$O:"")."'".bold(isset($_GET[$z])).">$X</a>";echo
doc_link(array($y=>$n->tableHelp($C)),"?"),"\n";}function
foreignKeys($R){return
foreign_keys($R);}function
backwardKeys($R,$Wh){return
array();}function
backwardKeysPrint($Qa,$J){}function
selectQuery($G,$Mh,$Uc=false){global$y,$n;$I="</p>\n";if(!$Uc&&($nj=$n->warnings())){$u="warnings";$I=", <a href='#$u'>".lang(48)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."$I<div id='$u' class='hidden'>\n$nj</div>\n";}return"<p><code class='jush-$y'>".h(str_replace("\n"," ",$G))."</code> <span class='time'>(".format_time($Mh).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($G)."'>".lang(10)."</a>":"").$I;}function
sqlCommandQuery($G){return
shorten_utf8(trim($G),1000);}function
rowDescription($R){return"";}function
rowDescriptions($K,$kd){return$K;}function
selectLink($X,$p){}function
selectVal($X,$A,$p,$Pf){$I=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$p["type"])&&!preg_match("~var~",$p["type"])?"<code>$X</code>":$X));if(preg_match('~blob|bytea|raw|file~',$p["type"])&&!is_utf8($X))$I="<i>".lang(49,strlen($Pf))."</i>";if(preg_match('~json~',$p["type"]))$I="<code class='jush-js'>$I</code>";return($A?"<a href='".h($A)."'".(is_url($A)?target_blank():"").">$I</a>":$I);}function
editVal($X,$p){return$X;}function
tableStructurePrint($q){echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap'>\n","<thead><tr><th>".lang(50)."<td>".lang(51).(support("comment")?"<td>".lang(52):"")."</thead>\n";foreach($q
as$p){echo"<tr".odd()."><th>".h($p["field"]),"<td><span title='".h($p["collation"])."'>".h($p["full_type"])."</span>",($p["null"]?" <i>NULL</i>":""),($p["auto_increment"]?" <i>".lang(53)."</i>":""),(isset($p["default"])?" <span title='".lang(54)."'>[<b>".h($p["default"])."</b>]</span>":""),(support("comment")?"<td>".h($p["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint($x){echo"<table cellspacing='0'>\n";foreach($x
as$C=>$w){ksort($w["columns"]);$vg=array();foreach($w["columns"]as$z=>$X)$vg[]="<i>".h($X)."</i>".($w["lengths"][$z]?"(".$w["lengths"][$z].")":"").($w["descs"][$z]?" DESC":"");echo"<tr title='".h($C)."'><th>$w[type]<td>".implode(", ",$vg)."\n";}echo"</table>\n";}function
selectColumnsPrint($L,$f){global$rd,$xd;print_fieldset("select",lang(55),$L);$t=0;$L[""]=array();foreach($L
as$z=>$X){$X=$_GET["columns"][$z];$e=select_input(" name='columns[$t][col]'",$f,$X["col"],($z!==""?"selectFieldChange":"selectAddRow"));echo"<div>".($rd||$xd?"<select name='columns[$t][fun]'>".optionlist(array(-1=>"")+array_filter(array(lang(56)=>$rd,lang(57)=>$xd)),$X["fun"])."</select>".on_help("getTarget(event).value && getTarget(event).value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($z!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($e)":$e)."</div>\n";$t++;}echo"</div></fieldset>\n";}function
selectSearchPrint($Z,$f,$x){print_fieldset("search",lang(58),$Z);foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT"){echo"<div>(<i>".implode("</i>, <i>",array_map('h',$w["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$t]' value='".h($_GET["fulltext"][$t])."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$t]",1,isset($_GET["boolean"][$t]),"BOOL"),"</div>\n";}}$cb="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$t=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators))){echo"<div>".select_input(" name='where[$t][col]'",$f,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(59).")"),html_select("where[$t][op]",$this->operators,$X["op"],$cb),"<input type='search' name='where[$t][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $cb }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}}echo"</div></fieldset>\n";}function
selectOrderPrint($Hf,$f,$x){print_fieldset("sort",lang(60),$Hf);$t=0;foreach((array)$_GET["order"]as$z=>$X){if($X!=""){echo"<div>".select_input(" name='order[$t]'",$f,$X,"selectFieldChange"),checkbox("desc[$t]",1,isset($_GET["desc"][$z]),lang(61))."</div>\n";$t++;}}echo"<div>".select_input(" name='order[$t]'",$f,"","selectAddRow"),checkbox("desc[$t]",1,false,lang(61))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($_){echo"<fieldset><legend>".lang(62)."</legend><div>";echo"<input type='number' name='limit' class='size' value='".h($_)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($mi){if($mi!==null){echo"<fieldset><legend>".lang(63)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($mi)."'>","</div></fieldset>\n";}}function
selectActionPrint($x){echo"<fieldset><legend>".lang(64)."</legend><div>","<input type='submit' value='".lang(55)."'>"," <span id='noindex' title='".lang(65)."'></span>","<script".nonce().">\n","var indexColumns = ";$f=array();foreach($x
as$w){$Qb=reset($w["columns"]);if($w["type"]!="FULLTEXT"&&$Qb)$f[$Qb]=1;}$f[""]=1;foreach($f
as$z=>$X)json_row($z);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint($xc,$f){}function
selectColumnsProcess($f,$x){global$rd,$xd;$L=array();$ud=array();foreach((array)$_GET["columns"]as$z=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],$rd)||in_array($X["fun"],$xd)))){$L[$z]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],$xd))$ud[]=$L[$z];}}return
array($L,$ud);}function
selectSearchProcess($q,$x){global$h,$n;$I=array();foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT"&&$_GET["fulltext"][$t]!="")$I[]="MATCH (".implode(", ",array_map('idf_escape',$w["columns"])).") AGAINST (".q($_GET["fulltext"][$t]).(isset($_GET["boolean"][$t])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$z=>$X){if("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators)){$rg="";$yb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Od=process_length($X["val"]);$yb.=" ".($Od!=""?$Od:"(NULL)");}elseif($X["op"]=="SQL")$yb=" $X[val]";elseif($X["op"]=="LIKE %%")$yb=" LIKE ".$this->processInput($q[$X["col"]],"%$X[val]%");elseif($X["op"]=="ILIKE %%")$yb=" ILIKE ".$this->processInput($q[$X["col"]],"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$rg="$X[op](".q($X["val"]).", ";$yb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$yb.=" ".$this->processInput($q[$X["col"]],$X["val"]);if($X["col"]!="")$I[]=$rg.$n->convertSearch(idf_escape($X["col"]),$X,$q[$X["col"]]).$yb;else{$sb=array();foreach($q
as$C=>$p){if((preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$p["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$p["type"])))$sb[]=$rg.$n->convertSearch(idf_escape($C),$X,$p).$yb;}$I[]=($sb?"(".implode(" OR ",$sb).")":"1 = 0");}}}return$I;}function
selectOrderProcess($q,$x){$I=array();foreach((array)$_GET["order"]as$z=>$X){if($X!="")$I[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$z])?" DESC":"");}return$I;}function
selectLimitProcess(){return(isset($_GET["limit"])?$_GET["limit"]:"50");}function
selectLengthProcess(){return(isset($_GET["text_length"])?$_GET["text_length"]:"100");}function
selectEmailProcess($Z,$kd){return
false;}function
selectQueryBuild($L,$Z,$ud,$Hf,$_,$E){return"";}function
messageQuery($G,$ni,$Uc=false){global$y,$n;restart_session();$Ed=&get_session("queries");if(!$Ed[$_GET["db"]])$Ed[$_GET["db"]]=array();if(strlen($G)>1e6)$G=preg_replace('~[\x80-\xFF]+$~','',substr($G,0,1e6))."\n…";$Ed[$_GET["db"]][]=array($G,time(),$ni);$Jh="sql-".count($Ed[$_GET["db"]]);$I="<a href='#$Jh' class='toggle'>".lang(66)."</a>\n";if(!$Uc&&($nj=$n->warnings())){$u="warnings-".count($Ed[$_GET["db"]]);$I="<a href='#$u' class='toggle'>".lang(48)."</a>, $I<div id='$u' class='hidden'>\n$nj</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $I<div id='$Jh' class='hidden'><pre><code class='jush-$y'>".shorten_utf8($G,1000)."</code></pre>".($ni?" <span class='time'>($ni)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($Ed[$_GET["db"]])-1)).'">'.lang(10).'</a>':'').'</div>';}function
editFunctions($p){global$sc;$I=($p["null"]?"NULL/":"");foreach($sc
as$z=>$rd){if(!$z||(!isset($_GET["call"])&&(isset($_GET["select"])||where($_GET)))){foreach($rd
as$ig=>$X){if(!$ig||preg_match("~$ig~",$p["type"]))$I.="/$X";}if($z&&!preg_match('~set|blob|bytea|raw|file|bool~',$p["type"]))$I.="/SQL";}}if($p["auto_increment"]&&!isset($_GET["select"])&&!where($_GET))$I=lang(53);return
explode("/",$I);}function
editInput($R,$p,$Ka,$Y){if($p["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$Ka value='-1' checked><i>".lang(8)."</i></label> ":"").($p["null"]?"<label><input type='radio'$Ka value=''".($Y!==null||isset($_GET["select"])?"":" checked")."><i>NULL</i></label> ":"").enum_input("radio",$Ka,$p,$Y,0);return"";}function
editHint($R,$p,$Y){return"";}function
processInput($p,$Y,$s=""){if($s=="SQL")return$Y;$C=$p["field"];$I=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$s))$I="$s()";elseif(preg_match('~^current_(date|timestamp)$~',$s))$I=$s;elseif(preg_match('~^([+-]|\|\|)$~',$s))$I=idf_escape($C)." $s $I";elseif(preg_match('~^[+-] interval$~',$s))$I=idf_escape($C)." $s ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)?$Y:$I);elseif(preg_match('~^(addtime|subtime|concat)$~',$s))$I="$s(".idf_escape($C).", $I)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$s))$I="$s($I)";return
unconvert_field($p,$I);}function
dumpOutput(){$I=array('text'=>lang(67),'file'=>lang(68));if(function_exists('gzencode'))$I['gz']='gzip';return$I;}function
dumpFormat(){return
array('sql'=>'SQL','csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($m){}function
dumpTable($R,$Rh,$he=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($Rh)dump_csv(array_keys(fields($R)));}else{if($he==2){$q=array();foreach(fields($R)as$C=>$p)$q[]=idf_escape($C)." $p[full_type]";$j="CREATE TABLE ".table($R)." (".implode(", ",$q).")";}else$j=create_sql($R,$_POST["auto_increment"],$Rh);set_utf8mb4($j);if($Rh&&$j){if($Rh=="DROP+CREATE"||$he==1)echo"DROP ".($he==2?"VIEW":"TABLE")." IF EXISTS ".table($R).";\n";if($he==1)$j=remove_definer($j);echo"$j;\n\n";}}}function
dumpData($R,$Rh,$G){global$h,$y;$Ne=($y=="sqlite"?0:1048576);if($Rh){if($_POST["format"]=="sql"){if($Rh=="TRUNCATE+INSERT")echo
truncate_sql($R).";\n";$q=fields($R);}$H=$h->query($G,1);if($H){$ae="";$Za="";$oe=array();$Th="";$Xc=($R!=''?'fetch_assoc':'fetch_row');while($J=$H->$Xc()){if(!$oe){$fj=array();foreach($J
as$X){$p=$H->fetch_field();$oe[]=$p->name;$z=idf_escape($p->name);$fj[]="$z = VALUES($z)";}$Th=($Rh=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$fj):"").";\n";}if($_POST["format"]!="sql"){if($Rh=="table"){dump_csv($oe);$Rh="INSERT";}dump_csv($J);}else{if(!$ae)$ae="INSERT INTO ".table($R)." (".implode(", ",array_map('idf_escape',$oe)).") VALUES";foreach($J
as$z=>$X){$p=$q[$z];$J[$z]=($X!==null?unconvert_field($p,preg_match(number_type(),$p["type"])&&!preg_match('~\[~',$p["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$hh=($Ne?"\n":" ")."(".implode(",\t",$J).")";if(!$Za)$Za=$ae.$hh;elseif(strlen($Za)+4+strlen($hh)+strlen($Th)<$Ne)$Za.=",$hh";else{echo$Za.$Th;$Za=$ae.$hh;}}}if($Za)echo$Za.$Th;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",$h->error)."\n";}}function
dumpFilename($Jd){return
friendly_url($Jd!=""?$Jd:(SERVER!=""?SERVER:"localhost"));}function
dumpHeaders($Jd,$cf=false){$Sf=$_POST["output"];$Pc=(preg_match('~sql~',$_POST["format"])?"sql":($cf?"tar":"csv"));header("Content-Type: ".($Sf=="gz"?"application/x-gzip":($Pc=="tar"?"application/x-tar":($Pc=="sql"||$Sf!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($Sf=="gz")ob_start('ob_gzencode',1e6);return$Pc;}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.lang(69)."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(70):lang(71))."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.lang(72)."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".lang(73)."</a>\n":"");return
true;}function
navigation($bf){global$ia,$y,$kc,$h;echo'<h1>
',$this->name(),' <span class="version">',$ia,'</span>
<a href="https://www.adminer.org/#download"',target_blank(),' id="version">',(version_compare($ia,$_COOKIE["adminer_version"])<0?h($_COOKIE["adminer_version"]):""),'</a>
</h1>
';if($bf=="auth"){$Sf="";foreach((array)$_SESSION["pwds"]as$hj=>$vh){foreach($vh
as$N=>$cj){foreach($cj
as$V=>$F){if($F!==null){$Wb=$_SESSION["db"][$hj][$N][$V];foreach(($Wb?array_keys($Wb):array(""))as$m)$Sf.="<li><a href='".h(auth_url($hj,$N,$V,$m))."'>($kc[$hj]) ".h($V.($N!=""?"@".$this->serverName($N):"").($m!=""?" - $m":""))."</a>\n";}}}}if($Sf)echo"<ul id='logins'>\n$Sf</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{if($_GET["ns"]!==""&&!$bf&&DB!=""){$h->select_db(DB);$T=table_status('',true);}echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=4.7.9");if(support("sql")){echo'<script',nonce(),'>
';if($T){$De=array();foreach($T
as$R=>$U)$De[]=preg_quote($R,'/');echo"var jushLinks = { $y: [ '".js_escape(ME).(support("table")?"table=":"select=")."\$&', /\\b(".implode("|",$De).")\\b/g ] };\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.$y;\n";}$uh=$h->server_info;echo'bodyLoad(\'',(is_object($h)?preg_replace('~^(\d\.?\d).*~s','\1',$uh):""),'\'',(preg_match('~MariaDB~',$uh)?", true":""),');
</script>
';}$this->databasesPrint($bf);if(DB==""||!$bf){echo"<p class='links'>".(support("sql")?"<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(66)."</a>\n<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(74)."</a>\n":"")."";if(support("dump"))echo"<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(75)."</a>\n";}if($_GET["ns"]!==""&&!$bf&&DB!=""){echo'<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(76)."</a>\n";if(!$T)echo"<p class='message'>".lang(9)."\n";else$this->tablesPrint($T);}}}function
databasesPrint($bf){global$b,$h;$l=$this->databases();if(DB&&$l&&!in_array(DB,$l))array_unshift($l,DB);echo'<form action="">
<p id="dbs">
';hidden_fields_get();$Ub=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<span title='".lang(77)."'>".lang(78)."</span>: ".($l?"<select name='db'>".optionlist(array(""=>"")+$l,DB)."</select>$Ub":"<input name='db' value='".h(DB)."' autocapitalize='off'>\n"),"<input type='submit' value='".lang(20)."'".($l?" class='hidden'":"").">\n";if($bf!="db"&&DB!=""&&$h->select_db(DB)){if(support("scheme")){echo"<br>".lang(79).": <select name='ns'>".optionlist(array(""=>"")+$b->schemas(),$_GET["ns"])."</select>$Ub";if($_GET["ns"]!="")set_schema($_GET["ns"]);}}foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo"<input type='hidden' name='$X' value=''>";break;}}echo"</p></form>\n";}function
tablesPrint($T){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($T
as$R=>$P){$C=$this->tableName($P);if($C!=""){echo'<li><a href="'.h(ME).'select='.urlencode($R).'"'.bold($_GET["select"]==$R||$_GET["edit"]==$R,"select")." title='".lang(43)."'>".lang(80)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($R).'"'.bold(in_array($R,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"])),(is_view($P)?"view":"structure"))." title='".lang(44)."'>$C</a>":"<span>$C</span>")."\n";}}echo"</ul>\n";}}$b=(function_exists('adminer_object')?adminer_object():new
Adminer);if($b->operators===null)$b->operators=$Cf;function
page_header($qi,$o="",$Ya=array(),$ri=""){global$ca,$ia,$b,$kc,$y;page_headers();if(is_ajax()&&$o){page_messages($o);exit;}$si=$qi.($ri!=""?": $ri":"");$ti=strip_tags($si.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".$b->name());echo'<!DOCTYPE html>
<html lang="',$ca,'" dir="',lang(81),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<title>',$ti,'</title>
<link rel="stylesheet" type="text/css" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=4.7.9"),'">
',script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=4.7.9");if($b->head()){echo'<link rel="shortcut icon" type="image/x-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.7.9"),'">
<link rel="apple-touch-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.7.9"),'">
';foreach($b->css()as$Ob){echo'<link rel="stylesheet" type="text/css" href="',h($Ob),'">
';}}echo'
<body class="',lang(81),' nojs">
';$bd=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($bd)&&filemtime($bd)+86400>time()){$ij=unserialize(file_get_contents($bd));$Bg="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($ij["version"],base64_decode($ij["signature"]),$Bg)==1)$_COOKIE["adminer_version"]=$ij["version"];}echo'<script',nonce(),'>
mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick',(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '$ia', '".js_escape(ME)."', '".get_token()."')");?>});
document.body.className = document.body.className.replace(/ nojs/, ' js');
var offlineMessage = '<?php echo
js_escape(lang(82)),'\';
var thousandsSeparator = \'',js_escape(lang(5)),'\';
</script>

<div id="help" class="jush-',$y,' jsonly hidden"></div>
',script("mixin(qs('#help'), {onmouseover: function () { helpOpen = 1; }, onmouseout: helpMouseout});"),'
<div id="content">
';if($Ya!==null){$A=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($A?$A:".").'">'.$kc[DRIVER].'</a> &raquo; ';$A=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$N=$b->serverName(SERVER);$N=($N!=""?$N:lang(36));if($Ya===false)echo"$N\n";else{echo"<a href='".h($A)."' accesskey='1' title='Alt+Shift+1'>$N</a> &raquo; ";if($_GET["ns"]!=""||(DB!=""&&is_array($Ya)))echo'<a href="'.h($A."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> &raquo; ';if(is_array($Ya)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> &raquo; ';foreach($Ya
as$z=>$X){$dc=(is_array($X)?$X[1]:h($X));if($dc!="")echo"<a href='".h(ME."$z=").urlencode(is_array($X)?$X[0]:$X)."'>$dc</a> &raquo; ";}}echo"$qi\n";}}echo"<h2>$si</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($o);$l=&get_session("dbs");if(DB!=""&&$l&&!in_array(DB,$l,true))$l=null;stop_session();define("PAGE_HEADER",1);}function
page_headers(){global$b;header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach($b->csp()as$Nb){$Cd=array();foreach($Nb
as$z=>$X)$Cd[]="$z $X";header("Content-Security-Policy: ".implode("; ",$Cd));}$b->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$lf;if(!$lf)$lf=base64_encode(rand_string());return$lf;}function
page_messages($o){$Ui=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$Xe=$_SESSION["messages"][$Ui];if($Xe){echo"<div class='message'>".implode("</div>\n<div class='message'>",$Xe)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$Ui]);}if($o)echo"<div class='error'>$o</div>\n";}function
page_footer($bf=""){global$b,$xi;echo'</div>

';switch_lang();if($bf!="auth"){echo'<form action="" method="post">
<p class="logout">
<input type="submit" name="logout" value="',lang(83),'" id="logout">
<input type="hidden" name="token" value="',$xi,'">
</p>
</form>
';}echo'<div id="menu">
';$b->navigation($bf);echo'</div>
',script("setupSubmitHighlight(document);");}function
int32($ef){while($ef>=2147483648)$ef-=4294967296;while($ef<=-2147483649)$ef+=4294967296;return(int)$ef;}function
long2str($W,$mj){$hh='';foreach($W
as$X)$hh.=pack('V',$X);if($mj)return
substr($hh,0,end($W));return$hh;}function
str2long($hh,$mj){$W=array_values(unpack('V*',str_pad($hh,4*ceil(strlen($hh)/4),"\0")));if($mj)$W[]=strlen($hh);return$W;}function
xxtea_mx($zj,$yj,$Uh,$ke){return
int32((($zj>>5&0x7FFFFFF)^$yj<<2)+(($yj>>3&0x1FFFFFFF)^$zj<<4))^int32(($Uh^$yj)+($ke^$zj));}function
encrypt_string($Ph,$z){if($Ph=="")return"";$z=array_values(unpack("V*",pack("H*",md5($z))));$W=str2long($Ph,true);$ef=count($W)-1;$zj=$W[$ef];$yj=$W[0];$Cg=floor(6+52/($ef+1));$Uh=0;while($Cg-->0){$Uh=int32($Uh+0x9E3779B9);$rc=$Uh>>2&3;for($Tf=0;$Tf<$ef;$Tf++){$yj=$W[$Tf+1];$df=xxtea_mx($zj,$yj,$Uh,$z[$Tf&3^$rc]);$zj=int32($W[$Tf]+$df);$W[$Tf]=$zj;}$yj=$W[0];$df=xxtea_mx($zj,$yj,$Uh,$z[$Tf&3^$rc]);$zj=int32($W[$ef]+$df);$W[$ef]=$zj;}return
long2str($W,false);}function
decrypt_string($Ph,$z){if($Ph=="")return"";if(!$z)return
false;$z=array_values(unpack("V*",pack("H*",md5($z))));$W=str2long($Ph,false);$ef=count($W)-1;$zj=$W[$ef];$yj=$W[0];$Cg=floor(6+52/($ef+1));$Uh=int32($Cg*0x9E3779B9);while($Uh){$rc=$Uh>>2&3;for($Tf=$ef;$Tf>0;$Tf--){$zj=$W[$Tf-1];$df=xxtea_mx($zj,$yj,$Uh,$z[$Tf&3^$rc]);$yj=int32($W[$Tf]-$df);$W[$Tf]=$yj;}$zj=$W[$ef];$df=xxtea_mx($zj,$yj,$Uh,$z[$Tf&3^$rc]);$yj=int32($W[0]-$df);$W[0]=$yj;$Uh=int32($Uh-0x9E3779B9);}return
long2str($W,true);}$h='';$Bd=$_SESSION["token"];if(!$Bd)$_SESSION["token"]=rand(1,1e6);$xi=get_token();$kg=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($z)=explode(":",$X);$kg[$z]=$X;}}function
add_invalid_login(){global$b;$pd=file_open_lock(get_temp_dir()."/adminer.invalid");if(!$pd)return;$de=unserialize(stream_get_contents($pd));$ni=time();if($de){foreach($de
as$ee=>$X){if($X[0]<$ni)unset($de[$ee]);}}$ce=&$de[$b->bruteForceKey()];if(!$ce)$ce=array($ni+30*60,0);$ce[1]++;file_write_unlock($pd,serialize($de));}function
check_invalid_login(){global$b;$de=unserialize(@file_get_contents(get_temp_dir()."/adminer.invalid"));$ce=$de[$b->bruteForceKey()];$kf=($ce[1]>29?$ce[0]-time():0);if($kf>0)auth_error(lang(84,ceil($kf/60)));}$La=$_POST["auth"];if($La){session_regenerate_id();$hj=$La["driver"];$N=$La["server"];$V=$La["username"];$F=(string)$La["password"];$m=$La["db"];set_password($hj,$N,$V,$F);$_SESSION["db"][$hj][$N][$V][$m]=true;if($La["permanent"]){$z=base64_encode($hj)."-".base64_encode($N)."-".base64_encode($V)."-".base64_encode($m);$wg=$b->permanentLogin(true);$kg[$z]="$z:".base64_encode($wg?encrypt_string($F,$wg):"");cookie("adminer_permanent",implode(" ",$kg));}if(count($_POST)==1||DRIVER!=$hj||SERVER!=$N||$_GET["username"]!==$V||DB!=$m)redirect(auth_url($hj,$N,$V,$m));}elseif($_POST["logout"]&&(!$Bd||verify_token())){foreach(array("pwds","db","dbs","queries")as$z)set_session($z,null);unset_permanent();redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(85).' '.lang(86));}elseif($kg&&!$_SESSION["pwds"]){session_regenerate_id();$wg=$b->permanentLogin();foreach($kg
as$z=>$X){list(,$kb)=explode(":",$X);list($hj,$N,$V,$m)=array_map('base64_decode',explode("-",$z));set_password($hj,$N,$V,decrypt_string(base64_decode($kb),$wg));$_SESSION["db"][$hj][$N][$V][$m]=true;}}function
unset_permanent(){global$kg;foreach($kg
as$z=>$X){list($hj,$N,$V,$m)=array_map('base64_decode',explode("-",$z));if($hj==DRIVER&&$N==SERVER&&$V==$_GET["username"]&&$m==DB)unset($kg[$z]);}cookie("adminer_permanent",implode(" ",$kg));}function
auth_error($o){global$b,$Bd;$wh=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$wh]||$_GET[$wh])&&!$Bd)$o=lang(87);else{restart_session();add_invalid_login();$F=get_password();if($F!==null){if($F===false)$o.='<br>'.lang(88,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent();}}if(!$_COOKIE[$wh]&&$_GET[$wh]&&ini_bool("session.use_only_cookies"))$o=lang(89);$Wf=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?$_COOKIE["adminer_key"]:rand_string()),$Wf["lifetime"]);page_header(lang(40),$o,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(90)."\n";echo"</div>\n";$b->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists("Min_DB")){unset($_SESSION["pwds"][DRIVER]);unset_permanent();page_header(lang(91),lang(92,implode(", ",$qg)),false);page_footer("auth");exit;}stop_session(true);if(isset($_GET["username"])&&is_string(get_password())){list($Hd,$mg)=explode(":",SERVER,2);if(preg_match('~^\s*([-+]?\d+)~',$mg,$B)&&($B[1]<1024||$B[1]>65535))auth_error(lang(93));check_invalid_login();$h=connect();$n=new
Min_Driver($h);}$Fe=null;if(!is_object($h)||($Fe=$b->login($_GET["username"],get_password()))!==true){$o=(is_string($h)?h($h):(is_string($Fe)?$Fe:lang(32)));auth_error($o.(preg_match('~^ | $~',get_password())?'<br>'.lang(94):''));}if($_POST["logout"]&&$Bd&&!verify_token()){page_header(lang(83),lang(95));page_footer("db");exit;}if($La&&$_POST["token"])$_POST["token"]=$xi;$o='';if($_POST){if(!verify_token()){$Xd="max_input_vars";$Re=ini_get($Xd);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$z){$X=ini_get($z);if($X&&(!$Re||$X<$Re)){$Xd=$z;$Re=$X;}}}$o=(!$_POST["token"]&&$Re?lang(96,"'$Xd'"):lang(95).' '.lang(97));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$o=lang(98,"'post_max_size'");if(isset($_GET["sql"]))$o.=' '.lang(99);}function
select($H,$i=null,$Kf=array(),$_=0){global$y;$De=array();$x=array();$f=array();$Va=array();$Li=array();$I=array();odd('');for($t=0;(!$_||$t<$_)&&($J=$H->fetch_row());$t++){if(!$t){echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap'>\n","<thead><tr>";for($je=0;$je<count($J);$je++){$p=$H->fetch_field();$C=$p->name;$Jf=$p->orgtable;$If=$p->orgname;$I[$p->table]=$Jf;if($Kf&&$y=="sql")$De[$je]=($C=="table"?"table=":($C=="possible_keys"?"indexes=":null));elseif($Jf!=""){if(!isset($x[$Jf])){$x[$Jf]=array();foreach(indexes($Jf,$i)as$w){if($w["type"]=="PRIMARY"){$x[$Jf]=array_flip($w["columns"]);break;}}$f[$Jf]=$x[$Jf];}if(isset($f[$Jf][$If])){unset($f[$Jf][$If]);$x[$Jf][$If]=$je;$De[$je]=$Jf;}}if($p->charsetnr==63)$Va[$je]=true;$Li[$je]=$p->type;echo"<th".($Jf!=""||$p->name!=$If?" title='".h(($Jf!=""?"$Jf.":"").$If)."'":"").">".h($C).($Kf?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($C),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr".odd().">";foreach($J
as$z=>$X){$A="";if(isset($De[$z])&&!$f[$De[$z]]){if($Kf&&$y=="sql"){$R=$J[array_search("table=",$De)];$A=ME.$De[$z].urlencode($Kf[$R]!=""?$Kf[$R]:$R);}else{$A=ME."edit=".urlencode($De[$z]);foreach($x[$De[$z]]as$ob=>$je)$A.="&where".urlencode("[".bracket_escape($ob)."]")."=".urlencode($J[$je]);}}elseif(is_url($X))$A=$X;if($X===null)$X="<i>NULL</i>";elseif($Va[$z]&&!is_utf8($X))$X="<i>".lang(49,strlen($X))."</i>";else{$X=h($X);if($Li[$z]==254)$X="<code>$X</code>";}if($A)$X="<a href='".h($A)."'".(is_url($A)?target_blank():'').">$X</a>";echo"<td>$X";}}echo($t?"</table>\n</div>":"<p class='message'>".lang(12))."\n";return$I;}function
referencable_primary($qh){$I=array();foreach(table_status('',true)as$Yh=>$R){if($Yh!=$qh&&fk_support($R)){foreach(fields($Yh)as$p){if($p["primary"]){if($I[$Yh]){unset($I[$Yh]);break;}$I[$Yh]=$p;}}}}return$I;}function
adminer_settings(){parse_str($_COOKIE["adminer_settings"],$yh);return$yh;}function
adminer_setting($z){$yh=adminer_settings();return$yh[$z];}function
set_adminer_settings($yh){return
cookie("adminer_settings",http_build_query($yh+adminer_settings()));}function
textarea($C,$Y,$K=10,$sb=80){global$y;echo"<textarea name='$C' rows='$K' cols='$sb' class='sqlarea jush-$y' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
edit_type($z,$p,$qb,$ld=array(),$Sc=array()){global$Qh,$Li,$Si,$yf;$U=$p["type"];echo'<td><select name="',h($z),'[type]" class="type" aria-labelledby="label-type">';if($U&&!isset($Li[$U])&&!isset($ld[$U])&&!in_array($U,$Sc))$Sc[]=$U;if($ld)$Qh[lang(100)]=$ld;echo
optionlist(array_merge($Sc,$Qh),$U),'</select><td><input name="',h($z),'[length]" value="',h($p["length"]),'" size="3"',(!$p["length"]&&preg_match('~var(char|binary)$~',$U)?" class='required'":"");echo' aria-labelledby="label-length"><td class="options">',"<select name='".h($z)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'").'><option value="">('.lang(101).')'.optionlist($qb,$p["collation"]).'</select>',($Si?"<select name='".h($z)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist($Si,$p["unsigned"]).'</select>':''),(isset($p['on_update'])?"<select name='".h($z)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(102).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$p["on_update"])?"CURRENT_TIMESTAMP":$p["on_update"])).'</select>':''),($ld?"<select name='".h($z)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".lang(103).")".optionlist(explode("|",$yf),$p["on_delete"])."</select> ":" ");}function
process_length($Ae){global$Bc;return(preg_match("~^\\s*\\(?\\s*$Bc(?:\\s*,\\s*$Bc)*+\\s*\\)?\\s*\$~",$Ae)&&preg_match_all("~$Bc~",$Ae,$Le)?"(".implode(",",$Le[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$Ae)));}function
process_type($p,$pb="COLLATE"){global$Si;return" $p[type]".process_length($p["length"]).(preg_match(number_type(),$p["type"])&&in_array($p["unsigned"],$Si)?" $p[unsigned]":"").(preg_match('~char|text|enum|set~',$p["type"])&&$p["collation"]?" $pb ".q($p["collation"]):"");}function
process_field($p,$Ji){return
array(idf_escape(trim($p["field"])),process_type($Ji),($p["null"]?" NULL":" NOT NULL"),default_value($p),(preg_match('~timestamp|datetime~',$p["type"])&&$p["on_update"]?" ON UPDATE $p[on_update]":""),(support("comment")&&$p["comment"]!=""?" COMMENT ".q($p["comment"]):""),($p["auto_increment"]?auto_increment():null),);}function
default_value($p){$Yb=$p["default"];return($Yb===null?"":" DEFAULT ".(preg_match('~char|binary|text|enum|set~',$p["type"])||preg_match('~^(?![a-z])~i',$Yb)?q($Yb):$Yb));}function
type_class($U){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$z=>$X){if(preg_match("~$z|$X~",$U))return" class='$z'";}}function
edit_fields($q,$qb,$U="TABLE",$ld=array()){global$Yd;$q=array_values($q);$Zb=(($_POST?$_POST["defaults"]:adminer_setting("defaults"))?"":" class='hidden'");$wb=(($_POST?$_POST["comments"]:adminer_setting("comments"))?"":" class='hidden'");echo'<thead><tr>
';if($U=="PROCEDURE"){echo'<td>';}echo'<th id="label-name">',($U=="TABLE"?lang(104):lang(105)),'<td id="label-type">',lang(51),'<textarea id="enum-edit" rows="4" cols="12" wrap="off" style="display: none;"></textarea>',script("qs('#enum-edit').onblur = editingLengthBlur;"),'<td id="label-length">',lang(106),'<td>',lang(107);if($U=="TABLE"){echo'<td id="label-null">NULL
<td><input type="radio" name="auto_increment_col" value=""><acronym id="label-ai" title="',lang(53),'">AI</acronym>',doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",'sqlite'=>"autoinc.html",'pgsql'=>"datatype.html#DATATYPE-SERIAL",'mssql'=>"ms186775.aspx",)),'<td id="label-default"',$Zb,'>',lang(54),(support("comment")?"<td id='label-comment'$wb>".lang(52):"");}echo'<td>',"<input type='image' class='icon' name='add[".(support("move_col")?0:count($q))."]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.7.9")."' alt='+' title='".lang(108)."'>".script("row_count = ".count($q).";"),'</thead>
<tbody>
',script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($q
as$t=>$p){$t++;$Lf=$p[($_POST?"orig":"field")];$hc=(isset($_POST["add"][$t-1])||(isset($p["field"])&&!$_POST["drop_col"][$t]))&&(support("drop_col")||$Lf=="");echo'<tr',($hc?"":" style='display: none;'"),'>
',($U=="PROCEDURE"?"<td>".html_select("fields[$t][inout]",explode("|",$Yd),$p["inout"]):""),'<th>';if($hc){echo'<input name="fields[',$t,'][field]" value="',h($p["field"]),'" data-maxlength="64" autocapitalize="off" aria-labelledby="label-name">';}echo'<input type="hidden" name="fields[',$t,'][orig]" value="',h($Lf),'">';edit_type("fields[$t]",$p,$qb,$ld);if($U=="TABLE"){echo'<td>',checkbox("fields[$t][null]",1,$p["null"],"","","block","label-null"),'<td><label class="block"><input type="radio" name="auto_increment_col" value="',$t,'"';if($p["auto_increment"]){echo' checked';}echo' aria-labelledby="label-ai"></label><td',$Zb,'>',checkbox("fields[$t][has_default]",1,$p["has_default"],"","","","label-default"),'<input name="fields[',$t,'][default]" value="',h($p["default"]),'" aria-labelledby="label-default">',(support("comment")?"<td$wb><input name='fields[$t][comment]' value='".h($p["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");}echo"<td>",(support("move_col")?"<input type='image' class='icon' name='add[$t]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.7.9")."' alt='+' title='".lang(108)."'> "."<input type='image' class='icon' name='up[$t]' src='".h(preg_replace("~\\?.*~","",ME)."?file=up.gif&version=4.7.9")."' alt='↑' title='".lang(109)."'> "."<input type='image' class='icon' name='down[$t]' src='".h(preg_replace("~\\?.*~","",ME)."?file=down.gif&version=4.7.9")."' alt='↓' title='".lang(110)."'> ":""),($Lf==""||support("drop_col")?"<input type='image' class='icon' name='drop_col[$t]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.7.9")."' alt='x' title='".lang(111)."'>":"");}}function
process_fields(&$q){$D=0;if($_POST["up"]){$ve=0;foreach($q
as$z=>$p){if(key($_POST["up"])==$z){unset($q[$z]);array_splice($q,$ve,0,array($p));break;}if(isset($p["field"]))$ve=$D;$D++;}}elseif($_POST["down"]){$nd=false;foreach($q
as$z=>$p){if(isset($p["field"])&&$nd){unset($q[key($_POST["down"])]);array_splice($q,$D,0,array($nd));break;}if(key($_POST["down"])==$z)$nd=$p;$D++;}}elseif($_POST["add"]){$q=array_values($q);array_splice($q,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum($B){return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($B[0][0].$B[0][0],$B[0][0],substr($B[0],1,-1))),'\\'))."'";}function
grant($sd,$yg,$f,$xf){if(!$yg)return
true;if($yg==array("ALL PRIVILEGES","GRANT OPTION"))return($sd=="GRANT"?queries("$sd ALL PRIVILEGES$xf WITH GRANT OPTION"):queries("$sd ALL PRIVILEGES$xf")&&queries("$sd GRANT OPTION$xf"));return
queries("$sd ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$f, ",$yg).$f).$xf);}function
drop_create($lc,$j,$mc,$ki,$oc,$Ee,$We,$Ue,$Ve,$uf,$hf){if($_POST["drop"])query_redirect($lc,$Ee,$We);elseif($uf=="")query_redirect($j,$Ee,$Ve);elseif($uf!=$hf){$Lb=queries($j);queries_redirect($Ee,$Ue,$Lb&&queries($lc));if($Lb)queries($mc);}else
queries_redirect($Ee,$Ue,queries($ki)&&queries($oc)&&queries($lc)&&queries($j));}function
create_trigger($xf,$J){global$y;$pi=" $J[Timing] $J[Event]".($J["Event"]=="UPDATE OF"?" ".idf_escape($J["Of"]):"");return"CREATE TRIGGER ".idf_escape($J["Trigger"]).($y=="mssql"?$xf.$pi:$pi.$xf).rtrim(" $J[Type]\n$J[Statement]",";").";";}function
create_routine($dh,$J){global$Yd,$y;$O=array();$q=(array)$J["fields"];ksort($q);foreach($q
as$p){if($p["field"]!="")$O[]=(preg_match("~^($Yd)\$~",$p["inout"])?"$p[inout] ":"").idf_escape($p["field"]).process_type($p,"CHARACTER SET");}$ac=rtrim("\n$J[definition]",";");return"CREATE $dh ".idf_escape(trim($J["name"]))." (".implode(", ",$O).")".(isset($_GET["function"])?" RETURNS".process_type($J["returns"],"CHARACTER SET"):"").($J["language"]?" LANGUAGE $J[language]":"").($y=="pgsql"?" AS ".q($ac):"$ac;");}function
remove_definer($G){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$G);}function
format_foreign_key($r){global$yf;$m=$r["db"];$mf=$r["ns"];return" FOREIGN KEY (".implode(", ",array_map('idf_escape',$r["source"])).") REFERENCES ".($m!=""&&$m!=$_GET["db"]?idf_escape($m).".":"").($mf!=""&&$mf!=$_GET["ns"]?idf_escape($mf).".":"").table($r["table"])." (".implode(", ",array_map('idf_escape',$r["target"])).")".(preg_match("~^($yf)\$~",$r["on_delete"])?" ON DELETE $r[on_delete]":"").(preg_match("~^($yf)\$~",$r["on_update"])?" ON UPDATE $r[on_update]":"");}function
tar_file($bd,$ui){$I=pack("a100a8a8a8a12a12",$bd,644,0,0,decoct($ui->size),decoct(time()));$ib=8*32;for($t=0;$t<strlen($I);$t++)$ib+=ord($I[$t]);$I.=sprintf("%06o",$ib)."\0 ";echo$I,str_repeat("\0",512-strlen($I));$ui->send();echo
str_repeat("\0",511-($ui->size+511)%512);}function
ini_bytes($Xd){$X=ini_get($Xd);switch(strtolower(substr($X,-1))){case'g':$X*=1024;case'm':$X*=1024;case'k':$X*=1024;}return$X;}function
doc_link($hg,$li="<sup>?</sup>"){global$y,$h;$uh=$h->server_info;$ij=preg_replace('~^(\d\.?\d).*~s','\1',$uh);$Xi=array('sql'=>"https://dev.mysql.com/doc/refman/$ij/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/$ij/",'mssql'=>"https://msdn.microsoft.com/library/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$uh)."&id=",);if(preg_match('~MariaDB~',$uh)){$Xi['sql']="https://mariadb.com/kb/en/library/";$hg['sql']=(isset($hg['mariadb'])?$hg['mariadb']:str_replace(".html","/",$hg['sql']));}return($hg[$y]?"<a href='".h($Xi[$y].$hg[$y])."'".target_blank().">$li</a>":"");}function
ob_gzencode($Q){return
gzencode($Q);}function
db_size($m){global$h;if(!$h->select_db($m))return"?";$I=0;foreach(table_status()as$S)$I+=$S["Data_length"]+$S["Index_length"];return
format_number($I);}function
set_utf8mb4($j){global$h;static$O=false;if(!$O&&preg_match('~\butf8mb4~i',$j)){$O=true;echo"SET NAMES ".charset($h).";\n\n";}}function
connect_error(){global$b,$h,$xi,$o,$kc;if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(39).": ".h(DB),lang(112),true);}else{if($_POST["db"]&&!$o)queries_redirect(substr(ME,0,-1),lang(113),drop_databases($_POST["db"]));page_header(lang(114),$o,false);echo"<p class='links'>\n";foreach(array('database'=>lang(115),'privileges'=>lang(73),'processlist'=>lang(116),'variables'=>lang(117),'status'=>lang(118),)as$z=>$X){if(support($z))echo"<a href='".h(ME)."$z='>$X</a>\n";}echo"<p>".lang(119,$kc[DRIVER],"<b>".h($h->server_info)."</b>","<b>$h->extension</b>")."\n","<p>".lang(120,"<b>".h(logged_user())."</b>")."\n";$l=$b->databases();if($l){$kh=support("scheme");$qb=collations();echo"<form action='' method='post'>\n","<table cellspacing='0' class='checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(39)." - <a href='".h(ME)."refresh=1'>".lang(121)."</a>"."<td>".lang(122)."<td>".lang(123)."<td>".lang(124)." - <a href='".h(ME)."dbsize=1'>".lang(125)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$l=($_GET["dbsize"]?count_tables($l):array_flip($l));foreach($l
as$m=>$T){$ch=h(ME)."db=".urlencode($m);$u=h("Db-".$m);echo"<tr".odd().">".(support("database")?"<td>".checkbox("db[]",$m,in_array($m,(array)$_POST["db"]),"","","",$u):""),"<th><a href='$ch' id='$u'>".h($m)."</a>";$d=h(db_collation($m,$qb));echo"<td>".(support("database")?"<a href='$ch".($kh?"&amp;ns=":"")."&amp;database=' title='".lang(69)."'>$d</a>":$d),"<td align='right'><a href='$ch&amp;schema=' id='tables-".h($m)."' title='".lang(72)."'>".($_GET["dbsize"]?$T:"?")."</a>","<td align='right' id='size-".h($m)."'>".($_GET["dbsize"]?db_size($m):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(126)." <span id='selected'></span></legend><div>\n"."<input type='hidden' name='all' value=''>".script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(127)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),"<input type='hidden' name='token' value='$xi'>\n","</form>\n",script("tableCheck();");}}page_footer("db");}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?$h->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}connect_error();exit;}if(support("scheme")&&DB!=""&&$_GET["ns"]!==""){if(!isset($_GET["ns"]))redirect(preg_replace('~ns=[^&]*&~','',ME)."ns=".get_schema());if(!set_schema($_GET["ns"])){header("HTTP/1.1 404 Not Found");page_header(lang(79).": ".h($_GET["ns"]),lang(128),true);page_footer("ns");exit;}}$yf="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";class
TmpFile{var$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($Fb){$this->size+=strlen($Fb);fwrite($this->handler,$Fb);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}$Bc="'(?:''|[^'\\\\]|\\\\.)*'";$Yd="IN|OUT|INOUT";if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$q=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$L=array(idf_escape($_GET["field"]));$H=$n->select($a,$L,array(where($_GET,$q)),$L);$J=($H?$H->fetch_row():array());echo$n->value($J[0],$q[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$q=fields($a);if(!$q)$o=error();$S=table_status1($a,true);$C=$b->tableName($S);page_header(($q&&is_view($S)?$S['Engine']=='materialized view'?lang(129):lang(130):lang(131)).": ".($C!=""?$C:h($a)),$o);$b->selectLinks($S);$vb=$S["Comment"];if($vb!="")echo"<p class='nowrap'>".lang(52).": ".h($vb)."\n";if($q)$b->tableStructurePrint($q);if(!is_view($S)){if(support("indexes")){echo"<h3 id='indexes'>".lang(132)."</h3>\n";$x=indexes($a);if($x)$b->tableIndexesPrint($x);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(133)."</a>\n";}if(fk_support($S)){echo"<h3 id='foreign-keys'>".lang(100)."</h3>\n";$ld=foreign_keys($a);if($ld){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(134)."<td>".lang(135)."<td>".lang(103)."<td>".lang(102)."<td></thead>\n";foreach($ld
as$C=>$r){echo"<tr title='".h($C)."'>","<th><i>".implode("</i>, <i>",array_map('h',$r["source"]))."</i>","<td><a href='".h($r["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($r["db"]),ME):($r["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($r["ns"]),ME):ME))."table=".urlencode($r["table"])."'>".($r["db"]!=""?"<b>".h($r["db"])."</b>.":"").($r["ns"]!=""?"<b>".h($r["ns"])."</b>.":"").h($r["table"])."</a>","(<i>".implode("</i>, <i>",array_map('h',$r["target"]))."</i>)","<td>".h($r["on_delete"])."\n","<td>".h($r["on_update"])."\n",'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($C)).'">'.lang(136).'</a>';}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(137)."</a>\n";}}if(support(is_view($S)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(138)."</h3>\n";$Ii=triggers($a);if($Ii){echo"<table cellspacing='0'>\n";foreach($Ii
as$z=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($z)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($z))."'>".lang(136)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(139)."</a>\n";}}elseif(isset($_GET["schema"])){page_header(lang(72),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$ai=array();$bi=array();$ea=($_GET["schema"]?$_GET["schema"]:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$ea,$Le,PREG_SET_ORDER);foreach($Le
as$t=>$B){$ai[$B[1]]=array($B[2],$B[3]);$bi[]="\n\t'".js_escape($B[1])."': [ $B[2], $B[3] ]";}$yi=0;$Sa=-1;$jh=array();$Og=array();$ze=array();foreach(table_status('',true)as$R=>$S){if(is_view($S))continue;$ng=0;$jh[$R]["fields"]=array();foreach(fields($R)as$C=>$p){$ng+=1.25;$p["pos"]=$ng;$jh[$R]["fields"][$C]=$p;}$jh[$R]["pos"]=($ai[$R]?$ai[$R]:array($yi,0));foreach($b->foreignKeys($R)as$X){if(!$X["db"]){$xe=$Sa;if($ai[$R][1]||$ai[$X["table"]][1])$xe=min(floatval($ai[$R][1]),floatval($ai[$X["table"]][1]))-1;else$Sa-=.1;while($ze[(string)$xe])$xe-=.0001;$jh[$R]["references"][$X["table"]][(string)$xe]=array($X["source"],$X["target"]);$Og[$X["table"]][$R][(string)$xe]=$X["target"];$ze[(string)$xe]=true;}}$yi=max($yi,$jh[$R]["pos"][0]+2.5+$ng);}echo'<div id="schema" style="height: ',$yi,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = function () { return false; };
var tablePos = {',implode(",",$bi)."\n",'};
var em = qs(\'#schema\').offsetHeight / ',$yi,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($jh
as$C=>$R){echo"<div class='table' style='top: ".$R["pos"][0]."em; left: ".$R["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($C).'"><b>'.h($C)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($R["fields"]as$p){$X='<span'.type_class($p["type"]).' title="'.h($p["full_type"].($p["null"]?" NULL":'')).'">'.h($p["field"]).'</span>';echo"<br>".($p["primary"]?"<i>$X</i>":$X);}foreach((array)$R["references"]as$hi=>$Pg){foreach($Pg
as$xe=>$Lg){$ye=$xe-$ai[$C][1];$t=0;foreach($Lg[0]as$Eh)echo"\n<div class='references' title='".h($hi)."' id='refs$xe-".($t++)."' style='left: $ye"."em; top: ".$R["fields"][$Eh]["pos"]."em; padding-top: .5em;'><div style='border-top: 1px solid Gray; width: ".(-$ye)."em;'></div></div>";}}foreach((array)$Og[$C]as$hi=>$Pg){foreach($Pg
as$xe=>$f){$ye=$xe-$ai[$C][1];$t=0;foreach($f
as$gi)echo"\n<div class='references' title='".h($hi)."' id='refd$xe-".($t++)."' style='left: $ye"."em; top: ".$R["fields"][$gi]["pos"]."em; height: 1.25em; background: url(".h(preg_replace("~\\?.*~","",ME)."?file=arrow.gif) no-repeat right center;&version=4.7.9")."'><div style='height: .5em; border-bottom: 1px solid Gray; width: ".(-$ye)."em;'></div></div>";}}echo"\n</div>\n";}foreach($jh
as$C=>$R){foreach((array)$R["references"]as$hi=>$Pg){foreach($Pg
as$xe=>$Lg){$af=$yi;$Pe=-10;foreach($Lg[0]as$z=>$Eh){$og=$R["pos"][0]+$R["fields"][$Eh]["pos"];$pg=$jh[$hi]["pos"][0]+$jh[$hi]["fields"][$Lg[1][$z]]["pos"];$af=min($af,$og,$pg);$Pe=max($Pe,$og,$pg);}echo"<div class='references' id='refl$xe' style='left: $xe"."em; top: $af"."em; padding: .5em 0;'><div style='border-right: 1px solid Gray; margin-top: 1px; height: ".($Pe-$af)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($ea)),'" id="schema-link">',lang(140),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$o){$Ib="";foreach(array("output","format","db_style","routines","events","table_style","auto_increment","triggers","data_style")as$z)$Ib.="&$z=".urlencode($_POST[$z]);cookie("adminer_export",substr($Ib,1));$T=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$Pc=dump_headers((count($T)==1?key($T):DB),(DB==""||count($T)>1));$ge=preg_match('~sql~',$_POST["format"]);if($ge){echo"-- Adminer $ia ".$kc[DRIVER]." dump\n\n";if($y=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";$h->query("SET time_zone = '+00:00'");$h->query("SET sql_mode = ''");}}$Rh=$_POST["db_style"];$l=array(DB);if(DB==""){$l=$_POST["databases"];if(is_string($l))$l=explode("\n",rtrim(str_replace("\r","",$l),"\n"));}foreach((array)$l
as$m){$b->dumpDatabase($m);if($h->select_db($m)){if($ge&&preg_match('~CREATE~',$Rh)&&($j=$h->result("SHOW CREATE DATABASE ".idf_escape($m),1))){set_utf8mb4($j);if($Rh=="DROP+CREATE")echo"DROP DATABASE IF EXISTS ".idf_escape($m).";\n";echo"$j;\n";}if($ge){if($Rh)echo
use_sql($m).";\n\n";$Rf="";if($_POST["routines"]){foreach(array("FUNCTION","PROCEDURE")as$dh){foreach(get_rows("SHOW $dh STATUS WHERE Db = ".q($m),null,"-- ")as$J){$j=remove_definer($h->result("SHOW CREATE $dh ".idf_escape($J["Name"]),2));set_utf8mb4($j);$Rf.=($Rh!='DROP+CREATE'?"DROP $dh IF EXISTS ".idf_escape($J["Name"]).";;\n":"")."$j;;\n\n";}}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$J){$j=remove_definer($h->result("SHOW CREATE EVENT ".idf_escape($J["Name"]),3));set_utf8mb4($j);$Rf.=($Rh!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($J["Name"]).";;\n":"")."$j;;\n\n";}}if($Rf)echo"DELIMITER ;;\n\n$Rf"."DELIMITER ;\n\n";}if($_POST["table_style"]||$_POST["data_style"]){$kj=array();foreach(table_status('',true)as$C=>$S){$R=(DB==""||in_array($C,(array)$_POST["tables"]));$Rb=(DB==""||in_array($C,(array)$_POST["data"]));if($R||$Rb){if($Pc=="tar"){$ui=new
TmpFile;ob_start(array($ui,'write'),1e5);}$b->dumpTable($C,($R?$_POST["table_style"]:""),(is_view($S)?2:0));if(is_view($S))$kj[]=$C;elseif($Rb){$q=fields($C);$b->dumpData($C,$_POST["data_style"],"SELECT *".convert_fields($q,$q)." FROM ".table($C));}if($ge&&$_POST["triggers"]&&$R&&($Ii=trigger_sql($C)))echo"\nDELIMITER ;;\n$Ii\nDELIMITER ;\n";if($Pc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$m/")."$C.csv",$ui);}elseif($ge)echo"\n";}}if(function_exists('foreign_keys_sql')){foreach(table_status('',true)as$C=>$S){$R=(DB==""||in_array($C,(array)$_POST["tables"]));if($R&&!is_view($S))echo
foreign_keys_sql($C);}}foreach($kj
as$jj)$b->dumpTable($jj,$_POST["table_style"],1);if($Pc=="tar")echo
pack("x512");}}}if($ge)echo"-- ".$h->result("SELECT NOW()")."\n";exit;}page_header(lang(75),$o,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table cellspacing="0" class="layout">
';$Vb=array('','USE','DROP+CREATE','CREATE');$ci=array('','DROP+CREATE','CREATE');$Sb=array('','TRUNCATE+INSERT','INSERT');if($y=="sql")$Sb[]='INSERT+UPDATE';parse_str($_COOKIE["adminer_export"],$J);if(!$J)$J=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($J["events"])){$J["routines"]=$J["events"]=($_GET["dump"]=="");$J["triggers"]=$J["table_style"];}echo"<tr><th>".lang(141)."<td>".html_select("output",$b->dumpOutput(),$J["output"],0)."\n";echo"<tr><th>".lang(142)."<td>".html_select("format",$b->dumpFormat(),$J["format"],0)."\n";echo($y=="sqlite"?"":"<tr><th>".lang(39)."<td>".html_select('db_style',$Vb,$J["db_style"]).(support("routine")?checkbox("routines",1,$J["routines"],lang(143)):"").(support("event")?checkbox("events",1,$J["events"],lang(144)):"")),"<tr><th>".lang(123)."<td>".html_select('table_style',$ci,$J["table_style"]).checkbox("auto_increment",1,$J["auto_increment"],lang(53)).(support("trigger")?checkbox("triggers",1,$J["triggers"],lang(138)):""),"<tr><th>".lang(145)."<td>".html_select('data_style',$Sb,$J["data_style"]),'</table>
<p><input type="submit" value="',lang(75),'">
<input type="hidden" name="token" value="',$xi,'">

<table cellspacing="0">
',script("qsl('table').onclick = dumpClick;");$sg=array();if(DB!=""){$gb=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$gb>".lang(123)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(145)."<input type='checkbox' id='check-data'$gb></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$kj="";$di=tables_list();foreach($di
as$C=>$U){$rg=preg_replace('~_.*~','',$C);$gb=($a==""||$a==(substr($a,-1)=="%"?"$rg%":$C));$vg="<tr><td>".checkbox("tables[]",$C,$gb,$C,"","block");if($U!==null&&!preg_match('~table~i',$U))$kj.="$vg\n";else
echo"$vg<td align='right'><label class='block'><span id='Rows-".h($C)."'></span>".checkbox("data[]",$C,$gb)."</label>\n";$sg[$rg]++;}echo$kj;if($di)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(39)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$l=$b->databases();if($l){foreach($l
as$m){if(!information_schema($m)){$rg=preg_replace('~_.*~','',$m);echo"<tr><td>".checkbox("databases[]",$m,$a==""||$a=="$rg%",$m,"","block")."\n";$sg[$rg]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$dd=true;foreach($sg
as$z=>$X){if($z!=""&&$X>1){echo($dd?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$z%")."'>".h($z)."</a>";$dd=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(73));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(146)."</a>";$H=$h->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$sd=$H;if(!$H)$H=$h->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo"<input type='hidden' name='db' value='".h(DB)."'>\n",($sd?"":"<input type='hidden' name='grant' value=''>\n"),"<table cellspacing='0'>\n","<thead><tr><th>".lang(37)."<th>".lang(36)."<th></thead>\n";while($J=$H->fetch_assoc())echo'<tr'.odd().'><td>'.h($J["User"])."<td>".h($J["Host"]).'<td><a href="'.h(ME.'user='.urlencode($J["User"]).'&host='.urlencode($J["Host"])).'">'.lang(10)."</a>\n";if(!$sd||DB!="")echo"<tr".odd()."><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(10)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$o&&$_POST["export"]){dump_headers("sql");$b->dumpTable("","");$b->dumpData("","table",$_POST["query"]);exit;}restart_session();$Fd=&get_session("queries");$Ed=&$Fd[DB];if(!$o&&$_POST["clear"]){$Ed=array();redirect(remove_from_uri("history"));}page_header((isset($_GET["import"])?lang(74):lang(66)),$o);if(!$o&&$_POST){$pd=false;if(!isset($_GET["import"]))$G=$_POST["query"];elseif($_POST["webfile"]){$Ih=$b->importServerPath();$pd=@fopen((file_exists($Ih)?$Ih:"compress.zlib://$Ih.gz"),"rb");$G=($pd?fread($pd,1e6):false);}else$G=get_file("sql_file",true);if(is_string($G)){if(function_exists('memory_get_usage'))@ini_set("memory_limit",max(ini_bytes("memory_limit"),2*strlen($G)+memory_get_usage()+8e6));if($G!=""&&strlen($G)<1e6){$Cg=$G.(preg_match("~;[ \t\r\n]*\$~",$G)?"":";");if(!$Ed||reset(end($Ed))!=$Cg){restart_session();$Ed[]=array($Cg,time());set_session("queries",$Fd);stop_session();}}$Fh="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$cc=";";$D=0;$zc=true;$i=connect();if(is_object($i)&&DB!=""){$i->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$i);}$ub=0;$Dc=array();$Yf='[\'"'.($y=="sql"?'`#':($y=="sqlite"?'`[':($y=="mssql"?'[':''))).']|/\*|-- |$'.($y=="pgsql"?'|\$[^$]*\$':'');$zi=microtime(true);parse_str($_COOKIE["adminer_export"],$ya);$qc=$b->dumpFormat();unset($qc["sql"]);while($G!=""){if(!$D&&preg_match("~^$Fh*+DELIMITER\\s+(\\S+)~i",$G,$B)){$cc=$B[1];$G=substr($G,strlen($B[0]));}else{preg_match('('.preg_quote($cc)."\\s*|$Yf)",$G,$B,PREG_OFFSET_CAPTURE,$D);list($nd,$ng)=$B[0];if(!$nd&&$pd&&!feof($pd))$G.=fread($pd,1e5);else{if(!$nd&&rtrim($G)=="")break;$D=$ng+strlen($nd);if($nd&&rtrim($nd)!=$cc){while(preg_match('('.($nd=='/*'?'\*/':($nd=='['?']':(preg_match('~^-- |^#~',$nd)?"\n":preg_quote($nd)."|\\\\."))).'|$)s',$G,$B,PREG_OFFSET_CAPTURE,$D)){$hh=$B[0][0];if(!$hh&&$pd&&!feof($pd))$G.=fread($pd,1e5);else{$D=$B[0][1]+strlen($hh);if($hh[0]!="\\")break;}}}else{$zc=false;$Cg=substr($G,0,$ng);$ub++;$vg="<pre id='sql-$ub'><code class='jush-$y'>".$b->sqlCommandQuery($Cg)."</code></pre>\n";if($y=="sqlite"&&preg_match("~^$Fh*+ATTACH\\b~i",$Cg,$B)){echo$vg,"<p class='error'>".lang(147)."\n";$Dc[]=" <a href='#sql-$ub'>$ub</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$vg;ob_flush();flush();}$Mh=microtime(true);if($h->multi_query($Cg)&&is_object($i)&&preg_match("~^$Fh*+USE\\b~i",$Cg))$i->query($Cg);do{$H=$h->store_result();if($h->error){echo($_POST["only_errors"]?$vg:""),"<p class='error'>".lang(148).($h->errno?" ($h->errno)":"").": ".error()."\n";$Dc[]=" <a href='#sql-$ub'>$ub</a>";if($_POST["error_stops"])break
2;}else{$ni=" <span class='time'>(".format_time($Mh).")</span>".(strlen($Cg)<1000?" <a href='".h(ME)."sql=".urlencode(trim($Cg))."'>".lang(10)."</a>":"");$_a=$h->affected_rows;$nj=($_POST["only_errors"]?"":$n->warnings());$oj="warnings-$ub";if($nj)$ni.=", <a href='#$oj'>".lang(48)."</a>".script("qsl('a').onclick = partial(toggle, '$oj');","");$Mc=null;$Nc="explain-$ub";if(is_object($H)){$_=$_POST["limit"];$Kf=select($H,$i,array(),$_);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$of=$H->num_rows;echo"<p>".($of?($_&&$of>$_?lang(149,$_):"").lang(150,$of):""),$ni;if($i&&preg_match("~^($Fh|\\()*+SELECT\\b~i",$Cg)&&($Mc=explain($i,$Cg)))echo", <a href='#$Nc'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$Nc');","");$u="export-$ub";echo", <a href='#$u'>".lang(75)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."<span id='$u' class='hidden'>: ".html_select("output",$b->dumpOutput(),$ya["output"])." ".html_select("format",$qc,$ya["format"])."<input type='hidden' name='query' value='".h($Cg)."'>"." <input type='submit' name='export' value='".lang(75)."'><input type='hidden' name='token' value='$xi'></span>\n"."</form>\n";}}else{if(preg_match("~^$Fh*+(CREATE|DROP|ALTER)$Fh++(DATABASE|SCHEMA)\\b~i",$Cg)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h($h->info)."'>".lang(151,$_a)."$ni\n";}echo($nj?"<div id='$oj' class='hidden'>\n$nj</div>\n":"");if($Mc){echo"<div id='$Nc' class='hidden'>\n";select($Mc,$i,$Kf);echo"</div>\n";}}$Mh=microtime(true);}while($h->next_result());}$G=substr($G,$D);$D=0;}}}}if($zc)echo"<p class='message'>".lang(152)."\n";elseif($_POST["only_errors"]){echo"<p class='message'>".lang(153,$ub-count($Dc))," <span class='time'>(".format_time($zi).")</span>\n";}elseif($Dc&&$ub>1)echo"<p class='error'>".lang(148).": ".implode("",$Dc)."\n";}else
echo"<p class='error'>".upload_error($G)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$Jc="<input type='submit' value='".lang(154)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$Cg=$_GET["sql"];if($_POST)$Cg=$_POST["query"];elseif($_GET["history"]=="all")$Cg=$Ed;elseif($_GET["history"]!="")$Cg=$Ed[$_GET["history"]][0];echo"<p>";textarea("query",$Cg,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>$Jc\n",lang(155).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".lang(156)."</legend><div>";$yd=(extension_loaded("zlib")?"[.gz]":"");echo(ini_bool("file_uploads")?"SQL$yd (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n$Jc":lang(157)),"</div></fieldset>\n";$Nd=$b->importServerPath();if($Nd){echo"<fieldset><legend>".lang(158)."</legend><div>",lang(159,"<code>".h($Nd)."$yd</code>"),' <input type="submit" name="webfile" value="'.lang(160).'">',"</div></fieldset>\n";}echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(161))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(162))."\n","<input type='hidden' name='token' value='$xi'>\n";if(!isset($_GET["import"])&&$Ed){print_fieldset("history",lang(163),$_GET["history"]!="");for($X=end($Ed);$X;$X=prev($Ed)){$z=key($Ed);list($Cg,$ni,$uc)=$X;echo'<a href="'.h(ME."sql=&history=$z").'">'.lang(10)."</a>"." <span class='time' title='".@date('Y-m-d',$ni)."'>".@date("H:i:s",$ni)."</span>"." <code class='jush-$y'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace('~^(#|-- ).*~m','',$Cg)))),80,"</code>").($uc?" <span class='time'>($uc)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(164)."'>\n","<a href='".h(ME."sql=&history=all")."'>".lang(165)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$q=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$q):""):where($_GET,$q));$Ti=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($q
as$C=>$p){if(!isset($p["privileges"][$Ti?"update":"insert"])||$b->fieldName($p)==""||$p["generated"])unset($q[$C]);}if($_POST&&!$o&&!isset($_GET["select"])){$Ee=$_POST["referer"];if($_POST["insert"])$Ee=($Ti?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$Ee))$Ee=ME."select=".urlencode($a);$x=indexes($a);$Oi=unique_array($_GET["where"],$x);$Fg="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($Ee,lang(166),$n->delete($a,$Fg,!$Oi));else{$O=array();foreach($q
as$C=>$p){$X=process_input($p);if($X!==false&&$X!==null)$O[idf_escape($C)]=$X;}if($Ti){if(!$O)redirect($Ee);queries_redirect($Ee,lang(167),$n->update($a,$O,$Fg,!$Oi));if(is_ajax()){page_headers();page_messages($o);exit;}}else{$H=$n->insert($a,$O);$we=($H?last_id():0);queries_redirect($Ee,lang(168,($we?" $we":"")),$H);}}}$J=null;if($_POST["save"])$J=(array)$_POST["fields"];elseif($Z){$L=array();foreach($q
as$C=>$p){if(isset($p["privileges"]["select"])){$Ha=convert_field($p);if($_POST["clone"]&&$p["auto_increment"])$Ha="''";if($y=="sql"&&preg_match("~enum|set~",$p["type"]))$Ha="1*".idf_escape($C);$L[]=($Ha?"$Ha AS ":"").idf_escape($C);}}$J=array();if(!support("table"))$L=array("*");if($L){$H=$n->select($a,$L,array($Z),$L,array(),(isset($_GET["select"])?2:1));if(!$H)$o=error();else{$J=$H->fetch_assoc();if(!$J)$J=false;}if(isset($_GET["select"])&&(!$J||$H->fetch_assoc()))$J=null;}}if(!support("table")&&!$q){if(!$Z){$H=$n->select($a,array("*"),$Z,array("*"));$J=($H?$H->fetch_assoc():false);if(!$J)$J=array($n->primary=>"");}if($J){foreach($J
as$z=>$X){if(!$Z)$J[$z]=null;$q[$z]=array("field"=>$z,"null"=>($z!=$n->primary),"auto_increment"=>($z==$n->primary));}}}edit_form($a,$q,$J,$Ti);}elseif(isset($_GET["create"])){$a=$_GET["create"];$ag=array();foreach(array('HASH','LINEAR HASH','KEY','LINEAR KEY','RANGE','LIST')as$z)$ag[$z]=$z;$Ng=referencable_primary($a);$ld=array();foreach($Ng
as$Yh=>$p)$ld[str_replace("`","``",$Yh)."`".str_replace("`","``",$p["field"])]=$Yh;$Nf=array();$S=array();if($a!=""){$Nf=fields($a);$S=table_status($a);if(!$S)$o=lang(9);}$J=$_POST;$J["fields"]=(array)$J["fields"];if($J["auto_increment_col"])$J["fields"][$J["auto_increment_col"]]["auto_increment"]=true;if($_POST)set_adminer_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($J["fields"])&&!$o){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(169),drop_tables(array($a)));else{$q=array();$Ea=array();$Yi=false;$jd=array();$Mf=reset($Nf);$Ba=" FIRST";foreach($J["fields"]as$z=>$p){$r=$ld[$p["type"]];$Ji=($r!==null?$Ng[$r]:$p);if($p["field"]!=""){if(!$p["has_default"])$p["default"]=null;if($z==$J["auto_increment_col"])$p["auto_increment"]=true;$_g=process_field($p,$Ji);$Ea[]=array($p["orig"],$_g,$Ba);if($_g!=process_field($Mf,$Mf)){$q[]=array($p["orig"],$_g,$Ba);if($p["orig"]!=""||$Ba)$Yi=true;}if($r!==null)$jd[idf_escape($p["field"])]=($a!=""&&$y!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$ld[$p["type"]],'source'=>array($p["field"]),'target'=>array($Ji["field"]),'on_delete'=>$p["on_delete"],));$Ba=" AFTER ".idf_escape($p["field"]);}elseif($p["orig"]!=""){$Yi=true;$q[]=array($p["orig"]);}if($p["orig"]!=""){$Mf=next($Nf);if(!$Mf)$Ba="";}}$cg="";if($ag[$J["partition_by"]]){$dg=array();if($J["partition_by"]=='RANGE'||$J["partition_by"]=='LIST'){foreach(array_filter($J["partition_names"])as$z=>$X){$Y=$J["partition_values"][$z];$dg[]="\n  PARTITION ".idf_escape($X)." VALUES ".($J["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$cg.="\nPARTITION BY $J[partition_by]($J[partition])".($dg?" (".implode(",",$dg)."\n)":($J["partitions"]?" PARTITIONS ".(+$J["partitions"]):""));}elseif(support("partitioning")&&preg_match("~partitioned~",$S["Create_options"]))$cg.="\nREMOVE PARTITIONING";$Te=lang(170);if($a==""){cookie("adminer_engine",$J["Engine"]);$Te=lang(171);}$C=trim($J["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($C),$Te,alter_table($a,$C,($y=="sqlite"&&($Yi||$jd)?$Ea:$q),$jd,($J["Comment"]!=$S["Comment"]?$J["Comment"]:null),($J["Engine"]&&$J["Engine"]!=$S["Engine"]?$J["Engine"]:""),($J["Collation"]&&$J["Collation"]!=$S["Collation"]?$J["Collation"]:""),($J["Auto_increment"]!=""?number($J["Auto_increment"]):""),$cg));}}page_header(($a!=""?lang(46):lang(76)),$o,array("table"=>$a),h($a));if(!$_POST){$J=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($Li["int"])?"int":(isset($Li["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$J=$S;$J["name"]=$a;$J["fields"]=array();if(!$_GET["auto_increment"])$J["Auto_increment"]="";foreach($Nf
as$p){$p["has_default"]=isset($p["default"]);$J["fields"][]=$p;}if(support("partitioning")){$qd="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($a);$H=$h->query("SELECT PARTITION_METHOD, PARTITION_ORDINAL_POSITION, PARTITION_EXPRESSION $qd ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");list($J["partition_by"],$J["partitions"],$J["partition"])=$H->fetch_row();$dg=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $qd AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$dg[""]="";$J["partition_names"]=array_keys($dg);$J["partition_values"]=array_values($dg);}}}$qb=collations();$Ac=engines();foreach($Ac
as$_c){if(!strcasecmp($_c,$J["Engine"])){$J["Engine"]=$_c;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(172),': <input name="name" data-maxlength="64" value="',h($J["name"]),'" autocapitalize="off">
';if($a==""&&!$_POST)echo
script("focus(qs('#form')['name']);");echo($Ac?"<select name='Engine'>".optionlist(array(""=>"(".lang(173).")")+$Ac,$J["Engine"])."</select>".on_help("getTarget(event).value",1).script("qsl('select').onchange = helpClose;"):""),' ',($qb&&!preg_match("~sqlite|mssql~",$y)?html_select("Collation",array(""=>"(".lang(101).")")+$qb,$J["Collation"]):""),' <input type="submit" value="',lang(14),'">
';}echo'
';if(support("columns")){echo'<div class="scrollable">
<table cellspacing="0" id="edit-fields" class="nowrap">
';edit_fields($J["fields"],$qb,"TABLE",$ld);echo'</table>
',script("editFields();"),'</div>
<p>
',lang(53),': <input type="number" name="Auto_increment" size="6" value="',h($J["Auto_increment"]),'">
',checkbox("defaults",1,($_POST?$_POST["defaults"]:adminer_setting("defaults")),lang(174),"columnShow(this.checked, 5)","jsonly"),(support("comment")?checkbox("comments",1,($_POST?$_POST["comments"]:adminer_setting("comments")),lang(52),"editingCommentsClick(this, true);","jsonly").' <input name="Comment" value="'.h($J["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'">':''),'<p>
<input type="submit" value="',lang(14),'">
';}echo'
';if($a!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$a));}if(support("partitioning")){$bg=preg_match('~RANGE|LIST~',$J["partition_by"]);print_fieldset("partition",lang(176),$J["partition_by"]);echo'<p>
',"<select name='partition_by'>".optionlist(array(""=>"")+$ag,$J["partition_by"])."</select>".on_help("getTarget(event).value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),'(<input name="partition" value="',h($J["partition"]),'">)
',lang(177),': <input type="number" name="partitions" class="size',($bg||!$J["partition_by"]?" hidden":""),'" value="',h($J["partitions"]),'">
<table cellspacing="0" id="partition-table"',($bg?"":" class='hidden'"),'>
<thead><tr><th>',lang(178),'<th>',lang(179),'</thead>
';foreach($J["partition_names"]as$z=>$X){echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($z==count($J["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h($J["partition_values"][$z]).'">';}echo'</table>
</div></fieldset>
';}echo'<input type="hidden" name="token" value="',$xi,'">
</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$Qd=array("PRIMARY","UNIQUE","INDEX");$S=table_status($a,true);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$S["Engine"]))$Qd[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$S["Engine"]))$Qd[]="SPATIAL";$x=indexes($a);$tg=array();if($y=="mongo"){$tg=$x["_id_"];unset($Qd[0]);unset($x["_id_"]);}$J=$_POST;if($_POST&&!$o&&!$_POST["add"]&&!$_POST["drop_col"]){$c=array();foreach($J["indexes"]as$w){$C=$w["name"];if(in_array($w["type"],$Qd)){$f=array();$Be=array();$ec=array();$O=array();ksort($w["columns"]);foreach($w["columns"]as$z=>$e){if($e!=""){$Ae=$w["lengths"][$z];$dc=$w["descs"][$z];$O[]=idf_escape($e).($Ae?"(".(+$Ae).")":"").($dc?" DESC":"");$f[]=$e;$Be[]=($Ae?$Ae:null);$ec[]=$dc;}}if($f){$Kc=$x[$C];if($Kc){ksort($Kc["columns"]);ksort($Kc["lengths"]);ksort($Kc["descs"]);if($w["type"]==$Kc["type"]&&array_values($Kc["columns"])===$f&&(!$Kc["lengths"]||array_values($Kc["lengths"])===$Be)&&array_values($Kc["descs"])===$ec){unset($x[$C]);continue;}}$c[]=array($w["type"],$C,$O);}}}foreach($x
as$C=>$Kc)$c[]=array($Kc["type"],$C,"DROP");if(!$c)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(180),alter_indexes($a,$c));}page_header(lang(132),$o,array("table"=>$a),h($a));$q=array_keys(fields($a));if($_POST["add"]){foreach($J["indexes"]as$z=>$w){if($w["columns"][count($w["columns"])]!="")$J["indexes"][$z]["columns"][]="";}$w=end($J["indexes"]);if($w["type"]||array_filter($w["columns"],'strlen'))$J["indexes"][]=array("columns"=>array(1=>""));}if(!$J){foreach($x
as$z=>$w){$x[$z]["name"]=$z;$x[$z]["columns"][]="";}$x[]=array("columns"=>array(1=>""));$J["indexes"]=$x;}echo'
<form action="" method="post">
<div class="scrollable">
<table cellspacing="0" class="nowrap">
<thead><tr>
<th id="label-type">',lang(181),'<th><input type="submit" class="wayoff">',lang(182),'<th id="label-name">',lang(183),'<th><noscript>',"<input type='image' class='icon' name='add[0]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.7.9")."' alt='+' title='".lang(108)."'>",'</noscript>
</thead>
';if($tg){echo"<tr><td>PRIMARY<td>";foreach($tg["columns"]as$z=>$e){echo
select_input(" disabled",$q,$e),"<label><input disabled type='checkbox'>".lang(61)."</label> ";}echo"<td><td>\n";}$je=1;foreach($J["indexes"]as$w){if(!$_POST["drop_col"]||$je!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$je][type]",array(-1=>"")+$Qd,$w["type"],($je==count($J["indexes"])?"indexesAddRow.call(this);":1),"label-type"),"<td>";ksort($w["columns"]);$t=1;foreach($w["columns"]as$z=>$e){echo"<span>".select_input(" name='indexes[$je][columns][$t]' title='".lang(50)."'",($q?array_combine($q,$q):$q),$e,"partial(".($t==count($w["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape($y=="sql"?"":$_GET["indexes"]."_")."')"),($y=="sql"||$y=="mssql"?"<input type='number' name='indexes[$je][lengths][$t]' class='size' value='".h($w["lengths"][$z])."' title='".lang(106)."'>":""),(support("descidx")?checkbox("indexes[$je][descs][$t]",1,$w["descs"][$z],lang(61)):"")," </span>";$t++;}echo"<td><input name='indexes[$je][name]' value='".h($w["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n","<td><input type='image' class='icon' name='drop_col[$je]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.7.9")."' alt='x' title='".lang(111)."'>".script("qsl('input').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$je++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(14),'">
<input type="hidden" name="token" value="',$xi,'">
</form>
';}elseif(isset($_GET["database"])){$J=$_POST;if($_POST&&!$o&&!isset($_POST["add_x"])){$C=trim($J["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(184),drop_databases(array(DB)));}elseif(DB!==$C){if(DB!=""){$_GET["db"]=$C;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($C),lang(185),rename_database($C,$J["collation"]));}else{$l=explode("\n",str_replace("\r","",$C));$Sh=true;$ve="";foreach($l
as$m){if(count($l)==1||$m!=""){if(!create_database($m,$J["collation"]))$Sh=false;$ve=$m;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($ve),lang(186),$Sh);}}else{if(!$J["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($C).(preg_match('~^[a-z0-9_]+$~i',$J["collation"])?" COLLATE $J[collation]":""),substr(ME,0,-1),lang(187));}}page_header(DB!=""?lang(69):lang(115),$o,array(),h(DB));$qb=collations();$C=DB;if($_POST)$C=$J["name"];elseif(DB!="")$J["collation"]=db_collation(DB,$qb);elseif($y=="sql"){foreach(get_vals("SHOW GRANTS")as$sd){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$sd,$B)&&$B[1]){$C=stripcslashes(idf_unescape("`$B[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add_x"]||strpos($C,"\n")?'<textarea id="name" name="name" rows="10" cols="40">'.h($C).'</textarea><br>':'<input name="name" id="name" value="'.h($C).'" data-maxlength="64" autocapitalize="off">')."\n".($qb?html_select("collation",array(""=>"(".lang(101).")")+$qb,$J["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",'mssql'=>"ms187963.aspx",)):""),script("focus(qs('#name'));"),'<input type="submit" value="',lang(14),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(127)."'>".confirm(lang(175,DB))."\n";elseif(!$_POST["add_x"]&&$_GET["db"]=="")echo"<input type='image' class='icon' name='add' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.7.9")."' alt='+' title='".lang(108)."'>\n";echo'<input type="hidden" name="token" value="',$xi,'">
</form>
';}elseif(isset($_GET["scheme"])){$J=$_POST;if($_POST&&!$o){$A=preg_replace('~ns=[^&]*&~','',ME)."ns=";if($_POST["drop"])query_redirect("DROP SCHEMA ".idf_escape($_GET["ns"]),$A,lang(188));else{$C=trim($J["name"]);$A.=urlencode($C);if($_GET["ns"]=="")query_redirect("CREATE SCHEMA ".idf_escape($C),$A,lang(189));elseif($_GET["ns"]!=$C)query_redirect("ALTER SCHEMA ".idf_escape($_GET["ns"])." RENAME TO ".idf_escape($C),$A,lang(190));else
redirect($A);}}page_header($_GET["ns"]!=""?lang(70):lang(71),$o);if(!$J)$J["name"]=$_GET["ns"];echo'
<form action="" method="post">
<p><input name="name" id="name" value="',h($J["name"]),'" autocapitalize="off">
',script("focus(qs('#name'));"),'<input type="submit" value="',lang(14),'">
';if($_GET["ns"]!="")echo"<input type='submit' name='drop' value='".lang(127)."'>".confirm(lang(175,$_GET["ns"]))."\n";echo'<input type="hidden" name="token" value="',$xi,'">
</form>
';}elseif(isset($_GET["call"])){$da=($_GET["name"]?$_GET["name"]:$_GET["call"]);page_header(lang(191).": ".h($da),$o);$dh=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Od=array();$Rf=array();foreach($dh["fields"]as$t=>$p){if(substr($p["inout"],-3)=="OUT")$Rf[$t]="@".idf_escape($p["field"])." AS ".idf_escape($p["field"]);if(!$p["inout"]||substr($p["inout"],0,2)=="IN")$Od[]=$t;}if(!$o&&$_POST){$bb=array();foreach($dh["fields"]as$z=>$p){if(in_array($z,$Od)){$X=process_input($p);if($X===false)$X="''";if(isset($Rf[$z]))$h->query("SET @".idf_escape($p["field"])." = $X");}$bb[]=(isset($Rf[$z])?"@".idf_escape($p["field"]):$X);}$G=(isset($_GET["callf"])?"SELECT":"CALL")." ".table($da)."(".implode(", ",$bb).")";$Mh=microtime(true);$H=$h->multi_query($G);$_a=$h->affected_rows;echo$b->selectQuery($G,$Mh,!$H);if(!$H)echo"<p class='error'>".error()."\n";else{$i=connect();if(is_object($i))$i->select_db(DB);do{$H=$h->store_result();if(is_object($H))select($H,$i);else
echo"<p class='message'>".lang(192,$_a)." <span class='time'>".@date("H:i:s")."</span>\n";}while($h->next_result());if($Rf)select($h->query("SELECT ".implode(", ",$Rf)));}}echo'
<form action="" method="post">
';if($Od){echo"<table cellspacing='0' class='layout'>\n";foreach($Od
as$z){$p=$dh["fields"][$z];$C=$p["field"];echo"<tr><th>".$b->fieldName($p);$Y=$_POST["fields"][$C];if($Y!=""){if($p["type"]=="enum")$Y=+$Y;if($p["type"]=="set")$Y=array_sum($Y);}input($p,$Y,(string)$_POST["function"][$C]);echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(191),'">
<input type="hidden" name="token" value="',$xi,'">
</form>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$C=$_GET["name"];$J=$_POST;if($_POST&&!$o&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){$Te=($_POST["drop"]?lang(193):($C!=""?lang(194):lang(195)));$Ee=ME."table=".urlencode($a);if(!$_POST["drop"]){$J["source"]=array_filter($J["source"],'strlen');ksort($J["source"]);$gi=array();foreach($J["source"]as$z=>$X)$gi[$z]=$J["target"][$z];$J["target"]=$gi;}if($y=="sqlite")queries_redirect($Ee,$Te,recreate_table($a,$a,array(),array(),array(" $C"=>($_POST["drop"]?"":" ".format_foreign_key($J)))));else{$c="ALTER TABLE ".table($a);$lc="\nDROP ".($y=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($C);if($_POST["drop"])query_redirect($c.$lc,$Ee,$Te);else{query_redirect($c.($C!=""?"$lc,":"")."\nADD".format_foreign_key($J),$Ee,$Te);$o=lang(196)."<br>$o";}}}page_header(lang(197),$o,array("table"=>$a),h($a));if($_POST){ksort($J["source"]);if($_POST["add"])$J["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$J["target"]=array();}elseif($C!=""){$ld=foreign_keys($a);$J=$ld[$C];$J["source"][]="";}else{$J["table"]=$a;$J["source"]=array("");}echo'
<form action="" method="post">
';$Eh=array_keys(fields($a));if($J["db"]!="")$h->select_db($J["db"]);if($J["ns"]!="")set_schema($J["ns"]);$Mg=array_keys(array_filter(table_status('',true),'fk_support'));$gi=array_keys(fields(in_array($J["table"],$Mg)?$J["table"]:reset($Mg)));$zf="this.form['change-js'].value = '1'; this.form.submit();";echo"<p>".lang(198).": ".html_select("table",$Mg,$J["table"],$zf)."\n";if($y=="pgsql")echo
lang(79).": ".html_select("ns",$b->schemas(),$J["ns"]!=""?$J["ns"]:$_GET["ns"],$zf);elseif($y!="sqlite"){$Wb=array();foreach($b->databases()as$m){if(!information_schema($m))$Wb[]=$m;}echo
lang(78).": ".html_select("db",$Wb,$J["db"]!=""?$J["db"]:$_GET["db"],$zf);}echo'<input type="hidden" name="change-js" value="">
<noscript><p><input type="submit" name="change" value="',lang(199),'"></noscript>
<table cellspacing="0">
<thead><tr><th id="label-source">',lang(134),'<th id="label-target">',lang(135),'</thead>
';$je=0;foreach($J["source"]as$z=>$X){echo"<tr>","<td>".html_select("source[".(+$z)."]",array(-1=>"")+$Eh,$X,($je==count($J["source"])-1?"foreignAddRow.call(this);":1),"label-source"),"<td>".html_select("target[".(+$z)."]",$gi,$J["target"][$z],1,"label-target");$je++;}echo'</table>
<p>
',lang(103),': ',html_select("on_delete",array(-1=>"")+explode("|",$yf),$J["on_delete"]),' ',lang(102),': ',html_select("on_update",array(-1=>"")+explode("|",$yf),$J["on_update"]),doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",'pgsql'=>"sql-createtable.html#SQL-CREATETABLE-REFERENCES",'mssql'=>"ms174979.aspx",'oracle'=>"https://docs.oracle.com/cd/B19306_01/server.102/b14200/clauses002.htm#sthref2903",)),'<p>
<input type="submit" value="',lang(14),'">
<noscript><p><input type="submit" name="add" value="',lang(200),'"></noscript>
';if($C!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$C));}echo'<input type="hidden" name="token" value="',$xi,'">
</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$J=$_POST;$Of="VIEW";if($y=="pgsql"&&$a!=""){$P=table_status($a);$Of=strtoupper($P["Engine"]);}if($_POST&&!$o){$C=trim($J["name"]);$Ha=" AS\n$J[select]";$Ee=ME."table=".urlencode($C);$Te=lang(201);$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$C&&$y!="sqlite"&&$U=="VIEW"&&$Of=="VIEW")query_redirect(($y=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($C).$Ha,$Ee,$Te);else{$ii=$C."_adminer_".uniqid();drop_create("DROP $Of ".table($a),"CREATE $U ".table($C).$Ha,"DROP $U ".table($C),"CREATE $U ".table($ii).$Ha,"DROP $U ".table($ii),($_POST["drop"]?substr(ME,0,-1):$Ee),lang(202),$Te,lang(203),$a,$C);}}if(!$_POST&&$a!=""){$J=view($a);$J["name"]=$a;$J["materialized"]=($Of!="VIEW");if(!$o)$o=error();}page_header(($a!=""?lang(45):lang(204)),$o,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(183),': <input name="name" value="',h($J["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$J["materialized"],lang(129)):""),'<p>';textarea("select",$J["select"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($a!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$a));}echo'<input type="hidden" name="token" value="',$xi,'">
</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$be=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$Oh=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$J=$_POST;if($_POST&&!$o){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(205));elseif(in_array($J["INTERVAL_FIELD"],$be)&&isset($Oh[$J["STATUS"]])){$ih="\nON SCHEDULE ".($J["INTERVAL_VALUE"]?"EVERY ".q($J["INTERVAL_VALUE"])." $J[INTERVAL_FIELD]".($J["STARTS"]?" STARTS ".q($J["STARTS"]):"").($J["ENDS"]?" ENDS ".q($J["ENDS"]):""):"AT ".q($J["STARTS"]))." ON COMPLETION".($J["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(206):lang(207)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$ih.($aa!=$J["EVENT_NAME"]?"\nRENAME TO ".idf_escape($J["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($J["EVENT_NAME"]).$ih)."\n".$Oh[$J["STATUS"]]." COMMENT ".q($J["EVENT_COMMENT"]).rtrim(" DO\n$J[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(208).": ".h($aa):lang(209)),$o);if(!$J&&$aa!=""){$K=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$J=reset($K);}echo'
<form action="" method="post">
<table cellspacing="0" class="layout">
<tr><th>',lang(183),'<td><input name="EVENT_NAME" value="',h($J["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(210),'<td><input name="STARTS" value="',h("$J[EXECUTE_AT]$J[STARTS]"),'">
<tr><th title="datetime">',lang(211),'<td><input name="ENDS" value="',h($J["ENDS"]),'">
<tr><th>',lang(212),'<td><input type="number" name="INTERVAL_VALUE" value="',h($J["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$be,$J["INTERVAL_FIELD"]),'<tr><th>',lang(118),'<td>',html_select("STATUS",$Oh,$J["STATUS"]),'<tr><th>',lang(52),'<td><input name="EVENT_COMMENT" value="',h($J["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$J["ON_COMPLETION"]=="PRESERVE",lang(213)),'</table>
<p>';textarea("EVENT_DEFINITION",$J["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($aa!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$aa));}echo'<input type="hidden" name="token" value="',$xi,'">
</form>
';}elseif(isset($_GET["procedure"])){$da=($_GET["name"]?$_GET["name"]:$_GET["procedure"]);$dh=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$J=$_POST;$J["fields"]=(array)$J["fields"];if($_POST&&!process_fields($J["fields"])&&!$o){$Lf=routine($_GET["procedure"],$dh);$ii="$J[name]_adminer_".uniqid();drop_create("DROP $dh ".routine_id($da,$Lf),create_routine($dh,$J),"DROP $dh ".routine_id($J["name"],$J),create_routine($dh,array("name"=>$ii)+$J),"DROP $dh ".routine_id($ii,$J),substr(ME,0,-1),lang(214),lang(215),lang(216),$da,$J["name"]);}page_header(($da!=""?(isset($_GET["function"])?lang(217):lang(218)).": ".h($da):(isset($_GET["function"])?lang(219):lang(220))),$o);if(!$_POST&&$da!=""){$J=routine($_GET["procedure"],$dh);$J["name"]=$da;}$qb=get_vals("SHOW CHARACTER SET");sort($qb);$eh=routine_languages();echo'
<form action="" method="post" id="form">
<p>',lang(183),': <input name="name" value="',h($J["name"]),'" data-maxlength="64" autocapitalize="off">
',($eh?lang(19).": ".html_select("language",$eh,$J["language"])."\n":""),'<input type="submit" value="',lang(14),'">
<div class="scrollable">
<table cellspacing="0" class="nowrap">
';edit_fields($J["fields"],$qb,$dh);if(isset($_GET["function"])){echo"<tr><td>".lang(221);edit_type("returns",$J["returns"],$qb,array(),($y=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$J["definition"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($da!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$da));}echo'<input type="hidden" name="token" value="',$xi,'">
</form>
';}elseif(isset($_GET["sequence"])){$fa=$_GET["sequence"];$J=$_POST;if($_POST&&!$o){$A=substr(ME,0,-1);$C=trim($J["name"]);if($_POST["drop"])query_redirect("DROP SEQUENCE ".idf_escape($fa),$A,lang(222));elseif($fa=="")query_redirect("CREATE SEQUENCE ".idf_escape($C),$A,lang(223));elseif($fa!=$C)query_redirect("ALTER SEQUENCE ".idf_escape($fa)." RENAME TO ".idf_escape($C),$A,lang(224));else
redirect($A);}page_header($fa!=""?lang(225).": ".h($fa):lang(226),$o);if(!$J)$J["name"]=$fa;echo'
<form action="" method="post">
<p><input name="name" value="',h($J["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(14),'">
';if($fa!="")echo"<input type='submit' name='drop' value='".lang(127)."'>".confirm(lang(175,$fa))."\n";echo'<input type="hidden" name="token" value="',$xi,'">
</form>
';}elseif(isset($_GET["type"])){$ga=$_GET["type"];$J=$_POST;if($_POST&&!$o){$A=substr(ME,0,-1);if($_POST["drop"])query_redirect("DROP TYPE ".idf_escape($ga),$A,lang(227));else
query_redirect("CREATE TYPE ".idf_escape(trim($J["name"]))." $J[as]",$A,lang(228));}page_header($ga!=""?lang(229).": ".h($ga):lang(230),$o);if(!$J)$J["as"]="AS ";echo'
<form action="" method="post">
<p>
';if($ga!="")echo"<input type='submit' name='drop' value='".lang(127)."'>".confirm(lang(175,$ga))."\n";else{echo"<input name='name' value='".h($J['name'])."' autocapitalize='off'>\n";textarea("as",$J["as"]);echo"<p><input type='submit' value='".lang(14)."'>\n";}echo'<input type="hidden" name="token" value="',$xi,'">
</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$C=$_GET["name"];$Hi=trigger_options();$J=(array)trigger($C)+array("Trigger"=>$a."_bi");if($_POST){if(!$o&&in_array($_POST["Timing"],$Hi["Timing"])&&in_array($_POST["Event"],$Hi["Event"])&&in_array($_POST["Type"],$Hi["Type"])){$xf=" ON ".table($a);$lc="DROP TRIGGER ".idf_escape($C).($y=="pgsql"?$xf:"");$Ee=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($lc,$Ee,lang(231));else{if($C!="")queries($lc);queries_redirect($Ee,($C!=""?lang(232):lang(233)),queries(create_trigger($xf,$_POST)));if($C!="")queries(create_trigger($xf,$J+array("Type"=>reset($Hi["Type"]))));}}$J=$_POST;}page_header(($C!=""?lang(234).": ".h($C):lang(235)),$o,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table cellspacing="0" class="layout">
<tr><th>',lang(236),'<td>',html_select("Timing",$Hi["Timing"],$J["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(237),'<td>',html_select("Event",$Hi["Event"],$J["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$Hi["Event"])?" <input name='Of' value='".h($J["Of"])."' class='hidden'>":""),'<tr><th>',lang(51),'<td>',html_select("Type",$Hi["Type"],$J["Type"]),'</table>
<p>',lang(183),': <input name="Trigger" value="',h($J["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$J["Statement"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($C!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$C));}echo'<input type="hidden" name="token" value="',$xi,'">
</form>
';}elseif(isset($_GET["user"])){$ha=$_GET["user"];$yg=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$J){foreach(explode(",",($J["Privilege"]=="Grant option"?"":$J["Context"]))as$Gb)$yg[$Gb][$J["Privilege"]]=$J["Comment"];}$yg["Server Admin"]+=$yg["File access on server"];$yg["Databases"]["Create routine"]=$yg["Procedures"]["Create routine"];unset($yg["Procedures"]["Create routine"]);$yg["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$yg["Columns"][$X]=$yg["Tables"][$X];unset($yg["Server Admin"]["Usage"]);foreach($yg["Tables"]as$z=>$X)unset($yg["Databases"][$z]);$gf=array();if($_POST){foreach($_POST["objects"]as$z=>$X)$gf[$X]=(array)$gf[$X]+(array)$_POST["grants"][$z];}$td=array();$vf="";if(isset($_GET["host"])&&($H=$h->query("SHOW GRANTS FOR ".q($ha)."@".q($_GET["host"])))){while($J=$H->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$J[0],$B)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$B[1],$Le,PREG_SET_ORDER)){foreach($Le
as$X){if($X[1]!="USAGE")$td["$B[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$J[0]))$td["$B[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$J[0],$B))$vf=$B[1];}}if($_POST&&!$o){$wf=(isset($_GET["host"])?q($ha)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $wf",ME."privileges=",lang(238));else{$if=q($_POST["user"])."@".q($_POST["host"]);$fg=$_POST["pass"];if($fg!=''&&!$_POST["hashed"]&&!min_version(8)){$fg=$h->result("SELECT PASSWORD(".q($fg).")");$o=!$fg;}$Lb=false;if(!$o){if($wf!=$if){$Lb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $if IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($fg));$o=!$Lb;}elseif($fg!=$vf)queries("SET PASSWORD FOR $if = ".q($fg));}if(!$o){$ah=array();foreach($gf
as$qf=>$sd){if(isset($_GET["grant"]))$sd=array_filter($sd);$sd=array_keys($sd);if(isset($_GET["grant"]))$ah=array_diff(array_keys(array_filter($gf[$qf],'strlen')),$sd);elseif($wf==$if){$tf=array_keys((array)$td[$qf]);$ah=array_diff($tf,$sd);$sd=array_diff($sd,$tf);unset($td[$qf]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$qf,$B)&&(!grant("REVOKE",$ah,$B[2]," ON $B[1] FROM $if")||!grant("GRANT",$sd,$B[2]," ON $B[1] TO $if"))){$o=true;break;}}}if(!$o&&isset($_GET["host"])){if($wf!=$if)queries("DROP USER $wf");elseif(!isset($_GET["grant"])){foreach($td
as$qf=>$ah){if(preg_match('~^(.+)(\(.*\))?$~U',$qf,$B))grant("REVOKE",array_keys($ah),$B[2]," ON $B[1] FROM $if");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(239):lang(240)),!$o);if($Lb)$h->query("DROP USER $if");}}page_header((isset($_GET["host"])?lang(37).": ".h("$ha@$_GET[host]"):lang(146)),$o,array("privileges"=>array('',lang(73))));if($_POST){$J=$_POST;$td=$gf;}else{$J=$_GET+array("host"=>$h->result("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$J["pass"]=$vf;if($vf!="")$J["hashed"]=true;$td[(DB==""||$td?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table cellspacing="0" class="layout">
<tr><th>',lang(36),'<td><input name="host" data-maxlength="60" value="',h($J["host"]),'" autocapitalize="off">
<tr><th>',lang(37),'<td><input name="user" data-maxlength="80" value="',h($J["user"]),'" autocapitalize="off">
<tr><th>',lang(38),'<td><input name="pass" id="pass" value="',h($J["pass"]),'" autocomplete="new-password">
';if(!$J["hashed"])echo
script("typePassword(qs('#pass'));");echo(min_version(8)?"":checkbox("hashed",1,$J["hashed"],lang(241),"typePassword(this.form['pass'], this.checked);")),'</table>

';echo"<table cellspacing='0'>\n","<thead><tr><th colspan='2'>".lang(73).doc_link(array('sql'=>"grant.html#priv_level"));$t=0;foreach($td
as$qf=>$sd){echo'<th>'.($qf!="*.*"?"<input name='objects[$t]' value='".h($qf)."' size='10' autocapitalize='off'>":"<input type='hidden' name='objects[$t]' value='*.*' size='10'>*.*");$t++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(36),"Databases"=>lang(39),"Tables"=>lang(131),"Columns"=>lang(50),"Procedures"=>lang(242),)as$Gb=>$dc){foreach((array)$yg[$Gb]as$xg=>$vb){echo"<tr".odd()."><td".($dc?">$dc<td":" colspan='2'").' lang="en" title="'.h($vb).'">'.h($xg);$t=0;foreach($td
as$qf=>$sd){$C="'grants[$t][".h(strtoupper($xg))."]'";$Y=$sd[strtoupper($xg)];if($Gb=="Server Admin"&&$qf!=(isset($td["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$C><option><option value='1'".($Y?" selected":"").">".lang(243)."<option value='0'".($Y=="0"?" selected":"").">".lang(244)."</select>";else{echo"<td align='center'><label class='block'>","<input type='checkbox' name=$C value='1'".($Y?" checked":"").($xg=="All privileges"?" id='grants-$t-all'>":">".($xg=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$t-all'); };"))),"</label>";}$t++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(14),'">
';if(isset($_GET["host"])){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,"$ha@$_GET[host]"));}echo'<input type="hidden" name="token" value="',$xi,'">
</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")&&$_POST&&!$o){$qe=0;foreach((array)$_POST["kill"]as$X){if(kill_process($X))$qe++;}queries_redirect(ME."processlist=",lang(245,$qe),$qe||!$_POST["kill"]);}page_header(lang(116),$o);echo'
<form action="" method="post">
<div class="scrollable">
<table cellspacing="0" class="nowrap checkable">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$t=-1;foreach(process_list()as$t=>$J){if(!$t){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($J
as$z=>$X)echo"<th>$z".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($z),'pgsql'=>"monitoring-stats.html#PG-STAT-ACTIVITY-VIEW",'oracle'=>"REFRN30223",));echo"</thead>\n";}echo"<tr".odd().">".(support("kill")?"<td>".checkbox("kill[]",$J[$y=="sql"?"Id":"pid"],0):"");foreach($J
as$z=>$X)echo"<td>".(($y=="sql"&&$z=="Info"&&preg_match("~Query|Killed~",$J["Command"])&&$X!="")||($y=="pgsql"&&$z=="current_query"&&$X!="<IDLE>")||($y=="oracle"&&$z=="sql_text"&&$X!="")?"<code class='jush-$y'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($J["db"]!=""?"db=".urlencode($J["db"])."&":"")."sql=".urlencode($X)).'">'.lang(246).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill")){echo($t+1)."/".lang(247,max_connections()),"<p><input type='submit' value='".lang(248)."'>\n";}echo'<input type="hidden" name="token" value="',$xi,'">
</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$S=table_status1($a);$x=indexes($a);$q=fields($a);$ld=column_foreign_keys($a);$sf=$S["Oid"];parse_str($_COOKIE["adminer_import"],$za);$bh=array();$f=array();$mi=null;foreach($q
as$z=>$p){$C=$b->fieldName($p);if(isset($p["privileges"]["select"])&&$C!=""){$f[$z]=html_entity_decode(strip_tags($C),ENT_QUOTES);if(is_shortable($p))$mi=$b->selectLengthProcess();}$bh+=$p["privileges"];}list($L,$ud)=$b->selectColumnsProcess($f,$x);$fe=count($ud)<count($L);$Z=$b->selectSearchProcess($q,$x);$Hf=$b->selectOrderProcess($q,$x);$_=$b->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$Pi=>$J){$Ha=convert_field($q[key($J)]);$L=array($Ha?$Ha:idf_escape(key($J)));$Z[]=where_check($Pi,$q);$I=$n->select($a,$L,$Z,$L);if($I)echo
reset($I->fetch_row());}exit;}$tg=$Ri=null;foreach($x
as$w){if($w["type"]=="PRIMARY"){$tg=array_flip($w["columns"]);$Ri=($L?$tg:array());foreach($Ri
as$z=>$X){if(in_array(idf_escape($z),$L))unset($Ri[$z]);}break;}}if($sf&&!$tg){$tg=$Ri=array($sf=>0);$x[]=array("type"=>"PRIMARY","columns"=>array($sf));}if($_POST&&!$o){$tj=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$hb=array();foreach($_POST["check"]as$eb)$hb[]=where_check($eb,$q);$tj[]="((".implode(") OR (",$hb)."))";}$tj=($tj?"\nWHERE ".implode(" AND ",$tj):"");if($_POST["export"]){cookie("adminer_import","output=".urlencode($_POST["output"])."&format=".urlencode($_POST["format"]));dump_headers($a);$b->dumpTable($a,"");$qd=($L?implode(", ",$L):"*").convert_fields($f,$q,$L)."\nFROM ".table($a);$wd=($ud&&$fe?"\nGROUP BY ".implode(", ",$ud):"").($Hf?"\nORDER BY ".implode(", ",$Hf):"");if(!is_array($_POST["check"])||$tg)$G="SELECT $qd$tj$wd";else{$Ni=array();foreach($_POST["check"]as$X)$Ni[]="(SELECT".limit($qd,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$q).$wd,1).")";$G=implode(" UNION ALL ",$Ni);}$b->dumpData($a,"table",$G);exit;}if(!$b->selectEmailProcess($Z,$ld)){if($_POST["save"]||$_POST["delete"]){$H=true;$_a=0;$O=array();if(!$_POST["delete"]){foreach($f
as$C=>$X){$X=process_input($q[$C]);if($X!==null&&($_POST["clone"]||$X!==false))$O[idf_escape($C)]=($X!==false?$X:idf_escape($C));}}if($_POST["delete"]||$O){if($_POST["clone"])$G="INTO ".table($a)." (".implode(", ",array_keys($O)).")\nSELECT ".implode(", ",$O)."\nFROM ".table($a);if($_POST["all"]||($tg&&is_array($_POST["check"]))||$fe){$H=($_POST["delete"]?$n->delete($a,$tj):($_POST["clone"]?queries("INSERT $G$tj"):$n->update($a,$O,$tj)));$_a=$h->affected_rows;}else{foreach((array)$_POST["check"]as$X){$pj="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$q);$H=($_POST["delete"]?$n->delete($a,$pj,1):($_POST["clone"]?queries("INSERT".limit1($a,$G,$pj)):$n->update($a,$O,$pj,1)));if(!$H)break;$_a+=$h->affected_rows;}}}$Te=lang(249,$_a);if($_POST["clone"]&&$H&&$_a==1){$we=last_id();if($we)$Te=lang(168," $we");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$Te,$H);if(!$_POST["delete"]){edit_form($a,$q,(array)$_POST["fields"],!$_POST["clone"]);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$o=lang(250);else{$H=true;$_a=0;foreach($_POST["val"]as$Pi=>$J){$O=array();foreach($J
as$z=>$X){$z=bracket_escape($z,1);$O[idf_escape($z)]=(preg_match('~char|text~',$q[$z]["type"])||$X!=""?$b->processInput($q[$z],$X):"NULL");}$H=$n->update($a,$O," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($Pi,$q),!$fe&&!$tg," ");if(!$H)break;$_a+=$h->affected_rows;}queries_redirect(remove_from_uri(),lang(249,$_a),$H);}}elseif(!is_string($ad=get_file("csv_file",true)))$o=upload_error($ad);elseif(!preg_match('~~u',$ad))$o=lang(251);else{cookie("adminer_import","output=".urlencode($za["output"])."&format=".urlencode($_POST["separator"]));$H=true;$sb=array_keys($q);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$ad,$Le);$_a=count($Le[0]);$n->begin();$M=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$K=array();foreach($Le[0]as$z=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$M]*)$M~",$X.$M,$Me);if(!$z&&!array_diff($Me[1],$sb)){$sb=$Me[1];$_a--;}else{$O=array();foreach($Me[1]as$t=>$ob)$O[idf_escape($sb[$t])]=($ob==""&&$q[$sb[$t]]["null"]?"NULL":q(str_replace('""','"',preg_replace('~^"|"$~','',$ob))));$K[]=$O;}}$H=(!$K||$n->insertUpdate($a,$K,$tg));if($H)$H=$n->commit();queries_redirect(remove_from_uri("page"),lang(252,$_a),$H);$n->rollback();}}}$Yh=$b->tableName($S);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(55).": $Yh",$o);$O=null;if(isset($bh["insert"])||!support("table")){$O="";foreach((array)$_GET["where"]as$X){if($ld[$X["col"]]&&count($ld[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&!preg_match('~[_%]~',$X["val"]))))$O.="&set".urlencode("[".bracket_escape($X["col"])."]")."=".urlencode($X["val"]);}}$b->selectLinks($S,$O);if(!$f&&support("table"))echo"<p class='error'>".lang(253).($q?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?'<input type="hidden" name="db" value="'.h(DB).'">'.(isset($_GET["ns"])?'<input type="hidden" name="ns" value="'.h($_GET["ns"]).'">':""):"");echo'<input type="hidden" name="select" value="'.h($a).'">',"</div>\n";$b->selectColumnsPrint($L,$f);$b->selectSearchPrint($Z,$f,$x);$b->selectOrderPrint($Hf,$f,$x);$b->selectLimitPrint($_);$b->selectLengthPrint($mi);$b->selectActionPrint($x);echo"</form>\n";$E=$_GET["page"];if($E=="last"){$od=$h->result(count_rows($a,$Z,$fe,$ud));$E=floor(max(0,$od-1)/$_);}$nh=$L;$vd=$ud;if(!$nh){$nh[]="*";$Hb=convert_fields($f,$q,$L);if($Hb)$nh[]=substr($Hb,2);}foreach($L
as$z=>$X){$p=$q[idf_unescape($X)];if($p&&($Ha=convert_field($p)))$nh[$z]="$Ha AS $X";}if(!$fe&&$Ri){foreach($Ri
as$z=>$X){$nh[]=idf_escape($z);if($vd)$vd[]=idf_escape($z);}}$H=$n->select($a,$nh,$Z,$vd,$Hf,$_,$E,true);if(!$H)echo"<p class='error'>".error()."\n";else{if($y=="mssql"&&$E)$H->seek($_*$E);$yc=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$K=array();while($J=$H->fetch_assoc()){if($E&&$y=="oracle")unset($J["RNUM"]);$K[]=$J;}if($_GET["page"]!="last"&&$_!=""&&$ud&&$fe&&$y=="sql")$od=$h->result(" SELECT FOUND_ROWS()");if(!$K)echo"<p class='message'>".lang(12)."\n";else{$Ra=$b->backwardKeys($a,$Yh);echo"<div class='scrollable'>","<table id='table' cellspacing='0' class='nowrap checkable'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$ud&&$L?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(254)."</a>");$ff=array();$rd=array();reset($L);$Hg=1;foreach($K[0]as$z=>$X){if(!isset($Ri[$z])){$X=$_GET["columns"][key($L)];$p=$q[$L?($X?$X["col"]:current($L)):$z];$C=($p?$b->fieldName($p,$Hg):($X["fun"]?"*":$z));if($C!=""){$Hg++;$ff[$z]=$C;$e=idf_escape($z);$Id=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($z);$dc="&desc%5B0%5D=1";echo"<th>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});",""),'<a href="'.h($Id.($Hf[0]==$e||$Hf[0]==$z||(!$Hf&&$fe&&$ud[0]==$e)?$dc:'')).'">';echo
apply_sql_function($X["fun"],$C)."</a>";echo"<span class='column hidden'>","<a href='".h($Id.$dc)."' title='".lang(61)."' class='text'> ↓</a>";if(!$X["fun"]){echo'<a href="#fieldset-search" title="'.lang(58).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($z)."');");}echo"</span>";}$rd[$z]=$X["fun"];next($L);}}$Be=array();if($_GET["modify"]){foreach($K
as$J){foreach($J
as$z=>$X)$Be[$z]=max($Be[$z],min(40,strlen(utf8_decode($X))));}}echo($Ra?"<th>".lang(255):"")."</thead>\n";if(is_ajax()){if($_%2==1&&$E%2==1)odd();ob_end_clean();}foreach($b->rowDescriptions($K,$ld)as$ef=>$J){$Oi=unique_array($K[$ef],$x);if(!$Oi){$Oi=array();foreach($K[$ef]as$z=>$X){if(!preg_match('~^(COUNT\((\*|(DISTINCT )?`(?:[^`]|``)+`)\)|(AVG|GROUP_CONCAT|MAX|MIN|SUM)\(`(?:[^`]|``)+`\))$~',$z))$Oi[$z]=$X;}}$Pi="";foreach($Oi
as$z=>$X){if(($y=="sql"||$y=="pgsql")&&preg_match('~char|text|enum|set~',$q[$z]["type"])&&strlen($X)>64){$z=(strpos($z,'(')?$z:idf_escape($z));$z="MD5(".($y!='sql'||preg_match("~^utf8~",$q[$z]["collation"])?$z:"CONVERT($z USING ".charset($h).")").")";$X=md5($X);}$Pi.="&".($X!==null?urlencode("where[".bracket_escape($z)."]")."=".urlencode($X):"null%5B%5D=".urlencode($z));}echo"<tr".odd().">".(!$ud&&$L?"":"<td>".checkbox("check[]",substr($Pi,1),in_array(substr($Pi,1),(array)$_POST["check"])).($fe||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$Pi)."' class='edit'>".lang(256)."</a>"));foreach($J
as$z=>$X){if(isset($ff[$z])){$p=$q[$z];$X=$n->value($X,$p);if($X!=""&&(!isset($yc[$z])||$yc[$z]!=""))$yc[$z]=(is_mail($X)?$ff[$z]:"");$A="";if(preg_match('~blob|bytea|raw|file~',$p["type"])&&$X!="")$A=ME.'download='.urlencode($a).'&field='.urlencode($z).$Pi;if(!$A&&$X!==null){foreach((array)$ld[$z]as$r){if(count($ld[$z])==1||end($r["source"])==$z){$A="";foreach($r["source"]as$t=>$Eh)$A.=where_link($t,$r["target"][$t],$K[$ef][$Eh]);$A=($r["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($r["db"]),ME):ME).'select='.urlencode($r["table"]).$A;if($r["ns"])$A=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($r["ns"]),$A);if(count($r["source"])==1)break;}}}if($z=="COUNT(*)"){$A=ME."select=".urlencode($a);$t=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$Oi))$A.=where_link($t++,$W["col"],$W["val"],$W["op"]);}foreach($Oi
as$ke=>$W)$A.=where_link($t++,$ke,$W);}$X=select_value($X,$A,$p,$mi);$u=h("val[$Pi][".bracket_escape($z)."]");$Y=$_POST["val"][$Pi][bracket_escape($z)];$tc=!is_array($J[$z])&&is_utf8($X)&&$K[$ef][$z]==$J[$z]&&!$rd[$z];$li=preg_match('~text|lob~',$p["type"]);echo"<td id='$u'";if(($_GET["modify"]&&$tc)||$Y!==null){$zd=h($Y!==null?$Y:$J[$z]);echo">".($li?"<textarea name='$u' cols='30' rows='".(substr_count($J[$z],"\n")+1)."'>$zd</textarea>":"<input name='$u' value='$zd' size='$Be[$z]'>");}else{$Ge=strpos($X,"<i>…</i>");echo" data-text='".($Ge?2:($li?1:0))."'".($tc?"":" data-warning='".h(lang(257))."'").">$X</td>";}}}if($Ra)echo"<td>";$b->backwardKeysPrint($Ra,$K[$ef]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($K||$E){$Ic=true;if($_GET["page"]!="last"){if($_==""||(count($K)<$_&&($K||!$E)))$od=($E?$E*$_:0)+count($K);elseif($y!="sql"||!$fe){$od=($fe?false:found_rows($S,$Z));if($od<max(1e4,2*($E+1)*$_))$od=reset(slow_query(count_rows($a,$Z,$fe,$ud)));else$Ic=false;}}$Uf=($_!=""&&($od===false||$od>$_||$E));if($Uf){echo(($od===false?count($K)+1:$od-$E*$_)>$_?'<p><a href="'.h(remove_from_uri("page")."&page=".($E+1)).'" class="loadmore">'.lang(258).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, ".(+$_).", '".lang(259)."…');",""):''),"\n";}}echo"<div class='footer'><div>\n";if($K||$E){if($Uf){$Oe=($od===false?$E+(count($K)>=$_?2:1):floor(($od-1)/$_));echo"<fieldset>";if($y!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(260)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(260)."', '".($E+1)."')); return false; };"),pagination(0,$E).($E>5?" …":"");for($t=max(1,$E-4);$t<min($Oe,$E+5);$t++)echo
pagination($t,$E);if($Oe>0){echo($E+5<$Oe?" …":""),($Ic&&$od!==false?pagination($Oe,$E):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$Oe'>".lang(261)."</a>");}}else{echo"<legend>".lang(260)."</legend>",pagination(0,$E).($E>1?" …":""),($E?pagination($E,$E):""),($Oe>$E?pagination($E+1,$E).($Oe>$E+1?" …":""):"");}echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(262)."</legend>";$ic=($Ic?"":"~ ").$od;echo
checkbox("all",1,0,($od!==false?($Ic?"":"~ ").lang(150,$od):""),"var checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$ic' : checked); selectCount('selected2', this.checked || !checked ? '$ic' : checked);")."\n","</fieldset>\n";if($b->selectCommandPrint()){echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(254),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(250).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(126),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(246),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';}$md=$b->dumpFormat();foreach((array)$_GET["columns"]as$e){if($e["fun"]){unset($md['sql']);break;}}if($md){print_fieldset("export",lang(75)." <span id='selected2'></span>");$Sf=$b->dumpOutput();echo($Sf?html_select("output",$Sf,$za["output"])." ":""),html_select("format",$md,$za["format"])," <input type='submit' name='export' value='".lang(75)."'>\n","</div></fieldset>\n";}$b->selectEmailPrint(array_filter($yc,'strlen'),$f);}echo"</div></div>\n";if($b->selectImportPrint()){echo"<div>","<a href='#import'>".lang(74)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import' class='hidden'>: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$za["format"],1);echo" <input type='submit' name='import' value='".lang(74)."'>","</span>","</div>";}echo"<input type='hidden' name='token' value='$xi'>\n","</form>\n",(!$ud&&$L?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$P=isset($_GET["status"]);page_header($P?lang(118):lang(117));$gj=($P?show_status():show_variables());if(!$gj)echo"<p class='message'>".lang(12)."\n";else{echo"<table cellspacing='0'>\n";foreach($gj
as$z=>$X){echo"<tr>","<th><code class='jush-".$y.($P?"status":"set")."'>".h($z)."</code>","<td>".h($X);}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$Vh=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$C=>$S){json_row("Comment-$C",h($S["Comment"]));if(!is_view($S)){foreach(array("Engine","Collation")as$z)json_row("$z-$C",h($S[$z]));foreach($Vh+array("Auto_increment"=>0,"Rows"=>0)as$z=>$X){if($S[$z]!=""){$X=format_number($S[$z]);json_row("$z-$C",($z=="Rows"&&$X&&$S["Engine"]==($Hh=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($Vh[$z]))$Vh[$z]+=($S["Engine"]!="InnoDB"||$z!="Data_free"?$S[$z]:0);}elseif(array_key_exists($z,$S))json_row("$z-$C");}}}foreach($Vh
as$z=>$X)json_row("sum-$z",format_number($X));json_row("");}elseif($_GET["script"]=="kill")$h->query("KILL ".number($_POST["kill"]));else{foreach(count_tables($b->databases())as$m=>$X){json_row("tables-$m",$X);json_row("size-$m",db_size($m));}json_row("");}exit;}else{$ei=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($ei&&!$o&&!$_POST["search"]){$H=true;$Te="";if($y=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$H=truncate_tables($_POST["tables"]);$Te=lang(263);}elseif($_POST["move"]){$H=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Te=lang(264);}elseif($_POST["copy"]){$H=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Te=lang(265);}elseif($_POST["drop"]){if($_POST["views"])$H=drop_views($_POST["views"]);if($H&&$_POST["tables"])$H=drop_tables($_POST["tables"]);$Te=lang(266);}elseif($y!="sql"){$H=($y=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$Te=lang(267);}elseif(!$_POST["tables"])$Te=lang(9);elseif($H=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('idf_escape',$_POST["tables"])))){while($J=$H->fetch_assoc())$Te.="<b>".h($J["Table"])."</b>: ".h($J["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$Te,$H);}page_header(($_GET["ns"]==""?lang(39).": ".h(DB):lang(79).": ".h($_GET["ns"])),$o,true);if($b->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(268)."</h3>\n";$di=tables_list();if(!$di)echo"<p class='message'>".lang(9)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(269)." <span id='selected2'></span></legend><div>","<input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(58)."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]="LIKE %%";search_tables();}}echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(131),'<td>'.lang(270).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(122).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(271).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT','oracle'=>'REFRN20286')),'<td>'.lang(272).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT')),'<td>'.lang(273).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(53).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(274).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'catalog-pg-class.html#CATALOG-PG-CLASS','oracle'=>'REFRN20286')),(support("comment")?'<td>'.lang(52).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-info.html#FUNCTIONS-INFO-COMMENT-TABLE')):''),"</thead>\n";$T=0;foreach($di
as$C=>$U){$jj=($U!==null&&!preg_match('~table~i',$U));$u=h("Table-".$C);echo'<tr'.odd().'><td>'.checkbox(($jj?"views[]":"tables[]"),$C,in_array($C,$ei,true),"","","",$u),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($C)."' title='".lang(44)."' id='$u'>".h($C).'</a>':h($C));if($jj){echo'<td colspan="6"><a href="'.h(ME)."view=".urlencode($C).'" title="'.lang(45).'">'.(preg_match('~materialized~i',$U)?lang(129):lang(130)).'</a>','<td align="right"><a href="'.h(ME)."select=".urlencode($C).'" title="'.lang(43).'">?</a>';}else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(46)),"Index_length"=>array("indexes",lang(133)),"Data_free"=>array("edit",lang(47)),"Auto_increment"=>array("auto_increment=1&create",lang(46)),"Rows"=>array("select",lang(43)),)as$z=>$A){$u=" id='$z-".h($C)."'";echo($A?"<td align='right'>".(support("table")||$z=="Rows"||(support("indexes")&&$z!="Data_length")?"<a href='".h(ME."$A[0]=").urlencode($C)."'$u title='$A[1]'>?</a>":"<span$u>?</span>"):"<td id='$z-".h($C)."'>");}$T++;}echo(support("comment")?"<td id='Comment-".h($C)."'>":"");}echo"<tr><td><th>".lang(247,count($di)),"<td>".h($y=="sql"?$h->result("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$z)echo"<td align='right' id='sum-$z'>";echo"</table>\n","</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$dj="<input type='submit' value='".lang(275)."'> ".on_help("'VACUUM'");$Df="<input type='submit' name='optimize' value='".lang(276)."'> ".on_help($y=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(126)." <span id='selected'></span></legend><div>".($y=="sqlite"?$dj:($y=="pgsql"?$dj.$Df:($y=="sql"?"<input type='submit' value='".lang(277)."'> ".on_help("'ANALYZE TABLE'").$Df."<input type='submit' name='check' value='".lang(278)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(279)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(280)."'> ".on_help($y=="sqlite"?"'DELETE'":"'TRUNCATE".($y=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(127)."'>".on_help("'DROP TABLE'").confirm()."\n";$l=(support("scheme")?$b->schemas():$b->databases());if(count($l)!=1&&$y!="sqlite"){$m=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo"<p>".lang(281).": ",($l?html_select("target",$l,$m):'<input name="target" value="'.h($m).'" autocapitalize="off">')," <input type='submit' name='move' value='".lang(282)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(283)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(284)):""),"\n";}echo"<input type='hidden' name='all' value=''>";echo
script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $T);":"")." }"),"<input type='hidden' name='token' value='$xi'>\n","</div></fieldset>\n","</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo'<p class="links"><a href="'.h(ME).'create=">'.lang(76)."</a>\n",(support("view")?'<a href="'.h(ME).'view=">'.lang(204)."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".lang(143)."</h3>\n";$fh=routines();if($fh){echo"<table cellspacing='0'>\n",'<thead><tr><th>'.lang(183).'<td>'.lang(51).'<td>'.lang(221)."<td></thead>\n";odd('');foreach($fh
as$J){$C=($J["SPECIFIC_NAME"]==$J["ROUTINE_NAME"]?"":"&name=".urlencode($J["ROUTINE_NAME"]));echo'<tr'.odd().'>','<th><a href="'.h(ME.($J["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($J["SPECIFIC_NAME"]).$C).'">'.h($J["ROUTINE_NAME"]).'</a>','<td>'.h($J["ROUTINE_TYPE"]),'<td>'.h($J["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($J["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($J["SPECIFIC_NAME"]).$C).'">'.lang(136)."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.lang(220).'</a>':'').'<a href="'.h(ME).'function=">'.lang(219)."</a>\n";}if(support("sequence")){echo"<h3 id='sequences'>".lang(285)."</h3>\n";$th=get_vals("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema = current_schema() ORDER BY sequence_name");if($th){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(183)."</thead>\n";odd('');foreach($th
as$X)echo"<tr".odd()."><th><a href='".h(ME)."sequence=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."sequence='>".lang(226)."</a>\n";}if(support("type")){echo"<h3 id='user-types'>".lang(26)."</h3>\n";$bj=types();if($bj){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(183)."</thead>\n";odd('');foreach($bj
as$X)echo"<tr".odd()."><th><a href='".h(ME)."type=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."type='>".lang(230)."</a>\n";}if(support("event")){echo"<h3 id='events'>".lang(144)."</h3>\n";$K=get_rows("SHOW EVENTS");if($K){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(183)."<td>".lang(286)."<td>".lang(210)."<td>".lang(211)."<td></thead>\n";foreach($K
as$J){echo"<tr>","<th>".h($J["Name"]),"<td>".($J["Execute at"]?lang(287)."<td>".$J["Execute at"]:lang(212)." ".$J["Interval value"]." ".$J["Interval field"]."<td>$J[Starts]"),"<td>$J[Ends]",'<td><a href="'.h(ME).'event='.urlencode($J["Name"]).'">'.lang(136).'</a>';}echo"</table>\n";$Gc=$h->result("SELECT @@event_scheduler");if($Gc&&$Gc!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($Gc)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.lang(209)."</a>\n";}if($di)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}}}page_footer();