<?php
/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.0 on 2013-02-01 at 23:10:54.
 */
class JGithubPackageOrgsTeamsTest extends \PHPUnit\Framework\TestCase
{
	/**
	 * @var    JRegistry  Options for the GitHub object.
	 * @since  2.5.0
	 */
	protected $options;

	/**
	 * @var    JGithubHttp  Mock client object.
	 * @since  2.5.0
	 */
	protected $client;

	/**
	 * @var    JHttpResponse  Mock response object.
	 * @since  3.1.4
	 */
	protected $response;

	/**
	 * @var JGithubPackageOrgsTeams
	 */
	protected $object;

	/**
	 * @var    string  Sample JSON string.
	 * @since  3.1.4
	 */
	protected $sampleString = '{"a":1,"b":2,"c":3,"d":4,"e":5}';

	/**
	 * @var    string  Sample JSON error message.
	 * @since  3.1.4
	 */
	protected $errorString = '{"message": "Generic Error"}';

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 *
	 * @since   ¿
	 *
	 * @return  void
	 */
	protected function setUp()
	{
		parent::setUp();

		$this->options  = new JRegistry;
		$this->client   = $this->getMockBuilder('JGithubHttp')->setMethods(array('get', 'post', 'delete', 'patch', 'put'))->getMock();
		$this->response = $this->getMockBuilder('JHttpResponse')->getMock();

		$this->object = new JGithubPackageOrgsTeams($this->options, $this->client);
	}

	/**
	 * @covers JGithubPackageOrgsTeams::getList
	 */
	public function testGetList()
	{
		$this->response->code = 200;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/orgs/joomla/teams')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->getList('joomla'),
			$this->equalTo(json_decode($this->sampleString))
		);
	}

	/**
	 * @covers JGithubPackageOrgsTeams::get
	 */
	public function testGet()
	{
		$this->response->code = 200;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/teams/123')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->get(123),
			$this->equalTo(json_decode($this->sampleString))
		);
	}

	/**
	 * @covers JGithubPackageOrgsTeams::create
	 */
	public function testCreate()
	{
		$this->response->code = 201;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('post')
			->with('/orgs/joomla/teams')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->create('joomla', 'TheTeam', array('joomla-platform'), 'admin'),
			$this->equalTo(json_decode($this->sampleString))
		);
	}

	/**
	 * @covers JGithubPackageOrgsTeams::create
	 *
	 * @expectedException UnexpectedValueException
	 */
	public function testCreateWrongPermission()
	{
		$this->response->code = 201;
		$this->response->body = $this->sampleString;

		$this->object->create('joomla', 'TheTeam', array('joomla-platform'), 'invalid');
	}

	/**
	 * @covers JGithubPackageOrgsTeams::edit
	 */
	public function testEdit()
	{
		$this->response->code = 200;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('patch')
			->with('/teams/123')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->edit(123, 'TheTeam', 'admin'),
			$this->equalTo(json_decode($this->sampleString))
		);
	}

	/**
	 * @covers JGithubPackageOrgsTeams::edit
	 *
	 * @expectedException UnexpectedValueException
	 */
	public function testEditWrongPermission()
	{
		$this->response->code = 200;
		$this->response->body = $this->sampleString;

		$this->object->edit(123, 'TheTeam', 'invalid');
	}

	/**
	 * @covers JGithubPackageOrgsTeams::delete
	 */
	public function testDelete()
	{
		$this->response->code = 204;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('delete')
			->with('/teams/123')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->delete(123),
			$this->equalTo(json_decode($this->sampleString))
		);
	}

	/**
	 * @covers JGithubPackageOrgsTeams::getListMembers
	 */
	public function testGetListMembers()
	{
		$this->response->code = 200;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/teams/123/members')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->getListMembers(123),
			$this->equalTo(json_decode($this->sampleString))
		);
	}

	/**
	 * @covers JGithubPackageOrgsTeams::isMember
	 */
	public function testIsMember()
	{
		$this->response->code = 204;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/teams/123/members/elkuku')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->isMember(123, 'elkuku'),
			$this->equalTo(json_decode(true))
		);
	}

	/**
	 * @covers JGithubPackageOrgsTeams::isMember
	 */
	public function testIsMemberNo()
	{
		$this->response->code = 404;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/teams/123/members/elkuku')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->isMember(123, 'elkuku'),
			$this->equalTo(json_decode(false))
		);
	}

	/**
	 * @covers JGithubPackageOrgsTeams::isMember
	 *
	 * @expectedException UnexpectedValueException
	 */
	public function testIsMemberUnexpected()
	{
		$this->response->code = 666;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/teams/123/members/elkuku')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->isMember(123, 'elkuku'),
			$this->equalTo(json_decode(true))
		);
	}

	/**
	 * @covers JGithubPackageOrgsTeams::addMember
	 */
	public function testAddMember()
	{
		$this->response->code = 204;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('put')
			->with('/teams/123/members/elkuku')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->addMember(123, 'elkuku'),
			$this->equalTo(json_decode($this->sampleString))
		);
	}

	/**
	 * @covers JGithubPackageOrgsTeams::removeMember
	 */
	public function testRemoveMember()
	{
		$this->response->code = 204;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('delete')
			->with('/teams/123/members/elkuku')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->removeMember(123, 'elkuku'),
			$this->equalTo(json_decode($this->sampleString))
		);
	}

	/**
	 * @covers JGithubPackageOrgsTeams::getListRepos
	 */
	public function testGetListRepos()
	{
		$this->response->code = 200;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/teams/123/repos')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->getListRepos(123),
			$this->equalTo(json_decode($this->sampleString))
		);
	}

	/**
	 * @covers JGithubPackageOrgsTeams::checkRepo
	 */
	public function testCheckRepo()
	{
		$this->response->code = 204;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/teams/123/repos/joomla')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->checkRepo(123, 'joomla'),
			$this->equalTo(true)
		);
	}

	/**
	 * @covers JGithubPackageOrgsTeams::checkRepo
	 */
	public function testCheckRepoNo()
	{
		$this->response->code = 404;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/teams/123/repos/joomla')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->checkRepo(123, 'joomla'),
			$this->equalTo(false)
		);
	}

	/**
	 * @covers JGithubPackageOrgsTeams::checkRepo
	 *
	 * @expectedException UnexpectedValueException
	 */
	public function testCheckRepoUnexpected()
	{
		$this->response->code = 666;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/teams/123/repos/joomla')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->checkRepo(123, 'joomla'),
			$this->equalTo(true)
		);
	}

	/**
	 * @covers JGithubPackageOrgsTeams::addRepo
	 */
	public function testAddRepo()
	{
		$this->response->code = 204;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('put')
			->with('/teams/123/repos/joomla/joomla-platform')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->addRepo(123, 'joomla', 'joomla-platform'),
			$this->equalTo(json_decode($this->sampleString))
		);
	}

	/**
	 * @covers JGithubPackageOrgsTeams::removeRepo
	 */
	public function testRemoveRepo()
	{
		$this->response->code = 204;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('delete')
			->with('/teams/123/repos/joomla/joomla-platform')
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->removeRepo(123, 'joomla', 'joomla-platform'),
			$this->equalTo(json_decode($this->sampleString))
		);
	}
}
