<?php

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.0 on 2013-01-30 at 01:41:06.
 */
class JGithubPackageDataCommitsTest extends \PHPUnit\Framework\TestCase
{
	/**
	 * @var    JRegistry  Options for the GitHub object.
	 * @since  2.5.0
	 */
	protected $options;

	/**
	 * @var    JGithubHttp  Mock client object.
	 * @since  2.5.0
	 */
	protected $client;

	/**
	 * @var    JHttpResponse  Mock response object.
	 * @since  3.1.4
	 */
	protected $response;

	/**
	 * @var JGithubPackageDataCommits
	 */
	protected $object;

	/**
	 * @var    string  Sample JSON string.
	 * @since  3.1.4
	 */
	protected $sampleString = '{"a":1,"b":2,"c":3,"d":4,"e":5}';

	/**
	 * @var    string  Sample JSON error message.
	 * @since  3.1.4
	 */
	protected $errorString = '{"message": "Generic Error"}';

	/**
	 * Sets up the fixture, for example, opens a network connection.
	 * This method is called before a test is executed.
	 */
	protected function setUp()
	{
		parent::setUp();

		$this->options = new JRegistry;
		$this->client = $this->getMockBuilder('JGithubHttp')->setMethods(array('get', 'post', 'delete', 'patch', 'put'))->getMock();
		$this->response = $this->getMockBuilder('JHttpResponse')->getMock();

		$this->object = new JGithubPackageDataCommits($this->options, $this->client);
	}

	/**
	 * @covers JGithubPackageDataCommits::get
	 *
	 * GET /repos/:owner/:repo/git/commits/:sha
	 *
	 * Response
	 *
	 * Status: 200 OK
	 * X-RateLimit-Limit: 5000
	 * X-RateLimit-Remaining: 4999
	 */
	public function testGet()
	{
		$this->response->code = 200;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('get')
			->with('/repos/joomla/joomla-platform/git/commits/12345', 0, 0)
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->get('joomla', 'joomla-platform', '12345'),
			$this->equalTo(json_decode($this->response->body))
		);
	}

	/**
	 * @covers JGithubPackageDataCommits::create
	 *
	 * POST /repos/:owner/:repo/git/commits
	 *
	 * Parameters
	 *
	 * message
	 * String of the commit message
	 * tree
	 * String of the SHA of the tree object this commit points to
	 * parents
	 * Array of the SHAs of the commits that were the parents of this commit. If omitted or empty, the commit will be
	 * written as a root commit. For a single parent, an array of one SHA should be provided, for a merge commit, an
	 * array of more than one should be provided.
	 *
	 * Optional Parameters
	 *
	 * The committer section is optional and will be filled with the author data if omitted. If the author section is
	 * omitted, it will be filled in with the authenticated user’s information and the current date.
	 *
	 * author.name
	 * String of the name of the author of the commit
	 * author.email
	 * String of the email of the author of the commit
	 * author.date
	 * Timestamp of when this commit was authored
	 * committer.name
	 * String of the name of the committer of the commit
	 * committer.email
	 * String of the email of the committer of the commit
	 * committer.date
	 * Timestamp of when this commit was committed
	 *
	 * Example Input
	 *
	 * {
	 * "message": "my commit message",
	 * "author": {
	 * "name": "Scott Chacon",
	 * "email": "schacon@gmail.com",
	 * "date": "2008-07-09T16:13:30+12:00"
	 * },
	 * "parents": [
	 * "7d1b31e74ee336d15cbd21741bc88a537ed063a0"
	 * ],
	 * "tree": "827efc6d56897b048c772eb4087f854f46256132"
	 * }
	 *
	 * Response
	 *
	 * Status: 201 Created
	 * Location: https://api.github.com/git/:owner/:repo/commit/:sha
	 * X-RateLimit-Limit: 5000
	 * X-RateLimit-Remaining: 4999
	 */
	public function testCreate()
	{
		$this->response->code = 201;
		$this->response->body = $this->sampleString;

		$this->client->expects($this->once())
			->method('post')
			->with('/repos/joomla/joomla-platform/git/commits', '{"message":"My Message","tree":"12345","parents":[]}', 0, 0)
			->will($this->returnValue($this->response));

		$this->assertThat(
			$this->object->create('joomla', 'joomla-platform', 'My Message', '12345'),
			$this->equalTo(json_decode($this->response->body))
		);
	}
}
