<?php
/**
 * @package     Joomla.UnitTest
 * @subpackage  Component
 *
 * @copyright   (C) 2016 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

/**
 * Mock Menu class for JComponentRouterRulesMenu class
 *
 * @package     Joomla.UnitTest
 * @subpackage  Component
 * @since       3.4
 */
class MockJComponentRouterRulesMenuMenuObject
{
	/**
	 * Menuitems
	 *
	 * @var array
	 */
	protected $items = array();

	/**
	 * Active menuitem
	 *
	 * @var integer
	 */
	public $active = 49;

	/**
	 * Constructor for this object
	 *
	 * @since 3.4
	 */
	public function __construct()
	{
		$this->items[47] = (object) array(
			'id'           => '47',
			'menutype'     => 'testmenu',
			'title'        => 'Content Home',
			'alias'        => 'content-home',
			'route'        => 'content-home',
			'link'         => 'index.php?option=com_content&view=featured',
			'type'         => 'component',
			'level'        => '1',
			'language'     => '*',
			'component_id' => '22',
			'component'    => 'com_content',
			'parent_id'    => '0',
			'query'        => array('option' => 'com_content', 'view' => 'featured'));

		$this->items[48] = (object) array(
			'id'           => '48',
			'menutype'     => 'testmenu',
			'title'        => 'Categories View',
			'alias'        => 'categories',
			'route'        => 'content-home/categories',
			'link'         => 'index.php?option=com_content&view=categories&id=14',
			'type'         => 'component',
			'level'        => '2',
			'language'     => '*',
			'component_id' => '22',
			'component'    => 'com_content',
			'parent_id'    => '47',
			'query'        => array('option' => 'com_content', 'view' => 'categories', 'id' => '14'));

		$this->items[49] = (object) array(
			'id'           => '49',
			'menutype'     => 'testmenu',
			'title'        => 'Category View',
			'alias'        => 'category-view',
			'route'        => 'category-view',
			'link'         => 'index.php?option=com_content&view=category&id=20',
			'type'         => 'component',
			'level'        => '1',
			'language'     => '*',
			'component_id' => '22',
			'component'    => 'com_content',
			'parent_id'    => '47',
			'query'        => array('option' => 'com_content', 'view' => 'category', 'id' => '20'));

		$this->items[50] = (object) array(
			'id'           => '50',
			'menutype'     => 'testmenu',
			'title'        => 'Categories View',
			'alias'        => 'categories',
			'route'        => 'content-home/categories',
			'link'         => 'index.php?option=com_content&view=categories&id=14',
			'type'         => 'component',
			'level'        => '2',
			'language'     => 'en-GB',
			'component_id' => '22',
			'component'    => 'com_content',
			'parent_id'    => '47',
			'query'        => array('option' => 'com_content', 'view' => 'categories', 'id' => '14'));

		$this->items[51] = (object) array(
			'id'           => '51',
			'menutype'     => 'testmenu',
			'title'        => 'Content Home',
			'alias'        => 'content-home',
			'route'        => 'content-home',
			'link'         => 'index.php?option=com_content&view=featured',
			'type'         => 'component',
			'level'        => '1',
			'language'     => 'en-GB',
			'component_id' => '22',
			'component'    => 'com_content',
			'parent_id'    => '0',
			'query'        => array('option' => 'com_content', 'view' => 'featured'));

		$this->items[52] = (object) array(
			'id'           => '52',
			'menutype'     => 'testmenu',
			'title'        => 'Content Article',
			'alias'        => 'content-article',
			'route'        => 'content-article',
			'link'         => 'index.php?option=com_content&view=article&id=1',
			'type'         => 'component',
			'level'        => '1',
			'language'     => '*',
			'component_id' => '22',
			'component'    => 'com_content',
			'parent_id'    => '0',
			'query'        => array('option' => 'com_content', 'view' => 'article', 'id' => '1'));

		$this->items[53] = (object) array(
			'id'           => '53',
			'menutype'     => 'testmenu',
			'title'        => 'Content Article (2)',
			'alias'        => 'content-article-2',
			'route'        => 'content-article-2',
			'link'         => 'index.php?option=com_content&view=article&id=1',
			'type'         => 'component',
			'level'        => '1',
			'language'     => '*',
			'component_id' => '22',
			'component'    => 'com_content',
			'parent_id'    => '0',
			'query'        => array('option' => 'com_content', 'view' => 'article', 'id' => '1'));
	}

	/**
	 * Gets the menu item set that fits the search array
	 *
	 * @param   array   $attributes  Search criteria
	 * @param   array   $values      Search criteria
	 *
	 * @return  mixed  Menu items
	 *
	 * @since   3.4
	 */
	public function getItems($attributes, $values)
	{
		$items = array();
		$attributes = (array) $attributes;
		$values = (array) $values;

		foreach ($this->items as $item)
		{
			$test = true;

			for ($i = 0, $count = count($attributes); $i < $count; $i++)
			{
				if (is_array($values[$i]))
				{
					if (!in_array($item->{$attributes[$i]}, $values[$i]))
					{
						$test = false;
						break;
					}
				}
				else
				{
					if ($item->{$attributes[$i]} != $values[$i])
					{
						$test = false;
						break;
					}
				}
			}

			if ($test)
			{
				$items[] = $item;
			}
		}

		return $items;
	}

	/**
	 * Return the currently active menuitem
	 *
	 * @return  object  Menuitem
	 * @since 3.4
	 */
	public function getActive()
	{
		return (isset($this->items[$this->active]) ? $this->items[$this->active] : null);
	}

	/**
	 * Return the default menuitem for the language
	 *
	 * @param   string  $language  Language for the default
	 *
	 * @return  object  Menuitem
	 * @since 3.4
	 */
	public function getDefault($language = '*')
	{
		if ($language == '*')
		{
			return $this->items[47];
		}

		if ($language == 'en-GB')
		{
			return $this->items[51];
		}
	}
}
